package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Base class of scene nodes that can be aggregated by Qt3DCore::QEntity instances as a component</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qt3dcore-qcomponent.html">Qt3DCore::QComponent</a></p>
 */
public class QComponent extends io.qt.qt3d.core.QNode
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QComponent.class);
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qcomponent.html#addedToEntity">Qt3DCore::QComponent::addedToEntity(Qt3DCore::QEntity*)</a></p>
     */
    public final @NonNull Signal1<io.qt.qt3d.core.@Nullable QEntity> addedToEntity = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qcomponent.html#removedFromEntity">Qt3DCore::QComponent::removedFromEntity(Qt3DCore::QEntity*)</a></p>
     */
    public final @NonNull Signal1<io.qt.qt3d.core.@Nullable QEntity> removedFromEntity = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qcomponent.html#isShareable-prop">Qt3DCore::QComponent::shareableChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="isShareable")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> shareableChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QComponent() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qcomponent.html#QComponent">Qt3DCore::QComponent::QComponent(Qt3DCore::QNode*)</a></p>
     */
    public QComponent(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QComponent instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qcomponent.html#entities">Qt3DCore::QComponent::entities()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QVector<io.qt.qt3d.core.@Nullable QEntity> entities(){
        return entities_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QVector<io.qt.qt3d.core.QEntity> entities_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qcomponent.html#isShareable-prop">Qt3DCore::QComponent::isShareable()const</a></p>
     */
    @QtPropertyReader(name="isShareable")
    @QtUninvokable
    public final boolean isShareable(){
        return isShareable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isShareable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qcomponent.html#isShareable-prop">Qt3DCore::QComponent::setShareable(bool)</a></p>
     */
    @QtPropertyWriter(name="isShareable")
    public final void setShareable(boolean isShareable){
        setShareable_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), isShareable);
    }
    
    private native void setShareable_native_bool(long __this__nativeId, boolean isShareable);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QComponent(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QComponent(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QComponent instance, QDeclarativeConstructor constructor);
    
}
