package io.qt.qt3d.core;

import io.qt.*;


/**
 * <p>Base class for jobs executed in an aspect</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qt3dcore-qaspectjob.html">Qt3DCore::QAspectJob</a></p>
 */
public abstract class QAspectJob extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @NativeAccess
    private static final class ConcreteWrapper extends QAspectJob {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        public void run(){
            run_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native void run_native(long __this__nativeId);
        
    }
    
    
    public QAspectJob(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QAspectJob instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qaspectjob.html#addDependency">Qt3DCore::QAspectJob::addDependency(QWeakPointer&lt;Qt3DCore::QAspectJob&gt;)</a></p>
     */
    @QtUninvokable
    public final void addDependency(io.qt.qt3d.core.@Nullable QAspectJob dependency){
        addDependency_native_QWeakPointer(QtJambi_LibraryUtilities.internal.nativeId(this), dependency);
    }
    
    @QtUninvokable
    private native void addDependency_native_QWeakPointer(long __this__nativeId, io.qt.qt3d.core.QAspectJob dependency);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qaspectjob.html#dependencies">Qt3DCore::QAspectJob::dependencies()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QVector<io.qt.qt3d.core.@Nullable QAspectJob> dependencies(){
        return dependencies_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QVector<io.qt.qt3d.core.QAspectJob> dependencies_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qaspectjob.html#removeDependency">Qt3DCore::QAspectJob::removeDependency(QWeakPointer&lt;Qt3DCore::QAspectJob&gt;)</a></p>
     */
    @QtUninvokable
    public final void removeDependency(io.qt.qt3d.core.@Nullable QAspectJob dependency){
        removeDependency_native_QWeakPointer(QtJambi_LibraryUtilities.internal.nativeId(this), dependency);
    }
    
    @QtUninvokable
    private native void removeDependency_native_QWeakPointer(long __this__nativeId, io.qt.qt3d.core.QAspectJob dependency);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qaspectjob.html#run">Qt3DCore::QAspectJob::run()</a></p>
     */
    @QtUninvokable
    public abstract void run();
    
    @QtUninvokable
    private native void run_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QAspectJob(QPrivateConstructor p) { super(p); } 
    
}
