package io.qt.qt3d.core;


/**
 * <p>Base class for all Qt3D backend nodes</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qt3dcore-qbackendnode.html">Qt3DCore::QBackendNode</a></p>
 */
public class QBackendNode extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3dcore-qbackendnode.html#Mode-enum">Qt3DCore::QBackendNode::Mode</a></p>
     */
    public enum Mode implements io.qt.QtEnumerator {
        ReadOnly(0),
        ReadWrite(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Mode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Mode resolve(int value) {
            switch (value) {
            case 0: return ReadOnly;
            case 1: return ReadWrite;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #QBackendNode(io.qt.qt3d.core.QBackendNode.Mode)}
     *  with <code>mode = io.qt.qt3d.core.QBackendNode.Mode.ReadOnly</code>.</p>
     */
    public QBackendNode() {
        this(io.qt.qt3d.core.QBackendNode.Mode.ReadOnly);
    }
    
    public QBackendNode(io.qt.qt3d.core.QBackendNode.Mode mode){
        super((QPrivateConstructor)null);
        initialize_native(this, mode);
    }
    
    private native static void initialize_native(QBackendNode instance, io.qt.qt3d.core.QBackendNode.Mode mode);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qbackendnode.html#isEnabled">Qt3DCore::QBackendNode::isEnabled()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isEnabled(){
        return isEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qbackendnode.html#mode">Qt3DCore::QBackendNode::mode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qt3d.core.QBackendNode.Mode mode(){
        return io.qt.qt3d.core.QBackendNode.Mode.resolve(mode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int mode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qbackendnode-obsolete.html#notifyObservers">Qt3DCore::QBackendNode::notifyObservers(Qt3DCore::QSceneChangePtr)</a></p>
     */
    @Deprecated
    @io.qt.QtUninvokable
    protected final void notifyObservers(io.qt.qt3d.core.QSceneChange e){
        notifyObservers_native_cref_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), e);
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native void notifyObservers_native_cref_QSharedPointer(long __this__nativeId, io.qt.qt3d.core.QSceneChange e);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qbackendnode.html#peerId">Qt3DCore::QBackendNode::peerId()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qt3d.core.QNodeId peerId(){
        return peerId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.core.QNodeId peerId_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #sendCommand(java.lang.String, java.lang.Object, int)}
     *  with <code>replyTo = 0</code>.</p>
     */
    @Deprecated
    @io.qt.QtUninvokable
    protected final int sendCommand(java.lang.String name, java.lang.Object data) {
        return sendCommand(name, data, (int)0);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qbackendnode-obsolete.html#sendCommand">Qt3DCore::QBackendNode::sendCommand(QString,QVariant,Qt3DCore::QNodeCommand::CommandId)</a></p>
     */
    @Deprecated
    @io.qt.QtUninvokable
    protected final int sendCommand(java.lang.String name, java.lang.Object data, int replyTo){
        return sendCommand_native_cref_QString_cref_QVariant_unsigned_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, data, replyTo);
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native int sendCommand_native_cref_QString_cref_QVariant_unsigned_int(long __this__nativeId, java.lang.String name, java.lang.Object data, int replyTo);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qbackendnode-obsolete.html#sendReply">Qt3DCore::QBackendNode::sendReply(Qt3DCore::QNodeCommandPtr)</a></p>
     */
    @Deprecated
    @io.qt.QtUninvokable
    protected final void sendReply(io.qt.qt3d.core.QNodeCommand command){
        sendReply_native_cref_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), command);
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native void sendReply_native_cref_QSharedPointer(long __this__nativeId, io.qt.qt3d.core.QNodeCommand command);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qbackendnode.html#setEnabled">Qt3DCore::QBackendNode::setEnabled(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setEnabled(boolean enabled){
        setEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @io.qt.QtUninvokable
    private native void setEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qbackendnode-obsolete.html#sceneChangeEvent">Qt3DCore::QBackendNode::sceneChangeEvent(Qt3DCore::QSceneChangePtr)</a></p>
     */
    @Deprecated
    @io.qt.QtUninvokable
    protected void sceneChangeEvent(io.qt.qt3d.core.QSceneChange e){
        sceneChangeEvent_native_cref_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), e);
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native void sceneChangeEvent_native_cref_QSharedPointer(long __this__nativeId, io.qt.qt3d.core.QSceneChange e);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QBackendNode(QPrivateConstructor p) { super(p); } 
    
}
