package io.qt.qt3d.core;


/**
 * <p>Responsible for handling all the QAbstractAspect subclasses that have been registered with the scene</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qt3dcore-qaspectengine.html">Qt3DCore::QAspectEngine</a></p>
 */
public class QAspectEngine extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAspectEngine.class);
    
    /**
     * <p>Java wrapper for Qt enum Qt3DCore::QAspectEngine::RunMode</p>
     */
    public enum RunMode implements io.qt.QtEnumerator {
        Manual(0),
        Automatic(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private RunMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static RunMode resolve(int value) {
            switch (value) {
            case 0: return Manual;
            case 1: return Automatic;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #QAspectEngine(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAspectEngine() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qaspectengine.html#QAspectEngine">Qt3DCore::QAspectEngine::QAspectEngine(QObject*)</a></p>
     */
    public QAspectEngine(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAspectEngine instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qaspectengine.html#aspects">Qt3DCore::QAspectEngine::aspects()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QVector<io.qt.qt3d.core.QAbstractAspect> aspects(){
        return aspects_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QVector<io.qt.qt3d.core.QAbstractAspect> aspects_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qaspectengine.html#executeCommand">Qt3DCore::QAspectEngine::executeCommand(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object executeCommand(java.lang.String command){
        return executeCommand_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), command);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object executeCommand_native_cref_QString(long __this__nativeId, java.lang.String command);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qaspectengine.html#processFrame">Qt3DCore::QAspectEngine::processFrame()</a></p>
     */
    @io.qt.QtUninvokable
    public final void processFrame(){
        processFrame_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void processFrame_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qaspectengine.html#registerAspect">Qt3DCore::QAspectEngine::registerAspect(Qt3DCore::QAbstractAspect*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void registerAspect(io.qt.qt3d.core.QAbstractAspect aspect){
        registerAspect_native_Qt3DCore_QAbstractAspect_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(aspect));
    }
    
    @io.qt.QtUninvokable
    private native void registerAspect_native_Qt3DCore_QAbstractAspect_ptr(long __this__nativeId, long aspect);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qaspectengine.html#registerAspect-1">Qt3DCore::QAspectEngine::registerAspect(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void registerAspect(java.lang.String name){
        registerAspect_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native void registerAspect_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qaspectengine.html#rootEntity">Qt3DCore::QAspectEngine::rootEntity()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qt3d.core.QEntity rootEntity(){
        return rootEntity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.core.QEntity rootEntity_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.qt3d.core.QAspectEngine.RunMode runMode(){
        return io.qt.qt3d.core.QAspectEngine.RunMode.resolve(runMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int runMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qaspectengine.html#setRootEntity">Qt3DCore::QAspectEngine::setRootEntity(Qt3DCore::QEntityPtr)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setRootEntity(io.qt.qt3d.core.QEntity root){
        setRootEntity_native_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), root);
    }
    
    @io.qt.QtUninvokable
    private native void setRootEntity_native_QSharedPointer(long __this__nativeId, io.qt.qt3d.core.QEntity root);
    
    @io.qt.QtUninvokable
    public final void setRunMode(io.qt.qt3d.core.QAspectEngine.RunMode mode){
        setRunMode_native_Qt3DCore_QAspectEngine_RunMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @io.qt.QtUninvokable
    private native void setRunMode_native_Qt3DCore_QAspectEngine_RunMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qaspectengine.html#unregisterAspect">Qt3DCore::QAspectEngine::unregisterAspect(Qt3DCore::QAbstractAspect*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void unregisterAspect(io.qt.qt3d.core.QAbstractAspect aspect){
        unregisterAspect_native_Qt3DCore_QAbstractAspect_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(aspect));
    }
    
    @io.qt.QtUninvokable
    private native void unregisterAspect_native_Qt3DCore_QAbstractAspect_ptr(long __this__nativeId, long aspect);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qaspectengine.html#unregisterAspect-1">Qt3DCore::QAspectEngine::unregisterAspect(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void unregisterAspect(java.lang.String name){
        unregisterAspect_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native void unregisterAspect_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAspectEngine(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QAspectEngine(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QAspectEngine instance, QDeclarativeConstructor constructor);
    
}
