package io.qt.qt3d.animation;


/**
 * <p>A class implementing vertex-blend morphing animation</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3danimation-qvertexblendanimation.html">Qt3DAnimation::QVertexBlendAnimation</a></p>
 */
public class QVertexBlendAnimation extends io.qt.qt3d.animation.QAbstractAnimation
{
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcTarget = null;
    @io.qt.QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcMorphTarget;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QVertexBlendAnimation.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qvertexblendanimation.html#interpolator-prop">Qt3DAnimation::QVertexBlendAnimation::interpolatorChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="interpolator")
    public final Signal1<@io.qt.QtPrimitiveType Float> interpolatorChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qvertexblendanimation.html#target-prop">Qt3DAnimation::QVertexBlendAnimation::targetChanged(Qt3DRender::QGeometryRenderer*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtPropertyNotify(name="target")
    public final Signal1<io.qt.qt3d.render.QGeometryRenderer> targetChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qvertexblendanimation.html#targetName-prop">Qt3DAnimation::QVertexBlendAnimation::targetNameChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="targetName")
    public final Signal1<java.lang.String> targetNameChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qvertexblendanimation.html#targetPositions-prop">Qt3DAnimation::QVertexBlendAnimation::targetPositionsChanged(QList&lt;float&gt;)</a></p>
     */
    @io.qt.QtPropertyNotify(name="targetPositions")
    public final Signal1<java.util.List<java.lang.Float>> targetPositionsChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QVertexBlendAnimation(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QVertexBlendAnimation() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qvertexblendanimation.html#QVertexBlendAnimation">Qt3DAnimation::QVertexBlendAnimation::QVertexBlendAnimation(QObject*)</a></p>
     */
    public QVertexBlendAnimation(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QVertexBlendAnimation instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qvertexblendanimation.html#addMorphTarget">Qt3DAnimation::QVertexBlendAnimation::addMorphTarget(Qt3DAnimation::QMorphTarget*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addMorphTarget(io.qt.qt3d.animation.QMorphTarget target){
        addMorphTarget_native_Qt3DAnimation_QMorphTarget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(target));
        if (target != null) {
            if(__rcMorphTarget==null)
                __rcMorphTarget = QtJambi_LibraryUtilities.internal.newRCList();
            __rcMorphTarget.add(target);
        }
    }
    
    @io.qt.QtUninvokable
    private native void addMorphTarget_native_Qt3DAnimation_QMorphTarget_ptr(long __this__nativeId, long target);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qvertexblendanimation.html#interpolator-prop">Qt3DAnimation::QVertexBlendAnimation::interpolator()const</a></p>
     */
    @io.qt.QtPropertyReader(name="interpolator")
    @io.qt.QtUninvokable
    public final float interpolator(){
        return interpolator_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float interpolator_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qvertexblendanimation.html#morphTargetList">Qt3DAnimation::QVertexBlendAnimation::morphTargetList()</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.qt3d.animation.QMorphTarget> morphTargetList(){
        return morphTargetList_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.animation.QMorphTarget> morphTargetList_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qvertexblendanimation.html#removeMorphTarget">Qt3DAnimation::QVertexBlendAnimation::removeMorphTarget(Qt3DAnimation::QMorphTarget*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeMorphTarget(io.qt.qt3d.animation.QMorphTarget target){
        removeMorphTarget_native_Qt3DAnimation_QMorphTarget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(target));
        if (target != null) {
            while (__rcMorphTarget != null && __rcMorphTarget.remove(target)) ;
        }
    }
    
    @io.qt.QtUninvokable
    private native void removeMorphTarget_native_Qt3DAnimation_QMorphTarget_ptr(long __this__nativeId, long target);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qvertexblendanimation.html#setMorphTargets">Qt3DAnimation::QVertexBlendAnimation::setMorphTargets(QList&lt;Qt3DAnimation::QMorphTarget*&gt;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setMorphTargets(java.util.Collection<io.qt.qt3d.animation.QMorphTarget> targets){
        setMorphTargets_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), targets);
        if(__rcMorphTarget!=null){
            __rcMorphTarget.clear();
        }else{
            __rcMorphTarget = new java.util.ArrayList<>();
        }
        __rcMorphTarget.addAll(targets);
    }
    
    @io.qt.QtUninvokable
    private native void setMorphTargets_native_cref_QList(long __this__nativeId, java.util.Collection<io.qt.qt3d.animation.QMorphTarget> targets);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qvertexblendanimation.html#target-prop">Qt3DAnimation::QVertexBlendAnimation::setTarget(Qt3DRender::QGeometryRenderer*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="target")
    @SuppressWarnings({"exports"})
    public final void setTarget(io.qt.qt3d.render.QGeometryRenderer target){
        setTarget_native_Qt3DRender_QGeometryRenderer_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(target));
        __rcTarget = target;
    }
    
    private native void setTarget_native_Qt3DRender_QGeometryRenderer_ptr(long __this__nativeId, long target);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qvertexblendanimation.html#targetName-prop">Qt3DAnimation::QVertexBlendAnimation::setTargetName(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="targetName")
    public final void setTargetName(java.lang.String name){
        setTargetName_native_const_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native void setTargetName_native_const_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qvertexblendanimation.html#targetPositions-prop">Qt3DAnimation::QVertexBlendAnimation::setTargetPositions(QList&lt;float&gt;)</a></p>
     */
    @io.qt.QtPropertyWriter(name="targetPositions")
    public final void setTargetPositions(java.util.Collection<java.lang.Float> targetPositions){
        setTargetPositions_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), targetPositions);
    }
    
    private native void setTargetPositions_native_cref_QList(long __this__nativeId, java.util.Collection<java.lang.Float> targetPositions);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qvertexblendanimation.html#target-prop">Qt3DAnimation::QVertexBlendAnimation::target()const</a></p>
     */
    @io.qt.QtPropertyReader(name="target")
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QGeometryRenderer target(){
        return target_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.render.QGeometryRenderer target_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qvertexblendanimation.html#targetName-prop">Qt3DAnimation::QVertexBlendAnimation::targetName()const</a></p>
     */
    @io.qt.QtPropertyReader(name="targetName")
    @io.qt.QtUninvokable
    public final java.lang.String targetName(){
        return targetName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String targetName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qvertexblendanimation.html#targetPositions-prop">Qt3DAnimation::QVertexBlendAnimation::targetPositions()const</a></p>
     */
    @io.qt.QtPropertyReader(name="targetPositions")
    @io.qt.QtUninvokable
    public final io.qt.core.QList<java.lang.Float> targetPositions(){
        return targetPositions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<java.lang.Float> targetPositions_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QVertexBlendAnimation(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QVertexBlendAnimation(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QVertexBlendAnimation instance, QDeclarativeConstructor constructor);
    
}
