package io.qt.qt3d.animation;


/**
 * <p>A class providing morph targets to blend-shape animation</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3danimation-qmorphtarget.html">Qt3DAnimation::QMorphTarget</a></p>
 */
public class QMorphTarget extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcAttribute;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QMorphTarget.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphtarget.html#attributeNames-prop">Qt3DAnimation::QMorphTarget::attributeNamesChanged(QStringList)</a></p>
     */
    @io.qt.QtPropertyNotify(name="attributeNames")
    public final Signal1<java.util.List<java.lang.String>> attributeNamesChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QMorphTarget(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QMorphTarget() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphtarget.html#QMorphTarget">Qt3DAnimation::QMorphTarget::QMorphTarget(QObject*)</a></p>
     */
    public QMorphTarget(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QMorphTarget instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphtarget.html#addAttribute">Qt3DAnimation::QMorphTarget::addAttribute(Qt3DCore::QAttribute*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void addAttribute(io.qt.qt3d.core.QAttribute attribute){
        addAttribute_native_Qt3DCore_QAttribute_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(attribute));
        if (attribute != null) {
            if(__rcAttribute==null)
                __rcAttribute = QtJambi_LibraryUtilities.internal.newRCList();
            __rcAttribute.add(attribute);
        }
    }
    
    @io.qt.QtUninvokable
    private native void addAttribute_native_Qt3DCore_QAttribute_ptr(long __this__nativeId, long attribute);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphtarget.html#attributeList">Qt3DAnimation::QMorphTarget::attributeList()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.qt3d.core.QAttribute> attributeList(){
        return attributeList_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.core.QAttribute> attributeList_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphtarget.html#attributeNames-prop">Qt3DAnimation::QMorphTarget::attributeNames()const</a></p>
     */
    @io.qt.QtPropertyReader(name="attributeNames")
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList attributeNames(){
        return attributeNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList attributeNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphtarget.html#removeAttribute">Qt3DAnimation::QMorphTarget::removeAttribute(Qt3DCore::QAttribute*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void removeAttribute(io.qt.qt3d.core.QAttribute attribute){
        removeAttribute_native_Qt3DCore_QAttribute_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(attribute));
        if (attribute != null) {
            while (__rcAttribute != null && __rcAttribute.remove(attribute)) ;
        }
    }
    
    @io.qt.QtUninvokable
    private native void removeAttribute_native_Qt3DCore_QAttribute_ptr(long __this__nativeId, long attribute);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphtarget.html#setAttributes">Qt3DAnimation::QMorphTarget::setAttributes(QList&lt;Qt3DCore::QAttribute*&gt;)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void setAttributes(java.util.Collection<io.qt.qt3d.core.QAttribute> attributes){
        setAttributes_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), attributes);
        if(__rcAttribute!=null){
            __rcAttribute.clear();
        }else{
            __rcAttribute = new java.util.ArrayList<>();
        }
        __rcAttribute.addAll(attributes);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributes_native_cref_QList(long __this__nativeId, java.util.Collection<io.qt.qt3d.core.QAttribute> attributes);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphtarget.html#fromGeometry">Qt3DAnimation::QMorphTarget::fromGeometry(Qt3DCore::QGeometry*,QStringList)</a></p>
     */
    @SuppressWarnings({"exports"})
    public static io.qt.qt3d.animation.QMorphTarget fromGeometry(io.qt.qt3d.core.QGeometry geometry, java.util.Collection<java.lang.String> attributes){
        return fromGeometry_native_Qt3DCore_QGeometry_ptr_cref_QStringList(QtJambi_LibraryUtilities.internal.checkedNativeId(geometry), attributes);
    }
    
    private native static io.qt.qt3d.animation.QMorphTarget fromGeometry_native_Qt3DCore_QGeometry_ptr_cref_QStringList(long geometry, java.util.Collection<java.lang.String> attributes);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QMorphTarget(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QMorphTarget(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QMorphTarget instance, QDeclarativeConstructor constructor);
    
}
