package io.qt.qt3d.animation;


/**
 * <p>A controller class for animations</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html">Qt3DAnimation::QAnimationController</a></p>
 */
public class QAnimationController extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcAnimationGroup;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAnimationController.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#activeAnimationGroup-prop">Qt3DAnimation::QAnimationController::activeAnimationGroupChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="activeAnimationGroup")
    public final Signal1<@io.qt.QtPrimitiveType Integer> activeAnimationGroupChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#entity-prop">Qt3DAnimation::QAnimationController::entityChanged(Qt3DCore::QEntity*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtPropertyNotify(name="entity")
    public final Signal1<io.qt.qt3d.core.QEntity> entityChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#position-prop">Qt3DAnimation::QAnimationController::positionChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="position")
    public final Signal1<@io.qt.QtPrimitiveType Float> positionChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#positionOffset-prop">Qt3DAnimation::QAnimationController::positionOffsetChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="positionOffset")
    public final Signal1<@io.qt.QtPrimitiveType Float> positionOffsetChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#positionScale-prop">Qt3DAnimation::QAnimationController::positionScaleChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="positionScale")
    public final Signal1<@io.qt.QtPrimitiveType Float> positionScaleChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#recursive-prop">Qt3DAnimation::QAnimationController::recursiveChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="recursive")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> recursiveChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QAnimationController(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAnimationController() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#QAnimationController">Qt3DAnimation::QAnimationController::QAnimationController(QObject*)</a></p>
     */
    public QAnimationController(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAnimationController instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#activeAnimationGroup-prop">Qt3DAnimation::QAnimationController::activeAnimationGroup()const</a></p>
     */
    @io.qt.QtPropertyReader(name="activeAnimationGroup")
    @io.qt.QtUninvokable
    public final int activeAnimationGroup(){
        return activeAnimationGroup_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int activeAnimationGroup_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#addAnimationGroup">Qt3DAnimation::QAnimationController::addAnimationGroup(Qt3DAnimation::QAnimationGroup*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addAnimationGroup(io.qt.qt3d.animation.QAnimationGroup animationGroups){
        addAnimationGroup_native_Qt3DAnimation_QAnimationGroup_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(animationGroups));
        if (animationGroups != null) {
            if(__rcAnimationGroup==null)
                __rcAnimationGroup = QtJambi_LibraryUtilities.internal.newRCList();
            __rcAnimationGroup.add(animationGroups);
        }
    }
    
    @io.qt.QtUninvokable
    private native void addAnimationGroup_native_Qt3DAnimation_QAnimationGroup_ptr(long __this__nativeId, long animationGroups);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#animationGroupList">Qt3DAnimation::QAnimationController::animationGroupList()</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.qt3d.animation.QAnimationGroup> animationGroupList(){
        return animationGroupList_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.animation.QAnimationGroup> animationGroupList_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#entity-prop">Qt3DAnimation::QAnimationController::entity()const</a></p>
     */
    @io.qt.QtPropertyReader(name="entity")
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.qt3d.core.QEntity entity(){
        return entity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.core.QEntity entity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#getAnimationIndex">Qt3DAnimation::QAnimationController::getAnimationIndex(QString)const</a></p>
     */
    public final int getAnimationIndex(java.lang.String name){
        return getAnimationIndex_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native int getAnimationIndex_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#getGroup">Qt3DAnimation::QAnimationController::getGroup(int)const</a></p>
     */
    public final io.qt.qt3d.animation.QAnimationGroup getGroup(int index){
        return getGroup_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    private native io.qt.qt3d.animation.QAnimationGroup getGroup_native_int_constfct(long __this__nativeId, int index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#position-prop">Qt3DAnimation::QAnimationController::position()const</a></p>
     */
    @io.qt.QtPropertyReader(name="position")
    @io.qt.QtUninvokable
    public final float position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float position_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#positionOffset-prop">Qt3DAnimation::QAnimationController::positionOffset()const</a></p>
     */
    @io.qt.QtPropertyReader(name="positionOffset")
    @io.qt.QtUninvokable
    public final float positionOffset(){
        return positionOffset_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float positionOffset_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#positionScale-prop">Qt3DAnimation::QAnimationController::positionScale()const</a></p>
     */
    @io.qt.QtPropertyReader(name="positionScale")
    @io.qt.QtUninvokable
    public final float positionScale(){
        return positionScale_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float positionScale_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#recursive-prop">Qt3DAnimation::QAnimationController::recursive()const</a></p>
     */
    @io.qt.QtPropertyReader(name="recursive")
    @io.qt.QtUninvokable
    public final boolean recursive(){
        return recursive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean recursive_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#removeAnimationGroup">Qt3DAnimation::QAnimationController::removeAnimationGroup(Qt3DAnimation::QAnimationGroup*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeAnimationGroup(io.qt.qt3d.animation.QAnimationGroup animationGroups){
        removeAnimationGroup_native_Qt3DAnimation_QAnimationGroup_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(animationGroups));
        if (animationGroups != null) {
            while (__rcAnimationGroup != null && __rcAnimationGroup.remove(animationGroups)) ;
        }
    }
    
    @io.qt.QtUninvokable
    private native void removeAnimationGroup_native_Qt3DAnimation_QAnimationGroup_ptr(long __this__nativeId, long animationGroups);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#activeAnimationGroup-prop">Qt3DAnimation::QAnimationController::setActiveAnimationGroup(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="activeAnimationGroup")
    public final void setActiveAnimationGroup(int index){
        setActiveAnimationGroup_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    private native void setActiveAnimationGroup_native_int(long __this__nativeId, int index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#setAnimationGroups">Qt3DAnimation::QAnimationController::setAnimationGroups(QList&lt;Qt3DAnimation::QAnimationGroup*&gt;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAnimationGroups(java.util.Collection<io.qt.qt3d.animation.QAnimationGroup> animationGroups){
        setAnimationGroups_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), animationGroups);
        if(__rcAnimationGroup!=null){
            __rcAnimationGroup.clear();
        }else{
            __rcAnimationGroup = new java.util.ArrayList<>();
        }
        __rcAnimationGroup.addAll(animationGroups);
    }
    
    @io.qt.QtUninvokable
    private native void setAnimationGroups_native_cref_QList(long __this__nativeId, java.util.Collection<io.qt.qt3d.animation.QAnimationGroup> animationGroups);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#entity-prop">Qt3DAnimation::QAnimationController::setEntity(Qt3DCore::QEntity*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="entity")
    @SuppressWarnings({"exports"})
    public final void setEntity(io.qt.qt3d.core.QEntity entity){
        setEntity_native_Qt3DCore_QEntity_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(entity));
    }
    
    private native void setEntity_native_Qt3DCore_QEntity_ptr(long __this__nativeId, long entity);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#position-prop">Qt3DAnimation::QAnimationController::setPosition(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="position")
    public final void setPosition(float position){
        setPosition_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), position);
    }
    
    private native void setPosition_native_float(long __this__nativeId, float position);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#positionOffset-prop">Qt3DAnimation::QAnimationController::setPositionOffset(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="positionOffset")
    public final void setPositionOffset(float offset){
        setPositionOffset_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), offset);
    }
    
    private native void setPositionOffset_native_float(long __this__nativeId, float offset);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#positionScale-prop">Qt3DAnimation::QAnimationController::setPositionScale(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="positionScale")
    public final void setPositionScale(float scale){
        setPositionScale_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), scale);
    }
    
    private native void setPositionScale_native_float(long __this__nativeId, float scale);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcontroller.html#recursive-prop">Qt3DAnimation::QAnimationController::setRecursive(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="recursive")
    public final void setRecursive(boolean recursive){
        setRecursive_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), recursive);
    }
    
    private native void setRecursive_native_bool(long __this__nativeId, boolean recursive);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAnimationController(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QAnimationController(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QAnimationController instance, QDeclarativeConstructor constructor);
    
}
