package io.qt.qt3d.animation;


/**
 * <p>A class implementing simple keyframe animation to a QTransform</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html">Qt3DAnimation::QKeyframeAnimation</a></p>
 */
public class QKeyframeAnimation extends io.qt.qt3d.animation.QAbstractAnimation
{
    @io.qt.QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcKeyframe;
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcTarget = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QKeyframeAnimation.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#RepeatMode-enum">Qt3DAnimation::QKeyframeAnimation::RepeatMode</a></p>
     */
    public enum RepeatMode implements io.qt.QtEnumerator {
        None(0),
        Constant(1),
        Repeat(2);

        private RepeatMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static RepeatMode resolve(int value) {
            switch (value) {
            case 0: return None;
            case 1: return Constant;
            case 2: return Repeat;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#easing-prop">Qt3DAnimation::QKeyframeAnimation::easingChanged(QEasingCurve)</a></p>
     */
    @io.qt.QtPropertyNotify(name="easing")
    public final Signal1<io.qt.core.QEasingCurve> easingChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#endMode-prop">Qt3DAnimation::QKeyframeAnimation::endModeChanged(Qt3DAnimation::QKeyframeAnimation::RepeatMode)</a></p>
     */
    @io.qt.QtPropertyNotify(name="endMode")
    public final Signal1<io.qt.qt3d.animation.QKeyframeAnimation.RepeatMode> endModeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#framePositions-prop">Qt3DAnimation::QKeyframeAnimation::framePositionsChanged(QList&lt;float&gt;)</a></p>
     */
    @io.qt.QtPropertyNotify(name="framePositions")
    public final Signal1<java.util.List<java.lang.Float>> framePositionsChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#startMode-prop">Qt3DAnimation::QKeyframeAnimation::startModeChanged(Qt3DAnimation::QKeyframeAnimation::RepeatMode)</a></p>
     */
    @io.qt.QtPropertyNotify(name="startMode")
    public final Signal1<io.qt.qt3d.animation.QKeyframeAnimation.RepeatMode> startModeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#target-prop">Qt3DAnimation::QKeyframeAnimation::targetChanged(Qt3DCore::QTransform*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtPropertyNotify(name="target")
    public final Signal1<io.qt.qt3d.core.QTransform> targetChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#targetName-prop">Qt3DAnimation::QKeyframeAnimation::targetNameChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="targetName")
    public final Signal1<java.lang.String> targetNameChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QKeyframeAnimation(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QKeyframeAnimation() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#QKeyframeAnimation">Qt3DAnimation::QKeyframeAnimation::QKeyframeAnimation(QObject*)</a></p>
     */
    public QKeyframeAnimation(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QKeyframeAnimation instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#addKeyframe">Qt3DAnimation::QKeyframeAnimation::addKeyframe(Qt3DCore::QTransform*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void addKeyframe(io.qt.qt3d.core.QTransform keyframe){
        addKeyframe_native_Qt3DCore_QTransform_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(keyframe));
        if (keyframe != null) {
            if(__rcKeyframe==null)
                __rcKeyframe = QtJambi_LibraryUtilities.internal.newRCList();
            __rcKeyframe.add(keyframe);
        }
    }
    
    @io.qt.QtUninvokable
    private native void addKeyframe_native_Qt3DCore_QTransform_ptr(long __this__nativeId, long keyframe);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#easing-prop">Qt3DAnimation::QKeyframeAnimation::easing()const</a></p>
     */
    @io.qt.QtPropertyReader(name="easing")
    @io.qt.QtUninvokable
    public final io.qt.core.QEasingCurve easing(){
        return easing_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QEasingCurve easing_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#endMode-prop">Qt3DAnimation::QKeyframeAnimation::endMode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="endMode")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.animation.QKeyframeAnimation.RepeatMode endMode(){
        return io.qt.qt3d.animation.QKeyframeAnimation.RepeatMode.resolve(endMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int endMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#framePositions-prop">Qt3DAnimation::QKeyframeAnimation::framePositions()const</a></p>
     */
    @io.qt.QtPropertyReader(name="framePositions")
    @io.qt.QtUninvokable
    public final io.qt.core.QList<java.lang.Float> framePositions(){
        return framePositions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<java.lang.Float> framePositions_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#keyframeList">Qt3DAnimation::QKeyframeAnimation::keyframeList()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.qt3d.core.QTransform> keyframeList(){
        return keyframeList_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.core.QTransform> keyframeList_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#removeKeyframe">Qt3DAnimation::QKeyframeAnimation::removeKeyframe(Qt3DCore::QTransform*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void removeKeyframe(io.qt.qt3d.core.QTransform keyframe){
        removeKeyframe_native_Qt3DCore_QTransform_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(keyframe));
        if (keyframe != null) {
            while (__rcKeyframe != null && __rcKeyframe.remove(keyframe)) ;
        }
    }
    
    @io.qt.QtUninvokable
    private native void removeKeyframe_native_Qt3DCore_QTransform_ptr(long __this__nativeId, long keyframe);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#easing-prop">Qt3DAnimation::QKeyframeAnimation::setEasing(QEasingCurve)</a></p>
     */
    @io.qt.QtPropertyWriter(name="easing")
    public final void setEasing(io.qt.core.QEasingCurve easing){
        setEasing_native_cref_QEasingCurve(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(easing));
    }
    
    private native void setEasing_native_cref_QEasingCurve(long __this__nativeId, long easing);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#endMode-prop">Qt3DAnimation::QKeyframeAnimation::setEndMode(Qt3DAnimation::QKeyframeAnimation::RepeatMode)</a></p>
     */
    @io.qt.QtPropertyWriter(name="endMode")
    public final void setEndMode(io.qt.qt3d.animation.QKeyframeAnimation.RepeatMode mode){
        setEndMode_native_Qt3DAnimation_QKeyframeAnimation_RepeatMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    private native void setEndMode_native_Qt3DAnimation_QKeyframeAnimation_RepeatMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#framePositions-prop">Qt3DAnimation::QKeyframeAnimation::setFramePositions(QList&lt;float&gt;)</a></p>
     */
    @io.qt.QtPropertyWriter(name="framePositions")
    public final void setFramePositions(java.util.Collection<java.lang.Float> positions){
        setFramePositions_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), positions);
    }
    
    private native void setFramePositions_native_cref_QList(long __this__nativeId, java.util.Collection<java.lang.Float> positions);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#setKeyframes">Qt3DAnimation::QKeyframeAnimation::setKeyframes(QList&lt;Qt3DCore::QTransform*&gt;)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void setKeyframes(java.util.Collection<io.qt.qt3d.core.QTransform> keyframes){
        setKeyframes_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), keyframes);
        if(__rcKeyframe!=null){
            __rcKeyframe.clear();
        }else{
            __rcKeyframe = new java.util.ArrayList<>();
        }
        __rcKeyframe.addAll(keyframes);
    }
    
    @io.qt.QtUninvokable
    private native void setKeyframes_native_cref_QList(long __this__nativeId, java.util.Collection<io.qt.qt3d.core.QTransform> keyframes);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#startMode-prop">Qt3DAnimation::QKeyframeAnimation::setStartMode(Qt3DAnimation::QKeyframeAnimation::RepeatMode)</a></p>
     */
    @io.qt.QtPropertyWriter(name="startMode")
    public final void setStartMode(io.qt.qt3d.animation.QKeyframeAnimation.RepeatMode mode){
        setStartMode_native_Qt3DAnimation_QKeyframeAnimation_RepeatMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    private native void setStartMode_native_Qt3DAnimation_QKeyframeAnimation_RepeatMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#target-prop">Qt3DAnimation::QKeyframeAnimation::setTarget(Qt3DCore::QTransform*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="target")
    @SuppressWarnings({"exports"})
    public final void setTarget(io.qt.qt3d.core.QTransform target){
        setTarget_native_Qt3DCore_QTransform_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(target));
        __rcTarget = target;
    }
    
    private native void setTarget_native_Qt3DCore_QTransform_ptr(long __this__nativeId, long target);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#targetName-prop">Qt3DAnimation::QKeyframeAnimation::setTargetName(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="targetName")
    public final void setTargetName(java.lang.String name){
        setTargetName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native void setTargetName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#startMode-prop">Qt3DAnimation::QKeyframeAnimation::startMode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="startMode")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.animation.QKeyframeAnimation.RepeatMode startMode(){
        return io.qt.qt3d.animation.QKeyframeAnimation.RepeatMode.resolve(startMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int startMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#target-prop">Qt3DAnimation::QKeyframeAnimation::target()const</a></p>
     */
    @io.qt.QtPropertyReader(name="target")
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.qt3d.core.QTransform target(){
        return target_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.core.QTransform target_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qkeyframeanimation.html#targetName-prop">Qt3DAnimation::QKeyframeAnimation::targetName()const</a></p>
     */
    @io.qt.QtPropertyReader(name="targetName")
    @io.qt.QtUninvokable
    public final java.lang.String targetName(){
        return targetName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String targetName_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QKeyframeAnimation(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QKeyframeAnimation(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QKeyframeAnimation instance, QDeclarativeConstructor constructor);
    
}
