package io.qt.qt3d.animation;


/**
 * <p>A class grouping animations together</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3danimation-qanimationgroup.html">Qt3DAnimation::QAnimationGroup</a></p>
 */
public class QAnimationGroup extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcAnimation;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAnimationGroup.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationgroup.html#duration-prop">Qt3DAnimation::QAnimationGroup::durationChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="duration")
    public final Signal1<@io.qt.QtPrimitiveType Float> durationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationgroup.html#name-prop">Qt3DAnimation::QAnimationGroup::nameChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="name")
    public final Signal1<java.lang.String> nameChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationgroup.html#position-prop">Qt3DAnimation::QAnimationGroup::positionChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="position")
    public final Signal1<@io.qt.QtPrimitiveType Float> positionChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QAnimationGroup(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAnimationGroup() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationgroup.html#QAnimationGroup">Qt3DAnimation::QAnimationGroup::QAnimationGroup(QObject*)</a></p>
     */
    public QAnimationGroup(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAnimationGroup instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationgroup.html#addAnimation">Qt3DAnimation::QAnimationGroup::addAnimation(Qt3DAnimation::QAbstractAnimation*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addAnimation(io.qt.qt3d.animation.QAbstractAnimation animation){
        addAnimation_native_Qt3DAnimation_QAbstractAnimation_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(animation));
        if (animation != null) {
            if(__rcAnimation==null)
                __rcAnimation = QtJambi_LibraryUtilities.internal.newRCList();
            __rcAnimation.add(animation);
        }
    }
    
    @io.qt.QtUninvokable
    private native void addAnimation_native_Qt3DAnimation_QAbstractAnimation_ptr(long __this__nativeId, long animation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationgroup.html#animationList">Qt3DAnimation::QAnimationGroup::animationList()</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.qt3d.animation.QAbstractAnimation> animationList(){
        return animationList_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.animation.QAbstractAnimation> animationList_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationgroup.html#duration-prop">Qt3DAnimation::QAnimationGroup::duration()const</a></p>
     */
    @io.qt.QtPropertyReader(name="duration")
    @io.qt.QtUninvokable
    public final float duration(){
        return duration_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float duration_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationgroup.html#name-prop">Qt3DAnimation::QAnimationGroup::name()const</a></p>
     */
    @io.qt.QtPropertyReader(name="name")
    @io.qt.QtUninvokable
    public final java.lang.String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationgroup.html#position-prop">Qt3DAnimation::QAnimationGroup::position()const</a></p>
     */
    @io.qt.QtPropertyReader(name="position")
    @io.qt.QtUninvokable
    public final float position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float position_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationgroup.html#removeAnimation">Qt3DAnimation::QAnimationGroup::removeAnimation(Qt3DAnimation::QAbstractAnimation*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeAnimation(io.qt.qt3d.animation.QAbstractAnimation animation){
        removeAnimation_native_Qt3DAnimation_QAbstractAnimation_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(animation));
        if (animation != null) {
            while (__rcAnimation != null && __rcAnimation.remove(animation)) ;
        }
    }
    
    @io.qt.QtUninvokable
    private native void removeAnimation_native_Qt3DAnimation_QAbstractAnimation_ptr(long __this__nativeId, long animation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationgroup.html#setAnimations">Qt3DAnimation::QAnimationGroup::setAnimations(QList&lt;Qt3DAnimation::QAbstractAnimation*&gt;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAnimations(java.util.Collection<io.qt.qt3d.animation.QAbstractAnimation> animations){
        setAnimations_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), animations);
        if(__rcAnimation!=null){
            __rcAnimation.clear();
        }else{
            __rcAnimation = new java.util.ArrayList<>();
        }
        __rcAnimation.addAll(animations);
    }
    
    @io.qt.QtUninvokable
    private native void setAnimations_native_cref_QList(long __this__nativeId, java.util.Collection<io.qt.qt3d.animation.QAbstractAnimation> animations);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationgroup.html#name-prop">Qt3DAnimation::QAnimationGroup::setName(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="name")
    public final void setName(java.lang.String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationgroup.html#position-prop">Qt3DAnimation::QAnimationGroup::setPosition(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="position")
    public final void setPosition(float position){
        setPosition_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), position);
    }
    
    private native void setPosition_native_float(long __this__nativeId, float position);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAnimationGroup(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QAnimationGroup(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QAnimationGroup instance, QDeclarativeConstructor constructor);
    
}
