package io.qt.qt3d.animation;


/**
 * <p>A class implementing blend-shape morphing animation</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html">Qt3DAnimation::QMorphingAnimation</a></p>
 */
public class QMorphingAnimation extends io.qt.qt3d.animation.QAbstractAnimation
{
    @io.qt.QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcMorphTarget;
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcTarget = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QMorphingAnimation.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#Method-enum">Qt3DAnimation::QMorphingAnimation::Method</a></p>
     */
    public enum Method implements io.qt.QtEnumerator {
        Normalized(0),
        Relative(1);

        private Method(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Method resolve(int value) {
            switch (value) {
            case 0: return Normalized;
            case 1: return Relative;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#easing-prop">Qt3DAnimation::QMorphingAnimation::easingChanged(QEasingCurve)</a></p>
     */
    @io.qt.QtPropertyNotify(name="easing")
    public final Signal1<io.qt.core.QEasingCurve> easingChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#interpolator-prop">Qt3DAnimation::QMorphingAnimation::interpolatorChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="interpolator")
    public final Signal1<@io.qt.QtPrimitiveType Float> interpolatorChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#method-prop">Qt3DAnimation::QMorphingAnimation::methodChanged(Qt3DAnimation::QMorphingAnimation::Method)</a></p>
     */
    @io.qt.QtPropertyNotify(name="method")
    public final Signal1<io.qt.qt3d.animation.QMorphingAnimation.Method> methodChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#target-prop">Qt3DAnimation::QMorphingAnimation::targetChanged(Qt3DRender::QGeometryRenderer*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtPropertyNotify(name="target")
    public final Signal1<io.qt.qt3d.render.QGeometryRenderer> targetChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#targetName-prop">Qt3DAnimation::QMorphingAnimation::targetNameChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="targetName")
    public final Signal1<java.lang.String> targetNameChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#targetPositions-prop">Qt3DAnimation::QMorphingAnimation::targetPositionsChanged(QList&lt;float&gt;)</a></p>
     */
    @io.qt.QtPropertyNotify(name="targetPositions")
    public final Signal1<java.util.List<java.lang.Float>> targetPositionsChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QMorphingAnimation(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QMorphingAnimation() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#QMorphingAnimation">Qt3DAnimation::QMorphingAnimation::QMorphingAnimation(QObject*)</a></p>
     */
    public QMorphingAnimation(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QMorphingAnimation instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#addMorphTarget">Qt3DAnimation::QMorphingAnimation::addMorphTarget(Qt3DAnimation::QMorphTarget*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addMorphTarget(io.qt.qt3d.animation.QMorphTarget target){
        addMorphTarget_native_Qt3DAnimation_QMorphTarget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(target));
        if (target != null) {
            if(__rcMorphTarget==null)
                __rcMorphTarget = QtJambi_LibraryUtilities.internal.newRCList();
            __rcMorphTarget.add(target);
        }
    }
    
    @io.qt.QtUninvokable
    private native void addMorphTarget_native_Qt3DAnimation_QMorphTarget_ptr(long __this__nativeId, long target);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#easing-prop">Qt3DAnimation::QMorphingAnimation::easing()const</a></p>
     */
    @io.qt.QtPropertyReader(name="easing")
    @io.qt.QtUninvokable
    public final io.qt.core.QEasingCurve easing(){
        return easing_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QEasingCurve easing_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#getWeights">Qt3DAnimation::QMorphingAnimation::getWeights(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<java.lang.Float> getWeights(int positionIndex){
        return getWeights_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), positionIndex);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<java.lang.Float> getWeights_native_int(long __this__nativeId, int positionIndex);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#interpolator-prop">Qt3DAnimation::QMorphingAnimation::interpolator()const</a></p>
     */
    @io.qt.QtPropertyReader(name="interpolator")
    @io.qt.QtUninvokable
    public final float interpolator(){
        return interpolator_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float interpolator_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#method-prop">Qt3DAnimation::QMorphingAnimation::method()const</a></p>
     */
    @io.qt.QtPropertyReader(name="method")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.animation.QMorphingAnimation.Method method(){
        return io.qt.qt3d.animation.QMorphingAnimation.Method.resolve(method_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int method_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#morphTargetList">Qt3DAnimation::QMorphingAnimation::morphTargetList()</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.qt3d.animation.QMorphTarget> morphTargetList(){
        return morphTargetList_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.animation.QMorphTarget> morphTargetList_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#removeMorphTarget">Qt3DAnimation::QMorphingAnimation::removeMorphTarget(Qt3DAnimation::QMorphTarget*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeMorphTarget(io.qt.qt3d.animation.QMorphTarget target){
        removeMorphTarget_native_Qt3DAnimation_QMorphTarget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(target));
        if (target != null) {
            while (__rcMorphTarget != null && __rcMorphTarget.remove(target)) ;
        }
    }
    
    @io.qt.QtUninvokable
    private native void removeMorphTarget_native_Qt3DAnimation_QMorphTarget_ptr(long __this__nativeId, long target);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#easing-prop">Qt3DAnimation::QMorphingAnimation::setEasing(QEasingCurve)</a></p>
     */
    @io.qt.QtPropertyWriter(name="easing")
    public final void setEasing(io.qt.core.QEasingCurve easing){
        setEasing_native_cref_QEasingCurve(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(easing));
    }
    
    private native void setEasing_native_cref_QEasingCurve(long __this__nativeId, long easing);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#method-prop">Qt3DAnimation::QMorphingAnimation::setMethod(Qt3DAnimation::QMorphingAnimation::Method)</a></p>
     */
    @io.qt.QtPropertyWriter(name="method")
    public final void setMethod(io.qt.qt3d.animation.QMorphingAnimation.Method method){
        setMethod_native_Qt3DAnimation_QMorphingAnimation_Method(QtJambi_LibraryUtilities.internal.nativeId(this), method.value());
    }
    
    private native void setMethod_native_Qt3DAnimation_QMorphingAnimation_Method(long __this__nativeId, int method);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#setMorphTargets">Qt3DAnimation::QMorphingAnimation::setMorphTargets(QList&lt;Qt3DAnimation::QMorphTarget*&gt;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setMorphTargets(java.util.Collection<io.qt.qt3d.animation.QMorphTarget> targets){
        setMorphTargets_native_cref_QVector(QtJambi_LibraryUtilities.internal.nativeId(this), targets);
        if(__rcMorphTarget!=null){
            __rcMorphTarget.clear();
        }else{
            __rcMorphTarget = new java.util.ArrayList<>();
        }
        __rcMorphTarget.addAll(targets);
    }
    
    @io.qt.QtUninvokable
    private native void setMorphTargets_native_cref_QVector(long __this__nativeId, java.util.Collection<io.qt.qt3d.animation.QMorphTarget> targets);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#target-prop">Qt3DAnimation::QMorphingAnimation::setTarget(Qt3DRender::QGeometryRenderer*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="target")
    @SuppressWarnings({"exports"})
    public final void setTarget(io.qt.qt3d.render.QGeometryRenderer target){
        setTarget_native_Qt3DRender_QGeometryRenderer_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(target));
        __rcTarget = target;
    }
    
    private native void setTarget_native_Qt3DRender_QGeometryRenderer_ptr(long __this__nativeId, long target);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#targetName-prop">Qt3DAnimation::QMorphingAnimation::setTargetName(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="targetName")
    public final void setTargetName(java.lang.String name){
        setTargetName_native_const_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native void setTargetName_native_const_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#targetPositions-prop">Qt3DAnimation::QMorphingAnimation::setTargetPositions(QList&lt;float&gt;)</a></p>
     */
    @io.qt.QtPropertyWriter(name="targetPositions")
    public final void setTargetPositions(java.util.Collection<java.lang.Float> targetPositions){
        setTargetPositions_native_cref_QVector(QtJambi_LibraryUtilities.internal.nativeId(this), targetPositions);
    }
    
    private native void setTargetPositions_native_cref_QVector(long __this__nativeId, java.util.Collection<java.lang.Float> targetPositions);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#setWeights">Qt3DAnimation::QMorphingAnimation::setWeights(int,QList&lt;float&gt;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setWeights(int positionIndex, java.util.Collection<java.lang.Float> weights){
        setWeights_native_int_cref_QVector(QtJambi_LibraryUtilities.internal.nativeId(this), positionIndex, weights);
    }
    
    @io.qt.QtUninvokable
    private native void setWeights_native_int_cref_QVector(long __this__nativeId, int positionIndex, java.util.Collection<java.lang.Float> weights);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#target-prop">Qt3DAnimation::QMorphingAnimation::target()const</a></p>
     */
    @io.qt.QtPropertyReader(name="target")
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QGeometryRenderer target(){
        return target_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.render.QGeometryRenderer target_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#targetName-prop">Qt3DAnimation::QMorphingAnimation::targetName()const</a></p>
     */
    @io.qt.QtPropertyReader(name="targetName")
    @io.qt.QtUninvokable
    public final java.lang.String targetName(){
        return targetName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String targetName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qmorphinganimation.html#targetPositions-prop">Qt3DAnimation::QMorphingAnimation::targetPositions()const</a></p>
     */
    @io.qt.QtPropertyReader(name="targetPositions")
    @io.qt.QtUninvokable
    public final io.qt.core.QList<java.lang.Float> targetPositions(){
        return targetPositions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<java.lang.Float> targetPositions_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QMorphingAnimation(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QMorphingAnimation(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QMorphingAnimation instance, QDeclarativeConstructor constructor);
    
}
