package io.qt.qt3d.animation;


/**
 * <p>A base class for handling keyframes</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3danimation-qkeyframe.html">Qt3DAnimation::QKeyFrame</a></p>
 */
public class QKeyFrame extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum Qt3DAnimation::QKeyFrame::InterpolationType</p>
     */
    public enum InterpolationType implements io.qt.QtByteEnumerator {
        ConstantInterpolation((byte)0),
        LinearInterpolation((byte)1),
        BezierInterpolation((byte)2);

        private InterpolationType(byte value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public byte value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static InterpolationType resolve(byte value) {
            switch (value) {
            case 0: return ConstantInterpolation;
            case 1: return LinearInterpolation;
            case 2: return BezierInterpolation;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final byte value;
    }
    
    
    public QKeyFrame(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QKeyFrame instance);
    
    public QKeyFrame(io.qt.gui.QVector2D coords){
        super((QPrivateConstructor)null);
        initialize_native(this, coords);
    }
    
    private native static void initialize_native(QKeyFrame instance, io.qt.gui.QVector2D coords);
    
    public QKeyFrame(io.qt.gui.QVector2D coords, io.qt.gui.QVector2D lh, io.qt.gui.QVector2D rh){
        super((QPrivateConstructor)null);
        initialize_native(this, coords, lh, rh);
    }
    
    private native static void initialize_native(QKeyFrame instance, io.qt.gui.QVector2D coords, io.qt.gui.QVector2D lh, io.qt.gui.QVector2D rh);
    
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector2D coordinates(){
        return coordinates_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector2D coordinates_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.qt3d.animation.QKeyFrame.InterpolationType interpolationType(){
        return io.qt.qt3d.animation.QKeyFrame.InterpolationType.resolve(interpolationType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native byte interpolationType_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector2D leftControlPoint(){
        return leftControlPoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector2D leftControlPoint_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    private final boolean operator_equal(io.qt.qt3d.animation.QKeyFrame rhs){
        java.util.Objects.requireNonNull(rhs, "Argument 'rhs': null not expected.");
        return operator_equal_native_cref_Qt3DAnimation_QKeyFrame(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @io.qt.QtUninvokable
    private native boolean operator_equal_native_cref_Qt3DAnimation_QKeyFrame(long __this__nativeId, long rhs);
    
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector2D rightControlPoint(){
        return rightControlPoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector2D rightControlPoint_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void setCoordinates(io.qt.gui.QVector2D coords){
        setCoordinates_native_QVector2D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(coords));
    }
    
    @io.qt.QtUninvokable
    private native void setCoordinates_native_QVector2D(long __this__nativeId, long coords);
    
    @io.qt.QtUninvokable
    public final void setInterpolationType(io.qt.qt3d.animation.QKeyFrame.InterpolationType interp){
        setInterpolationType_native_Qt3DAnimation_QKeyFrame_InterpolationType(QtJambi_LibraryUtilities.internal.nativeId(this), interp.value());
    }
    
    @io.qt.QtUninvokable
    private native void setInterpolationType_native_Qt3DAnimation_QKeyFrame_InterpolationType(long __this__nativeId, byte interp);
    
    @io.qt.QtUninvokable
    public final void setLeftControlPoint(io.qt.gui.QVector2D lh){
        setLeftControlPoint_native_QVector2D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(lh));
    }
    
    @io.qt.QtUninvokable
    private native void setLeftControlPoint_native_QVector2D(long __this__nativeId, long lh);
    
    @io.qt.QtUninvokable
    public final void setRightControlPoint(io.qt.gui.QVector2D rh){
        setRightControlPoint_native_QVector2D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rh));
    }
    
    @io.qt.QtUninvokable
    private native void setRightControlPoint_native_QVector2D(long __this__nativeId, long rh);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QKeyFrame(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.qt3d.animation.QKeyFrame) {
            return operator_equal((io.qt.qt3d.animation.QKeyFrame) other);
        }

        return false;
    }


    @io.qt.QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
}
