package io.qt.qt3d.animation;


/**
 * <p>Enables loading key frame animation data from a file</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3danimation-qanimationcliploader.html">Qt3DAnimation::QAnimationClipLoader</a></p>
 */
public class QAnimationClipLoader extends io.qt.qt3d.animation.QAbstractAnimationClip
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAnimationClipLoader.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3danimation-qanimationcliploader.html#Status-enum">Qt3DAnimation::QAnimationClipLoader::Status</a></p>
     */
    public enum Status implements io.qt.QtEnumerator {
        NotReady(0),
        Ready(1),
        Error(2);

        private Status(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Status resolve(int value) {
            switch (value) {
            case 0: return NotReady;
            case 1: return Ready;
            case 2: return Error;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcliploader.html#source-prop">Qt3DAnimation::QAnimationClipLoader::sourceChanged(QUrl)</a></p>
     */
    @io.qt.QtPropertyNotify(name="source")
    public final Signal1<io.qt.core.QUrl> sourceChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcliploader.html#status-prop">Qt3DAnimation::QAnimationClipLoader::statusChanged(Qt3DAnimation::QAnimationClipLoader::Status)</a></p>
     */
    @io.qt.QtPropertyNotify(name="status")
    public final Signal1<io.qt.qt3d.animation.QAnimationClipLoader.Status> statusChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QAnimationClipLoader(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAnimationClipLoader() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QAnimationClipLoader(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAnimationClipLoader instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Overloaded constructor for {@link #QAnimationClipLoader(io.qt.core.QUrl, io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAnimationClipLoader(io.qt.core.QUrl source) {
        this(source, (io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QAnimationClipLoader(io.qt.core.QUrl source, io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, source, parent);
    }
    
    private native static void initialize_native(QAnimationClipLoader instance, io.qt.core.QUrl source, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcliploader.html#source-prop">Qt3DAnimation::QAnimationClipLoader::setSource(QUrl)</a></p>
     */
    @io.qt.QtPropertyWriter(name="source")
    public final void setSource(io.qt.core.QUrl source){
        setSource_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    private native void setSource_native_cref_QUrl(long __this__nativeId, long source);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcliploader.html#source-prop">Qt3DAnimation::QAnimationClipLoader::source()const</a></p>
     */
    @io.qt.QtPropertyReader(name="source")
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl source(){
        return source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl source_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qanimationcliploader.html#status">Qt3DAnimation::QAnimationClipLoader::status()const</a></p>
     */
    @io.qt.QtPropertyReader(name="status")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.animation.QAnimationClipLoader.Status status(){
        return io.qt.qt3d.animation.QAnimationClipLoader.Status.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAnimationClipLoader(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QAnimationClipLoader(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QAnimationClipLoader instance, QDeclarativeConstructor constructor);
    
}
