package io.qt.qt3d.animation;


/**
 * <p>An abstract base class for Qt3D animations</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3danimation-qabstractanimation.html">Qt3DAnimation::QAbstractAnimation</a></p>
 */
public class QAbstractAnimation extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractAnimation.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3danimation-qabstractanimation.html#AnimationType-enum">Qt3DAnimation::QAbstractAnimation::AnimationType</a></p>
     */
    public enum AnimationType implements io.qt.QtEnumerator {
        KeyframeAnimation(1),
        MorphingAnimation(2),
        VertexBlendAnimation(3);

        private AnimationType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static AnimationType resolve(int value) {
            switch (value) {
            case 1: return KeyframeAnimation;
            case 2: return MorphingAnimation;
            case 3: return VertexBlendAnimation;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractanimation.html#animationName-prop">Qt3DAnimation::QAbstractAnimation::animationNameChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="animationName")
    public final Signal1<java.lang.String> animationNameChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractanimation.html#duration-prop">Qt3DAnimation::QAbstractAnimation::durationChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="duration")
    public final Signal1<@io.qt.QtPrimitiveType Float> durationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractanimation.html#position-prop">Qt3DAnimation::QAbstractAnimation::positionChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="position")
    public final Signal1<@io.qt.QtPrimitiveType Float> positionChanged = new Signal1<>();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractanimation.html#animationName-prop">Qt3DAnimation::QAbstractAnimation::animationName()const</a></p>
     */
    @io.qt.QtPropertyReader(name="animationName")
    @io.qt.QtUninvokable
    public final java.lang.String animationName(){
        return animationName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String animationName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractanimation.html#animationType-prop">Qt3DAnimation::QAbstractAnimation::animationType()const</a></p>
     */
    @io.qt.QtPropertyReader(name="animationType")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.qt3d.animation.QAbstractAnimation.AnimationType animationType(){
        return io.qt.qt3d.animation.QAbstractAnimation.AnimationType.resolve(animationType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int animationType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractanimation.html#duration-prop">Qt3DAnimation::QAbstractAnimation::duration()const</a></p>
     */
    @io.qt.QtPropertyReader(name="duration")
    @io.qt.QtUninvokable
    public final float duration(){
        return duration_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float duration_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractanimation.html#position-prop">Qt3DAnimation::QAbstractAnimation::position()const</a></p>
     */
    @io.qt.QtPropertyReader(name="position")
    @io.qt.QtUninvokable
    public final float position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float position_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractanimation.html#animationName-prop">Qt3DAnimation::QAbstractAnimation::setAnimationName(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="animationName")
    public final void setAnimationName(java.lang.String name){
        setAnimationName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native void setAnimationName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractanimation.html#setDuration">Qt3DAnimation::QAbstractAnimation::setDuration(float)</a></p>
     */
    @io.qt.QtUninvokable
    protected final void setDuration(float duration){
        setDuration_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), duration);
    }
    
    @io.qt.QtUninvokable
    private native void setDuration_native_float(long __this__nativeId, float duration);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractanimation.html#position-prop">Qt3DAnimation::QAbstractAnimation::setPosition(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="position")
    public final void setPosition(float position){
        setPosition_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), position);
    }
    
    private native void setPosition_native_float(long __this__nativeId, float position);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAbstractAnimation(QPrivateConstructor p) { super(p); } 
    
}
