package io.qt.qt3d.animation;


/**
 * <p>Defines a channel for a QAnimationClipData. The animation system interpolates each channel component independently except in the case the QChannel is called "Rotation" (case sensitive), it has four QChannelComponents and the same number of keyframes for each QChannelComponent. In that case the interpolation will be performed using SLERP</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3danimation-qchannel.html">Qt3DAnimation::QChannel</a></p>
 */
public class QChannel extends io.qt.QtObject
    implements java.lang.Iterable<io.qt.qt3d.animation.QChannelComponent>,
            java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    

    
    public QChannel(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QChannel instance);
    
    public QChannel(java.lang.String name){
        super((QPrivateConstructor)null);
        initialize_native(this, name);
    }
    
    private native static void initialize_native(QChannel instance, java.lang.String name);
    
    public QChannel(io.qt.qt3d.animation.QChannel arg__1){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1);
    }
    
    private native static void initialize_native(QChannel instance, io.qt.qt3d.animation.QChannel arg__1);
    
    @io.qt.QtUninvokable
    public final void appendChannelComponent(io.qt.qt3d.animation.QChannelComponent component){
        appendChannelComponent_native_cref_Qt3DAnimation_QChannelComponent(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(component));
    }
    
    @io.qt.QtUninvokable
    private native void appendChannelComponent_native_cref_Qt3DAnimation_QChannelComponent(long __this__nativeId, long component);
    
    @io.qt.QtUninvokable
    protected final io.qt.core.QIterator<io.qt.qt3d.animation.QChannelComponent> begin(){
        return begin_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QIterator<io.qt.qt3d.animation.QChannelComponent> begin_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final int channelComponentCount(){
        return channelComponentCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int channelComponentCount_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void clearChannelComponents(){
        clearChannelComponents_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void clearChannelComponents_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected final io.qt.core.QIterator<io.qt.qt3d.animation.QChannelComponent> end(){
        return end_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QIterator<io.qt.qt3d.animation.QChannelComponent> end_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void insertChannelComponent(int index, io.qt.qt3d.animation.QChannelComponent component){
        insertChannelComponent_native_int_cref_Qt3DAnimation_QChannelComponent(QtJambi_LibraryUtilities.internal.nativeId(this), index, QtJambi_LibraryUtilities.internal.checkedNativeId(component));
    }
    
    @io.qt.QtUninvokable
    private native void insertChannelComponent_native_int_cref_Qt3DAnimation_QChannelComponent(long __this__nativeId, int index, long component);
    
    @io.qt.QtUninvokable
    public final int jointIndex(){
        return jointIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int jointIndex_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final java.lang.String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void removeChannelComponent(int index){
        removeChannelComponent_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @io.qt.QtUninvokable
    private native void removeChannelComponent_native_int(long __this__nativeId, int index);
    
    @io.qt.QtUninvokable
    public final void setJointIndex(int jointIndex){
        setJointIndex_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), jointIndex);
    }
    
    @io.qt.QtUninvokable
    private native void setJointIndex_native_int(long __this__nativeId, int jointIndex);
    
    @io.qt.QtUninvokable
    public final void setName(java.lang.String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    
    @Override
    public java.util.Iterator<io.qt.qt3d.animation.QChannelComponent> iterator() {
        return begin().iterator();
    }
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QChannel(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public boolean equals(Object other) {
        if(other instanceof io.qt.qt3d.animation.QChannel)
            return hashCode()==other.hashCode();
        else return super.equals(other);    }


    @io.qt.QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    @Override
    public QChannel clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QChannel clone_native(long __this_nativeId);
}
