package io.qt.qt3d.animation;


/**
 * <p>The base class for types providing animation playback capabilities</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3danimation-qabstractclipanimator.html">Qt3DAnimation::QAbstractClipAnimator</a></p>
 */
public class QAbstractClipAnimator extends io.qt.qt3d.core.QComponent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractClipAnimator.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3danimation-qabstractclipanimator.html#Loops-enum">Qt3DAnimation::QAbstractClipAnimator::Loops</a></p>
     */
    public static class Loops{
        public static final int Infinite = -1;
    } // end of enum Loops


    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractclipanimator.html#channelMapper-prop">Qt3DAnimation::QAbstractClipAnimator::channelMapperChanged(Qt3DAnimation::QChannelMapper*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="channelMapper")
    public final Signal1<io.qt.qt3d.animation.QChannelMapper> channelMapperChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractclipanimator.html#clock-prop">Qt3DAnimation::QAbstractClipAnimator::clockChanged(Qt3DAnimation::QClock*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="clock")
    public final Signal1<io.qt.qt3d.animation.QClock> clockChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractclipanimator.html#loops-prop">Qt3DAnimation::QAbstractClipAnimator::loopCountChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="loops")
    public final Signal1<@io.qt.QtPrimitiveType Integer> loopCountChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractclipanimator.html#normalizedTime-prop">Qt3DAnimation::QAbstractClipAnimator::normalizedTimeChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="normalizedTime")
    public final Signal1<@io.qt.QtPrimitiveType Float> normalizedTimeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractclipanimator.html#running-prop">Qt3DAnimation::QAbstractClipAnimator::runningChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="running")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> runningChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractClipAnimator(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    protected QAbstractClipAnimator() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    protected QAbstractClipAnimator(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAbstractClipAnimator instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractclipanimator.html#channelMapper-prop">Qt3DAnimation::QAbstractClipAnimator::channelMapper()const</a></p>
     */
    @io.qt.QtPropertyReader(name="channelMapper")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.animation.QChannelMapper channelMapper(){
        return channelMapper_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.animation.QChannelMapper channelMapper_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractclipanimator.html#clock-prop">Qt3DAnimation::QAbstractClipAnimator::clock()const</a></p>
     */
    @io.qt.QtPropertyReader(name="clock")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.animation.QClock clock(){
        return clock_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.animation.QClock clock_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractclipanimator.html#isRunning">Qt3DAnimation::QAbstractClipAnimator::isRunning()const</a></p>
     */
    @io.qt.QtPropertyReader(name="running")
    @io.qt.QtUninvokable
    public final boolean isRunning(){
        return isRunning_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isRunning_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractclipanimator.html#loopCount">Qt3DAnimation::QAbstractClipAnimator::loopCount()const</a></p>
     */
    @io.qt.QtPropertyReader(name="loops")
    @io.qt.QtUninvokable
    public final int loopCount(){
        return loopCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int loopCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractclipanimator.html#normalizedTime-prop">Qt3DAnimation::QAbstractClipAnimator::normalizedTime()const</a></p>
     */
    @io.qt.QtPropertyReader(name="normalizedTime")
    @io.qt.QtUninvokable
    public final float normalizedTime(){
        return normalizedTime_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float normalizedTime_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractclipanimator.html#channelMapper-prop">Qt3DAnimation::QAbstractClipAnimator::setChannelMapper(Qt3DAnimation::QChannelMapper*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="channelMapper")
    public final void setChannelMapper(io.qt.qt3d.animation.QChannelMapper channelMapper){
        setChannelMapper_native_Qt3DAnimation_QChannelMapper_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(channelMapper));
    }
    
    private native void setChannelMapper_native_Qt3DAnimation_QChannelMapper_ptr(long __this__nativeId, long channelMapper);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractclipanimator.html#clock-prop">Qt3DAnimation::QAbstractClipAnimator::setClock(Qt3DAnimation::QClock*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="clock")
    public final void setClock(io.qt.qt3d.animation.QClock clock){
        setClock_native_Qt3DAnimation_QClock_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(clock));
    }
    
    private native void setClock_native_Qt3DAnimation_QClock_ptr(long __this__nativeId, long clock);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractclipanimator.html#loops-prop">Qt3DAnimation::QAbstractClipAnimator::setLoopCount(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="loops")
    public final void setLoopCount(int loops){
        setLoopCount_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), loops);
    }
    
    private native void setLoopCount_native_int(long __this__nativeId, int loops);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractclipanimator.html#normalizedTime-prop">Qt3DAnimation::QAbstractClipAnimator::setNormalizedTime(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="normalizedTime")
    public final void setNormalizedTime(float timeFraction){
        setNormalizedTime_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), timeFraction);
    }
    
    private native void setNormalizedTime_native_float(long __this__nativeId, float timeFraction);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractclipanimator.html#running-prop">Qt3DAnimation::QAbstractClipAnimator::setRunning(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="running")
    public final void setRunning(boolean running){
        setRunning_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), running);
    }
    
    private native void setRunning_native_bool(long __this__nativeId, boolean running);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractclipanimator.html#start">Qt3DAnimation::QAbstractClipAnimator::start()</a></p>
     */
    public final void start(){
        start_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void start_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3danimation-qabstractclipanimator.html#stop">Qt3DAnimation::QAbstractClipAnimator::stop()</a></p>
     */
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void stop_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAbstractClipAnimator(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QAbstractClipAnimator(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QAbstractClipAnimator instance, QDeclarativeConstructor constructor);
    
}
