package io.qt.qml;


/**
 * <p>Used to register image providers in the QML engine</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qqmlimageproviderbase.html">QQmlImageProviderBase</a></p>
 */
public abstract class QQmlImageProviderBase extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQmlImageProviderBase.class);
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QQmlImageProviderBase {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.qml.QQmlImageProviderBase.Flags flags(){
            return new io.qt.qml.QQmlImageProviderBase.Flags(flags_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        @io.qt.QtUninvokable
        private native int flags_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.qml.QQmlImageProviderBase.ImageType imageType(){
            return io.qt.qml.QQmlImageProviderBase.ImageType.resolve(imageType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        @io.qt.QtUninvokable
        private native int imageType_native_constfct(long __this__nativeId);
        
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qqmlimageproviderbase.html#Flag-enum">QQmlImageProviderBase::Flag</a></p>
     * 
     * @see Flags
     */
    public enum Flag implements io.qt.QtFlagEnumerator {
        ForceAsynchronousImageLoading(1);

        private Flag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public Flags asFlags() {
            return new Flags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public Flags combined(Flag e) {
            return new Flags(this, e);
        }

        /**
         * Creates a new {@link Flags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static Flags flags(Flag ... values) {
            return new Flags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Flag resolve(int value) {
            switch (value) {
            case 1: return ForceAsynchronousImageLoading;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link Flag}
     */
    public static final class Flags extends io.qt.QFlags<Flag> implements Comparable<Flags> {
        private static final long serialVersionUID = 0x92d9bce6c929c1c6L;

        /**
         * Creates a new Flags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public Flags(Flag ... args){
            super(args);
        }

        /**
         * Creates a new Flags with given <code>value</code>.
         * @param value
         */
        public Flags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new Flags
         */
        @Override
        public final Flags combined(Flag e){
            return new Flags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final Flags setFlag(Flag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final Flags setFlag(Flag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this Flags.
         * @return array of enum entries
         */
        @Override
        public final Flag[] flags(){
            return super.flags(Flag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final Flags clone(){
            return new Flags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(Flags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qqmlimageproviderbase.html#ImageType-enum">QQmlImageProviderBase::ImageType</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum ImageType implements io.qt.QtEnumerator {
        Invalid(0),
        Image(1),
        Pixmap(2),
        Texture(3),
        ImageResponse(4);

        private ImageType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ImageType resolve(int value) {
            switch (value) {
            case 0: return Invalid;
            case 1: return Image;
            case 2: return Pixmap;
            case 3: return Texture;
            case 4: return ImageResponse;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlimageproviderbase.html#flags">QQmlImageProviderBase::flags()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.qml.QQmlImageProviderBase.Flags flags();
    
    @io.qt.QtUninvokable
    private native int flags_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlimageproviderbase.html#imageType">QQmlImageProviderBase::imageType()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.qml.QQmlImageProviderBase.ImageType imageType();
    
    @io.qt.QtUninvokable
    private native int imageType_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQmlImageProviderBase(QPrivateConstructor p) { super(p); } 
    
}
