package io.qt.qml;


/**
 * <p>Evaluates JavaScript in a QML context</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qqmlexpression.html">QQmlExpression</a></p>
 */
public class QQmlExpression extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQmlExpression.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlexpression.html#valueChanged">QQmlExpression::valueChanged()</a></p>
     */
    public final Signal0 valueChanged = new Signal0();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlexpression.html#QQmlExpression">QQmlExpression::QQmlExpression()</a></p>
     */
    public QQmlExpression(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QQmlExpression instance);
    
    /**
     * <p>Overloaded constructor for {@link #QQmlExpression(io.qt.qml.QQmlContext, io.qt.core.QObject, java.lang.String, io.qt.core.QObject)}
     *  with <code>arg__4 = null</code>.</p>
     */
    public QQmlExpression(io.qt.qml.QQmlContext arg__1, io.qt.core.QObject arg__2, java.lang.String arg__3) {
        this(arg__1, arg__2, arg__3, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlexpression.html#QQmlExpression-1">QQmlExpression::QQmlExpression(QQmlContext*,QObject*,QString,QObject*)</a></p>
     */
    public QQmlExpression(io.qt.qml.QQmlContext arg__1, io.qt.core.QObject arg__2, java.lang.String arg__3, io.qt.core.QObject arg__4){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1, arg__2, arg__3, arg__4);
    }
    
    private native static void initialize_native(QQmlExpression instance, io.qt.qml.QQmlContext arg__1, io.qt.core.QObject arg__2, java.lang.String arg__3, io.qt.core.QObject arg__4);
    
    /**
     * <p>Overloaded constructor for {@link #QQmlExpression(io.qt.qml.QQmlScriptString, io.qt.qml.QQmlContext, io.qt.core.QObject, io.qt.core.QObject)}
     *  with <code>arg__4 = null</code>.</p>
     */
    public QQmlExpression(io.qt.qml.QQmlScriptString arg__1, io.qt.qml.QQmlContext arg__2, io.qt.core.QObject arg__3) {
        this(arg__1, arg__2, arg__3, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QQmlExpression(io.qt.qml.QQmlScriptString, io.qt.qml.QQmlContext, io.qt.core.QObject, io.qt.core.QObject)}</p>
     * <p>with: </p><ul>
     * <li><code>arg__3 = null</code></li>
     * <li><code>arg__4 = null</code></li>
     * </ul>
     */
    public QQmlExpression(io.qt.qml.QQmlScriptString arg__1, io.qt.qml.QQmlContext arg__2) {
        this(arg__1, arg__2, (io.qt.core.QObject)null, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QQmlExpression(io.qt.qml.QQmlScriptString, io.qt.qml.QQmlContext, io.qt.core.QObject, io.qt.core.QObject)}</p>
     * <p>with: </p><ul>
     * <li><code>arg__2 = null</code></li>
     * <li><code>arg__3 = null</code></li>
     * <li><code>arg__4 = null</code></li>
     * </ul>
     */
    public QQmlExpression(io.qt.qml.QQmlScriptString arg__1) {
        this(arg__1, (io.qt.qml.QQmlContext)null, (io.qt.core.QObject)null, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlexpression.html#QQmlExpression-2">QQmlExpression::QQmlExpression(QQmlScriptString,QQmlContext*,QObject*,QObject*)</a></p>
     */
    public QQmlExpression(io.qt.qml.QQmlScriptString arg__1, io.qt.qml.QQmlContext arg__2, io.qt.core.QObject arg__3, io.qt.core.QObject arg__4){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1, arg__2, arg__3, arg__4);
    }
    
    private native static void initialize_native(QQmlExpression instance, io.qt.qml.QQmlScriptString arg__1, io.qt.qml.QQmlContext arg__2, io.qt.core.QObject arg__3, io.qt.core.QObject arg__4);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlexpression.html#clearError">QQmlExpression::clearError()</a></p>
     */
    @io.qt.QtUninvokable
    public final void clearError(){
        clearError_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void clearError_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlexpression.html#columnNumber">QQmlExpression::columnNumber()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int columnNumber(){
        return columnNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int columnNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlexpression.html#context">QQmlExpression::context()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QQmlContext context(){
        return context_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QQmlContext context_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlexpression.html#engine">QQmlExpression::engine()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QQmlEngine engine(){
        return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QQmlEngine engine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlexpression.html#error">QQmlExpression::error()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QQmlError error(){
        return error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QQmlError error_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlexpression.html#evaluate">QQmlExpression::evaluate(bool*)</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object evaluate() throws ValueIsUndefined{
        return evaluate_native_bool_ptr(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object evaluate_native_bool_ptr(long __this__nativeId) throws ValueIsUndefined ;
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlexpression.html#expression">QQmlExpression::expression()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String expression(){
        return expression_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String expression_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlexpression.html#hasError">QQmlExpression::hasError()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean hasError(){
        return hasError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean hasError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlexpression.html#lineNumber">QQmlExpression::lineNumber()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int lineNumber(){
        return lineNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int lineNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlexpression.html#notifyOnValueChanged">QQmlExpression::notifyOnValueChanged()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean notifyOnValueChanged(){
        return notifyOnValueChanged_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean notifyOnValueChanged_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlexpression.html#scopeObject">QQmlExpression::scopeObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QObject scopeObject(){
        return scopeObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QObject scopeObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlexpression.html#setExpression">QQmlExpression::setExpression(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setExpression(java.lang.String arg__1){
        setExpression_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setExpression_native_cref_QString(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlexpression.html#setNotifyOnValueChanged">QQmlExpression::setNotifyOnValueChanged(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setNotifyOnValueChanged(boolean arg__1){
        setNotifyOnValueChanged_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setNotifyOnValueChanged_native_bool(long __this__nativeId, boolean arg__1);
    
    /**
     * <p>Overloaded function for {@link #setSourceLocation(java.lang.String, int, int)}
     *  with <code>column = 0</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setSourceLocation(java.lang.String fileName, int line) {
        setSourceLocation(fileName, line, (int)0);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlexpression.html#setSourceLocation">QQmlExpression::setSourceLocation(QString,int,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setSourceLocation(java.lang.String fileName, int line, int column){
        setSourceLocation_native_cref_QString_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), fileName, line, column);
    }
    
    @io.qt.QtUninvokable
    private native void setSourceLocation_native_cref_QString_int_int(long __this__nativeId, java.lang.String fileName, int line, int column);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlexpression.html#sourceFile">QQmlExpression::sourceFile()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String sourceFile(){
        return sourceFile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String sourceFile_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQmlExpression(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QQmlExpression(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QQmlExpression instance, QDeclarativeConstructor constructor);
    
    public static class ValueIsUndefined extends RuntimeException{
        private static final long serialVersionUID = 7719401165632826435L;
        private ValueIsUndefined(String message) {
            super(message);
        }
    }
}
