package io.qt.qml;


/**
 * <p>Allows you to control QML file loading</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qqmlabstracturlinterceptor.html">QQmlAbstractUrlInterceptor</a></p>
 */
public interface QQmlAbstractUrlInterceptor extends io.qt.QtObjectInterface
{
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qqmlabstracturlinterceptor.html#DataType-enum">QQmlAbstractUrlInterceptor::DataType</a></p>
     */
    public enum DataType implements io.qt.QtEnumerator {
        QmlFile(0),
        JavaScriptFile(1),
        QmldirFile(2),
        UrlString(4096);

        private DataType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static DataType resolve(int value) {
            switch (value) {
            case 0: return QmlFile;
            case 1: return JavaScriptFile;
            case 2: return QmldirFile;
            case 4096: return UrlString;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Implementor class for interface {@link io.qt.qml.QQmlAbstractUrlInterceptor}</p>
     */
    public static abstract class Impl extends io.qt.QtObject
        implements io.qt.qml.QQmlAbstractUrlInterceptor
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @io.qt.NativeAccess
        private static final class ConcreteWrapper extends QQmlAbstractUrlInterceptor.Impl {
            
            @io.qt.NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @io.qt.QtUninvokable
            public io.qt.core.QUrl intercept(io.qt.core.QUrl path, io.qt.qml.QQmlAbstractUrlInterceptor.DataType type){
                return intercept_native_cref_QUrl_QQmlAbstractUrlInterceptor_DataType(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(path), type.value());
            }
            private native static io.qt.core.QUrl intercept_native_cref_QUrl_QQmlAbstractUrlInterceptor_DataType(long __this__nativeId, long path, int type);
            
        }
        
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qqmlabstracturlinterceptor.html#QQmlAbstractUrlInterceptor">QQmlAbstractUrlInterceptor::QQmlAbstractUrlInterceptor()</a></p>
         */
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QQmlAbstractUrlInterceptor instance);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qqmlabstracturlinterceptor.html#intercept">QQmlAbstractUrlInterceptor::intercept(QUrl,QQmlAbstractUrlInterceptor::DataType)</a></p>
         */
        @io.qt.QtUninvokable
        public abstract io.qt.core.QUrl intercept(io.qt.core.QUrl path, io.qt.qml.QQmlAbstractUrlInterceptor.DataType type);
        
        private native static io.qt.core.QUrl intercept_native_cref_QUrl_QQmlAbstractUrlInterceptor_DataType(long __this__nativeId, long path, int type);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlabstracturlinterceptor.html#intercept">QQmlAbstractUrlInterceptor::intercept(QUrl,QQmlAbstractUrlInterceptor::DataType)</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.core.QUrl intercept(io.qt.core.QUrl path, io.qt.qml.QQmlAbstractUrlInterceptor.DataType type);
    
}
