package io.qt.qml;


/**
 * <p>Instances drive the progress of QQmlIncubators</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qqmlincubationcontroller.html">QQmlIncubationController</a></p>
 * <p>Following function is protected in the Qt interface, all implementations of this interface may implement this function:</p>
 * <br>
 * <code>
 * &commat;io.qt.QtUninvokable<br>
 * protected void incubatingObjectCountChanged(int arg__1){<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;QQmlIncubationController.MemberAccess.of(this).incubatingObjectCountChanged(arg__1);<br>
 * }<br>
 * <br>
 * </code>
 */
public interface QQmlIncubationController extends io.qt.QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.qml.QQmlIncubationController}</p>
     */
    public static class Impl extends io.qt.QtObject
        implements io.qt.qml.QQmlIncubationController
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @io.qt.QtPropertyMember(enabled=false)
        private Object __rcWhileFlag = null;
        
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qqmlincubationcontroller.html#QQmlIncubationController-1">QQmlIncubationController::</a></p>
         */
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QQmlIncubationController instance);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qqmlincubationcontroller.html#engine">QQmlIncubationController::</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.qml.QQmlEngine engine(){
            return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static io.qt.qml.QQmlEngine engine_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qqmlincubationcontroller.html#incubateFor">QQmlIncubationController::</a></p>
         */
        @io.qt.QtUninvokable
        public final void incubateFor(int msecs){
            incubateFor_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), msecs);
        }
        
        private native static void incubateFor_native_int(long __this__nativeId, int msecs);
        
        /**
         * <p>Overloaded function for {@link #incubateWhile(io.qt.qml.QQmlIncubationController.WhileFlag, int)}
         *  with <code>msecs = 0</code>.</p>
         */
        @io.qt.QtUninvokable
        public final void incubateWhile(io.qt.qml.QQmlIncubationController.WhileFlag flag) {
            incubateWhile(flag, (int)0);
        }
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qqmlincubationcontroller.html#incubateWhile">QQmlIncubationController::</a></p>
         */
        @io.qt.QtUninvokable
        public final void incubateWhile(io.qt.qml.QQmlIncubationController.WhileFlag flag, int msecs){
            java.util.Objects.requireNonNull(flag, "Argument 'flag': null not expected.");
            incubateWhile_native_std_atomic_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), flag, msecs);
            __rcWhileFlag = flag;
        }
        
        private native static void incubateWhile_native_std_atomic_ptr_int(long __this__nativeId, io.qt.qml.QQmlIncubationController.WhileFlag flag, int msecs);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qqmlincubationcontroller.html#incubatingObjectCount">QQmlIncubationController::</a></p>
         */
        @io.qt.QtUninvokable
        public final int incubatingObjectCount(){
            return incubatingObjectCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static int incubatingObjectCount_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qqmlincubationcontroller.html#incubatingObjectCountChanged">QQmlIncubationController::</a></p>
         */
        @io.qt.QtUninvokable
        protected void incubatingObjectCountChanged(int arg__1){
            incubatingObjectCountChanged_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
        }
        
        private native static void incubatingObjectCountChanged_native_int(long __this__nativeId, int arg__1);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlincubationcontroller.html#engine">QQmlIncubationController::engine()const</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default io.qt.qml.QQmlEngine engine(){
        return Impl.engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlincubationcontroller.html#incubateFor">QQmlIncubationController::incubateFor(int)</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default void incubateFor(int msecs){
        Impl.incubateFor_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), msecs);
    }
    
    /**
     * <p>Overloaded function for {@link #incubateWhile(io.qt.qml.QQmlIncubationController.WhileFlag, int)}
     *  with <code>msecs = 0</code>.</p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default void incubateWhile(io.qt.qml.QQmlIncubationController.WhileFlag flag) {
        incubateWhile(flag, (int)0);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlincubationcontroller.html#incubateWhile">QQmlIncubationController::incubateWhile(std::atomic&lt;bool&gt;*,int)</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default void incubateWhile(io.qt.qml.QQmlIncubationController.WhileFlag flag, int msecs){
        Impl.incubateWhile_native_std_atomic_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), flag, msecs);
        QtJambi_LibraryUtilities.internal.setReferenceCount(this, io.qt.qml.QQmlIncubationController.class, "__rcWhileFlag", false, false, flag);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlincubationcontroller.html#incubatingObjectCount">QQmlIncubationController::incubatingObjectCount()const</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default int incubatingObjectCount(){
        return Impl.incubatingObjectCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    public static class WhileFlag{
        private final long flag;
            public WhileFlag() {
                this(true);
            }
            
            public WhileFlag(boolean flag) {
                long ptr = create(flag);
                this.flag = ptr;
                QtJambi_LibraryUtilities.internal.registerCleaner(this, ()->destroy(ptr));
            }
            
            public void set(boolean flag) {
            	set(this.flag, flag);
            }
            
            private static native long create(boolean flag);
            
            private static native void destroy(long ptr);
            
            private static native void set(long ptr, boolean flag);
        }
    public static class MemberAccess extends io.qt.MemberAccess<QQmlIncubationController> {
        private MemberAccess(QQmlIncubationController instance){
            super(instance);
        }
        
        @io.qt.QtUninvokable
        public void incubatingObjectCountChanged(int arg__1){
            QQmlIncubationController instance = instance();
            QQmlIncubationController.Impl.incubatingObjectCountChanged_native_int(QtJambi_LibraryUtilities.internal.nativeId(instance), arg__1);
        }
        
        public static MemberAccess of(QQmlIncubationController instance){
            Class<?> callerClass = QtJambi_LibraryUtilities.internal.callerClassProvider().get();
            if(!QQmlIncubationController.class.isAssignableFrom(callerClass) || !callerClass.isInstance(instance))
                throw new RuntimeException("Access to restricted functions of class QQmlIncubationController is only granted from inside a user-implemented subclass.");
            return QtJambi_LibraryUtilities.internal.findMemberAccess(instance, QQmlIncubationController.class, MemberAccess.class);
        }
    }
}
