package io.qt.qml;


/**
 * <p>Defines a context within a QML engine</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qqmlcontext.html">QQmlContext</a></p>
 */
public class QQmlContext extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQmlContext.class);
    
    /**
     * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qqmlcontext-propertypair.html">QQmlContext::PropertyPair</a></p>
     */
    public static class PropertyPair extends io.qt.QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public PropertyPair(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(PropertyPair instance);
        
        @io.qt.QtUninvokable
        public final void setName(java.lang.String name){
            setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
        }
        
        @io.qt.QtUninvokable
        private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
        
        @io.qt.QtUninvokable
        public final java.lang.String name(){
            return name_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native java.lang.String name_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setValue(java.lang.Object value){
            setValue_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), value);
        }
        
        @io.qt.QtUninvokable
        private native void setValue_native_cref_QVariant(long __this__nativeId, java.lang.Object value);
        
        @io.qt.QtUninvokable
        public final java.lang.Object value(){
            return value_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native java.lang.Object value_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected PropertyPair(QPrivateConstructor p) { super(p); } 
        
        
        @Override
        public PropertyPair clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native PropertyPair clone_native(long __this_nativeId);
    }

    
    /**
     * <p>Overloaded constructor for {@link #QQmlContext(io.qt.qml.QQmlContext, io.qt.core.QObject)}
     *  with <code>objParent = null</code>.</p>
     */
    public QQmlContext(io.qt.qml.QQmlContext parent) {
        this(parent, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlcontext.html#QQmlContext-1">QQmlContext::QQmlContext(QQmlContext*,QObject*)</a></p>
     */
    public QQmlContext(io.qt.qml.QQmlContext parent, io.qt.core.QObject objParent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent, objParent);
    }
    
    private native static void initialize_native(QQmlContext instance, io.qt.qml.QQmlContext parent, io.qt.core.QObject objParent);
    
    /**
     * <p>Overloaded constructor for {@link #QQmlContext(io.qt.qml.QQmlEngine, io.qt.core.QObject)}
     *  with <code>objParent = null</code>.</p>
     */
    public QQmlContext(io.qt.qml.QQmlEngine parent) {
        this(parent, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlcontext.html#QQmlContext">QQmlContext::QQmlContext(QQmlEngine*,QObject*)</a></p>
     */
    public QQmlContext(io.qt.qml.QQmlEngine parent, io.qt.core.QObject objParent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent, objParent);
    }
    
    private native static void initialize_native(QQmlContext instance, io.qt.qml.QQmlEngine parent, io.qt.core.QObject objParent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlcontext.html#baseUrl">QQmlContext::baseUrl()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl baseUrl(){
        return baseUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl baseUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlcontext.html#contextObject">QQmlContext::contextObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QObject contextObject(){
        return contextObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QObject contextObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlcontext.html#contextProperty">QQmlContext::contextProperty(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object contextProperty(java.lang.String arg__1){
        return contextProperty_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object contextProperty_native_cref_QString_constfct(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlcontext.html#engine">QQmlContext::engine()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QQmlEngine engine(){
        return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QQmlEngine engine_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue importedScript(java.lang.String name){
        return importedScript_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSValue importedScript_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlcontext.html#isValid">QQmlContext::isValid()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlcontext.html#nameForObject">QQmlContext::nameForObject(const QObject*)const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String nameForObject(io.qt.core.QObject arg__1){
        return nameForObject_native_const_QObject_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String nameForObject_native_const_QObject_ptr_constfct(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlcontext.html#objectForName">QQmlContext::objectForName(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QObject objectForName(java.lang.String arg__1){
        return objectForName_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QObject objectForName_native_cref_QString_constfct(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlcontext.html#parentContext">QQmlContext::parentContext()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QQmlContext parentContext(){
        return parentContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QQmlContext parentContext_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlcontext.html#resolvedUrl">QQmlContext::resolvedUrl(QUrl)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl resolvedUrl(io.qt.core.QUrl arg__1){
        return resolvedUrl_native_cref_QUrl_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl resolvedUrl_native_cref_QUrl_constfct(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlcontext.html#setBaseUrl">QQmlContext::setBaseUrl(QUrl)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setBaseUrl(io.qt.core.QUrl arg__1){
        setBaseUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void setBaseUrl_native_cref_QUrl(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlcontext.html#setContextObject">QQmlContext::setContextObject(QObject*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setContextObject(io.qt.core.QObject arg__1){
        setContextObject_native_QObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void setContextObject_native_QObject_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlcontext.html#setContextProperties">QQmlContext::setContextProperties(QList&lt;QQmlContext::PropertyPair&gt;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setContextProperties(java.util.Collection<io.qt.qml.QQmlContext.PropertyPair> properties){
        setContextProperties_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), properties);
    }
    
    @io.qt.QtUninvokable
    private native void setContextProperties_native_cref_QList(long __this__nativeId, java.util.Collection<io.qt.qml.QQmlContext.PropertyPair> properties);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlcontext.html#setContextProperty">QQmlContext::setContextProperty(QString,QObject*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setContextProperty(java.lang.String arg__1, io.qt.core.QObject arg__2){
        setContextProperty_native_cref_QString_QObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1, QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2));
    }
    
    @io.qt.QtUninvokable
    private native void setContextProperty_native_cref_QString_QObject_ptr(long __this__nativeId, java.lang.String arg__1, long arg__2);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlcontext.html#setContextProperty-1">QQmlContext::setContextProperty(QString,QVariant)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setContextProperty(java.lang.String arg__1, java.lang.Object arg__2){
        setContextProperty_native_cref_QString_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1, arg__2);
    }
    
    @io.qt.QtUninvokable
    private native void setContextProperty_native_cref_QString_cref_QVariant(long __this__nativeId, java.lang.String arg__1, java.lang.Object arg__2);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQmlContext(QPrivateConstructor p) { super(p); } 
    
}
