package io.qt.qml;


/**
 * <p>Operates on primitive types in JavaScript semantics</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qjsprimitivevalue.html">QJSPrimitiveValue</a></p>
 */
public class QJSPrimitiveValue extends io.qt.QtObject
    implements java.lang.Comparable<io.qt.qml.QJSPrimitiveValue>,
            java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qjsprimitivevalue.html#Type-enum">QJSPrimitiveValue::Type</a></p>
     */
    public enum Type implements io.qt.QtByteEnumerator {
        Undefined((byte)0),
        Null((byte)1),
        Boolean((byte)2),
        Integer((byte)3),
        Double((byte)4),
        String((byte)5);

        private Type(byte value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public byte value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Type resolve(byte value) {
            switch (value) {
            case 0: return Undefined;
            case 1: return Null;
            case 2: return Boolean;
            case 3: return Integer;
            case 4: return Double;
            case 5: return String;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final byte value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsprimitivevalue.html#QJSPrimitiveValue">QJSPrimitiveValue::QJSPrimitiveValue()</a></p>
     */
    public QJSPrimitiveValue(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QJSPrimitiveValue instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsprimitivevalue.html#QJSPrimitiveValue-6">QJSPrimitiveValue::QJSPrimitiveValue(QString)</a></p>
     */
    public QJSPrimitiveValue(java.lang.String string){
        super((QPrivateConstructor)null);
        initialize_native(this, string);
    }
    
    private native static void initialize_native(QJSPrimitiveValue instance, java.lang.String string);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsprimitivevalue.html#QJSPrimitiveValue-3">QJSPrimitiveValue::QJSPrimitiveValue(bool)</a></p>
     */
    public QJSPrimitiveValue(boolean value){
        super((QPrivateConstructor)null);
        initialize_native(this, value);
    }
    
    private native static void initialize_native(QJSPrimitiveValue instance, boolean value);
    
    public QJSPrimitiveValue(java.lang.Object variant){
        super((QPrivateConstructor)null);
        initialize_native(this, variant);
    }
    
    private native static void initialize_native(QJSPrimitiveValue instance, java.lang.Object variant);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsprimitivevalue.html#QJSPrimitiveValue-5">QJSPrimitiveValue::QJSPrimitiveValue(double)</a></p>
     */
    public QJSPrimitiveValue(double value){
        super((QPrivateConstructor)null);
        initialize_native(this, value);
    }
    
    private native static void initialize_native(QJSPrimitiveValue instance, double value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsprimitivevalue.html#QJSPrimitiveValue-4">QJSPrimitiveValue::QJSPrimitiveValue(int)</a></p>
     */
    public QJSPrimitiveValue(int value){
        super((QPrivateConstructor)null);
        initialize_native(this, value);
    }
    
    private native static void initialize_native(QJSPrimitiveValue instance, int value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsprimitivevalue.html#equals">QJSPrimitiveValue::equals(QJSPrimitiveValue)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean equals(io.qt.qml.QJSPrimitiveValue other){
        return equals_native_cref_QJSPrimitiveValue_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native boolean equals_native_cref_QJSPrimitiveValue_constfct(long __this__nativeId, long other);
    
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSPrimitiveValue modulo(io.qt.qml.QJSPrimitiveValue rhs){
        return modulo_native_cref_QJSPrimitiveValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSPrimitiveValue modulo_native_cref_QJSPrimitiveValue(long __this__nativeId, long rhs);
    
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSPrimitiveValue multiplied(io.qt.qml.QJSPrimitiveValue rhs){
        return multiplied_native_cref_QJSPrimitiveValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSPrimitiveValue multiplied_native_cref_QJSPrimitiveValue(long __this__nativeId, long rhs);
    
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSPrimitiveValue added(io.qt.qml.QJSPrimitiveValue rhs){
        return added_native_cref_QJSPrimitiveValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSPrimitiveValue added_native_cref_QJSPrimitiveValue(long __this__nativeId, long rhs);
    
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSPrimitiveValue incremented(int arg__1){
        return incremented_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSPrimitiveValue incremented_native_int(long __this__nativeId, int arg__1);
    
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSPrimitiveValue substracted(io.qt.qml.QJSPrimitiveValue rhs){
        return substracted_native_cref_QJSPrimitiveValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSPrimitiveValue substracted_native_cref_QJSPrimitiveValue(long __this__nativeId, long rhs);
    
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSPrimitiveValue decremented(int arg__1){
        return decremented_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSPrimitiveValue decremented_native_int(long __this__nativeId, int arg__1);
    
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSPrimitiveValue divided(io.qt.qml.QJSPrimitiveValue rhs){
        return divided_native_cref_QJSPrimitiveValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSPrimitiveValue divided_native_cref_QJSPrimitiveValue(long __this__nativeId, long rhs);
    
    @io.qt.QtUninvokable
    private final boolean operator_less(io.qt.qml.QJSPrimitiveValue rhs){
        return operator_less_native_cref_QJSPrimitiveValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @io.qt.QtUninvokable
    private native boolean operator_less_native_cref_QJSPrimitiveValue(long __this__nativeId, long rhs);
    
    @io.qt.QtUninvokable
    private final boolean operator_equal(io.qt.qml.QJSPrimitiveValue rhs){
        return operator_equal_native_cref_QJSPrimitiveValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @io.qt.QtUninvokable
    private native boolean operator_equal_native_cref_QJSPrimitiveValue(long __this__nativeId, long rhs);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsprimitivevalue.html#strictlyEquals">QJSPrimitiveValue::strictlyEquals(QJSPrimitiveValue)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean strictlyEquals(io.qt.qml.QJSPrimitiveValue other){
        return strictlyEquals_native_cref_QJSPrimitiveValue_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native boolean strictlyEquals_native_cref_QJSPrimitiveValue_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsprimitivevalue.html#toBoolean">QJSPrimitiveValue::toBoolean()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean toBoolean(){
        return toBoolean_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean toBoolean_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsprimitivevalue.html#toDouble">QJSPrimitiveValue::toDouble()const</a></p>
     */
    @io.qt.QtUninvokable
    public final double toDouble(){
        return toDouble_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double toDouble_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsprimitivevalue.html#toInteger">QJSPrimitiveValue::toInteger()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int toInteger(){
        return toInteger_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int toInteger_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsprimitivevalue.html#toString">QJSPrimitiveValue::toString()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String toString(){
        return toString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String toString_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final java.lang.Object toVariant(){
        return toVariant_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object toVariant_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsprimitivevalue.html#type">QJSPrimitiveValue::type()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSPrimitiveValue.Type type(){
        return io.qt.qml.QJSPrimitiveValue.Type.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native byte type_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QJSPrimitiveValue(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.qml.QJSPrimitiveValue) {
            return operator_equal((io.qt.qml.QJSPrimitiveValue) other);
        }

        return false;
    }

    @io.qt.QtUninvokable
    public int compareTo(io.qt.qml.QJSPrimitiveValue other) {
        if (equals(other)) return 0;
        else if (operator_less(other)) return -1;
        else return 1;
    }


    @io.qt.QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    @Override
    public QJSPrimitiveValue clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QJSPrimitiveValue clone_native(long __this_nativeId);
}
