package io.qt.qml;


/**
 * <p>Represents a value on the JavaScript heap belonging to a QJSEngine</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qjsmanagedvalue.html">QJSManagedValue</a></p>
 */
public class QJSManagedValue extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#Type-enum">QJSManagedValue::Type</a></p>
     */
    public enum Type implements io.qt.QtEnumerator {
        Undefined(0),
        Boolean(1),
        Number(2),
        String(3),
        Object(4),
        Symbol(5),
        Function(6);

        private Type(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Type resolve(int value) {
            switch (value) {
            case 0: return Undefined;
            case 1: return Boolean;
            case 2: return Number;
            case 3: return String;
            case 4: return Object;
            case 5: return Symbol;
            case 6: return Function;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#QJSManagedValue-1">QJSManagedValue::QJSManagedValue()</a></p>
     */
    public QJSManagedValue(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QJSManagedValue instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#QJSManagedValue-2">QJSManagedValue::QJSManagedValue(QJSValue,QJSEngine*)</a></p>
     */
    public QJSManagedValue(io.qt.qml.QJSValue value, io.qt.qml.QJSEngine engine){
        super((QPrivateConstructor)null);
        initialize_native(this, value, engine);
    }
    
    private native static void initialize_native(QJSManagedValue instance, io.qt.qml.QJSValue value, io.qt.qml.QJSEngine engine);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#QJSManagedValue-3">QJSManagedValue::QJSManagedValue(QJSPrimitiveValue,QJSEngine*)</a></p>
     */
    public QJSManagedValue(io.qt.qml.QJSPrimitiveValue value, io.qt.qml.QJSEngine engine){
        super((QPrivateConstructor)null);
        initialize_native(this, value, engine);
    }
    
    private native static void initialize_native(QJSManagedValue instance, io.qt.qml.QJSPrimitiveValue value, io.qt.qml.QJSEngine engine);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#QJSManagedValue-5">QJSManagedValue::QJSManagedValue(QString,QJSEngine*)</a></p>
     */
    public QJSManagedValue(java.lang.String string, io.qt.qml.QJSEngine engine){
        super((QPrivateConstructor)null);
        initialize_native(this, string, engine);
    }
    
    private native static void initialize_native(QJSManagedValue instance, java.lang.String string, io.qt.qml.QJSEngine engine);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#QJSManagedValue-4">QJSManagedValue::QJSManagedValue(QVariant,QJSEngine*)</a></p>
     */
    public QJSManagedValue(java.lang.Object variant, io.qt.qml.QJSEngine engine){
        super((QPrivateConstructor)null);
        initialize_native(this, variant, engine);
    }
    
    private native static void initialize_native(QJSManagedValue instance, java.lang.Object variant, io.qt.qml.QJSEngine engine);
    
    /**
     * <p>Overloaded function for {@link #call(java.util.Collection)}
     *  with <code>arguments = java.util.Collections.emptyList()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue call() {
        return call(java.util.Collections.emptyList());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#call">QJSManagedValue::call(QJSValueList)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue call(java.util.Collection<io.qt.qml.QJSValue> arguments){
        return call_native_cref_QList_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arguments);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSValue call_native_cref_QList_constfct(long __this__nativeId, java.util.Collection<io.qt.qml.QJSValue> arguments);
    
    /**
     * <p>Overloaded function for {@link #callAsConstructor(java.util.Collection)}
     *  with <code>arguments = java.util.Collections.emptyList()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue callAsConstructor() {
        return callAsConstructor(java.util.Collections.emptyList());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#callAsConstructor">QJSManagedValue::callAsConstructor(QJSValueList)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue callAsConstructor(java.util.Collection<io.qt.qml.QJSValue> arguments){
        return callAsConstructor_native_cref_QList_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arguments);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSValue callAsConstructor_native_cref_QList_constfct(long __this__nativeId, java.util.Collection<io.qt.qml.QJSValue> arguments);
    
    /**
     * <p>Overloaded function for {@link #callWithInstance(io.qt.qml.QJSValue, java.util.Collection)}
     *  with <code>arguments = java.util.Collections.emptyList()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue callWithInstance(io.qt.qml.QJSValue instance) {
        return callWithInstance(instance, java.util.Collections.emptyList());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#callWithInstance">QJSManagedValue::callWithInstance(QJSValue,QJSValueList)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue callWithInstance(io.qt.qml.QJSValue instance, java.util.Collection<io.qt.qml.QJSValue> arguments){
        return callWithInstance_native_cref_QJSValue_cref_QList_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(instance), arguments);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSValue callWithInstance_native_cref_QJSValue_cref_QList_constfct(long __this__nativeId, long instance, java.util.Collection<io.qt.qml.QJSValue> arguments);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#deleteProperty">QJSManagedValue::deleteProperty(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean deleteProperty(java.lang.String name){
        return deleteProperty_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native boolean deleteProperty_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#deleteProperty-1">QJSManagedValue::deleteProperty(quint32)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean deleteProperty(int arrayIndex){
        return deleteProperty_native_unsigned_int(QtJambi_LibraryUtilities.internal.nativeId(this), arrayIndex);
    }
    
    @io.qt.QtUninvokable
    private native boolean deleteProperty_native_unsigned_int(long __this__nativeId, int arrayIndex);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#engine">QJSManagedValue::engine()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSEngine engine(){
        return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSEngine engine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#equals">QJSManagedValue::equals(QJSManagedValue)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean equals(io.qt.qml.QJSManagedValue other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        return equals_native_cref_QJSManagedValue_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native boolean equals_native_cref_QJSManagedValue_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#hasOwnProperty">QJSManagedValue::hasOwnProperty(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean hasOwnProperty(java.lang.String name){
        return hasOwnProperty_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native boolean hasOwnProperty_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#hasOwnProperty-1">QJSManagedValue::hasOwnProperty(quint32)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean hasOwnProperty(int arrayIndex){
        return hasOwnProperty_native_unsigned_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arrayIndex);
    }
    
    @io.qt.QtUninvokable
    private native boolean hasOwnProperty_native_unsigned_int_constfct(long __this__nativeId, int arrayIndex);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#hasProperty">QJSManagedValue::hasProperty(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean hasProperty(java.lang.String name){
        return hasProperty_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native boolean hasProperty_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#hasProperty-1">QJSManagedValue::hasProperty(quint32)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean hasProperty(int arrayIndex){
        return hasProperty_native_unsigned_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arrayIndex);
    }
    
    @io.qt.QtUninvokable
    private native boolean hasProperty_native_unsigned_int_constfct(long __this__nativeId, int arrayIndex);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#isArray">QJSManagedValue::isArray()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isArray(){
        return isArray_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isArray_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#isBoolean">QJSManagedValue::isBoolean()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isBoolean(){
        return isBoolean_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isBoolean_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#isDate">QJSManagedValue::isDate()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isDate(){
        return isDate_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isDate_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#isError">QJSManagedValue::isError()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isError(){
        return isError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#isFunction">QJSManagedValue::isFunction()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isFunction(){
        return isFunction_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isFunction_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#isInteger">QJSManagedValue::isInteger()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isInteger(){
        return isInteger_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isInteger_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final boolean isJsMetaType(){
        return isJsMetaType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isJsMetaType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#isNull">QJSManagedValue::isNull()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#isNumber">QJSManagedValue::isNumber()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isNumber(){
        return isNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#isObject">QJSManagedValue::isObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isObject(){
        return isObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#isQMetaObject">QJSManagedValue::isQMetaObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isQMetaObject(){
        return isQMetaObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isQMetaObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#isQObject">QJSManagedValue::isQObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isQObject(){
        return isQObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isQObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#isRegularExpression">QJSManagedValue::isRegularExpression()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isRegularExpression(){
        return isRegularExpression_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isRegularExpression_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#isString">QJSManagedValue::isString()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isString(){
        return isString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#isSymbol">QJSManagedValue::isSymbol()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isSymbol(){
        return isSymbol_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isSymbol_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#isUndefined">QJSManagedValue::isUndefined()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isUndefined(){
        return isUndefined_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isUndefined_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#isUrl">QJSManagedValue::isUrl()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isUrl(){
        return isUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#isVariant">QJSManagedValue::isVariant()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isVariant(){
        return isVariant_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isVariant_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #jsMetaInstantiate(java.util.Collection)}
     *  with <code>values = java.util.Collections.emptyList()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSManagedValue jsMetaInstantiate() {
        return jsMetaInstantiate(java.util.Collections.emptyList());
    }
    
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSManagedValue jsMetaInstantiate(java.util.Collection<io.qt.qml.QJSValue> values){
        return jsMetaInstantiate_native_cref_QList_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), values);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSManagedValue jsMetaInstantiate_native_cref_QList_constfct(long __this__nativeId, java.util.Collection<io.qt.qml.QJSValue> values);
    
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList jsMetaMembers(){
        return jsMetaMembers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList jsMetaMembers_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSManagedValue jsMetaType(){
        return jsMetaType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSManagedValue jsMetaType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#property">QJSManagedValue::property(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue property(java.lang.String name){
        return property_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSValue property_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#property-1">QJSManagedValue::property(quint32)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue property(int arrayIndex){
        return property_native_unsigned_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arrayIndex);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSValue property_native_unsigned_int_constfct(long __this__nativeId, int arrayIndex);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#prototype">QJSManagedValue::prototype()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSManagedValue prototype(){
        return prototype_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSManagedValue prototype_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#setProperty">QJSManagedValue::setProperty(QString,QJSValue)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setProperty(java.lang.String name, io.qt.qml.QJSValue value){
        setProperty_native_cref_QString_cref_QJSValue(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setProperty_native_cref_QString_cref_QJSValue(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#setProperty-1">QJSManagedValue::setProperty(quint32,QJSValue)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setProperty(int arrayIndex, io.qt.qml.QJSValue value){
        setProperty_native_unsigned_int_cref_QJSValue(QtJambi_LibraryUtilities.internal.nativeId(this), arrayIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setProperty_native_unsigned_int_cref_QJSValue(long __this__nativeId, int arrayIndex, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#setPrototype">QJSManagedValue::setPrototype(QJSManagedValue)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPrototype(io.qt.qml.QJSManagedValue prototype){
        java.util.Objects.requireNonNull(prototype, "Argument 'prototype': null not expected.");
        setPrototype_native_cref_QJSManagedValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(prototype));
    }
    
    @io.qt.QtUninvokable
    private native void setPrototype_native_cref_QJSManagedValue(long __this__nativeId, long prototype);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#strictlyEquals">QJSManagedValue::strictlyEquals(QJSManagedValue)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean strictlyEquals(io.qt.qml.QJSManagedValue other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        return strictlyEquals_native_cref_QJSManagedValue_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native boolean strictlyEquals_native_cref_QJSManagedValue_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#toBoolean">QJSManagedValue::toBoolean()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean toBoolean(){
        return toBoolean_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean toBoolean_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#toDateTime">QJSManagedValue::toDateTime()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QDateTime toDateTime(){
        return toDateTime_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QDateTime toDateTime_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#toInteger">QJSManagedValue::toInteger()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int toInteger(){
        return toInteger_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int toInteger_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#toJSValue">QJSManagedValue::toJSValue()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue toJSValue(){
        return toJSValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSValue toJSValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#toNumber">QJSManagedValue::toNumber()const</a></p>
     */
    @io.qt.QtUninvokable
    public final double toNumber(){
        return toNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double toNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#toPrimitive">QJSManagedValue::toPrimitive()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSPrimitiveValue toPrimitive(){
        return toPrimitive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSPrimitiveValue toPrimitive_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#toQMetaObject">QJSManagedValue::toQMetaObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QMetaObject toQMetaObject(){
        return toQMetaObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QMetaObject toQMetaObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#toQObject">QJSManagedValue::toQObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QObject toQObject(){
        return toQObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QObject toQObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#toRegularExpression">QJSManagedValue::toRegularExpression()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QRegularExpression toRegularExpression(){
        return toRegularExpression_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRegularExpression toRegularExpression_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#toString">QJSManagedValue::toString()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String toString(){
        return toString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String toString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#toUrl">QJSManagedValue::toUrl()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl toUrl(){
        return toUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl toUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#toVariant">QJSManagedValue::toVariant()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object toVariant(){
        return toVariant_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object toVariant_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsmanagedvalue.html#type">QJSManagedValue::type()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSManagedValue.Type type(){
        return io.qt.qml.QJSManagedValue.Type.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QJSManagedValue(QPrivateConstructor p) { super(p); } 
    
}
