package io.qt.qml;


/**
 * <p>Allows you to set key-value pairs that can be used in QML bindings</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qqmlpropertymap.html">QQmlPropertyMap</a></p>
 */
public class QQmlPropertyMap extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQmlPropertyMap.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlpropertymap.html#valueChanged">QQmlPropertyMap::valueChanged(QString,QVariant)</a></p>
     */
    public final Signal2<java.lang.String, java.lang.Object> valueChanged = new Signal2<>();
    
    /**
     * <p>Overloaded constructor for {@link #QQmlPropertyMap(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QQmlPropertyMap() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlpropertymap.html#QQmlPropertyMap">QQmlPropertyMap::QQmlPropertyMap(QObject*)</a></p>
     */
    public QQmlPropertyMap(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QQmlPropertyMap instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlpropertymap.html#clear">QQmlPropertyMap::clear(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void clear(java.lang.String key){
        clear_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), key);
    }
    
    @io.qt.QtUninvokable
    private native void clear_native_cref_QString(long __this__nativeId, java.lang.String key);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlpropertymap.html#contains">QQmlPropertyMap::contains(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean contains(java.lang.String key){
        return contains_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), key);
    }
    
    @io.qt.QtUninvokable
    private native boolean contains_native_cref_QString_constfct(long __this__nativeId, java.lang.String key);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlpropertymap.html#count">QQmlPropertyMap::count()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int count(){
        return count_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int count_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlpropertymap.html#freeze">QQmlPropertyMap::freeze()</a></p>
     */
    @io.qt.QtUninvokable
    public final void freeze(){
        freeze_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void freeze_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlpropertymap.html#insert-1">QQmlPropertyMap::insert(QVariantHash)</a></p>
     */
    @io.qt.QtUninvokable
    public final void insert(java.util.Map<java.lang.String, java.lang.Object> values){
        insert_native_cref_QHash(QtJambi_LibraryUtilities.internal.nativeId(this), values);
    }
    
    @io.qt.QtUninvokable
    private native void insert_native_cref_QHash(long __this__nativeId, java.util.Map<java.lang.String, java.lang.Object> values);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlpropertymap.html#insert">QQmlPropertyMap::insert(QString,QVariant)</a></p>
     */
    @io.qt.QtUninvokable
    public final void insert(java.lang.String key, java.lang.Object value){
        insert_native_cref_QString_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), key, value);
    }
    
    @io.qt.QtUninvokable
    private native void insert_native_cref_QString_cref_QVariant(long __this__nativeId, java.lang.String key, java.lang.Object value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlpropertymap.html#isEmpty">QQmlPropertyMap::isEmpty()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isEmpty(){
        return isEmpty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isEmpty_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlpropertymap.html#keys">QQmlPropertyMap::keys()const</a></p>
     */
    public final io.qt.core.QStringList keys(){
        return keys_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native io.qt.core.QStringList keys_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlpropertymap.html#size">QQmlPropertyMap::size()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int size(){
        return size_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int size_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlpropertymap.html#value">QQmlPropertyMap::value(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object value(java.lang.String key){
        return value_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), key);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object value_native_cref_QString_constfct(long __this__nativeId, java.lang.String key);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlpropertymap.html#updateValue">QQmlPropertyMap::updateValue(QString,QVariant)</a></p>
     */
    @io.qt.QtUninvokable
    protected java.lang.Object updateValue(java.lang.String key, java.lang.Object input){
        return updateValue_native_cref_QString_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), key, input);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object updateValue_native_cref_QString_cref_QVariant(long __this__nativeId, java.lang.String key, java.lang.Object input);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQmlPropertyMap(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QQmlPropertyMap(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QQmlPropertyMap instance, QDeclarativeConstructor constructor);
    
}
