package io.qt.qml;


/**
 * <p>Allows QML objects to be created asynchronously</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qqmlincubator.html">QQmlIncubator</a></p>
 */
public class QQmlIncubator extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qqmlincubator.html#IncubationMode-enum">QQmlIncubator::IncubationMode</a></p>
     */
    public enum IncubationMode implements io.qt.QtEnumerator {
        Asynchronous(0),
        AsynchronousIfNested(1),
        Synchronous(2);

        private IncubationMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static IncubationMode resolve(int value) {
            switch (value) {
            case 0: return Asynchronous;
            case 1: return AsynchronousIfNested;
            case 2: return Synchronous;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qqmlincubator.html#Status-enum">QQmlIncubator::Status</a></p>
     */
    public enum Status implements io.qt.QtEnumerator {
        Null(0),
        Ready(1),
        Loading(2),
        Error(3);

        private Status(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Status resolve(int value) {
            switch (value) {
            case 0: return Null;
            case 1: return Ready;
            case 2: return Loading;
            case 3: return Error;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #QQmlIncubator(io.qt.qml.QQmlIncubator.IncubationMode)}
     *  with <code>arg__1 = io.qt.qml.QQmlIncubator.IncubationMode.Asynchronous</code>.</p>
     */
    public QQmlIncubator() {
        this(io.qt.qml.QQmlIncubator.IncubationMode.Asynchronous);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlincubator.html#QQmlIncubator-1">QQmlIncubator::QQmlIncubator(QQmlIncubator::IncubationMode)</a></p>
     */
    public QQmlIncubator(io.qt.qml.QQmlIncubator.IncubationMode arg__1){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1);
    }
    
    private native static void initialize_native(QQmlIncubator instance, io.qt.qml.QQmlIncubator.IncubationMode arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlincubator.html#clear">QQmlIncubator::clear()</a></p>
     */
    @io.qt.QtUninvokable
    public final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlincubator.html#errors">QQmlIncubator::errors()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.qml.QQmlError> errors(){
        return errors_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.qml.QQmlError> errors_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlincubator.html#forceCompletion">QQmlIncubator::forceCompletion()</a></p>
     */
    @io.qt.QtUninvokable
    public final void forceCompletion(){
        forceCompletion_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void forceCompletion_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlincubator.html#incubationMode">QQmlIncubator::incubationMode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QQmlIncubator.IncubationMode incubationMode(){
        return io.qt.qml.QQmlIncubator.IncubationMode.resolve(incubationMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int incubationMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlincubator.html#isError">QQmlIncubator::isError()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isError(){
        return isError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlincubator.html#isLoading">QQmlIncubator::isLoading()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isLoading(){
        return isLoading_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isLoading_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlincubator.html#isNull">QQmlIncubator::isNull()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlincubator.html#isReady">QQmlIncubator::isReady()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isReady(){
        return isReady_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isReady_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlincubator.html#object">QQmlIncubator::object()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QObject object(){
        return object_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QObject object_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlincubator.html#setInitialProperties">QQmlIncubator::setInitialProperties(QVariantMap)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setInitialProperties(java.util.Map<java.lang.String, java.lang.Object> initialProperties){
        setInitialProperties_native_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), initialProperties);
    }
    
    @io.qt.QtUninvokable
    private native void setInitialProperties_native_cref_QMap(long __this__nativeId, java.util.Map<java.lang.String, java.lang.Object> initialProperties);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlincubator.html#status">QQmlIncubator::status()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QQmlIncubator.Status status(){
        return io.qt.qml.QQmlIncubator.Status.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlincubator.html#setInitialState">QQmlIncubator::setInitialState(QObject*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void setInitialState(io.qt.core.QObject arg__1){
        setInitialState_native_QObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void setInitialState_native_QObject_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlincubator.html#statusChanged">QQmlIncubator::statusChanged(QQmlIncubator::Status)</a></p>
     */
    @io.qt.QtUninvokable
    protected void statusChanged(io.qt.qml.QQmlIncubator.Status arg__1){
        statusChanged_native_QQmlIncubator_Status(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @io.qt.QtUninvokable
    private native void statusChanged_native_QQmlIncubator_Status(long __this__nativeId, int arg__1);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQmlIncubator(QPrivateConstructor p) { super(p); } 
    
}
