package io.qt.qml;


/**
 * <p>Environment for evaluating JavaScript code</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qjsengine.html">QJSEngine</a></p>
 */
public class QJSEngine extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QJSEngine.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qjsengine.html#Extension-enum">QJSEngine::Extension</a></p>
     * 
     * @see Extensions
     */
    public enum Extension implements io.qt.QtFlagEnumerator {
        TranslationExtension(1),
        ConsoleExtension(2),
        GarbageCollectionExtension(4),
        AllExtensions(-1);

        private Extension(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public Extensions asFlags() {
            return new Extensions(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public Extensions combined(Extension e) {
            return new Extensions(this, e);
        }

        /**
         * Creates a new {@link Extensions} from the entries.
         * @param values entries
         * @return new flag
         */
        public static Extensions flags(Extension ... values) {
            return new Extensions(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Extension resolve(int value) {
            switch (value) {
            case 1: return TranslationExtension;
            case 2: return ConsoleExtension;
            case 4: return GarbageCollectionExtension;
            case -1: return AllExtensions;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link Extension}
     */
    public static final class Extensions extends io.qt.QFlags<Extension> implements Comparable<Extensions> {
        private static final long serialVersionUID = 0x4a861be83a02c55aL;

        /**
         * Creates a new Extensions where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public Extensions(Extension ... args){
            super(args);
        }

        /**
         * Creates a new Extensions with given <code>value</code>.
         * @param value
         */
        public Extensions(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new Extensions
         */
        @Override
        public final Extensions combined(Extension e){
            return new Extensions(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final Extensions setFlag(Extension e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final Extensions setFlag(Extension e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this Extensions.
         * @return array of enum entries
         */
        @Override
        public final Extension[] flags(){
            return super.flags(Extension.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final Extensions clone(){
            return new Extensions(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(Extensions other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qjsengine.html#ObjectOwnership-enum">QJSEngine::ObjectOwnership</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum ObjectOwnership implements io.qt.QtEnumerator {
        CppOwnership(0),
        JavaScriptOwnership(1);

        private ObjectOwnership(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ObjectOwnership resolve(int value) {
            switch (value) {
            case 0: return CppOwnership;
            case 1: return JavaScriptOwnership;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#uiLanguage-prop">QJSEngine::uiLanguageChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="uiLanguage")
    public final Signal0 uiLanguageChanged = new Signal0();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#QJSEngine">QJSEngine::QJSEngine()</a></p>
     */
    public QJSEngine(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QJSEngine instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#QJSEngine-1">QJSEngine::QJSEngine(QObject*)</a></p>
     */
    public QJSEngine(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QJSEngine instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#catchError">QJSEngine::catchError()</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue catchError(){
        return catchError_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSValue catchError_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#collectGarbage">QJSEngine::collectGarbage()</a></p>
     */
    @io.qt.QtUninvokable
    public final void collectGarbage(){
        collectGarbage_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void collectGarbage_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #evaluate(java.lang.String, java.lang.String, int, java.util.Collection)}
     *  with <code>exceptionStackTrace = null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue evaluate(java.lang.String program, java.lang.String fileName, int lineNumber) {
        return evaluate(program, fileName, lineNumber, (java.util.Collection<java.lang.String>)null);
    }
    
    /**
     * <p>Overloaded function for {@link #evaluate(java.lang.String, java.lang.String, int, java.util.Collection)}</p>
     * <p>with: </p><ul>
     * <li><code>lineNumber = 1</code></li>
     * <li><code>exceptionStackTrace = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue evaluate(java.lang.String program, java.lang.String fileName) {
        return evaluate(program, fileName, (int)1, (java.util.Collection<java.lang.String>)null);
    }
    
    /**
     * <p>Overloaded function for {@link #evaluate(java.lang.String, java.lang.String, int, java.util.Collection)}</p>
     * <p>with: </p><ul>
     * <li><code>fileName = ""</code></li>
     * <li><code>lineNumber = 1</code></li>
     * <li><code>exceptionStackTrace = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue evaluate(java.lang.String program) {
        return evaluate(program, "", (int)1, (java.util.Collection<java.lang.String>)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#evaluate">QJSEngine::evaluate(QString,QString,int,QStringList*)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue evaluate(java.lang.String program, java.lang.String fileName, int lineNumber, java.util.Collection<java.lang.String> exceptionStackTrace){
        return evaluate_native_cref_QString_cref_QString_int_QStringList_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, fileName, lineNumber, exceptionStackTrace);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSValue evaluate_native_cref_QString_cref_QString_int_QStringList_ptr(long __this__nativeId, java.lang.String program, java.lang.String fileName, int lineNumber, java.util.Collection<java.lang.String> exceptionStackTrace);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#globalObject">QJSEngine::globalObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue globalObject(){
        return globalObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSValue globalObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#hasError">QJSEngine::hasError()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean hasError(){
        return hasError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean hasError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#importModule">QJSEngine::importModule(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue importModule(java.lang.String fileName){
        return importModule_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), fileName);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSValue importModule_native_cref_QString(long __this__nativeId, java.lang.String fileName);
    
    /**
     * <p>Overloaded function for {@link #installExtensions(io.qt.qml.QJSEngine.Extensions, io.qt.qml.QJSValue)}
     *  with <code>object = new io.qt.qml.QJSValue()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void installExtensions(io.qt.qml.QJSEngine.Extensions extensions) {
        installExtensions(extensions, new io.qt.qml.QJSValue());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#installExtensions">QJSEngine::installExtensions(Extensions,QJSValue)</a></p>
     */
    @io.qt.QtUninvokable
    public final void installExtensions(io.qt.qml.QJSEngine.Extensions extensions, io.qt.qml.QJSValue object){
        installExtensions_native_QFlags_QJSEngine_Extension__cref_QJSValue(QtJambi_LibraryUtilities.internal.nativeId(this), extensions.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(object));
    }
    
    @io.qt.QtUninvokable
    private native void installExtensions_native_QFlags_QJSEngine_Extension__cref_QJSValue(long __this__nativeId, int extensions, long object);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#isInterrupted">QJSEngine::isInterrupted()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isInterrupted(){
        return isInterrupted_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isInterrupted_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #newArray(int)}
     *  with <code>length = 0</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue newArray() {
        return newArray((int)0);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#newArray">QJSEngine::newArray(uint)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue newArray(int length){
        return newArray_native_uint(QtJambi_LibraryUtilities.internal.nativeId(this), length);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSValue newArray_native_uint(long __this__nativeId, int length);
    
    /**
     * <p>Overloaded function for {@link #newErrorObject(io.qt.qml.QJSValue.ErrorType, java.lang.String)}
     *  with <code>message = ""</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue newErrorObject(io.qt.qml.QJSValue.ErrorType errorType) {
        return newErrorObject(errorType, "");
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#newErrorObject">QJSEngine::newErrorObject(QJSValue::ErrorType,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue newErrorObject(io.qt.qml.QJSValue.ErrorType errorType, java.lang.String message){
        return newErrorObject_native_QJSValue_ErrorType_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), errorType.value(), message);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSValue newErrorObject_native_QJSValue_ErrorType_cref_QString(long __this__nativeId, int errorType, java.lang.String message);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#newObject">QJSEngine::newObject()</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue newObject(){
        return newObject_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSValue newObject_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#newQObject">QJSEngine::newQObject(QObject*)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue newQObject(io.qt.core.QObject object){
        return newQObject_native_QObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSValue newQObject_native_QObject_ptr(long __this__nativeId, long object);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#newSymbol">QJSEngine::newSymbol(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qml.QJSValue newSymbol(java.lang.String name){
        return newSymbol_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QJSValue newSymbol_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#registerModule">QJSEngine::registerModule(QString,QJSValue)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean registerModule(java.lang.String moduleName, io.qt.qml.QJSValue value){
        return registerModule_native_cref_QString_cref_QJSValue(QtJambi_LibraryUtilities.internal.nativeId(this), moduleName, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native boolean registerModule_native_cref_QString_cref_QJSValue(long __this__nativeId, java.lang.String moduleName, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#setInterrupted">QJSEngine::setInterrupted(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setInterrupted(boolean interrupted){
        setInterrupted_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), interrupted);
    }
    
    @io.qt.QtUninvokable
    private native void setInterrupted_native_bool(long __this__nativeId, boolean interrupted);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#uiLanguage-prop">QJSEngine::setUiLanguage(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="uiLanguage")
    @io.qt.QtUninvokable
    public final void setUiLanguage(java.lang.String language){
        setUiLanguage_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), language);
    }
    
    @io.qt.QtUninvokable
    private native void setUiLanguage_native_cref_QString(long __this__nativeId, java.lang.String language);
    
    /**
     * <p>Overloaded function for {@link #throwError(io.qt.qml.QJSValue.ErrorType, java.lang.String)}
     *  with <code>message = ""</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void throwError(io.qt.qml.QJSValue.ErrorType errorType) {
        throwError(errorType, "");
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#throwError-1">QJSEngine::throwError(QJSValue::ErrorType,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void throwError(io.qt.qml.QJSValue.ErrorType errorType, java.lang.String message){
        throwError_native_QJSValue_ErrorType_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), errorType.value(), message);
    }
    
    @io.qt.QtUninvokable
    private native void throwError_native_QJSValue_ErrorType_cref_QString(long __this__nativeId, int errorType, java.lang.String message);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#throwError-2">QJSEngine::throwError(QJSValue)</a></p>
     */
    @io.qt.QtUninvokable
    public final void throwError(io.qt.qml.QJSValue error){
        throwError_native_cref_QJSValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(error));
    }
    
    @io.qt.QtUninvokable
    private native void throwError_native_cref_QJSValue(long __this__nativeId, long error);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#throwError">QJSEngine::throwError(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void throwError(java.lang.String message){
        throwError_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), message);
    }
    
    @io.qt.QtUninvokable
    private native void throwError_native_cref_QString(long __this__nativeId, java.lang.String message);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#uiLanguage-prop">QJSEngine::uiLanguage()const</a></p>
     */
    @io.qt.QtPropertyReader(name="uiLanguage")
    @io.qt.QtUninvokable
    public final java.lang.String uiLanguage(){
        return uiLanguage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String uiLanguage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#objectOwnership">QJSEngine::objectOwnership(QObject*)</a></p>
     */
    public static io.qt.qml.QJSEngine.ObjectOwnership objectOwnership(io.qt.core.QObject arg__1){
        return io.qt.qml.QJSEngine.ObjectOwnership.resolve(objectOwnership_native_QObject_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1)));
    }
    
    private native static int objectOwnership_native_QObject_ptr(long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qjsengine.html#setObjectOwnership">QJSEngine::setObjectOwnership(QObject*,QJSEngine::ObjectOwnership)</a></p>
     */
    public static void setObjectOwnership(io.qt.core.QObject arg__1, io.qt.qml.QJSEngine.ObjectOwnership arg__2){
        setObjectOwnership_native_QObject_ptr_QJSEngine_ObjectOwnership(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), arg__2.value());
        if (arg__1 != null && arg__2 != null){
                            switch(arg__2){
                            case CppOwnership: 
                                if(arg__1.parent()==null){
                                    QtJambi_LibraryUtilities.internal.setJavaOwnership(arg__1);
                                }
                            default:
                                QtJambi_LibraryUtilities.internal.setCppOwnership(arg__1);
                            }
                        }
    }
    
    private native static void setObjectOwnership_native_QObject_ptr_QJSEngine_ObjectOwnership(long arg__1, int arg__2);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QJSEngine(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QJSEngine(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QJSEngine instance, QDeclarativeConstructor constructor);
    
}
