package io.qt.printsupport;

import io.qt.*;


/**
 * <p>Paint device that paints on a printer</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qprinter.html">QPrinter</a></code></p>
 */
public class QPrinter extends QtObject
    implements io.qt.gui.QPagedPaintDevice,
            io.qt.gui.QPaintDevice
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcPaintEngine = null;
    @QtPropertyMember(enabled=false)
    private Object __rcPrintEngine = null;
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qprinter.html#ColorMode-enum">QPrinter::ColorMode</a></code></p>
     */
    public enum ColorMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#ColorMode-enum">QPrinter::<wbr>GrayScale</a></code></p>
         */
        GrayScale(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#ColorMode-enum">QPrinter::<wbr>Color</a></code></p>
         */
        Color(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ColorMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ColorMode resolve(int value) {
            switch (value) {
            case 0: return GrayScale;
            case 1: return Color;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qprinter.html#DuplexMode-enum">QPrinter::DuplexMode</a></code></p>
     */
    public enum DuplexMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#DuplexMode-enum">QPrinter::<wbr>DuplexNone</a></code></p>
         */
        DuplexNone(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#DuplexMode-enum">QPrinter::<wbr>DuplexAuto</a></code></p>
         */
        DuplexAuto(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#DuplexMode-enum">QPrinter::<wbr>DuplexLongSide</a></code></p>
         */
        DuplexLongSide(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#DuplexMode-enum">QPrinter::<wbr>DuplexShortSide</a></code></p>
         */
        DuplexShortSide(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DuplexMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull DuplexMode resolve(int value) {
            switch (value) {
            case 0: return DuplexNone;
            case 1: return DuplexAuto;
            case 2: return DuplexLongSide;
            case 3: return DuplexShortSide;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qprinter.html#OutputFormat-enum">QPrinter::OutputFormat</a></code></p>
     */
    public enum OutputFormat implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#OutputFormat-enum">QPrinter::<wbr>NativeFormat</a></code></p>
         */
        NativeFormat(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#OutputFormat-enum">QPrinter::<wbr>PdfFormat</a></code></p>
         */
        PdfFormat(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private OutputFormat(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull OutputFormat resolve(int value) {
            switch (value) {
            case 0: return NativeFormat;
            case 1: return PdfFormat;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qprinter.html#PageOrder-enum">QPrinter::PageOrder</a></code></p>
     */
    public enum PageOrder implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PageOrder-enum">QPrinter::<wbr>FirstPageFirst</a></code></p>
         */
        FirstPageFirst(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PageOrder-enum">QPrinter::<wbr>LastPageFirst</a></code></p>
         */
        LastPageFirst(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PageOrder(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PageOrder resolve(int value) {
            switch (value) {
            case 0: return FirstPageFirst;
            case 1: return LastPageFirst;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qprinter.html#PaperSource-enum">QPrinter::PaperSource</a></code></p>
     */
    @QtRejectedEntries({"LastPaperSource", "Upper"})
    public enum PaperSource implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PaperSource-enum">QPrinter::<wbr>OnlyOne</a></code></p>
         */
        OnlyOne(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PaperSource-enum">QPrinter::<wbr>Lower</a></code></p>
         */
        Lower(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PaperSource-enum">QPrinter::<wbr>Middle</a></code></p>
         */
        Middle(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PaperSource-enum">QPrinter::<wbr>Manual</a></code></p>
         */
        Manual(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PaperSource-enum">QPrinter::<wbr>Envelope</a></code></p>
         */
        Envelope(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PaperSource-enum">QPrinter::<wbr>EnvelopeManual</a></code></p>
         */
        EnvelopeManual(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PaperSource-enum">QPrinter::<wbr>Auto</a></code></p>
         */
        Auto(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PaperSource-enum">QPrinter::<wbr>Tractor</a></code></p>
         */
        Tractor(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PaperSource-enum">QPrinter::<wbr>SmallFormat</a></code></p>
         */
        SmallFormat(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PaperSource-enum">QPrinter::<wbr>LargeFormat</a></code></p>
         */
        LargeFormat(9),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PaperSource-enum">QPrinter::<wbr>LargeCapacity</a></code></p>
         */
        LargeCapacity(10),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PaperSource-enum">QPrinter::<wbr>Cassette</a></code></p>
         */
        Cassette(11),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PaperSource-enum">QPrinter::<wbr>FormSource</a></code></p>
         */
        FormSource(12),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PaperSource-enum">QPrinter::<wbr>MaxPageSource</a></code></p>
         */
        MaxPageSource(13),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PaperSource-enum">QPrinter::<wbr>CustomSource</a></code></p>
         */
        CustomSource(14),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PaperSource-enum">QPrinter::<wbr>LastPaperSource</a></code></p>
         */
        LastPaperSource(14),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PaperSource-enum">QPrinter::<wbr>Upper</a></code></p>
         */
        Upper(0);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PaperSource(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PaperSource resolve(int value) {
            switch (value) {
            case 0: return OnlyOne;
            case 1: return Lower;
            case 2: return Middle;
            case 3: return Manual;
            case 4: return Envelope;
            case 5: return EnvelopeManual;
            case 6: return Auto;
            case 7: return Tractor;
            case 8: return SmallFormat;
            case 9: return LargeFormat;
            case 10: return LargeCapacity;
            case 11: return Cassette;
            case 12: return FormSource;
            case 13: return MaxPageSource;
            case 14: return CustomSource;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qprinter.html#PrintRange-enum">QPrinter::PrintRange</a></code></p>
     */
    public enum PrintRange implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PrintRange-enum">QPrinter::<wbr>AllPages</a></code></p>
         */
        AllPages(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PrintRange-enum">QPrinter::<wbr>Selection</a></code></p>
         */
        Selection(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PrintRange-enum">QPrinter::<wbr>PageRange</a></code></p>
         */
        PageRange(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PrintRange-enum">QPrinter::<wbr>CurrentPage</a></code></p>
         */
        CurrentPage(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PrintRange(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PrintRange resolve(int value) {
            switch (value) {
            case 0: return AllPages;
            case 1: return Selection;
            case 2: return PageRange;
            case 3: return CurrentPage;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qprinter.html#PrinterMode-enum">QPrinter::PrinterMode</a></code></p>
     */
    public enum PrinterMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PrinterMode-enum">QPrinter::<wbr>ScreenResolution</a></code></p>
         */
        ScreenResolution(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PrinterMode-enum">QPrinter::<wbr>PrinterResolution</a></code></p>
         */
        PrinterResolution(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PrinterMode-enum">QPrinter::<wbr>HighResolution</a></code></p>
         */
        HighResolution(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PrinterMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PrinterMode resolve(int value) {
            switch (value) {
            case 0: return ScreenResolution;
            case 1: return PrinterResolution;
            case 2: return HighResolution;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qprinter.html#PrinterState-enum">QPrinter::PrinterState</a></code></p>
     */
    public enum PrinterState implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PrinterState-enum">QPrinter::<wbr>Idle</a></code></p>
         */
        Idle(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PrinterState-enum">QPrinter::<wbr>Active</a></code></p>
         */
        Active(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PrinterState-enum">QPrinter::<wbr>Aborted</a></code></p>
         */
        Aborted(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#PrinterState-enum">QPrinter::<wbr>Error</a></code></p>
         */
        Error(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PrinterState(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PrinterState resolve(int value) {
            switch (value) {
            case 0: return Idle;
            case 1: return Active;
            case 2: return Aborted;
            case 3: return Error;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qprinter.html#Unit-enum">QPrinter::Unit</a></code></p>
     */
    public enum Unit implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#Unit-enum">QPrinter::<wbr>Millimeter</a></code></p>
         */
        Millimeter(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#Unit-enum">QPrinter::<wbr>Point</a></code></p>
         */
        Point(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#Unit-enum">QPrinter::<wbr>Inch</a></code></p>
         */
        Inch(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#Unit-enum">QPrinter::<wbr>Pica</a></code></p>
         */
        Pica(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#Unit-enum">QPrinter::<wbr>Didot</a></code></p>
         */
        Didot(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#Unit-enum">QPrinter::<wbr>Cicero</a></code></p>
         */
        Cicero(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qprinter.html#Unit-enum">QPrinter::<wbr>DevicePixel</a></code></p>
         */
        DevicePixel(6);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Unit(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Unit resolve(int value) {
            switch (value) {
            case 0: return Millimeter;
            case 1: return Point;
            case 2: return Inch;
            case 3: return Pica;
            case 4: return Didot;
            case 5: return Cicero;
            case 6: return DevicePixel;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#QPrinter">QPrinter::<wbr>QPrinter(QPrinter::PrinterMode)</a></code></p>
     */
    public QPrinter(io.qt.printsupport.QPrinter.@NonNull PrinterMode mode){
        super((QPrivateConstructor)null);
        if(io.qt.core.QCoreApplication.instance()==null)
            throw new IllegalStateException("Cannot create QPrinter before initializing QCoreApplication.");
        initialize_native(this, mode);
    }
    
    private native static void initialize_native(QPrinter instance, io.qt.printsupport.QPrinter.PrinterMode mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#QPrinter-1">QPrinter::<wbr>QPrinter(QPrinterInfo,<wbr>QPrinter::PrinterMode)</a></code></p>
     */
    public QPrinter(io.qt.printsupport.@NonNull QPrinterInfo printer, io.qt.printsupport.QPrinter.@NonNull PrinterMode mode){
        super((QPrivateConstructor)null);
        if(io.qt.core.QCoreApplication.instance()==null)
            throw new IllegalStateException("Cannot create QPrinter before initializing QCoreApplication.");
        initialize_native(this, printer, mode);
    }
    
    private native static void initialize_native(QPrinter instance, io.qt.printsupport.QPrinterInfo printer, io.qt.printsupport.QPrinter.PrinterMode mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#abort">QPrinter::<wbr>abort()</a></code></p>
     */
    @QtUninvokable
    public final boolean abort(){
        return abort_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean abort_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#collateCopies">QPrinter::<wbr>collateCopies()const</a></code></p>
     */
    @QtUninvokable
    public final boolean collateCopies(){
        return collateCopies_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean collateCopies_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#colorCount">QPaintDevice::<wbr>colorCount()const</a></code></p>
     */
    @QtUninvokable
    public final int colorCount(){
        return colorCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int colorCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#colorMode">QPrinter::<wbr>colorMode()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.printsupport.QPrinter.@NonNull ColorMode colorMode(){
        return io.qt.printsupport.QPrinter.ColorMode.resolve(colorMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int colorMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#copyCount">QPrinter::<wbr>copyCount()const</a></code></p>
     */
    @QtUninvokable
    public final int copyCount(){
        return copyCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int copyCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#creator">QPrinter::<wbr>creator()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String creator(){
        return creator_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String creator_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#depth">QPaintDevice::<wbr>depth()const</a></code></p>
     */
    @QtUninvokable
    public final int depth(){
        return depth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int depth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#devicePixelRatio">QPaintDevice::<wbr>devicePixelRatio()const</a></code></p>
     */
    @QtUninvokable
    public final double devicePixelRatio(){
        return devicePixelRatio_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static double devicePixelRatio_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#devicePixelRatioF">QPaintDevice::<wbr>devicePixelRatioF()const</a></code></p>
     */
    @QtUninvokable
    public final double devicePixelRatioF(){
        return devicePixelRatioF_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static double devicePixelRatioF_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#docName">QPrinter::<wbr>docName()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String docName(){
        return docName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String docName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#duplex">QPrinter::<wbr>duplex()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.printsupport.QPrinter.@NonNull DuplexMode duplex(){
        return io.qt.printsupport.QPrinter.DuplexMode.resolve(duplex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int duplex_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#fontEmbeddingEnabled">QPrinter::<wbr>fontEmbeddingEnabled()const</a></code></p>
     */
    @QtUninvokable
    public final boolean fontEmbeddingEnabled(){
        return fontEmbeddingEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean fontEmbeddingEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#fromPage">QPrinter::<wbr>fromPage()const</a></code></p>
     */
    @QtUninvokable
    public final int fromPage(){
        return fromPage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int fromPage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#fullPage">QPrinter::<wbr>fullPage()const</a></code></p>
     */
    @QtUninvokable
    public final boolean fullPage(){
        return fullPage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean fullPage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#height">QPaintDevice::<wbr>height()const</a></code></p>
     */
    @QtUninvokable
    public final int height(){
        return height_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int height_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#heightMM">QPaintDevice::<wbr>heightMM()const</a></code></p>
     */
    @QtUninvokable
    public final int heightMM(){
        return heightMM_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int heightMM_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#isValid">QPrinter::<wbr>isValid()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#logicalDpiX">QPaintDevice::<wbr>logicalDpiX()const</a></code></p>
     */
    @QtUninvokable
    public final int logicalDpiX(){
        return logicalDpiX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int logicalDpiX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#logicalDpiY">QPaintDevice::<wbr>logicalDpiY()const</a></code></p>
     */
    @QtUninvokable
    public final int logicalDpiY(){
        return logicalDpiY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int logicalDpiY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#outputFileName">QPrinter::<wbr>outputFileName()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String outputFileName(){
        return outputFileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String outputFileName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#outputFormat">QPrinter::<wbr>outputFormat()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.printsupport.QPrinter.@NonNull OutputFormat outputFormat(){
        return io.qt.printsupport.QPrinter.OutputFormat.resolve(outputFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int outputFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpagedpaintdevice.html#pageLayout">QPagedPaintDevice::<wbr>pageLayout()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QPageLayout pageLayout(){
        return pageLayout_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.gui.QPageLayout pageLayout_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#pageOrder">QPrinter::<wbr>pageOrder()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.printsupport.QPrinter.@NonNull PageOrder pageOrder(){
        return io.qt.printsupport.QPrinter.PageOrder.resolve(pageOrder_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int pageOrder_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpagedpaintdevice.html#pageRanges">QPagedPaintDevice::<wbr>pageRanges()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QPageRanges pageRanges(){
        return pageRanges_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.gui.QPageRanges pageRanges_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#pageRect">QPrinter::<wbr>pageRect(QPrinter::Unit)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QRectF pageRect(io.qt.printsupport.QPrinter.@NonNull Unit arg__1){
        return pageRect_native_QPrinter_Unit_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @QtUninvokable
    private native io.qt.core.QRectF pageRect_native_QPrinter_Unit_constfct(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#paintingActive">QPaintDevice::<wbr>paintingActive()const</a></code></p>
     */
    @QtUninvokable
    public final boolean paintingActive(){
        return paintingActive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static boolean paintingActive_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#paperRect">QPrinter::<wbr>paperRect(QPrinter::Unit)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QRectF paperRect(io.qt.printsupport.QPrinter.@NonNull Unit arg__1){
        return paperRect_native_QPrinter_Unit_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @QtUninvokable
    private native io.qt.core.QRectF paperRect_native_QPrinter_Unit_constfct(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#paperSource">QPrinter::<wbr>paperSource()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.printsupport.QPrinter.@NonNull PaperSource paperSource(){
        return io.qt.printsupport.QPrinter.PaperSource.resolve(paperSource_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int paperSource_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#pdfVersion">QPrinter::<wbr>pdfVersion()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.QPagedPaintDevice.@NonNull PdfVersion pdfVersion(){
        return io.qt.gui.QPagedPaintDevice.PdfVersion.resolve(pdfVersion_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int pdfVersion_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#physicalDpiX">QPaintDevice::<wbr>physicalDpiX()const</a></code></p>
     */
    @QtUninvokable
    public final int physicalDpiX(){
        return physicalDpiX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int physicalDpiX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#physicalDpiY">QPaintDevice::<wbr>physicalDpiY()const</a></code></p>
     */
    @QtUninvokable
    public final int physicalDpiY(){
        return physicalDpiY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int physicalDpiY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#printEngine">QPrinter::<wbr>printEngine()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.printsupport.@Nullable QPrintEngine printEngine(){
        return printEngine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.printsupport.QPrintEngine printEngine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#printProgram">QPrinter::<wbr>printProgram()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String printProgram(){
        return printProgram_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String printProgram_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#printRange">QPrinter::<wbr>printRange()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.printsupport.QPrinter.@NonNull PrintRange printRange(){
        return io.qt.printsupport.QPrinter.PrintRange.resolve(printRange_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int printRange_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#printerName">QPrinter::<wbr>printerName()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String printerName(){
        return printerName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String printerName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#printerSelectionOption">QPrinter::<wbr>printerSelectionOption()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String printerSelectionOption(){
        return printerSelectionOption_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String printerSelectionOption_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#printerState">QPrinter::<wbr>printerState()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.printsupport.QPrinter.@NonNull PrinterState printerState(){
        return io.qt.printsupport.QPrinter.PrinterState.resolve(printerState_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int printerState_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#resolution">QPrinter::<wbr>resolution()const</a></code></p>
     */
    @QtUninvokable
    public final int resolution(){
        return resolution_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int resolution_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#setCollateCopies">QPrinter::<wbr>setCollateCopies(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setCollateCopies(boolean collate){
        setCollateCopies_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), collate);
    }
    
    @QtUninvokable
    private native void setCollateCopies_native_bool(long __this__nativeId, boolean collate);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#setColorMode">QPrinter::<wbr>setColorMode(QPrinter::ColorMode)</a></code></p>
     */
    @QtUninvokable
    public final void setColorMode(io.qt.printsupport.QPrinter.@NonNull ColorMode arg__1){
        setColorMode_native_QPrinter_ColorMode(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @QtUninvokable
    private native void setColorMode_native_QPrinter_ColorMode(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#setCopyCount">QPrinter::<wbr>setCopyCount(int)</a></code></p>
     */
    @QtUninvokable
    public final void setCopyCount(int arg__1){
        setCopyCount_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native void setCopyCount_native_int(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#setCreator">QPrinter::<wbr>setCreator(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setCreator(java.lang.@NonNull String arg__1){
        setCreator_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native void setCreator_native_cref_QString(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#setDocName">QPrinter::<wbr>setDocName(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setDocName(java.lang.@NonNull String arg__1){
        setDocName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native void setDocName_native_cref_QString(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#setDuplex">QPrinter::<wbr>setDuplex(QPrinter::DuplexMode)</a></code></p>
     */
    @QtUninvokable
    public final void setDuplex(io.qt.printsupport.QPrinter.@NonNull DuplexMode duplex){
        setDuplex_native_QPrinter_DuplexMode(QtJambi_LibraryUtilities.internal.nativeId(this), duplex.value());
    }
    
    @QtUninvokable
    private native void setDuplex_native_QPrinter_DuplexMode(long __this__nativeId, int duplex);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#setEngines">QPrinter::<wbr>setEngines(QPrintEngine*,<wbr>QPaintEngine*)</a></code></p>
     */
    @QtUninvokable
    protected final void setEngines(io.qt.printsupport.@Nullable QPrintEngine printEngine, io.qt.gui.@Nullable QPaintEngine paintEngine){
        setEngines_native_QPrintEngine_ptr_QPaintEngine_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(printEngine), QtJambi_LibraryUtilities.internal.checkedNativeId(paintEngine));
        __rcPrintEngine = printEngine;
        __rcPaintEngine = paintEngine;
    }
    
    @QtUninvokable
    private native void setEngines_native_QPrintEngine_ptr_QPaintEngine_ptr(long __this__nativeId, long printEngine, long paintEngine);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#setFontEmbeddingEnabled">QPrinter::<wbr>setFontEmbeddingEnabled(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setFontEmbeddingEnabled(boolean enable){
        setFontEmbeddingEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @QtUninvokable
    private native void setFontEmbeddingEnabled_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#setFromTo">QPrinter::<wbr>setFromTo(int,<wbr>int)</a></code></p>
     */
    @QtUninvokable
    public final void setFromTo(int fromPage, int toPage){
        setFromTo_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), fromPage, toPage);
    }
    
    @QtUninvokable
    private native void setFromTo_native_int_int(long __this__nativeId, int fromPage, int toPage);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#setFullPage">QPrinter::<wbr>setFullPage(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setFullPage(boolean arg__1){
        setFullPage_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native void setFullPage_native_bool(long __this__nativeId, boolean arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#setOutputFileName">QPrinter::<wbr>setOutputFileName(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setOutputFileName(java.lang.@NonNull String arg__1){
        setOutputFileName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native void setOutputFileName_native_cref_QString(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#setOutputFormat">QPrinter::<wbr>setOutputFormat(QPrinter::OutputFormat)</a></code></p>
     */
    @QtUninvokable
    public final void setOutputFormat(io.qt.printsupport.QPrinter.@NonNull OutputFormat format){
        setOutputFormat_native_QPrinter_OutputFormat(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    @QtUninvokable
    private native void setOutputFormat_native_QPrinter_OutputFormat(long __this__nativeId, int format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#setPageOrder">QPrinter::<wbr>setPageOrder(QPrinter::PageOrder)</a></code></p>
     */
    @QtUninvokable
    public final void setPageOrder(io.qt.printsupport.QPrinter.@NonNull PageOrder arg__1){
        setPageOrder_native_QPrinter_PageOrder(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @QtUninvokable
    private native void setPageOrder_native_QPrinter_PageOrder(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#setPaperSource">QPrinter::<wbr>setPaperSource(QPrinter::PaperSource)</a></code></p>
     */
    @QtUninvokable
    public final void setPaperSource(io.qt.printsupport.QPrinter.@NonNull PaperSource arg__1){
        setPaperSource_native_QPrinter_PaperSource(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @QtUninvokable
    private native void setPaperSource_native_QPrinter_PaperSource(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#setPdfVersion">QPrinter::<wbr>setPdfVersion(QPagedPaintDevice::PdfVersion)</a></code></p>
     */
    @QtUninvokable
    public final void setPdfVersion(io.qt.gui.QPagedPaintDevice.@NonNull PdfVersion version){
        setPdfVersion_native_QPagedPaintDevice_PdfVersion(QtJambi_LibraryUtilities.internal.nativeId(this), version.value());
    }
    
    @QtUninvokable
    private native void setPdfVersion_native_QPagedPaintDevice_PdfVersion(long __this__nativeId, int version);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#setPrintProgram">QPrinter::<wbr>setPrintProgram(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setPrintProgram(java.lang.@NonNull String arg__1){
        setPrintProgram_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native void setPrintProgram_native_cref_QString(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#setPrintRange">QPrinter::<wbr>setPrintRange(QPrinter::PrintRange)</a></code></p>
     */
    @QtUninvokable
    public final void setPrintRange(io.qt.printsupport.QPrinter.@NonNull PrintRange range){
        setPrintRange_native_QPrinter_PrintRange(QtJambi_LibraryUtilities.internal.nativeId(this), range.value());
    }
    
    @QtUninvokable
    private native void setPrintRange_native_QPrinter_PrintRange(long __this__nativeId, int range);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#setPrinterName">QPrinter::<wbr>setPrinterName(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setPrinterName(java.lang.@NonNull String arg__1){
        setPrinterName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native void setPrinterName_native_cref_QString(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#setPrinterSelectionOption">QPrinter::<wbr>setPrinterSelectionOption(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setPrinterSelectionOption(java.lang.@NonNull String arg__1){
        setPrinterSelectionOption_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native void setPrinterSelectionOption_native_cref_QString(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#setResolution">QPrinter::<wbr>setResolution(int)</a></code></p>
     */
    @QtUninvokable
    public final void setResolution(int arg__1){
        setResolution_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native void setResolution_native_int(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#supportedResolutions">QPrinter::<wbr>supportedResolutions()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Integer> supportedResolutions(){
        return supportedResolutions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.@QtPrimitiveType Integer> supportedResolutions_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#supportsMultipleCopies">QPrinter::<wbr>supportsMultipleCopies()const</a></code></p>
     */
    @QtUninvokable
    public final boolean supportsMultipleCopies(){
        return supportsMultipleCopies_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean supportsMultipleCopies_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprinter.html#toPage">QPrinter::<wbr>toPage()const</a></code></p>
     */
    @QtUninvokable
    public final int toPage(){
        return toPage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int toPage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#width">QPaintDevice::<wbr>width()const</a></code></p>
     */
    @QtUninvokable
    public final int width(){
        return width_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int width_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#widthMM">QPaintDevice::<wbr>widthMM()const</a></code></p>
     */
    @QtUninvokable
    public final int widthMM(){
        return widthMM_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int widthMM_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QPaintDevice::<wbr>initPainter(QPainter*)const</code></p>
     */
    @QtUninvokable
    protected void initPainter(io.qt.gui.@Nullable QPainter painter){
        initPainter_native_QPainter_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(painter));
    }
    
    private native static void initPainter_native_QPainter_ptr_constfct(long __this__nativeId, long painter);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#metric">QPaintDevice::<wbr>metric(QPaintDevice::PaintDeviceMetric)const</a></code></p>
     */
    @QtUninvokable
    protected int metric(io.qt.gui.QPaintDevice.@NonNull PaintDeviceMetric arg__1){
        return metric_native_QPaintDevice_PaintDeviceMetric_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    private native static int metric_native_QPaintDevice_PaintDeviceMetric_constfct(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpagedpaintdevice.html#newPage">QPagedPaintDevice::<wbr>newPage()</a></code></p>
     */
    @QtUninvokable
    @Override
    public boolean newPage(){
        return newPage_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static boolean newPage_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#paintEngine">QPaintDevice::<wbr>paintEngine()const</a></code></p>
     */
    @QtUninvokable
    @Override
    public io.qt.gui.@Nullable QPaintEngine paintEngine(){
        return paintEngine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.gui.QPaintEngine paintEngine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QPaintDevice::<wbr>redirected(QPoint*)const</code></p>
     */
    @QtUninvokable
    protected io.qt.gui.@Nullable QPaintDevice redirected(io.qt.core.@Nullable QPoint offset){
        return redirected_native_QPoint_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(offset));
    }
    
    private native static io.qt.gui.QPaintDevice redirected_native_QPoint_ptr_constfct(long __this__nativeId, long offset);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpagedpaintdevice.html#setPageLayout">QPagedPaintDevice::<wbr>setPageLayout(QPageLayout)</a></code></p>
     */
    @QtUninvokable
    public boolean setPageLayout(io.qt.gui.@NonNull QPageLayout pageLayout){
        return setPageLayout_native_cref_QPageLayout(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pageLayout));
    }
    
    private native static boolean setPageLayout_native_cref_QPageLayout(long __this__nativeId, long pageLayout);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpagedpaintdevice.html#setPageMargins">QPagedPaintDevice::<wbr>setPageMargins(QMarginsF,<wbr>QPageLayout::Unit)</a></code></p>
     */
    @QtUninvokable
    public boolean setPageMargins(io.qt.core.@NonNull QMarginsF margins, io.qt.gui.QPageLayout.@NonNull Unit units){
        return setPageMargins_native_cref_QMarginsF_QPageLayout_Unit(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(margins), units.value());
    }
    
    private native static boolean setPageMargins_native_cref_QMarginsF_QPageLayout_Unit(long __this__nativeId, long margins, int units);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpagedpaintdevice.html#setPageOrientation">QPagedPaintDevice::<wbr>setPageOrientation(QPageLayout::Orientation)</a></code></p>
     */
    @QtUninvokable
    public boolean setPageOrientation(io.qt.gui.QPageLayout.@NonNull Orientation orientation){
        return setPageOrientation_native_QPageLayout_Orientation(QtJambi_LibraryUtilities.internal.nativeId(this), orientation.value());
    }
    
    private native static boolean setPageOrientation_native_QPageLayout_Orientation(long __this__nativeId, int orientation);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpagedpaintdevice.html#setPageRanges">QPagedPaintDevice::<wbr>setPageRanges(QPageRanges)</a></code></p>
     */
    @QtUninvokable
    public void setPageRanges(io.qt.gui.@NonNull QPageRanges ranges){
        setPageRanges_native_cref_QPageRanges(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(ranges));
    }
    
    private native static void setPageRanges_native_cref_QPageRanges(long __this__nativeId, long ranges);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpagedpaintdevice.html#setPageSize">QPagedPaintDevice::<wbr>setPageSize(QPageSize)</a></code></p>
     */
    @QtUninvokable
    public boolean setPageSize(io.qt.gui.@NonNull QPageSize pageSize){
        return setPageSize_native_cref_QPageSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pageSize));
    }
    
    private native static boolean setPageSize_native_cref_QPageSize(long __this__nativeId, long pageSize);
    
    /**
     * <p>See <code>QPaintDevice::<wbr>sharedPainter()const</code></p>
     */
    @QtUninvokable
    protected io.qt.gui.@Nullable QPainter sharedPainter(){
        return sharedPainter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.gui.QPainter sharedPainter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QPaintDevice::<wbr>devicePixelRatioFScale()</code></p>
     */
    public native static double devicePixelRatioFScale();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QPrinter(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Overloaded constructor for {@link #QPrinter(io.qt.printsupport.QPrinter.PrinterMode)}
     *  with <code>mode = io.qt.printsupport.QPrinter.PrinterMode.ScreenResolution</code>.</p>
     */
    public QPrinter() {
        this(io.qt.printsupport.QPrinter.PrinterMode.ScreenResolution);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QPrinter(io.qt.printsupport.QPrinterInfo, io.qt.printsupport.QPrinter.PrinterMode)}
     *  with <code>mode = io.qt.printsupport.QPrinter.PrinterMode.ScreenResolution</code>.</p>
     */
    public QPrinter(io.qt.printsupport.@NonNull QPrinterInfo printer) {
        this(printer, io.qt.printsupport.QPrinter.PrinterMode.ScreenResolution);
    }
    
    /**
     * <p>Overloaded function for {@link #setPageMargins(io.qt.core.QMarginsF, io.qt.gui.QPageLayout.Unit)}
     *  with <code>units = io.qt.gui.QPageLayout.Unit.Millimeter</code>.</p>
     */
    @QtUninvokable
    public final boolean setPageMargins(io.qt.core.@NonNull QMarginsF margins) {
        return setPageMargins(margins, io.qt.gui.QPageLayout.Unit.Millimeter);
    }
}
