package io.qt.printsupport;

import io.qt.*;


/**
 * <p>Dialog for specifying the printer's configuration</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qprintdialog.html">QPrintDialog</a></code></p>
 */
public class QPrintDialog extends io.qt.printsupport.QAbstractPrintDialog
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPrintDialog.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprintdialog.html#accepted">QPrintDialog::<wbr>accepted(QPrinter*)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.printsupport.@Nullable QPrinter> accepted = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprintdialog.html#QPrintDialog">QPrintDialog::<wbr>QPrintDialog(QPrinter*,<wbr>QWidget*)</a></code></p>
     */
    public QPrintDialog(io.qt.printsupport.@Nullable QPrinter printer, io.qt.widgets.@Nullable QWidget parent){
        super((QPrivateConstructor)null);
        initialize_native(this, printer, parent);
    }
    
    private native static void initialize_native(QPrintDialog instance, io.qt.printsupport.QPrinter printer, io.qt.widgets.QWidget parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprintdialog.html#QPrintDialog-1">QPrintDialog::<wbr>QPrintDialog(QWidget*)</a></code></p>
     */
    public QPrintDialog(io.qt.widgets.@Nullable QWidget parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QPrintDialog instance, io.qt.widgets.QWidget parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprintdialog.html#options-prop">QPrintDialog::<wbr>options()const</a></code></p>
     */
    @QtPropertyReader(name="options")
    @QtUninvokable
    public final io.qt.printsupport.QAbstractPrintDialog.@NonNull PrintDialogOptions options(){
        return new io.qt.printsupport.QAbstractPrintDialog.PrintDialogOptions(options_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int options_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprintdialog.html#setOption">QPrintDialog::<wbr>setOption(QAbstractPrintDialog::PrintDialogOption,<wbr>bool)</a></code></p>
     */
    @QtUninvokable
    public final void setOption(io.qt.printsupport.QAbstractPrintDialog.@NonNull PrintDialogOption option, boolean on){
        setOption_native_QAbstractPrintDialog_PrintDialogOption_bool(QtJambi_LibraryUtilities.internal.nativeId(this), option.value(), on);
    }
    
    @QtUninvokable
    private native void setOption_native_QAbstractPrintDialog_PrintDialogOption_bool(long __this__nativeId, int option, boolean on);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprintdialog.html#options-prop">QPrintDialog::<wbr>setOptions(QAbstractPrintDialog::PrintDialogOptions)</a></code></p>
     */
    @QtPropertyWriter(name="options")
    @QtUninvokable
    public final void setOptions(io.qt.printsupport.QAbstractPrintDialog.@NonNull PrintDialogOptions options){
        setOptions_native_QAbstractPrintDialog_PrintDialogOptions(QtJambi_LibraryUtilities.internal.nativeId(this), options.value());
    }
    
    @QtUninvokable
    private native void setOptions_native_QAbstractPrintDialog_PrintDialogOptions(long __this__nativeId, int options);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qprintdialog.html#testOption">QPrintDialog::<wbr>testOption(QAbstractPrintDialog::PrintDialogOption)const</a></code></p>
     */
    @QtUninvokable
    public final boolean testOption(io.qt.printsupport.QAbstractPrintDialog.@NonNull PrintDialogOption option){
        return testOption_native_QAbstractPrintDialog_PrintDialogOption_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), option.value());
    }
    
    @QtUninvokable
    private native boolean testOption_native_QAbstractPrintDialog_PrintDialogOption_constfct(long __this__nativeId, int option);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdialog.html#accept">QDialog::<wbr>accept()</a></code></p>
     */
    @QtUninvokable
    public void accept(){
        accept_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void accept_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdialog.html#done">QDialog::<wbr>done(int)</a></code></p>
     */
    @QtUninvokable
    @Override
    public void done(int result){
        done_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), result);
    }
    
    @QtUninvokable
    private native void done_native_int(long __this__nativeId, int result);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdialog.html#exec">QDialog::<wbr>exec()</a></code></p>
     */
    @QtUninvokable
    @Override
    public int exec(){
        return exec_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int exec_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QPrintDialog(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QPrintDialog(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QPrintDialog instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QPrintDialog(io.qt.printsupport.QPrinter, io.qt.widgets.QWidget)}
     *  with <code>parent = null</code>.</p>
     */
    public QPrintDialog(io.qt.printsupport.@Nullable QPrinter printer) {
        this(printer, (io.qt.widgets.QWidget)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QPrintDialog(io.qt.widgets.QWidget)}
     *  with <code>parent = null</code>.</p>
     */
    public QPrintDialog() {
        this((io.qt.widgets.QWidget)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #options()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.printsupport.QAbstractPrintDialog.@NonNull PrintDialogOptions getOptions() {
        return options();
    }
    
    /**
     * <p>Overloaded function for {@link #setOption(io.qt.printsupport.QAbstractPrintDialog.PrintDialogOption, boolean)}
     *  with <code>on = true</code>.</p>
     */
    @QtUninvokable
    public final void setOption(io.qt.printsupport.QAbstractPrintDialog.@NonNull PrintDialogOption option) {
        setOption(option, (boolean)true);
    }
    
    /**
     * <p>Overloaded function for {@link #setOptions(io.qt.printsupport.QAbstractPrintDialog.PrintDialogOptions)}.</p>
     */
    @QtUninvokable
    public final void setOptions(io.qt.printsupport.QAbstractPrintDialog.@NonNull PrintDialogOption @NonNull... options) {
        setOptions(new io.qt.printsupport.QAbstractPrintDialog.PrintDialogOptions(options));
    }
}
