package io.qt.printsupport;

import io.qt.*;


/**
 * <p>Base implementation for print dialogs used to configure printers</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html">QAbstractPrintDialog</a></code></p>
 */
public class QAbstractPrintDialog extends io.qt.widgets.QDialog
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractPrintDialog.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#PrintDialogOption-enum">QAbstractPrintDialog::PrintDialogOption</a></code></p>
     * 
     * @see PrintDialogOptions
     */
    public enum PrintDialogOption implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#PrintDialogOption-enum">QAbstractPrintDialog::<wbr>PrintToFile</a></code></p>
         */
        PrintToFile(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#PrintDialogOption-enum">QAbstractPrintDialog::<wbr>PrintSelection</a></code></p>
         */
        PrintSelection(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#PrintDialogOption-enum">QAbstractPrintDialog::<wbr>PrintPageRange</a></code></p>
         */
        PrintPageRange(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#PrintDialogOption-enum">QAbstractPrintDialog::<wbr>PrintShowPageSize</a></code></p>
         */
        PrintShowPageSize(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#PrintDialogOption-enum">QAbstractPrintDialog::<wbr>PrintCollateCopies</a></code></p>
         */
        PrintCollateCopies(16),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#PrintDialogOption-enum">QAbstractPrintDialog::<wbr>PrintCurrentPage</a></code></p>
         */
        PrintCurrentPage(64);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PrintDialogOption(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull PrintDialogOptions asFlags() {
            return new PrintDialogOptions(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull PrintDialogOptions combined(@NonNull PrintDialogOption e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull PrintDialogOptions cleared(@NonNull PrintDialogOption e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link PrintDialogOptions} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull PrintDialogOptions flags(@Nullable PrintDialogOption @NonNull... values) {
            return new PrintDialogOptions(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PrintDialogOption resolve(int value) {
            switch (value) {
            case 1: return PrintToFile;
            case 2: return PrintSelection;
            case 4: return PrintPageRange;
            case 8: return PrintShowPageSize;
            case 16: return PrintCollateCopies;
            case 64: return PrintCurrentPage;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link PrintDialogOption}
     */
    public static final class PrintDialogOptions extends QFlags<PrintDialogOption> implements Comparable<PrintDialogOptions> {
        private static final long serialVersionUID = 0xe8a339595a9c2774L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new PrintDialogOptions where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public PrintDialogOptions(@Nullable PrintDialogOption @NonNull... args){
            super(args);
        }

        /**
         * Creates a new PrintDialogOptions with given <code>value</code>.
         * @param value
         */
        public PrintDialogOptions(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new PrintDialogOptions
         */
        @Override
        public final @NonNull PrintDialogOptions combined(@StrictNonNull PrintDialogOption e){
            return new PrintDialogOptions(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull PrintDialogOptions setFlag(@Nullable PrintDialogOption e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull PrintDialogOptions setFlag(@Nullable PrintDialogOption e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this PrintDialogOptions.
         * @return array of enum entries
         */
        @Override
        public final @NonNull PrintDialogOption @NonNull[] flags(){
            return super.flags(PrintDialogOption.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull PrintDialogOptions clone(){
            return new PrintDialogOptions(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull PrintDialogOptions other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#PrintRange-enum">QAbstractPrintDialog::PrintRange</a></code></p>
     */
    @QtUnlistedEnum
    public enum PrintRange implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#PrintRange-enum">QAbstractPrintDialog::<wbr>AllPages</a></code></p>
         */
        AllPages(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#PrintRange-enum">QAbstractPrintDialog::<wbr>Selection</a></code></p>
         */
        Selection(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#PrintRange-enum">QAbstractPrintDialog::<wbr>PageRange</a></code></p>
         */
        PageRange(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#PrintRange-enum">QAbstractPrintDialog::<wbr>CurrentPage</a></code></p>
         */
        CurrentPage(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PrintRange(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PrintRange resolve(int value) {
            switch (value) {
            case 0: return AllPages;
            case 1: return Selection;
            case 2: return PageRange;
            case 3: return CurrentPage;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#QAbstractPrintDialog">QAbstractPrintDialog::<wbr>QAbstractPrintDialog(QPrinter*,<wbr>QWidget*)</a></code></p>
     */
    public QAbstractPrintDialog(io.qt.printsupport.@Nullable QPrinter printer, io.qt.widgets.@Nullable QWidget parent){
        super((QPrivateConstructor)null);
        initialize_native(this, printer, parent);
    }
    
    private native static void initialize_native(QAbstractPrintDialog instance, io.qt.printsupport.QPrinter printer, io.qt.widgets.QWidget parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#fromPage">QAbstractPrintDialog::<wbr>fromPage()const</a></code></p>
     */
    @QtUninvokable
    public final int fromPage(){
        return fromPage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int fromPage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#maxPage">QAbstractPrintDialog::<wbr>maxPage()const</a></code></p>
     */
    @QtUninvokable
    public final int maxPage(){
        return maxPage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxPage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#minPage">QAbstractPrintDialog::<wbr>minPage()const</a></code></p>
     */
    @QtUninvokable
    public final int minPage(){
        return minPage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int minPage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#printRange">QAbstractPrintDialog::<wbr>printRange()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.printsupport.QAbstractPrintDialog.@NonNull PrintRange printRange(){
        return io.qt.printsupport.QAbstractPrintDialog.PrintRange.resolve(printRange_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int printRange_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#printer">QAbstractPrintDialog::<wbr>printer()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.printsupport.@Nullable QPrinter printer(){
        return printer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.printsupport.QPrinter printer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#setFromTo">QAbstractPrintDialog::<wbr>setFromTo(int,<wbr>int)</a></code></p>
     */
    @QtUninvokable
    public final void setFromTo(int fromPage, int toPage){
        setFromTo_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), fromPage, toPage);
    }
    
    @QtUninvokable
    private native void setFromTo_native_int_int(long __this__nativeId, int fromPage, int toPage);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#setMinMax">QAbstractPrintDialog::<wbr>setMinMax(int,<wbr>int)</a></code></p>
     */
    @QtUninvokable
    public final void setMinMax(int min, int max){
        setMinMax_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), min, max);
    }
    
    @QtUninvokable
    private native void setMinMax_native_int_int(long __this__nativeId, int min, int max);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#setOptionTabs">QAbstractPrintDialog::<wbr>setOptionTabs(QList&lt;QWidget*&gt;)</a></code></p>
     */
    @QtUninvokable
    public final void setOptionTabs(java.util.@NonNull Collection<? extends io.qt.widgets.@Nullable QWidget> tabs){
        setOptionTabs_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), tabs);
    }
    
    @QtUninvokable
    private native void setOptionTabs_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.widgets.QWidget> tabs);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#setPrintRange">QAbstractPrintDialog::<wbr>setPrintRange(QAbstractPrintDialog::PrintRange)</a></code></p>
     */
    @QtUninvokable
    public final void setPrintRange(io.qt.printsupport.QAbstractPrintDialog.@NonNull PrintRange range){
        setPrintRange_native_QAbstractPrintDialog_PrintRange(QtJambi_LibraryUtilities.internal.nativeId(this), range.value());
    }
    
    @QtUninvokable
    private native void setPrintRange_native_QAbstractPrintDialog_PrintRange(long __this__nativeId, int range);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractprintdialog.html#toPage">QAbstractPrintDialog::<wbr>toPage()const</a></code></p>
     */
    @QtUninvokable
    public final int toPage(){
        return toPage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int toPage_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAbstractPrintDialog(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractPrintDialog(io.qt.printsupport.QPrinter, io.qt.widgets.QWidget)}
     *  with <code>parent = null</code>.</p>
     */
    public QAbstractPrintDialog(io.qt.printsupport.@Nullable QPrinter printer) {
        this(printer, (io.qt.widgets.QWidget)null);
    }
}
