package io.qt.printsupport;


/**
 * <p>Defines an interface for how QPrinter interacts with a given printing subsystem</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qprintengine.html">QPrintEngine</a></p>
 */
public abstract class QPrintEngine extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QPrintEngine {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public boolean abort(){
            return abort_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native boolean abort_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public int metric(io.qt.gui.QPaintDevice.PaintDeviceMetric arg__1){
            return metric_native_QPaintDevice_PaintDeviceMetric_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
        }
        @io.qt.QtUninvokable
        private native int metric_native_QPaintDevice_PaintDeviceMetric_constfct(long __this__nativeId, int arg__1);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean newPage(){
            return newPage_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native boolean newPage_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.printsupport.QPrinter.PrinterState printerState(){
            return io.qt.printsupport.QPrinter.PrinterState.resolve(printerState_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        @io.qt.QtUninvokable
        private native int printerState_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public java.lang.Object property(io.qt.printsupport.QPrintEngine.PrintEnginePropertyKey key){
            return property_native_QPrintEngine_PrintEnginePropertyKey_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), key.value());
        }
        @io.qt.QtUninvokable
        private native java.lang.Object property_native_QPrintEngine_PrintEnginePropertyKey_constfct(long __this__nativeId, int key);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setProperty(io.qt.printsupport.QPrintEngine.PrintEnginePropertyKey key, java.lang.Object value){
            setProperty_native_QPrintEngine_PrintEnginePropertyKey_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), key.value(), value);
        }
        @io.qt.QtUninvokable
        private native void setProperty_native_QPrintEngine_PrintEnginePropertyKey_cref_QVariant(long __this__nativeId, int key, java.lang.Object value);
        
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::PrintEnginePropertyKey</a></p>
     */
    @io.qt.QtRejectedEntries({"PPK_PaperSize"})
    public enum PrintEnginePropertyKey implements io.qt.QtEnumerator {
        PPK_CollateCopies(0),
        PPK_ColorMode(1),
        PPK_Creator(2),
        PPK_DocumentName(3),
        PPK_FullPage(4),
        PPK_NumberOfCopies(5),
        PPK_Orientation(6),
        PPK_OutputFileName(7),
        PPK_PageOrder(8),
        PPK_PageRect(9),
        PPK_PageSize(10),
        PPK_PaperRect(11),
        PPK_PaperSource(12),
        PPK_PrinterName(13),
        PPK_PrinterProgram(14),
        PPK_Resolution(15),
        PPK_SelectionOption(16),
        PPK_SupportedResolutions(17),
        PPK_WindowsPageSize(18),
        PPK_FontEmbedding(19),
        PPK_Duplex(20),
        PPK_PaperSources(21),
        PPK_CustomPaperSize(22),
        PPK_PageMargins(23),
        PPK_CopyCount(24),
        PPK_SupportsMultipleCopies(25),
        PPK_PaperName(26),
        PPK_QPageSize(27),
        PPK_QPageMargins(28),
        PPK_QPageLayout(29),
        PPK_PaperSize(10),
        PPK_CustomBase(65280);

        private PrintEnginePropertyKey(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static PrintEnginePropertyKey resolve(int value) {
            switch (value) {
            case 0: return PPK_CollateCopies;
            case 1: return PPK_ColorMode;
            case 2: return PPK_Creator;
            case 3: return PPK_DocumentName;
            case 4: return PPK_FullPage;
            case 5: return PPK_NumberOfCopies;
            case 6: return PPK_Orientation;
            case 7: return PPK_OutputFileName;
            case 8: return PPK_PageOrder;
            case 9: return PPK_PageRect;
            case 10: return PPK_PageSize;
            case 11: return PPK_PaperRect;
            case 12: return PPK_PaperSource;
            case 13: return PPK_PrinterName;
            case 14: return PPK_PrinterProgram;
            case 15: return PPK_Resolution;
            case 16: return PPK_SelectionOption;
            case 17: return PPK_SupportedResolutions;
            case 18: return PPK_WindowsPageSize;
            case 19: return PPK_FontEmbedding;
            case 20: return PPK_Duplex;
            case 21: return PPK_PaperSources;
            case 22: return PPK_CustomPaperSize;
            case 23: return PPK_PageMargins;
            case 24: return PPK_CopyCount;
            case 25: return PPK_SupportsMultipleCopies;
            case 26: return PPK_PaperName;
            case 27: return PPK_QPageSize;
            case 28: return PPK_QPageMargins;
            case 29: return PPK_QPageLayout;
            case 65280: return PPK_CustomBase;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    public QPrintEngine(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QPrintEngine instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qprintengine.html#abort">QPrintEngine::abort()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean abort();
    
    @io.qt.QtUninvokable
    private native boolean abort_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qprintengine.html#metric">QPrintEngine::metric(QPaintDevice::PaintDeviceMetric)const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract int metric(io.qt.gui.QPaintDevice.PaintDeviceMetric arg__1);
    
    @io.qt.QtUninvokable
    private native int metric_native_QPaintDevice_PaintDeviceMetric_constfct(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qprintengine.html#newPage">QPrintEngine::newPage()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean newPage();
    
    @io.qt.QtUninvokable
    private native boolean newPage_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qprintengine.html#printerState">QPrintEngine::printerState()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.printsupport.QPrinter.PrinterState printerState();
    
    @io.qt.QtUninvokable
    private native int printerState_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qprintengine.html#property">QPrintEngine::property(QPrintEngine::PrintEnginePropertyKey)const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.lang.Object property(io.qt.printsupport.QPrintEngine.PrintEnginePropertyKey key);
    
    @io.qt.QtUninvokable
    private native java.lang.Object property_native_QPrintEngine_PrintEnginePropertyKey_constfct(long __this__nativeId, int key);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qprintengine.html#setProperty">QPrintEngine::setProperty(QPrintEngine::PrintEnginePropertyKey,QVariant)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void setProperty(io.qt.printsupport.QPrintEngine.PrintEnginePropertyKey key, java.lang.Object value);
    
    @io.qt.QtUninvokable
    private native void setProperty_native_QPrintEngine_PrintEnginePropertyKey_cref_QVariant(long __this__nativeId, int key, java.lang.Object value);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QPrintEngine(QPrivateConstructor p) { super(p); } 
    
}
