package io.qt.printsupport;

import io.qt.*;


/**
 * <p>Widget for previewing page layouts for printer output</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html">QPrintPreviewWidget</a></code></p>
 */
public class QPrintPreviewWidget extends io.qt.widgets.QWidget
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPrintPreviewWidget.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#ViewMode-enum">QPrintPreviewWidget::ViewMode</a></code></p>
     */
    @QtUnlistedEnum
    public enum ViewMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#ViewMode-enum">QPrintPreviewWidget::<wbr/>SinglePageView</a></code></p>
         */
        SinglePageView(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#ViewMode-enum">QPrintPreviewWidget::<wbr/>FacingPagesView</a></code></p>
         */
        FacingPagesView(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#ViewMode-enum">QPrintPreviewWidget::<wbr/>AllPagesView</a></code></p>
         */
        AllPagesView(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ViewMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ViewMode resolve(int value) {
            switch (value) {
            case 0: return SinglePageView;
            case 1: return FacingPagesView;
            case 2: return AllPagesView;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#ZoomMode-enum">QPrintPreviewWidget::ZoomMode</a></code></p>
     */
    @QtUnlistedEnum
    public enum ZoomMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#ZoomMode-enum">QPrintPreviewWidget::<wbr/>CustomZoom</a></code></p>
         */
        CustomZoom(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#ZoomMode-enum">QPrintPreviewWidget::<wbr/>FitToWidth</a></code></p>
         */
        FitToWidth(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#ZoomMode-enum">QPrintPreviewWidget::<wbr/>FitInView</a></code></p>
         */
        FitInView(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ZoomMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ZoomMode resolve(int value) {
            switch (value) {
            case 0: return CustomZoom;
            case 1: return FitToWidth;
            case 2: return FitInView;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#paintRequested">QPrintPreviewWidget::<wbr/>paintRequested(QPrinter*)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.printsupport.@Nullable QPrinter> paintRequested = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#previewChanged">QPrintPreviewWidget::<wbr/>previewChanged()</a></code></p>
     */
    public final @NonNull Signal0 previewChanged = new Signal0();
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#QPrintPreviewWidget">QPrintPreviewWidget::<wbr/>QPrintPreviewWidget(QPrinter*,<wbr/>QWidget*,<wbr/>Qt::WindowFlags)</a></code></p>
     */
    public QPrintPreviewWidget(io.qt.printsupport.@Nullable QPrinter printer, io.qt.widgets.@Nullable QWidget parent, io.qt.core.Qt.@NonNull WindowFlags flags){
        super((QPrivateConstructor)null);
        initialize_native(this, printer, parent, flags);
    }
    
    private native static void initialize_native(QPrintPreviewWidget instance, io.qt.printsupport.QPrinter printer, io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowFlags flags);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#QPrintPreviewWidget-1">QPrintPreviewWidget::<wbr/>QPrintPreviewWidget(QWidget*,<wbr/>Qt::WindowFlags)</a></code></p>
     */
    public QPrintPreviewWidget(io.qt.widgets.@Nullable QWidget parent, io.qt.core.Qt.@NonNull WindowFlags flags){
        super((QPrivateConstructor)null);
        initialize_native(this, parent, flags);
    }
    
    private native static void initialize_native(QPrintPreviewWidget instance, io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowFlags flags);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#currentPage">QPrintPreviewWidget::<wbr/>currentPage()const</a></code></p>
     */
    @QtUninvokable
    public final int currentPage(){
        return currentPage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int currentPage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#fitInView">QPrintPreviewWidget::<wbr/>fitInView()</a></code></p>
     */
    public final void fitInView(){
        fitInView_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void fitInView_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#fitToWidth">QPrintPreviewWidget::<wbr/>fitToWidth()</a></code></p>
     */
    public final void fitToWidth(){
        fitToWidth_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void fitToWidth_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#orientation">QPrintPreviewWidget::<wbr/>orientation()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.printsupport.QPrinter.@NonNull Orientation orientation(){
        return io.qt.printsupport.QPrinter.Orientation.resolve(orientation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int orientation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#pageCount">QPrintPreviewWidget::<wbr/>pageCount()const</a></code></p>
     */
    @QtUninvokable
    public final int pageCount(){
        return pageCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int pageCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#print">QPrintPreviewWidget::<wbr/>print()</a></code></p>
     */
    public final void print(){
        print_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void print_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#setAllPagesViewMode">QPrintPreviewWidget::<wbr/>setAllPagesViewMode()</a></code></p>
     */
    public final void setAllPagesViewMode(){
        setAllPagesViewMode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void setAllPagesViewMode_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#setCurrentPage">QPrintPreviewWidget::<wbr/>setCurrentPage(int)</a></code></p>
     */
    public final void setCurrentPage(int pageNumber){
        setCurrentPage_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), pageNumber);
    }
    
    private native void setCurrentPage_native_int(long __this__nativeId, int pageNumber);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#setFacingPagesViewMode">QPrintPreviewWidget::<wbr/>setFacingPagesViewMode()</a></code></p>
     */
    public final void setFacingPagesViewMode(){
        setFacingPagesViewMode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void setFacingPagesViewMode_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#setLandscapeOrientation">QPrintPreviewWidget::<wbr/>setLandscapeOrientation()</a></code></p>
     */
    public final void setLandscapeOrientation(){
        setLandscapeOrientation_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void setLandscapeOrientation_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#setOrientation">QPrintPreviewWidget::<wbr/>setOrientation(QPrinter::Orientation)</a></code></p>
     */
    public final void setOrientation(io.qt.printsupport.QPrinter.@NonNull Orientation orientation){
        setOrientation_native_QPrinter_Orientation(QtJambi_LibraryUtilities.internal.nativeId(this), orientation.value());
    }
    
    private native void setOrientation_native_QPrinter_Orientation(long __this__nativeId, int orientation);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#setPortraitOrientation">QPrintPreviewWidget::<wbr/>setPortraitOrientation()</a></code></p>
     */
    public final void setPortraitOrientation(){
        setPortraitOrientation_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void setPortraitOrientation_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#setSinglePageViewMode">QPrintPreviewWidget::<wbr/>setSinglePageViewMode()</a></code></p>
     */
    public final void setSinglePageViewMode(){
        setSinglePageViewMode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void setSinglePageViewMode_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#setViewMode">QPrintPreviewWidget::<wbr/>setViewMode(QPrintPreviewWidget::ViewMode)</a></code></p>
     */
    public final void setViewMode(io.qt.printsupport.QPrintPreviewWidget.@NonNull ViewMode viewMode){
        setViewMode_native_QPrintPreviewWidget_ViewMode(QtJambi_LibraryUtilities.internal.nativeId(this), viewMode.value());
    }
    
    private native void setViewMode_native_QPrintPreviewWidget_ViewMode(long __this__nativeId, int viewMode);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#setZoomFactor">QPrintPreviewWidget::<wbr/>setZoomFactor(qreal)</a></code></p>
     */
    public final void setZoomFactor(double zoomFactor){
        setZoomFactor_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), zoomFactor);
    }
    
    private native void setZoomFactor_native_qreal(long __this__nativeId, double zoomFactor);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#setZoomMode">QPrintPreviewWidget::<wbr/>setZoomMode(QPrintPreviewWidget::ZoomMode)</a></code></p>
     */
    public final void setZoomMode(io.qt.printsupport.QPrintPreviewWidget.@NonNull ZoomMode zoomMode){
        setZoomMode_native_QPrintPreviewWidget_ZoomMode(QtJambi_LibraryUtilities.internal.nativeId(this), zoomMode.value());
    }
    
    private native void setZoomMode_native_QPrintPreviewWidget_ZoomMode(long __this__nativeId, int zoomMode);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#updatePreview">QPrintPreviewWidget::<wbr/>updatePreview()</a></code></p>
     */
    public final void updatePreview(){
        updatePreview_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void updatePreview_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#viewMode">QPrintPreviewWidget::<wbr/>viewMode()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.printsupport.QPrintPreviewWidget.@NonNull ViewMode viewMode(){
        return io.qt.printsupport.QPrintPreviewWidget.ViewMode.resolve(viewMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int viewMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#zoomFactor">QPrintPreviewWidget::<wbr/>zoomFactor()const</a></code></p>
     */
    @QtUninvokable
    public final double zoomFactor(){
        return zoomFactor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double zoomFactor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#zoomIn">QPrintPreviewWidget::<wbr/>zoomIn(qreal)</a></code></p>
     */
    public final void zoomIn(double zoom){
        zoomIn_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), zoom);
    }
    
    private native void zoomIn_native_qreal(long __this__nativeId, double zoom);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#zoomMode">QPrintPreviewWidget::<wbr/>zoomMode()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.printsupport.QPrintPreviewWidget.@NonNull ZoomMode zoomMode(){
        return io.qt.printsupport.QPrintPreviewWidget.ZoomMode.resolve(zoomMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int zoomMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#zoomOut">QPrintPreviewWidget::<wbr/>zoomOut(qreal)</a></code></p>
     */
    public final void zoomOut(double zoom){
        zoomOut_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), zoom);
    }
    
    private native void zoomOut_native_qreal(long __this__nativeId, double zoom);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qwidget.html#visible-prop">QWidget::<wbr/>setVisible(bool)</a></code></p>
     */
    @QtUninvokable
    @Override
    public void setVisible(boolean visible){
        setVisible_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), visible);
    }
    
    @QtUninvokable
    private native void setVisible_native_bool(long __this__nativeId, boolean visible);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QPrintPreviewWidget(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QPrintPreviewWidget(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QPrintPreviewWidget instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QPrintPreviewWidget(io.qt.printsupport.QPrinter, io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}
     *  with <code>flags = new io.qt.core.Qt.WindowFlags(0)</code>.</p>
     */
    public QPrintPreviewWidget(io.qt.printsupport.@Nullable QPrinter printer, io.qt.widgets.@Nullable QWidget parent) {
        this(printer, parent, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QPrintPreviewWidget(io.qt.printsupport.QPrinter, io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}</p>
     * <p>with: </p><ul>
     * <li><code>parent = null</code></li>
     * <li><code>flags = new io.qt.core.Qt.WindowFlags(0)</code></li>
     * </ul>
     */
    public QPrintPreviewWidget(io.qt.printsupport.@Nullable QPrinter printer) {
        this(printer, (io.qt.widgets.QWidget)null, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QPrintPreviewWidget(io.qt.printsupport.QPrinter, io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}.</p>
     */
    public QPrintPreviewWidget(io.qt.printsupport.@Nullable QPrinter printer, io.qt.widgets.@Nullable QWidget parent, io.qt.core.Qt.@NonNull WindowType @NonNull... flags) {
        this(printer, parent, new io.qt.core.Qt.WindowFlags(flags));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QPrintPreviewWidget(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}
     *  with <code>flags = new io.qt.core.Qt.WindowFlags(0)</code>.</p>
     */
    public QPrintPreviewWidget(io.qt.widgets.@Nullable QWidget parent) {
        this(parent, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QPrintPreviewWidget(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}</p>
     * <p>with: </p><ul>
     * <li><code>parent = null</code></li>
     * <li><code>flags = new io.qt.core.Qt.WindowFlags(0)</code></li>
     * </ul>
     */
    public QPrintPreviewWidget() {
        this((io.qt.widgets.QWidget)null, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QPrintPreviewWidget(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}.</p>
     */
    public QPrintPreviewWidget(io.qt.widgets.@Nullable QWidget parent, io.qt.core.Qt.@NonNull WindowType @NonNull... flags) {
        this(parent, new io.qt.core.Qt.WindowFlags(flags));
    }
    
    /**
     * <p>Overloaded function for {@link #zoomIn(double)}
     *  with <code>zoom = 1.1</code>.</p>
     */
    public final void zoomIn() {
        zoomIn((double)1.1);
    }
    
    /**
     * <p>Overloaded function for {@link #zoomOut(double)}
     *  with <code>zoom = 1.1</code>.</p>
     */
    public final void zoomOut() {
        zoomOut((double)1.1);
    }
}
