package io.qt.printsupport;

import io.qt.*;


/**
 * <p>Gives access to information about existing printers</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html">QPrinterInfo</a></code></p>
 */
public class QPrinterInfo extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#QPrinterInfo">QPrinterInfo::<wbr>QPrinterInfo()</a></code></p>
     */
    public QPrinterInfo(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QPrinterInfo instance);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#QPrinterInfo-2">QPrinterInfo::<wbr>QPrinterInfo(QPrinter)</a></code></p>
     */
    public QPrinterInfo(io.qt.printsupport.@StrictNonNull QPrinter printer){
        super((QPrivateConstructor)null);
        java.util.Objects.requireNonNull(printer, "Argument 'printer': null not expected.");
        initialize_native(this, printer);
    }
    
    private native static void initialize_native(QPrinterInfo instance, io.qt.printsupport.QPrinter printer);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#QPrinterInfo-1">QPrinterInfo::<wbr>QPrinterInfo(QPrinterInfo)</a></code></p>
     */
    public QPrinterInfo(io.qt.printsupport.@NonNull QPrinterInfo other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QPrinterInfo instance, io.qt.printsupport.QPrinterInfo other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#defaultColorMode">QPrinterInfo::<wbr>defaultColorMode()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.printsupport.QPrinter.@NonNull ColorMode defaultColorMode(){
        return io.qt.printsupport.QPrinter.ColorMode.resolve(defaultColorMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int defaultColorMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#defaultDuplexMode">QPrinterInfo::<wbr>defaultDuplexMode()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.printsupport.QPrinter.@NonNull DuplexMode defaultDuplexMode(){
        return io.qt.printsupport.QPrinter.DuplexMode.resolve(defaultDuplexMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int defaultDuplexMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#defaultPageSize">QPrinterInfo::<wbr>defaultPageSize()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QPageSize defaultPageSize(){
        return defaultPageSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QPageSize defaultPageSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#description">QPrinterInfo::<wbr>description()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String description(){
        return description_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String description_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#isDefault">QPrinterInfo::<wbr>isDefault()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isDefault(){
        return isDefault_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isDefault_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#isNull">QPrinterInfo::<wbr>isNull()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#isRemote">QPrinterInfo::<wbr>isRemote()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isRemote(){
        return isRemote_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isRemote_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#location">QPrinterInfo::<wbr>location()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String location(){
        return location_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String location_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#makeAndModel">QPrinterInfo::<wbr>makeAndModel()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String makeAndModel(){
        return makeAndModel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String makeAndModel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#maximumPhysicalPageSize">QPrinterInfo::<wbr>maximumPhysicalPageSize()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QPageSize maximumPhysicalPageSize(){
        return maximumPhysicalPageSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QPageSize maximumPhysicalPageSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#minimumPhysicalPageSize">QPrinterInfo::<wbr>minimumPhysicalPageSize()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QPageSize minimumPhysicalPageSize(){
        return minimumPhysicalPageSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QPageSize minimumPhysicalPageSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#operator-eq">QPrinterInfo::<wbr>operator=(QPrinterInfo)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.printsupport.@NonNull QPrinterInfo other){
        assign_native_cref_QPrinterInfo(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QPrinterInfo(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#printerName">QPrinterInfo::<wbr>printerName()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String printerName(){
        return printerName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String printerName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#state">QPrinterInfo::<wbr>state()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.printsupport.QPrinter.@NonNull PrinterState state(){
        return io.qt.printsupport.QPrinter.PrinterState.resolve(state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int state_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#supportedColorModes">QPrinterInfo::<wbr>supportedColorModes()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.printsupport.QPrinter.@NonNull ColorMode> supportedColorModes(){
        return supportedColorModes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.printsupport.QPrinter.ColorMode> supportedColorModes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#supportedDuplexModes">QPrinterInfo::<wbr>supportedDuplexModes()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.printsupport.QPrinter.@NonNull DuplexMode> supportedDuplexModes(){
        return supportedDuplexModes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.printsupport.QPrinter.DuplexMode> supportedDuplexModes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#supportedPageSizes">QPrinterInfo::<wbr>supportedPageSizes()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.gui.@NonNull QPageSize> supportedPageSizes(){
        return supportedPageSizes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.gui.QPageSize> supportedPageSizes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo-obsolete.html#supportedPaperSizes">QPrinterInfo::<wbr>supportedPaperSizes()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.gui.QPagedPaintDevice.@NonNull PageSize> supportedPaperSizes(){
        return supportedPaperSizes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.gui.QPagedPaintDevice.PageSize> supportedPaperSizes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#supportedResolutions">QPrinterInfo::<wbr>supportedResolutions()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Integer> supportedResolutions(){
        return supportedResolutions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.@QtPrimitiveType Integer> supportedResolutions_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo-obsolete.html#supportedSizesWithNames">QPrinterInfo::<wbr>supportedSizesWithNames()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.core.@NonNull QPair<java.lang.@NonNull String, io.qt.core.@NonNull QSizeF>> supportedSizesWithNames(){
        return supportedSizesWithNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.core.QPair<java.lang.String, io.qt.core.QSizeF>> supportedSizesWithNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#supportsCustomPageSizes">QPrinterInfo::<wbr>supportsCustomPageSizes()const</a></code></p>
     */
    @QtUninvokable
    public final boolean supportsCustomPageSizes(){
        return supportsCustomPageSizes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean supportsCustomPageSizes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#availablePrinterNames">QPrinterInfo::<wbr>availablePrinterNames()</a></code></p>
     */
    public native static io.qt.core.@NonNull QStringList availablePrinterNames();
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#availablePrinters">QPrinterInfo::<wbr>availablePrinters()</a></code></p>
     */
    public native static io.qt.core.@NonNull QList<io.qt.printsupport.@NonNull QPrinterInfo> availablePrinters();
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#defaultPrinter">QPrinterInfo::<wbr>defaultPrinter()</a></code></p>
     */
    public native static io.qt.printsupport.@NonNull QPrinterInfo defaultPrinter();
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#defaultPrinterName">QPrinterInfo::<wbr>defaultPrinterName()</a></code></p>
     */
    public native static java.lang.@NonNull String defaultPrinterName();
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprinterinfo.html#printerInfo">QPrinterInfo::<wbr>printerInfo(QString)</a></code></p>
     */
    public native static io.qt.printsupport.@NonNull QPrinterInfo printerInfo(java.lang.@NonNull String printerName);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QPrinterInfo(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QPrinterInfo clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QPrinterInfo clone_native(long __this_nativeId);
}
