package io.qt.printsupport;

import io.qt.*;


/**
 * <p>Defines an interface for how QPrinter interacts with a given printing subsystem</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qprintengine.html">QPrintEngine</a></code></p>
 */
public abstract class QPrintEngine extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @NativeAccess
    private static final class ConcreteWrapper extends QPrintEngine {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        public boolean abort(){
            return abort_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native boolean abort_native(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public int metric(io.qt.gui.QPaintDevice.@NonNull PaintDeviceMetric arg__1){
            return metric_native_QPaintDevice_PaintDeviceMetric_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
        }
        @QtUninvokable
        private native int metric_native_QPaintDevice_PaintDeviceMetric_constfct(long __this__nativeId, int arg__1);
        
        
        @Override
        @QtUninvokable
        public boolean newPage(){
            return newPage_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native boolean newPage_native(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public io.qt.printsupport.QPrinter.@NonNull PrinterState printerState(){
            return io.qt.printsupport.QPrinter.PrinterState.resolve(printerState_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        @QtUninvokable
        private native int printerState_native_constfct(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public java.lang.Object property(io.qt.printsupport.QPrintEngine.@NonNull PrintEnginePropertyKey key){
            return property_native_QPrintEngine_PrintEnginePropertyKey_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), key.value());
        }
        @QtUninvokable
        private native java.lang.Object property_native_QPrintEngine_PrintEnginePropertyKey_constfct(long __this__nativeId, int key);
        
        
        @Override
        @QtUninvokable
        public void setProperty(io.qt.printsupport.QPrintEngine.@NonNull PrintEnginePropertyKey key, java.lang.Object value){
            setProperty_native_QPrintEngine_PrintEnginePropertyKey_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), key.value(), value);
        }
        @QtUninvokable
        private native void setProperty_native_QPrintEngine_PrintEnginePropertyKey_cref_QVariant(long __this__nativeId, int key, java.lang.Object value);
        
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::PrintEnginePropertyKey</a></code></p>
     */
    @QtRejectedEntries({"PPK_PaperSize"})
    public enum PrintEnginePropertyKey implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_CollateCopies</a></code></p>
         */
        PPK_CollateCopies(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_ColorMode</a></code></p>
         */
        PPK_ColorMode(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_Creator</a></code></p>
         */
        PPK_Creator(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_DocumentName</a></code></p>
         */
        PPK_DocumentName(3),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_FullPage</a></code></p>
         */
        PPK_FullPage(4),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_NumberOfCopies</a></code></p>
         */
        PPK_NumberOfCopies(5),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_Orientation</a></code></p>
         */
        PPK_Orientation(6),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_OutputFileName</a></code></p>
         */
        PPK_OutputFileName(7),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_PageOrder</a></code></p>
         */
        PPK_PageOrder(8),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_PageRect</a></code></p>
         */
        PPK_PageRect(9),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_PageSize</a></code></p>
         */
        PPK_PageSize(10),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_PaperRect</a></code></p>
         */
        PPK_PaperRect(11),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_PaperSource</a></code></p>
         */
        PPK_PaperSource(12),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_PrinterName</a></code></p>
         */
        PPK_PrinterName(13),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_PrinterProgram</a></code></p>
         */
        PPK_PrinterProgram(14),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_Resolution</a></code></p>
         */
        PPK_Resolution(15),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_SelectionOption</a></code></p>
         */
        PPK_SelectionOption(16),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_SupportedResolutions</a></code></p>
         */
        PPK_SupportedResolutions(17),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_WindowsPageSize</a></code></p>
         */
        PPK_WindowsPageSize(18),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_FontEmbedding</a></code></p>
         */
        PPK_FontEmbedding(19),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_Duplex</a></code></p>
         */
        PPK_Duplex(20),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_PaperSources</a></code></p>
         */
        PPK_PaperSources(21),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_CustomPaperSize</a></code></p>
         */
        PPK_CustomPaperSize(22),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_PageMargins</a></code></p>
         */
        PPK_PageMargins(23),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_CopyCount</a></code></p>
         */
        PPK_CopyCount(24),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_SupportsMultipleCopies</a></code></p>
         */
        PPK_SupportsMultipleCopies(25),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_PaperName</a></code></p>
         */
        PPK_PaperName(26),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_QPageSize</a></code></p>
         */
        PPK_QPageSize(27),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_QPageMargins</a></code></p>
         */
        PPK_QPageMargins(28),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_QPageLayout</a></code></p>
         */
        PPK_QPageLayout(29),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_PaperSize</a></code></p>
         */
        PPK_PaperSize(10),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qprintengine.html#PrintEnginePropertyKey-enum">QPrintEngine::<wbr>PPK_CustomBase</a></code></p>
         */
        PPK_CustomBase(65280);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PrintEnginePropertyKey(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PrintEnginePropertyKey resolve(int value) {
            switch (value) {
            case 0: return PPK_CollateCopies;
            case 1: return PPK_ColorMode;
            case 2: return PPK_Creator;
            case 3: return PPK_DocumentName;
            case 4: return PPK_FullPage;
            case 5: return PPK_NumberOfCopies;
            case 6: return PPK_Orientation;
            case 7: return PPK_OutputFileName;
            case 8: return PPK_PageOrder;
            case 9: return PPK_PageRect;
            case 10: return PPK_PageSize;
            case 11: return PPK_PaperRect;
            case 12: return PPK_PaperSource;
            case 13: return PPK_PrinterName;
            case 14: return PPK_PrinterProgram;
            case 15: return PPK_Resolution;
            case 16: return PPK_SelectionOption;
            case 17: return PPK_SupportedResolutions;
            case 18: return PPK_WindowsPageSize;
            case 19: return PPK_FontEmbedding;
            case 20: return PPK_Duplex;
            case 21: return PPK_PaperSources;
            case 22: return PPK_CustomPaperSize;
            case 23: return PPK_PageMargins;
            case 24: return PPK_CopyCount;
            case 25: return PPK_SupportsMultipleCopies;
            case 26: return PPK_PaperName;
            case 27: return PPK_QPageSize;
            case 28: return PPK_QPageMargins;
            case 29: return PPK_QPageLayout;
            case 65280: return PPK_CustomBase;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code>QPrintEngine::<wbr>QPrintEngine()</code></p>
     */
    public QPrintEngine(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QPrintEngine instance);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintengine.html#abort">QPrintEngine::<wbr>abort()</a></code></p>
     */
    @QtUninvokable
    public abstract boolean abort();
    
    @QtUninvokable
    private native boolean abort_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintengine.html#metric">QPrintEngine::<wbr>metric(QPaintDevice::PaintDeviceMetric)const</a></code></p>
     */
    @QtUninvokable
    public abstract int metric(io.qt.gui.QPaintDevice.@NonNull PaintDeviceMetric arg__1);
    
    @QtUninvokable
    private native int metric_native_QPaintDevice_PaintDeviceMetric_constfct(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintengine.html#newPage">QPrintEngine::<wbr>newPage()</a></code></p>
     */
    @QtUninvokable
    public abstract boolean newPage();
    
    @QtUninvokable
    private native boolean newPage_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintengine.html#printerState">QPrintEngine::<wbr>printerState()const</a></code></p>
     */
    @QtUninvokable
    public abstract io.qt.printsupport.QPrinter.@NonNull PrinterState printerState();
    
    @QtUninvokable
    private native int printerState_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintengine.html#property">QPrintEngine::<wbr>property(QPrintEngine::PrintEnginePropertyKey)const</a></code></p>
     */
    @QtUninvokable
    public abstract java.lang.Object property(io.qt.printsupport.QPrintEngine.@NonNull PrintEnginePropertyKey key);
    
    @QtUninvokable
    private native java.lang.Object property_native_QPrintEngine_PrintEnginePropertyKey_constfct(long __this__nativeId, int key);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qprintengine.html#setProperty">QPrintEngine::<wbr>setProperty(QPrintEngine::PrintEnginePropertyKey,<wbr>QVariant)</a></code></p>
     */
    @QtUninvokable
    public abstract void setProperty(io.qt.printsupport.QPrintEngine.@NonNull PrintEnginePropertyKey key, java.lang.Object value);
    
    @QtUninvokable
    private native void setProperty_native_QPrintEngine_PrintEnginePropertyKey_cref_QVariant(long __this__nativeId, int key, java.lang.Object value);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QPrintEngine(QPrivateConstructor p) { super(p); } 
    
}
