package io.qt.printsupport;


/**
 * <p>Paint device that paints on a printer</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qprinter.html">QPrinter</a></p>
 */
public class QPrinter extends io.qt.QtObject
    implements io.qt.gui.QPagedPaintDevice,
            io.qt.gui.QPaintDevice
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcPaintEngine = null;
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcPrintEngine = null;
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qprinter.html#ColorMode-enum">QPrinter::ColorMode</a></p>
     */
    public enum ColorMode implements io.qt.QtEnumerator {
        GrayScale(0),
        Color(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ColorMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ColorMode resolve(int value) {
            switch (value) {
            case 0: return GrayScale;
            case 1: return Color;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qprinter.html#DuplexMode-enum">QPrinter::DuplexMode</a></p>
     */
    public enum DuplexMode implements io.qt.QtEnumerator {
        DuplexNone(0),
        DuplexAuto(1),
        DuplexLongSide(2),
        DuplexShortSide(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DuplexMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static DuplexMode resolve(int value) {
            switch (value) {
            case 0: return DuplexNone;
            case 1: return DuplexAuto;
            case 2: return DuplexLongSide;
            case 3: return DuplexShortSide;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qprinter.html#Orientation-enum">QPrinter::Orientation</a></p>
     */
    public enum Orientation implements io.qt.QtEnumerator {
        Portrait(0),
        Landscape(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Orientation(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Orientation resolve(int value) {
            switch (value) {
            case 0: return Portrait;
            case 1: return Landscape;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qprinter.html#OutputFormat-enum">QPrinter::OutputFormat</a></p>
     */
    public enum OutputFormat implements io.qt.QtEnumerator {
        NativeFormat(0),
        PdfFormat(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private OutputFormat(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static OutputFormat resolve(int value) {
            switch (value) {
            case 0: return NativeFormat;
            case 1: return PdfFormat;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qprinter.html#PageOrder-enum">QPrinter::PageOrder</a></p>
     */
    public enum PageOrder implements io.qt.QtEnumerator {
        FirstPageFirst(0),
        LastPageFirst(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PageOrder(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static PageOrder resolve(int value) {
            switch (value) {
            case 0: return FirstPageFirst;
            case 1: return LastPageFirst;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qprinter.html#PaperSource-enum">QPrinter::PaperSource</a></p>
     */
    @io.qt.QtRejectedEntries({"LastPaperSource", "Upper"})
    public enum PaperSource implements io.qt.QtEnumerator {
        OnlyOne(0),
        Lower(1),
        Middle(2),
        Manual(3),
        Envelope(4),
        EnvelopeManual(5),
        Auto(6),
        Tractor(7),
        SmallFormat(8),
        LargeFormat(9),
        LargeCapacity(10),
        Cassette(11),
        FormSource(12),
        MaxPageSource(13),
        CustomSource(14),
        LastPaperSource(14),
        Upper(0);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PaperSource(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static PaperSource resolve(int value) {
            switch (value) {
            case 0: return OnlyOne;
            case 1: return Lower;
            case 2: return Middle;
            case 3: return Manual;
            case 4: return Envelope;
            case 5: return EnvelopeManual;
            case 6: return Auto;
            case 7: return Tractor;
            case 8: return SmallFormat;
            case 9: return LargeFormat;
            case 10: return LargeCapacity;
            case 11: return Cassette;
            case 12: return FormSource;
            case 13: return MaxPageSource;
            case 14: return CustomSource;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qprinter.html#PrintRange-enum">QPrinter::PrintRange</a></p>
     */
    public enum PrintRange implements io.qt.QtEnumerator {
        AllPages(0),
        Selection(1),
        PageRange(2),
        CurrentPage(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PrintRange(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static PrintRange resolve(int value) {
            switch (value) {
            case 0: return AllPages;
            case 1: return Selection;
            case 2: return PageRange;
            case 3: return CurrentPage;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qprinter.html#PrinterMode-enum">QPrinter::PrinterMode</a></p>
     */
    public enum PrinterMode implements io.qt.QtEnumerator {
        ScreenResolution(0),
        PrinterResolution(1),
        HighResolution(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PrinterMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static PrinterMode resolve(int value) {
            switch (value) {
            case 0: return ScreenResolution;
            case 1: return PrinterResolution;
            case 2: return HighResolution;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qprinter.html#PrinterState-enum">QPrinter::PrinterState</a></p>
     */
    public enum PrinterState implements io.qt.QtEnumerator {
        Idle(0),
        Active(1),
        Aborted(2),
        Error(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PrinterState(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static PrinterState resolve(int value) {
            switch (value) {
            case 0: return Idle;
            case 1: return Active;
            case 2: return Aborted;
            case 3: return Error;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qprinter.html#Unit-enum">QPrinter::Unit</a></p>
     */
    public enum Unit implements io.qt.QtEnumerator {
        Millimeter(0),
        Point(1),
        Inch(2),
        Pica(3),
        Didot(4),
        Cicero(5),
        DevicePixel(6);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Unit(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Unit resolve(int value) {
            switch (value) {
            case 0: return Millimeter;
            case 1: return Point;
            case 2: return Inch;
            case 3: return Pica;
            case 4: return Didot;
            case 5: return Cicero;
            case 6: return DevicePixel;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #QPrinter(io.qt.printsupport.QPrinter.PrinterMode)}
     *  with <code>mode = io.qt.printsupport.QPrinter.PrinterMode.ScreenResolution</code>.</p>
     */
    public QPrinter() {
        this(io.qt.printsupport.QPrinter.PrinterMode.ScreenResolution);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#QPrinter">QPrinter::QPrinter(QPrinter::PrinterMode)</a></p>
     */
    public QPrinter(io.qt.printsupport.QPrinter.PrinterMode mode){
        super((QPrivateConstructor)null);
        if(io.qt.core.QCoreApplication.instance()==null)
            throw new IllegalStateException("Cannot create QPrinter before initializing QCoreApplication.");
        initialize_native(this, mode);
    }
    
    private native static void initialize_native(QPrinter instance, io.qt.printsupport.QPrinter.PrinterMode mode);
    
    /**
     * <p>Overloaded constructor for {@link #QPrinter(io.qt.printsupport.QPrinterInfo, io.qt.printsupport.QPrinter.PrinterMode)}
     *  with <code>mode = io.qt.printsupport.QPrinter.PrinterMode.ScreenResolution</code>.</p>
     */
    public QPrinter(io.qt.printsupport.QPrinterInfo printer) {
        this(printer, io.qt.printsupport.QPrinter.PrinterMode.ScreenResolution);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#QPrinter-1">QPrinter::QPrinter(QPrinterInfo,QPrinter::PrinterMode)</a></p>
     */
    public QPrinter(io.qt.printsupport.QPrinterInfo printer, io.qt.printsupport.QPrinter.PrinterMode mode){
        super((QPrivateConstructor)null);
        if(io.qt.core.QCoreApplication.instance()==null)
            throw new IllegalStateException("Cannot create QPrinter before initializing QCoreApplication.");
        initialize_native(this, printer, mode);
    }
    
    private native static void initialize_native(QPrinter instance, io.qt.printsupport.QPrinterInfo printer, io.qt.printsupport.QPrinter.PrinterMode mode);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#abort">QPrinter::abort()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean abort(){
        return abort_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean abort_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter-obsolete.html#actualNumCopies">QPrinter::actualNumCopies()const</a></p>
     * 
     * @deprecated Use copyCount() instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final int actualNumCopies(){
        return actualNumCopies_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native int actualNumCopies_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#collateCopies">QPrinter::collateCopies()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean collateCopies(){
        return collateCopies_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean collateCopies_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#colorCount">QPaintDevice::colorCount()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int colorCount(){
        return colorCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int colorCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#colorMode">QPrinter::colorMode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.printsupport.QPrinter.ColorMode colorMode(){
        return io.qt.printsupport.QPrinter.ColorMode.resolve(colorMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int colorMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#copyCount">QPrinter::copyCount()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int copyCount(){
        return copyCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int copyCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#creator">QPrinter::creator()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String creator(){
        return creator_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String creator_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#depth">QPaintDevice::depth()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int depth(){
        return depth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int depth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#devicePixelRatio">QPaintDevice::devicePixelRatio()const</a></p>
     */
    @io.qt.QtUninvokable
    public final double devicePixelRatio(){
        return devicePixelRatio_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static double devicePixelRatio_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#devicePixelRatioF">QPaintDevice::devicePixelRatioF()const</a></p>
     */
    @io.qt.QtUninvokable
    public final double devicePixelRatioF(){
        return devicePixelRatioF_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static double devicePixelRatioF_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#docName">QPrinter::docName()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String docName(){
        return docName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String docName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter-obsolete.html#doubleSidedPrinting">QPrinter::doubleSidedPrinting()const</a></p>
     * 
     * @deprecated Use duplex() instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final boolean doubleSidedPrinting(){
        return doubleSidedPrinting_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native boolean doubleSidedPrinting_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#duplex">QPrinter::duplex()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.printsupport.QPrinter.DuplexMode duplex(){
        return io.qt.printsupport.QPrinter.DuplexMode.resolve(duplex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int duplex_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#fontEmbeddingEnabled">QPrinter::fontEmbeddingEnabled()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean fontEmbeddingEnabled(){
        return fontEmbeddingEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean fontEmbeddingEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#fromPage">QPrinter::fromPage()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int fromPage(){
        return fromPage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int fromPage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#fullPage">QPrinter::fullPage()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean fullPage(){
        return fullPage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean fullPage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter-obsolete.html#getPageMargins">QPrinter::getPageMargins(qreal*,qreal*,qreal*,qreal*,QPrinter::Unit)const</a></p>
     * 
     * @deprecated Use pageLayout().margins() instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final io.qt.core.QMarginsF getPageMargins(io.qt.printsupport.QPrinter.Unit unit){
        return getPageMargins_native_qreal_ptr_qreal_ptr_qreal_ptr_qreal_ptr_QPrinter_Unit_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), unit.value());
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native io.qt.core.QMarginsF getPageMargins_native_qreal_ptr_qreal_ptr_qreal_ptr_qreal_ptr_QPrinter_Unit_constfct(long __this__nativeId, int unit);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#height">QPaintDevice::height()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int height(){
        return height_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int height_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#heightMM">QPaintDevice::heightMM()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int heightMM(){
        return heightMM_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int heightMM_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#isValid">QPrinter::isValid()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#logicalDpiX">QPaintDevice::logicalDpiX()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int logicalDpiX(){
        return logicalDpiX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int logicalDpiX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#logicalDpiY">QPaintDevice::logicalDpiY()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int logicalDpiY(){
        return logicalDpiY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int logicalDpiY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpagedpaintdevice-obsolete.html#margins">QPagedPaintDevice::margins()const</a></p>
     * 
     * @deprecated Use pageLayout().margins() instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final io.qt.gui.QPagedPaintDevice.Margins margins(){
        return margins_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    private native static io.qt.gui.QPagedPaintDevice.Margins margins_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter-obsolete.html#numCopies">QPrinter::numCopies()const</a></p>
     * 
     * @deprecated Use copyCount() instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final int numCopies(){
        return numCopies_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native int numCopies_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter-obsolete.html#orientation">QPrinter::orientation()const</a></p>
     * 
     * @deprecated Use pageLayout().orientation() instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final io.qt.printsupport.QPrinter.Orientation orientation(){
        return io.qt.printsupport.QPrinter.Orientation.resolve(orientation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native int orientation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#outputFileName">QPrinter::outputFileName()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String outputFileName(){
        return outputFileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String outputFileName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#outputFormat">QPrinter::outputFormat()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.printsupport.QPrinter.OutputFormat outputFormat(){
        return io.qt.printsupport.QPrinter.OutputFormat.resolve(outputFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int outputFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpagedpaintdevice.html#pageLayout">QPagedPaintDevice::pageLayout()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QPageLayout pageLayout(){
        return pageLayout_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.gui.QPageLayout pageLayout_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#pageOrder">QPrinter::pageOrder()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.printsupport.QPrinter.PageOrder pageOrder(){
        return io.qt.printsupport.QPrinter.PageOrder.resolve(pageOrder_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int pageOrder_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter-obsolete.html#pageRect">QPrinter::pageRect()const</a></p>
     * 
     * @deprecated Use pageLayout().paintRectPixels(resolution()) instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final io.qt.core.QRect pageRect(){
        return pageRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native io.qt.core.QRect pageRect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#pageRect-1">QPrinter::pageRect(QPrinter::Unit)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QRectF pageRect(io.qt.printsupport.QPrinter.Unit arg__1){
        return pageRect_native_QPrinter_Unit_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF pageRect_native_QPrinter_Unit_constfct(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpagedpaintdevice.html#pageSize">QPagedPaintDevice::pageSize()const</a></p>
     * 
     * @deprecated Use pageLayout().pageSize().id() instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final io.qt.gui.QPagedPaintDevice.PageSize pageSize(){
        return io.qt.gui.QPagedPaintDevice.PageSize.resolve(pageSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @Deprecated
    private native static int pageSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpagedpaintdevice-obsolete.html#pageSizeMM">QPagedPaintDevice::pageSizeMM()const</a></p>
     * 
     * @deprecated Use pageLayout().pageSize() instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final io.qt.core.QSizeF pageSizeMM(){
        return pageSizeMM_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    private native static io.qt.core.QSizeF pageSizeMM_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#paintingActive">QPaintDevice::paintingActive()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean paintingActive(){
        return paintingActive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static boolean paintingActive_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter-obsolete.html#paperName">QPrinter::paperName()const</a></p>
     * 
     * @deprecated Use pageLayout().pageSize().name() instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final java.lang.String paperName(){
        return paperName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native java.lang.String paperName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter-obsolete.html#paperRect">QPrinter::paperRect()const</a></p>
     * 
     * @deprecated Use pageLayout().fullRectPixels(resolution()) instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final io.qt.core.QRect paperRect(){
        return paperRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native io.qt.core.QRect paperRect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#paperRect-1">QPrinter::paperRect(QPrinter::Unit)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QRectF paperRect(io.qt.printsupport.QPrinter.Unit arg__1){
        return paperRect_native_QPrinter_Unit_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF paperRect_native_QPrinter_Unit_constfct(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter-obsolete.html#paperSize">QPrinter::paperSize()const</a></p>
     * 
     * @deprecated pageLayout().pageSize().id()
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final io.qt.gui.QPagedPaintDevice.PageSize paperSize(){
        return io.qt.gui.QPagedPaintDevice.PageSize.resolve(paperSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native int paperSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter-obsolete.html#paperSize-1">QPrinter::paperSize(QPrinter::Unit)const</a></p>
     * 
     * @deprecated Use pageLayout().pageSize().size() or pageLayout().fullPageSize() instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final io.qt.core.QSizeF paperSize(io.qt.printsupport.QPrinter.Unit unit){
        return paperSize_native_QPrinter_Unit_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), unit.value());
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native io.qt.core.QSizeF paperSize_native_QPrinter_Unit_constfct(long __this__nativeId, int unit);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#paperSource">QPrinter::paperSource()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.printsupport.QPrinter.PaperSource paperSource(){
        return io.qt.printsupport.QPrinter.PaperSource.resolve(paperSource_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int paperSource_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#pdfVersion">QPrinter::pdfVersion()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QPagedPaintDevice.PdfVersion pdfVersion(){
        return io.qt.gui.QPagedPaintDevice.PdfVersion.resolve(pdfVersion_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int pdfVersion_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#physicalDpiX">QPaintDevice::physicalDpiX()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int physicalDpiX(){
        return physicalDpiX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int physicalDpiX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#physicalDpiY">QPaintDevice::physicalDpiY()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int physicalDpiY(){
        return physicalDpiY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int physicalDpiY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#printEngine">QPrinter::printEngine()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.printsupport.QPrintEngine printEngine(){
        return printEngine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.printsupport.QPrintEngine printEngine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#printProgram">QPrinter::printProgram()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String printProgram(){
        return printProgram_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String printProgram_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#printRange">QPrinter::printRange()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.printsupport.QPrinter.PrintRange printRange(){
        return io.qt.printsupport.QPrinter.PrintRange.resolve(printRange_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int printRange_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#printerName">QPrinter::printerName()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String printerName(){
        return printerName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String printerName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#printerState">QPrinter::printerState()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.printsupport.QPrinter.PrinterState printerState(){
        return io.qt.printsupport.QPrinter.PrinterState.resolve(printerState_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int printerState_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#resolution">QPrinter::resolution()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int resolution(){
        return resolution_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int resolution_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#setCollateCopies">QPrinter::setCollateCopies(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setCollateCopies(boolean collate){
        setCollateCopies_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), collate);
    }
    
    @io.qt.QtUninvokable
    private native void setCollateCopies_native_bool(long __this__nativeId, boolean collate);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#setColorMode">QPrinter::setColorMode(QPrinter::ColorMode)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setColorMode(io.qt.printsupport.QPrinter.ColorMode arg__1){
        setColorMode_native_QPrinter_ColorMode(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @io.qt.QtUninvokable
    private native void setColorMode_native_QPrinter_ColorMode(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#setCopyCount">QPrinter::setCopyCount(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setCopyCount(int arg__1){
        setCopyCount_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setCopyCount_native_int(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#setCreator">QPrinter::setCreator(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setCreator(java.lang.String arg__1){
        setCreator_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setCreator_native_cref_QString(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#setDocName">QPrinter::setDocName(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setDocName(java.lang.String arg__1){
        setDocName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setDocName_native_cref_QString(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter-obsolete.html#setDoubleSidedPrinting">QPrinter::setDoubleSidedPrinting(bool)</a></p>
     * 
     * @deprecated Use setDuplex() instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final void setDoubleSidedPrinting(boolean enable){
        setDoubleSidedPrinting_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native void setDoubleSidedPrinting_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#setDuplex">QPrinter::setDuplex(QPrinter::DuplexMode)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setDuplex(io.qt.printsupport.QPrinter.DuplexMode duplex){
        setDuplex_native_QPrinter_DuplexMode(QtJambi_LibraryUtilities.internal.nativeId(this), duplex.value());
    }
    
    @io.qt.QtUninvokable
    private native void setDuplex_native_QPrinter_DuplexMode(long __this__nativeId, int duplex);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#setEngines">QPrinter::setEngines(QPrintEngine*,QPaintEngine*)</a></p>
     */
    @io.qt.QtUninvokable
    protected final void setEngines(io.qt.printsupport.QPrintEngine printEngine, io.qt.gui.QPaintEngine paintEngine){
        setEngines_native_QPrintEngine_ptr_QPaintEngine_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(printEngine), QtJambi_LibraryUtilities.internal.checkedNativeId(paintEngine));
        __rcPrintEngine = printEngine;
        __rcPaintEngine = paintEngine;
    }
    
    @io.qt.QtUninvokable
    private native void setEngines_native_QPrintEngine_ptr_QPaintEngine_ptr(long __this__nativeId, long printEngine, long paintEngine);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#setFontEmbeddingEnabled">QPrinter::setFontEmbeddingEnabled(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFontEmbeddingEnabled(boolean enable){
        setFontEmbeddingEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setFontEmbeddingEnabled_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#setFromTo">QPrinter::setFromTo(int,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFromTo(int fromPage, int toPage){
        setFromTo_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), fromPage, toPage);
    }
    
    @io.qt.QtUninvokable
    private native void setFromTo_native_int_int(long __this__nativeId, int fromPage, int toPage);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#setFullPage">QPrinter::setFullPage(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFullPage(boolean arg__1){
        setFullPage_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setFullPage_native_bool(long __this__nativeId, boolean arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter-obsolete.html#setNumCopies">QPrinter::setNumCopies(int)</a></p>
     * 
     * @deprecated Use setCopyCount() instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final void setNumCopies(int arg__1){
        setNumCopies_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native void setNumCopies_native_int(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter-obsolete.html#setOrientation">QPrinter::setOrientation(QPrinter::Orientation)</a></p>
     * 
     * @deprecated Use setPageOrientation() instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final void setOrientation(io.qt.printsupport.QPrinter.Orientation arg__1){
        setOrientation_native_QPrinter_Orientation(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native void setOrientation_native_QPrinter_Orientation(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#setOutputFileName">QPrinter::setOutputFileName(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setOutputFileName(java.lang.String arg__1){
        setOutputFileName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setOutputFileName_native_cref_QString(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#setOutputFormat">QPrinter::setOutputFormat(QPrinter::OutputFormat)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setOutputFormat(io.qt.printsupport.QPrinter.OutputFormat format){
        setOutputFormat_native_QPrinter_OutputFormat(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    @io.qt.QtUninvokable
    private native void setOutputFormat_native_QPrinter_OutputFormat(long __this__nativeId, int format);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpagedpaintdevice.html#setPageLayout">QPagedPaintDevice::setPageLayout(QPageLayout)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean setPageLayout(io.qt.gui.QPageLayout pageLayout){
        return setPageLayout_native_cref_QPageLayout(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pageLayout));
    }
    
    private native static boolean setPageLayout_native_cref_QPageLayout(long __this__nativeId, long pageLayout);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpagedpaintdevice.html#setPageMargins">QPagedPaintDevice::setPageMargins(QMarginsF)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean setPageMargins(io.qt.core.QMarginsF margins){
        return setPageMargins_native_cref_QMarginsF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(margins));
    }
    
    private native static boolean setPageMargins_native_cref_QMarginsF(long __this__nativeId, long margins);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpagedpaintdevice.html#setPageMargins-1">QPagedPaintDevice::setPageMargins(QMarginsF,QPageLayout::Unit)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean setPageMargins(io.qt.core.QMarginsF margins, io.qt.gui.QPageLayout.Unit units){
        return setPageMargins_native_cref_QMarginsF_QPageLayout_Unit(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(margins), units.value());
    }
    
    private native static boolean setPageMargins_native_cref_QMarginsF_QPageLayout_Unit(long __this__nativeId, long margins, int units);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter-obsolete.html#setPageMargins-2">QPrinter::setPageMargins(qreal,qreal,qreal,qreal,QPrinter::Unit)</a></p>
     * 
     * @deprecated Use setPageMargins(QMarginsF, QPageLayout::Unit) instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final void setPageMargins(double left, double top, double right, double bottom, io.qt.printsupport.QPrinter.Unit unit){
        setPageMargins_native_qreal_qreal_qreal_qreal_QPrinter_Unit(QtJambi_LibraryUtilities.internal.nativeId(this), left, top, right, bottom, unit.value());
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native void setPageMargins_native_qreal_qreal_qreal_qreal_QPrinter_Unit(long __this__nativeId, double left, double top, double right, double bottom, int unit);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#setPageOrder">QPrinter::setPageOrder(QPrinter::PageOrder)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPageOrder(io.qt.printsupport.QPrinter.PageOrder arg__1){
        setPageOrder_native_QPrinter_PageOrder(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @io.qt.QtUninvokable
    private native void setPageOrder_native_QPrinter_PageOrder(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpagedpaintdevice.html#setPageOrientation">QPagedPaintDevice::setPageOrientation(QPageLayout::Orientation)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean setPageOrientation(io.qt.gui.QPageLayout.Orientation orientation){
        return setPageOrientation_native_QPageLayout_Orientation(QtJambi_LibraryUtilities.internal.nativeId(this), orientation.value());
    }
    
    private native static boolean setPageOrientation_native_QPageLayout_Orientation(long __this__nativeId, int orientation);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpagedpaintdevice.html#setPageSize">QPagedPaintDevice::setPageSize(QPageSize)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean setPageSize(io.qt.gui.QPageSize pageSize){
        return setPageSize_native_cref_QPageSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(pageSize));
    }
    
    private native static boolean setPageSize_native_cref_QPageSize(long __this__nativeId, long pageSize);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter-obsolete.html#setPaperName">QPrinter::setPaperName(QString)</a></p>
     * 
     * @deprecated Use setPageSize(QPageSize) instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final void setPaperName(java.lang.String paperName){
        setPaperName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), paperName);
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native void setPaperName_native_cref_QString(long __this__nativeId, java.lang.String paperName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter-obsolete.html#setPaperSize">QPrinter::setPaperSize(QPrinter::PaperSize)</a></p>
     * 
     * @deprecated Use setPageSize(QPageSize) instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final void setPaperSize(io.qt.gui.QPagedPaintDevice.PageSize arg__1){
        setPaperSize_native_QPagedPaintDevice_PageSize(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native void setPaperSize_native_QPagedPaintDevice_PageSize(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter-obsolete.html#setPaperSize-1">QPrinter::setPaperSize(QSizeF,QPrinter::Unit)</a></p>
     * 
     * @deprecated Use setPageSize(QPageSize) instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final void setPaperSize(io.qt.core.QSizeF paperSize, io.qt.printsupport.QPrinter.Unit unit){
        setPaperSize_native_cref_QSizeF_QPrinter_Unit(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(paperSize), unit.value());
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native void setPaperSize_native_cref_QSizeF_QPrinter_Unit(long __this__nativeId, long paperSize, int unit);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#setPaperSource">QPrinter::setPaperSource(QPrinter::PaperSource)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPaperSource(io.qt.printsupport.QPrinter.PaperSource arg__1){
        setPaperSource_native_QPrinter_PaperSource(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @io.qt.QtUninvokable
    private native void setPaperSource_native_QPrinter_PaperSource(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#setPdfVersion">QPrinter::setPdfVersion(QPagedPaintDevice::PdfVersion)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPdfVersion(io.qt.gui.QPagedPaintDevice.PdfVersion version){
        setPdfVersion_native_QPagedPaintDevice_PdfVersion(QtJambi_LibraryUtilities.internal.nativeId(this), version.value());
    }
    
    @io.qt.QtUninvokable
    private native void setPdfVersion_native_QPagedPaintDevice_PdfVersion(long __this__nativeId, int version);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#setPrintProgram">QPrinter::setPrintProgram(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPrintProgram(java.lang.String arg__1){
        setPrintProgram_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setPrintProgram_native_cref_QString(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#setPrintRange">QPrinter::setPrintRange(QPrinter::PrintRange)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPrintRange(io.qt.printsupport.QPrinter.PrintRange range){
        setPrintRange_native_QPrinter_PrintRange(QtJambi_LibraryUtilities.internal.nativeId(this), range.value());
    }
    
    @io.qt.QtUninvokable
    private native void setPrintRange_native_QPrinter_PrintRange(long __this__nativeId, int range);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#setPrinterName">QPrinter::setPrinterName(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPrinterName(java.lang.String arg__1){
        setPrinterName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setPrinterName_native_cref_QString(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#setResolution">QPrinter::setResolution(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setResolution(int arg__1){
        setResolution_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setResolution_native_int(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter-obsolete.html#setWinPageSize">QPrinter::setWinPageSize(int)</a></p>
     * 
     * @deprecated Use QPageSize::id(windowsId) and setPageLayout(QPageSize) instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final void setWinPageSize(int winPageSize){
        setWinPageSize_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), winPageSize);
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native void setWinPageSize_native_int(long __this__nativeId, int winPageSize);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#supportedResolutions">QPrinter::supportedResolutions()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<java.lang.Integer> supportedResolutions(){
        return supportedResolutions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<java.lang.Integer> supportedResolutions_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#supportsMultipleCopies">QPrinter::supportsMultipleCopies()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean supportsMultipleCopies(){
        return supportsMultipleCopies_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean supportsMultipleCopies_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter.html#toPage">QPrinter::toPage()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int toPage(){
        return toPage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int toPage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#width">QPaintDevice::width()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int width(){
        return width_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int width_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#widthMM">QPaintDevice::widthMM()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int widthMM(){
        return widthMM_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int widthMM_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprinter-obsolete.html#winPageSize">QPrinter::winPageSize()const</a></p>
     * 
     * @deprecated Use pageLayout.pageSize().windowsId() instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final int winPageSize(){
        return winPageSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native int winPageSize_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected void initPainter(io.qt.gui.QPainter painter){
        initPainter_native_QPainter_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(painter));
    }
    
    private native static void initPainter_native_QPainter_ptr_constfct(long __this__nativeId, long painter);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#metric">QPaintDevice::metric(QPaintDevice::PaintDeviceMetric)const</a></p>
     */
    @io.qt.QtUninvokable
    protected int metric(io.qt.gui.QPaintDevice.PaintDeviceMetric arg__1){
        return metric_native_QPaintDevice_PaintDeviceMetric_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    private native static int metric_native_QPaintDevice_PaintDeviceMetric_constfct(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpagedpaintdevice.html#newPage">QPagedPaintDevice::newPage()</a></p>
     */
    @io.qt.QtUninvokable
    public boolean newPage(){
        return newPage_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static boolean newPage_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpaintdevice.html#paintEngine">QPaintDevice::paintEngine()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.gui.QPaintEngine paintEngine(){
        return paintEngine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.gui.QPaintEngine paintEngine_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected io.qt.gui.QPaintDevice redirected(io.qt.core.QPoint offset){
        return redirected_native_QPoint_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), offset);
    }
    
    private native static io.qt.gui.QPaintDevice redirected_native_QPoint_ptr_constfct(long __this__nativeId, io.qt.core.QPoint offset);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpagedpaintdevice-obsolete.html#setMargins">QPagedPaintDevice::setMargins(QPagedPaintDevice::Margins)</a></p>
     * 
     * @deprecated Use setPageMargins(QMarginsF, QPageLayout::Unit) instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public void setMargins(io.qt.gui.QPagedPaintDevice.Margins m){
        setMargins_native_cref_QPagedPaintDevice_Margins(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(m));
    }
    
    @Deprecated
    private native static void setMargins_native_cref_QPagedPaintDevice_Margins(long __this__nativeId, long m);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpagedpaintdevice.html#setPageSize-1">QPagedPaintDevice::setPageSize(QPagedPaintDevice::PageSize)</a></p>
     * 
     * @deprecated Use setPageSize(QPageSize) instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public void setPageSize(io.qt.gui.QPagedPaintDevice.PageSize arg__1){
        setPageSize_native_QPagedPaintDevice_PageSize(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @Deprecated
    private native static void setPageSize_native_QPagedPaintDevice_PageSize(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qpagedpaintdevice-obsolete.html#setPageSizeMM">QPagedPaintDevice::setPageSizeMM(QSizeF)</a></p>
     * 
     * @deprecated Use setPageSize(QPageSize) instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public void setPageSizeMM(io.qt.core.QSizeF size){
        setPageSizeMM_native_cref_QSizeF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @Deprecated
    private native static void setPageSizeMM_native_cref_QSizeF(long __this__nativeId, long size);
    
    @io.qt.QtUninvokable
    protected io.qt.gui.QPainter sharedPainter(){
        return sharedPainter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.gui.QPainter sharedPainter_native_constfct(long __this__nativeId);
    
    public native static double devicePixelRatioFScale();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QPrinter(QPrivateConstructor p) { super(p); } 
    
}
