package io.qt.printsupport;


/**
 * <p>Widget for previewing page layouts for printer output</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html">QPrintPreviewWidget</a></p>
 */
public class QPrintPreviewWidget extends io.qt.widgets.QWidget
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPrintPreviewWidget.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#ViewMode-enum">QPrintPreviewWidget::ViewMode</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum ViewMode implements io.qt.QtEnumerator {
        SinglePageView(0),
        FacingPagesView(1),
        AllPagesView(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ViewMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ViewMode resolve(int value) {
            switch (value) {
            case 0: return SinglePageView;
            case 1: return FacingPagesView;
            case 2: return AllPagesView;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#ZoomMode-enum">QPrintPreviewWidget::ZoomMode</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum ZoomMode implements io.qt.QtEnumerator {
        CustomZoom(0),
        FitToWidth(1),
        FitInView(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ZoomMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ZoomMode resolve(int value) {
            switch (value) {
            case 0: return CustomZoom;
            case 1: return FitToWidth;
            case 2: return FitInView;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#paintRequested">QPrintPreviewWidget::paintRequested(QPrinter*)</a></p>
     */
    public final Signal1<io.qt.printsupport.QPrinter> paintRequested = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#previewChanged">QPrintPreviewWidget::previewChanged()</a></p>
     */
    public final Signal0 previewChanged = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QPrintPreviewWidget(io.qt.printsupport.QPrinter, io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}.</p>
     */
    public QPrintPreviewWidget(io.qt.printsupport.QPrinter printer, io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowType ... flags){
        this(printer, parent, new io.qt.core.Qt.WindowFlags(flags));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QPrintPreviewWidget(io.qt.printsupport.QPrinter, io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}
     *  with <code>flags = new io.qt.core.Qt.WindowFlags(0)</code>.</p>
     */
    public QPrintPreviewWidget(io.qt.printsupport.QPrinter printer, io.qt.widgets.QWidget parent) {
        this(printer, parent, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QPrintPreviewWidget(io.qt.printsupport.QPrinter, io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}</p>
     * <p>with: </p><ul>
     * <li><code>parent = null</code></li>
     * <li><code>flags = new io.qt.core.Qt.WindowFlags(0)</code></li>
     * </ul>
     */
    public QPrintPreviewWidget(io.qt.printsupport.QPrinter printer) {
        this(printer, (io.qt.widgets.QWidget)null, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#QPrintPreviewWidget">QPrintPreviewWidget::QPrintPreviewWidget(QPrinter*,QWidget*,Qt::WindowFlags)</a></p>
     */
    public QPrintPreviewWidget(io.qt.printsupport.QPrinter printer, io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowFlags flags){
        super((QPrivateConstructor)null);
        initialize_native(this, printer, parent, flags);
    }
    
    private native static void initialize_native(QPrintPreviewWidget instance, io.qt.printsupport.QPrinter printer, io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowFlags flags);
    
    /**
     * <p>Overloaded constructor for {@link #QPrintPreviewWidget(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}.</p>
     */
    public QPrintPreviewWidget(io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowType ... flags){
        this(parent, new io.qt.core.Qt.WindowFlags(flags));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QPrintPreviewWidget(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}
     *  with <code>flags = new io.qt.core.Qt.WindowFlags(0)</code>.</p>
     */
    public QPrintPreviewWidget(io.qt.widgets.QWidget parent) {
        this(parent, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QPrintPreviewWidget(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}</p>
     * <p>with: </p><ul>
     * <li><code>parent = null</code></li>
     * <li><code>flags = new io.qt.core.Qt.WindowFlags(0)</code></li>
     * </ul>
     */
    public QPrintPreviewWidget() {
        this((io.qt.widgets.QWidget)null, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#QPrintPreviewWidget-1">QPrintPreviewWidget::QPrintPreviewWidget(QWidget*,Qt::WindowFlags)</a></p>
     */
    public QPrintPreviewWidget(io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowFlags flags){
        super((QPrivateConstructor)null);
        initialize_native(this, parent, flags);
    }
    
    private native static void initialize_native(QPrintPreviewWidget instance, io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowFlags flags);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#currentPage">QPrintPreviewWidget::currentPage()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int currentPage(){
        return currentPage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int currentPage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#fitInView">QPrintPreviewWidget::fitInView()</a></p>
     */
    public final void fitInView(){
        fitInView_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void fitInView_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#fitToWidth">QPrintPreviewWidget::fitToWidth()</a></p>
     */
    public final void fitToWidth(){
        fitToWidth_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void fitToWidth_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#orientation">QPrintPreviewWidget::orientation()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.printsupport.QPrinter.Orientation orientation(){
        return io.qt.printsupport.QPrinter.Orientation.resolve(orientation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int orientation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#pageCount">QPrintPreviewWidget::pageCount()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int pageCount(){
        return pageCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int pageCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#print">QPrintPreviewWidget::print()</a></p>
     */
    public final void print(){
        print_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void print_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#setAllPagesViewMode">QPrintPreviewWidget::setAllPagesViewMode()</a></p>
     */
    public final void setAllPagesViewMode(){
        setAllPagesViewMode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void setAllPagesViewMode_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#setCurrentPage">QPrintPreviewWidget::setCurrentPage(int)</a></p>
     */
    public final void setCurrentPage(int pageNumber){
        setCurrentPage_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), pageNumber);
    }
    
    private native void setCurrentPage_native_int(long __this__nativeId, int pageNumber);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#setFacingPagesViewMode">QPrintPreviewWidget::setFacingPagesViewMode()</a></p>
     */
    public final void setFacingPagesViewMode(){
        setFacingPagesViewMode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void setFacingPagesViewMode_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#setLandscapeOrientation">QPrintPreviewWidget::setLandscapeOrientation()</a></p>
     */
    public final void setLandscapeOrientation(){
        setLandscapeOrientation_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void setLandscapeOrientation_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#setOrientation">QPrintPreviewWidget::setOrientation(QPrinter::Orientation)</a></p>
     */
    public final void setOrientation(io.qt.printsupport.QPrinter.Orientation orientation){
        setOrientation_native_QPrinter_Orientation(QtJambi_LibraryUtilities.internal.nativeId(this), orientation.value());
    }
    
    private native void setOrientation_native_QPrinter_Orientation(long __this__nativeId, int orientation);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#setPortraitOrientation">QPrintPreviewWidget::setPortraitOrientation()</a></p>
     */
    public final void setPortraitOrientation(){
        setPortraitOrientation_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void setPortraitOrientation_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#setSinglePageViewMode">QPrintPreviewWidget::setSinglePageViewMode()</a></p>
     */
    public final void setSinglePageViewMode(){
        setSinglePageViewMode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void setSinglePageViewMode_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#setViewMode">QPrintPreviewWidget::setViewMode(QPrintPreviewWidget::ViewMode)</a></p>
     */
    public final void setViewMode(io.qt.printsupport.QPrintPreviewWidget.ViewMode viewMode){
        setViewMode_native_QPrintPreviewWidget_ViewMode(QtJambi_LibraryUtilities.internal.nativeId(this), viewMode.value());
    }
    
    private native void setViewMode_native_QPrintPreviewWidget_ViewMode(long __this__nativeId, int viewMode);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#setZoomFactor">QPrintPreviewWidget::setZoomFactor(qreal)</a></p>
     */
    public final void setZoomFactor(double zoomFactor){
        setZoomFactor_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), zoomFactor);
    }
    
    private native void setZoomFactor_native_qreal(long __this__nativeId, double zoomFactor);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#setZoomMode">QPrintPreviewWidget::setZoomMode(QPrintPreviewWidget::ZoomMode)</a></p>
     */
    public final void setZoomMode(io.qt.printsupport.QPrintPreviewWidget.ZoomMode zoomMode){
        setZoomMode_native_QPrintPreviewWidget_ZoomMode(QtJambi_LibraryUtilities.internal.nativeId(this), zoomMode.value());
    }
    
    private native void setZoomMode_native_QPrintPreviewWidget_ZoomMode(long __this__nativeId, int zoomMode);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#updatePreview">QPrintPreviewWidget::updatePreview()</a></p>
     */
    public final void updatePreview(){
        updatePreview_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void updatePreview_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#viewMode">QPrintPreviewWidget::viewMode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.printsupport.QPrintPreviewWidget.ViewMode viewMode(){
        return io.qt.printsupport.QPrintPreviewWidget.ViewMode.resolve(viewMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int viewMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#zoomFactor">QPrintPreviewWidget::zoomFactor()const</a></p>
     */
    @io.qt.QtUninvokable
    public final double zoomFactor(){
        return zoomFactor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double zoomFactor_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #zoomIn(double)}
     *  with <code>zoom = 1.1</code>.</p>
     */
    public final void zoomIn() {
        zoomIn((double)1.1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#zoomIn">QPrintPreviewWidget::zoomIn(qreal)</a></p>
     */
    public final void zoomIn(double zoom){
        zoomIn_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), zoom);
    }
    
    private native void zoomIn_native_qreal(long __this__nativeId, double zoom);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#zoomMode">QPrintPreviewWidget::zoomMode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.printsupport.QPrintPreviewWidget.ZoomMode zoomMode(){
        return io.qt.printsupport.QPrintPreviewWidget.ZoomMode.resolve(zoomMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int zoomMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #zoomOut(double)}
     *  with <code>zoom = 1.1</code>.</p>
     */
    public final void zoomOut() {
        zoomOut((double)1.1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qprintpreviewwidget.html#zoomOut">QPrintPreviewWidget::zoomOut(qreal)</a></p>
     */
    public final void zoomOut(double zoom){
        zoomOut_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), zoom);
    }
    
    private native void zoomOut_native_qreal(long __this__nativeId, double zoom);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwidget.html#visible-prop">QWidget::setVisible(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public void setVisible(boolean visible){
        setVisible_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), visible);
    }
    
    @io.qt.QtUninvokable
    private native void setVisible_native_bool(long __this__nativeId, boolean visible);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QPrintPreviewWidget(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QPrintPreviewWidget(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QPrintPreviewWidget instance, QDeclarativeConstructor constructor);
    
}
