#ifndef QPRINTENGINE_SHELL_H
#define QPRINTENGINE_SHELL_H

#include <QtCore/QtGlobal>
#if __has_include(<QtPrintSupport/qprintengine.h>)
#include <QtPrintSupport/qprintengine.h>
#endif
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtGui/qpaintdevice.h>
#include <QtPrintSupport/qprinter.h>
#include <QtJambi/RegistryAPI>


#if !defined(QT_NO_PRINTER)

class QPrintEngine_shell : public QPrintEngine, public QtJambiShellInterface
{
public:
    QPrintEngine_shell();
    ~QPrintEngine_shell() override;
private:
    QtJambiShell* __shell() const override final;
    friend class QPrintEngine_oshell;
};


class QPrintEngine_oshell : public QPrintEngine_shell
{
public:
    using QPrintEngine_shell::QPrintEngine_shell;
    bool abort() override;
    int metric(QPaintDevice::PaintDeviceMetric arg__1) const override;
    bool newPage() override;
    QPrinter::PrinterState printerState() const override;
    QVariant property(QPrintEngine::PrintEnginePropertyKey key0) const override;
    void setProperty(QPrintEngine::PrintEnginePropertyKey key0, const QVariant& value1) override;
    static void operator delete(void * ptr) noexcept;
private:
    jmethodID __shell_javaMethod(int pos) const;
};

struct QPrintEngine_access : public QPrintEngine
{
    jboolean __qt_abort(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jint __qt_metric_QPaintDevice_PaintDeviceMetric_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint arg__1) const;
    jboolean __qt_newPage(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jint __qt_printerState_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_property_QPrintEngine_PrintEnginePropertyKey_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint key0) const;
    void __qt_setProperty_QPrintEngine_PrintEnginePropertyKey_cref_QVariant(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint key0, jobject value1);
};

#endif // !defined(QT_NO_PRINTER)
#endif // QPRINTENGINE_SHELL_H
