#include "QPrinter_shell.h"
#include <QtJambi/Cast>

#if !defined(QT_NO_PRINTER)


void deleter_QPrinter(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QPrinter")
    QPrinter *_ptr = reinterpret_cast<QPrinter *>(ptr);
    if(!isShell){
        struct PaintDeviceAccess : QPaintDevice{
            inline QPainter* getSharedPainter() const { return sharedPainter(); }
        };
        if(QPainter* painter = reinterpret_cast<PaintDeviceAccess*>(dynamic_cast<QPaintDevice*>(_ptr))->getSharedPainter()){
            if(painter->isActive()){
                painter->end();
            }
        }
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

QtJambiShell* QPrinter_shell::__shell() const { return *reinterpret_cast<QtJambiShell**>( quintptr(this) + sizeof(QPrinter_shell) ); }

jmethodID QPrinter_shell::__shell_javaMethod(int pos) const { return QPrinter_shell::__shell()->javaMethod(typeid(QPrinter), pos); }

// emitting (writeShellConstructor)
QPrinter_shell::QPrinter_shell(QPrinter::PrinterMode mode0)
    : QPrinter(mode0)
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QPrinter::QPrinter_shell(QPrinter::PrinterMode mode0)", QPrinter_shell::__shell())
    QPrinter_shell::__shell()->constructed(typeid(QPrinter));
}

QPrinter_shell::QPrinter_shell(const QPrinterInfo& printer0, QPrinter::PrinterMode mode1)
    : QPrinter(printer0, mode1)
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QPrinter::QPrinter_shell(const QPrinterInfo& printer0, QPrinter::PrinterMode mode1)", QPrinter_shell::__shell())
    QPrinter_shell::__shell()->constructed(typeid(QPrinter));
}

// emitting (writeShellDestructor)
QPrinter_shell::~QPrinter_shell()
{
    QTJAMBI_IN_DESTRUCTOR_CALL("QPrinter::~QPrinter()", QPrinter_shell::__shell())
    if(QPainter* painter = QPrinter_shell::sharedPainter()){
        if(painter->isActive()){
            painter->end();
        }
    }
    QPrinter_shell::__shell()->destructed(typeid(QPrinter));
}

void QPrinter_shell::operator delete(void * ptr) noexcept {
    reinterpret_cast<QPrinter_shell*>(ptr)->QPrinter_shell::__shell()->tryDeleteShell(typeid(QPrinter));
}

// emitting Virtual overrides (virtualFunctions)
void QPrinter_shell::initPainter(QPainter* painter0) const
{
    if(jmethodID method_id = __shell_javaMethod(0)){
        QTJAMBI_JAVA_METHOD_CALL("QPrinter::", QPrinter_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QPrinter_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_painter0 = qtjambi_cast<jobject>(__jni_env, painter0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_painter0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_painter0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QPrinter_shell::__shell()->warnForMethod("QPrinter::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QPrinter::");
            } QTJAMBI_TRY_END
        }else{
            QPagedPaintDevice::initPainter(painter0);
        }
    }else{
        QPagedPaintDevice::initPainter(painter0);
    }
}

int QPrinter_shell::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    if(jmethodID method_id = __shell_javaMethod(1)){
        QTJAMBI_JAVA_METHOD_CALL("QPrinter::metric(QPaintDevice::PaintDeviceMetric)const", QPrinter_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QPrinter_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_arg__1 = qtjambi_cast<jobject>(__jni_env, arg__1);
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id, __java_arg__1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QPrinter_shell::__shell()->warnForMethod("QPrinter::metric(QPaintDevice::PaintDeviceMetric)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QPrinter::metric(QPaintDevice::PaintDeviceMetric)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPrinter::metric(QPaintDevice::PaintDeviceMetric(arg__1));
        }
    }else{
        return QPrinter::metric(QPaintDevice::PaintDeviceMetric(arg__1));
    }
}

bool QPrinter_shell::newPage()
{
    if(jmethodID method_id = __shell_javaMethod(2)){
        QTJAMBI_JAVA_METHOD_CALL("QPrinter::newPage()", QPrinter_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QPrinter_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QPrinter_shell::__shell()->warnForMethod("QPrinter::newPage()");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QPrinter::newPage()");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPrinter::newPage();
        }
    }else{
        return QPrinter::newPage();
    }
}

QPaintEngine* QPrinter_shell::paintEngine() const
{
    if(jmethodID method_id = __shell_javaMethod(3)){
        QTJAMBI_JAVA_METHOD_CALL("QPrinter::paintEngine()const", QPrinter_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QPaintEngine*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QPrinter_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QPaintEngine* >(__jni_env, __java_return_value);
                } else {
                    QPrinter_shell::__shell()->warnForMethod("QPrinter::paintEngine()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QPrinter::paintEngine()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPrinter::paintEngine();
        }
    }else{
        return QPrinter::paintEngine();
    }
}

QPaintDevice* QPrinter_shell::redirected(QPoint* offset0) const
{
    if(jmethodID method_id = __shell_javaMethod(4)){
        QTJAMBI_JAVA_METHOD_CALL("QPrinter::", QPrinter_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QPaintDevice*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QPrinter_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_offset0 = qtjambi_cast<jobject>(__jni_env, offset0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_offset0);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_offset0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QPaintDevice* >(__jni_env, __java_return_value);
                } else {
                    QPrinter_shell::__shell()->warnForMethod("QPrinter::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QPrinter::");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPagedPaintDevice::redirected(offset0);
        }
    }else{
        return QPagedPaintDevice::redirected(offset0);
    }
}

bool QPrinter_shell::setPageLayout(const QPageLayout& pageLayout0)
{
    if(jmethodID method_id = __shell_javaMethod(5)){
        QTJAMBI_JAVA_METHOD_CALL("QPrinter::", QPrinter_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QPrinter_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_pageLayout0 = qtjambi_cast<jobject>(__jni_env, pageLayout0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_pageLayout0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QPrinter_shell::__shell()->warnForMethod("QPrinter::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QPrinter::");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPagedPaintDevice::setPageLayout(pageLayout0);
        }
    }else{
        return QPagedPaintDevice::setPageLayout(pageLayout0);
    }
}

bool QPrinter_shell::setPageMargins(const QMarginsF& margins0, QPageLayout::Unit units1)
{
    if(jmethodID method_id = __shell_javaMethod(6)){
        QTJAMBI_JAVA_METHOD_CALL("QPrinter::", QPrinter_shell::__shell())
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QPrinter_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_margins0 = qtjambi_cast<jobject>(__jni_env, margins0);
                    jobject __java_units1 = qtjambi_cast<jobject>(__jni_env, units1);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_margins0, __java_units1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QPrinter_shell::__shell()->warnForMethod("QPrinter::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QPrinter::");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPagedPaintDevice::setPageMargins(margins0, QPageLayout::Unit(units1));
        }
    }else{
        return QPagedPaintDevice::setPageMargins(margins0, QPageLayout::Unit(units1));
    }
}

bool QPrinter_shell::setPageOrientation(QPageLayout::Orientation orientation0)
{
    if(jmethodID method_id = __shell_javaMethod(7)){
        QTJAMBI_JAVA_METHOD_CALL("QPrinter::", QPrinter_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QPrinter_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_orientation0 = qtjambi_cast<jobject>(__jni_env, orientation0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_orientation0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QPrinter_shell::__shell()->warnForMethod("QPrinter::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QPrinter::");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPagedPaintDevice::setPageOrientation(QPageLayout::Orientation(orientation0));
        }
    }else{
        return QPagedPaintDevice::setPageOrientation(QPageLayout::Orientation(orientation0));
    }
}

void QPrinter_shell::setPageRanges(const QPageRanges& ranges0)
{
    if(jmethodID method_id = __shell_javaMethod(8)){
        QTJAMBI_JAVA_METHOD_CALL("QPrinter::", QPrinter_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QPrinter_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_ranges0 = qtjambi_cast<jobject>(__jni_env, ranges0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_ranges0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QPrinter_shell::__shell()->warnForMethod("QPrinter::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QPrinter::");
            } QTJAMBI_TRY_END
        }else{
            QPagedPaintDevice::setPageRanges(ranges0);
        }
    }else{
        QPagedPaintDevice::setPageRanges(ranges0);
    }
}

bool QPrinter_shell::setPageSize(const QPageSize& pageSize0)
{
    if(jmethodID method_id = __shell_javaMethod(9)){
        QTJAMBI_JAVA_METHOD_CALL("QPrinter::", QPrinter_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QPrinter_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_pageSize0 = qtjambi_cast<jobject>(__jni_env, pageSize0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_pageSize0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QPrinter_shell::__shell()->warnForMethod("QPrinter::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QPrinter::");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPagedPaintDevice::setPageSize(pageSize0);
        }
    }else{
        return QPagedPaintDevice::setPageSize(pageSize0);
    }
}

QPainter* QPrinter_shell::sharedPainter() const
{
    if(jmethodID method_id = __shell_javaMethod(10)){
        QTJAMBI_JAVA_METHOD_CALL("QPrinter::", QPrinter_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QPainter*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QPrinter_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QPainter* >(__jni_env, __java_return_value);
                } else {
                    QPrinter_shell::__shell()->warnForMethod("QPrinter::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QPrinter::");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPagedPaintDevice::sharedPainter();
        }
    }else{
        return QPagedPaintDevice::sharedPainter();
    }
}

// emitting Functions in shell class (nonVirtualShellFunctions)
// emitting Public Override Functions (publicOverrideFunctions)
void QPrinter_access::__qt_setEngines_QPrintEngine_ptr_QPaintEngine_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID printEngine0, QtJambiNativeID paintEngine1)
{
    Q_UNUSED(__jni_env)
    Q_UNUSED(__this_nativeId)
    QPrintEngine* __qt_printEngine0 = QtJambiAPI::objectFromNativeId<QPrintEngine>(printEngine0);
    QPaintEngine* __qt_paintEngine1 = QtJambiAPI::objectFromNativeId<QPaintEngine>(paintEngine1);
    QPrinter::setEngines(__qt_printEngine0, __qt_paintEngine1);
}

// emitting Virtual Override Functions (virtualOverrideFunctions)
void QPrinter_access::__qt_initPainter_QPainter_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID painter0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QPainter* __qt_painter0 = QtJambiAPI::objectFromNativeId<QPainter>(painter0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPagedPaintDevice::initPainter(__qt_painter0);
    } else {
        initPainter(__qt_painter0);
    }
}

jint QPrinter_access::__qt_metric_QPaintDevice_PaintDeviceMetric_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint arg__1) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QPaintDevice::PaintDeviceMetric __qt_arg__1 = qtjambi_cast<QPaintDevice::PaintDeviceMetric>(__jni_env, arg__1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        int __qt_return_value = QPrinter::metric(__qt_arg__1);
        return jint(__qt_return_value);
    } else {
        int __qt_return_value = metric(__qt_arg__1);
        return jint(__qt_return_value);
    }
}

jboolean QPrinter_access::__qt_newPage(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QPrinter::newPage();
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = newPage();
        return jboolean(__qt_return_value);
    }
}

jobject QPrinter_access::__qt_paintEngine_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintEngine* __qt_return_value = QPrinter::paintEngine();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QPaintEngine* __qt_return_value = paintEngine();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QPrinter_access::__qt_redirected_QPoint_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID offset0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QPoint* __qt_offset0 = QtJambiAPI::objectFromNativeId<QPoint>(offset0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintDevice* __qt_return_value = QPagedPaintDevice::redirected(__qt_offset0);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QPaintDevice* __qt_return_value = redirected(__qt_offset0);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jboolean QPrinter_access::__qt_setPageLayout_cref_QPageLayout(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID pageLayout0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    const QPageLayout& __qt_pageLayout0 = QtJambiAPI::valueReferenceFromNativeId<QPageLayout>(pageLayout0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QPagedPaintDevice::setPageLayout(__qt_pageLayout0);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = setPageLayout(__qt_pageLayout0);
        return jboolean(__qt_return_value);
    }
}

jboolean QPrinter_access::__qt_setPageMargins_cref_QMarginsF_QPageLayout_Unit(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID margins0, jint units1)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    const QMarginsF& __qt_margins0 = QtJambiAPI::valueReferenceFromNativeId<QMarginsF>(margins0);
    QPageLayout::Unit __qt_units1 = qtjambi_cast<QPageLayout::Unit>(__jni_env, units1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QPagedPaintDevice::setPageMargins(__qt_margins0, __qt_units1);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = setPageMargins(__qt_margins0, __qt_units1);
        return jboolean(__qt_return_value);
    }
}

jboolean QPrinter_access::__qt_setPageOrientation_QPageLayout_Orientation(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint orientation0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QPageLayout::Orientation __qt_orientation0 = qtjambi_cast<QPageLayout::Orientation>(__jni_env, orientation0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QPagedPaintDevice::setPageOrientation(__qt_orientation0);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = setPageOrientation(__qt_orientation0);
        return jboolean(__qt_return_value);
    }
}

void QPrinter_access::__qt_setPageRanges_cref_QPageRanges(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID ranges0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    const QPageRanges& __qt_ranges0 = QtJambiAPI::valueReferenceFromNativeId<QPageRanges>(ranges0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPagedPaintDevice::setPageRanges(__qt_ranges0);
    } else {
        setPageRanges(__qt_ranges0);
    }
}

jboolean QPrinter_access::__qt_setPageSize_cref_QPageSize(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID pageSize0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    const QPageSize& __qt_pageSize0 = QtJambiAPI::valueReferenceFromNativeId<QPageSize>(pageSize0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QPagedPaintDevice::setPageSize(__qt_pageSize0);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = setPageSize(__qt_pageSize0);
        return jboolean(__qt_return_value);
    }
}

jobject QPrinter_access::__qt_sharedPainter_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPainter* __qt_return_value = QPagedPaintDevice::sharedPainter();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QPainter* __qt_return_value = sharedPainter();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}


#endif // !defined(QT_NO_PRINTER)

// emitting (writeConstructors)
// new QPrinter(QPrinter::PrinterMode)
void __qt_construct_QPrinter(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QPrinter(QPrinter::PrinterMode)")
#if !defined(QT_NO_PRINTER)
    Q_UNUSED(__java_arguments)
    QPrinter *__qt_this = new(__qtjambi_ptr) QPrinter_shell();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    Q_UNUSED(__qtjambi_is_generic)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
}

// new QPrinter(QPrinter::PrinterMode)
void __qt_construct_QPrinter_QPrinter_PrinterMode(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QPrinter(QPrinter::PrinterMode)")
#if !defined(QT_NO_PRINTER)
    jobject mode0 = __java_arguments[0].l;
    QPrinter::PrinterMode __qt_mode0 = qtjambi_cast<QPrinter::PrinterMode>(__jni_env, mode0);
    QPrinter *__qt_this = new(__qtjambi_ptr) QPrinter_shell(QPrinter::PrinterMode(__qt_mode0));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    Q_UNUSED(__qtjambi_is_generic)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
}

// QPrinter::QPrinter(QPrinter::PrinterMode)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_initialize_1native__Lio_qt_printsupport_QPrinter_2Lio_qt_printsupport_QPrinter_00024PrinterMode_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject mode0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QPrinter::QPrinter(QPrinter::PrinterMode)")
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        jvalue arguments;
        arguments.l = mode0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QPrinter_QPrinter_PrinterMode, sizeof(QPrinter_shell), typeid(QPrinter), true, &deleter_QPrinter, &arguments);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        Q_UNUSED(mode0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QPrinter(QPrinterInfo,QPrinter::PrinterMode)
void __qt_construct_QPrinter_cref_QPrinterInfo(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QPrinter(QPrinterInfo,QPrinter::PrinterMode)")
#if !defined(QT_NO_PRINTER)
    jobject printer0 = __java_arguments[0].l;
    const QPrinterInfo& __qt_printer0 = qtjambi_cast<const QPrinterInfo& >(__jni_env, printer0);
    QPrinter *__qt_this = new(__qtjambi_ptr) QPrinter_shell(__qt_printer0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    Q_UNUSED(__qtjambi_is_generic)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
}

// new QPrinter(QPrinterInfo,QPrinter::PrinterMode)
void __qt_construct_QPrinter_cref_QPrinterInfo_QPrinter_PrinterMode(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QPrinter(QPrinterInfo,QPrinter::PrinterMode)")
#if !defined(QT_NO_PRINTER)
    jobject printer0 = __java_arguments[0].l;
    const QPrinterInfo& __qt_printer0 = qtjambi_cast<const QPrinterInfo& >(__jni_env, printer0);
    jobject mode1 = __java_arguments[1].l;
    QPrinter::PrinterMode __qt_mode1 = qtjambi_cast<QPrinter::PrinterMode>(__jni_env, mode1);
    QPrinter *__qt_this = new(__qtjambi_ptr) QPrinter_shell(__qt_printer0, QPrinter::PrinterMode(__qt_mode1));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    Q_UNUSED(__qtjambi_is_generic)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
}

// QPrinter::QPrinter(QPrinterInfo,QPrinter::PrinterMode)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_initialize_1native__Lio_qt_printsupport_QPrinter_2Lio_qt_printsupport_QPrinterInfo_2Lio_qt_printsupport_QPrinter_00024PrinterMode_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject printer0,
 jobject mode1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QPrinter::QPrinter(QPrinterInfo,QPrinter::PrinterMode)")
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        jvalue arguments[2];
        arguments[0].l = printer0;
        arguments[1].l = mode1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QPrinter_cref_QPrinterInfo_QPrinter_PrinterMode, sizeof(QPrinter_shell), typeid(QPrinter), true, &deleter_QPrinter, arguments);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        Q_UNUSED(printer0)
        Q_UNUSED(mode1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QPrinter_shell
void __qt_destruct_QPrinter(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QPrinter")

#if !defined(QT_NO_PRINTER)

    reinterpret_cast<QPrinter_shell*>(ptr)->~QPrinter_shell();

#else
    Q_UNUSED(ptr)

#endif // !defined(QT_NO_PRINTER)

}

// emitting  (functionsInTargetLang writeFinalFunction)
// QPrinter::abort()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_abort_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::abort()", __qt_this)
        __java_return_value = __qt_this->abort();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::collateCopies()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_collateCopies_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::collateCopies()const", __qt_this)
        __java_return_value = __qt_this->collateCopies();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::colorCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_colorCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::colorCount()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::colorCount();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::colorMode()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_colorMode_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::colorMode()const", __qt_this)
        QPrinter::ColorMode __qt_return_value = __qt_this->colorMode();
        __java_return_value = __qt_return_value;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::copyCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_copyCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::copyCount()const", __qt_this)
        __java_return_value = __qt_this->copyCount();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::creator()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_creator_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::creator()const", __qt_this)
        QString __qt_return_value = __qt_this->creator();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::depth()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_depth_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::depth()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::depth();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::devicePixelRatio()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_devicePixelRatio_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::devicePixelRatio()const", __qt_this)
        qreal __qt_return_value = __qt_this->QPaintDevice::devicePixelRatio();
        __java_return_value = jdouble(__qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::devicePixelRatioF()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_devicePixelRatioF_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::devicePixelRatioF()const", __qt_this)
        qreal __qt_return_value = __qt_this->QPaintDevice::devicePixelRatioF();
        __java_return_value = jdouble(__qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::docName()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_docName_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::docName()const", __qt_this)
        QString __qt_return_value = __qt_this->docName();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::duplex()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_duplex_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::duplex()const", __qt_this)
        QPrinter::DuplexMode __qt_return_value = __qt_this->duplex();
        __java_return_value = __qt_return_value;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::fontEmbeddingEnabled()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_fontEmbeddingEnabled_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::fontEmbeddingEnabled()const", __qt_this)
        __java_return_value = __qt_this->fontEmbeddingEnabled();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::fromPage()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_fromPage_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::fromPage()const", __qt_this)
        __java_return_value = __qt_this->fromPage();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::fullPage()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_fullPage_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::fullPage()const", __qt_this)
        __java_return_value = __qt_this->fullPage();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::height()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_height_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::height()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::height();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::heightMM()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_heightMM_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::heightMM()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::heightMM();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::isValid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_isValid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::isValid()const", __qt_this)
        __java_return_value = __qt_this->isValid();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::logicalDpiX()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_logicalDpiX_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::logicalDpiX()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::logicalDpiX();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::logicalDpiY()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_logicalDpiY_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::logicalDpiY()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::logicalDpiY();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::outputFileName()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_outputFileName_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::outputFileName()const", __qt_this)
        QString __qt_return_value = __qt_this->outputFileName();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::outputFormat()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_outputFormat_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::outputFormat()const", __qt_this)
        QPrinter::OutputFormat __qt_return_value = __qt_this->outputFormat();
        __java_return_value = __qt_return_value;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::pageLayout()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_pageLayout_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::pageLayout()const", __qt_this)
        QPageLayout __qt_return_value = __qt_this->QPagedPaintDevice::pageLayout();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::pageOrder()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_pageOrder_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::pageOrder()const", __qt_this)
        QPrinter::PageOrder __qt_return_value = __qt_this->pageOrder();
        __java_return_value = __qt_return_value;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::pageRanges()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_pageRanges_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::pageRanges()const", __qt_this)
        QPageRanges __qt_return_value = __qt_this->QPagedPaintDevice::pageRanges();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::pageRect(QPrinter::Unit)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_pageRect_1native_1QPrinter_1Unit_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint arg__1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::pageRect(QPrinter::Unit)const", __qt_this)
        QPrinter::Unit __qt_arg__1 = qtjambi_cast<QPrinter::Unit>(__jni_env, arg__1);
        QRectF __qt_return_value = __qt_this->pageRect(QPrinter::Unit(__qt_arg__1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(arg__1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::paintingActive()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_paintingActive_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::paintingActive()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::paintingActive();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::paperRect(QPrinter::Unit)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_paperRect_1native_1QPrinter_1Unit_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint arg__1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::paperRect(QPrinter::Unit)const", __qt_this)
        QPrinter::Unit __qt_arg__1 = qtjambi_cast<QPrinter::Unit>(__jni_env, arg__1);
        QRectF __qt_return_value = __qt_this->paperRect(QPrinter::Unit(__qt_arg__1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(arg__1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::paperSource()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_paperSource_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::paperSource()const", __qt_this)
        QPrinter::PaperSource __qt_return_value = __qt_this->paperSource();
        __java_return_value = __qt_return_value;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::pdfVersion()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_pdfVersion_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::pdfVersion()const", __qt_this)
        QPagedPaintDevice::PdfVersion __qt_return_value = __qt_this->pdfVersion();
        __java_return_value = __qt_return_value;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::physicalDpiX()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_physicalDpiX_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::physicalDpiX()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::physicalDpiX();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::physicalDpiY()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_physicalDpiY_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::physicalDpiY()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::physicalDpiY();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::printEngine()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_printEngine_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::printEngine()const", __qt_this)
        QPrintEngine* __qt_return_value = __qt_this->printEngine();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::printProgram()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_printProgram_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::printProgram()const", __qt_this)
        QString __qt_return_value = __qt_this->printProgram();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::printRange()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_printRange_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::printRange()const", __qt_this)
        QPrinter::PrintRange __qt_return_value = __qt_this->printRange();
        __java_return_value = __qt_return_value;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::printerName()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_printerName_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::printerName()const", __qt_this)
        QString __qt_return_value = __qt_this->printerName();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::printerSelectionOption()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_printerSelectionOption_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::printerSelectionOption()const", __qt_this)
        QString __qt_return_value = __qt_this->printerSelectionOption();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::printerState()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_printerState_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::printerState()const", __qt_this)
        QPrinter::PrinterState __qt_return_value = __qt_this->printerState();
        __java_return_value = __qt_return_value;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::resolution()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_resolution_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::resolution()const", __qt_this)
        __java_return_value = __qt_this->resolution();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::setCollateCopies(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setCollateCopies_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean collate0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setCollateCopies(bool)", __qt_this)
        __qt_this->setCollateCopies(static_cast<bool>(collate0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(collate0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPrinter::setColorMode(QPrinter::ColorMode)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setColorMode_1native_1QPrinter_1ColorMode__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setColorMode(QPrinter::ColorMode)", __qt_this)
        QPrinter::ColorMode __qt_arg__1 = qtjambi_cast<QPrinter::ColorMode>(__jni_env, arg__1);
        __qt_this->setColorMode(QPrinter::ColorMode(__qt_arg__1));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(arg__1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPrinter::setCopyCount(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setCopyCount_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setCopyCount(int)", __qt_this)
        __qt_this->setCopyCount(static_cast<int>(arg__1));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(arg__1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPrinter::setCreator(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setCreator_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setCreator(QString)", __qt_this)
        QString  __qt_arg__1 = qtjambi_cast<QString>(__jni_env, arg__1);
        __qt_this->setCreator(__qt_arg__1);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(arg__1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPrinter::setDocName(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setDocName_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setDocName(QString)", __qt_this)
        QString  __qt_arg__1 = qtjambi_cast<QString>(__jni_env, arg__1);
        __qt_this->setDocName(__qt_arg__1);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(arg__1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPrinter::setDuplex(QPrinter::DuplexMode)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setDuplex_1native_1QPrinter_1DuplexMode__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint duplex0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setDuplex(QPrinter::DuplexMode)", __qt_this)
        QPrinter::DuplexMode __qt_duplex0 = qtjambi_cast<QPrinter::DuplexMode>(__jni_env, duplex0);
        __qt_this->setDuplex(QPrinter::DuplexMode(__qt_duplex0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(duplex0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPrinter::setEngines(QPrintEngine*,QPaintEngine*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setEngines_1native_1QPrintEngine_1ptr_1QPaintEngine_1ptr__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID printEngine0,
 QtJambiNativeID paintEngine1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setEngines(QPrintEngine*,QPaintEngine*)", __qt_this)
        static_cast<QPrinter_access*>(__qt_this)->__qt_setEngines_QPrintEngine_ptr_QPaintEngine_ptr(__jni_env, __this_nativeId, printEngine0, paintEngine1);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(printEngine0)
        Q_UNUSED(paintEngine1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPrinter::setFontEmbeddingEnabled(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setFontEmbeddingEnabled_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean enable0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setFontEmbeddingEnabled(bool)", __qt_this)
        __qt_this->setFontEmbeddingEnabled(static_cast<bool>(enable0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(enable0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPrinter::setFromTo(int,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setFromTo_1native_1int_1int__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint fromPage0,
 jint toPage1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setFromTo(int,int)", __qt_this)
        __qt_this->setFromTo(static_cast<int>(fromPage0), static_cast<int>(toPage1));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(fromPage0)
        Q_UNUSED(toPage1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPrinter::setFullPage(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setFullPage_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setFullPage(bool)", __qt_this)
        __qt_this->setFullPage(static_cast<bool>(arg__1));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(arg__1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPrinter::setOutputFileName(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setOutputFileName_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setOutputFileName(QString)", __qt_this)
        QString  __qt_arg__1 = qtjambi_cast<QString>(__jni_env, arg__1);
        __qt_this->setOutputFileName(__qt_arg__1);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(arg__1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPrinter::setOutputFormat(QPrinter::OutputFormat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setOutputFormat_1native_1QPrinter_1OutputFormat__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint format0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setOutputFormat(QPrinter::OutputFormat)", __qt_this)
        QPrinter::OutputFormat __qt_format0 = qtjambi_cast<QPrinter::OutputFormat>(__jni_env, format0);
        __qt_this->setOutputFormat(QPrinter::OutputFormat(__qt_format0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(format0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPrinter::setPageOrder(QPrinter::PageOrder)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setPageOrder_1native_1QPrinter_1PageOrder__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setPageOrder(QPrinter::PageOrder)", __qt_this)
        QPrinter::PageOrder __qt_arg__1 = qtjambi_cast<QPrinter::PageOrder>(__jni_env, arg__1);
        __qt_this->setPageOrder(QPrinter::PageOrder(__qt_arg__1));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(arg__1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPrinter::setPaperSource(QPrinter::PaperSource)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setPaperSource_1native_1QPrinter_1PaperSource__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setPaperSource(QPrinter::PaperSource)", __qt_this)
        QPrinter::PaperSource __qt_arg__1 = qtjambi_cast<QPrinter::PaperSource>(__jni_env, arg__1);
        __qt_this->setPaperSource(QPrinter::PaperSource(__qt_arg__1));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(arg__1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPrinter::setPdfVersion(QPagedPaintDevice::PdfVersion)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setPdfVersion_1native_1QPagedPaintDevice_1PdfVersion__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint version0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setPdfVersion(QPagedPaintDevice::PdfVersion)", __qt_this)
        QPagedPaintDevice::PdfVersion __qt_version0 = qtjambi_cast<QPagedPaintDevice::PdfVersion>(__jni_env, version0);
        __qt_this->setPdfVersion(QPagedPaintDevice::PdfVersion(__qt_version0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(version0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPrinter::setPrintProgram(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setPrintProgram_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setPrintProgram(QString)", __qt_this)
        QString  __qt_arg__1 = qtjambi_cast<QString>(__jni_env, arg__1);
        __qt_this->setPrintProgram(__qt_arg__1);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(arg__1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPrinter::setPrintRange(QPrinter::PrintRange)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setPrintRange_1native_1QPrinter_1PrintRange__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint range0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setPrintRange(QPrinter::PrintRange)", __qt_this)
        QPrinter::PrintRange __qt_range0 = qtjambi_cast<QPrinter::PrintRange>(__jni_env, range0);
        __qt_this->setPrintRange(QPrinter::PrintRange(__qt_range0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(range0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPrinter::setPrinterName(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setPrinterName_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setPrinterName(QString)", __qt_this)
        QString  __qt_arg__1 = qtjambi_cast<QString>(__jni_env, arg__1);
        __qt_this->setPrinterName(__qt_arg__1);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(arg__1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPrinter::setPrinterSelectionOption(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setPrinterSelectionOption_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setPrinterSelectionOption(QString)", __qt_this)
        QString  __qt_arg__1 = qtjambi_cast<QString>(__jni_env, arg__1);
        __qt_this->setPrinterSelectionOption(__qt_arg__1);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(arg__1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPrinter::setResolution(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setResolution_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setResolution(int)", __qt_this)
        __qt_this->setResolution(static_cast<int>(arg__1));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(arg__1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPrinter::supportedResolutions()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_supportedResolutions_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::supportedResolutions()const", __qt_this)
        QList<int> __qt_return_value = __qt_this->supportedResolutions();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::supportsMultipleCopies()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_supportsMultipleCopies_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::supportsMultipleCopies()const", __qt_this)
        __java_return_value = __qt_this->supportsMultipleCopies();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::toPage()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_toPage_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::toPage()const", __qt_this)
        __java_return_value = __qt_this->toPage();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::width()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_width_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::width()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::width();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::widthMM()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_widthMM_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::widthMM()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::widthMM();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::initPainter(QPainter*)const
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_initPainter_1native_1QPainter_1ptr_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID painter0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::initPainter(QPainter*)const", __qt_this)
        static_cast<const QPrinter_access*>(__qt_this)->__qt_initPainter_QPainter_ptr_constfct(__jni_env, __this_nativeId, painter0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(painter0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPrinter::metric(QPaintDevice::PaintDeviceMetric)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_metric_1native_1QPaintDevice_1PaintDeviceMetric_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint arg__1)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::metric(QPaintDevice::PaintDeviceMetric)const", __qt_this)
        __java_return_value = static_cast<const QPrinter_access*>(__qt_this)->__qt_metric_QPaintDevice_PaintDeviceMetric_constfct(__jni_env, __this_nativeId, arg__1);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(arg__1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::newPage()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_newPage_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::newPage()", __qt_this)
        __java_return_value = static_cast<QPrinter_access*>(__qt_this)->__qt_newPage(__jni_env, __this_nativeId);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::paintEngine()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_paintEngine_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::paintEngine()const", __qt_this)
        __java_return_value = static_cast<const QPrinter_access*>(__qt_this)->__qt_paintEngine_constfct(__jni_env, __this_nativeId);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::redirected(QPoint*)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_redirected_1native_1QPoint_1ptr_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID offset0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::redirected(QPoint*)const", __qt_this)
        __java_return_value = static_cast<const QPrinter_access*>(__qt_this)->__qt_redirected_QPoint_ptr_constfct(__jni_env, __this_nativeId, offset0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(offset0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::setPageLayout(QPageLayout)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setPageLayout_1native_1cref_1QPageLayout__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID pageLayout0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setPageLayout(QPageLayout)", __qt_this)
        __java_return_value = static_cast<QPrinter_access*>(__qt_this)->__qt_setPageLayout_cref_QPageLayout(__jni_env, __this_nativeId, pageLayout0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(pageLayout0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::setPageMargins(QMarginsF,QPageLayout::Unit)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setPageMargins_1native_1cref_1QMarginsF_1QPageLayout_1Unit__JJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID margins0,
 jint units1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setPageMargins(QMarginsF,QPageLayout::Unit)", __qt_this)
        __java_return_value = static_cast<QPrinter_access*>(__qt_this)->__qt_setPageMargins_cref_QMarginsF_QPageLayout_Unit(__jni_env, __this_nativeId, margins0, units1);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(margins0)
        Q_UNUSED(units1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::setPageOrientation(QPageLayout::Orientation)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setPageOrientation_1native_1QPageLayout_1Orientation__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint orientation0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setPageOrientation(QPageLayout::Orientation)", __qt_this)
        __java_return_value = static_cast<QPrinter_access*>(__qt_this)->__qt_setPageOrientation_QPageLayout_Orientation(__jni_env, __this_nativeId, orientation0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(orientation0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::setPageRanges(QPageRanges)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setPageRanges_1native_1cref_1QPageRanges__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID ranges0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setPageRanges(QPageRanges)", __qt_this)
        static_cast<QPrinter_access*>(__qt_this)->__qt_setPageRanges_cref_QPageRanges(__jni_env, __this_nativeId, ranges0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(ranges0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPrinter::setPageSize(QPageSize)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_setPageSize_1native_1cref_1QPageSize__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID pageSize0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::setPageSize(QPageSize)", __qt_this)
        __java_return_value = static_cast<QPrinter_access*>(__qt_this)->__qt_setPageSize_cref_QPageSize(__jni_env, __this_nativeId, pageSize0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(pageSize0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::sharedPainter()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_sharedPainter_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        const QPrinter *__qt_this = QtJambiAPI::objectFromNativeId<QPrinter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPrinter::sharedPainter()const", __qt_this)
        __java_return_value = static_cast<const QPrinter_access*>(__qt_this)->__qt_sharedPainter_constfct(__jni_env, __this_nativeId);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPrinter::devicePixelRatioFScale()
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_printsupport_QPrinter_devicePixelRatioFScale__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QPrinter::devicePixelRatioFScale()")
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_PRINTER)
        qreal __qt_return_value = QPrinter::devicePixelRatioFScale();
        __java_return_value = jdouble(__qt_return_value);
#else
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_PRINTER)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QPrinter(){
    using namespace RegistryAPI;

#if !defined(QT_NO_PRINTER)

    const std::type_info& typeId = registerObjectTypeInfo<QPrinter>("QPrinter", "io/qt/printsupport/QPrinter");
// BEGIN: function table
    registerFunctionInfos(typeId, {
        FunctionInfo(/*  0 */ "initPainter", "(Lio/qt/gui/QPainter;)V"),
        FunctionInfo(/*  1 */ "metric", "(Lio/qt/gui/QPaintDevice$PaintDeviceMetric;)I"),
        FunctionInfo(/*  2 */ "newPage", "()Z"),
        FunctionInfo(/*  3 */ "paintEngine", "()Lio/qt/gui/QPaintEngine;"),
        FunctionInfo(/*  4 */ "redirected", "(Lio/qt/core/QPoint;)Lio/qt/gui/QPaintDevice;"),
        FunctionInfo(/*  5 */ "setPageLayout", "(Lio/qt/gui/QPageLayout;)Z"),
        FunctionInfo(/*  6 */ "setPageMargins", "(Lio/qt/core/QMarginsF;Lio/qt/gui/QPageLayout$Unit;)Z"),
        FunctionInfo(/*  7 */ "setPageOrientation", "(Lio/qt/gui/QPageLayout$Orientation;)Z"),
        FunctionInfo(/*  8 */ "setPageRanges", "(Lio/qt/gui/QPageRanges;)V"),
        FunctionInfo(/*  9 */ "setPageSize", "(Lio/qt/gui/QPageSize;)Z"),
        FunctionInfo(/* 10 */ "sharedPainter", "()Lio/qt/gui/QPainter;")});
    registerConstructorInfos(typeId, &__qt_destruct_QPrinter, {
        ConstructorInfo(&__qt_construct_QPrinter, nullptr)
       ,ConstructorInfo(&__qt_construct_QPrinter_QPrinter_PrinterMode, "Lio/qt/printsupport/QPrinter$PrinterMode;")
       ,ConstructorInfo(&__qt_construct_QPrinter_cref_QPrinterInfo, "Lio/qt/printsupport/QPrinterInfo;")
       ,ConstructorInfo(&__qt_construct_QPrinter_cref_QPrinterInfo_QPrinter_PrinterMode, "Lio/qt/printsupport/QPrinterInfo;Lio/qt/printsupport/QPrinter$PrinterMode;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QPrinter);
    registerSizeOfShell(typeId, sizeof(QPrinter_shell));
// END: type registration

// BEGIN: polymorphic ids
    registerPolymorphyHandler(typeid(QPagedPaintDevice), typeId, [](void *ptr, qintptr& offset) -> bool {
            QPagedPaintDevice *object = reinterpret_cast<QPagedPaintDevice *>(ptr);
            Q_ASSERT(object);
            bool _result = false;
            QTJAMBI_TRY_ANY {
                if(QPrinter* _object = dynamic_cast<QPrinter*>(object)){
                    offset = qintptr(object)-qintptr(_object);
                    _result = true;
                }
            } QTJAMBI_CATCH_ANY{
            } QTJAMBI_TRY_END
            return _result;
        });
    registerPolymorphyHandler(typeid(QPaintDevice), typeId, [](void *ptr, qintptr& offset) -> bool {
            QPaintDevice *object = reinterpret_cast<QPaintDevice *>(ptr);
            Q_ASSERT(object);
            bool _result = false;
            QTJAMBI_TRY_ANY {
                if(QPrinter* _object = dynamic_cast<QPrinter*>(object)){
                    offset = qintptr(object)-qintptr(_object);
                    _result = true;
                }
            } QTJAMBI_CATCH_ANY{
            } QTJAMBI_TRY_END
            return _result;
        });
// END: polymorphic ids

    registerInterfaceOffset(typeId, typeid(QPagedPaintDevice), int(reinterpret_cast<quintptr>(static_cast<QPagedPaintDevice *>(reinterpret_cast<QPrinter *>(0x10000000)))) - 0x10000000);
    registerInterfaceOffset(typeId, typeid(QPaintDevice), int(reinterpret_cast<quintptr>(static_cast<QPaintDevice *>(reinterpret_cast<QPrinter *>(0x10000000)))) - 0x10000000);

// BEGIN: enums and flags

#if !defined(QT_NO_PRINTER)
    registerEnumTypeInfo<QPrinter::ColorMode>("QPrinter::ColorMode", "io/qt/printsupport/QPrinter$ColorMode");
#endif //!defined(QT_NO_PRINTER)

#if !defined(QT_NO_PRINTER)
    registerEnumTypeInfo<QPrinter::DuplexMode>("QPrinter::DuplexMode", "io/qt/printsupport/QPrinter$DuplexMode");
#endif //!defined(QT_NO_PRINTER)

#if !defined(QT_NO_PRINTER)
    registerEnumTypeInfo<QPrinter::OutputFormat>("QPrinter::OutputFormat", "io/qt/printsupport/QPrinter$OutputFormat");
#endif //!defined(QT_NO_PRINTER)

#if !defined(QT_NO_PRINTER)
    registerEnumTypeInfo<QPrinter::PageOrder>("QPrinter::PageOrder", "io/qt/printsupport/QPrinter$PageOrder");
#endif //!defined(QT_NO_PRINTER)

#if !defined(QT_NO_PRINTER)
    registerEnumTypeInfo<QPrinter::PaperSource>("QPrinter::PaperSource", "io/qt/printsupport/QPrinter$PaperSource");
#endif //!defined(QT_NO_PRINTER)

#if !defined(QT_NO_PRINTER)
    registerEnumTypeInfo<QPrinter::PrintRange>("QPrinter::PrintRange", "io/qt/printsupport/QPrinter$PrintRange");
#endif //!defined(QT_NO_PRINTER)

#if !defined(QT_NO_PRINTER)
    registerEnumTypeInfo<QPrinter::PrinterMode>("QPrinter::PrinterMode", "io/qt/printsupport/QPrinter$PrinterMode");
#endif //!defined(QT_NO_PRINTER)

#if !defined(QT_NO_PRINTER)
    registerEnumTypeInfo<QPrinter::PrinterState>("QPrinter::PrinterState", "io/qt/printsupport/QPrinter$PrinterState");
#endif //!defined(QT_NO_PRINTER)

#if !defined(QT_NO_PRINTER)
    registerEnumTypeInfo<QPrinter::Unit>("QPrinter::Unit", "io/qt/printsupport/QPrinter$Unit");
#endif //!defined(QT_NO_PRINTER)
// END: enums and flags

#endif //!defined(QT_NO_PRINTER)

}
