#include <QtCore/QtGlobal>
#include <QtPositioning/qgeorectangle.h>
#include <QtCore/QList>
#include <QtCore/QVariant>
#include <QtCore/qdatastream.h>
#include <QtCore/qdebug.h>
#include <QtPositioning/qgeocoordinate.h>
#include <QtPositioning/qgeoshape.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiPositioning/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QGeoRectangle(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QGeoRectangle")
    QGeoRectangle *_ptr = reinterpret_cast<QGeoRectangle *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QGeoRectangle()
void __qt_construct_QGeoRectangle(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QGeoRectangle()")
    Q_UNUSED(__java_arguments)
    QGeoRectangle *__qt_this = new(__qtjambi_ptr) QGeoRectangle();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QGeoRectangle::QGeoRectangle()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_initialize_1native__Lio_qt_positioning_QGeoRectangle_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QGeoRectangle::QGeoRectangle()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QGeoRectangle, sizeof(QGeoRectangle), typeid(QGeoRectangle), false, &deleter_QGeoRectangle, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QGeoRectangle(QGeoCoordinate,QGeoCoordinate)
void __qt_construct_QGeoRectangle_cref_QGeoCoordinate_cref_QGeoCoordinate(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QGeoRectangle(QGeoCoordinate,QGeoCoordinate)")
    jobject topLeft0 = __java_arguments[0].l;
    const QGeoCoordinate& __qt_topLeft0 = qtjambi_cast<const QGeoCoordinate& >(__jni_env, topLeft0);
    jobject bottomRight1 = __java_arguments[1].l;
    const QGeoCoordinate& __qt_bottomRight1 = qtjambi_cast<const QGeoCoordinate& >(__jni_env, bottomRight1);
    QGeoRectangle *__qt_this = new(__qtjambi_ptr) QGeoRectangle(__qt_topLeft0, __qt_bottomRight1);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QGeoRectangle::QGeoRectangle(QGeoCoordinate,QGeoCoordinate)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_initialize_1native__Lio_qt_positioning_QGeoRectangle_2Lio_qt_positioning_QGeoCoordinate_2Lio_qt_positioning_QGeoCoordinate_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject topLeft0,
 jobject bottomRight1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QGeoRectangle::QGeoRectangle(QGeoCoordinate,QGeoCoordinate)")
    QTJAMBI_TRY {
        jvalue arguments[2];
        arguments[0].l = topLeft0;
        arguments[1].l = bottomRight1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QGeoRectangle_cref_QGeoCoordinate_cref_QGeoCoordinate, sizeof(QGeoRectangle), typeid(QGeoRectangle), false, &deleter_QGeoRectangle, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QGeoRectangle(QGeoCoordinate,double,double)
void __qt_construct_QGeoRectangle_cref_QGeoCoordinate_double_double(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QGeoRectangle(QGeoCoordinate,double,double)")
    jobject center0 = __java_arguments[0].l;
    const QGeoCoordinate& __qt_center0 = qtjambi_cast<const QGeoCoordinate& >(__jni_env, center0);
    jdouble degreesWidth1 = __java_arguments[1].d;
    Q_UNUSED(degreesWidth1)
    jdouble degreesHeight2 = __java_arguments[2].d;
    Q_UNUSED(degreesHeight2)
    QGeoRectangle *__qt_this = new(__qtjambi_ptr) QGeoRectangle(__qt_center0, static_cast<double>(degreesWidth1), static_cast<double>(degreesHeight2));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QGeoRectangle::QGeoRectangle(QGeoCoordinate,double,double)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_initialize_1native__Lio_qt_positioning_QGeoRectangle_2Lio_qt_positioning_QGeoCoordinate_2DD)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject center0,
 jdouble degreesWidth1,
 jdouble degreesHeight2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QGeoRectangle::QGeoRectangle(QGeoCoordinate,double,double)")
    QTJAMBI_TRY {
        jvalue arguments[3];
        arguments[0].l = center0;
        arguments[1].d = degreesWidth1;
        arguments[2].d = degreesHeight2;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QGeoRectangle_cref_QGeoCoordinate_double_double, sizeof(QGeoRectangle), typeid(QGeoRectangle), false, &deleter_QGeoRectangle, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QGeoRectangle(QGeoRectangle)
void __qt_construct_QGeoRectangle_cref_QGeoRectangle(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QGeoRectangle(QGeoRectangle)")
    jobject other0 = __java_arguments[0].l;
    const QGeoRectangle& __qt_other0 = qtjambi_cast<const QGeoRectangle& >(__jni_env, other0);
    QGeoRectangle *__qt_this = new(__qtjambi_ptr) QGeoRectangle(__qt_other0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QGeoRectangle::QGeoRectangle(QGeoRectangle)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_initialize_1native__Lio_qt_positioning_QGeoRectangle_2Lio_qt_positioning_QGeoRectangle_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QGeoRectangle::QGeoRectangle(QGeoRectangle)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QGeoRectangle_cref_QGeoRectangle, sizeof(QGeoRectangle), typeid(QGeoRectangle), false, &deleter_QGeoRectangle, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QGeoRectangle(QGeoShape)
void __qt_construct_QGeoRectangle_cref_QGeoShape(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QGeoRectangle(QGeoShape)")
    jobject other0 = __java_arguments[0].l;
    const QGeoShape& __qt_other0 = qtjambi_cast<const QGeoShape& >(__jni_env, other0);
    QGeoRectangle *__qt_this = new(__qtjambi_ptr) QGeoRectangle(__qt_other0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QGeoRectangle::QGeoRectangle(QGeoShape)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_initialize_1native__Lio_qt_positioning_QGeoRectangle_2Lio_qt_positioning_QGeoShape_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QGeoRectangle::QGeoRectangle(QGeoShape)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QGeoRectangle_cref_QGeoShape, sizeof(QGeoRectangle), typeid(QGeoRectangle), false, &deleter_QGeoRectangle, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QGeoRectangle(QList<QGeoCoordinate>)
void __qt_construct_QGeoRectangle_cref_QList(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QGeoRectangle(QList<QGeoCoordinate>)")
    QtJambiScope __qtjambi_scope;
    jobject coordinates0 = __java_arguments[0].l;
    const QList<QGeoCoordinate>&  __qt_coordinates0 = qtjambi_cast<const QList<QGeoCoordinate>& >(__jni_env, __qtjambi_scope, coordinates0);
    QGeoRectangle *__qt_this = new(__qtjambi_ptr) QGeoRectangle(__qt_coordinates0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QGeoRectangle::QGeoRectangle(QList<QGeoCoordinate>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_initialize_1native__Lio_qt_positioning_QGeoRectangle_2Ljava_util_Collection_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject coordinates0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QGeoRectangle::QGeoRectangle(QList<QGeoCoordinate>)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = coordinates0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QGeoRectangle_cref_QList, sizeof(QGeoRectangle), typeid(QGeoRectangle), false, &deleter_QGeoRectangle, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QGeoRectangle
void __qt_destruct_QGeoRectangle(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QGeoRectangle")
    reinterpret_cast<QGeoRectangle*>(ptr)->~QGeoRectangle();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QGeoRectangle::bottomLeft()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_bottomLeft_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::bottomLeft()const", __qt_this)
        QGeoCoordinate __qt_return_value = __qt_this->bottomLeft();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoRectangle::bottomRight()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_bottomRight_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::bottomRight()const", __qt_this)
        QGeoCoordinate __qt_return_value = __qt_this->bottomRight();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoRectangle::contains(QGeoRectangle)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_contains_1native_1cref_1QGeoRectangle_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rectangle0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::contains(QGeoRectangle)const", __qt_this)
        const QGeoRectangle& __qt_rectangle0 = QtJambiAPI::valueReferenceFromNativeId<QGeoRectangle>(rectangle0);
        __java_return_value = __qt_this->contains(__qt_rectangle0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoRectangle::extendRectangle(QGeoCoordinate)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_extendRectangle_1native_1cref_1QGeoCoordinate__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID coordinate0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::extendRectangle(QGeoCoordinate)", __qt_this)
        const QGeoCoordinate& __qt_coordinate0 = QtJambiAPI::valueReferenceFromNativeId<QGeoCoordinate>(coordinate0);
        __qt_this->extendRectangle(__qt_coordinate0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRectangle::height()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_height_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::height()const", __qt_this)
        __java_return_value = __qt_this->height();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoRectangle::intersects(QGeoRectangle)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_intersects_1native_1cref_1QGeoRectangle_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rectangle0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::intersects(QGeoRectangle)const", __qt_this)
        const QGeoRectangle& __qt_rectangle0 = QtJambiAPI::valueReferenceFromNativeId<QGeoRectangle>(rectangle0);
        __java_return_value = __qt_this->intersects(__qt_rectangle0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoRectangle::operator<<(QDataStream&,QGeoRectangle)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID stream0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::operator<<(QDataStream&,QGeoRectangle)", __qt_this)
        QDataStream& __qt_stream0 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, stream0);
        __qt_stream0 << (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRectangle::operator=(QGeoRectangle)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_assign_1native_1cref_1QGeoRectangle__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::operator=(QGeoRectangle)", __qt_this)
        const QGeoRectangle& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QGeoRectangle>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRectangle::operator>>(QDataStream&,QGeoRectangle&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID stream0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::operator>>(QDataStream&,QGeoRectangle&)", __qt_this)
        QDataStream& __qt_stream0 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, stream0);
        __qt_stream0 >> (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRectangle::setBottomLeft(QGeoCoordinate)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_setBottomLeft_1native_1cref_1QGeoCoordinate__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID bottomLeft0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::setBottomLeft(QGeoCoordinate)", __qt_this)
        const QGeoCoordinate& __qt_bottomLeft0 = QtJambiAPI::valueReferenceFromNativeId<QGeoCoordinate>(bottomLeft0);
        __qt_this->setBottomLeft(__qt_bottomLeft0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRectangle::setBottomRight(QGeoCoordinate)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_setBottomRight_1native_1cref_1QGeoCoordinate__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID bottomRight0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::setBottomRight(QGeoCoordinate)", __qt_this)
        const QGeoCoordinate& __qt_bottomRight0 = QtJambiAPI::valueReferenceFromNativeId<QGeoCoordinate>(bottomRight0);
        __qt_this->setBottomRight(__qt_bottomRight0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRectangle::setCenter(QGeoCoordinate)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_setCenter_1native_1cref_1QGeoCoordinate__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID center0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::setCenter(QGeoCoordinate)", __qt_this)
        const QGeoCoordinate& __qt_center0 = QtJambiAPI::valueReferenceFromNativeId<QGeoCoordinate>(center0);
        __qt_this->setCenter(__qt_center0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRectangle::setHeight(double)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_setHeight_1native_1double__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble degreesHeight0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::setHeight(double)", __qt_this)
        __qt_this->setHeight(static_cast<double>(degreesHeight0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRectangle::setTopLeft(QGeoCoordinate)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_setTopLeft_1native_1cref_1QGeoCoordinate__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID topLeft0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::setTopLeft(QGeoCoordinate)", __qt_this)
        const QGeoCoordinate& __qt_topLeft0 = QtJambiAPI::valueReferenceFromNativeId<QGeoCoordinate>(topLeft0);
        __qt_this->setTopLeft(__qt_topLeft0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRectangle::setTopRight(QGeoCoordinate)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_setTopRight_1native_1cref_1QGeoCoordinate__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID topRight0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::setTopRight(QGeoCoordinate)", __qt_this)
        const QGeoCoordinate& __qt_topRight0 = QtJambiAPI::valueReferenceFromNativeId<QGeoCoordinate>(topRight0);
        __qt_this->setTopRight(__qt_topRight0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRectangle::setWidth(double)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_setWidth_1native_1double__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble degreesWidth0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::setWidth(double)", __qt_this)
        __qt_this->setWidth(static_cast<double>(degreesWidth0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRectangle::toString()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_toString_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::toString()const", __qt_this)
        QString __qt_return_value = __qt_this->toString();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoRectangle::topLeft()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_topLeft_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::topLeft()const", __qt_this)
        QGeoCoordinate __qt_return_value = __qt_this->topLeft();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoRectangle::topRight()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_topRight_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::topRight()const", __qt_this)
        QGeoCoordinate __qt_return_value = __qt_this->topRight();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoRectangle::translate(double,double)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_translate_1native_1double_1double__JDD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble degreesLatitude0,
 jdouble degreesLongitude1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::translate(double,double)", __qt_this)
        __qt_this->translate(static_cast<double>(degreesLatitude0), static_cast<double>(degreesLongitude1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRectangle::translated(double,double)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_translated_1native_1double_1double_1constfct__JDD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble degreesLatitude0,
 jdouble degreesLongitude1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::translated(double,double)const", __qt_this)
        QGeoRectangle __qt_return_value = __qt_this->translated(static_cast<double>(degreesLatitude0), static_cast<double>(degreesLongitude1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoRectangle::united(QGeoRectangle)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_united_1native_1cref_1QGeoRectangle_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rectangle0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::united(QGeoRectangle)const", __qt_this)
        const QGeoRectangle& __qt_rectangle0 = QtJambiAPI::valueReferenceFromNativeId<QGeoRectangle>(rectangle0);
        QGeoRectangle __qt_return_value = __qt_this->united(__qt_rectangle0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoRectangle::width()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_width_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRectangle::width()const", __qt_this)
        __java_return_value = __qt_this->width();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoRectangle_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QGeoRectangle *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRectangle>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


bool javaToNativeConverter_QGeoCoordinate_cref(JNIEnv*, QtJambiScope*, jvalue, void* &, jValueType); // declared in QGeoCircle
bool javaToNativeConverter_QGeoRectangle(JNIEnv*, QtJambiScope*, jvalue, void* &, jValueType);
bool javaToNativeConverter_QGeoRectangle(JNIEnv*, QtJambiScope*, jvalue, void* &, jValueType); // declared in QGeoRectangle
bool javaToNativeConverter_QGeoRectangle_cref(JNIEnv*, QtJambiScope*, jvalue, void* &, jValueType);
bool javaToNativeConverter_QGeoRectangle_cref(JNIEnv*, QtJambiScope*, jvalue, void* &, jValueType); // declared in QGeoRectangle
bool nativeToJavaConverter_QGeoCoordinate_cref(JNIEnv*, QtJambiScope*, const void*, jvalue&, bool); // declared in QGeoCircle
bool nativeToJavaConverter_QGeoRectangle(JNIEnv*, QtJambiScope*, const void*, jvalue&, bool);
bool nativeToJavaConverter_QGeoRectangle(JNIEnv*, QtJambiScope*, const void*, jvalue&, bool); // declared in QGeoRectangle
bool nativeToJavaConverter_QGeoRectangle_cref(JNIEnv*, QtJambiScope*, const void*, jvalue&, bool);
bool nativeToJavaConverter_QGeoRectangle_cref(JNIEnv*, QtJambiScope*, const void*, jvalue&, bool); // declared in QGeoRectangle

bool javaToNativeConverter_QGeoRectangle(JNIEnv* env, QtJambiScope* scope, jvalue in, void* &out, jValueType) {
    Q_UNUSED(env)
    if(scope && !out){
        QGeoRectangle* _out = new QGeoRectangle;
        scope->addDeletion(_out);
        out = _out;
    }
    if(!out)
        return false;
    *reinterpret_cast<QGeoRectangle*>(out) = qtjambi_cast<QGeoRectangle >(env, in.l);
    return true;
}

bool javaToNativeConverter_QGeoRectangle_cref(JNIEnv* env, QtJambiScope* scope, jvalue in, void* &out, jValueType) {
    Q_UNUSED(env)
    Q_UNUSED(scope)
    if(out){
        *reinterpret_cast<QGeoRectangle*>(out) = qtjambi_cast<const QGeoRectangle& >(env, in.l);
    }else{
        out = const_cast<QGeoRectangle*>(&qtjambi_cast<const QGeoRectangle& >(env, in.l));
    }
    return true;
}

bool nativeToJavaConverter_QGeoRectangle(JNIEnv* env, QtJambiScope* scope, const void* in, jvalue& out, bool) {
    Q_UNUSED(env)
    Q_UNUSED(scope)
    out.l = qtjambi_cast<jobject>(env, *reinterpret_cast<QGeoRectangle const*>(in));
    return true;
}

bool nativeToJavaConverter_QGeoRectangle_cref(JNIEnv* env, QtJambiScope* scope, const void* in, jvalue& out, bool) {
    Q_UNUSED(env)
    Q_UNUSED(scope)
    out.l = qtjambi_cast<jobject>(env, *reinterpret_cast<QGeoRectangle const*>(in));
    return true;
}


void initialize_meta_info_QGeoRectangle(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QGeoRectangle>("QGeoRectangle", "io/qt/positioning/QGeoRectangle");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QGeoRectangle, {
        ConstructorInfo(&__qt_construct_QGeoRectangle, nullptr)
       ,ConstructorInfo(&__qt_construct_QGeoRectangle_cref_QGeoCoordinate_cref_QGeoCoordinate, "Lio/qt/positioning/QGeoCoordinate;Lio/qt/positioning/QGeoCoordinate;")
       ,ConstructorInfo(&__qt_construct_QGeoRectangle_cref_QGeoCoordinate_double_double, "Lio/qt/positioning/QGeoCoordinate;DD")
       ,ConstructorInfo(&__qt_construct_QGeoRectangle_cref_QGeoRectangle, "Lio/qt/positioning/QGeoRectangle;")
       ,ConstructorInfo(&__qt_construct_QGeoRectangle_cref_QGeoShape, "Lio/qt/positioning/QGeoShape;")
       ,ConstructorInfo(&__qt_construct_QGeoRectangle_cref_QList, "Ljava/util/Collection;")
    });
// END: function table

    registerMetaObject(typeId, QGeoRectangle::staticMetaObject, false,
            {},
            [](const QMetaMethod& method, QList<ParameterInfo>& infos) {
                Q_UNUSED(infos)
                int methodIndex = method.methodIndex();
                if(methodIndex==QGeoRectangle::staticMetaObject.indexOfMethod("extendRectangle(QGeoCoordinate)")){
                    infos << ParameterInfo(QMetaType::Void);
                    infos << ParameterInfo(
                                // const QGeoCoordinate&
                                method.parameterType(0),
                                "io/qt/positioning/QGeoCoordinate",
                                &nativeToJavaConverter_QGeoCoordinate_cref,
                                &javaToNativeConverter_QGeoCoordinate_cref);
                    return true;
                }
                if(methodIndex==QGeoRectangle::staticMetaObject.indexOfMethod("intersects(QGeoRectangle)const")){
                    infos << ParameterInfo(QMetaType::Bool);
                    infos << ParameterInfo(
                                // const QGeoRectangle&
                                method.parameterType(0),
                                "io/qt/positioning/QGeoRectangle",
                                &nativeToJavaConverter_QGeoRectangle_cref,
                                &javaToNativeConverter_QGeoRectangle_cref);
                    return true;
                }
                if(methodIndex==QGeoRectangle::staticMetaObject.indexOfMethod("toString()const")){
                    infos << ParameterInfo(QMetaType::QString);
                    return true;
                }
                if(methodIndex==QGeoRectangle::staticMetaObject.indexOfMethod("translate(double,double)")){
                    infos << ParameterInfo(QMetaType::Void);
                    infos << ParameterInfo(QMetaType::Double);
                    infos << ParameterInfo(QMetaType::Double);
                    return true;
                }
                if(methodIndex==QGeoRectangle::staticMetaObject.indexOfMethod("translated(double,double)const")){
                    infos << ParameterInfo(
                                // QGeoRectangle
                                method.returnType(),
                                "io/qt/positioning/QGeoRectangle",
                                &nativeToJavaConverter_QGeoRectangle,
                                &javaToNativeConverter_QGeoRectangle);
                    infos << ParameterInfo(QMetaType::Double);
                    infos << ParameterInfo(QMetaType::Double);
                    return true;
                }
                if(methodIndex==QGeoRectangle::staticMetaObject.indexOfMethod("united(QGeoRectangle)const")){
                    infos << ParameterInfo(
                                // QGeoRectangle
                                method.returnType(),
                                "io/qt/positioning/QGeoRectangle",
                                &nativeToJavaConverter_QGeoRectangle,
                                &javaToNativeConverter_QGeoRectangle);
                    infos << ParameterInfo(
                                // const QGeoRectangle&
                                method.parameterType(0),
                                "io/qt/positioning/QGeoRectangle",
                                &nativeToJavaConverter_QGeoRectangle_cref,
                                &javaToNativeConverter_QGeoRectangle_cref);
                    return true;
                }
                return false;
            });
// END: signal table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QGeoRectangle);
    registerMetaType<QGeoRectangle>("QGeoRectangle");
// END: type registration

// BEGIN: polymorphic ids
    registerPolymorphyHandler(typeid(QGeoShape), typeId, [](void *ptr, qintptr& offset) -> bool {
            QGeoShape *object = reinterpret_cast<QGeoShape *>(ptr);
            Q_ASSERT(object);
            offset = 0;
            bool _result = false;
            QTJAMBI_TRY_ANY { // cast from baseclass
                _result = object->type() == QGeoShape::RectangleType;
            } QTJAMBI_CATCH_ANY{
            } QTJAMBI_TRY_END
            return _result;
        });
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
