#include <QtCore/QtGlobal>
#include <QtPositioning/qgeopath.h>
#include <QtCore/QList>
#include <QtCore/QVariant>
#include <QtCore/qdatastream.h>
#include <QtCore/qdebug.h>
#include <QtPositioning/qgeocoordinate.h>
#include <QtPositioning/qgeorectangle.h>
#include <QtPositioning/qgeoshape.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiPositioning/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QGeoPath(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QGeoPath")
    QGeoPath *_ptr = reinterpret_cast<QGeoPath *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QGeoPath()
void __qt_construct_QGeoPath(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QGeoPath()")
    Q_UNUSED(__java_arguments)
    QGeoPath *__qt_this = new(__qtjambi_ptr) QGeoPath();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QGeoPath::QGeoPath()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_initialize_1native__Lio_qt_positioning_QGeoPath_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QGeoPath::QGeoPath()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QGeoPath, sizeof(QGeoPath), typeid(QGeoPath), false, &deleter_QGeoPath, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QGeoPath(QGeoPath)
void __qt_construct_QGeoPath_cref_QGeoPath(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QGeoPath(QGeoPath)")
    jobject other0 = __java_arguments[0].l;
    const QGeoPath& __qt_other0 = qtjambi_cast<const QGeoPath& >(__jni_env, other0);
    QGeoPath *__qt_this = new(__qtjambi_ptr) QGeoPath(__qt_other0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QGeoPath::QGeoPath(QGeoPath)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_initialize_1native__Lio_qt_positioning_QGeoPath_2Lio_qt_positioning_QGeoPath_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QGeoPath::QGeoPath(QGeoPath)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QGeoPath_cref_QGeoPath, sizeof(QGeoPath), typeid(QGeoPath), false, &deleter_QGeoPath, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QGeoPath(QGeoShape)
void __qt_construct_QGeoPath_cref_QGeoShape(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QGeoPath(QGeoShape)")
    jobject other0 = __java_arguments[0].l;
    const QGeoShape& __qt_other0 = qtjambi_cast<const QGeoShape& >(__jni_env, other0);
    QGeoPath *__qt_this = new(__qtjambi_ptr) QGeoPath(__qt_other0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QGeoPath::QGeoPath(QGeoShape)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_initialize_1native__Lio_qt_positioning_QGeoPath_2Lio_qt_positioning_QGeoShape_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QGeoPath::QGeoPath(QGeoShape)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QGeoPath_cref_QGeoShape, sizeof(QGeoPath), typeid(QGeoPath), false, &deleter_QGeoPath, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QGeoPath(QList<QGeoCoordinate>,qreal)
void __qt_construct_QGeoPath_cref_QList(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QGeoPath(QList<QGeoCoordinate>,qreal)")
    QtJambiScope __qtjambi_scope;
    jobject path0 = __java_arguments[0].l;
    const QList<QGeoCoordinate>&  __qt_path0 = qtjambi_cast<const QList<QGeoCoordinate>& >(__jni_env, __qtjambi_scope, path0);
    QGeoPath *__qt_this = new(__qtjambi_ptr) QGeoPath(__qt_path0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QGeoPath(QList<QGeoCoordinate>,qreal)
void __qt_construct_QGeoPath_cref_QList_cref_qreal(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QGeoPath(QList<QGeoCoordinate>,qreal)")
    QtJambiScope __qtjambi_scope;
    jobject path0 = __java_arguments[0].l;
    const QList<QGeoCoordinate>&  __qt_path0 = qtjambi_cast<const QList<QGeoCoordinate>& >(__jni_env, __qtjambi_scope, path0);
    jdouble width1 = __java_arguments[1].d;
    Q_UNUSED(width1)
    QGeoPath *__qt_this = new(__qtjambi_ptr) QGeoPath(__qt_path0, static_cast<qreal>(width1));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QGeoPath::QGeoPath(QList<QGeoCoordinate>,qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_initialize_1native__Lio_qt_positioning_QGeoPath_2Ljava_util_Collection_2D)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject path0,
 jdouble width1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QGeoPath::QGeoPath(QList<QGeoCoordinate>,qreal)")
    QTJAMBI_TRY {
        jvalue arguments[2];
        arguments[0].l = path0;
        arguments[1].d = width1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QGeoPath_cref_QList_cref_qreal, sizeof(QGeoPath), typeid(QGeoPath), false, &deleter_QGeoPath, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QGeoPath
void __qt_destruct_QGeoPath(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QGeoPath")
    reinterpret_cast<QGeoPath*>(ptr)->~QGeoPath();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QGeoPath::addCoordinate(QGeoCoordinate)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_addCoordinate_1native_1cref_1QGeoCoordinate__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID coordinate0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoPath::addCoordinate(QGeoCoordinate)", __qt_this)
        const QGeoCoordinate& __qt_coordinate0 = QtJambiAPI::valueReferenceFromNativeId<QGeoCoordinate>(coordinate0);
        __qt_this->addCoordinate(__qt_coordinate0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoPath::clearPath()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_clearPath_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoPath::clearPath()", __qt_this)
        __qt_this->clearPath();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoPath::containsCoordinate(QGeoCoordinate)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_containsCoordinate_1native_1cref_1QGeoCoordinate_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID coordinate0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoPath::containsCoordinate(QGeoCoordinate)const", __qt_this)
        const QGeoCoordinate& __qt_coordinate0 = QtJambiAPI::valueReferenceFromNativeId<QGeoCoordinate>(coordinate0);
        __java_return_value = __qt_this->containsCoordinate(__qt_coordinate0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoPath::coordinateAt(qsizetype)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_coordinateAt_1native_1qsizetype_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong index0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoPath::coordinateAt(qsizetype)const", __qt_this)
        QGeoCoordinate __qt_return_value = __qt_this->coordinateAt(static_cast<qsizetype>(index0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoPath::insertCoordinate(qsizetype,QGeoCoordinate)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_insertCoordinate_1native_1qsizetype_1cref_1QGeoCoordinate__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong index0,
 QtJambiNativeID coordinate1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoPath::insertCoordinate(qsizetype,QGeoCoordinate)", __qt_this)
        const QGeoCoordinate& __qt_coordinate1 = QtJambiAPI::valueReferenceFromNativeId<QGeoCoordinate>(coordinate1);
        __qt_this->insertCoordinate(static_cast<qsizetype>(index0), __qt_coordinate1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoPath::length(qsizetype,qsizetype)const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_length_1native_1qsizetype_1qsizetype_1constfct__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong indexFrom0,
 jlong indexTo1)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoPath::length(qsizetype,qsizetype)const", __qt_this)
        __java_return_value = __qt_this->length(static_cast<qsizetype>(indexFrom0), static_cast<qsizetype>(indexTo1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoPath::operator<<(QDataStream&,QGeoPath)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID stream0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoPath::operator<<(QDataStream&,QGeoPath)", __qt_this)
        QDataStream& __qt_stream0 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, stream0);
        __qt_stream0 << (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoPath::operator=(QGeoPath)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_assign_1native_1cref_1QGeoPath__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoPath::operator=(QGeoPath)", __qt_this)
        const QGeoPath& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QGeoPath>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoPath::operator>>(QDataStream&,QGeoPath&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID stream0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoPath::operator>>(QDataStream&,QGeoPath&)", __qt_this)
        QDataStream& __qt_stream0 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, stream0);
        __qt_stream0 >> (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoPath::path()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_path_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoPath::path()const", __qt_this)
        const QList<QGeoCoordinate>& __qt_return_value = __qt_this->path();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoPath::removeCoordinate(QGeoCoordinate)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_removeCoordinate_1native_1cref_1QGeoCoordinate__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID coordinate0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoPath::removeCoordinate(QGeoCoordinate)", __qt_this)
        const QGeoCoordinate& __qt_coordinate0 = QtJambiAPI::valueReferenceFromNativeId<QGeoCoordinate>(coordinate0);
        __qt_this->removeCoordinate(__qt_coordinate0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoPath::removeCoordinate(qsizetype)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_removeCoordinate_1native_1qsizetype__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong index0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoPath::removeCoordinate(qsizetype)", __qt_this)
        __qt_this->removeCoordinate(static_cast<qsizetype>(index0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoPath::replaceCoordinate(qsizetype,QGeoCoordinate)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_replaceCoordinate_1native_1qsizetype_1cref_1QGeoCoordinate__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong index0,
 QtJambiNativeID coordinate1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoPath::replaceCoordinate(qsizetype,QGeoCoordinate)", __qt_this)
        const QGeoCoordinate& __qt_coordinate1 = QtJambiAPI::valueReferenceFromNativeId<QGeoCoordinate>(coordinate1);
        __qt_this->replaceCoordinate(static_cast<qsizetype>(index0), __qt_coordinate1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoPath::setPath(QList<QGeoCoordinate>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_setPath_1native_1cref_1QList__JLjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject path0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoPath::setPath(QList<QGeoCoordinate>)", __qt_this)
        const QList<QGeoCoordinate>&  __qt_path0 = qtjambi_cast<const QList<QGeoCoordinate>& >(__jni_env, __qtjambi_scope, path0);
        __qt_this->setPath(__qt_path0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoPath::setVariantPath(QVariantList)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_setVariantPath_1native_1cref_1QList__JLjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject path0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoPath::setVariantPath(QVariantList)", __qt_this)
        const QList<QVariant>&  __qt_path0 = qtjambi_cast<const QList<QVariant>& >(__jni_env, __qtjambi_scope, path0);
        __qt_this->setVariantPath(__qt_path0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoPath::setWidth(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_setWidth_1native_1cref_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble width0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoPath::setWidth(qreal)", __qt_this)
        __qt_this->setWidth(static_cast<qreal>(width0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoPath::size()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_size_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoPath::size()const", __qt_this)
        qsizetype __qt_return_value = __qt_this->size();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoPath::toString()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_toString_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoPath::toString()const", __qt_this)
        QString __qt_return_value = __qt_this->toString();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoPath::translate(double,double)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_translate_1native_1double_1double__JDD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble degreesLatitude0,
 jdouble degreesLongitude1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoPath::translate(double,double)", __qt_this)
        __qt_this->translate(static_cast<double>(degreesLatitude0), static_cast<double>(degreesLongitude1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoPath::translated(double,double)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_translated_1native_1double_1double_1constfct__JDD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble degreesLatitude0,
 jdouble degreesLongitude1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoPath::translated(double,double)const", __qt_this)
        QGeoPath __qt_return_value = __qt_this->translated(static_cast<double>(degreesLatitude0), static_cast<double>(degreesLongitude1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoPath::variantPath()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_variantPath_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoPath::variantPath()const", __qt_this)
        QList<QVariant> __qt_return_value = __qt_this->variantPath();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoPath::width()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_width_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoPath::width()const", __qt_this)
        qreal __qt_return_value = __qt_this->width();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_positioning_QGeoPath_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QGeoPath *__qt_this = QtJambiAPI::objectFromNativeId<QGeoPath>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


bool javaToNativeConverter_QGeoCoordinate(JNIEnv*, QtJambiScope*, jvalue, void* &, jValueType); // declared in QGeoCoordinate
bool javaToNativeConverter_QGeoCoordinate_cref(JNIEnv*, QtJambiScope*, jvalue, void* &, jValueType); // declared in QGeoCircle
bool javaToNativeConverter_QGeoPath(JNIEnv*, QtJambiScope*, jvalue, void* &, jValueType);
bool javaToNativeConverter_qsizetype(JNIEnv*, QtJambiScope*, jvalue, void* &, jValueType);
bool javaToNativeConverter_qsizetype(JNIEnv*, QtJambiScope*, jvalue, void* &, jValueType); // declared in QGeoPath
bool nativeToJavaConverter_QGeoCoordinate(JNIEnv*, QtJambiScope*, const void*, jvalue&, bool); // declared in QGeoCoordinate
bool nativeToJavaConverter_QGeoCoordinate_cref(JNIEnv*, QtJambiScope*, const void*, jvalue&, bool); // declared in QGeoCircle
bool nativeToJavaConverter_QGeoPath(JNIEnv*, QtJambiScope*, const void*, jvalue&, bool);
bool nativeToJavaConverter_qsizetype(JNIEnv*, QtJambiScope*, const void*, jvalue&, bool);
bool nativeToJavaConverter_qsizetype(JNIEnv*, QtJambiScope*, const void*, jvalue&, bool); // declared in QGeoPath

bool javaToNativeConverter_QGeoPath(JNIEnv* env, QtJambiScope* scope, jvalue in, void* &out, jValueType) {
    Q_UNUSED(env)
    if(scope && !out){
        QGeoPath* _out = new QGeoPath;
        scope->addDeletion(_out);
        out = _out;
    }
    if(!out)
        return false;
    *reinterpret_cast<QGeoPath*>(out) = qtjambi_cast<QGeoPath >(env, in.l);
    return true;
}

bool javaToNativeConverter_qsizetype(JNIEnv* env, QtJambiScope* scope, jvalue in, void* &out, jValueType valueType) {
    Q_UNUSED(env)
    jlong _in;
    switch(valueType){
    case jValueType::l:
        _in = QtJambiAPI::fromJavaLongObject(env, in.l);
    break;
    default:
        _in = in.j;
    break;
    }
    if(scope && !out){
        qsizetype* _out = new qsizetype;
        scope->addDeletion(_out);
        out = _out;
    }
    if(!out)
        return false;
    *reinterpret_cast<qsizetype*>(out) = static_cast<qsizetype>(_in);
    return true;
}

bool nativeToJavaConverter_QGeoPath(JNIEnv* env, QtJambiScope* scope, const void* in, jvalue& out, bool) {
    Q_UNUSED(env)
    Q_UNUSED(scope)
    out.l = qtjambi_cast<jobject>(env, *reinterpret_cast<QGeoPath const*>(in));
    return true;
}

bool nativeToJavaConverter_qsizetype(JNIEnv* env, QtJambiScope* scope, const void* in, jvalue& out, bool forceBoxedType) {
    Q_UNUSED(env)
    Q_UNUSED(scope)
    out.j = jlong(*reinterpret_cast<qsizetype const*>(in));
    if(forceBoxedType)
        out.l = QtJambiAPI::toJavaLongObject(env, out.j);
    return true;
}


void initialize_meta_info_QGeoPath(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QGeoPath>("QGeoPath", "io/qt/positioning/QGeoPath");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QGeoPath, {
        ConstructorInfo(&__qt_construct_QGeoPath, nullptr)
       ,ConstructorInfo(&__qt_construct_QGeoPath_cref_QGeoPath, "Lio/qt/positioning/QGeoPath;")
       ,ConstructorInfo(&__qt_construct_QGeoPath_cref_QGeoShape, "Lio/qt/positioning/QGeoShape;")
       ,ConstructorInfo(&__qt_construct_QGeoPath_cref_QList, "Ljava/util/Collection;")
       ,ConstructorInfo(&__qt_construct_QGeoPath_cref_QList_cref_qreal, "Ljava/util/Collection;D")
    });
// END: function table

    registerMetaObject(typeId, QGeoPath::staticMetaObject, false,
            {},
            [](const QMetaMethod& method, QList<ParameterInfo>& infos) {
                Q_UNUSED(infos)
                int methodIndex = method.methodIndex();
                if(methodIndex==QGeoPath::staticMetaObject.indexOfMethod("addCoordinate(QGeoCoordinate)")){
                    infos << ParameterInfo(QMetaType::Void);
                    infos << ParameterInfo(
                                // const QGeoCoordinate&
                                method.parameterType(0),
                                "io/qt/positioning/QGeoCoordinate",
                                &nativeToJavaConverter_QGeoCoordinate_cref,
                                &javaToNativeConverter_QGeoCoordinate_cref);
                    return true;
                }
                if(methodIndex==QGeoPath::staticMetaObject.indexOfMethod("containsCoordinate(QGeoCoordinate)const")){
                    infos << ParameterInfo(QMetaType::Bool);
                    infos << ParameterInfo(
                                // const QGeoCoordinate&
                                method.parameterType(0),
                                "io/qt/positioning/QGeoCoordinate",
                                &nativeToJavaConverter_QGeoCoordinate_cref,
                                &javaToNativeConverter_QGeoCoordinate_cref);
                    return true;
                }
                if(methodIndex==QGeoPath::staticMetaObject.indexOfMethod("coordinateAt(qsizetype)const")){
                    infos << ParameterInfo(
                                // QGeoCoordinate
                                method.returnType(),
                                "io/qt/positioning/QGeoCoordinate",
                                &nativeToJavaConverter_QGeoCoordinate,
                                &javaToNativeConverter_QGeoCoordinate);
                    infos << ParameterInfo(
                                // qsizetype
                                method.parameterType(0),
                                "long",
                                &nativeToJavaConverter_qsizetype,
                                &javaToNativeConverter_qsizetype);
                    return true;
                }
                if(methodIndex==QGeoPath::staticMetaObject.indexOfMethod("insertCoordinate(qsizetype,QGeoCoordinate)")){
                    infos << ParameterInfo(QMetaType::Void);
                    infos << ParameterInfo(
                                // qsizetype
                                method.parameterType(0),
                                "long",
                                &nativeToJavaConverter_qsizetype,
                                &javaToNativeConverter_qsizetype);
                    infos << ParameterInfo(
                                // const QGeoCoordinate&
                                method.parameterType(1),
                                "io/qt/positioning/QGeoCoordinate",
                                &nativeToJavaConverter_QGeoCoordinate_cref,
                                &javaToNativeConverter_QGeoCoordinate_cref);
                    return true;
                }
                if(methodIndex==QGeoPath::staticMetaObject.indexOfMethod("length(qsizetype,qsizetype)const")){
                    infos << ParameterInfo(QMetaType::Double);
                    infos << ParameterInfo(
                                // qsizetype
                                method.parameterType(0),
                                "long",
                                &nativeToJavaConverter_qsizetype,
                                &javaToNativeConverter_qsizetype);
                    infos << ParameterInfo(
                                // qsizetype
                                method.parameterType(1),
                                "long",
                                &nativeToJavaConverter_qsizetype,
                                &javaToNativeConverter_qsizetype);
                    return true;
                }
                if(methodIndex==QGeoPath::staticMetaObject.indexOfMethod("removeCoordinate(QGeoCoordinate)")){
                    infos << ParameterInfo(QMetaType::Void);
                    infos << ParameterInfo(
                                // const QGeoCoordinate&
                                method.parameterType(0),
                                "io/qt/positioning/QGeoCoordinate",
                                &nativeToJavaConverter_QGeoCoordinate_cref,
                                &javaToNativeConverter_QGeoCoordinate_cref);
                    return true;
                }
                if(methodIndex==QGeoPath::staticMetaObject.indexOfMethod("removeCoordinate(qsizetype)")){
                    infos << ParameterInfo(QMetaType::Void);
                    infos << ParameterInfo(
                                // qsizetype
                                method.parameterType(0),
                                "long",
                                &nativeToJavaConverter_qsizetype,
                                &javaToNativeConverter_qsizetype);
                    return true;
                }
                if(methodIndex==QGeoPath::staticMetaObject.indexOfMethod("replaceCoordinate(qsizetype,QGeoCoordinate)")){
                    infos << ParameterInfo(QMetaType::Void);
                    infos << ParameterInfo(
                                // qsizetype
                                method.parameterType(0),
                                "long",
                                &nativeToJavaConverter_qsizetype,
                                &javaToNativeConverter_qsizetype);
                    infos << ParameterInfo(
                                // const QGeoCoordinate&
                                method.parameterType(1),
                                "io/qt/positioning/QGeoCoordinate",
                                &nativeToJavaConverter_QGeoCoordinate_cref,
                                &javaToNativeConverter_QGeoCoordinate_cref);
                    return true;
                }
                if(methodIndex==QGeoPath::staticMetaObject.indexOfMethod("size()const")){
                    infos << ParameterInfo(
                                // qsizetype
                                method.returnType(),
                                "long",
                                &nativeToJavaConverter_qsizetype,
                                &javaToNativeConverter_qsizetype);
                    return true;
                }
                if(methodIndex==QGeoPath::staticMetaObject.indexOfMethod("toString()const")){
                    infos << ParameterInfo(QMetaType::QString);
                    return true;
                }
                if(methodIndex==QGeoPath::staticMetaObject.indexOfMethod("translate(double,double)")){
                    infos << ParameterInfo(QMetaType::Void);
                    infos << ParameterInfo(QMetaType::Double);
                    infos << ParameterInfo(QMetaType::Double);
                    return true;
                }
                if(methodIndex==QGeoPath::staticMetaObject.indexOfMethod("translated(double,double)const")){
                    infos << ParameterInfo(
                                // QGeoPath
                                method.returnType(),
                                "io/qt/positioning/QGeoPath",
                                &nativeToJavaConverter_QGeoPath,
                                &javaToNativeConverter_QGeoPath);
                    infos << ParameterInfo(QMetaType::Double);
                    infos << ParameterInfo(QMetaType::Double);
                    return true;
                }
                return false;
            });
// END: signal table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QGeoPath);
    registerMetaType<QGeoPath>("QGeoPath");
// END: type registration

// BEGIN: polymorphic ids
    registerPolymorphyHandler(typeid(QGeoShape), typeId, [](void *ptr, qintptr& offset) -> bool {
            QGeoShape *object = reinterpret_cast<QGeoShape *>(ptr);
            Q_ASSERT(object);
            offset = 0;
            bool _result = false;
            QTJAMBI_TRY_ANY { // cast from baseclass
                _result = object->type() == QGeoShape::PathType;
            } QTJAMBI_CATCH_ANY{
            } QTJAMBI_TRY_END
            return _result;
        });
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
