/*
 * Decompiled with CFR 0.152.
 */
package io.qt.sql.jdbc;

import io.qt.core.QDate;
import io.qt.core.QDateTime;
import io.qt.core.QTime;
import io.qt.core.QUrl;
import io.qt.sql.QSqlError;
import io.qt.sql.QSqlField;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;

class QJdbcSqlUtil {
    QJdbcSqlUtil() {
    }

    static QSqlField.RequiredStatus toRequiredStatus(int isNullable) {
        switch (isNullable) {
            case 0: {
                return QSqlField.RequiredStatus.Required;
            }
            case 1: {
                return QSqlField.RequiredStatus.Optional;
            }
        }
        return QSqlField.RequiredStatus.Unknown;
    }

    static QSqlError getError(SQLException ex, String driverText, QSqlError.ErrorType t) {
        Logger.getLogger("io.qt.sql.jdbc").log(Level.SEVERE, driverText, ex);
        StringBuilder dbText = new StringBuilder();
        int errorCode = 0;
        for (SQLException e = ex; e != null; e = e.getNextException()) {
            if (dbText.length() != 0) {
                dbText.append(", ");
            }
            dbText.append(e.getMessage());
            if (e.getCause() != null && e.getCause().getMessage() != null && !e.getCause().getMessage().isEmpty()) {
                dbText.append(", caused by: ").append(e.getCause().getMessage());
            }
            if (e.getSQLState() != null) {
                dbText.append(" (").append(e.getSQLState()).append(")");
            }
            errorCode = e.getErrorCode();
        }
        return new QSqlError(driverText, dbText.toString(), t, "" + errorCode);
    }

    static Object javaToQt(Object input) {
        if (input instanceof java.sql.Date) {
            java.sql.Date date = (java.sql.Date)input;
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(date);
            return new QDate(c.get(1), c.get(2) + 1, c.get(5));
        }
        if (input instanceof Time) {
            Time time = (Time)input;
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(time);
            return new QTime(c.get(10), c.get(12) + 1, c.get(13));
        }
        if (input instanceof Date) {
            Date date = (Date)input;
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(date);
            return new QDateTime(new QDate(c.get(1), c.get(2) + 1, c.get(5)), new QTime(c.get(11), c.get(12), c.get(13), c.get(14)));
        }
        if (input instanceof URL) {
            URL url = (URL)input;
            return new QUrl(url.toString());
        }
        return input;
    }

    static Object qtToJava(Object input) {
        if (input instanceof QDateTime) {
            QDateTime dt = (QDateTime)input;
            QDate date = dt.date();
            QTime time = dt.time();
            return new Timestamp(date.year() - 1900, date.month() - 1, date.day(), time.hour(), time.minute(), time.second(), time.msec());
        }
        if (input instanceof QDate) {
            QDate date = (QDate)input;
            return new java.sql.Date(date.year() - 1900, date.month() - 1, date.day());
        }
        if (input instanceof QTime) {
            QTime time = (QTime)input;
            return new Time(time.hour(), time.minute(), time.second());
        }
        if (input instanceof QUrl) {
            QUrl url = (QUrl)input;
            try {
                return new URL(url.toString());
            }
            catch (MalformedURLException e) {
                Logger.getLogger("io.qt.sql").log(Level.SEVERE, "", e);
                return input;
            }
        }
        return input;
    }
}

