/*
 * Decompiled with CFR 0.152.
 */
package io.qt.sql.jdbc;

import io.qt.sql.QSql;
import io.qt.sql.QSqlDriver;
import io.qt.sql.QSqlError;
import io.qt.sql.QSqlField;
import io.qt.sql.QSqlIndex;
import io.qt.sql.QSqlRecord;
import io.qt.sql.QSqlResult;
import io.qt.sql.jdbc.QJdbcSqlResult;
import io.qt.sql.jdbc.QJdbcSqlUtil;
import io.qt.sql.jdbc.QJdbcSqlVariantUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;

class QJdbcSqlDriver
extends QSqlDriver {
    private Connection connection = null;

    QJdbcSqlDriver() {
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                this.setError(e, QJdbcSqlDriver.tr((String)"Unable to close connection"), QSqlError.ErrorType.ConnectionError);
            }
        }
        this.connection = null;
        this.setOpen(false);
    }

    public Object handle() {
        return this.connection;
    }

    public QSqlResult createResult() {
        return new QJdbcSqlResult(this, this.connection);
    }

    public List<String> tables(QSql.TableType tableType) {
        Vector<String> list = new Vector<String>();
        if (this.connection == null) {
            return list;
        }
        try {
            DatabaseMetaData metaData = this.connection.getMetaData();
            String[] types = new String[1];
            switch (tableType) {
                case Tables: {
                    types[0] = "TABLE";
                    break;
                }
                case Views: {
                    types[0] = "VIEWS";
                    break;
                }
                case SystemTables: {
                    types[0] = "SYSTEM TABLE";
                    break;
                }
                default: {
                    types = null;
                }
            }
            ResultSet rs = metaData.getTables(null, null, null, types);
            while (rs.next()) {
                list.add(rs.getString("TABLE_NAME"));
            }
            rs.close();
        }
        catch (SQLException ex) {
            this.setError(ex, QJdbcSqlDriver.tr((String)"Unable to list tables"), QSqlError.ErrorType.ConnectionError);
            return new Vector<String>();
        }
        return list;
    }

    public boolean hasFeature(QSqlDriver.DriverFeature f) {
        switch (f) {
            case PreparedQueries: 
            case PositionalPlaceholders: 
            case BLOB: 
            case Unicode: 
            case Transactions: {
                return true;
            }
            case LastInsertId: {
                try {
                    return this.connection != null && this.connection.getMetaData().supportsGetGeneratedKeys();
                }
                catch (SQLException e) {
                    this.setError(e, "Can't determine availability of LastInsertId", QSqlError.ErrorType.UnknownError);
                    return false;
                }
            }
            case QuerySize: 
            case NamedPlaceholders: 
            case BatchOperations: 
            case SimpleLocking: 
            case LowPrecisionNumbers: {
                return false;
            }
            case CancelQuery: {
                break;
            }
            case EventNotifications: {
                break;
            }
            case FinishQuery: {
                break;
            }
            case MultipleResultSets: {
                break;
            }
        }
        return false;
    }

    public boolean open(String db, String user, String password, String host, int port, String connOpts) {
        Connection con = null;
        try {
            con = DriverManager.getConnection(db, user, password);
        }
        catch (SQLException ex) {
            this.setError(ex, QJdbcSqlDriver.tr((String)"Unable to find JDBC driver."), QSqlError.ErrorType.ConnectionError);
            this.setOpenError(true);
            return false;
        }
        if (con == null) {
            this.setOpenError(true);
            return false;
        }
        try {
            con.setAutoCommit(true);
        }
        catch (SQLException ex) {
            this.setError(ex, QJdbcSqlDriver.tr((String)"Unable to enable auto-commit"), QSqlError.ErrorType.ConnectionError);
        }
        this.connection = con;
        this.setOpen(true);
        this.setOpenError(false);
        return true;
    }

    public QSqlRecord record(String tableName) {
        if (this.connection == null) {
            return new QSqlRecord();
        }
        QSqlRecord res = new QSqlRecord();
        try {
            DatabaseMetaData metaData = this.connection.getMetaData();
            if (metaData == null) {
                return new QSqlRecord();
            }
            ResultSet resultSet = metaData.getColumns(null, null, tableName, null);
            while (resultSet.next()) {
                QSqlField f = new QSqlField(resultSet.getString(4), QJdbcSqlVariantUtil.javaTypeIdToVariantType(resultSet.getInt(5)));
                f.setLength(resultSet.getInt(7));
                f.setPrecision(resultSet.getInt(8));
                f.setRequiredStatus(QJdbcSqlUtil.toRequiredStatus(resultSet.getInt(11)));
                f.setSqlType(resultSet.getInt(5));
                f.setDefaultValue(resultSet.getObject(13));
                res.append(f);
            }
            resultSet.close();
        }
        catch (SQLException ex) {
            this.setError(ex, QJdbcSqlDriver.tr((String)"Unable to retrieve database meta data"), QSqlError.ErrorType.ConnectionError);
            return new QSqlRecord();
        }
        return res;
    }

    public QSqlIndex primaryIndex(String tableName) {
        try {
            DatabaseMetaData metaData = this.connection.getMetaData();
            if (metaData == null) {
                return new QSqlIndex(tableName);
            }
            ResultSet primaryKeys = metaData.getPrimaryKeys(null, null, tableName);
            QSqlIndex idx = new QSqlIndex(tableName);
            while (primaryKeys.next()) {
                String columnName = primaryKeys.getString("COLUMN_NAME");
                ResultSet resultSet = metaData.getColumns(null, null, tableName, columnName);
                idx.setName(primaryKeys.getString("PK_NAME"));
                if (resultSet.next()) {
                    QSqlField f = new QSqlField(resultSet.getString(4), QJdbcSqlVariantUtil.javaTypeIdToVariantType(resultSet.getInt(5)));
                    f.setLength(resultSet.getInt(7));
                    f.setPrecision(resultSet.getInt(8));
                    f.setRequiredStatus(QJdbcSqlUtil.toRequiredStatus(resultSet.getInt(11)));
                    f.setSqlType(resultSet.getInt(5));
                    f.setDefaultValue(resultSet.getObject(13));
                    idx.append(f);
                }
                resultSet.close();
            }
            primaryKeys.close();
            return idx;
        }
        catch (SQLException ex) {
            this.setError(ex, QJdbcSqlDriver.tr((String)"Unable to get primary index"), QSqlError.ErrorType.ConnectionError);
            return new QSqlIndex(tableName);
        }
    }

    public boolean beginTransaction() {
        if (this.connection == null) {
            return false;
        }
        try {
            this.connection.setAutoCommit(false);
        }
        catch (SQLException ex) {
            this.setError(ex, "Unable to disable autoCommit", QSqlError.ErrorType.ConnectionError);
            return false;
        }
        return true;
    }

    public boolean commitTransaction() {
        if (this.connection == null) {
            return false;
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.setError(ex, QJdbcSqlDriver.tr((String)"Unable to commit transaction"), QSqlError.ErrorType.ConnectionError);
            return false;
        }
        return true;
    }

    public boolean rollbackTransaction() {
        if (this.connection == null) {
            return false;
        }
        try {
            this.connection.rollback();
        }
        catch (SQLException ex) {
            this.setError(ex, QJdbcSqlDriver.tr((String)"Unable to roll back transaction"), QSqlError.ErrorType.ConnectionError);
            return false;
        }
        return true;
    }

    private void setError(SQLException e, String driverText, QSqlError.ErrorType t) {
        this.setLastError(QJdbcSqlUtil.getError(e, driverText, t));
    }
}

