/*
 * Decompiled with CFR 0.152.
 */
package io.qt.sql.jdbc;

import io.qt.core.QVariant;
import java.util.HashMap;

class QJdbcSqlVariantUtil {
    private static HashMap<String, QVariant.Type> javaToVariant = new HashMap();

    QJdbcSqlVariantUtil() {
    }

    static QVariant.Type javaTypeToVariantType(String javaType) {
        QVariant.Type variantType = javaToVariant.get(javaType);
        if (variantType == null) {
            return QVariant.Type.UserType;
        }
        return variantType;
    }

    static QVariant.Type javaTypeIdToVariantType(int variantType) {
        switch (variantType) {
            case 1: 
            case 12: {
                return QVariant.Type.String;
            }
            case -6: 
            case 4: 
            case 5: {
                return QVariant.Type.Int;
            }
            case -7: 
            case 16: {
                return QVariant.Type.Boolean;
            }
            case -5: 
            case 3: {
                return QVariant.Type.Long;
            }
            case 91: {
                return QVariant.Type.Date;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                return QVariant.Type.Double;
            }
            case 92: {
                return QVariant.Type.Time;
            }
            case 93: {
                return QVariant.Type.DateTime;
            }
        }
        return QVariant.Type.UserType;
    }

    static {
        javaToVariant.put(null, QVariant.Type.Invalid);
        javaToVariant.put("java.lang.String", QVariant.Type.String);
        javaToVariant.put("java.lang.Integer", QVariant.Type.Int);
        javaToVariant.put("java.lang.Short", QVariant.Type.Int);
        javaToVariant.put("java.lang.Byte", QVariant.Type.Int);
        javaToVariant.put("java.lang.Boolean", QVariant.Type.Boolean);
        javaToVariant.put("java.lang.Byte[]", QVariant.Type.ByteArray);
        javaToVariant.put("java.util.Date", QVariant.Type.Date);
        javaToVariant.put("java.sql.Date", QVariant.Type.Date);
        javaToVariant.put("java.lang.Float", QVariant.Type.Double);
        javaToVariant.put("java.lang.Double", QVariant.Type.Double);
        javaToVariant.put("java.lang.Long", QVariant.Type.Long);
        javaToVariant.put("java.sql.Time", QVariant.Type.Time);
        javaToVariant.put("java.sql.TimeStamp", QVariant.Type.DateTime);
        javaToVariant.put("java.net.Url", QVariant.Type.Url);
    }
}

