package io.qt.pdf.widgets;

import io.qt.*;


/**
 * <p>A PDF viewer widget</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qpdfview.html">QPdfView</a></code></p>
 */
public class QPdfView extends io.qt.widgets.QAbstractScrollArea
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcDocument = null;
    @QtPropertyMember(enabled=false)
    private Object __rcSearchModel = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPdfView.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qpdfview.html#PageMode-enum">QPdfView::PageMode</a></code></p>
     */
    public enum PageMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qpdfview.html#PageMode-enum">QPdfView::<wbr/>PageMode::<wbr/>SinglePage</a></code></p>
         */
        SinglePage(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qpdfview.html#PageMode-enum">QPdfView::<wbr/>PageMode::<wbr/>MultiPage</a></code></p>
         */
        MultiPage(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PageMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PageMode resolve(int value) {
            switch (value) {
            case 0: return SinglePage;
            case 1: return MultiPage;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qpdfview.html#ZoomMode-enum">QPdfView::ZoomMode</a></code></p>
     */
    public enum ZoomMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qpdfview.html#ZoomMode-enum">QPdfView::<wbr/>ZoomMode::<wbr/>Custom</a></code></p>
         */
        Custom(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qpdfview.html#ZoomMode-enum">QPdfView::<wbr/>ZoomMode::<wbr/>FitToWidth</a></code></p>
         */
        FitToWidth(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qpdfview.html#ZoomMode-enum">QPdfView::<wbr/>ZoomMode::<wbr/>FitInView</a></code></p>
         */
        FitInView(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ZoomMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ZoomMode resolve(int value) {
            switch (value) {
            case 0: return Custom;
            case 1: return FitToWidth;
            case 2: return FitInView;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#currentSearchResultIndex-prop">QPdfView::<wbr/>currentSearchResultIndexChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="currentSearchResultIndex")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> currentSearchResultIndexChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#document-prop">QPdfView::<wbr/>documentChanged(QPdfDocument*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtPropertyNotify(name="document")
    public final @NonNull Signal1<io.qt.pdf.@Nullable QPdfDocument> documentChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#documentMargins-prop">QPdfView::<wbr/>documentMarginsChanged(QMargins)</a></code></p>
     */
    @QtPropertyNotify(name="documentMargins")
    public final @NonNull Signal1<io.qt.core.@NonNull QMargins> documentMarginsChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#pageMode-prop">QPdfView::<wbr/>pageModeChanged(QPdfView::PageMode)</a></code></p>
     */
    @QtPropertyNotify(name="pageMode")
    public final @NonNull Signal1<io.qt.pdf.widgets.QPdfView.@NonNull PageMode> pageModeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#pageSpacing-prop">QPdfView::<wbr/>pageSpacingChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="pageSpacing")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> pageSpacingChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#searchModel-prop">QPdfView::<wbr/>searchModelChanged(QPdfSearchModel*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtPropertyNotify(name="searchModel")
    public final @NonNull Signal1<io.qt.pdf.@Nullable QPdfSearchModel> searchModelChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#zoomFactor-prop">QPdfView::<wbr/>zoomFactorChanged(qreal)</a></code></p>
     */
    @QtPropertyNotify(name="zoomFactor")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Double> zoomFactorChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#zoomMode-prop">QPdfView::<wbr/>zoomModeChanged(QPdfView::ZoomMode)</a></code></p>
     */
    @QtPropertyNotify(name="zoomMode")
    public final @NonNull Signal1<io.qt.pdf.widgets.QPdfView.@NonNull ZoomMode> zoomModeChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#QPdfView-1">QPdfView::<wbr/>QPdfView()</a></code></p>
     */
    public QPdfView(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QPdfView instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#QPdfView-1">QPdfView::<wbr/>QPdfView(QWidget*)</a></code></p>
     */
    public QPdfView(io.qt.widgets.@Nullable QWidget parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QPdfView instance, io.qt.widgets.QWidget parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#currentSearchResultIndex-prop">QPdfView::<wbr/>currentSearchResultIndex()const</a></code></p>
     */
    @QtPropertyReader(name="currentSearchResultIndex")
    @QtUninvokable
    public final int currentSearchResultIndex(){
        return currentSearchResultIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int currentSearchResultIndex_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#document-prop">QPdfView::<wbr/>document()const</a></code></p>
     */
    @QtPropertyReader(name="document")
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.pdf.@Nullable QPdfDocument document(){
        return document_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.pdf.QPdfDocument document_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#documentMargins-prop">QPdfView::<wbr/>documentMargins()const</a></code></p>
     */
    @QtPropertyReader(name="documentMargins")
    @QtUninvokable
    public final io.qt.core.@NonNull QMargins documentMargins(){
        return documentMargins_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QMargins documentMargins_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#pageMode-prop">QPdfView::<wbr/>pageMode()const</a></code></p>
     */
    @QtPropertyReader(name="pageMode")
    @QtUninvokable
    public final io.qt.pdf.widgets.QPdfView.@NonNull PageMode pageMode(){
        return io.qt.pdf.widgets.QPdfView.PageMode.resolve(pageMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int pageMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#pageSpacing-prop">QPdfView::<wbr/>pageSpacing()const</a></code></p>
     */
    @QtPropertyReader(name="pageSpacing")
    @QtUninvokable
    public final int pageSpacing(){
        return pageSpacing_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int pageSpacing_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#searchModel-prop">QPdfView::<wbr/>searchModel()const</a></code></p>
     */
    @QtPropertyReader(name="searchModel")
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.pdf.@Nullable QPdfSearchModel searchModel(){
        return searchModel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.pdf.QPdfSearchModel searchModel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#currentSearchResultIndex-prop">QPdfView::<wbr/>setCurrentSearchResultIndex(int)</a></code></p>
     */
    @QtPropertyWriter(name="currentSearchResultIndex")
    public final void setCurrentSearchResultIndex(int currentResult){
        setCurrentSearchResultIndex_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), currentResult);
    }
    
    private native void setCurrentSearchResultIndex_native_int(long __this__nativeId, int currentResult);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#document-prop">QPdfView::<wbr/>setDocument(QPdfDocument*)</a></code></p>
     */
    @QtPropertyWriter(name="document")
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setDocument(io.qt.pdf.@Nullable QPdfDocument document){
        setDocument_native_QPdfDocument_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(document));
        __rcDocument = document;
    }
    
    @QtUninvokable
    private native void setDocument_native_QPdfDocument_ptr(long __this__nativeId, long document);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#documentMargins-prop">QPdfView::<wbr/>setDocumentMargins(QMargins)</a></code></p>
     */
    @QtPropertyWriter(name="documentMargins")
    @QtUninvokable
    public final void setDocumentMargins(io.qt.core.@NonNull QMargins margins){
        setDocumentMargins_native_QMargins(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(margins));
    }
    
    @QtUninvokable
    private native void setDocumentMargins_native_QMargins(long __this__nativeId, long margins);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#pageMode-prop">QPdfView::<wbr/>setPageMode(QPdfView::PageMode)</a></code></p>
     */
    @QtPropertyWriter(name="pageMode")
    public final void setPageMode(io.qt.pdf.widgets.QPdfView.@NonNull PageMode mode){
        setPageMode_native_QPdfView_PageMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    private native void setPageMode_native_QPdfView_PageMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#pageSpacing-prop">QPdfView::<wbr/>setPageSpacing(int)</a></code></p>
     */
    @QtPropertyWriter(name="pageSpacing")
    @QtUninvokable
    public final void setPageSpacing(int spacing){
        setPageSpacing_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), spacing);
    }
    
    @QtUninvokable
    private native void setPageSpacing_native_int(long __this__nativeId, int spacing);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#searchModel-prop">QPdfView::<wbr/>setSearchModel(QPdfSearchModel*)</a></code></p>
     */
    @QtPropertyWriter(name="searchModel")
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setSearchModel(io.qt.pdf.@Nullable QPdfSearchModel searchModel){
        setSearchModel_native_QPdfSearchModel_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(searchModel));
        __rcSearchModel = searchModel;
    }
    
    @QtUninvokable
    private native void setSearchModel_native_QPdfSearchModel_ptr(long __this__nativeId, long searchModel);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#zoomFactor-prop">QPdfView::<wbr/>setZoomFactor(qreal)</a></code></p>
     */
    @QtPropertyWriter(name="zoomFactor")
    public final void setZoomFactor(double factor){
        setZoomFactor_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), factor);
    }
    
    private native void setZoomFactor_native_qreal(long __this__nativeId, double factor);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#zoomMode-prop">QPdfView::<wbr/>setZoomMode(QPdfView::ZoomMode)</a></code></p>
     */
    @QtPropertyWriter(name="zoomMode")
    public final void setZoomMode(io.qt.pdf.widgets.QPdfView.@NonNull ZoomMode mode){
        setZoomMode_native_QPdfView_ZoomMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    private native void setZoomMode_native_QPdfView_ZoomMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#zoomFactor-prop">QPdfView::<wbr/>zoomFactor()const</a></code></p>
     */
    @QtPropertyReader(name="zoomFactor")
    @QtUninvokable
    public final double zoomFactor(){
        return zoomFactor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double zoomFactor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfview.html#zoomMode-prop">QPdfView::<wbr/>zoomMode()const</a></code></p>
     */
    @QtPropertyReader(name="zoomMode")
    @QtUninvokable
    public final io.qt.pdf.widgets.QPdfView.@NonNull ZoomMode zoomMode(){
        return io.qt.pdf.widgets.QPdfView.ZoomMode.resolve(zoomMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int zoomMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#mouseMoveEvent">QWidget::<wbr/>mouseMoveEvent(QMouseEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void mouseMoveEvent(io.qt.gui.@Nullable QMouseEvent event){
        mouseMoveEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void mouseMoveEvent_native_QMouseEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#mousePressEvent">QWidget::<wbr/>mousePressEvent(QMouseEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void mousePressEvent(io.qt.gui.@Nullable QMouseEvent event){
        mousePressEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void mousePressEvent_native_QMouseEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#mouseReleaseEvent">QWidget::<wbr/>mouseReleaseEvent(QMouseEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void mouseReleaseEvent(io.qt.gui.@Nullable QMouseEvent event){
        mouseReleaseEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void mouseReleaseEvent_native_QMouseEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#paintEvent">QWidget::<wbr/>paintEvent(QPaintEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void paintEvent(io.qt.gui.@Nullable QPaintEvent event){
        paintEvent_native_QPaintEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void paintEvent_native_QPaintEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#resizeEvent">QWidget::<wbr/>resizeEvent(QResizeEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void resizeEvent(io.qt.gui.@Nullable QResizeEvent event){
        resizeEvent_native_QResizeEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void resizeEvent_native_QResizeEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractscrollarea.html#scrollContentsBy">QAbstractScrollArea::<wbr/>scrollContentsBy(int,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void scrollContentsBy(int dx, int dy){
        scrollContentsBy_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), dx, dy);
    }
    
    @QtUninvokable
    private native void scrollContentsBy_native_int_int(long __this__nativeId, int dx, int dy);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QPdfView(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QPdfView(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QPdfView instance, QDeclarativeConstructor constructor);
    
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #currentSearchResultIndex()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getCurrentSearchResultIndex() {
        return currentSearchResultIndex();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #document()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.pdf.@Nullable QPdfDocument getDocument() {
        return document();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #documentMargins()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QMargins getDocumentMargins() {
        return documentMargins();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #pageMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.pdf.widgets.QPdfView.@NonNull PageMode getPageMode() {
        return pageMode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #pageSpacing()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getPageSpacing() {
        return pageSpacing();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #searchModel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.pdf.@Nullable QPdfSearchModel getSearchModel() {
        return searchModel();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #zoomFactor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getZoomFactor() {
        return zoomFactor();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #zoomMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.pdf.widgets.QPdfView.@NonNull ZoomMode getZoomMode() {
        return zoomMode();
    }
}
