package io.qt.pdf.widgets;

import io.qt.*;


/**
 * <p>A widget for selecting a PDF page</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qpdfpageselector.html">QPdfPageSelector</a></code></p>
 */
public class QPdfPageSelector extends io.qt.widgets.QWidget
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcDocument = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPdfPageSelector.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfpageselector.html#currentPage-prop">QPdfPageSelector::<wbr/>currentPageChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="currentPage")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> currentPageChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfpageselector.html#currentPageLabel-prop">QPdfPageSelector::<wbr/>currentPageLabelChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="currentPageLabel")
    public final @NonNull Signal1<java.lang.@NonNull String> currentPageLabelChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfpageselector.html#document-prop">QPdfPageSelector::<wbr/>documentChanged(QPdfDocument*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtPropertyNotify(name="document")
    public final @NonNull Signal1<io.qt.pdf.@Nullable QPdfDocument> documentChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfpageselector.html#QPdfPageSelector-1">QPdfPageSelector::<wbr/>QPdfPageSelector()</a></code></p>
     */
    public QPdfPageSelector(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QPdfPageSelector instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfpageselector.html#QPdfPageSelector-1">QPdfPageSelector::<wbr/>QPdfPageSelector(QWidget*)</a></code></p>
     */
    public QPdfPageSelector(io.qt.widgets.@Nullable QWidget parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QPdfPageSelector instance, io.qt.widgets.QWidget parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfpageselector.html#currentPage-prop">QPdfPageSelector::<wbr/>currentPage()const</a></code></p>
     */
    @QtPropertyReader(name="currentPage")
    @QtPropertyUser
    @QtUninvokable
    public final int currentPage(){
        return currentPage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int currentPage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfpageselector.html#currentPageLabel-prop">QPdfPageSelector::<wbr/>currentPageLabel()const</a></code></p>
     */
    @QtPropertyReader(name="currentPageLabel")
    @QtUninvokable
    public final java.lang.@NonNull String currentPageLabel(){
        return currentPageLabel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String currentPageLabel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfpageselector.html#document-prop">QPdfPageSelector::<wbr/>document()const</a></code></p>
     */
    @QtPropertyReader(name="document")
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.pdf.@Nullable QPdfDocument document(){
        return document_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.pdf.QPdfDocument document_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfpageselector.html#currentPage-prop">QPdfPageSelector::<wbr/>setCurrentPage(int)</a></code></p>
     */
    @QtPropertyWriter(name="currentPage")
    public final void setCurrentPage(int index){
        setCurrentPage_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    private native void setCurrentPage_native_int(long __this__nativeId, int index);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpdfpageselector.html#document-prop">QPdfPageSelector::<wbr/>setDocument(QPdfDocument*)</a></code></p>
     */
    @QtPropertyWriter(name="document")
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setDocument(io.qt.pdf.@Nullable QPdfDocument document){
        setDocument_native_QPdfDocument_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(document));
        __rcDocument = document;
    }
    
    @QtUninvokable
    private native void setDocument_native_QPdfDocument_ptr(long __this__nativeId, long document);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QPdfPageSelector(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QPdfPageSelector(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QPdfPageSelector instance, QDeclarativeConstructor constructor);
    
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #currentPage()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getCurrentPage() {
        return currentPage();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #currentPageLabel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getCurrentPageLabel() {
        return currentPageLabel();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #document()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.pdf.@Nullable QPdfDocument getDocument() {
        return document();
    }
}
