package io.qt.pdf.widgets;


/**
 * <p>A PDF viewer widget</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qpdfview.html">QPdfView</a></p>
 */
public class QPdfView extends io.qt.widgets.QAbstractScrollArea
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcDocument = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPdfView.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qpdfview.html#PageMode-enum">QPdfView::PageMode</a></p>
     */
    public enum PageMode implements io.qt.QtEnumerator {
        SinglePage(0),
        MultiPage(1);

        private PageMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static PageMode resolve(int value) {
            switch (value) {
            case 0: return SinglePage;
            case 1: return MultiPage;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qpdfview.html#ZoomMode-enum">QPdfView::ZoomMode</a></p>
     */
    public enum ZoomMode implements io.qt.QtEnumerator {
        Custom(0),
        FitToWidth(1),
        FitInView(2);

        private ZoomMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ZoomMode resolve(int value) {
            switch (value) {
            case 0: return Custom;
            case 1: return FitToWidth;
            case 2: return FitInView;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qpdfview.html#document-prop">QPdfView::documentChanged(QPdfDocument*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtPropertyNotify(name="document")
    public final Signal1<io.qt.pdf.QPdfDocument> documentChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qpdfview.html#documentMargins-prop">QPdfView::documentMarginsChanged(QMargins)</a></p>
     */
    @io.qt.QtPropertyNotify(name="documentMargins")
    public final Signal1<io.qt.core.QMargins> documentMarginsChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qpdfview.html#pageMode-prop">QPdfView::pageModeChanged(QPdfView::PageMode)</a></p>
     */
    @io.qt.QtPropertyNotify(name="pageMode")
    public final Signal1<io.qt.pdf.widgets.QPdfView.PageMode> pageModeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qpdfview.html#pageSpacing-prop">QPdfView::pageSpacingChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="pageSpacing")
    public final Signal1<@io.qt.QtPrimitiveType Integer> pageSpacingChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qpdfview.html#zoomFactor-prop">QPdfView::zoomFactorChanged(qreal)</a></p>
     */
    @io.qt.QtPropertyNotify(name="zoomFactor")
    public final Signal1<@io.qt.QtPrimitiveType Double> zoomFactorChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qpdfview.html#zoomMode-prop">QPdfView::zoomModeChanged(QPdfView::ZoomMode)</a></p>
     */
    @io.qt.QtPropertyNotify(name="zoomMode")
    public final Signal1<io.qt.pdf.widgets.QPdfView.ZoomMode> zoomModeChanged = new Signal1<>();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpdfview.html#QPdfView-1">QPdfView::QPdfView()</a></p>
     */
    public QPdfView(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QPdfView instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpdfview.html#QPdfView-1">QPdfView::QPdfView(QWidget*)</a></p>
     */
    public QPdfView(io.qt.widgets.QWidget parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QPdfView instance, io.qt.widgets.QWidget parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpdfview.html#document-prop">QPdfView::document()const</a></p>
     */
    @io.qt.QtPropertyReader(name="document")
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.pdf.QPdfDocument document(){
        return document_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.pdf.QPdfDocument document_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpdfview.html#documentMargins-prop">QPdfView::documentMargins()const</a></p>
     */
    @io.qt.QtPropertyReader(name="documentMargins")
    @io.qt.QtUninvokable
    public final io.qt.core.QMargins documentMargins(){
        return documentMargins_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QMargins documentMargins_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpdfview.html#pageMode-prop">QPdfView::pageMode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="pageMode")
    @io.qt.QtUninvokable
    public final io.qt.pdf.widgets.QPdfView.PageMode pageMode(){
        return io.qt.pdf.widgets.QPdfView.PageMode.resolve(pageMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int pageMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpdfview.html#pageSpacing-prop">QPdfView::pageSpacing()const</a></p>
     */
    @io.qt.QtPropertyReader(name="pageSpacing")
    @io.qt.QtUninvokable
    public final int pageSpacing(){
        return pageSpacing_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int pageSpacing_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpdfview.html#document-prop">QPdfView::setDocument(QPdfDocument*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="document")
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void setDocument(io.qt.pdf.QPdfDocument document){
        setDocument_native_QPdfDocument_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(document));
        __rcDocument = document;
    }
    
    @io.qt.QtUninvokable
    private native void setDocument_native_QPdfDocument_ptr(long __this__nativeId, long document);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpdfview.html#documentMargins-prop">QPdfView::setDocumentMargins(QMargins)</a></p>
     */
    @io.qt.QtPropertyWriter(name="documentMargins")
    @io.qt.QtUninvokable
    public final void setDocumentMargins(io.qt.core.QMargins margins){
        setDocumentMargins_native_QMargins(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(margins));
    }
    
    @io.qt.QtUninvokable
    private native void setDocumentMargins_native_QMargins(long __this__nativeId, long margins);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpdfview.html#pageMode-prop">QPdfView::setPageMode(QPdfView::PageMode)</a></p>
     */
    @io.qt.QtPropertyWriter(name="pageMode")
    public final void setPageMode(io.qt.pdf.widgets.QPdfView.PageMode mode){
        setPageMode_native_QPdfView_PageMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    private native void setPageMode_native_QPdfView_PageMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpdfview.html#pageSpacing-prop">QPdfView::setPageSpacing(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="pageSpacing")
    @io.qt.QtUninvokable
    public final void setPageSpacing(int spacing){
        setPageSpacing_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), spacing);
    }
    
    @io.qt.QtUninvokable
    private native void setPageSpacing_native_int(long __this__nativeId, int spacing);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpdfview.html#zoomFactor-prop">QPdfView::setZoomFactor(qreal)</a></p>
     */
    @io.qt.QtPropertyWriter(name="zoomFactor")
    public final void setZoomFactor(double factor){
        setZoomFactor_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), factor);
    }
    
    private native void setZoomFactor_native_qreal(long __this__nativeId, double factor);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpdfview.html#zoomMode-prop">QPdfView::setZoomMode(QPdfView::ZoomMode)</a></p>
     */
    @io.qt.QtPropertyWriter(name="zoomMode")
    public final void setZoomMode(io.qt.pdf.widgets.QPdfView.ZoomMode mode){
        setZoomMode_native_QPdfView_ZoomMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    private native void setZoomMode_native_QPdfView_ZoomMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpdfview.html#zoomFactor-prop">QPdfView::zoomFactor()const</a></p>
     */
    @io.qt.QtPropertyReader(name="zoomFactor")
    @io.qt.QtUninvokable
    public final double zoomFactor(){
        return zoomFactor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double zoomFactor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpdfview.html#zoomMode-prop">QPdfView::zoomMode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="zoomMode")
    @io.qt.QtUninvokable
    public final io.qt.pdf.widgets.QPdfView.ZoomMode zoomMode(){
        return io.qt.pdf.widgets.QPdfView.ZoomMode.resolve(zoomMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int zoomMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwidget.html#paintEvent">QWidget::paintEvent(QPaintEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void paintEvent(io.qt.gui.QPaintEvent event){
        paintEvent_native_QPaintEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void paintEvent_native_QPaintEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwidget.html#resizeEvent">QWidget::resizeEvent(QResizeEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void resizeEvent(io.qt.gui.QResizeEvent event){
        resizeEvent_native_QResizeEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void resizeEvent_native_QResizeEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractscrollarea.html#scrollContentsBy">QAbstractScrollArea::scrollContentsBy(int,int)</a></p>
     */
    @io.qt.QtUninvokable
    protected void scrollContentsBy(int dx, int dy){
        scrollContentsBy_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), dx, dy);
    }
    
    @io.qt.QtUninvokable
    private native void scrollContentsBy_native_int_int(long __this__nativeId, int dx, int dy);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QPdfView(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QPdfView(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QPdfView instance, QDeclarativeConstructor constructor);
    
}
