package io.qt.opengl.widgets;

import io.qt.*;


/**
 * <p>Widget for rendering OpenGL graphics</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qopenglwidget.html">QOpenGLWidget</a></code></p>
 */
public class QOpenGLWidget extends io.qt.widgets.QWidget
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QOpenGLWidget.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qopenglwidget.html#TargetBuffer-enum">QOpenGLWidget::TargetBuffer</a></code></p>
     */
    public enum TargetBuffer implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglwidget.html#TargetBuffer-enum">QOpenGLWidget::<wbr/>LeftBuffer</a></code></p>
         */
        LeftBuffer(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglwidget.html#TargetBuffer-enum">QOpenGLWidget::<wbr/>RightBuffer</a></code></p>
         */
        RightBuffer(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private TargetBuffer(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull TargetBuffer resolve(int value) {
            switch (value) {
            case 0: return LeftBuffer;
            case 1: return RightBuffer;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qopenglwidget.html#UpdateBehavior-enum">QOpenGLWidget::UpdateBehavior</a></code></p>
     */
    public enum UpdateBehavior implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglwidget.html#UpdateBehavior-enum">QOpenGLWidget::<wbr/>NoPartialUpdate</a></code></p>
         */
        NoPartialUpdate(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglwidget.html#UpdateBehavior-enum">QOpenGLWidget::<wbr/>PartialUpdate</a></code></p>
         */
        PartialUpdate(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private UpdateBehavior(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull UpdateBehavior resolve(int value) {
            switch (value) {
            case 0: return NoPartialUpdate;
            case 1: return PartialUpdate;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#aboutToCompose">QOpenGLWidget::<wbr/>aboutToCompose()</a></code></p>
     */
    public final @NonNull Signal0 aboutToCompose = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#aboutToResize">QOpenGLWidget::<wbr/>aboutToResize()</a></code></p>
     */
    public final @NonNull Signal0 aboutToResize = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#frameSwapped">QOpenGLWidget::<wbr/>frameSwapped()</a></code></p>
     */
    public final @NonNull Signal0 frameSwapped = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#resized">QOpenGLWidget::<wbr/>resized()</a></code></p>
     */
    public final @NonNull Signal0 resized = new Signal0();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#QOpenGLWidget">QOpenGLWidget::<wbr/>QOpenGLWidget(QWidget*,<wbr/>Qt::WindowFlags)</a></code></p>
     */
    public QOpenGLWidget(io.qt.widgets.@Nullable QWidget parent, io.qt.core.Qt.@NonNull WindowFlags f){
        super((QPrivateConstructor)null);
        initialize_native(this, parent, f);
    }
    
    private native static void initialize_native(QOpenGLWidget instance, io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowFlags f);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#context">QOpenGLWidget::<wbr/>context()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.@Nullable QOpenGLContext context(){
        return context_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QOpenGLContext context_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#currentTargetBuffer">QOpenGLWidget::<wbr/>currentTargetBuffer()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.opengl.widgets.QOpenGLWidget.@NonNull TargetBuffer currentTargetBuffer(){
        return io.qt.opengl.widgets.QOpenGLWidget.TargetBuffer.resolve(currentTargetBuffer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int currentTargetBuffer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#defaultFramebufferObject">QOpenGLWidget::<wbr/>defaultFramebufferObject()const</a></code></p>
     */
    @QtUninvokable
    public final int defaultFramebufferObject(){
        return defaultFramebufferObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int defaultFramebufferObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#defaultFramebufferObject-1">QOpenGLWidget::<wbr/>defaultFramebufferObject(QOpenGLWidget::TargetBuffer)const</a></code></p>
     */
    @QtUninvokable
    public final int defaultFramebufferObject(io.qt.opengl.widgets.QOpenGLWidget.@NonNull TargetBuffer targetBuffer){
        return defaultFramebufferObject_native_QOpenGLWidget_TargetBuffer_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), targetBuffer.value());
    }
    
    @QtUninvokable
    private native int defaultFramebufferObject_native_QOpenGLWidget_TargetBuffer_constfct(long __this__nativeId, int targetBuffer);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#doneCurrent">QOpenGLWidget::<wbr/>doneCurrent()</a></code></p>
     */
    @QtUninvokable
    public final void doneCurrent(){
        doneCurrent_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void doneCurrent_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#format">QOpenGLWidget::<wbr/>format()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QSurfaceFormat format(){
        return format_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QSurfaceFormat format_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#grabFramebuffer">QOpenGLWidget::<wbr/>grabFramebuffer()</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QImage grabFramebuffer(){
        return grabFramebuffer_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QImage grabFramebuffer_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#grabFramebuffer-1">QOpenGLWidget::<wbr/>grabFramebuffer(QOpenGLWidget::TargetBuffer)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QImage grabFramebuffer(io.qt.opengl.widgets.QOpenGLWidget.@NonNull TargetBuffer targetBuffer){
        return grabFramebuffer_native_QOpenGLWidget_TargetBuffer(QtJambi_LibraryUtilities.internal.nativeId(this), targetBuffer.value());
    }
    
    @QtUninvokable
    private native io.qt.gui.QImage grabFramebuffer_native_QOpenGLWidget_TargetBuffer(long __this__nativeId, int targetBuffer);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#isValid">QOpenGLWidget::<wbr/>isValid()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#makeCurrent">QOpenGLWidget::<wbr/>makeCurrent()</a></code></p>
     */
    @QtUninvokable
    public final void makeCurrent(){
        makeCurrent_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void makeCurrent_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#makeCurrent-1">QOpenGLWidget::<wbr/>makeCurrent(QOpenGLWidget::TargetBuffer)</a></code></p>
     */
    @QtUninvokable
    public final void makeCurrent(io.qt.opengl.widgets.QOpenGLWidget.@NonNull TargetBuffer targetBuffer){
        makeCurrent_native_QOpenGLWidget_TargetBuffer(QtJambi_LibraryUtilities.internal.nativeId(this), targetBuffer.value());
    }
    
    @QtUninvokable
    private native void makeCurrent_native_QOpenGLWidget_TargetBuffer(long __this__nativeId, int targetBuffer);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#setFormat">QOpenGLWidget::<wbr/>setFormat(QSurfaceFormat)</a></code></p>
     */
    @QtUninvokable
    public final void setFormat(io.qt.gui.@NonNull QSurfaceFormat format){
        setFormat_native_cref_QSurfaceFormat(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(format));
    }
    
    @QtUninvokable
    private native void setFormat_native_cref_QSurfaceFormat(long __this__nativeId, long format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#setTextureFormat">QOpenGLWidget::<wbr/>setTextureFormat(GLenum)</a></code></p>
     */
    @QtUninvokable
    public final void setTextureFormat(int texFormat){
        setTextureFormat_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), texFormat);
    }
    
    @QtUninvokable
    private native void setTextureFormat_native_GLenum(long __this__nativeId, int texFormat);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#setUpdateBehavior">QOpenGLWidget::<wbr/>setUpdateBehavior(QOpenGLWidget::UpdateBehavior)</a></code></p>
     */
    @QtUninvokable
    public final void setUpdateBehavior(io.qt.opengl.widgets.QOpenGLWidget.@NonNull UpdateBehavior updateBehavior){
        setUpdateBehavior_native_QOpenGLWidget_UpdateBehavior(QtJambi_LibraryUtilities.internal.nativeId(this), updateBehavior.value());
    }
    
    @QtUninvokable
    private native void setUpdateBehavior_native_QOpenGLWidget_UpdateBehavior(long __this__nativeId, int updateBehavior);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#textureFormat">QOpenGLWidget::<wbr/>textureFormat()const</a></code></p>
     */
    @QtUninvokable
    public final int textureFormat(){
        return textureFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int textureFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#updateBehavior">QOpenGLWidget::<wbr/>updateBehavior()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.opengl.widgets.QOpenGLWidget.@NonNull UpdateBehavior updateBehavior(){
        return io.qt.opengl.widgets.QOpenGLWidget.UpdateBehavior.resolve(updateBehavior_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int updateBehavior_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qobject.html#event">QObject::<wbr/>event(QEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    public boolean event(io.qt.core.@Nullable QEvent e){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#initializeGL">QOpenGLWidget::<wbr/>initializeGL()</a></code></p>
     */
    @QtUninvokable
    protected void initializeGL(){
        initializeGL_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void initializeGL_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#metric">QPaintDevice::<wbr/>metric(QPaintDevice::PaintDeviceMetric)const</a></code></p>
     */
    @QtUninvokable
    @Override
    protected int metric(io.qt.gui.QPaintDevice.@NonNull PaintDeviceMetric metric){
        return metric_native_QPaintDevice_PaintDeviceMetric_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), metric.value());
    }
    
    private native static int metric_native_QPaintDevice_PaintDeviceMetric_constfct(long __this__nativeId, int metric);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#paintEngine">QPaintDevice::<wbr/>paintEngine()const</a></code></p>
     */
    @QtUninvokable
    @Override
    public io.qt.gui.@Nullable QPaintEngine paintEngine(){
        return paintEngine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.gui.QPaintEngine paintEngine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#paintEvent">QWidget::<wbr/>paintEvent(QPaintEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void paintEvent(io.qt.gui.@Nullable QPaintEvent e){
        paintEvent_native_QPaintEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @QtUninvokable
    private native void paintEvent_native_QPaintEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#paintGL">QOpenGLWidget::<wbr/>paintGL()</a></code></p>
     */
    @QtUninvokable
    protected void paintGL(){
        paintGL_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void paintGL_native(long __this__nativeId);
    
    /**
     * <p>See <code>QPaintDevice::<wbr/>redirected(QPoint*)const</code></p>
     */
    @QtUninvokable
    @Override
    protected io.qt.gui.@Nullable QPaintDevice redirected(io.qt.core.@Nullable QPoint p){
        return redirected_native_QPoint_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(p));
    }
    
    private native static io.qt.gui.QPaintDevice redirected_native_QPoint_ptr_constfct(long __this__nativeId, long p);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#resizeEvent">QWidget::<wbr/>resizeEvent(QResizeEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void resizeEvent(io.qt.gui.@Nullable QResizeEvent e){
        resizeEvent_native_QResizeEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @QtUninvokable
    private native void resizeEvent_native_QResizeEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglwidget.html#resizeGL">QOpenGLWidget::<wbr/>resizeGL(int,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    protected void resizeGL(int w, int h){
        resizeGL_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), w, h);
    }
    
    @QtUninvokable
    private native void resizeGL_native_int_int(long __this__nativeId, int w, int h);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QOpenGLWidget(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QOpenGLWidget(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QOpenGLWidget instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLWidget(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}
     *  with <code>f = new io.qt.core.Qt.WindowFlags(0)</code>.</p>
     */
    public QOpenGLWidget(io.qt.widgets.@Nullable QWidget parent) {
        this(parent, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLWidget(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}</p>
     * <p>with: </p><ul>
     * <li><code>parent = null</code></li>
     * <li><code>f = new io.qt.core.Qt.WindowFlags(0)</code></li>
     * </ul>
     */
    public QOpenGLWidget() {
        this((io.qt.widgets.QWidget)null, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLWidget(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}.</p>
     */
    public QOpenGLWidget(io.qt.widgets.@Nullable QWidget parent, io.qt.core.Qt.@NonNull WindowType @NonNull... f) {
        this(parent, new io.qt.core.Qt.WindowFlags(f));
    }
    
    /**
     * <p>Overloaded function for {@link #setFormat(io.qt.gui.QSurfaceFormat)}.</p>
     */
    @QtUninvokable
    public final void setFormat(io.qt.gui.QSurfaceFormat.@NonNull FormatOptions format) {
        setFormat(new io.qt.gui.QSurfaceFormat(format));
    }
}
