package io.qt.opengl.widgets;


/**
 * <p>Widget for rendering OpenGL graphics</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qopenglwidget.html">QOpenGLWidget</a></p>
 */
public class QOpenGLWidget extends io.qt.widgets.QWidget
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QOpenGLWidget.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopenglwidget.html#UpdateBehavior-enum">QOpenGLWidget::UpdateBehavior</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum UpdateBehavior implements io.qt.QtEnumerator {
        NoPartialUpdate(0),
        PartialUpdate(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private UpdateBehavior(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static UpdateBehavior resolve(int value) {
            switch (value) {
            case 0: return NoPartialUpdate;
            case 1: return PartialUpdate;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwidget.html#aboutToCompose">QOpenGLWidget::aboutToCompose()</a></p>
     */
    public final Signal0 aboutToCompose = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwidget.html#aboutToResize">QOpenGLWidget::aboutToResize()</a></p>
     */
    public final Signal0 aboutToResize = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwidget.html#frameSwapped">QOpenGLWidget::frameSwapped()</a></p>
     */
    public final Signal0 frameSwapped = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwidget.html#resized">QOpenGLWidget::resized()</a></p>
     */
    public final Signal0 resized = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLWidget(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}.</p>
     */
    public QOpenGLWidget(io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowType ... f){
        this(parent, new io.qt.core.Qt.WindowFlags(f));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLWidget(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}
     *  with <code>f = new io.qt.core.Qt.WindowFlags(0)</code>.</p>
     */
    public QOpenGLWidget(io.qt.widgets.QWidget parent) {
        this(parent, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLWidget(io.qt.widgets.QWidget, io.qt.core.Qt.WindowFlags)}</p>
     * <p>with: </p><ul>
     * <li><code>parent = null</code></li>
     * <li><code>f = new io.qt.core.Qt.WindowFlags(0)</code></li>
     * </ul>
     */
    public QOpenGLWidget() {
        this((io.qt.widgets.QWidget)null, new io.qt.core.Qt.WindowFlags(0));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwidget.html#QOpenGLWidget">QOpenGLWidget::QOpenGLWidget(QWidget*,Qt::WindowFlags)</a></p>
     */
    public QOpenGLWidget(io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowFlags f){
        super((QPrivateConstructor)null);
        initialize_native(this, parent, f);
    }
    
    private native static void initialize_native(QOpenGLWidget instance, io.qt.widgets.QWidget parent, io.qt.core.Qt.WindowFlags f);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwidget.html#context">QOpenGLWidget::context()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QOpenGLContext context(){
        return context_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QOpenGLContext context_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwidget.html#defaultFramebufferObject">QOpenGLWidget::defaultFramebufferObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int defaultFramebufferObject(){
        return defaultFramebufferObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int defaultFramebufferObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwidget.html#doneCurrent">QOpenGLWidget::doneCurrent()</a></p>
     */
    @io.qt.QtUninvokable
    public final void doneCurrent(){
        doneCurrent_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void doneCurrent_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwidget.html#format">QOpenGLWidget::format()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QSurfaceFormat format(){
        return format_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QSurfaceFormat format_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwidget.html#grabFramebuffer">QOpenGLWidget::grabFramebuffer()</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QImage grabFramebuffer(){
        return grabFramebuffer_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QImage grabFramebuffer_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwidget.html#isValid">QOpenGLWidget::isValid()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwidget.html#makeCurrent">QOpenGLWidget::makeCurrent()</a></p>
     */
    @io.qt.QtUninvokable
    public final void makeCurrent(){
        makeCurrent_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void makeCurrent_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwidget.html#setFormat">QOpenGLWidget::setFormat(QSurfaceFormat)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFormat(io.qt.gui.QSurfaceFormat format){
        setFormat_native_cref_QSurfaceFormat(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(format));
    }
    
    @io.qt.QtUninvokable
    private native void setFormat_native_cref_QSurfaceFormat(long __this__nativeId, long format);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwidget.html#setTextureFormat">QOpenGLWidget::setTextureFormat(GLenum)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setTextureFormat(int texFormat){
        setTextureFormat_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), texFormat);
    }
    
    @io.qt.QtUninvokable
    private native void setTextureFormat_native_GLenum(long __this__nativeId, int texFormat);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwidget.html#setUpdateBehavior">QOpenGLWidget::setUpdateBehavior(QOpenGLWidget::UpdateBehavior)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUpdateBehavior(io.qt.opengl.widgets.QOpenGLWidget.UpdateBehavior updateBehavior){
        setUpdateBehavior_native_QOpenGLWidget_UpdateBehavior(QtJambi_LibraryUtilities.internal.nativeId(this), updateBehavior.value());
    }
    
    @io.qt.QtUninvokable
    private native void setUpdateBehavior_native_QOpenGLWidget_UpdateBehavior(long __this__nativeId, int updateBehavior);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwidget.html#textureFormat">QOpenGLWidget::textureFormat()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int textureFormat(){
        return textureFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int textureFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwidget.html#updateBehavior">QOpenGLWidget::updateBehavior()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.opengl.widgets.QOpenGLWidget.UpdateBehavior updateBehavior(){
        return io.qt.opengl.widgets.QOpenGLWidget.UpdateBehavior.resolve(updateBehavior_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int updateBehavior_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qobject.html#event">QObject::event(QEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    public boolean event(io.qt.core.QEvent e){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @io.qt.QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwidget.html#initializeGL">QOpenGLWidget::initializeGL()</a></p>
     */
    @io.qt.QtUninvokable
    protected void initializeGL(){
        initializeGL_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void initializeGL_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpaintdevice.html#metric">QPaintDevice::metric(QPaintDevice::PaintDeviceMetric)const</a></p>
     */
    @io.qt.QtUninvokable
    protected int metric(io.qt.gui.QPaintDevice.PaintDeviceMetric metric){
        return metric_native_QPaintDevice_PaintDeviceMetric_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), metric.value());
    }
    
    private native static int metric_native_QPaintDevice_PaintDeviceMetric_constfct(long __this__nativeId, int metric);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpaintdevice.html#paintEngine">QPaintDevice::paintEngine()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.gui.QPaintEngine paintEngine(){
        return paintEngine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.gui.QPaintEngine paintEngine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwidget.html#paintEvent">QWidget::paintEvent(QPaintEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void paintEvent(io.qt.gui.QPaintEvent e){
        paintEvent_native_QPaintEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @io.qt.QtUninvokable
    private native void paintEvent_native_QPaintEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwidget.html#paintGL">QOpenGLWidget::paintGL()</a></p>
     */
    @io.qt.QtUninvokable
    protected void paintGL(){
        paintGL_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void paintGL_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected io.qt.gui.QPaintDevice redirected(io.qt.core.QPoint p){
        return redirected_native_QPoint_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), p);
    }
    
    private native static io.qt.gui.QPaintDevice redirected_native_QPoint_ptr_constfct(long __this__nativeId, io.qt.core.QPoint p);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwidget.html#resizeEvent">QWidget::resizeEvent(QResizeEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void resizeEvent(io.qt.gui.QResizeEvent e){
        resizeEvent_native_QResizeEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @io.qt.QtUninvokable
    private native void resizeEvent_native_QResizeEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwidget.html#resizeGL">QOpenGLWidget::resizeGL(int,int)</a></p>
     */
    @io.qt.QtUninvokable
    protected void resizeGL(int w, int h){
        resizeGL_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), w, h);
    }
    
    @io.qt.QtUninvokable
    private native void resizeGL_native_int_int(long __this__nativeId, int w, int h);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QOpenGLWidget(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QOpenGLWidget(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QOpenGLWidget instance, QDeclarativeConstructor constructor);
    
}
