package io.qt.opengl;

import io.qt.*;


/**
 * <p>All functions for OpenGL 4.3 core profile</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qopenglfunctions-4-3-core.html">QOpenGLFunctions_4_3_Core</a></code></p>
 */
public class QOpenGLFunctions_4_3_Core extends io.qt.opengl.QAbstractOpenGLFunctions
{
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>QOpenGLFunctions_4_3_Core()</code></p>
     */
    public QOpenGLFunctions_4_3_Core(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLFunctions_4_3_Core instance);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glActiveShaderProgram(GLuint,<wbr/>GLuint)</code></p>
     * @param pipeline
     * @param program
     */
    @QtUninvokable
    public final void glActiveShaderProgram(int pipeline, int program){
        glActiveShaderProgram_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), pipeline, program);
    }
    
    @QtUninvokable
    private native void glActiveShaderProgram_native_GLuint_GLuint(long __this__nativeId, int pipeline, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glActiveTexture(GLenum)</code></p>
     * @param texture
     */
    @QtUninvokable
    public final void glActiveTexture(int texture){
        glActiveTexture_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @QtUninvokable
    private native void glActiveTexture_native_GLenum(long __this__nativeId, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glAttachShader(GLuint,<wbr/>GLuint)</code></p>
     * @param program
     * @param shader
     */
    @QtUninvokable
    public final void glAttachShader(int program, int shader){
        glAttachShader_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, shader);
    }
    
    @QtUninvokable
    private native void glAttachShader_native_GLuint_GLuint(long __this__nativeId, int program, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBeginConditionalRender(GLuint,<wbr/>GLenum)</code></p>
     * @param id
     * @param mode
     */
    @QtUninvokable
    public final void glBeginConditionalRender(int id, int mode){
        glBeginConditionalRender_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), id, mode);
    }
    
    @QtUninvokable
    private native void glBeginConditionalRender_native_GLuint_GLenum(long __this__nativeId, int id, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBeginQuery(GLenum,<wbr/>GLuint)</code></p>
     * @param target
     * @param id
     */
    @QtUninvokable
    public final void glBeginQuery(int target, int id){
        glBeginQuery_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, id);
    }
    
    @QtUninvokable
    private native void glBeginQuery_native_GLenum_GLuint(long __this__nativeId, int target, int id);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBeginQueryIndexed(GLenum,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     * @param target
     * @param index
     * @param id
     */
    @QtUninvokable
    public final void glBeginQueryIndexed(int target, int index, int id){
        glBeginQueryIndexed_native_GLenum_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, id);
    }
    
    @QtUninvokable
    private native void glBeginQueryIndexed_native_GLenum_GLuint_GLuint(long __this__nativeId, int target, int index, int id);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBeginTransformFeedback(GLenum)</code></p>
     * @param primitiveMode
     */
    @QtUninvokable
    public final void glBeginTransformFeedback(int primitiveMode){
        glBeginTransformFeedback_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), primitiveMode);
    }
    
    @QtUninvokable
    private native void glBeginTransformFeedback_native_GLenum(long __this__nativeId, int primitiveMode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBindAttribLocation(GLuint,<wbr/>GLuint,<wbr/>const GLchar*)</code></p>
     * @param program
     * @param index
     * @param name
     */
    @QtUninvokable
    public final void glBindAttribLocation(int program, int index, java.nio.@Nullable CharBuffer name){
        glBindAttribLocation_native_GLuint_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, name);
    }
    
    @QtUninvokable
    private native void glBindAttribLocation_native_GLuint_GLuint_const_GLchar_ptr(long __this__nativeId, int program, int index, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBindBuffer(GLenum,<wbr/>GLuint)</code></p>
     * @param target
     * @param buffer
     */
    @QtUninvokable
    public final void glBindBuffer(int target, int buffer){
        glBindBuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, buffer);
    }
    
    @QtUninvokable
    private native void glBindBuffer_native_GLenum_GLuint(long __this__nativeId, int target, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBindBufferBase(GLenum,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     * @param target
     * @param index
     * @param buffer
     */
    @QtUninvokable
    public final void glBindBufferBase(int target, int index, int buffer){
        glBindBufferBase_native_GLenum_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, buffer);
    }
    
    @QtUninvokable
    private native void glBindBufferBase_native_GLenum_GLuint_GLuint(long __this__nativeId, int target, int index, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBindBufferRange(GLenum,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLintptr,<wbr/>GLsizeiptr)</code></p>
     * @param target
     * @param index
     * @param buffer
     * @param offset
     * @param size
     */
    @QtUninvokable
    public final void glBindBufferRange(int target, int index, int buffer, long offset, long size){
        glBindBufferRange_native_GLenum_GLuint_GLuint_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, buffer, offset, size);
    }
    
    @QtUninvokable
    private native void glBindBufferRange_native_GLenum_GLuint_GLuint_GLintptr_GLsizeiptr(long __this__nativeId, int target, int index, int buffer, long offset, long size);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBindFragDataLocation(GLuint,<wbr/>GLuint,<wbr/>const GLchar*)</code></p>
     * @param program
     * @param color
     * @param name
     */
    @QtUninvokable
    public final void glBindFragDataLocation(int program, int color, java.nio.@Nullable CharBuffer name){
        glBindFragDataLocation_native_GLuint_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, color, name);
    }
    
    @QtUninvokable
    private native void glBindFragDataLocation_native_GLuint_GLuint_const_GLchar_ptr(long __this__nativeId, int program, int color, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBindFragDataLocationIndexed(GLuint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>const GLchar*)</code></p>
     * @param program
     * @param colorNumber
     * @param index
     * @param name
     */
    @QtUninvokable
    public final void glBindFragDataLocationIndexed(int program, int colorNumber, int index, java.nio.@Nullable CharBuffer name){
        glBindFragDataLocationIndexed_native_GLuint_GLuint_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, colorNumber, index, name);
    }
    
    @QtUninvokable
    private native void glBindFragDataLocationIndexed_native_GLuint_GLuint_GLuint_const_GLchar_ptr(long __this__nativeId, int program, int colorNumber, int index, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBindFramebuffer(GLenum,<wbr/>GLuint)</code></p>
     * @param target
     * @param framebuffer
     */
    @QtUninvokable
    public final void glBindFramebuffer(int target, int framebuffer){
        glBindFramebuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, framebuffer);
    }
    
    @QtUninvokable
    private native void glBindFramebuffer_native_GLenum_GLuint(long __this__nativeId, int target, int framebuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBindImageTexture(GLuint,<wbr/>GLuint,<wbr/>GLint,<wbr/>GLboolean,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     * @param unit
     * @param texture
     * @param level
     * @param layered
     * @param layer
     * @param access
     * @param format
     */
    @QtUninvokable
    public final void glBindImageTexture(int unit, int texture, int level, boolean layered, int layer, int access, int format){
        glBindImageTexture_native_GLuint_GLuint_GLint_GLboolean_GLint_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), unit, texture, level, layered, layer, access, format);
    }
    
    @QtUninvokable
    private native void glBindImageTexture_native_GLuint_GLuint_GLint_GLboolean_GLint_GLenum_GLenum(long __this__nativeId, int unit, int texture, int level, boolean layered, int layer, int access, int format);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBindProgramPipeline(GLuint)</code></p>
     * @param pipeline
     */
    @QtUninvokable
    public final void glBindProgramPipeline(int pipeline){
        glBindProgramPipeline_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), pipeline);
    }
    
    @QtUninvokable
    private native void glBindProgramPipeline_native_GLuint(long __this__nativeId, int pipeline);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBindRenderbuffer(GLenum,<wbr/>GLuint)</code></p>
     * @param target
     * @param renderbuffer
     */
    @QtUninvokable
    public final void glBindRenderbuffer(int target, int renderbuffer){
        glBindRenderbuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, renderbuffer);
    }
    
    @QtUninvokable
    private native void glBindRenderbuffer_native_GLenum_GLuint(long __this__nativeId, int target, int renderbuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBindSampler(GLuint,<wbr/>GLuint)</code></p>
     * @param unit
     * @param sampler
     */
    @QtUninvokable
    public final void glBindSampler(int unit, int sampler){
        glBindSampler_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), unit, sampler);
    }
    
    @QtUninvokable
    private native void glBindSampler_native_GLuint_GLuint(long __this__nativeId, int unit, int sampler);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBindTexture(GLenum,<wbr/>GLuint)</code></p>
     * @param target
     * @param texture
     */
    @QtUninvokable
    public final void glBindTexture(int target, int texture){
        glBindTexture_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, texture);
    }
    
    @QtUninvokable
    private native void glBindTexture_native_GLenum_GLuint(long __this__nativeId, int target, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBindTransformFeedback(GLenum,<wbr/>GLuint)</code></p>
     * @param target
     * @param id
     */
    @QtUninvokable
    public final void glBindTransformFeedback(int target, int id){
        glBindTransformFeedback_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, id);
    }
    
    @QtUninvokable
    private native void glBindTransformFeedback_native_GLenum_GLuint(long __this__nativeId, int target, int id);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBindVertexArray(GLuint)</code></p>
     * @param array
     */
    @QtUninvokable
    public final void glBindVertexArray(int array){
        glBindVertexArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), array);
    }
    
    @QtUninvokable
    private native void glBindVertexArray_native_GLuint(long __this__nativeId, int array);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBindVertexBuffer(GLuint,<wbr/>GLuint,<wbr/>GLintptr,<wbr/>GLsizei)</code></p>
     * @param bindingindex
     * @param buffer
     * @param offset
     * @param stride
     */
    @QtUninvokable
    public final void glBindVertexBuffer(int bindingindex, int buffer, long offset, int stride){
        glBindVertexBuffer_native_GLuint_GLuint_GLintptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), bindingindex, buffer, offset, stride);
    }
    
    @QtUninvokable
    private native void glBindVertexBuffer_native_GLuint_GLuint_GLintptr_GLsizei(long __this__nativeId, int bindingindex, int buffer, long offset, int stride);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBlendColor(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param red
     * @param green
     * @param blue
     * @param alpha
     */
    @QtUninvokable
    public final void glBlendColor(float red, float green, float blue, float alpha){
        glBlendColor_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glBlendColor_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBlendEquation(GLenum)</code></p>
     * @param mode
     */
    @QtUninvokable
    public final void glBlendEquation(int mode){
        glBlendEquation_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glBlendEquation_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBlendEquationSeparate(GLenum,<wbr/>GLenum)</code></p>
     * @param modeRGB
     * @param modeAlpha
     */
    @QtUninvokable
    public final void glBlendEquationSeparate(int modeRGB, int modeAlpha){
        glBlendEquationSeparate_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), modeRGB, modeAlpha);
    }
    
    @QtUninvokable
    private native void glBlendEquationSeparate_native_GLenum_GLenum(long __this__nativeId, int modeRGB, int modeAlpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBlendEquationSeparatei(GLuint,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     * @param buf
     * @param modeRGB
     * @param modeAlpha
     */
    @QtUninvokable
    public final void glBlendEquationSeparatei(int buf, int modeRGB, int modeAlpha){
        glBlendEquationSeparatei_native_GLuint_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), buf, modeRGB, modeAlpha);
    }
    
    @QtUninvokable
    private native void glBlendEquationSeparatei_native_GLuint_GLenum_GLenum(long __this__nativeId, int buf, int modeRGB, int modeAlpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBlendEquationi(GLuint,<wbr/>GLenum)</code></p>
     * @param buf
     * @param mode
     */
    @QtUninvokable
    public final void glBlendEquationi(int buf, int mode){
        glBlendEquationi_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), buf, mode);
    }
    
    @QtUninvokable
    private native void glBlendEquationi_native_GLuint_GLenum(long __this__nativeId, int buf, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBlendFunc(GLenum,<wbr/>GLenum)</code></p>
     * @param sfactor
     * @param dfactor
     */
    @QtUninvokable
    public final void glBlendFunc(int sfactor, int dfactor){
        glBlendFunc_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), sfactor, dfactor);
    }
    
    @QtUninvokable
    private native void glBlendFunc_native_GLenum_GLenum(long __this__nativeId, int sfactor, int dfactor);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBlendFuncSeparate(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     * @param sfactorRGB
     * @param dfactorRGB
     * @param sfactorAlpha
     * @param dfactorAlpha
     */
    @QtUninvokable
    public final void glBlendFuncSeparate(int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha){
        glBlendFuncSeparate_native_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
    }
    
    @QtUninvokable
    private native void glBlendFuncSeparate_native_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBlendFuncSeparatei(GLuint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     * @param buf
     * @param srcRGB
     * @param dstRGB
     * @param srcAlpha
     * @param dstAlpha
     */
    @QtUninvokable
    public final void glBlendFuncSeparatei(int buf, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha){
        glBlendFuncSeparatei_native_GLuint_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
    }
    
    @QtUninvokable
    private native void glBlendFuncSeparatei_native_GLuint_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int buf, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBlendFunci(GLuint,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     * @param buf
     * @param src
     * @param dst
     */
    @QtUninvokable
    public final void glBlendFunci(int buf, int src, int dst){
        glBlendFunci_native_GLuint_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), buf, src, dst);
    }
    
    @QtUninvokable
    private native void glBlendFunci_native_GLuint_GLenum_GLenum(long __this__nativeId, int buf, int src, int dst);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBlitFramebuffer(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLbitfield,<wbr/>GLenum)</code></p>
     * @param srcX0
     * @param srcY0
     * @param srcX1
     * @param srcY1
     * @param dstX0
     * @param dstY0
     * @param dstX1
     * @param dstY1
     * @param mask
     * @param filter
     */
    @QtUninvokable
    public final void glBlitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter){
        glBlitFramebuffer_native_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLbitfield_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    }
    
    @QtUninvokable
    private native void glBlitFramebuffer_native_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLbitfield_GLenum(long __this__nativeId, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBufferData(GLenum,<wbr/>GLsizeiptr,<wbr/>const GLvoid*,<wbr/>GLenum)</code></p>
     * @param target
     * @param size
     * @param data
     * @param usage
     */
    @QtUninvokable
    public final void glBufferData(int target, long size, java.nio.@Nullable Buffer data, int usage){
        glBufferData_native_GLenum_GLsizeiptr_const_GLvoid_ptr_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, size, data, usage);
    }
    
    @QtUninvokable
    private native void glBufferData_native_GLenum_GLsizeiptr_const_GLvoid_ptr_GLenum(long __this__nativeId, int target, long size, java.nio.Buffer data, int usage);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glBufferSubData(GLenum,<wbr/>GLintptr,<wbr/>GLsizeiptr,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param offset
     * @param size
     * @param data
     */
    @QtUninvokable
    public final void glBufferSubData(int target, long offset, long size, java.nio.@Nullable Buffer data){
        glBufferSubData_native_GLenum_GLintptr_GLsizeiptr_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, size, data);
    }
    
    @QtUninvokable
    private native void glBufferSubData_native_GLenum_GLintptr_GLsizeiptr_const_GLvoid_ptr(long __this__nativeId, int target, long offset, long size, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glCheckFramebufferStatus(GLenum)</code></p>
     * @param target
     * @return
     */
    @QtUninvokable
    public final int glCheckFramebufferStatus(int target){
        return glCheckFramebufferStatus_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native int glCheckFramebufferStatus_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glClampColor(GLenum,<wbr/>GLenum)</code></p>
     * @param target
     * @param clamp
     */
    @QtUninvokable
    public final void glClampColor(int target, int clamp){
        glClampColor_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, clamp);
    }
    
    @QtUninvokable
    private native void glClampColor_native_GLenum_GLenum(long __this__nativeId, int target, int clamp);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glClear(GLbitfield)</code></p>
     * @param mask
     */
    @QtUninvokable
    public final void glClear(int mask){
        glClear_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glClear_native_GLbitfield(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glClearBufferData(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     * @param target
     * @param internalformat
     * @param format
     * @param type
     * @param data
     */
    @QtUninvokable
    public final void glClearBufferData(int target, int internalformat, int format, int type, java.nio.@Nullable Buffer data){
        glClearBufferData_native_GLenum_GLenum_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, format, type, data);
    }
    
    @QtUninvokable
    private native void glClearBufferData_native_GLenum_GLenum_GLenum_GLenum_const_void_ptr(long __this__nativeId, int target, int internalformat, int format, int type, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glClearBufferSubData(GLenum,<wbr/>GLenum,<wbr/>GLintptr,<wbr/>GLsizeiptr,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     * @param target
     * @param internalformat
     * @param offset
     * @param size
     * @param format
     * @param type
     * @param data
     */
    @QtUninvokable
    public final void glClearBufferSubData(int target, int internalformat, long offset, long size, int format, int type, java.nio.@Nullable Buffer data){
        glClearBufferSubData_native_GLenum_GLenum_GLintptr_GLsizeiptr_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, offset, size, format, type, data);
    }
    
    @QtUninvokable
    private native void glClearBufferSubData_native_GLenum_GLenum_GLintptr_GLsizeiptr_GLenum_GLenum_const_void_ptr(long __this__nativeId, int target, int internalformat, long offset, long size, int format, int type, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glClearBufferfi(GLenum,<wbr/>GLint,<wbr/>GLfloat,<wbr/>GLint)</code></p>
     * @param buffer
     * @param drawbuffer
     * @param depth
     * @param stencil
     */
    @QtUninvokable
    public final void glClearBufferfi(int buffer, int drawbuffer, float depth, int stencil){
        glClearBufferfi_native_GLenum_GLint_GLfloat_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, depth, stencil);
    }
    
    @QtUninvokable
    private native void glClearBufferfi_native_GLenum_GLint_GLfloat_GLint(long __this__nativeId, int buffer, int drawbuffer, float depth, int stencil);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glClearBufferfv(GLenum,<wbr/>GLint,<wbr/>const GLfloat*)</code></p>
     * @param buffer
     * @param drawbuffer
     * @param value
     */
    @QtUninvokable
    public final void glClearBufferfv(int buffer, int drawbuffer, java.nio.@Nullable FloatBuffer value){
        glClearBufferfv_native_GLenum_GLint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, value);
    }
    
    @QtUninvokable
    private native void glClearBufferfv_native_GLenum_GLint_const_GLfloat_ptr(long __this__nativeId, int buffer, int drawbuffer, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glClearBufferiv(GLenum,<wbr/>GLint,<wbr/>const GLint*)</code></p>
     * @param buffer
     * @param drawbuffer
     * @param value
     */
    @QtUninvokable
    public final void glClearBufferiv(int buffer, int drawbuffer, java.nio.@Nullable IntBuffer value){
        glClearBufferiv_native_GLenum_GLint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, value);
    }
    
    @QtUninvokable
    private native void glClearBufferiv_native_GLenum_GLint_const_GLint_ptr(long __this__nativeId, int buffer, int drawbuffer, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glClearBufferuiv(GLenum,<wbr/>GLint,<wbr/>const GLuint*)</code></p>
     * @param buffer
     * @param drawbuffer
     * @param value
     */
    @QtUninvokable
    public final void glClearBufferuiv(int buffer, int drawbuffer, java.nio.@Nullable IntBuffer value){
        glClearBufferuiv_native_GLenum_GLint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, value);
    }
    
    @QtUninvokable
    private native void glClearBufferuiv_native_GLenum_GLint_const_GLuint_ptr(long __this__nativeId, int buffer, int drawbuffer, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glClearColor(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param red
     * @param green
     * @param blue
     * @param alpha
     */
    @QtUninvokable
    public final void glClearColor(float red, float green, float blue, float alpha){
        glClearColor_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glClearColor_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glClearDepth(GLdouble)</code></p>
     * @param depth
     */
    @QtUninvokable
    public final void glClearDepth(double depth){
        glClearDepth_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), depth);
    }
    
    @QtUninvokable
    private native void glClearDepth_native_GLdouble(long __this__nativeId, double depth);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glClearDepthf(GLfloat)</code></p>
     * @param dd
     */
    @QtUninvokable
    public final void glClearDepthf(float dd){
        glClearDepthf_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), dd);
    }
    
    @QtUninvokable
    private native void glClearDepthf_native_GLfloat(long __this__nativeId, float dd);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glClearStencil(GLint)</code></p>
     * @param s
     */
    @QtUninvokable
    public final void glClearStencil(int s){
        glClearStencil_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glClearStencil_native_GLint(long __this__nativeId, int s);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glClientWaitSync(GLsync,<wbr/>GLbitfield,<wbr/>GLuint64)</code></p>
     * @param sync
     * @param flags
     * @param timeout
     * @return
     */
    @QtUninvokable
    public final int glClientWaitSync(io.qt.gui.gl.@Nullable GLsync sync, int flags, long timeout){
        return glClientWaitSync_native___GLsync_ptr_GLbitfield_GLuint64(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync), flags, timeout);
    }
    
    @QtUninvokable
    private native int glClientWaitSync_native___GLsync_ptr_GLbitfield_GLuint64(long __this__nativeId, long sync, int flags, long timeout);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glColorMask(GLboolean,<wbr/>GLboolean,<wbr/>GLboolean,<wbr/>GLboolean)</code></p>
     * @param red
     * @param green
     * @param blue
     * @param alpha
     */
    @QtUninvokable
    public final void glColorMask(boolean red, boolean green, boolean blue, boolean alpha){
        glColorMask_native_GLboolean_GLboolean_GLboolean_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColorMask_native_GLboolean_GLboolean_GLboolean_GLboolean(long __this__nativeId, boolean red, boolean green, boolean blue, boolean alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glColorMaski(GLuint,<wbr/>GLboolean,<wbr/>GLboolean,<wbr/>GLboolean,<wbr/>GLboolean)</code></p>
     * @param index
     * @param r
     * @param g
     * @param b
     * @param a
     */
    @QtUninvokable
    public final void glColorMaski(int index, boolean r, boolean g, boolean b, boolean a){
        glColorMaski_native_GLuint_GLboolean_GLboolean_GLboolean_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), index, r, g, b, a);
    }
    
    @QtUninvokable
    private native void glColorMaski_native_GLuint_GLboolean_GLboolean_GLboolean_GLboolean(long __this__nativeId, int index, boolean r, boolean g, boolean b, boolean a);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glCompileShader(GLuint)</code></p>
     * @param shader
     */
    @QtUninvokable
    public final void glCompileShader(int shader){
        glCompileShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @QtUninvokable
    private native void glCompileShader_native_GLuint(long __this__nativeId, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glCompressedTexImage1D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param internalformat
     * @param width
     * @param border
     * @param imageSize
     * @param data
     */
    @QtUninvokable
    public final void glCompressedTexImage1D(int target, int level, int internalformat, int width, int border, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexImage1D_native_GLenum_GLint_GLenum_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, border, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexImage1D_native_GLenum_GLint_GLenum_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int border, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glCompressedTexImage2D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param internalformat
     * @param width
     * @param height
     * @param border
     * @param imageSize
     * @param data
     */
    @QtUninvokable
    public final void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexImage2D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, border, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexImage2D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int border, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glCompressedTexImage3D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param internalformat
     * @param width
     * @param height
     * @param depth
     * @param border
     * @param imageSize
     * @param data
     */
    @QtUninvokable
    public final void glCompressedTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexImage3D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, depth, border, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexImage3D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glCompressedTexSubImage1D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param xoffset
     * @param width
     * @param format
     * @param imageSize
     * @param data
     */
    @QtUninvokable
    public final void glCompressedTexSubImage1D(int target, int level, int xoffset, int width, int format, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, width, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int width, int format, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glCompressedTexSubImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param xoffset
     * @param yoffset
     * @param width
     * @param height
     * @param format
     * @param imageSize
     * @param data
     */
    @QtUninvokable
    public final void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, width, height, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glCompressedTexSubImage3D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param xoffset
     * @param yoffset
     * @param zoffset
     * @param width
     * @param height
     * @param depth
     * @param format
     * @param imageSize
     * @param data
     */
    @QtUninvokable
    public final void glCompressedTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glCopyBufferSubData(GLenum,<wbr/>GLenum,<wbr/>GLintptr,<wbr/>GLintptr,<wbr/>GLsizeiptr)</code></p>
     * @param readTarget
     * @param writeTarget
     * @param readOffset
     * @param writeOffset
     * @param size
     */
    @QtUninvokable
    public final void glCopyBufferSubData(int readTarget, int writeTarget, long readOffset, long writeOffset, long size){
        glCopyBufferSubData_native_GLenum_GLenum_GLintptr_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), readTarget, writeTarget, readOffset, writeOffset, size);
    }
    
    @QtUninvokable
    private native void glCopyBufferSubData_native_GLenum_GLenum_GLintptr_GLintptr_GLsizeiptr(long __this__nativeId, int readTarget, int writeTarget, long readOffset, long writeOffset, long size);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glCopyImageSubData(GLuint,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLuint,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param srcName
     * @param srcTarget
     * @param srcLevel
     * @param srcX
     * @param srcY
     * @param srcZ
     * @param dstName
     * @param dstTarget
     * @param dstLevel
     * @param dstX
     * @param dstY
     * @param dstZ
     * @param srcWidth
     * @param srcHeight
     * @param srcDepth
     */
    @QtUninvokable
    public final void glCopyImageSubData(int srcName, int srcTarget, int srcLevel, int srcX, int srcY, int srcZ, int dstName, int dstTarget, int dstLevel, int dstX, int dstY, int dstZ, int srcWidth, int srcHeight, int srcDepth){
        glCopyImageSubData_native_GLuint_GLenum_GLint_GLint_GLint_GLint_GLuint_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth);
    }
    
    @QtUninvokable
    private native void glCopyImageSubData_native_GLuint_GLenum_GLint_GLint_GLint_GLint_GLuint_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei(long __this__nativeId, int srcName, int srcTarget, int srcLevel, int srcX, int srcY, int srcZ, int dstName, int dstTarget, int dstLevel, int dstX, int dstY, int dstZ, int srcWidth, int srcHeight, int srcDepth);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glCopyTexImage1D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLint)</code></p>
     * @param target
     * @param level
     * @param internalformat
     * @param x
     * @param y
     * @param width
     * @param border
     */
    @QtUninvokable
    public final void glCopyTexImage1D(int target, int level, int internalformat, int x, int y, int width, int border){
        glCopyTexImage1D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, x, y, width, border);
    }
    
    @QtUninvokable
    private native void glCopyTexImage1D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLint(long __this__nativeId, int target, int level, int internalformat, int x, int y, int width, int border);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glCopyTexImage2D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint)</code></p>
     * @param target
     * @param level
     * @param internalformat
     * @param x
     * @param y
     * @param width
     * @param height
     * @param border
     */
    @QtUninvokable
    public final void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border){
        glCopyTexImage2D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, x, y, width, height, border);
    }
    
    @QtUninvokable
    private native void glCopyTexImage2D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLsizei_GLint(long __this__nativeId, int target, int level, int internalformat, int x, int y, int width, int height, int border);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glCopyTexSubImage1D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei)</code></p>
     * @param target
     * @param level
     * @param xoffset
     * @param x
     * @param y
     * @param width
     */
    @QtUninvokable
    public final void glCopyTexSubImage1D(int target, int level, int xoffset, int x, int y, int width){
        glCopyTexSubImage1D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, x, y, width);
    }
    
    @QtUninvokable
    private native void glCopyTexSubImage1D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei(long __this__nativeId, int target, int level, int xoffset, int x, int y, int width);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glCopyTexSubImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param target
     * @param level
     * @param xoffset
     * @param yoffset
     * @param x
     * @param y
     * @param width
     * @param height
     */
    @QtUninvokable
    public final void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height){
        glCopyTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glCopyTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int level, int xoffset, int yoffset, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glCopyTexSubImage3D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param target
     * @param level
     * @param xoffset
     * @param yoffset
     * @param zoffset
     * @param x
     * @param y
     * @param width
     * @param height
     */
    @QtUninvokable
    public final void glCopyTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height){
        glCopyTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glCopyTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glCreateProgram()</code></p>
     * @return
     */
    @QtUninvokable
    public final int glCreateProgram(){
        return glCreateProgram_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int glCreateProgram_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glCreateShader(GLenum)</code></p>
     * @param type
     * @return
     */
    @QtUninvokable
    public final int glCreateShader(int type){
        return glCreateShader_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), type);
    }
    
    @QtUninvokable
    private native int glCreateShader_native_GLenum(long __this__nativeId, int type);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glCreateShaderProgramv(GLenum,<wbr/>GLsizei,<wbr/>const GLchar*const*)</code></p>
     * @param type
     * @param strings
     * @return
     */
    @QtUninvokable
    public final int glCreateShaderProgramv(int type, java.lang.String[] strings){
        return glCreateShaderProgramv_native_GLenum_GLsizei_const_GLchar_cptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, strings);
    }
    
    @QtUninvokable
    private native int glCreateShaderProgramv_native_GLenum_GLsizei_const_GLchar_cptr_ptr(long __this__nativeId, int type, java.lang.String[] strings);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glCullFace(GLenum)</code></p>
     * @param mode
     */
    @QtUninvokable
    public final void glCullFace(int mode){
        glCullFace_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glCullFace_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDeleteBuffers(GLsizei,<wbr/>const GLuint*)</code></p>
     * @param n
     * @param buffers
     */
    @QtUninvokable
    public final void glDeleteBuffers(int n, java.nio.@Nullable IntBuffer buffers){
        glDeleteBuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, buffers);
    }
    
    @QtUninvokable
    private native void glDeleteBuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer buffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDeleteFramebuffers(GLsizei,<wbr/>const GLuint*)</code></p>
     * @param n
     * @param framebuffers
     */
    @QtUninvokable
    public final void glDeleteFramebuffers(int n, java.nio.@Nullable IntBuffer framebuffers){
        glDeleteFramebuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, framebuffers);
    }
    
    @QtUninvokable
    private native void glDeleteFramebuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer framebuffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDeleteProgram(GLuint)</code></p>
     * @param program
     */
    @QtUninvokable
    public final void glDeleteProgram(int program){
        glDeleteProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glDeleteProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDeleteProgramPipelines(GLsizei,<wbr/>const GLuint*)</code></p>
     * @param n
     * @param pipelines
     */
    @QtUninvokable
    public final void glDeleteProgramPipelines(int n, java.nio.@Nullable IntBuffer pipelines){
        glDeleteProgramPipelines_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, pipelines);
    }
    
    @QtUninvokable
    private native void glDeleteProgramPipelines_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer pipelines);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDeleteQueries(GLsizei,<wbr/>const GLuint*)</code></p>
     * @param n
     * @param ids
     */
    @QtUninvokable
    public final void glDeleteQueries(int n, java.nio.@Nullable IntBuffer ids){
        glDeleteQueries_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @QtUninvokable
    private native void glDeleteQueries_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDeleteRenderbuffers(GLsizei,<wbr/>const GLuint*)</code></p>
     * @param n
     * @param renderbuffers
     */
    @QtUninvokable
    public final void glDeleteRenderbuffers(int n, java.nio.@Nullable IntBuffer renderbuffers){
        glDeleteRenderbuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, renderbuffers);
    }
    
    @QtUninvokable
    private native void glDeleteRenderbuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer renderbuffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDeleteSamplers(GLsizei,<wbr/>const GLuint*)</code></p>
     * @param count
     * @param samplers
     */
    @QtUninvokable
    public final void glDeleteSamplers(int count, java.nio.@Nullable IntBuffer samplers){
        glDeleteSamplers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), count, samplers);
    }
    
    @QtUninvokable
    private native void glDeleteSamplers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int count, java.nio.IntBuffer samplers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDeleteShader(GLuint)</code></p>
     * @param shader
     */
    @QtUninvokable
    public final void glDeleteShader(int shader){
        glDeleteShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @QtUninvokable
    private native void glDeleteShader_native_GLuint(long __this__nativeId, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDeleteSync(GLsync)</code></p>
     * @param sync
     */
    @QtUninvokable
    public final void glDeleteSync(io.qt.gui.gl.@Nullable GLsync sync){
        glDeleteSync_native___GLsync_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync));
    }
    
    @QtUninvokable
    private native void glDeleteSync_native___GLsync_ptr(long __this__nativeId, long sync);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDeleteTextures(GLsizei,<wbr/>const GLuint*)</code></p>
     * @param n
     * @param textures
     */
    @QtUninvokable
    public final void glDeleteTextures(int n, java.nio.@Nullable IntBuffer textures){
        glDeleteTextures_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures);
    }
    
    @QtUninvokable
    private native void glDeleteTextures_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDeleteTransformFeedbacks(GLsizei,<wbr/>const GLuint*)</code></p>
     * @param n
     * @param ids
     */
    @QtUninvokable
    public final void glDeleteTransformFeedbacks(int n, java.nio.@Nullable IntBuffer ids){
        glDeleteTransformFeedbacks_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @QtUninvokable
    private native void glDeleteTransformFeedbacks_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDeleteVertexArrays(GLsizei,<wbr/>const GLuint*)</code></p>
     * @param n
     * @param arrays
     */
    @QtUninvokable
    public final void glDeleteVertexArrays(int n, java.nio.@Nullable IntBuffer arrays){
        glDeleteVertexArrays_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, arrays);
    }
    
    @QtUninvokable
    private native void glDeleteVertexArrays_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer arrays);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDepthFunc(GLenum)</code></p>
     * @param func
     */
    @QtUninvokable
    public final void glDepthFunc(int func){
        glDepthFunc_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), func);
    }
    
    @QtUninvokable
    private native void glDepthFunc_native_GLenum(long __this__nativeId, int func);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDepthMask(GLboolean)</code></p>
     * @param flag
     */
    @QtUninvokable
    public final void glDepthMask(boolean flag){
        glDepthMask_native_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), flag);
    }
    
    @QtUninvokable
    private native void glDepthMask_native_GLboolean(long __this__nativeId, boolean flag);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDepthRange(GLdouble,<wbr/>GLdouble)</code></p>
     * @param nearVal
     * @param farVal
     */
    @QtUninvokable
    public final void glDepthRange(double nearVal, double farVal){
        glDepthRange_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), nearVal, farVal);
    }
    
    @QtUninvokable
    private native void glDepthRange_native_GLdouble_GLdouble(long __this__nativeId, double nearVal, double farVal);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDepthRangeArrayv(GLuint,<wbr/>GLsizei,<wbr/>const GLdouble*)</code></p>
     * @param first
     * @param count
     * @param v
     */
    @QtUninvokable
    public final void glDepthRangeArrayv(int first, int count, java.nio.@Nullable DoubleBuffer v){
        glDepthRangeArrayv_native_GLuint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), first, count, v);
    }
    
    @QtUninvokable
    private native void glDepthRangeArrayv_native_GLuint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int first, int count, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDepthRangeIndexed(GLuint,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param index
     * @param n
     * @param f
     */
    @QtUninvokable
    public final void glDepthRangeIndexed(int index, double n, double f){
        glDepthRangeIndexed_native_GLuint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, n, f);
    }
    
    @QtUninvokable
    private native void glDepthRangeIndexed_native_GLuint_GLdouble_GLdouble(long __this__nativeId, int index, double n, double f);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDepthRangef(GLfloat,<wbr/>GLfloat)</code></p>
     * @param n
     * @param f
     */
    @QtUninvokable
    public final void glDepthRangef(float n, float f){
        glDepthRangef_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), n, f);
    }
    
    @QtUninvokable
    private native void glDepthRangef_native_GLfloat_GLfloat(long __this__nativeId, float n, float f);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDetachShader(GLuint,<wbr/>GLuint)</code></p>
     * @param program
     * @param shader
     */
    @QtUninvokable
    public final void glDetachShader(int program, int shader){
        glDetachShader_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, shader);
    }
    
    @QtUninvokable
    private native void glDetachShader_native_GLuint_GLuint(long __this__nativeId, int program, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDisable(GLenum)</code></p>
     * @param cap
     */
    @QtUninvokable
    public final void glDisable(int cap){
        glDisable_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native void glDisable_native_GLenum(long __this__nativeId, int cap);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDisableVertexAttribArray(GLuint)</code></p>
     * @param index
     */
    @QtUninvokable
    public final void glDisableVertexAttribArray(int index){
        glDisableVertexAttribArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void glDisableVertexAttribArray_native_GLuint(long __this__nativeId, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDisablei(GLenum,<wbr/>GLuint)</code></p>
     * @param target
     * @param index
     */
    @QtUninvokable
    public final void glDisablei(int target, int index){
        glDisablei_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index);
    }
    
    @QtUninvokable
    private native void glDisablei_native_GLenum_GLuint(long __this__nativeId, int target, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDispatchCompute(GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     * @param num_groups_x
     * @param num_groups_y
     * @param num_groups_z
     */
    @QtUninvokable
    public final void glDispatchCompute(int num_groups_x, int num_groups_y, int num_groups_z){
        glDispatchCompute_native_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), num_groups_x, num_groups_y, num_groups_z);
    }
    
    @QtUninvokable
    private native void glDispatchCompute_native_GLuint_GLuint_GLuint(long __this__nativeId, int num_groups_x, int num_groups_y, int num_groups_z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDispatchComputeIndirect(GLintptr)</code></p>
     * @param indirect
     */
    @QtUninvokable
    public final void glDispatchComputeIndirect(long indirect){
        glDispatchComputeIndirect_native_GLintptr(QtJambi_LibraryUtilities.internal.nativeId(this), indirect);
    }
    
    @QtUninvokable
    private native void glDispatchComputeIndirect_native_GLintptr(long __this__nativeId, long indirect);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDrawArrays(GLenum,<wbr/>GLint,<wbr/>GLsizei)</code></p>
     * @param mode
     * @param first
     * @param count
     */
    @QtUninvokable
    public final void glDrawArrays(int mode, int first, int count){
        glDrawArrays_native_GLenum_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count);
    }
    
    @QtUninvokable
    private native void glDrawArrays_native_GLenum_GLint_GLsizei(long __this__nativeId, int mode, int first, int count);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDrawArraysIndirect(GLenum,<wbr/>const GLvoid*)</code></p>
     * @param mode
     * @param indirect
     */
    @QtUninvokable
    public final void glDrawArraysIndirect(int mode, java.nio.@Nullable Buffer indirect){
        glDrawArraysIndirect_native_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, indirect);
    }
    
    @QtUninvokable
    private native void glDrawArraysIndirect_native_GLenum_const_GLvoid_ptr(long __this__nativeId, int mode, java.nio.Buffer indirect);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDrawArraysInstanced(GLenum,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param mode
     * @param first
     * @param count
     * @param instancecount
     */
    @QtUninvokable
    public final void glDrawArraysInstanced(int mode, int first, int count, int instancecount){
        glDrawArraysInstanced_native_GLenum_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count, instancecount);
    }
    
    @QtUninvokable
    private native void glDrawArraysInstanced_native_GLenum_GLint_GLsizei_GLsizei(long __this__nativeId, int mode, int first, int count, int instancecount);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDrawArraysInstancedBaseInstance(GLenum,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLuint)</code></p>
     * @param mode
     * @param first
     * @param count
     * @param instancecount
     * @param baseinstance
     */
    @QtUninvokable
    public final void glDrawArraysInstancedBaseInstance(int mode, int first, int count, int instancecount, int baseinstance){
        glDrawArraysInstancedBaseInstance_native_GLenum_GLint_GLsizei_GLsizei_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count, instancecount, baseinstance);
    }
    
    @QtUninvokable
    private native void glDrawArraysInstancedBaseInstance_native_GLenum_GLint_GLsizei_GLsizei_GLuint(long __this__nativeId, int mode, int first, int count, int instancecount, int baseinstance);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDrawBuffer(GLenum)</code></p>
     * @param mode
     */
    @QtUninvokable
    public final void glDrawBuffer(int mode){
        glDrawBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glDrawBuffer_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDrawBuffers(GLsizei,<wbr/>const GLenum*)</code></p>
     * @param n
     * @param bufs
     */
    @QtUninvokable
    public final void glDrawBuffers(int n, java.nio.@Nullable IntBuffer bufs){
        glDrawBuffers_native_GLsizei_const_GLenum_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, bufs);
    }
    
    @QtUninvokable
    private native void glDrawBuffers_native_GLsizei_const_GLenum_ptr(long __this__nativeId, int n, java.nio.IntBuffer bufs);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDrawElements(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param mode
     * @param count
     * @param type
     * @param indices
     */
    @QtUninvokable
    public final void glDrawElements(int mode, int count, int type, java.nio.@Nullable Buffer indices){
        glDrawElements_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices);
    }
    
    @QtUninvokable
    private native void glDrawElements_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDrawElementsBaseVertex(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const GLvoid*,<wbr/>GLint)</code></p>
     * @param mode
     * @param count
     * @param type
     * @param indices
     * @param basevertex
     */
    @QtUninvokable
    public final void glDrawElementsBaseVertex(int mode, int count, int type, java.nio.@Nullable Buffer indices, int basevertex){
        glDrawElementsBaseVertex_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, basevertex);
    }
    
    @QtUninvokable
    private native void glDrawElementsBaseVertex_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr_GLint(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices, int basevertex);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDrawElementsIndirect(GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param mode
     * @param type
     * @param indirect
     */
    @QtUninvokable
    public final void glDrawElementsIndirect(int mode, int type, java.nio.@Nullable Buffer indirect){
        glDrawElementsIndirect_native_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, type, indirect);
    }
    
    @QtUninvokable
    private native void glDrawElementsIndirect_native_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int mode, int type, java.nio.Buffer indirect);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDrawElementsInstanced(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const GLvoid*,<wbr/>GLsizei)</code></p>
     * @param mode
     * @param count
     * @param type
     * @param indices
     * @param instancecount
     */
    @QtUninvokable
    public final void glDrawElementsInstanced(int mode, int count, int type, java.nio.@Nullable Buffer indices, int instancecount){
        glDrawElementsInstanced_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, instancecount);
    }
    
    @QtUninvokable
    private native void glDrawElementsInstanced_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr_GLsizei(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices, int instancecount);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDrawElementsInstancedBaseInstance(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const void*,<wbr/>GLsizei,<wbr/>GLuint)</code></p>
     * @param mode
     * @param count
     * @param type
     * @param indices
     * @param instancecount
     * @param baseinstance
     */
    @QtUninvokable
    public final void glDrawElementsInstancedBaseInstance(int mode, int count, int type, java.nio.@Nullable Buffer indices, int instancecount, int baseinstance){
        glDrawElementsInstancedBaseInstance_native_GLenum_GLsizei_GLenum_const_void_ptr_GLsizei_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, instancecount, baseinstance);
    }
    
    @QtUninvokable
    private native void glDrawElementsInstancedBaseInstance_native_GLenum_GLsizei_GLenum_const_void_ptr_GLsizei_GLuint(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices, int instancecount, int baseinstance);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDrawElementsInstancedBaseVertex(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const GLvoid*,<wbr/>GLsizei,<wbr/>GLint)</code></p>
     * @param mode
     * @param count
     * @param type
     * @param indices
     * @param instancecount
     * @param basevertex
     */
    @QtUninvokable
    public final void glDrawElementsInstancedBaseVertex(int mode, int count, int type, java.nio.@Nullable Buffer indices, int instancecount, int basevertex){
        glDrawElementsInstancedBaseVertex_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, instancecount, basevertex);
    }
    
    @QtUninvokable
    private native void glDrawElementsInstancedBaseVertex_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr_GLsizei_GLint(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices, int instancecount, int basevertex);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDrawElementsInstancedBaseVertexBaseInstance(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const void*,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLuint)</code></p>
     * @param mode
     * @param count
     * @param type
     * @param indices
     * @param instancecount
     * @param basevertex
     * @param baseinstance
     */
    @QtUninvokable
    public final void glDrawElementsInstancedBaseVertexBaseInstance(int mode, int count, int type, java.nio.@Nullable Buffer indices, int instancecount, int basevertex, int baseinstance){
        glDrawElementsInstancedBaseVertexBaseInstance_native_GLenum_GLsizei_GLenum_const_void_ptr_GLsizei_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, instancecount, basevertex, baseinstance);
    }
    
    @QtUninvokable
    private native void glDrawElementsInstancedBaseVertexBaseInstance_native_GLenum_GLsizei_GLenum_const_void_ptr_GLsizei_GLint_GLuint(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices, int instancecount, int basevertex, int baseinstance);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDrawRangeElements(GLenum,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param mode
     * @param start
     * @param end
     * @param count
     * @param type
     * @param indices
     */
    @QtUninvokable
    public final void glDrawRangeElements(int mode, int start, int end, int count, int type, java.nio.@Nullable Buffer indices){
        glDrawRangeElements_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, start, end, count, type, indices);
    }
    
    @QtUninvokable
    private native void glDrawRangeElements_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_GLvoid_ptr(long __this__nativeId, int mode, int start, int end, int count, int type, java.nio.Buffer indices);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDrawRangeElementsBaseVertex(GLenum,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const GLvoid*,<wbr/>GLint)</code></p>
     * @param mode
     * @param start
     * @param end
     * @param count
     * @param type
     * @param indices
     * @param basevertex
     */
    @QtUninvokable
    public final void glDrawRangeElementsBaseVertex(int mode, int start, int end, int count, int type, java.nio.@Nullable Buffer indices, int basevertex){
        glDrawRangeElementsBaseVertex_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_GLvoid_ptr_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, start, end, count, type, indices, basevertex);
    }
    
    @QtUninvokable
    private native void glDrawRangeElementsBaseVertex_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_GLvoid_ptr_GLint(long __this__nativeId, int mode, int start, int end, int count, int type, java.nio.Buffer indices, int basevertex);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDrawTransformFeedback(GLenum,<wbr/>GLuint)</code></p>
     * @param mode
     * @param id
     */
    @QtUninvokable
    public final void glDrawTransformFeedback(int mode, int id){
        glDrawTransformFeedback_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, id);
    }
    
    @QtUninvokable
    private native void glDrawTransformFeedback_native_GLenum_GLuint(long __this__nativeId, int mode, int id);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDrawTransformFeedbackInstanced(GLenum,<wbr/>GLuint,<wbr/>GLsizei)</code></p>
     * @param mode
     * @param id
     * @param instancecount
     */
    @QtUninvokable
    public final void glDrawTransformFeedbackInstanced(int mode, int id, int instancecount){
        glDrawTransformFeedbackInstanced_native_GLenum_GLuint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, id, instancecount);
    }
    
    @QtUninvokable
    private native void glDrawTransformFeedbackInstanced_native_GLenum_GLuint_GLsizei(long __this__nativeId, int mode, int id, int instancecount);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDrawTransformFeedbackStream(GLenum,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     * @param mode
     * @param id
     * @param stream
     */
    @QtUninvokable
    public final void glDrawTransformFeedbackStream(int mode, int id, int stream){
        glDrawTransformFeedbackStream_native_GLenum_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, id, stream);
    }
    
    @QtUninvokable
    private native void glDrawTransformFeedbackStream_native_GLenum_GLuint_GLuint(long __this__nativeId, int mode, int id, int stream);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glDrawTransformFeedbackStreamInstanced(GLenum,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLsizei)</code></p>
     * @param mode
     * @param id
     * @param stream
     * @param instancecount
     */
    @QtUninvokable
    public final void glDrawTransformFeedbackStreamInstanced(int mode, int id, int stream, int instancecount){
        glDrawTransformFeedbackStreamInstanced_native_GLenum_GLuint_GLuint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, id, stream, instancecount);
    }
    
    @QtUninvokable
    private native void glDrawTransformFeedbackStreamInstanced_native_GLenum_GLuint_GLuint_GLsizei(long __this__nativeId, int mode, int id, int stream, int instancecount);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glEnable(GLenum)</code></p>
     * @param cap
     */
    @QtUninvokable
    public final void glEnable(int cap){
        glEnable_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native void glEnable_native_GLenum(long __this__nativeId, int cap);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glEnableVertexAttribArray(GLuint)</code></p>
     * @param index
     */
    @QtUninvokable
    public final void glEnableVertexAttribArray(int index){
        glEnableVertexAttribArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void glEnableVertexAttribArray_native_GLuint(long __this__nativeId, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glEnablei(GLenum,<wbr/>GLuint)</code></p>
     * @param target
     * @param index
     */
    @QtUninvokable
    public final void glEnablei(int target, int index){
        glEnablei_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index);
    }
    
    @QtUninvokable
    private native void glEnablei_native_GLenum_GLuint(long __this__nativeId, int target, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glEndConditionalRender()</code></p>
     */
    @QtUninvokable
    public final void glEndConditionalRender(){
        glEndConditionalRender_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glEndConditionalRender_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glEndQuery(GLenum)</code></p>
     * @param target
     */
    @QtUninvokable
    public final void glEndQuery(int target){
        glEndQuery_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void glEndQuery_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glEndQueryIndexed(GLenum,<wbr/>GLuint)</code></p>
     * @param target
     * @param index
     */
    @QtUninvokable
    public final void glEndQueryIndexed(int target, int index){
        glEndQueryIndexed_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index);
    }
    
    @QtUninvokable
    private native void glEndQueryIndexed_native_GLenum_GLuint(long __this__nativeId, int target, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glEndTransformFeedback()</code></p>
     */
    @QtUninvokable
    public final void glEndTransformFeedback(){
        glEndTransformFeedback_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glEndTransformFeedback_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glFenceSync(GLenum,<wbr/>GLbitfield)</code></p>
     * @param condition
     * @param flags
     * @return
     */
    @QtUninvokable
    public final io.qt.gui.gl.@Nullable GLsync glFenceSync(int condition, int flags){
        return glFenceSync_native_GLenum_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), condition, flags);
    }
    
    @QtUninvokable
    private native io.qt.gui.gl.GLsync glFenceSync_native_GLenum_GLbitfield(long __this__nativeId, int condition, int flags);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glFinish()</code></p>
     */
    @QtUninvokable
    public final void glFinish(){
        glFinish_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glFinish_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glFlush()</code></p>
     */
    @QtUninvokable
    public final void glFlush(){
        glFlush_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glFlush_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glFlushMappedBufferRange(GLenum,<wbr/>GLintptr,<wbr/>GLsizeiptr)</code></p>
     * @param target
     * @param offset
     * @param length
     */
    @QtUninvokable
    public final void glFlushMappedBufferRange(int target, long offset, long length){
        glFlushMappedBufferRange_native_GLenum_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, length);
    }
    
    @QtUninvokable
    private native void glFlushMappedBufferRange_native_GLenum_GLintptr_GLsizeiptr(long __this__nativeId, int target, long offset, long length);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glFramebufferParameteri(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     * @param target
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glFramebufferParameteri(int target, int pname, int param){
        glFramebufferParameteri_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glFramebufferParameteri_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glFramebufferRenderbuffer(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLuint)</code></p>
     * @param target
     * @param attachment
     * @param renderbuffertarget
     * @param renderbuffer
     */
    @QtUninvokable
    public final void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer){
        glFramebufferRenderbuffer_native_GLenum_GLenum_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, renderbuffertarget, renderbuffer);
    }
    
    @QtUninvokable
    private native void glFramebufferRenderbuffer_native_GLenum_GLenum_GLenum_GLuint(long __this__nativeId, int target, int attachment, int renderbuffertarget, int renderbuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glFramebufferTexture(GLenum,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLint)</code></p>
     * @param target
     * @param attachment
     * @param texture
     * @param level
     */
    @QtUninvokable
    public final void glFramebufferTexture(int target, int attachment, int texture, int level){
        glFramebufferTexture_native_GLenum_GLenum_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, texture, level);
    }
    
    @QtUninvokable
    private native void glFramebufferTexture_native_GLenum_GLenum_GLuint_GLint(long __this__nativeId, int target, int attachment, int texture, int level);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glFramebufferTexture1D(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLint)</code></p>
     * @param target
     * @param attachment
     * @param textarget
     * @param texture
     * @param level
     */
    @QtUninvokable
    public final void glFramebufferTexture1D(int target, int attachment, int textarget, int texture, int level){
        glFramebufferTexture1D_native_GLenum_GLenum_GLenum_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, textarget, texture, level);
    }
    
    @QtUninvokable
    private native void glFramebufferTexture1D_native_GLenum_GLenum_GLenum_GLuint_GLint(long __this__nativeId, int target, int attachment, int textarget, int texture, int level);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glFramebufferTexture2D(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLint)</code></p>
     * @param target
     * @param attachment
     * @param textarget
     * @param texture
     * @param level
     */
    @QtUninvokable
    public final void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level){
        glFramebufferTexture2D_native_GLenum_GLenum_GLenum_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, textarget, texture, level);
    }
    
    @QtUninvokable
    private native void glFramebufferTexture2D_native_GLenum_GLenum_GLenum_GLuint_GLint(long __this__nativeId, int target, int attachment, int textarget, int texture, int level);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glFramebufferTexture3D(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param target
     * @param attachment
     * @param textarget
     * @param texture
     * @param level
     * @param zoffset
     */
    @QtUninvokable
    public final void glFramebufferTexture3D(int target, int attachment, int textarget, int texture, int level, int zoffset){
        glFramebufferTexture3D_native_GLenum_GLenum_GLenum_GLuint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, textarget, texture, level, zoffset);
    }
    
    @QtUninvokable
    private native void glFramebufferTexture3D_native_GLenum_GLenum_GLenum_GLuint_GLint_GLint(long __this__nativeId, int target, int attachment, int textarget, int texture, int level, int zoffset);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glFramebufferTextureLayer(GLenum,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param target
     * @param attachment
     * @param texture
     * @param level
     * @param layer
     */
    @QtUninvokable
    public final void glFramebufferTextureLayer(int target, int attachment, int texture, int level, int layer){
        glFramebufferTextureLayer_native_GLenum_GLenum_GLuint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, texture, level, layer);
    }
    
    @QtUninvokable
    private native void glFramebufferTextureLayer_native_GLenum_GLenum_GLuint_GLint_GLint(long __this__nativeId, int target, int attachment, int texture, int level, int layer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glFrontFace(GLenum)</code></p>
     * @param mode
     */
    @QtUninvokable
    public final void glFrontFace(int mode){
        glFrontFace_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glFrontFace_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGenBuffers(GLsizei,<wbr/>GLuint*)</code></p>
     * @param n
     * @param buffers
     */
    @QtUninvokable
    public final void glGenBuffers(int n, java.nio.@Nullable IntBuffer buffers){
        glGenBuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, buffers);
    }
    
    @QtUninvokable
    private native void glGenBuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer buffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGenFramebuffers(GLsizei,<wbr/>GLuint*)</code></p>
     * @param n
     * @param framebuffers
     */
    @QtUninvokable
    public final void glGenFramebuffers(int n, java.nio.@Nullable IntBuffer framebuffers){
        glGenFramebuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, framebuffers);
    }
    
    @QtUninvokable
    private native void glGenFramebuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer framebuffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGenProgramPipelines(GLsizei,<wbr/>GLuint*)</code></p>
     * @param n
     * @param pipelines
     */
    @QtUninvokable
    public final void glGenProgramPipelines(int n, java.nio.@Nullable IntBuffer pipelines){
        glGenProgramPipelines_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, pipelines);
    }
    
    @QtUninvokable
    private native void glGenProgramPipelines_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer pipelines);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGenQueries(GLsizei,<wbr/>GLuint*)</code></p>
     * @param n
     * @param ids
     */
    @QtUninvokable
    public final void glGenQueries(int n, java.nio.@Nullable IntBuffer ids){
        glGenQueries_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @QtUninvokable
    private native void glGenQueries_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGenRenderbuffers(GLsizei,<wbr/>GLuint*)</code></p>
     * @param n
     * @param renderbuffers
     */
    @QtUninvokable
    public final void glGenRenderbuffers(int n, java.nio.@Nullable IntBuffer renderbuffers){
        glGenRenderbuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, renderbuffers);
    }
    
    @QtUninvokable
    private native void glGenRenderbuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer renderbuffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGenSamplers(GLsizei,<wbr/>GLuint*)</code></p>
     * @param count
     * @param samplers
     */
    @QtUninvokable
    public final void glGenSamplers(int count, java.nio.@Nullable IntBuffer samplers){
        glGenSamplers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), count, samplers);
    }
    
    @QtUninvokable
    private native void glGenSamplers_native_GLsizei_GLuint_ptr(long __this__nativeId, int count, java.nio.IntBuffer samplers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGenTextures(GLsizei,<wbr/>GLuint*)</code></p>
     * @param n
     * @param textures
     */
    @QtUninvokable
    public final void glGenTextures(int n, java.nio.@Nullable IntBuffer textures){
        glGenTextures_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures);
    }
    
    @QtUninvokable
    private native void glGenTextures_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGenTransformFeedbacks(GLsizei,<wbr/>GLuint*)</code></p>
     * @param n
     * @param ids
     */
    @QtUninvokable
    public final void glGenTransformFeedbacks(int n, java.nio.@Nullable IntBuffer ids){
        glGenTransformFeedbacks_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @QtUninvokable
    private native void glGenTransformFeedbacks_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGenVertexArrays(GLsizei,<wbr/>GLuint*)</code></p>
     * @param n
     * @param arrays
     */
    @QtUninvokable
    public final void glGenVertexArrays(int n, java.nio.@Nullable IntBuffer arrays){
        glGenVertexArrays_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, arrays);
    }
    
    @QtUninvokable
    private native void glGenVertexArrays_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer arrays);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGenerateMipmap(GLenum)</code></p>
     * @param target
     */
    @QtUninvokable
    public final void glGenerateMipmap(int target){
        glGenerateMipmap_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void glGenerateMipmap_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetActiveAtomicCounterBufferiv(GLuint,<wbr/>GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param program
     * @param bufferIndex
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetActiveAtomicCounterBufferiv(int program, int bufferIndex, int pname, java.nio.@Nullable IntBuffer params){
        glGetActiveAtomicCounterBufferiv_native_GLuint_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, bufferIndex, pname, params);
    }
    
    @QtUninvokable
    private native void glGetActiveAtomicCounterBufferiv_native_GLuint_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int bufferIndex, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetActiveAttrib(GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLint*,<wbr/>GLenum*,<wbr/>GLchar*)</code></p>
     * @param program
     * @param index
     * @param bufSize
     * @param length
     * @param size
     * @param type
     * @param name
     */
    @QtUninvokable
    public final void glGetActiveAttrib(int program, int index, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable IntBuffer size, java.nio.@Nullable IntBuffer type, java.nio.@Nullable CharBuffer name){
        glGetActiveAttrib_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, bufSize, length, size, type, name);
    }
    
    @QtUninvokable
    private native void glGetActiveAttrib_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetActiveSubroutineName(GLuint,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     * @param program
     * @param shadertype
     * @param index
     * @param bufsize
     * @param length
     * @param name
     */
    @QtUninvokable
    public final void glGetActiveSubroutineName(int program, int shadertype, int index, int bufsize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer name){
        glGetActiveSubroutineName_native_GLuint_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, index, bufsize, length, name);
    }
    
    @QtUninvokable
    private native void glGetActiveSubroutineName_native_GLuint_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int shadertype, int index, int bufsize, java.nio.IntBuffer length, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetActiveSubroutineUniformName(GLuint,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     * @param program
     * @param shadertype
     * @param index
     * @param bufsize
     * @param length
     * @param name
     */
    @QtUninvokable
    public final void glGetActiveSubroutineUniformName(int program, int shadertype, int index, int bufsize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer name){
        glGetActiveSubroutineUniformName_native_GLuint_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, index, bufsize, length, name);
    }
    
    @QtUninvokable
    private native void glGetActiveSubroutineUniformName_native_GLuint_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int shadertype, int index, int bufsize, java.nio.IntBuffer length, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetActiveSubroutineUniformiv(GLuint,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param program
     * @param shadertype
     * @param index
     * @param pname
     * @param values
     */
    @QtUninvokable
    public final void glGetActiveSubroutineUniformiv(int program, int shadertype, int index, int pname, java.nio.@Nullable IntBuffer values){
        glGetActiveSubroutineUniformiv_native_GLuint_GLenum_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, index, pname, values);
    }
    
    @QtUninvokable
    private native void glGetActiveSubroutineUniformiv_native_GLuint_GLenum_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int shadertype, int index, int pname, java.nio.IntBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetActiveUniform(GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLint*,<wbr/>GLenum*,<wbr/>GLchar*)</code></p>
     * @param program
     * @param index
     * @param bufSize
     * @param length
     * @param size
     * @param type
     * @param name
     */
    @QtUninvokable
    public final void glGetActiveUniform(int program, int index, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable IntBuffer size, java.nio.@Nullable IntBuffer type, java.nio.@Nullable CharBuffer name){
        glGetActiveUniform_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, bufSize, length, size, type, name);
    }
    
    @QtUninvokable
    private native void glGetActiveUniform_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetActiveUniformBlockName(GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     * @param program
     * @param uniformBlockIndex
     * @param bufSize
     * @param length
     * @param uniformBlockName
     */
    @QtUninvokable
    public final void glGetActiveUniformBlockName(int program, int uniformBlockIndex, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer uniformBlockName){
        glGetActiveUniformBlockName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockIndex, bufSize, length, uniformBlockName);
    }
    
    @QtUninvokable
    private native void glGetActiveUniformBlockName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int uniformBlockIndex, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer uniformBlockName);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetActiveUniformBlockiv(GLuint,<wbr/>GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param program
     * @param uniformBlockIndex
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, java.nio.@Nullable IntBuffer params){
        glGetActiveUniformBlockiv_native_GLuint_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockIndex, pname, params);
    }
    
    @QtUninvokable
    private native void glGetActiveUniformBlockiv_native_GLuint_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int uniformBlockIndex, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetActiveUniformName(GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     * @param program
     * @param uniformIndex
     * @param bufSize
     * @param length
     * @param uniformName
     */
    @QtUninvokable
    public final void glGetActiveUniformName(int program, int uniformIndex, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer uniformName){
        glGetActiveUniformName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformIndex, bufSize, length, uniformName);
    }
    
    @QtUninvokable
    private native void glGetActiveUniformName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int uniformIndex, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer uniformName);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetActiveUniformsiv(GLuint,<wbr/>GLsizei,<wbr/>const GLuint*,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param program
     * @param uniformCount
     * @param uniformIndices
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetActiveUniformsiv(int program, int uniformCount, java.nio.@Nullable IntBuffer uniformIndices, int pname, java.nio.@Nullable IntBuffer params){
        glGetActiveUniformsiv_native_GLuint_GLsizei_const_GLuint_ptr_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformCount, uniformIndices, pname, params);
    }
    
    @QtUninvokable
    private native void glGetActiveUniformsiv_native_GLuint_GLsizei_const_GLuint_ptr_GLenum_GLint_ptr(long __this__nativeId, int program, int uniformCount, java.nio.IntBuffer uniformIndices, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetAttachedShaders(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLuint*)</code></p>
     * @param program
     * @param maxCount
     * @param count
     * @param obj
     */
    @QtUninvokable
    public final void glGetAttachedShaders(int program, int maxCount, java.nio.@Nullable IntBuffer count, java.nio.@Nullable IntBuffer obj){
        glGetAttachedShaders_native_GLuint_GLsizei_GLsizei_ptr_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, maxCount, count, obj);
    }
    
    @QtUninvokable
    private native void glGetAttachedShaders_native_GLuint_GLsizei_GLsizei_ptr_GLuint_ptr(long __this__nativeId, int program, int maxCount, java.nio.IntBuffer count, java.nio.IntBuffer obj);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetAttribLocation(GLuint,<wbr/>const GLchar*)</code></p>
     * @param program
     * @param name
     * @return
     */
    @QtUninvokable
    public final int glGetAttribLocation(int program, java.nio.@Nullable CharBuffer name){
        return glGetAttribLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @QtUninvokable
    private native int glGetAttribLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetBooleani_v(GLenum,<wbr/>GLuint,<wbr/>GLboolean*)</code></p>
     * @param target
     * @param index
     * @param data
     */
    @QtUninvokable
    public final void glGetBooleani_v(int target, int index, java.nio.@Nullable IntBuffer data){
        glGetBooleani_v_native_GLenum_GLuint_GLboolean_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @QtUninvokable
    private native void glGetBooleani_v_native_GLenum_GLuint_GLboolean_ptr(long __this__nativeId, int target, int index, java.nio.IntBuffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetBooleanv(GLenum,<wbr/>GLboolean*)</code></p>
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetBooleanv(int pname, boolean[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetBooleanv_native_GLenum_GLboolean_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetBooleanv_native_GLenum_GLboolean_ptr(long __this__nativeId, int pname, boolean[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetBufferParameteri64v(GLenum,<wbr/>GLenum,<wbr/>GLint64*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetBufferParameteri64v(int target, int pname, java.nio.@Nullable LongBuffer params){
        glGetBufferParameteri64v_native_GLenum_GLenum_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetBufferParameteri64v_native_GLenum_GLenum_GLint64_ptr(long __this__nativeId, int target, int pname, java.nio.LongBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetBufferParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetBufferParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetBufferParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetBufferParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetBufferPointerv(GLenum,<wbr/>GLenum,<wbr/>GLvoid**)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetBufferPointerv(int target, int pname, java.nio.@Nullable Buffer[] params){
        glGetBufferPointerv_native_GLenum_GLenum_GLvoid_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetBufferPointerv_native_GLenum_GLenum_GLvoid_ptr_ptr(long __this__nativeId, int target, int pname, java.nio.Buffer[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetBufferSubData(GLenum,<wbr/>GLintptr,<wbr/>GLsizeiptr,<wbr/>GLvoid*)</code></p>
     * @param target
     * @param offset
     * @param size
     * @param data
     */
    @QtUninvokable
    public final void glGetBufferSubData(int target, long offset, long size, java.nio.@Nullable Buffer data){
        glGetBufferSubData_native_GLenum_GLintptr_GLsizeiptr_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, size, data);
    }
    
    @QtUninvokable
    private native void glGetBufferSubData_native_GLenum_GLintptr_GLsizeiptr_GLvoid_ptr(long __this__nativeId, int target, long offset, long size, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetCompressedTexImage(GLenum,<wbr/>GLint,<wbr/>GLvoid*)</code></p>
     * @param target
     * @param level
     * @param img
     */
    @QtUninvokable
    public final void glGetCompressedTexImage(int target, int level, java.nio.@Nullable Buffer img){
        glGetCompressedTexImage_native_GLenum_GLint_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, img);
    }
    
    @QtUninvokable
    private native void glGetCompressedTexImage_native_GLenum_GLint_GLvoid_ptr(long __this__nativeId, int target, int level, java.nio.Buffer img);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetDoublei_v(GLenum,<wbr/>GLuint,<wbr/>GLdouble*)</code></p>
     * @param target
     * @param index
     * @param data
     */
    @QtUninvokable
    public final void glGetDoublei_v(int target, int index, java.nio.@Nullable DoubleBuffer data){
        glGetDoublei_v_native_GLenum_GLuint_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @QtUninvokable
    private native void glGetDoublei_v_native_GLenum_GLuint_GLdouble_ptr(long __this__nativeId, int target, int index, java.nio.DoubleBuffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetDoublev(GLenum,<wbr/>GLdouble*)</code></p>
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetDoublev(int pname, double[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetDoublev_native_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetDoublev_native_GLenum_GLdouble_ptr(long __this__nativeId, int pname, double[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetError()</code></p>
     * @return
     */
    @QtUninvokable
    public final int glGetError(){
        return glGetError_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int glGetError_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetFloati_v(GLenum,<wbr/>GLuint,<wbr/>GLfloat*)</code></p>
     * @param target
     * @param index
     * @param data
     */
    @QtUninvokable
    public final void glGetFloati_v(int target, int index, java.nio.@Nullable FloatBuffer data){
        glGetFloati_v_native_GLenum_GLuint_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @QtUninvokable
    private native void glGetFloati_v_native_GLenum_GLuint_GLfloat_ptr(long __this__nativeId, int target, int index, java.nio.FloatBuffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetFloatv(GLenum,<wbr/>GLfloat*)</code></p>
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetFloatv(int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetFloatv_native_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetFloatv_native_GLenum_GLfloat_ptr(long __this__nativeId, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetFragDataIndex(GLuint,<wbr/>const GLchar*)</code></p>
     * @param program
     * @param name
     * @return
     */
    @QtUninvokable
    public final int glGetFragDataIndex(int program, java.nio.@Nullable CharBuffer name){
        return glGetFragDataIndex_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @QtUninvokable
    private native int glGetFragDataIndex_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetFragDataLocation(GLuint,<wbr/>const GLchar*)</code></p>
     * @param program
     * @param name
     * @return
     */
    @QtUninvokable
    public final int glGetFragDataLocation(int program, java.nio.@Nullable CharBuffer name){
        return glGetFragDataLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @QtUninvokable
    private native int glGetFragDataLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetFramebufferAttachmentParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param attachment
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, java.nio.@Nullable IntBuffer params){
        glGetFramebufferAttachmentParameteriv_native_GLenum_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, pname, params);
    }
    
    @QtUninvokable
    private native void glGetFramebufferAttachmentParameteriv_native_GLenum_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int attachment, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetFramebufferParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetFramebufferParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetFramebufferParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetFramebufferParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetInteger64i_v(GLenum,<wbr/>GLuint,<wbr/>GLint64*)</code></p>
     * @param target
     * @param index
     * @param data
     */
    @QtUninvokable
    public final void glGetInteger64i_v(int target, int index, java.nio.@Nullable LongBuffer data){
        glGetInteger64i_v_native_GLenum_GLuint_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @QtUninvokable
    private native void glGetInteger64i_v_native_GLenum_GLuint_GLint64_ptr(long __this__nativeId, int target, int index, java.nio.LongBuffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetInteger64v(GLenum,<wbr/>GLint64*)</code></p>
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetInteger64v(int pname, java.nio.@Nullable LongBuffer params){
        glGetInteger64v_native_GLenum_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetInteger64v_native_GLenum_GLint64_ptr(long __this__nativeId, int pname, java.nio.LongBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetIntegeri_v(GLenum,<wbr/>GLuint,<wbr/>GLint*)</code></p>
     * @param target
     * @param index
     * @param data
     */
    @QtUninvokable
    public final void glGetIntegeri_v(int target, int index, java.nio.@Nullable IntBuffer data){
        glGetIntegeri_v_native_GLenum_GLuint_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @QtUninvokable
    private native void glGetIntegeri_v_native_GLenum_GLuint_GLint_ptr(long __this__nativeId, int target, int index, java.nio.IntBuffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetIntegerv(GLenum,<wbr/>GLint*)</code></p>
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetIntegerv(int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetIntegerv_native_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetIntegerv_native_GLenum_GLint_ptr(long __this__nativeId, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetInternalformati64v(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLint64*)</code></p>
     * @param target
     * @param internalformat
     * @param pname
     * @param bufSize
     * @param params
     */
    @QtUninvokable
    public final void glGetInternalformati64v(int target, int internalformat, int pname, int bufSize, java.nio.@Nullable LongBuffer params){
        glGetInternalformati64v_native_GLenum_GLenum_GLenum_GLsizei_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, pname, bufSize, params);
    }
    
    @QtUninvokable
    private native void glGetInternalformati64v_native_GLenum_GLenum_GLenum_GLsizei_GLint64_ptr(long __this__nativeId, int target, int internalformat, int pname, int bufSize, java.nio.LongBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetInternalformativ(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLint*)</code></p>
     * @param target
     * @param internalformat
     * @param pname
     * @param bufSize
     * @param params
     */
    @QtUninvokable
    public final void glGetInternalformativ(int target, int internalformat, int pname, int bufSize, java.nio.@Nullable IntBuffer params){
        glGetInternalformativ_native_GLenum_GLenum_GLenum_GLsizei_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, pname, bufSize, params);
    }
    
    @QtUninvokable
    private native void glGetInternalformativ_native_GLenum_GLenum_GLenum_GLsizei_GLint_ptr(long __this__nativeId, int target, int internalformat, int pname, int bufSize, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetMultisamplefv(GLenum,<wbr/>GLuint,<wbr/>GLfloat*)</code></p>
     * @param pname
     * @param index
     * @param val
     */
    @QtUninvokable
    public final void glGetMultisamplefv(int pname, int index, java.nio.@Nullable FloatBuffer val){
        glGetMultisamplefv_native_GLenum_GLuint_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, index, val);
    }
    
    @QtUninvokable
    private native void glGetMultisamplefv_native_GLenum_GLuint_GLfloat_ptr(long __this__nativeId, int pname, int index, java.nio.FloatBuffer val);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetProgramBinary(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLenum*,<wbr/>GLvoid*)</code></p>
     * @param program
     * @param bufSize
     * @param length
     * @param binaryFormat
     * @param binary
     */
    @QtUninvokable
    public final void glGetProgramBinary(int program, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable IntBuffer binaryFormat, java.nio.@Nullable Buffer binary){
        glGetProgramBinary_native_GLuint_GLsizei_GLsizei_ptr_GLenum_ptr_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, bufSize, length, binaryFormat, binary);
    }
    
    @QtUninvokable
    private native void glGetProgramBinary_native_GLuint_GLsizei_GLsizei_ptr_GLenum_ptr_GLvoid_ptr(long __this__nativeId, int program, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer binaryFormat, java.nio.Buffer binary);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetProgramInfoLog(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     * @param program
     * @param bufSize
     * @param length
     * @param infoLog
     */
    @QtUninvokable
    public final void glGetProgramInfoLog(int program, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer infoLog){
        glGetProgramInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, bufSize, length, infoLog);
    }
    
    @QtUninvokable
    private native void glGetProgramInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetProgramInterfaceiv(GLuint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param program
     * @param programInterface
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetProgramInterfaceiv(int program, int programInterface, int pname, java.nio.@Nullable IntBuffer params){
        glGetProgramInterfaceiv_native_GLuint_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, programInterface, pname, params);
    }
    
    @QtUninvokable
    private native void glGetProgramInterfaceiv_native_GLuint_GLenum_GLenum_GLint_ptr(long __this__nativeId, int program, int programInterface, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetProgramPipelineInfoLog(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     * @param pipeline
     * @param infoLog
     */
    @QtUninvokable
    public final void glGetProgramPipelineInfoLog(int pipeline, java.lang.String[] infoLog){
        if (infoLog.length < 1)
            throw new IllegalArgumentException("Argument 'infoLog': Wrong number of elements in array. Found: 0, expected: 1");
        glGetProgramPipelineInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pipeline, infoLog);
    }
    
    @QtUninvokable
    private native void glGetProgramPipelineInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int pipeline, java.lang.String[] infoLog);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetProgramPipelineiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param pipeline
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetProgramPipelineiv(int pipeline, int pname, java.nio.@Nullable IntBuffer params){
        glGetProgramPipelineiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pipeline, pname, params);
    }
    
    @QtUninvokable
    private native void glGetProgramPipelineiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int pipeline, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetProgramResourceIndex(GLuint,<wbr/>GLenum,<wbr/>const GLchar*)</code></p>
     * @param program
     * @param programInterface
     * @param name
     * @return
     */
    @QtUninvokable
    public final int glGetProgramResourceIndex(int program, int programInterface, java.nio.@Nullable CharBuffer name){
        return glGetProgramResourceIndex_native_GLuint_GLenum_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, programInterface, name);
    }
    
    @QtUninvokable
    private native int glGetProgramResourceIndex_native_GLuint_GLenum_const_GLchar_ptr(long __this__nativeId, int program, int programInterface, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetProgramResourceLocation(GLuint,<wbr/>GLenum,<wbr/>const GLchar*)</code></p>
     * @param program
     * @param programInterface
     * @param name
     * @return
     */
    @QtUninvokable
    public final int glGetProgramResourceLocation(int program, int programInterface, java.nio.@Nullable CharBuffer name){
        return glGetProgramResourceLocation_native_GLuint_GLenum_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, programInterface, name);
    }
    
    @QtUninvokable
    private native int glGetProgramResourceLocation_native_GLuint_GLenum_const_GLchar_ptr(long __this__nativeId, int program, int programInterface, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetProgramResourceLocationIndex(GLuint,<wbr/>GLenum,<wbr/>const GLchar*)</code></p>
     * @param program
     * @param programInterface
     * @param name
     * @return
     */
    @QtUninvokable
    public final int glGetProgramResourceLocationIndex(int program, int programInterface, java.nio.@Nullable CharBuffer name){
        return glGetProgramResourceLocationIndex_native_GLuint_GLenum_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, programInterface, name);
    }
    
    @QtUninvokable
    private native int glGetProgramResourceLocationIndex_native_GLuint_GLenum_const_GLchar_ptr(long __this__nativeId, int program, int programInterface, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetProgramResourceName(GLuint,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     * @param program
     * @param programInterface
     * @param index
     * @param name
     */
    @QtUninvokable
    public final void glGetProgramResourceName(int program, int programInterface, int index, java.lang.String[] name){
        if (name.length < 1)
            throw new IllegalArgumentException("Argument 'name': Wrong number of elements in array. Found: 0, expected: 1");
        glGetProgramResourceName_native_GLuint_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, programInterface, index, name);
    }
    
    @QtUninvokable
    private native void glGetProgramResourceName_native_GLuint_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int programInterface, int index, java.lang.String[] name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetProgramResourceiv(GLuint,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>const GLenum*,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLint*)</code></p>
     * @param program
     * @param programInterface
     * @param index
     * @param propCount
     * @param props
     * @param bufSize
     * @param length
     * @param params
     */
    @QtUninvokable
    public final void glGetProgramResourceiv(int program, int programInterface, int index, int propCount, java.nio.@Nullable IntBuffer props, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable IntBuffer params){
        glGetProgramResourceiv_native_GLuint_GLenum_GLuint_GLsizei_const_GLenum_ptr_GLsizei_GLsizei_ptr_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, programInterface, index, propCount, props, bufSize, length, params);
    }
    
    @QtUninvokable
    private native void glGetProgramResourceiv_native_GLuint_GLenum_GLuint_GLsizei_const_GLenum_ptr_GLsizei_GLsizei_ptr_GLint_ptr(long __this__nativeId, int program, int programInterface, int index, int propCount, java.nio.IntBuffer props, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetProgramStageiv(GLuint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param program
     * @param shadertype
     * @param pname
     * @param values
     */
    @QtUninvokable
    public final void glGetProgramStageiv(int program, int shadertype, int pname, java.nio.@Nullable IntBuffer values){
        glGetProgramStageiv_native_GLuint_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, pname, values);
    }
    
    @QtUninvokable
    private native void glGetProgramStageiv_native_GLuint_GLenum_GLenum_GLint_ptr(long __this__nativeId, int program, int shadertype, int pname, java.nio.IntBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetProgramiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param program
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetProgramiv(int program, int pname, java.nio.@Nullable IntBuffer params){
        glGetProgramiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, pname, params);
    }
    
    @QtUninvokable
    private native void glGetProgramiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetQueryIndexediv(GLenum,<wbr/>GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param index
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetQueryIndexediv(int target, int index, int pname, java.nio.@Nullable IntBuffer params){
        glGetQueryIndexediv_native_GLenum_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryIndexediv_native_GLenum_GLuint_GLenum_GLint_ptr(long __this__nativeId, int target, int index, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetQueryObjecti64v(GLuint,<wbr/>GLenum,<wbr/>GLint64*)</code></p>
     * @param id
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetQueryObjecti64v(int id, int pname, java.nio.@Nullable LongBuffer params){
        glGetQueryObjecti64v_native_GLuint_GLenum_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryObjecti64v_native_GLuint_GLenum_GLint64_ptr(long __this__nativeId, int id, int pname, java.nio.LongBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetQueryObjectiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param id
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetQueryObjectiv(int id, int pname, java.nio.@Nullable IntBuffer params){
        glGetQueryObjectiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryObjectiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int id, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetQueryObjectui64v(GLuint,<wbr/>GLenum,<wbr/>GLuint64*)</code></p>
     * @param id
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetQueryObjectui64v(int id, int pname, java.nio.@Nullable LongBuffer params){
        glGetQueryObjectui64v_native_GLuint_GLenum_GLuint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryObjectui64v_native_GLuint_GLenum_GLuint64_ptr(long __this__nativeId, int id, int pname, java.nio.LongBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetQueryObjectuiv(GLuint,<wbr/>GLenum,<wbr/>GLuint*)</code></p>
     * @param id
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetQueryObjectuiv(int id, int pname, java.nio.@Nullable IntBuffer params){
        glGetQueryObjectuiv_native_GLuint_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryObjectuiv_native_GLuint_GLenum_GLuint_ptr(long __this__nativeId, int id, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetQueryiv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetQueryiv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetQueryiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetRenderbufferParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetRenderbufferParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetRenderbufferParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetRenderbufferParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetSamplerParameterIiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param sampler
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetSamplerParameterIiv(int sampler, int pname, java.nio.@Nullable IntBuffer params){
        glGetSamplerParameterIiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, params);
    }
    
    @QtUninvokable
    private native void glGetSamplerParameterIiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetSamplerParameterIuiv(GLuint,<wbr/>GLenum,<wbr/>GLuint*)</code></p>
     * @param sampler
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetSamplerParameterIuiv(int sampler, int pname, java.nio.@Nullable IntBuffer params){
        glGetSamplerParameterIuiv_native_GLuint_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, params);
    }
    
    @QtUninvokable
    private native void glGetSamplerParameterIuiv_native_GLuint_GLenum_GLuint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetSamplerParameterfv(GLuint,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     * @param sampler
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetSamplerParameterfv(int sampler, int pname, java.nio.@Nullable FloatBuffer params){
        glGetSamplerParameterfv_native_GLuint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, params);
    }
    
    @QtUninvokable
    private native void glGetSamplerParameterfv_native_GLuint_GLenum_GLfloat_ptr(long __this__nativeId, int sampler, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetSamplerParameteriv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param sampler
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetSamplerParameteriv(int sampler, int pname, java.nio.@Nullable IntBuffer params){
        glGetSamplerParameteriv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, params);
    }
    
    @QtUninvokable
    private native void glGetSamplerParameteriv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetShaderInfoLog(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     * @param shader
     * @param bufSize
     * @param length
     * @param infoLog
     */
    @QtUninvokable
    public final void glGetShaderInfoLog(int shader, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer infoLog){
        glGetShaderInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, bufSize, length, infoLog);
    }
    
    @QtUninvokable
    private native void glGetShaderInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetShaderPrecisionFormat(GLenum,<wbr/>GLenum,<wbr/>GLint*,<wbr/>GLint*)</code></p>
     * @param shadertype
     * @param precisiontype
     * @param range
     * @param precision
     */
    @QtUninvokable
    public final void glGetShaderPrecisionFormat(int shadertype, int precisiontype, java.nio.@Nullable IntBuffer range, java.nio.@Nullable IntBuffer precision){
        glGetShaderPrecisionFormat_native_GLenum_GLenum_GLint_ptr_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shadertype, precisiontype, range, precision);
    }
    
    @QtUninvokable
    private native void glGetShaderPrecisionFormat_native_GLenum_GLenum_GLint_ptr_GLint_ptr(long __this__nativeId, int shadertype, int precisiontype, java.nio.IntBuffer range, java.nio.IntBuffer precision);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetShaderSource(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     * @param shader
     * @param bufSize
     * @param length
     * @param source
     */
    @QtUninvokable
    public final void glGetShaderSource(int shader, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer source){
        glGetShaderSource_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, bufSize, length, source);
    }
    
    @QtUninvokable
    private native void glGetShaderSource_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer source);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetShaderiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param shader
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetShaderiv(int shader, int pname, java.nio.@Nullable IntBuffer params){
        glGetShaderiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, pname, params);
    }
    
    @QtUninvokable
    private native void glGetShaderiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int shader, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetString(GLenum)</code></p>
     * @param name
     * @return
     */
    @QtUninvokable
    public final java.lang.@NonNull String glGetString(int name){
        return glGetString_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native java.lang.@NonNull String glGetString_native_GLenum(long __this__nativeId, int name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetStringi(GLenum,<wbr/>GLuint)</code></p>
     * @param name
     * @param index
     * @return
     */
    @QtUninvokable
    public final java.lang.@NonNull String glGetStringi(int name, int index){
        return glGetStringi_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), name, index);
    }
    
    @QtUninvokable
    private native java.lang.@NonNull String glGetStringi_native_GLenum_GLuint(long __this__nativeId, int name, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetSubroutineIndex(GLuint,<wbr/>GLenum,<wbr/>const GLchar*)</code></p>
     * @param program
     * @param shadertype
     * @param name
     * @return
     */
    @QtUninvokable
    public final int glGetSubroutineIndex(int program, int shadertype, java.nio.@Nullable CharBuffer name){
        return glGetSubroutineIndex_native_GLuint_GLenum_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, name);
    }
    
    @QtUninvokable
    private native int glGetSubroutineIndex_native_GLuint_GLenum_const_GLchar_ptr(long __this__nativeId, int program, int shadertype, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetSubroutineUniformLocation(GLuint,<wbr/>GLenum,<wbr/>const GLchar*)</code></p>
     * @param program
     * @param shadertype
     * @param name
     * @return
     */
    @QtUninvokable
    public final int glGetSubroutineUniformLocation(int program, int shadertype, java.nio.@Nullable CharBuffer name){
        return glGetSubroutineUniformLocation_native_GLuint_GLenum_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, name);
    }
    
    @QtUninvokable
    private native int glGetSubroutineUniformLocation_native_GLuint_GLenum_const_GLchar_ptr(long __this__nativeId, int program, int shadertype, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetSynciv(GLsync,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLint*)</code></p>
     * @param sync
     * @param pname
     * @param length
     * @param values
     */
    @QtUninvokable
    public final void glGetSynciv(io.qt.gui.gl.@Nullable GLsync sync, int pname, int[] length, java.nio.@Nullable IntBuffer values){
        if(length!=null && length.length < 1)
            throw new IllegalArgumentException("Argument 'length': Wrong number of elements in array. Found: " + length.length + ", expected: 1");
        glGetSynciv_native___GLsync_ptr_GLenum_GLsizei_GLsizei_ptr_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync), pname, length, values);
    }
    
    @QtUninvokable
    private native void glGetSynciv_native___GLsync_ptr_GLenum_GLsizei_GLsizei_ptr_GLint_ptr(long __this__nativeId, long sync, int pname, int[] length, java.nio.IntBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetTexImage(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLvoid*)</code></p>
     * @param target
     * @param level
     * @param format
     * @param type
     * @param pixels
     */
    @QtUninvokable
    public final void glGetTexImage(int target, int level, int format, int type, java.nio.@Nullable Buffer pixels){
        glGetTexImage_native_GLenum_GLint_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glGetTexImage_native_GLenum_GLint_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, int level, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetTexLevelParameterfv(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     * @param target
     * @param level
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetTexLevelParameterfv(int target, int level, int pname, java.nio.@Nullable FloatBuffer params){
        glGetTexLevelParameterfv_native_GLenum_GLint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexLevelParameterfv_native_GLenum_GLint_GLenum_GLfloat_ptr(long __this__nativeId, int target, int level, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetTexLevelParameteriv(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param level
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetTexLevelParameteriv(int target, int level, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexLevelParameteriv_native_GLenum_GLint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexLevelParameteriv_native_GLenum_GLint_GLenum_GLint_ptr(long __this__nativeId, int target, int level, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetTexParameterIiv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetTexParameterIiv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexParameterIiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameterIiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetTexParameterIuiv(GLenum,<wbr/>GLenum,<wbr/>GLuint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetTexParameterIuiv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexParameterIuiv_native_GLenum_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameterIuiv_native_GLenum_GLenum_GLuint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetTexParameterfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetTexParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glGetTexParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetTexParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetTexParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetTransformFeedbackVarying(GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLsizei*,<wbr/>GLenum*,<wbr/>GLchar*)</code></p>
     * @param program
     * @param index
     * @param size
     * @param type
     * @param name
     */
    @QtUninvokable
    public final void glGetTransformFeedbackVarying(int program, int index, int[] size, int[] type, java.lang.String[] name){
        if (name.length < 1)
            throw new IllegalArgumentException("Argument 'name': Wrong number of elements in array. Found: 0, expected: 1");
        if(size!=null && size.length < 1)
            throw new IllegalArgumentException("Argument 'size': Wrong number of elements in array. Found: " + size.length + ", expected: 1");
        if(type!=null && type.length < 1)
            throw new IllegalArgumentException("Argument 'type': Wrong number of elements in array. Found: " + type.length + ", expected: 1");
        glGetTransformFeedbackVarying_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLsizei_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, size, type, name);
    }
    
    @QtUninvokable
    private native void glGetTransformFeedbackVarying_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLsizei_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int[] size, int[] type, java.lang.String[] name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetUniformBlockIndex(GLuint,<wbr/>const GLchar*)</code></p>
     * @param program
     * @param uniformBlockName
     * @return
     */
    @QtUninvokable
    public final int glGetUniformBlockIndex(int program, java.nio.@Nullable CharBuffer uniformBlockName){
        return glGetUniformBlockIndex_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockName);
    }
    
    @QtUninvokable
    private native int glGetUniformBlockIndex_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer uniformBlockName);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetUniformIndices(GLuint,<wbr/>GLsizei,<wbr/>const GLchar*const*,<wbr/>GLuint*)</code></p>
     * @param program
     * @param uniformNames
     * @param uniformIndices
     */
    @QtUninvokable
    public final void glGetUniformIndices(int program, java.lang.String[] uniformNames, int[] uniformIndices){
        glGetUniformIndices_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformNames, uniformIndices);
    }
    
    @QtUninvokable
    private native void glGetUniformIndices_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLuint_ptr(long __this__nativeId, int program, java.lang.String[] uniformNames, int[] uniformIndices);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetUniformLocation(GLuint,<wbr/>const GLchar*)</code></p>
     * @param program
     * @param name
     * @return
     */
    @QtUninvokable
    public final int glGetUniformLocation(int program, java.nio.@Nullable CharBuffer name){
        return glGetUniformLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @QtUninvokable
    private native int glGetUniformLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetUniformSubroutineuiv(GLenum,<wbr/>GLint,<wbr/>GLuint*)</code></p>
     * @param shadertype
     * @param location
     * @param params
     */
    @QtUninvokable
    public final void glGetUniformSubroutineuiv(int shadertype, int location, java.nio.@Nullable IntBuffer params){
        glGetUniformSubroutineuiv_native_GLenum_GLint_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shadertype, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformSubroutineuiv_native_GLenum_GLint_GLuint_ptr(long __this__nativeId, int shadertype, int location, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetUniformdv(GLuint,<wbr/>GLint,<wbr/>GLdouble*)</code></p>
     * @param program
     * @param location
     * @param params
     */
    @QtUninvokable
    public final void glGetUniformdv(int program, int location, java.nio.@Nullable DoubleBuffer params){
        glGetUniformdv_native_GLuint_GLint_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformdv_native_GLuint_GLint_GLdouble_ptr(long __this__nativeId, int program, int location, java.nio.DoubleBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetUniformfv(GLuint,<wbr/>GLint,<wbr/>GLfloat*)</code></p>
     * @param program
     * @param location
     * @param params
     */
    @QtUninvokable
    public final void glGetUniformfv(int program, int location, java.nio.@Nullable FloatBuffer params){
        glGetUniformfv_native_GLuint_GLint_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformfv_native_GLuint_GLint_GLfloat_ptr(long __this__nativeId, int program, int location, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetUniformiv(GLuint,<wbr/>GLint,<wbr/>GLint*)</code></p>
     * @param program
     * @param location
     * @param params
     */
    @QtUninvokable
    public final void glGetUniformiv(int program, int location, java.nio.@Nullable IntBuffer params){
        glGetUniformiv_native_GLuint_GLint_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformiv_native_GLuint_GLint_GLint_ptr(long __this__nativeId, int program, int location, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetUniformuiv(GLuint,<wbr/>GLint,<wbr/>GLuint*)</code></p>
     * @param program
     * @param location
     * @param params
     */
    @QtUninvokable
    public final void glGetUniformuiv(int program, int location, java.nio.@Nullable IntBuffer params){
        glGetUniformuiv_native_GLuint_GLint_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformuiv_native_GLuint_GLint_GLuint_ptr(long __this__nativeId, int program, int location, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetVertexAttribIiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param index
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetVertexAttribIiv(int index, int pname, java.nio.@Nullable IntBuffer params){
        glGetVertexAttribIiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribIiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int index, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetVertexAttribIuiv(GLuint,<wbr/>GLenum,<wbr/>GLuint*)</code></p>
     * @param index
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetVertexAttribIuiv(int index, int pname, java.nio.@Nullable IntBuffer params){
        glGetVertexAttribIuiv_native_GLuint_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribIuiv_native_GLuint_GLenum_GLuint_ptr(long __this__nativeId, int index, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetVertexAttribLdv(GLuint,<wbr/>GLenum,<wbr/>GLdouble*)</code></p>
     * @param index
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetVertexAttribLdv(int index, int pname, java.nio.@Nullable DoubleBuffer params){
        glGetVertexAttribLdv_native_GLuint_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribLdv_native_GLuint_GLenum_GLdouble_ptr(long __this__nativeId, int index, int pname, java.nio.DoubleBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetVertexAttribPointerv(GLuint,<wbr/>GLenum,<wbr/>GLvoid**)</code></p>
     * @param index
     * @param pname
     * @param pointer
     */
    @QtUninvokable
    public final void glGetVertexAttribPointerv(int index, int pname, java.nio.@Nullable Buffer[] pointer){
        glGetVertexAttribPointerv_native_GLuint_GLenum_GLvoid_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, pointer);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribPointerv_native_GLuint_GLenum_GLvoid_ptr_ptr(long __this__nativeId, int index, int pname, java.nio.Buffer[] pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetVertexAttribdv(GLuint,<wbr/>GLenum,<wbr/>GLdouble*)</code></p>
     * @param index
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetVertexAttribdv(int index, int pname, java.nio.@Nullable DoubleBuffer params){
        glGetVertexAttribdv_native_GLuint_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribdv_native_GLuint_GLenum_GLdouble_ptr(long __this__nativeId, int index, int pname, java.nio.DoubleBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetVertexAttribfv(GLuint,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     * @param index
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetVertexAttribfv(int index, int pname, java.nio.@Nullable FloatBuffer params){
        glGetVertexAttribfv_native_GLuint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribfv_native_GLuint_GLenum_GLfloat_ptr(long __this__nativeId, int index, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glGetVertexAttribiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param index
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetVertexAttribiv(int index, int pname, java.nio.@Nullable IntBuffer params){
        glGetVertexAttribiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int index, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glHint(GLenum,<wbr/>GLenum)</code></p>
     * @param target
     * @param mode
     */
    @QtUninvokable
    public final void glHint(int target, int mode){
        glHint_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, mode);
    }
    
    @QtUninvokable
    private native void glHint_native_GLenum_GLenum(long __this__nativeId, int target, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glInvalidateBufferData(GLuint)</code></p>
     * @param buffer
     */
    @QtUninvokable
    public final void glInvalidateBufferData(int buffer){
        glInvalidateBufferData_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), buffer);
    }
    
    @QtUninvokable
    private native void glInvalidateBufferData_native_GLuint(long __this__nativeId, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glInvalidateBufferSubData(GLuint,<wbr/>GLintptr,<wbr/>GLsizeiptr)</code></p>
     * @param buffer
     * @param offset
     * @param length
     */
    @QtUninvokable
    public final void glInvalidateBufferSubData(int buffer, long offset, long length){
        glInvalidateBufferSubData_native_GLuint_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, offset, length);
    }
    
    @QtUninvokable
    private native void glInvalidateBufferSubData_native_GLuint_GLintptr_GLsizeiptr(long __this__nativeId, int buffer, long offset, long length);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glInvalidateFramebuffer(GLenum,<wbr/>GLsizei,<wbr/>const GLenum*)</code></p>
     * @param target
     * @param numAttachments
     * @param attachments
     */
    @QtUninvokable
    public final void glInvalidateFramebuffer(int target, int numAttachments, java.nio.@Nullable IntBuffer attachments){
        glInvalidateFramebuffer_native_GLenum_GLsizei_const_GLenum_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, numAttachments, attachments);
    }
    
    @QtUninvokable
    private native void glInvalidateFramebuffer_native_GLenum_GLsizei_const_GLenum_ptr(long __this__nativeId, int target, int numAttachments, java.nio.IntBuffer attachments);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glInvalidateSubFramebuffer(GLenum,<wbr/>GLsizei,<wbr/>const GLenum*,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param target
     * @param numAttachments
     * @param attachments
     * @param x
     * @param y
     * @param width
     * @param height
     */
    @QtUninvokable
    public final void glInvalidateSubFramebuffer(int target, int numAttachments, java.nio.@Nullable IntBuffer attachments, int x, int y, int width, int height){
        glInvalidateSubFramebuffer_native_GLenum_GLsizei_const_GLenum_ptr_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, numAttachments, attachments, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glInvalidateSubFramebuffer_native_GLenum_GLsizei_const_GLenum_ptr_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int numAttachments, java.nio.IntBuffer attachments, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glInvalidateTexImage(GLuint,<wbr/>GLint)</code></p>
     * @param texture
     * @param level
     */
    @QtUninvokable
    public final void glInvalidateTexImage(int texture, int level){
        glInvalidateTexImage_native_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level);
    }
    
    @QtUninvokable
    private native void glInvalidateTexImage_native_GLuint_GLint(long __this__nativeId, int texture, int level);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glInvalidateTexSubImage(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param texture
     * @param level
     * @param xoffset
     * @param yoffset
     * @param zoffset
     * @param width
     * @param height
     * @param depth
     */
    @QtUninvokable
    public final void glInvalidateTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth){
        glInvalidateTexSubImage_native_GLuint_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level, xoffset, yoffset, zoffset, width, height, depth);
    }
    
    @QtUninvokable
    private native void glInvalidateTexSubImage_native_GLuint_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei(long __this__nativeId, int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glIsBuffer(GLuint)</code></p>
     * @param buffer
     * @return
     */
    @QtUninvokable
    public final boolean glIsBuffer(int buffer){
        return glIsBuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), buffer);
    }
    
    @QtUninvokable
    private native boolean glIsBuffer_native_GLuint(long __this__nativeId, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glIsEnabled(GLenum)</code></p>
     * @param cap
     * @return
     */
    @QtUninvokable
    public final boolean glIsEnabled(int cap){
        return glIsEnabled_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native boolean glIsEnabled_native_GLenum(long __this__nativeId, int cap);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glIsEnabledi(GLenum,<wbr/>GLuint)</code></p>
     * @param target
     * @param index
     * @return
     */
    @QtUninvokable
    public final boolean glIsEnabledi(int target, int index){
        return glIsEnabledi_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index);
    }
    
    @QtUninvokable
    private native boolean glIsEnabledi_native_GLenum_GLuint(long __this__nativeId, int target, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glIsFramebuffer(GLuint)</code></p>
     * @param framebuffer
     * @return
     */
    @QtUninvokable
    public final boolean glIsFramebuffer(int framebuffer){
        return glIsFramebuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer);
    }
    
    @QtUninvokable
    private native boolean glIsFramebuffer_native_GLuint(long __this__nativeId, int framebuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glIsProgram(GLuint)</code></p>
     * @param program
     * @return
     */
    @QtUninvokable
    public final boolean glIsProgram(int program){
        return glIsProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native boolean glIsProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glIsProgramPipeline(GLuint)</code></p>
     * @param pipeline
     * @return
     */
    @QtUninvokable
    public final boolean glIsProgramPipeline(int pipeline){
        return glIsProgramPipeline_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), pipeline);
    }
    
    @QtUninvokable
    private native boolean glIsProgramPipeline_native_GLuint(long __this__nativeId, int pipeline);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glIsQuery(GLuint)</code></p>
     * @param id
     * @return
     */
    @QtUninvokable
    public final boolean glIsQuery(int id){
        return glIsQuery_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @QtUninvokable
    private native boolean glIsQuery_native_GLuint(long __this__nativeId, int id);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glIsRenderbuffer(GLuint)</code></p>
     * @param renderbuffer
     * @return
     */
    @QtUninvokable
    public final boolean glIsRenderbuffer(int renderbuffer){
        return glIsRenderbuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), renderbuffer);
    }
    
    @QtUninvokable
    private native boolean glIsRenderbuffer_native_GLuint(long __this__nativeId, int renderbuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glIsSampler(GLuint)</code></p>
     * @param sampler
     * @return
     */
    @QtUninvokable
    public final boolean glIsSampler(int sampler){
        return glIsSampler_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), sampler);
    }
    
    @QtUninvokable
    private native boolean glIsSampler_native_GLuint(long __this__nativeId, int sampler);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glIsShader(GLuint)</code></p>
     * @param shader
     * @return
     */
    @QtUninvokable
    public final boolean glIsShader(int shader){
        return glIsShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @QtUninvokable
    private native boolean glIsShader_native_GLuint(long __this__nativeId, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glIsSync(GLsync)</code></p>
     * @param sync
     * @return
     */
    @QtUninvokable
    public final boolean glIsSync(io.qt.gui.gl.@Nullable GLsync sync){
        return glIsSync_native___GLsync_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync));
    }
    
    @QtUninvokable
    private native boolean glIsSync_native___GLsync_ptr(long __this__nativeId, long sync);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glIsTexture(GLuint)</code></p>
     * @param texture
     * @return
     */
    @QtUninvokable
    public final boolean glIsTexture(int texture){
        return glIsTexture_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @QtUninvokable
    private native boolean glIsTexture_native_GLuint(long __this__nativeId, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glIsTransformFeedback(GLuint)</code></p>
     * @param id
     * @return
     */
    @QtUninvokable
    public final boolean glIsTransformFeedback(int id){
        return glIsTransformFeedback_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @QtUninvokable
    private native boolean glIsTransformFeedback_native_GLuint(long __this__nativeId, int id);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glIsVertexArray(GLuint)</code></p>
     * @param array
     * @return
     */
    @QtUninvokable
    public final boolean glIsVertexArray(int array){
        return glIsVertexArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), array);
    }
    
    @QtUninvokable
    private native boolean glIsVertexArray_native_GLuint(long __this__nativeId, int array);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glLineWidth(GLfloat)</code></p>
     * @param width
     */
    @QtUninvokable
    public final void glLineWidth(float width){
        glLineWidth_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), width);
    }
    
    @QtUninvokable
    private native void glLineWidth_native_GLfloat(long __this__nativeId, float width);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glLinkProgram(GLuint)</code></p>
     * @param program
     */
    @QtUninvokable
    public final void glLinkProgram(int program){
        glLinkProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glLinkProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glLogicOp(GLenum)</code></p>
     * @param opcode
     */
    @QtUninvokable
    public final void glLogicOp(int opcode){
        glLogicOp_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), opcode);
    }
    
    @QtUninvokable
    private native void glLogicOp_native_GLenum(long __this__nativeId, int opcode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glMapBuffer(GLenum,<wbr/>GLenum)</code></p>
     * @param target
     * @param access
     * @return
     */
    @QtUninvokable
    public final java.nio.@Nullable Buffer glMapBuffer(int target, int access){
        return glMapBuffer_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, access);
    }
    
    @QtUninvokable
    private native java.nio.Buffer glMapBuffer_native_GLenum_GLenum(long __this__nativeId, int target, int access);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glMapBufferRange(GLenum,<wbr/>GLintptr,<wbr/>GLsizeiptr,<wbr/>GLbitfield)</code></p>
     * @param target
     * @param offset
     * @param access
     * @return
     */
    @QtUninvokable
    public final java.nio.@Nullable Buffer glMapBufferRange(int target, long offset, int access){
        return glMapBufferRange_native_GLenum_GLintptr_GLsizeiptr_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, access);
    }
    
    @QtUninvokable
    private native java.nio.Buffer glMapBufferRange_native_GLenum_GLintptr_GLsizeiptr_GLbitfield(long __this__nativeId, int target, long offset, int access);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glMemoryBarrier(GLbitfield)</code></p>
     * @param barriers
     */
    @QtUninvokable
    public final void glMemoryBarrier(int barriers){
        glMemoryBarrier_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), barriers);
    }
    
    @QtUninvokable
    private native void glMemoryBarrier_native_GLbitfield(long __this__nativeId, int barriers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glMinSampleShading(GLfloat)</code></p>
     * @param value
     */
    @QtUninvokable
    public final void glMinSampleShading(float value){
        glMinSampleShading_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void glMinSampleShading_native_GLfloat(long __this__nativeId, float value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glMultiDrawArrays(GLenum,<wbr/>const GLint*,<wbr/>const GLsizei*,<wbr/>GLsizei)</code></p>
     * @param mode
     * @param first
     * @param count
     * @param drawcount
     */
    @QtUninvokable
    public final void glMultiDrawArrays(int mode, java.nio.@Nullable IntBuffer first, java.nio.@Nullable IntBuffer count, int drawcount){
        glMultiDrawArrays_native_GLenum_const_GLint_ptr_const_GLsizei_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count, drawcount);
    }
    
    @QtUninvokable
    private native void glMultiDrawArrays_native_GLenum_const_GLint_ptr_const_GLsizei_ptr_GLsizei(long __this__nativeId, int mode, java.nio.IntBuffer first, java.nio.IntBuffer count, int drawcount);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glMultiDrawArraysIndirect(GLenum,<wbr/>const void*,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param mode
     * @param indirect
     * @param drawcount
     * @param stride
     */
    @QtUninvokable
    public final void glMultiDrawArraysIndirect(int mode, java.nio.@Nullable Buffer indirect, int drawcount, int stride){
        glMultiDrawArraysIndirect_native_GLenum_const_void_ptr_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, indirect, drawcount, stride);
    }
    
    @QtUninvokable
    private native void glMultiDrawArraysIndirect_native_GLenum_const_void_ptr_GLsizei_GLsizei(long __this__nativeId, int mode, java.nio.Buffer indirect, int drawcount, int stride);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glMultiDrawElements(GLenum,<wbr/>const GLsizei*,<wbr/>GLenum,<wbr/>const GLvoid*const*,<wbr/>GLsizei)</code></p>
     * @param mode
     * @param count
     * @param type
     * @param indices
     * @param drawcount
     */
    @QtUninvokable
    public final void glMultiDrawElements(int mode, java.nio.@Nullable IntBuffer count, int type, java.nio.Buffer @StrictNonNull[] indices, int drawcount){
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glMultiDrawElements_native_GLenum_const_GLsizei_ptr_GLenum_const_GLvoid_cptr_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, drawcount);
    }
    
    @QtUninvokable
    private native void glMultiDrawElements_native_GLenum_const_GLsizei_ptr_GLenum_const_GLvoid_cptr_ptr_GLsizei(long __this__nativeId, int mode, java.nio.IntBuffer count, int type, java.nio.Buffer[] indices, int drawcount);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glMultiDrawElementsBaseVertex(GLenum,<wbr/>const GLsizei*,<wbr/>GLenum,<wbr/>const GLvoid*const*,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     * @param mode
     * @param count
     * @param type
     * @param indices
     * @param drawcount
     * @param basevertex
     */
    @QtUninvokable
    public final void glMultiDrawElementsBaseVertex(int mode, java.nio.@Nullable IntBuffer count, int type, java.nio.Buffer @StrictNonNull[] indices, int drawcount, java.nio.@Nullable IntBuffer basevertex){
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glMultiDrawElementsBaseVertex_native_GLenum_const_GLsizei_ptr_GLenum_const_GLvoid_cptr_ptr_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, drawcount, basevertex);
    }
    
    @QtUninvokable
    private native void glMultiDrawElementsBaseVertex_native_GLenum_const_GLsizei_ptr_GLenum_const_GLvoid_cptr_ptr_GLsizei_const_GLint_ptr(long __this__nativeId, int mode, java.nio.IntBuffer count, int type, java.nio.Buffer[] indices, int drawcount, java.nio.IntBuffer basevertex);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glMultiDrawElementsIndirect(GLenum,<wbr/>GLenum,<wbr/>const void*,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param mode
     * @param type
     * @param indirect
     * @param drawcount
     * @param stride
     */
    @QtUninvokable
    public final void glMultiDrawElementsIndirect(int mode, int type, java.nio.@Nullable Buffer indirect, int drawcount, int stride){
        glMultiDrawElementsIndirect_native_GLenum_GLenum_const_void_ptr_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, type, indirect, drawcount, stride);
    }
    
    @QtUninvokable
    private native void glMultiDrawElementsIndirect_native_GLenum_GLenum_const_void_ptr_GLsizei_GLsizei(long __this__nativeId, int mode, int type, java.nio.Buffer indirect, int drawcount, int stride);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glPatchParameterfv(GLenum,<wbr/>const GLfloat*)</code></p>
     * @param pname
     * @param values
     */
    @QtUninvokable
    public final void glPatchParameterfv(int pname, java.nio.@Nullable FloatBuffer values){
        glPatchParameterfv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, values);
    }
    
    @QtUninvokable
    private native void glPatchParameterfv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int pname, java.nio.FloatBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glPatchParameteri(GLenum,<wbr/>GLint)</code></p>
     * @param pname
     * @param value
     */
    @QtUninvokable
    public final void glPatchParameteri(int pname, int value){
        glPatchParameteri_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, value);
    }
    
    @QtUninvokable
    private native void glPatchParameteri_native_GLenum_GLint(long __this__nativeId, int pname, int value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glPauseTransformFeedback()</code></p>
     */
    @QtUninvokable
    public final void glPauseTransformFeedback(){
        glPauseTransformFeedback_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPauseTransformFeedback_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glPixelStoref(GLenum,<wbr/>GLfloat)</code></p>
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glPixelStoref(int pname, float param){
        glPixelStoref_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelStoref_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glPixelStorei(GLenum,<wbr/>GLint)</code></p>
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glPixelStorei(int pname, int param){
        glPixelStorei_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelStorei_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glPointParameterf(GLenum,<wbr/>GLfloat)</code></p>
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glPointParameterf(int pname, float param){
        glPointParameterf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPointParameterf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glPointParameterfv(GLenum,<wbr/>const GLfloat*)</code></p>
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glPointParameterfv(int pname, java.nio.@Nullable FloatBuffer params){
        glPointParameterfv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glPointParameterfv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glPointParameteri(GLenum,<wbr/>GLint)</code></p>
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glPointParameteri(int pname, int param){
        glPointParameteri_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPointParameteri_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glPointParameteriv(GLenum,<wbr/>const GLint*)</code></p>
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glPointParameteriv(int pname, java.nio.@Nullable IntBuffer params){
        glPointParameteriv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glPointParameteriv_native_GLenum_const_GLint_ptr(long __this__nativeId, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glPointSize(GLfloat)</code></p>
     * @param size
     */
    @QtUninvokable
    public final void glPointSize(float size){
        glPointSize_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), size);
    }
    
    @QtUninvokable
    private native void glPointSize_native_GLfloat(long __this__nativeId, float size);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glPolygonMode(GLenum,<wbr/>GLenum)</code></p>
     * @param face
     * @param mode
     */
    @QtUninvokable
    public final void glPolygonMode(int face, int mode){
        glPolygonMode_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, mode);
    }
    
    @QtUninvokable
    private native void glPolygonMode_native_GLenum_GLenum(long __this__nativeId, int face, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glPolygonOffset(GLfloat,<wbr/>GLfloat)</code></p>
     * @param factor
     * @param units
     */
    @QtUninvokable
    public final void glPolygonOffset(float factor, float units){
        glPolygonOffset_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), factor, units);
    }
    
    @QtUninvokable
    private native void glPolygonOffset_native_GLfloat_GLfloat(long __this__nativeId, float factor, float units);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glPrimitiveRestartIndex(GLuint)</code></p>
     * @param index
     */
    @QtUninvokable
    public final void glPrimitiveRestartIndex(int index){
        glPrimitiveRestartIndex_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void glPrimitiveRestartIndex_native_GLuint(long __this__nativeId, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramBinary(GLuint,<wbr/>GLenum,<wbr/>const GLvoid*,<wbr/>GLsizei)</code></p>
     * @param program
     * @param binaryFormat
     * @param binary
     * @param length
     */
    @QtUninvokable
    public final void glProgramBinary(int program, int binaryFormat, java.nio.@Nullable Buffer binary, int length){
        glProgramBinary_native_GLuint_GLenum_const_GLvoid_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), program, binaryFormat, binary, length);
    }
    
    @QtUninvokable
    private native void glProgramBinary_native_GLuint_GLenum_const_GLvoid_ptr_GLsizei(long __this__nativeId, int program, int binaryFormat, java.nio.Buffer binary, int length);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramParameteri(GLuint,<wbr/>GLenum,<wbr/>GLint)</code></p>
     * @param program
     * @param pname
     * @param value
     */
    @QtUninvokable
    public final void glProgramParameteri(int program, int pname, int value){
        glProgramParameteri_native_GLuint_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), program, pname, value);
    }
    
    @QtUninvokable
    private native void glProgramParameteri_native_GLuint_GLenum_GLint(long __this__nativeId, int program, int pname, int value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform1d(GLuint,<wbr/>GLint,<wbr/>GLdouble)</code></p>
     * @param program
     * @param location
     * @param v0
     */
    @QtUninvokable
    public final void glProgramUniform1d(int program, int location, double v0){
        glProgramUniform1d_native_GLuint_GLint_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0);
    }
    
    @QtUninvokable
    private native void glProgramUniform1d_native_GLuint_GLint_GLdouble(long __this__nativeId, int program, int location, double v0);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform1dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLdouble*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniform1dv(int program, int location, int count, java.nio.@Nullable DoubleBuffer value){
        glProgramUniform1dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform1dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform1f(GLuint,<wbr/>GLint,<wbr/>GLfloat)</code></p>
     * @param program
     * @param location
     * @param v0
     */
    @QtUninvokable
    public final void glProgramUniform1f(int program, int location, float v0){
        glProgramUniform1f_native_GLuint_GLint_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0);
    }
    
    @QtUninvokable
    private native void glProgramUniform1f_native_GLuint_GLint_GLfloat(long __this__nativeId, int program, int location, float v0);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform1fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniform1fv(int program, int location, int count, java.nio.@Nullable FloatBuffer value){
        glProgramUniform1fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform1fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform1i(GLuint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param program
     * @param location
     * @param v0
     */
    @QtUninvokable
    public final void glProgramUniform1i(int program, int location, int v0){
        glProgramUniform1i_native_GLuint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0);
    }
    
    @QtUninvokable
    private native void glProgramUniform1i_native_GLuint_GLint_GLint(long __this__nativeId, int program, int location, int v0);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform1iv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniform1iv(int program, int location, int count, java.nio.@Nullable IntBuffer value){
        glProgramUniform1iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform1iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform1ui(GLuint,<wbr/>GLint,<wbr/>GLuint)</code></p>
     * @param program
     * @param location
     * @param v0
     */
    @QtUninvokable
    public final void glProgramUniform1ui(int program, int location, int v0){
        glProgramUniform1ui_native_GLuint_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0);
    }
    
    @QtUninvokable
    private native void glProgramUniform1ui_native_GLuint_GLint_GLuint(long __this__nativeId, int program, int location, int v0);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform1uiv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniform1uiv(int program, int location, int count, java.nio.@Nullable IntBuffer value){
        glProgramUniform1uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform1uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform2d(GLuint,<wbr/>GLint,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param program
     * @param location
     * @param v0
     * @param v1
     */
    @QtUninvokable
    public final void glProgramUniform2d(int program, int location, double v0, double v1){
        glProgramUniform2d_native_GLuint_GLint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1);
    }
    
    @QtUninvokable
    private native void glProgramUniform2d_native_GLuint_GLint_GLdouble_GLdouble(long __this__nativeId, int program, int location, double v0, double v1);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform2dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLdouble*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniform2dv(int program, int location, int count, java.nio.@Nullable DoubleBuffer value){
        glProgramUniform2dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform2dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform2f(GLuint,<wbr/>GLint,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param program
     * @param location
     * @param v0
     * @param v1
     */
    @QtUninvokable
    public final void glProgramUniform2f(int program, int location, float v0, float v1){
        glProgramUniform2f_native_GLuint_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1);
    }
    
    @QtUninvokable
    private native void glProgramUniform2f_native_GLuint_GLint_GLfloat_GLfloat(long __this__nativeId, int program, int location, float v0, float v1);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform2fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniform2fv(int program, int location, int count, java.nio.@Nullable FloatBuffer value){
        glProgramUniform2fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform2fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform2i(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param program
     * @param location
     * @param v0
     * @param v1
     */
    @QtUninvokable
    public final void glProgramUniform2i(int program, int location, int v0, int v1){
        glProgramUniform2i_native_GLuint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1);
    }
    
    @QtUninvokable
    private native void glProgramUniform2i_native_GLuint_GLint_GLint_GLint(long __this__nativeId, int program, int location, int v0, int v1);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform2iv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniform2iv(int program, int location, int count, java.nio.@Nullable IntBuffer value){
        glProgramUniform2iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform2iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform2ui(GLuint,<wbr/>GLint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     * @param program
     * @param location
     * @param v0
     * @param v1
     */
    @QtUninvokable
    public final void glProgramUniform2ui(int program, int location, int v0, int v1){
        glProgramUniform2ui_native_GLuint_GLint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1);
    }
    
    @QtUninvokable
    private native void glProgramUniform2ui_native_GLuint_GLint_GLuint_GLuint(long __this__nativeId, int program, int location, int v0, int v1);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform2uiv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniform2uiv(int program, int location, int count, java.nio.@Nullable IntBuffer value){
        glProgramUniform2uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform2uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform3d(GLuint,<wbr/>GLint,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param program
     * @param location
     * @param v0
     * @param v1
     * @param v2
     */
    @QtUninvokable
    public final void glProgramUniform3d(int program, int location, double v0, double v1, double v2){
        glProgramUniform3d_native_GLuint_GLint_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glProgramUniform3d_native_GLuint_GLint_GLdouble_GLdouble_GLdouble(long __this__nativeId, int program, int location, double v0, double v1, double v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform3dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLdouble*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniform3dv(int program, int location, int count, java.nio.@Nullable DoubleBuffer value){
        glProgramUniform3dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform3dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform3f(GLuint,<wbr/>GLint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param program
     * @param location
     * @param v0
     * @param v1
     * @param v2
     */
    @QtUninvokable
    public final void glProgramUniform3f(int program, int location, float v0, float v1, float v2){
        glProgramUniform3f_native_GLuint_GLint_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glProgramUniform3f_native_GLuint_GLint_GLfloat_GLfloat_GLfloat(long __this__nativeId, int program, int location, float v0, float v1, float v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform3fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniform3fv(int program, int location, int count, java.nio.@Nullable FloatBuffer value){
        glProgramUniform3fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform3fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform3i(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param program
     * @param location
     * @param v0
     * @param v1
     * @param v2
     */
    @QtUninvokable
    public final void glProgramUniform3i(int program, int location, int v0, int v1, int v2){
        glProgramUniform3i_native_GLuint_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glProgramUniform3i_native_GLuint_GLint_GLint_GLint_GLint(long __this__nativeId, int program, int location, int v0, int v1, int v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform3iv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniform3iv(int program, int location, int count, java.nio.@Nullable IntBuffer value){
        glProgramUniform3iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform3iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform3ui(GLuint,<wbr/>GLint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     * @param program
     * @param location
     * @param v0
     * @param v1
     * @param v2
     */
    @QtUninvokable
    public final void glProgramUniform3ui(int program, int location, int v0, int v1, int v2){
        glProgramUniform3ui_native_GLuint_GLint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glProgramUniform3ui_native_GLuint_GLint_GLuint_GLuint_GLuint(long __this__nativeId, int program, int location, int v0, int v1, int v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform3uiv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniform3uiv(int program, int location, int count, java.nio.@Nullable IntBuffer value){
        glProgramUniform3uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform3uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform4d(GLuint,<wbr/>GLint,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param program
     * @param location
     * @param v0
     * @param v1
     * @param v2
     * @param v3
     */
    @QtUninvokable
    public final void glProgramUniform4d(int program, int location, double v0, double v1, double v2, double v3){
        glProgramUniform4d_native_GLuint_GLint_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glProgramUniform4d_native_GLuint_GLint_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, int program, int location, double v0, double v1, double v2, double v3);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform4dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLdouble*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniform4dv(int program, int location, int count, java.nio.@Nullable DoubleBuffer value){
        glProgramUniform4dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform4dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform4f(GLuint,<wbr/>GLint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param program
     * @param location
     * @param v0
     * @param v1
     * @param v2
     * @param v3
     */
    @QtUninvokable
    public final void glProgramUniform4f(int program, int location, float v0, float v1, float v2, float v3){
        glProgramUniform4f_native_GLuint_GLint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glProgramUniform4f_native_GLuint_GLint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int program, int location, float v0, float v1, float v2, float v3);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform4fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniform4fv(int program, int location, int count, java.nio.@Nullable FloatBuffer value){
        glProgramUniform4fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform4fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform4i(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param program
     * @param location
     * @param v0
     * @param v1
     * @param v2
     * @param v3
     */
    @QtUninvokable
    public final void glProgramUniform4i(int program, int location, int v0, int v1, int v2, int v3){
        glProgramUniform4i_native_GLuint_GLint_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glProgramUniform4i_native_GLuint_GLint_GLint_GLint_GLint_GLint(long __this__nativeId, int program, int location, int v0, int v1, int v2, int v3);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform4iv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniform4iv(int program, int location, int count, java.nio.@Nullable IntBuffer value){
        glProgramUniform4iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform4iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform4ui(GLuint,<wbr/>GLint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     * @param program
     * @param location
     * @param v0
     * @param v1
     * @param v2
     * @param v3
     */
    @QtUninvokable
    public final void glProgramUniform4ui(int program, int location, int v0, int v1, int v2, int v3){
        glProgramUniform4ui_native_GLuint_GLint_GLuint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glProgramUniform4ui_native_GLuint_GLint_GLuint_GLuint_GLuint_GLuint(long __this__nativeId, int program, int location, int v0, int v1, int v2, int v3);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniform4uiv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniform4uiv(int program, int location, int count, java.nio.@Nullable IntBuffer value){
        glProgramUniform4uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform4uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniformMatrix2dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniformMatrix2dv(int program, int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glProgramUniformMatrix2dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix2dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniformMatrix2fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniformMatrix2fv(int program, int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glProgramUniformMatrix2fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix2fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniformMatrix2x3dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniformMatrix2x3dv(int program, int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glProgramUniformMatrix2x3dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix2x3dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniformMatrix2x3fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniformMatrix2x3fv(int program, int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glProgramUniformMatrix2x3fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix2x3fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniformMatrix2x4dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniformMatrix2x4dv(int program, int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glProgramUniformMatrix2x4dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix2x4dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniformMatrix2x4fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniformMatrix2x4fv(int program, int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glProgramUniformMatrix2x4fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix2x4fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniformMatrix3dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniformMatrix3dv(int program, int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glProgramUniformMatrix3dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix3dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniformMatrix3fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniformMatrix3fv(int program, int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glProgramUniformMatrix3fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix3fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniformMatrix3x2dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniformMatrix3x2dv(int program, int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glProgramUniformMatrix3x2dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix3x2dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniformMatrix3x2fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniformMatrix3x2fv(int program, int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glProgramUniformMatrix3x2fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix3x2fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniformMatrix3x4dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniformMatrix3x4dv(int program, int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glProgramUniformMatrix3x4dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix3x4dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniformMatrix3x4fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniformMatrix3x4fv(int program, int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glProgramUniformMatrix3x4fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix3x4fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniformMatrix4dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniformMatrix4dv(int program, int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glProgramUniformMatrix4dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix4dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniformMatrix4fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniformMatrix4fv(int program, int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glProgramUniformMatrix4fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix4fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniformMatrix4x2dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniformMatrix4x2dv(int program, int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glProgramUniformMatrix4x2dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix4x2dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniformMatrix4x2fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniformMatrix4x2fv(int program, int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glProgramUniformMatrix4x2fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix4x2fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniformMatrix4x3dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniformMatrix4x3dv(int program, int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glProgramUniformMatrix4x3dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix4x3dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProgramUniformMatrix4x3fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param program
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glProgramUniformMatrix4x3fv(int program, int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glProgramUniformMatrix4x3fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix4x3fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glProvokingVertex(GLenum)</code></p>
     * @param mode
     */
    @QtUninvokable
    public final void glProvokingVertex(int mode){
        glProvokingVertex_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glProvokingVertex_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glQueryCounter(GLuint,<wbr/>GLenum)</code></p>
     * @param id
     * @param target
     */
    @QtUninvokable
    public final void glQueryCounter(int id, int target){
        glQueryCounter_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), id, target);
    }
    
    @QtUninvokable
    private native void glQueryCounter_native_GLuint_GLenum(long __this__nativeId, int id, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glReadBuffer(GLenum)</code></p>
     * @param mode
     */
    @QtUninvokable
    public final void glReadBuffer(int mode){
        glReadBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glReadBuffer_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glReadPixels(GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLvoid*)</code></p>
     * @param x
     * @param y
     * @param width
     * @param height
     * @param format
     * @param type
     * @param pixels
     */
    @QtUninvokable
    public final void glReadPixels(int x, int y, int width, int height, int format, int type, java.nio.@Nullable Buffer pixels){
        glReadPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glReadPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int x, int y, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glReleaseShaderCompiler()</code></p>
     */
    @QtUninvokable
    public final void glReleaseShaderCompiler(){
        glReleaseShaderCompiler_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glReleaseShaderCompiler_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glRenderbufferStorage(GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param target
     * @param internalformat
     * @param width
     * @param height
     */
    @QtUninvokable
    public final void glRenderbufferStorage(int target, int internalformat, int width, int height){
        glRenderbufferStorage_native_GLenum_GLenum_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, height);
    }
    
    @QtUninvokable
    private native void glRenderbufferStorage_native_GLenum_GLenum_GLsizei_GLsizei(long __this__nativeId, int target, int internalformat, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glRenderbufferStorageMultisample(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param target
     * @param samples
     * @param internalformat
     * @param width
     * @param height
     */
    @QtUninvokable
    public final void glRenderbufferStorageMultisample(int target, int samples, int internalformat, int width, int height){
        glRenderbufferStorageMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, samples, internalformat, width, height);
    }
    
    @QtUninvokable
    private native void glRenderbufferStorageMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei(long __this__nativeId, int target, int samples, int internalformat, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glResumeTransformFeedback()</code></p>
     */
    @QtUninvokable
    public final void glResumeTransformFeedback(){
        glResumeTransformFeedback_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glResumeTransformFeedback_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glSampleCoverage(GLfloat,<wbr/>GLboolean)</code></p>
     * @param value
     * @param invert
     */
    @QtUninvokable
    public final void glSampleCoverage(float value, boolean invert){
        glSampleCoverage_native_GLfloat_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), value, invert);
    }
    
    @QtUninvokable
    private native void glSampleCoverage_native_GLfloat_GLboolean(long __this__nativeId, float value, boolean invert);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glSampleMaski(GLuint,<wbr/>GLbitfield)</code></p>
     * @param index
     * @param mask
     */
    @QtUninvokable
    public final void glSampleMaski(int index, int mask){
        glSampleMaski_native_GLuint_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), index, mask);
    }
    
    @QtUninvokable
    private native void glSampleMaski_native_GLuint_GLbitfield(long __this__nativeId, int index, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glSamplerParameterIiv(GLuint,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     * @param sampler
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glSamplerParameterIiv(int sampler, int pname, java.nio.@Nullable IntBuffer param){
        glSamplerParameterIiv_native_GLuint_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @QtUninvokable
    private native void glSamplerParameterIiv_native_GLuint_GLenum_const_GLint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glSamplerParameterIuiv(GLuint,<wbr/>GLenum,<wbr/>const GLuint*)</code></p>
     * @param sampler
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glSamplerParameterIuiv(int sampler, int pname, java.nio.@Nullable IntBuffer param){
        glSamplerParameterIuiv_native_GLuint_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @QtUninvokable
    private native void glSamplerParameterIuiv_native_GLuint_GLenum_const_GLuint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glSamplerParameterf(GLuint,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     * @param sampler
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glSamplerParameterf(int sampler, int pname, float param){
        glSamplerParameterf_native_GLuint_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @QtUninvokable
    private native void glSamplerParameterf_native_GLuint_GLenum_GLfloat(long __this__nativeId, int sampler, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glSamplerParameterfv(GLuint,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     * @param sampler
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glSamplerParameterfv(int sampler, int pname, java.nio.@Nullable FloatBuffer param){
        glSamplerParameterfv_native_GLuint_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @QtUninvokable
    private native void glSamplerParameterfv_native_GLuint_GLenum_const_GLfloat_ptr(long __this__nativeId, int sampler, int pname, java.nio.FloatBuffer param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glSamplerParameteri(GLuint,<wbr/>GLenum,<wbr/>GLint)</code></p>
     * @param sampler
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glSamplerParameteri(int sampler, int pname, int param){
        glSamplerParameteri_native_GLuint_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @QtUninvokable
    private native void glSamplerParameteri_native_GLuint_GLenum_GLint(long __this__nativeId, int sampler, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glSamplerParameteriv(GLuint,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     * @param sampler
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glSamplerParameteriv(int sampler, int pname, java.nio.@Nullable IntBuffer param){
        glSamplerParameteriv_native_GLuint_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @QtUninvokable
    private native void glSamplerParameteriv_native_GLuint_GLenum_const_GLint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glScissor(GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param x
     * @param y
     * @param width
     * @param height
     */
    @QtUninvokable
    public final void glScissor(int x, int y, int width, int height){
        glScissor_native_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height);
    }
    
    @QtUninvokable
    private native void glScissor_native_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glScissorArrayv(GLuint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     * @param first
     * @param count
     * @param v
     */
    @QtUninvokable
    public final void glScissorArrayv(int first, int count, java.nio.@Nullable IntBuffer v){
        glScissorArrayv_native_GLuint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), first, count, v);
    }
    
    @QtUninvokable
    private native void glScissorArrayv_native_GLuint_GLsizei_const_GLint_ptr(long __this__nativeId, int first, int count, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glScissorIndexed(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param index
     * @param left
     * @param bottom
     * @param width
     * @param height
     */
    @QtUninvokable
    public final void glScissorIndexed(int index, int left, int bottom, int width, int height){
        glScissorIndexed_native_GLuint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), index, left, bottom, width, height);
    }
    
    @QtUninvokable
    private native void glScissorIndexed_native_GLuint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int index, int left, int bottom, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glScissorIndexedv(GLuint,<wbr/>const GLint*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glScissorIndexedv(int index, java.nio.@Nullable IntBuffer v){
        glScissorIndexedv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glScissorIndexedv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glShaderBinary(GLsizei,<wbr/>const GLuint*,<wbr/>GLenum,<wbr/>const GLvoid*,<wbr/>GLsizei)</code></p>
     * @param count
     * @param shaders
     * @param binaryformat
     * @param binary
     * @param length
     */
    @QtUninvokable
    public final void glShaderBinary(int count, java.nio.@Nullable IntBuffer shaders, int binaryformat, java.nio.@Nullable Buffer binary, int length){
        glShaderBinary_native_GLsizei_const_GLuint_ptr_GLenum_const_GLvoid_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), count, shaders, binaryformat, binary, length);
    }
    
    @QtUninvokable
    private native void glShaderBinary_native_GLsizei_const_GLuint_ptr_GLenum_const_GLvoid_ptr_GLsizei(long __this__nativeId, int count, java.nio.IntBuffer shaders, int binaryformat, java.nio.Buffer binary, int length);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glShaderSource(GLuint,<wbr/>GLsizei,<wbr/>const GLchar*const*,<wbr/>const GLint*)</code></p>
     * @param shader
     * @param string
     * @param length
     */
    @QtUninvokable
    public final void glShaderSource(int shader, java.lang.String[] string, java.nio.@Nullable IntBuffer length){
        glShaderSource_native_GLuint_GLsizei_const_GLchar_cptr_ptr_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, string, length);
    }
    
    @QtUninvokable
    private native void glShaderSource_native_GLuint_GLsizei_const_GLchar_cptr_ptr_const_GLint_ptr(long __this__nativeId, int shader, java.lang.String[] string, java.nio.IntBuffer length);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glShaderStorageBlockBinding(GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     * @param program
     * @param storageBlockIndex
     * @param storageBlockBinding
     */
    @QtUninvokable
    public final void glShaderStorageBlockBinding(int program, int storageBlockIndex, int storageBlockBinding){
        glShaderStorageBlockBinding_native_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, storageBlockIndex, storageBlockBinding);
    }
    
    @QtUninvokable
    private native void glShaderStorageBlockBinding_native_GLuint_GLuint_GLuint(long __this__nativeId, int program, int storageBlockIndex, int storageBlockBinding);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glStencilFunc(GLenum,<wbr/>GLint,<wbr/>GLuint)</code></p>
     * @param func
     * @param ref
     * @param mask
     */
    @QtUninvokable
    public final void glStencilFunc(int func, int ref, int mask){
        glStencilFunc_native_GLenum_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), func, ref, mask);
    }
    
    @QtUninvokable
    private native void glStencilFunc_native_GLenum_GLint_GLuint(long __this__nativeId, int func, int ref, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glStencilFuncSeparate(GLenum,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLuint)</code></p>
     * @param face
     * @param func
     * @param ref
     * @param mask
     */
    @QtUninvokable
    public final void glStencilFuncSeparate(int face, int func, int ref, int mask){
        glStencilFuncSeparate_native_GLenum_GLenum_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), face, func, ref, mask);
    }
    
    @QtUninvokable
    private native void glStencilFuncSeparate_native_GLenum_GLenum_GLint_GLuint(long __this__nativeId, int face, int func, int ref, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glStencilMask(GLuint)</code></p>
     * @param mask
     */
    @QtUninvokable
    public final void glStencilMask(int mask){
        glStencilMask_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glStencilMask_native_GLuint(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glStencilMaskSeparate(GLenum,<wbr/>GLuint)</code></p>
     * @param face
     * @param mask
     */
    @QtUninvokable
    public final void glStencilMaskSeparate(int face, int mask){
        glStencilMaskSeparate_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), face, mask);
    }
    
    @QtUninvokable
    private native void glStencilMaskSeparate_native_GLenum_GLuint(long __this__nativeId, int face, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glStencilOp(GLenum,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     * @param fail
     * @param zfail
     * @param zpass
     */
    @QtUninvokable
    public final void glStencilOp(int fail, int zfail, int zpass){
        glStencilOp_native_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), fail, zfail, zpass);
    }
    
    @QtUninvokable
    private native void glStencilOp_native_GLenum_GLenum_GLenum(long __this__nativeId, int fail, int zfail, int zpass);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glStencilOpSeparate(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     * @param face
     * @param sfail
     * @param dpfail
     * @param dppass
     */
    @QtUninvokable
    public final void glStencilOpSeparate(int face, int sfail, int dpfail, int dppass){
        glStencilOpSeparate_native_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, sfail, dpfail, dppass);
    }
    
    @QtUninvokable
    private native void glStencilOpSeparate_native_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int face, int sfail, int dpfail, int dppass);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTexBuffer(GLenum,<wbr/>GLenum,<wbr/>GLuint)</code></p>
     * @param target
     * @param internalformat
     * @param buffer
     */
    @QtUninvokable
    public final void glTexBuffer(int target, int internalformat, int buffer){
        glTexBuffer_native_GLenum_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, buffer);
    }
    
    @QtUninvokable
    private native void glTexBuffer_native_GLenum_GLenum_GLuint(long __this__nativeId, int target, int internalformat, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTexBufferRange(GLenum,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLintptr,<wbr/>GLsizeiptr)</code></p>
     * @param target
     * @param internalformat
     * @param buffer
     * @param offset
     * @param size
     */
    @QtUninvokable
    public final void glTexBufferRange(int target, int internalformat, int buffer, long offset, long size){
        glTexBufferRange_native_GLenum_GLenum_GLuint_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, buffer, offset, size);
    }
    
    @QtUninvokable
    private native void glTexBufferRange_native_GLenum_GLenum_GLuint_GLintptr_GLsizeiptr(long __this__nativeId, int target, int internalformat, int buffer, long offset, long size);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTexImage1D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param internalformat
     * @param width
     * @param border
     * @param format
     * @param type
     * @param pixels
     */
    @QtUninvokable
    public final void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexImage1D_native_GLenum_GLint_GLint_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, border, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexImage1D_native_GLenum_GLint_GLint_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int border, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTexImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param internalformat
     * @param width
     * @param height
     * @param border
     * @param format
     * @param type
     * @param pixels
     */
    @QtUninvokable
    public final void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexImage2D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, border, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexImage2D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int border, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTexImage2DMultisample(GLenum,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLboolean)</code></p>
     * @param target
     * @param samples
     * @param internalformat
     * @param width
     * @param height
     * @param fixedsamplelocations
     */
    @QtUninvokable
    public final void glTexImage2DMultisample(int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations){
        glTexImage2DMultisample_native_GLenum_GLsizei_GLint_GLsizei_GLsizei_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, samples, internalformat, width, height, fixedsamplelocations);
    }
    
    @QtUninvokable
    private native void glTexImage2DMultisample_native_GLenum_GLsizei_GLint_GLsizei_GLsizei_GLboolean(long __this__nativeId, int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTexImage3D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param internalformat
     * @param width
     * @param height
     * @param depth
     * @param border
     * @param format
     * @param type
     * @param pixels
     */
    @QtUninvokable
    public final void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexImage3D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, depth, border, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexImage3D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTexImage3DMultisample(GLenum,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLboolean)</code></p>
     * @param target
     * @param samples
     * @param internalformat
     * @param width
     * @param height
     * @param depth
     * @param fixedsamplelocations
     */
    @QtUninvokable
    public final void glTexImage3DMultisample(int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations){
        glTexImage3DMultisample_native_GLenum_GLsizei_GLint_GLsizei_GLsizei_GLsizei_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, samples, internalformat, width, height, depth, fixedsamplelocations);
    }
    
    @QtUninvokable
    private native void glTexImage3DMultisample_native_GLenum_GLsizei_GLint_GLsizei_GLsizei_GLsizei_GLboolean(long __this__nativeId, int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTexParameterIiv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glTexParameterIiv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glTexParameterIiv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameterIiv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTexParameterIuiv(GLenum,<wbr/>GLenum,<wbr/>const GLuint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glTexParameterIuiv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glTexParameterIuiv_native_GLenum_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameterIuiv_native_GLenum_GLenum_const_GLuint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTexParameterf(GLenum,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     * @param target
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glTexParameterf(int target, int pname, float param){
        glTexParameterf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexParameterf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int target, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTexParameterfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glTexParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glTexParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTexParameteri(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     * @param target
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glTexParameteri(int target, int pname, int param){
        glTexParameteri_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexParameteri_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTexParameteriv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glTexParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glTexParameteriv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameteriv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTexStorage1D(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei)</code></p>
     * @param target
     * @param levels
     * @param internalformat
     * @param width
     */
    @QtUninvokable
    public final void glTexStorage1D(int target, int levels, int internalformat, int width){
        glTexStorage1D_native_GLenum_GLsizei_GLenum_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, levels, internalformat, width);
    }
    
    @QtUninvokable
    private native void glTexStorage1D_native_GLenum_GLsizei_GLenum_GLsizei(long __this__nativeId, int target, int levels, int internalformat, int width);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTexStorage2D(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param target
     * @param levels
     * @param internalformat
     * @param width
     * @param height
     */
    @QtUninvokable
    public final void glTexStorage2D(int target, int levels, int internalformat, int width, int height){
        glTexStorage2D_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, levels, internalformat, width, height);
    }
    
    @QtUninvokable
    private native void glTexStorage2D_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei(long __this__nativeId, int target, int levels, int internalformat, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTexStorage2DMultisample(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLboolean)</code></p>
     * @param target
     * @param samples
     * @param internalformat
     * @param width
     * @param height
     * @param fixedsamplelocations
     */
    @QtUninvokable
    public final void glTexStorage2DMultisample(int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations){
        glTexStorage2DMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, samples, internalformat, width, height, fixedsamplelocations);
    }
    
    @QtUninvokable
    private native void glTexStorage2DMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLboolean(long __this__nativeId, int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTexStorage3D(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param target
     * @param levels
     * @param internalformat
     * @param width
     * @param height
     * @param depth
     */
    @QtUninvokable
    public final void glTexStorage3D(int target, int levels, int internalformat, int width, int height, int depth){
        glTexStorage3D_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, levels, internalformat, width, height, depth);
    }
    
    @QtUninvokable
    private native void glTexStorage3D_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLsizei(long __this__nativeId, int target, int levels, int internalformat, int width, int height, int depth);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTexStorage3DMultisample(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLboolean)</code></p>
     * @param target
     * @param samples
     * @param internalformat
     * @param width
     * @param height
     * @param depth
     * @param fixedsamplelocations
     */
    @QtUninvokable
    public final void glTexStorage3DMultisample(int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations){
        glTexStorage3DMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLsizei_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, samples, internalformat, width, height, depth, fixedsamplelocations);
    }
    
    @QtUninvokable
    private native void glTexStorage3DMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLsizei_GLboolean(long __this__nativeId, int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTexSubImage1D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param xoffset
     * @param width
     * @param format
     * @param type
     * @param pixels
     */
    @QtUninvokable
    public final void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, width, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int width, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTexSubImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param xoffset
     * @param yoffset
     * @param width
     * @param height
     * @param format
     * @param type
     * @param pixels
     */
    @QtUninvokable
    public final void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, width, height, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTexSubImage3D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param xoffset
     * @param yoffset
     * @param zoffset
     * @param width
     * @param height
     * @param depth
     * @param format
     * @param type
     * @param pixels
     */
    @QtUninvokable
    public final void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTextureView(GLuint,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     * @param texture
     * @param target
     * @param origtexture
     * @param internalformat
     * @param minlevel
     * @param numlevels
     * @param minlayer
     * @param numlayers
     */
    @QtUninvokable
    public final void glTextureView(int texture, int target, int origtexture, int internalformat, int minlevel, int numlevels, int minlayer, int numlayers){
        glTextureView_native_GLuint_GLenum_GLuint_GLenum_GLuint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), texture, target, origtexture, internalformat, minlevel, numlevels, minlayer, numlayers);
    }
    
    @QtUninvokable
    private native void glTextureView_native_GLuint_GLenum_GLuint_GLenum_GLuint_GLuint_GLuint_GLuint(long __this__nativeId, int texture, int target, int origtexture, int internalformat, int minlevel, int numlevels, int minlayer, int numlayers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glTransformFeedbackVaryings(GLuint,<wbr/>GLsizei,<wbr/>const GLchar*const*,<wbr/>GLenum)</code></p>
     * @param program
     * @param varyings
     * @param bufferMode
     */
    @QtUninvokable
    public final void glTransformFeedbackVaryings(int program, java.lang.String[] varyings, int bufferMode){
        glTransformFeedbackVaryings_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), program, varyings, bufferMode);
    }
    
    @QtUninvokable
    private native void glTransformFeedbackVaryings_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLenum(long __this__nativeId, int program, java.lang.String[] varyings, int bufferMode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform1d(GLint,<wbr/>GLdouble)</code></p>
     * @param location
     * @param x
     */
    @QtUninvokable
    public final void glUniform1d(int location, double x){
        glUniform1d_native_GLint_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), location, x);
    }
    
    @QtUninvokable
    private native void glUniform1d_native_GLint_GLdouble(long __this__nativeId, int location, double x);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform1dv(GLint,<wbr/>GLsizei,<wbr/>const GLdouble*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform1dv(int location, int count, java.nio.@Nullable DoubleBuffer value){
        glUniform1dv_native_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform1dv_native_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int location, int count, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform1f(GLint,<wbr/>GLfloat)</code></p>
     * @param location
     * @param v0
     */
    @QtUninvokable
    public final void glUniform1f(int location, float v0){
        glUniform1f_native_GLint_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0);
    }
    
    @QtUninvokable
    private native void glUniform1f_native_GLint_GLfloat(long __this__nativeId, int location, float v0);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform1fv(GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform1fv(int location, int count, java.nio.@Nullable FloatBuffer value){
        glUniform1fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform1fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform1i(GLint,<wbr/>GLint)</code></p>
     * @param location
     * @param v0
     */
    @QtUninvokable
    public final void glUniform1i(int location, int v0){
        glUniform1i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0);
    }
    
    @QtUninvokable
    private native void glUniform1i_native_GLint_GLint(long __this__nativeId, int location, int v0);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform1iv(GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform1iv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform1iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform1iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform1ui(GLint,<wbr/>GLuint)</code></p>
     * @param location
     * @param v0
     */
    @QtUninvokable
    public final void glUniform1ui(int location, int v0){
        glUniform1ui_native_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0);
    }
    
    @QtUninvokable
    private native void glUniform1ui_native_GLint_GLuint(long __this__nativeId, int location, int v0);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform1uiv(GLint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform1uiv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform1uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform1uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform2d(GLint,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param location
     * @param x
     * @param y
     */
    @QtUninvokable
    public final void glUniform2d(int location, double x, double y){
        glUniform2d_native_GLint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y);
    }
    
    @QtUninvokable
    private native void glUniform2d_native_GLint_GLdouble_GLdouble(long __this__nativeId, int location, double x, double y);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform2dv(GLint,<wbr/>GLsizei,<wbr/>const GLdouble*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform2dv(int location, int count, java.nio.@Nullable DoubleBuffer value){
        glUniform2dv_native_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform2dv_native_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int location, int count, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform2f(GLint,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param location
     * @param v0
     * @param v1
     */
    @QtUninvokable
    public final void glUniform2f(int location, float v0, float v1){
        glUniform2f_native_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1);
    }
    
    @QtUninvokable
    private native void glUniform2f_native_GLint_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform2fv(GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform2fv(int location, int count, java.nio.@Nullable FloatBuffer value){
        glUniform2fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform2fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform2i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param location
     * @param v0
     * @param v1
     */
    @QtUninvokable
    public final void glUniform2i(int location, int v0, int v1){
        glUniform2i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1);
    }
    
    @QtUninvokable
    private native void glUniform2i_native_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform2iv(GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform2iv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform2iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform2iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform2ui(GLint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     * @param location
     * @param v0
     * @param v1
     */
    @QtUninvokable
    public final void glUniform2ui(int location, int v0, int v1){
        glUniform2ui_native_GLint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1);
    }
    
    @QtUninvokable
    private native void glUniform2ui_native_GLint_GLuint_GLuint(long __this__nativeId, int location, int v0, int v1);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform2uiv(GLint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform2uiv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform2uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform2uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform3d(GLint,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param location
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glUniform3d(int location, double x, double y, double z){
        glUniform3d_native_GLint_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z);
    }
    
    @QtUninvokable
    private native void glUniform3d_native_GLint_GLdouble_GLdouble_GLdouble(long __this__nativeId, int location, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform3dv(GLint,<wbr/>GLsizei,<wbr/>const GLdouble*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform3dv(int location, int count, java.nio.@Nullable DoubleBuffer value){
        glUniform3dv_native_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform3dv_native_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int location, int count, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform3f(GLint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param location
     * @param v0
     * @param v1
     * @param v2
     */
    @QtUninvokable
    public final void glUniform3f(int location, float v0, float v1, float v2){
        glUniform3f_native_GLint_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glUniform3f_native_GLint_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1, float v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform3fv(GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform3fv(int location, int count, java.nio.@Nullable FloatBuffer value){
        glUniform3fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform3fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform3i(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param location
     * @param v0
     * @param v1
     * @param v2
     */
    @QtUninvokable
    public final void glUniform3i(int location, int v0, int v1, int v2){
        glUniform3i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glUniform3i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1, int v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform3iv(GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform3iv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform3iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform3iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform3ui(GLint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     * @param location
     * @param v0
     * @param v1
     * @param v2
     */
    @QtUninvokable
    public final void glUniform3ui(int location, int v0, int v1, int v2){
        glUniform3ui_native_GLint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glUniform3ui_native_GLint_GLuint_GLuint_GLuint(long __this__nativeId, int location, int v0, int v1, int v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform3uiv(GLint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform3uiv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform3uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform3uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform4d(GLint,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param location
     * @param x
     * @param y
     * @param z
     * @param w
     */
    @QtUninvokable
    public final void glUniform4d(int location, double x, double y, double z, double w){
        glUniform4d_native_GLint_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glUniform4d_native_GLint_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, int location, double x, double y, double z, double w);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform4dv(GLint,<wbr/>GLsizei,<wbr/>const GLdouble*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform4dv(int location, int count, java.nio.@Nullable DoubleBuffer value){
        glUniform4dv_native_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform4dv_native_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int location, int count, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform4f(GLint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param location
     * @param v0
     * @param v1
     * @param v2
     * @param v3
     */
    @QtUninvokable
    public final void glUniform4f(int location, float v0, float v1, float v2, float v3){
        glUniform4f_native_GLint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glUniform4f_native_GLint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1, float v2, float v3);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform4fv(GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform4fv(int location, int count, java.nio.@Nullable FloatBuffer value){
        glUniform4fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform4fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform4i(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param location
     * @param v0
     * @param v1
     * @param v2
     * @param v3
     */
    @QtUninvokable
    public final void glUniform4i(int location, int v0, int v1, int v2, int v3){
        glUniform4i_native_GLint_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glUniform4i_native_GLint_GLint_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1, int v2, int v3);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform4iv(GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform4iv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform4iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform4iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform4ui(GLint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     * @param location
     * @param v0
     * @param v1
     * @param v2
     * @param v3
     */
    @QtUninvokable
    public final void glUniform4ui(int location, int v0, int v1, int v2, int v3){
        glUniform4ui_native_GLint_GLuint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glUniform4ui_native_GLint_GLuint_GLuint_GLuint_GLuint(long __this__nativeId, int location, int v0, int v1, int v2, int v3);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniform4uiv(GLint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform4uiv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform4uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform4uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniformBlockBinding(GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     * @param program
     * @param uniformBlockIndex
     * @param uniformBlockBinding
     */
    @QtUninvokable
    public final void glUniformBlockBinding(int program, int uniformBlockIndex, int uniformBlockBinding){
        glUniformBlockBinding_native_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockIndex, uniformBlockBinding);
    }
    
    @QtUninvokable
    private native void glUniformBlockBinding_native_GLuint_GLuint_GLuint(long __this__nativeId, int program, int uniformBlockIndex, int uniformBlockBinding);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniformMatrix2dv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix2dv(int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glUniformMatrix2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniformMatrix2fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix2fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniformMatrix2x3dv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix2x3dv(int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glUniformMatrix2x3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2x3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniformMatrix2x3fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix2x3fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix2x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniformMatrix2x4dv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix2x4dv(int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glUniformMatrix2x4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2x4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniformMatrix2x4fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix2x4fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix2x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniformMatrix3dv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix3dv(int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glUniformMatrix3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniformMatrix3fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix3fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniformMatrix3x2dv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix3x2dv(int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glUniformMatrix3x2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3x2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniformMatrix3x2fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix3x2fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix3x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniformMatrix3x4dv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix3x4dv(int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glUniformMatrix3x4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3x4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniformMatrix3x4fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix3x4fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix3x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniformMatrix4dv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix4dv(int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glUniformMatrix4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniformMatrix4fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix4fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniformMatrix4x2dv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix4x2dv(int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glUniformMatrix4x2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4x2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniformMatrix4x2fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix4x2fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix4x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniformMatrix4x3dv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix4x3dv(int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glUniformMatrix4x3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4x3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniformMatrix4x3fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix4x3fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix4x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUniformSubroutinesuiv(GLenum,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     * @param shadertype
     * @param count
     * @param indices
     */
    @QtUninvokable
    public final void glUniformSubroutinesuiv(int shadertype, int count, java.nio.@Nullable IntBuffer indices){
        glUniformSubroutinesuiv_native_GLenum_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shadertype, count, indices);
    }
    
    @QtUninvokable
    private native void glUniformSubroutinesuiv_native_GLenum_GLsizei_const_GLuint_ptr(long __this__nativeId, int shadertype, int count, java.nio.IntBuffer indices);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUnmapBuffer(GLenum)</code></p>
     * @param target
     * @return
     */
    @QtUninvokable
    public final boolean glUnmapBuffer(int target){
        return glUnmapBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native boolean glUnmapBuffer_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUseProgram(GLuint)</code></p>
     * @param program
     */
    @QtUninvokable
    public final void glUseProgram(int program){
        glUseProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glUseProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glUseProgramStages(GLuint,<wbr/>GLbitfield,<wbr/>GLuint)</code></p>
     * @param pipeline
     * @param stages
     * @param program
     */
    @QtUninvokable
    public final void glUseProgramStages(int pipeline, int stages, int program){
        glUseProgramStages_native_GLuint_GLbitfield_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), pipeline, stages, program);
    }
    
    @QtUninvokable
    private native void glUseProgramStages_native_GLuint_GLbitfield_GLuint(long __this__nativeId, int pipeline, int stages, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glValidateProgram(GLuint)</code></p>
     * @param program
     */
    @QtUninvokable
    public final void glValidateProgram(int program){
        glValidateProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glValidateProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glValidateProgramPipeline(GLuint)</code></p>
     * @param pipeline
     */
    @QtUninvokable
    public final void glValidateProgramPipeline(int pipeline){
        glValidateProgramPipeline_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), pipeline);
    }
    
    @QtUninvokable
    private native void glValidateProgramPipeline_native_GLuint(long __this__nativeId, int pipeline);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribBinding(GLuint,<wbr/>GLuint)</code></p>
     * @param attribindex
     * @param bindingindex
     */
    @QtUninvokable
    public final void glVertexAttribBinding(int attribindex, int bindingindex){
        glVertexAttribBinding_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), attribindex, bindingindex);
    }
    
    @QtUninvokable
    private native void glVertexAttribBinding_native_GLuint_GLuint(long __this__nativeId, int attribindex, int bindingindex);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribDivisor(GLuint,<wbr/>GLuint)</code></p>
     * @param index
     * @param divisor
     */
    @QtUninvokable
    public final void glVertexAttribDivisor(int index, int divisor){
        glVertexAttribDivisor_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, divisor);
    }
    
    @QtUninvokable
    private native void glVertexAttribDivisor_native_GLuint_GLuint(long __this__nativeId, int index, int divisor);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribFormat(GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>GLuint)</code></p>
     * @param attribindex
     * @param size
     * @param type
     * @param normalized
     * @param relativeoffset
     */
    @QtUninvokable
    public final void glVertexAttribFormat(int attribindex, int size, int type, boolean normalized, int relativeoffset){
        glVertexAttribFormat_native_GLuint_GLint_GLenum_GLboolean_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), attribindex, size, type, normalized, relativeoffset);
    }
    
    @QtUninvokable
    private native void glVertexAttribFormat_native_GLuint_GLint_GLenum_GLboolean_GLuint(long __this__nativeId, int attribindex, int size, int type, boolean normalized, int relativeoffset);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribIFormat(GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLuint)</code></p>
     * @param attribindex
     * @param size
     * @param type
     * @param relativeoffset
     */
    @QtUninvokable
    public final void glVertexAttribIFormat(int attribindex, int size, int type, int relativeoffset){
        glVertexAttribIFormat_native_GLuint_GLint_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), attribindex, size, type, relativeoffset);
    }
    
    @QtUninvokable
    private native void glVertexAttribIFormat_native_GLuint_GLint_GLenum_GLuint(long __this__nativeId, int attribindex, int size, int type, int relativeoffset);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribIPointer(GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param index
     * @param size
     * @param type
     * @param stride
     * @param pointer
     */
    @QtUninvokable
    public final void glVertexAttribIPointer(int index, int size, int type, int stride, java.nio.@Nullable Buffer pointer){
        glVertexAttribIPointer_native_GLuint_GLint_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, size, type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glVertexAttribIPointer_native_GLuint_GLint_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int index, int size, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribL1d(GLuint,<wbr/>GLdouble)</code></p>
     * @param index
     * @param x
     */
    @QtUninvokable
    public final void glVertexAttribL1d(int index, double x){
        glVertexAttribL1d_native_GLuint_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @QtUninvokable
    private native void glVertexAttribL1d_native_GLuint_GLdouble(long __this__nativeId, int index, double x);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribL1dv(GLuint,<wbr/>const GLdouble*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttribL1dv(int index, java.nio.@Nullable DoubleBuffer v){
        glVertexAttribL1dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribL1dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribL2d(GLuint,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param index
     * @param x
     * @param y
     */
    @QtUninvokable
    public final void glVertexAttribL2d(int index, double x, double y){
        glVertexAttribL2d_native_GLuint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @QtUninvokable
    private native void glVertexAttribL2d_native_GLuint_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribL2dv(GLuint,<wbr/>const GLdouble*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttribL2dv(int index, java.nio.@Nullable DoubleBuffer v){
        glVertexAttribL2dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribL2dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribL3d(GLuint,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param index
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glVertexAttribL3d(int index, double x, double y, double z){
        glVertexAttribL3d_native_GLuint_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @QtUninvokable
    private native void glVertexAttribL3d_native_GLuint_GLdouble_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribL3dv(GLuint,<wbr/>const GLdouble*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttribL3dv(int index, java.nio.@Nullable DoubleBuffer v){
        glVertexAttribL3dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribL3dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribL4d(GLuint,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param index
     * @param x
     * @param y
     * @param z
     * @param w
     */
    @QtUninvokable
    public final void glVertexAttribL4d(int index, double x, double y, double z, double w){
        glVertexAttribL4d_native_GLuint_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertexAttribL4d_native_GLuint_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y, double z, double w);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribL4dv(GLuint,<wbr/>const GLdouble*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttribL4dv(int index, java.nio.@Nullable DoubleBuffer v){
        glVertexAttribL4dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribL4dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribLFormat(GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLuint)</code></p>
     * @param attribindex
     * @param size
     * @param type
     * @param relativeoffset
     */
    @QtUninvokable
    public final void glVertexAttribLFormat(int attribindex, int size, int type, int relativeoffset){
        glVertexAttribLFormat_native_GLuint_GLint_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), attribindex, size, type, relativeoffset);
    }
    
    @QtUninvokable
    private native void glVertexAttribLFormat_native_GLuint_GLint_GLenum_GLuint(long __this__nativeId, int attribindex, int size, int type, int relativeoffset);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribLPointer(GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param index
     * @param size
     * @param type
     * @param stride
     * @param pointer
     */
    @QtUninvokable
    public final void glVertexAttribLPointer(int index, int size, int type, int stride, java.nio.@Nullable Buffer pointer){
        glVertexAttribLPointer_native_GLuint_GLint_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, size, type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glVertexAttribLPointer_native_GLuint_GLint_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int index, int size, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribP1ui(GLuint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>GLuint)</code></p>
     * @param index
     * @param type
     * @param normalized
     * @param value
     */
    @QtUninvokable
    public final void glVertexAttribP1ui(int index, int type, boolean normalized, int value){
        glVertexAttribP1ui_native_GLuint_GLenum_GLboolean_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP1ui_native_GLuint_GLenum_GLboolean_GLuint(long __this__nativeId, int index, int type, boolean normalized, int value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribP1uiv(GLuint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>const GLuint*)</code></p>
     * @param index
     * @param type
     * @param normalized
     * @param value
     */
    @QtUninvokable
    public final void glVertexAttribP1uiv(int index, int type, boolean normalized, java.nio.@Nullable IntBuffer value){
        glVertexAttribP1uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP1uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(long __this__nativeId, int index, int type, boolean normalized, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribP2ui(GLuint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>GLuint)</code></p>
     * @param index
     * @param type
     * @param normalized
     * @param value
     */
    @QtUninvokable
    public final void glVertexAttribP2ui(int index, int type, boolean normalized, int value){
        glVertexAttribP2ui_native_GLuint_GLenum_GLboolean_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP2ui_native_GLuint_GLenum_GLboolean_GLuint(long __this__nativeId, int index, int type, boolean normalized, int value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribP2uiv(GLuint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>const GLuint*)</code></p>
     * @param index
     * @param type
     * @param normalized
     * @param value
     */
    @QtUninvokable
    public final void glVertexAttribP2uiv(int index, int type, boolean normalized, java.nio.@Nullable IntBuffer value){
        glVertexAttribP2uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP2uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(long __this__nativeId, int index, int type, boolean normalized, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribP3ui(GLuint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>GLuint)</code></p>
     * @param index
     * @param type
     * @param normalized
     * @param value
     */
    @QtUninvokable
    public final void glVertexAttribP3ui(int index, int type, boolean normalized, int value){
        glVertexAttribP3ui_native_GLuint_GLenum_GLboolean_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP3ui_native_GLuint_GLenum_GLboolean_GLuint(long __this__nativeId, int index, int type, boolean normalized, int value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribP3uiv(GLuint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>const GLuint*)</code></p>
     * @param index
     * @param type
     * @param normalized
     * @param value
     */
    @QtUninvokable
    public final void glVertexAttribP3uiv(int index, int type, boolean normalized, java.nio.@Nullable IntBuffer value){
        glVertexAttribP3uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP3uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(long __this__nativeId, int index, int type, boolean normalized, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribP4ui(GLuint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>GLuint)</code></p>
     * @param index
     * @param type
     * @param normalized
     * @param value
     */
    @QtUninvokable
    public final void glVertexAttribP4ui(int index, int type, boolean normalized, int value){
        glVertexAttribP4ui_native_GLuint_GLenum_GLboolean_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP4ui_native_GLuint_GLenum_GLboolean_GLuint(long __this__nativeId, int index, int type, boolean normalized, int value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribP4uiv(GLuint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>const GLuint*)</code></p>
     * @param index
     * @param type
     * @param normalized
     * @param value
     */
    @QtUninvokable
    public final void glVertexAttribP4uiv(int index, int type, boolean normalized, java.nio.@Nullable IntBuffer value){
        glVertexAttribP4uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP4uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(long __this__nativeId, int index, int type, boolean normalized, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexAttribPointer(GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param index
     * @param size
     * @param type
     * @param normalized
     * @param stride
     * @param pointer
     */
    @QtUninvokable
    public final void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, java.nio.@Nullable Buffer pointer){
        glVertexAttribPointer_native_GLuint_GLint_GLenum_GLboolean_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, size, type, normalized, stride, pointer);
    }
    
    @QtUninvokable
    private native void glVertexAttribPointer_native_GLuint_GLint_GLenum_GLboolean_GLsizei_const_GLvoid_ptr(long __this__nativeId, int index, int size, int type, boolean normalized, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glVertexBindingDivisor(GLuint,<wbr/>GLuint)</code></p>
     * @param bindingindex
     * @param divisor
     */
    @QtUninvokable
    public final void glVertexBindingDivisor(int bindingindex, int divisor){
        glVertexBindingDivisor_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), bindingindex, divisor);
    }
    
    @QtUninvokable
    private native void glVertexBindingDivisor_native_GLuint_GLuint(long __this__nativeId, int bindingindex, int divisor);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glViewport(GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param x
     * @param y
     * @param width
     * @param height
     */
    @QtUninvokable
    public final void glViewport(int x, int y, int width, int height){
        glViewport_native_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height);
    }
    
    @QtUninvokable
    private native void glViewport_native_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glViewportArrayv(GLuint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     * @param first
     * @param count
     * @param v
     */
    @QtUninvokable
    public final void glViewportArrayv(int first, int count, java.nio.@Nullable FloatBuffer v){
        glViewportArrayv_native_GLuint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), first, count, v);
    }
    
    @QtUninvokable
    private native void glViewportArrayv_native_GLuint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int first, int count, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glViewportIndexedf(GLuint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param index
     * @param x
     * @param y
     * @param w
     * @param h
     */
    @QtUninvokable
    public final void glViewportIndexedf(int index, float x, float y, float w, float h){
        glViewportIndexedf_native_GLuint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, w, h);
    }
    
    @QtUninvokable
    private native void glViewportIndexedf_native_GLuint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int index, float x, float y, float w, float h);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glViewportIndexedfv(GLuint,<wbr/>const GLfloat*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glViewportIndexedfv(int index, java.nio.@Nullable FloatBuffer v){
        glViewportIndexedfv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glViewportIndexedfv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_3_Core::<wbr/>glWaitSync(GLsync,<wbr/>GLbitfield,<wbr/>GLuint64)</code></p>
     * @param sync
     * @param flags
     * @param timeout
     */
    @QtUninvokable
    public final void glWaitSync(io.qt.gui.gl.@Nullable GLsync sync, int flags, long timeout){
        glWaitSync_native___GLsync_ptr_GLbitfield_GLuint64(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync), flags, timeout);
    }
    
    @QtUninvokable
    private native void glWaitSync_native___GLsync_ptr_GLbitfield_GLuint64(long __this__nativeId, long sync, int flags, long timeout);
    
    /**
     * <p>See <code>QAbstractOpenGLFunctions::<wbr/>initializeOpenGLFunctions()</code></p>
     * @return
     */
    @QtUninvokable
    @Override
    public boolean initializeOpenGLFunctions(){
        return initializeOpenGLFunctions_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean initializeOpenGLFunctions_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QOpenGLFunctions_4_3_Core(QPrivateConstructor p) { super(p); } 
    
}
