package io.qt.opengl;

import io.qt.*;


/**
 * <p>Functions for creating and managing OpenGL buffer objects</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qopenglbuffer.html">QOpenGLBuffer</a></code></p>
 */
public class QOpenGLBuffer extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#Access-enum">QOpenGLBuffer::Access</a></code></p>
     */
    public enum Access implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#Access-enum">QOpenGLBuffer::<wbr/>ReadOnly</a></code></p>
         */
        ReadOnly(35000),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#Access-enum">QOpenGLBuffer::<wbr/>WriteOnly</a></code></p>
         */
        WriteOnly(35001),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#Access-enum">QOpenGLBuffer::<wbr/>ReadWrite</a></code></p>
         */
        ReadWrite(35002);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Access(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Access resolve(int value) {
            switch (value) {
            case 35000: return ReadOnly;
            case 35001: return WriteOnly;
            case 35002: return ReadWrite;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#RangeAccessFlag-enum">QOpenGLBuffer::RangeAccessFlag</a></code></p>
     * 
     * @see RangeAccessFlags
     */
    public enum RangeAccessFlag implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#RangeAccessFlag-enum">QOpenGLBuffer::<wbr/>RangeRead</a></code></p>
         */
        RangeRead(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#RangeAccessFlag-enum">QOpenGLBuffer::<wbr/>RangeWrite</a></code></p>
         */
        RangeWrite(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#RangeAccessFlag-enum">QOpenGLBuffer::<wbr/>RangeInvalidate</a></code></p>
         */
        RangeInvalidate(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#RangeAccessFlag-enum">QOpenGLBuffer::<wbr/>RangeInvalidateBuffer</a></code></p>
         */
        RangeInvalidateBuffer(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#RangeAccessFlag-enum">QOpenGLBuffer::<wbr/>RangeFlushExplicit</a></code></p>
         */
        RangeFlushExplicit(16),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#RangeAccessFlag-enum">QOpenGLBuffer::<wbr/>RangeUnsynchronized</a></code></p>
         */
        RangeUnsynchronized(32);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private RangeAccessFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        @Override
        public @NonNull RangeAccessFlags asFlags() {
            return new RangeAccessFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull RangeAccessFlags combined(@NonNull RangeAccessFlag e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull RangeAccessFlags cleared(@NonNull RangeAccessFlag e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link RangeAccessFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull RangeAccessFlags flags(@Nullable RangeAccessFlag @NonNull... values) {
            return new RangeAccessFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull RangeAccessFlag resolve(int value) {
            switch (value) {
            case 1: return RangeRead;
            case 2: return RangeWrite;
            case 4: return RangeInvalidate;
            case 8: return RangeInvalidateBuffer;
            case 16: return RangeFlushExplicit;
            case 32: return RangeUnsynchronized;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link RangeAccessFlag}
     */
    public static final class RangeAccessFlags extends QFlags<RangeAccessFlag> implements Comparable<RangeAccessFlags> {
        private static final long serialVersionUID = 0xc659f859e942b0e3L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new RangeAccessFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public RangeAccessFlags(@Nullable RangeAccessFlag @NonNull... args){
            super(args);
        }

        /**
         * Creates a new RangeAccessFlags with given <code>value</code>.
         * @param value
         */
        public RangeAccessFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new RangeAccessFlags
         */
        @Override
        public final @NonNull RangeAccessFlags combined(@StrictNonNull RangeAccessFlag e){
            return new RangeAccessFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        @Override
        public final @NonNull RangeAccessFlags setFlag(@Nullable RangeAccessFlag e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        @Override
        public final @NonNull RangeAccessFlags setFlag(@Nullable RangeAccessFlag e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this RangeAccessFlags.
         * @return array of enum entries
         */
        @Override
        public final @NonNull RangeAccessFlag @NonNull[] flags(){
            return super.flags(RangeAccessFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull RangeAccessFlags clone(){
            return new RangeAccessFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull RangeAccessFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#Type-enum">QOpenGLBuffer::Type</a></code></p>
     */
    public enum Type implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#Type-enum">QOpenGLBuffer::<wbr/>VertexBuffer</a></code></p>
         */
        VertexBuffer(34962),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#Type-enum">QOpenGLBuffer::<wbr/>IndexBuffer</a></code></p>
         */
        IndexBuffer(34963),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#Type-enum">QOpenGLBuffer::<wbr/>PixelPackBuffer</a></code></p>
         */
        PixelPackBuffer(35051),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#Type-enum">QOpenGLBuffer::<wbr/>PixelUnpackBuffer</a></code></p>
         */
        PixelUnpackBuffer(35052);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Type(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Type resolve(int value) {
            switch (value) {
            case 34962: return VertexBuffer;
            case 34963: return IndexBuffer;
            case 35051: return PixelPackBuffer;
            case 35052: return PixelUnpackBuffer;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#UsagePattern-enum">QOpenGLBuffer::UsagePattern</a></code></p>
     */
    public enum UsagePattern implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#UsagePattern-enum">QOpenGLBuffer::<wbr/>StreamDraw</a></code></p>
         */
        StreamDraw(35040),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#UsagePattern-enum">QOpenGLBuffer::<wbr/>StreamRead</a></code></p>
         */
        StreamRead(35041),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#UsagePattern-enum">QOpenGLBuffer::<wbr/>StreamCopy</a></code></p>
         */
        StreamCopy(35042),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#UsagePattern-enum">QOpenGLBuffer::<wbr/>StaticDraw</a></code></p>
         */
        StaticDraw(35044),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#UsagePattern-enum">QOpenGLBuffer::<wbr/>StaticRead</a></code></p>
         */
        StaticRead(35045),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#UsagePattern-enum">QOpenGLBuffer::<wbr/>StaticCopy</a></code></p>
         */
        StaticCopy(35046),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#UsagePattern-enum">QOpenGLBuffer::<wbr/>DynamicDraw</a></code></p>
         */
        DynamicDraw(35048),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#UsagePattern-enum">QOpenGLBuffer::<wbr/>DynamicRead</a></code></p>
         */
        DynamicRead(35049),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#UsagePattern-enum">QOpenGLBuffer::<wbr/>DynamicCopy</a></code></p>
         */
        DynamicCopy(35050);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private UsagePattern(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull UsagePattern resolve(int value) {
            switch (value) {
            case 35040: return StreamDraw;
            case 35041: return StreamRead;
            case 35042: return StreamCopy;
            case 35044: return StaticDraw;
            case 35045: return StaticRead;
            case 35046: return StaticCopy;
            case 35048: return DynamicDraw;
            case 35049: return DynamicRead;
            case 35050: return DynamicCopy;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#QOpenGLBuffer">QOpenGLBuffer::<wbr/>QOpenGLBuffer()</a></code></p>
     */
    public QOpenGLBuffer(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLBuffer instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#QOpenGLBuffer-3">QOpenGLBuffer::<wbr/>QOpenGLBuffer(QOpenGLBuffer)</a></code></p>
     * @param other
     */
    public QOpenGLBuffer(io.qt.opengl.@NonNull QOpenGLBuffer other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QOpenGLBuffer instance, io.qt.opengl.QOpenGLBuffer other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#QOpenGLBuffer-2">QOpenGLBuffer::<wbr/>QOpenGLBuffer(QOpenGLBuffer::Type)</a></code></p>
     * @param type
     */
    public QOpenGLBuffer(io.qt.opengl.QOpenGLBuffer.@NonNull Type type){
        super((QPrivateConstructor)null);
        initialize_native(this, type);
    }
    
    private native static void initialize_native(QOpenGLBuffer instance, io.qt.opengl.QOpenGLBuffer.Type type);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#allocate">QOpenGLBuffer::<wbr/>allocate(const void*,<wbr/>int)</a></code></p>
     * @param data
     * @param count
     */
    @QtUninvokable
    public final void allocate(java.nio.@Nullable Buffer data, int count){
        allocate_native_const_void_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), data, count);
    }
    
    @QtUninvokable
    private native void allocate_native_const_void_ptr_int(long __this__nativeId, java.nio.Buffer data, int count);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#allocate-1">QOpenGLBuffer::<wbr/>allocate(int)</a></code></p>
     * @param count
     */
    @QtUninvokable
    public final void allocate(int count){
        allocate_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), count);
    }
    
    @QtUninvokable
    private native void allocate_native_int(long __this__nativeId, int count);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#bind">QOpenGLBuffer::<wbr/>bind()</a></code></p>
     * @return
     */
    @QtUninvokable
    public final boolean bind(){
        return bind_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean bind_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#bufferId">QOpenGLBuffer::<wbr/>bufferId()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final int bufferId(){
        return bufferId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int bufferId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#create">QOpenGLBuffer::<wbr/>create()</a></code></p>
     * @return
     */
    @QtUninvokable
    public final boolean create(){
        return create_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean create_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#destroy">QOpenGLBuffer::<wbr/>destroy()</a></code></p>
     */
    @QtUninvokable
    public final void destroy(){
        destroy_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void destroy_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#isCreated">QOpenGLBuffer::<wbr/>isCreated()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final boolean isCreated(){
        return isCreated_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isCreated_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#map">QOpenGLBuffer::<wbr/>map(QOpenGLBuffer::Access)</a></code></p>
     * @param access
     * @return
     */
    @QtUninvokable
    public final java.nio.@Nullable Buffer map(io.qt.opengl.QOpenGLBuffer.@NonNull Access access){
        return map_native_QOpenGLBuffer_Access(QtJambi_LibraryUtilities.internal.nativeId(this), access.value());
    }
    
    @QtUninvokable
    private native java.nio.Buffer map_native_QOpenGLBuffer_Access(long __this__nativeId, int access);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#mapRange">QOpenGLBuffer::<wbr/>mapRange(int,<wbr/>int,<wbr/>QOpenGLBuffer::RangeAccessFlags)</a></code></p>
     * @param offset
     * @param count
     * @param access
     * @return
     */
    @QtUninvokable
    public final java.nio.@Nullable Buffer mapRange(int offset, int count, io.qt.opengl.QOpenGLBuffer.@NonNull RangeAccessFlags access){
        return mapRange_native_int_int_QOpenGLBuffer_RangeAccessFlags(QtJambi_LibraryUtilities.internal.nativeId(this), offset, count, access.value());
    }
    
    @QtUninvokable
    private native java.nio.Buffer mapRange_native_int_int_QOpenGLBuffer_RangeAccessFlags(long __this__nativeId, int offset, int count, int access);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#operator-eq-1">QOpenGLBuffer::<wbr/>operator=(QOpenGLBuffer)</a></code></p>
     * @param other
     */
    @QtUninvokable
    public final void assign(io.qt.opengl.@NonNull QOpenGLBuffer other){
        assign_native_cref_QOpenGLBuffer(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QOpenGLBuffer(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#read">QOpenGLBuffer::<wbr/>read(int,<wbr/>void*,<wbr/>int)</a></code></p>
     * @param offset
     * @param data
     * @param count
     * @return
     */
    @QtUninvokable
    public final boolean read(int offset, java.nio.@Nullable Buffer data, int count){
        return read_native_int_void_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), offset, data, count);
    }
    
    @QtUninvokable
    private native boolean read_native_int_void_ptr_int(long __this__nativeId, int offset, java.nio.Buffer data, int count);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#release">QOpenGLBuffer::<wbr/>release()</a></code></p>
     */
    @QtUninvokable
    public final void release(){
        release_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void release_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#setUsagePattern">QOpenGLBuffer::<wbr/>setUsagePattern(QOpenGLBuffer::UsagePattern)</a></code></p>
     * @param value
     */
    @QtUninvokable
    public final void setUsagePattern(io.qt.opengl.QOpenGLBuffer.@NonNull UsagePattern value){
        setUsagePattern_native_QOpenGLBuffer_UsagePattern(QtJambi_LibraryUtilities.internal.nativeId(this), value.value());
    }
    
    @QtUninvokable
    private native void setUsagePattern_native_QOpenGLBuffer_UsagePattern(long __this__nativeId, int value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#size">QOpenGLBuffer::<wbr/>size()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final int size(){
        return size_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int size_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#swap">QOpenGLBuffer::<wbr/>swap(QOpenGLBuffer&amp;)</a></code></p>
     * @since This function was introduced in Qt 6.5.
     * @param other
     */
    @QtUninvokable
    public final void swap(io.qt.opengl.@StrictNonNull QOpenGLBuffer other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QOpenGLBuffer(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QOpenGLBuffer(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#type">QOpenGLBuffer::<wbr/>type()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLBuffer.@NonNull Type type(){
        return io.qt.opengl.QOpenGLBuffer.Type.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#unmap">QOpenGLBuffer::<wbr/>unmap()</a></code></p>
     * @return
     */
    @QtUninvokable
    public final boolean unmap(){
        return unmap_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean unmap_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#usagePattern">QOpenGLBuffer::<wbr/>usagePattern()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLBuffer.@NonNull UsagePattern usagePattern(){
        return io.qt.opengl.QOpenGLBuffer.UsagePattern.resolve(usagePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int usagePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#write">QOpenGLBuffer::<wbr/>write(int,<wbr/>const void*,<wbr/>int)</a></code></p>
     * @param offset
     * @param data
     * @param count
     */
    @QtUninvokable
    public final void write(int offset, java.nio.@Nullable Buffer data, int count){
        write_native_int_const_void_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), offset, data, count);
    }
    
    @QtUninvokable
    private native void write_native_int_const_void_ptr_int(long __this__nativeId, int offset, java.nio.Buffer data, int count);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#release-1">QOpenGLBuffer::<wbr/>release(QOpenGLBuffer::Type)</a></code></p>
     * @param type
     */
    public static void release(io.qt.opengl.QOpenGLBuffer.@NonNull Type type){
        release_native_QOpenGLBuffer_Type(type.value());
    }
    
    private native static void release_native_QOpenGLBuffer_Type(int type);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QOpenGLBuffer(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="https://doc.qt.io/qt/qopenglbuffer.html#QOpenGLBuffer-3">QOpenGLBuffer::<wbr/>QOpenGLBuffer(QOpenGLBuffer)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QOpenGLBuffer clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QOpenGLBuffer clone_native(long __this_nativeId);
    
    /**
     * <p>Overloaded function for {@link #mapRange(int, int, io.qt.opengl.QOpenGLBuffer.RangeAccessFlags)}.</p>
     */
    @QtUninvokable
    public final java.nio.@Nullable Buffer mapRange(int offset, int count, io.qt.opengl.QOpenGLBuffer.@NonNull RangeAccessFlag @NonNull... access) {
        return mapRange(offset, count, new io.qt.opengl.QOpenGLBuffer.RangeAccessFlags(access));
    }
}
