package io.qt.opengl;

import io.qt.*;


/**
 * <p>All functions for OpenGL 4.5 compatibility profile</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qopenglfunctions-4-5-compatibility.html">QOpenGLFunctions_4_5_Compatibility</a></code></p>
 */
public final class QOpenGLFunctions_4_5_Compatibility extends io.qt.opengl.QAbstractOpenGLFunctions
{
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>QOpenGLFunctions_4_5_Compatibility()</code></p>
     */
    public QOpenGLFunctions_4_5_Compatibility(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLFunctions_4_5_Compatibility instance);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glAccum(GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glAccum(int op, float value){
        glAccum_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), op, value);
    }
    
    @QtUninvokable
    private native void glAccum_native_GLenum_GLfloat(long __this__nativeId, int op, float value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glActiveShaderProgram(GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glActiveShaderProgram(int pipeline, int program){
        glActiveShaderProgram_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), pipeline, program);
    }
    
    @QtUninvokable
    private native void glActiveShaderProgram_native_GLuint_GLuint(long __this__nativeId, int pipeline, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glActiveTexture(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glActiveTexture(int texture){
        glActiveTexture_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @QtUninvokable
    private native void glActiveTexture_native_GLenum(long __this__nativeId, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glAlphaFunc(GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glAlphaFunc(int func, float ref){
        glAlphaFunc_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), func, ref);
    }
    
    @QtUninvokable
    private native void glAlphaFunc_native_GLenum_GLfloat(long __this__nativeId, int func, float ref);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glAreTexturesResident(GLsizei,<wbr/>const GLuint*,<wbr/>GLboolean*)</code></p>
     */
    @QtUninvokable
    public final boolean glAreTexturesResident(java.nio.@Nullable IntBuffer textures, boolean[] residences){
        return glAreTexturesResident_native_GLsizei_const_GLuint_ptr_GLboolean_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), textures, residences);
    }
    
    @QtUninvokable
    private native boolean glAreTexturesResident_native_GLsizei_const_GLuint_ptr_GLboolean_ptr(long __this__nativeId, java.nio.IntBuffer textures, boolean[] residences);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glArrayElement(GLint)</code></p>
     */
    @QtUninvokable
    public final void glArrayElement(int i){
        glArrayElement_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @QtUninvokable
    private native void glArrayElement_native_GLint(long __this__nativeId, int i);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glAttachShader(GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glAttachShader(int program, int shader){
        glAttachShader_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, shader);
    }
    
    @QtUninvokable
    private native void glAttachShader_native_GLuint_GLuint(long __this__nativeId, int program, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBegin(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBegin(int mode){
        glBegin_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glBegin_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBeginConditionalRender(GLuint,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBeginConditionalRender(int id, int mode){
        glBeginConditionalRender_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), id, mode);
    }
    
    @QtUninvokable
    private native void glBeginConditionalRender_native_GLuint_GLenum(long __this__nativeId, int id, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBeginQuery(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBeginQuery(int target, int id){
        glBeginQuery_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, id);
    }
    
    @QtUninvokable
    private native void glBeginQuery_native_GLenum_GLuint(long __this__nativeId, int target, int id);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBeginQueryIndexed(GLenum,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBeginQueryIndexed(int target, int index, int id){
        glBeginQueryIndexed_native_GLenum_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, id);
    }
    
    @QtUninvokable
    private native void glBeginQueryIndexed_native_GLenum_GLuint_GLuint(long __this__nativeId, int target, int index, int id);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBeginTransformFeedback(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBeginTransformFeedback(int primitiveMode){
        glBeginTransformFeedback_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), primitiveMode);
    }
    
    @QtUninvokable
    private native void glBeginTransformFeedback_native_GLenum(long __this__nativeId, int primitiveMode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBindAttribLocation(GLuint,<wbr/>GLuint,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glBindAttribLocation(int program, int index, java.nio.@Nullable CharBuffer name){
        glBindAttribLocation_native_GLuint_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, name);
    }
    
    @QtUninvokable
    private native void glBindAttribLocation_native_GLuint_GLuint_const_GLchar_ptr(long __this__nativeId, int program, int index, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBindBuffer(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindBuffer(int target, int buffer){
        glBindBuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, buffer);
    }
    
    @QtUninvokable
    private native void glBindBuffer_native_GLenum_GLuint(long __this__nativeId, int target, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBindBufferBase(GLenum,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindBufferBase(int target, int index, int buffer){
        glBindBufferBase_native_GLenum_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, buffer);
    }
    
    @QtUninvokable
    private native void glBindBufferBase_native_GLenum_GLuint_GLuint(long __this__nativeId, int target, int index, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBindBufferRange(GLenum,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLintptr,<wbr/>GLsizeiptr)</code></p>
     */
    @QtUninvokable
    public final void glBindBufferRange(int target, int index, int buffer, long offset, long size){
        glBindBufferRange_native_GLenum_GLuint_GLuint_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, buffer, offset, size);
    }
    
    @QtUninvokable
    private native void glBindBufferRange_native_GLenum_GLuint_GLuint_GLintptr_GLsizeiptr(long __this__nativeId, int target, int index, int buffer, long offset, long size);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBindBuffersBase(GLenum,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glBindBuffersBase(int target, int first, int count, java.nio.@Nullable IntBuffer buffers){
        glBindBuffersBase_native_GLenum_GLuint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, first, count, buffers);
    }
    
    @QtUninvokable
    private native void glBindBuffersBase_native_GLenum_GLuint_GLsizei_const_GLuint_ptr(long __this__nativeId, int target, int first, int count, java.nio.IntBuffer buffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBindBuffersRange(GLenum,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>const GLuint*,<wbr/>const GLintptr*,<wbr/>const GLsizeiptr*)</code></p>
     */
    @QtUninvokable
    public final void glBindBuffersRange(int target, int first, int count, java.nio.@Nullable IntBuffer buffers, java.nio.@Nullable LongBuffer offsets, java.nio.@Nullable LongBuffer sizes){
        glBindBuffersRange_native_GLenum_GLuint_GLsizei_const_GLuint_ptr_const_GLintptr_ptr_const_GLsizeiptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, first, count, buffers, offsets, sizes);
    }
    
    @QtUninvokable
    private native void glBindBuffersRange_native_GLenum_GLuint_GLsizei_const_GLuint_ptr_const_GLintptr_ptr_const_GLsizeiptr_ptr(long __this__nativeId, int target, int first, int count, java.nio.IntBuffer buffers, java.nio.LongBuffer offsets, java.nio.LongBuffer sizes);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBindFragDataLocation(GLuint,<wbr/>GLuint,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glBindFragDataLocation(int program, int color, java.nio.@Nullable CharBuffer name){
        glBindFragDataLocation_native_GLuint_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, color, name);
    }
    
    @QtUninvokable
    private native void glBindFragDataLocation_native_GLuint_GLuint_const_GLchar_ptr(long __this__nativeId, int program, int color, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBindFragDataLocationIndexed(GLuint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glBindFragDataLocationIndexed(int program, int colorNumber, int index, java.nio.@Nullable CharBuffer name){
        glBindFragDataLocationIndexed_native_GLuint_GLuint_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, colorNumber, index, name);
    }
    
    @QtUninvokable
    private native void glBindFragDataLocationIndexed_native_GLuint_GLuint_GLuint_const_GLchar_ptr(long __this__nativeId, int program, int colorNumber, int index, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBindFramebuffer(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindFramebuffer(int target, int framebuffer){
        glBindFramebuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, framebuffer);
    }
    
    @QtUninvokable
    private native void glBindFramebuffer_native_GLenum_GLuint(long __this__nativeId, int target, int framebuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBindImageTexture(GLuint,<wbr/>GLuint,<wbr/>GLint,<wbr/>GLboolean,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBindImageTexture(int unit, int texture, int level, boolean layered, int layer, int access, int format){
        glBindImageTexture_native_GLuint_GLuint_GLint_GLboolean_GLint_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), unit, texture, level, layered, layer, access, format);
    }
    
    @QtUninvokable
    private native void glBindImageTexture_native_GLuint_GLuint_GLint_GLboolean_GLint_GLenum_GLenum(long __this__nativeId, int unit, int texture, int level, boolean layered, int layer, int access, int format);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBindImageTextures(GLuint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glBindImageTextures(int first, int count, java.nio.@Nullable IntBuffer textures){
        glBindImageTextures_native_GLuint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), first, count, textures);
    }
    
    @QtUninvokable
    private native void glBindImageTextures_native_GLuint_GLsizei_const_GLuint_ptr(long __this__nativeId, int first, int count, java.nio.IntBuffer textures);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBindProgramPipeline(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindProgramPipeline(int pipeline){
        glBindProgramPipeline_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), pipeline);
    }
    
    @QtUninvokable
    private native void glBindProgramPipeline_native_GLuint(long __this__nativeId, int pipeline);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBindRenderbuffer(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindRenderbuffer(int target, int renderbuffer){
        glBindRenderbuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, renderbuffer);
    }
    
    @QtUninvokable
    private native void glBindRenderbuffer_native_GLenum_GLuint(long __this__nativeId, int target, int renderbuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBindSampler(GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindSampler(int unit, int sampler){
        glBindSampler_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), unit, sampler);
    }
    
    @QtUninvokable
    private native void glBindSampler_native_GLuint_GLuint(long __this__nativeId, int unit, int sampler);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBindSamplers(GLuint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glBindSamplers(int first, int count, java.nio.@Nullable IntBuffer samplers){
        glBindSamplers_native_GLuint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), first, count, samplers);
    }
    
    @QtUninvokable
    private native void glBindSamplers_native_GLuint_GLsizei_const_GLuint_ptr(long __this__nativeId, int first, int count, java.nio.IntBuffer samplers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBindTexture(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindTexture(int target, int texture){
        glBindTexture_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, texture);
    }
    
    @QtUninvokable
    private native void glBindTexture_native_GLenum_GLuint(long __this__nativeId, int target, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBindTextureUnit(GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindTextureUnit(int unit, int texture){
        glBindTextureUnit_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), unit, texture);
    }
    
    @QtUninvokable
    private native void glBindTextureUnit_native_GLuint_GLuint(long __this__nativeId, int unit, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBindTextures(GLuint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glBindTextures(int first, int count, java.nio.@Nullable IntBuffer textures){
        glBindTextures_native_GLuint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), first, count, textures);
    }
    
    @QtUninvokable
    private native void glBindTextures_native_GLuint_GLsizei_const_GLuint_ptr(long __this__nativeId, int first, int count, java.nio.IntBuffer textures);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBindTransformFeedback(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindTransformFeedback(int target, int id){
        glBindTransformFeedback_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, id);
    }
    
    @QtUninvokable
    private native void glBindTransformFeedback_native_GLenum_GLuint(long __this__nativeId, int target, int id);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBindVertexArray(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindVertexArray(int array){
        glBindVertexArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), array);
    }
    
    @QtUninvokable
    private native void glBindVertexArray_native_GLuint(long __this__nativeId, int array);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBindVertexBuffer(GLuint,<wbr/>GLuint,<wbr/>GLintptr,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glBindVertexBuffer(int bindingindex, int buffer, long offset, int stride){
        glBindVertexBuffer_native_GLuint_GLuint_GLintptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), bindingindex, buffer, offset, stride);
    }
    
    @QtUninvokable
    private native void glBindVertexBuffer_native_GLuint_GLuint_GLintptr_GLsizei(long __this__nativeId, int bindingindex, int buffer, long offset, int stride);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBindVertexBuffers(GLuint,<wbr/>GLsizei,<wbr/>const GLuint*,<wbr/>const GLintptr*,<wbr/>const GLsizei*)</code></p>
     */
    @QtUninvokable
    public final void glBindVertexBuffers(int first, int count, java.nio.@Nullable IntBuffer buffers, java.nio.@Nullable LongBuffer offsets, java.nio.@Nullable IntBuffer strides){
        glBindVertexBuffers_native_GLuint_GLsizei_const_GLuint_ptr_const_GLintptr_ptr_const_GLsizei_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), first, count, buffers, offsets, strides);
    }
    
    @QtUninvokable
    private native void glBindVertexBuffers_native_GLuint_GLsizei_const_GLuint_ptr_const_GLintptr_ptr_const_GLsizei_ptr(long __this__nativeId, int first, int count, java.nio.IntBuffer buffers, java.nio.LongBuffer offsets, java.nio.IntBuffer strides);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBitmap(GLsizei,<wbr/>GLsizei,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>const GLubyte*)</code></p>
     */
    @QtUninvokable
    public final void glBitmap(int width, int height, float xorig, float yorig, float xmove, float ymove, java.nio.@Nullable ByteBuffer bitmap){
        glBitmap_native_GLsizei_GLsizei_GLfloat_GLfloat_GLfloat_GLfloat_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), width, height, xorig, yorig, xmove, ymove, bitmap);
    }
    
    @QtUninvokable
    private native void glBitmap_native_GLsizei_GLsizei_GLfloat_GLfloat_GLfloat_GLfloat_const_GLubyte_ptr(long __this__nativeId, int width, int height, float xorig, float yorig, float xmove, float ymove, java.nio.ByteBuffer bitmap);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBlendColor(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glBlendColor(float red, float green, float blue, float alpha){
        glBlendColor_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glBlendColor_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBlendEquation(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBlendEquation(int mode){
        glBlendEquation_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glBlendEquation_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBlendEquationSeparate(GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBlendEquationSeparate(int modeRGB, int modeAlpha){
        glBlendEquationSeparate_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), modeRGB, modeAlpha);
    }
    
    @QtUninvokable
    private native void glBlendEquationSeparate_native_GLenum_GLenum(long __this__nativeId, int modeRGB, int modeAlpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBlendEquationSeparatei(GLuint,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBlendEquationSeparatei(int buf, int modeRGB, int modeAlpha){
        glBlendEquationSeparatei_native_GLuint_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), buf, modeRGB, modeAlpha);
    }
    
    @QtUninvokable
    private native void glBlendEquationSeparatei_native_GLuint_GLenum_GLenum(long __this__nativeId, int buf, int modeRGB, int modeAlpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBlendEquationi(GLuint,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBlendEquationi(int buf, int mode){
        glBlendEquationi_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), buf, mode);
    }
    
    @QtUninvokable
    private native void glBlendEquationi_native_GLuint_GLenum(long __this__nativeId, int buf, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBlendFunc(GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBlendFunc(int sfactor, int dfactor){
        glBlendFunc_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), sfactor, dfactor);
    }
    
    @QtUninvokable
    private native void glBlendFunc_native_GLenum_GLenum(long __this__nativeId, int sfactor, int dfactor);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBlendFuncSeparate(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBlendFuncSeparate(int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha){
        glBlendFuncSeparate_native_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
    }
    
    @QtUninvokable
    private native void glBlendFuncSeparate_native_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBlendFuncSeparatei(GLuint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBlendFuncSeparatei(int buf, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha){
        glBlendFuncSeparatei_native_GLuint_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
    }
    
    @QtUninvokable
    private native void glBlendFuncSeparatei_native_GLuint_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int buf, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBlendFunci(GLuint,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBlendFunci(int buf, int src, int dst){
        glBlendFunci_native_GLuint_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), buf, src, dst);
    }
    
    @QtUninvokable
    private native void glBlendFunci_native_GLuint_GLenum_GLenum(long __this__nativeId, int buf, int src, int dst);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBlitFramebuffer(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLbitfield,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBlitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter){
        glBlitFramebuffer_native_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLbitfield_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    }
    
    @QtUninvokable
    private native void glBlitFramebuffer_native_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLbitfield_GLenum(long __this__nativeId, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBlitNamedFramebuffer(GLuint,<wbr/>GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLbitfield,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBlitNamedFramebuffer(int readFramebuffer, int drawFramebuffer, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter){
        glBlitNamedFramebuffer_native_GLuint_GLuint_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLbitfield_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), readFramebuffer, drawFramebuffer, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    }
    
    @QtUninvokable
    private native void glBlitNamedFramebuffer_native_GLuint_GLuint_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLbitfield_GLenum(long __this__nativeId, int readFramebuffer, int drawFramebuffer, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBufferData(GLenum,<wbr/>GLsizeiptr,<wbr/>const void*,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBufferData(int target, long size, java.nio.@Nullable Buffer data, int usage){
        glBufferData_native_GLenum_GLsizeiptr_const_void_ptr_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, size, data, usage);
    }
    
    @QtUninvokable
    private native void glBufferData_native_GLenum_GLsizeiptr_const_void_ptr_GLenum(long __this__nativeId, int target, long size, java.nio.Buffer data, int usage);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBufferStorage(GLenum,<wbr/>GLsizeiptr,<wbr/>const void*,<wbr/>GLbitfield)</code></p>
     */
    @QtUninvokable
    public final void glBufferStorage(int target, long size, java.nio.@Nullable Buffer data, int flags){
        glBufferStorage_native_GLenum_GLsizeiptr_const_void_ptr_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), target, size, data, flags);
    }
    
    @QtUninvokable
    private native void glBufferStorage_native_GLenum_GLsizeiptr_const_void_ptr_GLbitfield(long __this__nativeId, int target, long size, java.nio.Buffer data, int flags);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glBufferSubData(GLenum,<wbr/>GLintptr,<wbr/>GLsizeiptr,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glBufferSubData(int target, long offset, long size, java.nio.@Nullable Buffer data){
        glBufferSubData_native_GLenum_GLintptr_GLsizeiptr_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, size, data);
    }
    
    @QtUninvokable
    private native void glBufferSubData_native_GLenum_GLintptr_GLsizeiptr_const_void_ptr(long __this__nativeId, int target, long offset, long size, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCallList(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glCallList(int list){
        glCallList_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), list);
    }
    
    @QtUninvokable
    private native void glCallList_native_GLuint(long __this__nativeId, int list);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCallLists(GLsizei,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glCallLists(int n, int type, java.nio.@Nullable Buffer lists){
        glCallLists_native_GLsizei_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, type, lists);
    }
    
    @QtUninvokable
    private native void glCallLists_native_GLsizei_GLenum_const_void_ptr(long __this__nativeId, int n, int type, java.nio.Buffer lists);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCheckFramebufferStatus(GLenum)</code></p>
     */
    @QtUninvokable
    public final int glCheckFramebufferStatus(int target){
        return glCheckFramebufferStatus_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native int glCheckFramebufferStatus_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCheckNamedFramebufferStatus(GLuint,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final int glCheckNamedFramebufferStatus(int framebuffer, int target){
        return glCheckNamedFramebufferStatus_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer, target);
    }
    
    @QtUninvokable
    private native int glCheckNamedFramebufferStatus_native_GLuint_GLenum(long __this__nativeId, int framebuffer, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClampColor(GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glClampColor(int target, int clamp){
        glClampColor_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, clamp);
    }
    
    @QtUninvokable
    private native void glClampColor_native_GLenum_GLenum(long __this__nativeId, int target, int clamp);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClear(GLbitfield)</code></p>
     */
    @QtUninvokable
    public final void glClear(int mask){
        glClear_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glClear_native_GLbitfield(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClearAccum(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glClearAccum(float red, float green, float blue, float alpha){
        glClearAccum_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glClearAccum_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClearBufferData(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glClearBufferData(int target, int internalformat, int format, int type, java.nio.@Nullable Buffer data){
        glClearBufferData_native_GLenum_GLenum_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, format, type, data);
    }
    
    @QtUninvokable
    private native void glClearBufferData_native_GLenum_GLenum_GLenum_GLenum_const_void_ptr(long __this__nativeId, int target, int internalformat, int format, int type, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClearBufferSubData(GLenum,<wbr/>GLenum,<wbr/>GLintptr,<wbr/>GLsizeiptr,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glClearBufferSubData(int target, int internalformat, long offset, long size, int format, int type, java.nio.@Nullable Buffer data){
        glClearBufferSubData_native_GLenum_GLenum_GLintptr_GLsizeiptr_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, offset, size, format, type, data);
    }
    
    @QtUninvokable
    private native void glClearBufferSubData_native_GLenum_GLenum_GLintptr_GLsizeiptr_GLenum_GLenum_const_void_ptr(long __this__nativeId, int target, int internalformat, long offset, long size, int format, int type, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClearBufferfi(GLenum,<wbr/>GLint,<wbr/>GLfloat,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glClearBufferfi(int buffer, int drawbuffer, float depth, int stencil){
        glClearBufferfi_native_GLenum_GLint_GLfloat_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, depth, stencil);
    }
    
    @QtUninvokable
    private native void glClearBufferfi_native_GLenum_GLint_GLfloat_GLint(long __this__nativeId, int buffer, int drawbuffer, float depth, int stencil);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClearBufferfv(GLenum,<wbr/>GLint,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glClearBufferfv(int buffer, int drawbuffer, java.nio.@Nullable FloatBuffer value){
        glClearBufferfv_native_GLenum_GLint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, value);
    }
    
    @QtUninvokable
    private native void glClearBufferfv_native_GLenum_GLint_const_GLfloat_ptr(long __this__nativeId, int buffer, int drawbuffer, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClearBufferiv(GLenum,<wbr/>GLint,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glClearBufferiv(int buffer, int drawbuffer, java.nio.@Nullable IntBuffer value){
        glClearBufferiv_native_GLenum_GLint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, value);
    }
    
    @QtUninvokable
    private native void glClearBufferiv_native_GLenum_GLint_const_GLint_ptr(long __this__nativeId, int buffer, int drawbuffer, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClearBufferuiv(GLenum,<wbr/>GLint,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glClearBufferuiv(int buffer, int drawbuffer, java.nio.@Nullable IntBuffer value){
        glClearBufferuiv_native_GLenum_GLint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, value);
    }
    
    @QtUninvokable
    private native void glClearBufferuiv_native_GLenum_GLint_const_GLuint_ptr(long __this__nativeId, int buffer, int drawbuffer, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClearColor(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glClearColor(float red, float green, float blue, float alpha){
        glClearColor_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glClearColor_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClearDepth(GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glClearDepth(double depth){
        glClearDepth_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), depth);
    }
    
    @QtUninvokable
    private native void glClearDepth_native_GLdouble(long __this__nativeId, double depth);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClearDepthf(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glClearDepthf(float dd){
        glClearDepthf_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), dd);
    }
    
    @QtUninvokable
    private native void glClearDepthf_native_GLfloat(long __this__nativeId, float dd);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClearIndex(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glClearIndex(float c){
        glClearIndex_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glClearIndex_native_GLfloat(long __this__nativeId, float c);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClearNamedBufferData(GLuint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glClearNamedBufferData(int buffer, int internalformat, int format, int type, java.nio.@Nullable Buffer data){
        glClearNamedBufferData_native_GLuint_GLenum_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, internalformat, format, type, data);
    }
    
    @QtUninvokable
    private native void glClearNamedBufferData_native_GLuint_GLenum_GLenum_GLenum_const_void_ptr(long __this__nativeId, int buffer, int internalformat, int format, int type, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClearNamedBufferSubData(GLuint,<wbr/>GLenum,<wbr/>GLintptr,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glClearNamedBufferSubData(int buffer, int internalformat, long offset, int size, int format, int type, java.nio.@Nullable Buffer data){
        glClearNamedBufferSubData_native_GLuint_GLenum_GLintptr_GLsizei_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, internalformat, offset, size, format, type, data);
    }
    
    @QtUninvokable
    private native void glClearNamedBufferSubData_native_GLuint_GLenum_GLintptr_GLsizei_GLenum_GLenum_const_void_ptr(long __this__nativeId, int buffer, int internalformat, long offset, int size, int format, int type, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClearNamedFramebufferfi(GLuint,<wbr/>GLenum,<wbr/>GLfloat,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glClearNamedFramebufferfi(int framebuffer, int buffer, float depth, int stencil){
        glClearNamedFramebufferfi_native_GLuint_GLenum_GLfloat_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer, buffer, depth, stencil);
    }
    
    @QtUninvokable
    private native void glClearNamedFramebufferfi_native_GLuint_GLenum_GLfloat_GLint(long __this__nativeId, int framebuffer, int buffer, float depth, int stencil);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClearNamedFramebufferfv(GLuint,<wbr/>GLenum,<wbr/>GLint,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glClearNamedFramebufferfv(int framebuffer, int buffer, int drawbuffer, java.nio.@Nullable FloatBuffer value){
        glClearNamedFramebufferfv_native_GLuint_GLenum_GLint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer, buffer, drawbuffer, value);
    }
    
    @QtUninvokable
    private native void glClearNamedFramebufferfv_native_GLuint_GLenum_GLint_const_GLfloat_ptr(long __this__nativeId, int framebuffer, int buffer, int drawbuffer, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClearNamedFramebufferiv(GLuint,<wbr/>GLenum,<wbr/>GLint,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glClearNamedFramebufferiv(int framebuffer, int buffer, int drawbuffer, java.nio.@Nullable IntBuffer value){
        glClearNamedFramebufferiv_native_GLuint_GLenum_GLint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer, buffer, drawbuffer, value);
    }
    
    @QtUninvokable
    private native void glClearNamedFramebufferiv_native_GLuint_GLenum_GLint_const_GLint_ptr(long __this__nativeId, int framebuffer, int buffer, int drawbuffer, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClearNamedFramebufferuiv(GLuint,<wbr/>GLenum,<wbr/>GLint,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glClearNamedFramebufferuiv(int framebuffer, int buffer, int drawbuffer, java.nio.@Nullable IntBuffer value){
        glClearNamedFramebufferuiv_native_GLuint_GLenum_GLint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer, buffer, drawbuffer, value);
    }
    
    @QtUninvokable
    private native void glClearNamedFramebufferuiv_native_GLuint_GLenum_GLint_const_GLuint_ptr(long __this__nativeId, int framebuffer, int buffer, int drawbuffer, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClearStencil(GLint)</code></p>
     */
    @QtUninvokable
    public final void glClearStencil(int s){
        glClearStencil_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glClearStencil_native_GLint(long __this__nativeId, int s);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClearTexImage(GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glClearTexImage(int texture, int level, int format, int type, java.nio.@Nullable Buffer data){
        glClearTexImage_native_GLuint_GLint_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level, format, type, data);
    }
    
    @QtUninvokable
    private native void glClearTexImage_native_GLuint_GLint_GLenum_GLenum_const_void_ptr(long __this__nativeId, int texture, int level, int format, int type, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClearTexSubImage(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.@Nullable Buffer data){
        glClearTexSubImage_native_GLuint_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, data);
    }
    
    @QtUninvokable
    private native void glClearTexSubImage_native_GLuint_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr(long __this__nativeId, int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClientActiveTexture(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glClientActiveTexture(int texture){
        glClientActiveTexture_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @QtUninvokable
    private native void glClientActiveTexture_native_GLenum(long __this__nativeId, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClientWaitSync(GLsync,<wbr/>GLbitfield,<wbr/>GLuint64)</code></p>
     */
    @QtUninvokable
    public final int glClientWaitSync(io.qt.gui.gl.@Nullable GLsync sync, int flags, long timeout){
        return glClientWaitSync_native___GLsync_ptr_GLbitfield_GLuint64(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync), flags, timeout);
    }
    
    @QtUninvokable
    private native int glClientWaitSync_native___GLsync_ptr_GLbitfield_GLuint64(long __this__nativeId, long sync, int flags, long timeout);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClipControl(GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glClipControl(int origin, int depth){
        glClipControl_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), origin, depth);
    }
    
    @QtUninvokable
    private native void glClipControl_native_GLenum_GLenum(long __this__nativeId, int origin, int depth);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glClipPlane(GLenum,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glClipPlane(int plane, double[] equation){
        if(equation!=null && equation.length < 4)
            throw new IllegalArgumentException("Argument 'equation': Wrong number of elements in array. Found: " + equation.length + ", expected: 4");
        glClipPlane_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), plane, equation);
    }
    
    @QtUninvokable
    private native void glClipPlane_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int plane, double[] equation);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColor3b(GLbyte,<wbr/>GLbyte,<wbr/>GLbyte)</code></p>
     */
    @QtUninvokable
    public final void glColor3b(byte red, byte green, byte blue){
        glColor3b_native_GLbyte_GLbyte_GLbyte(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glColor3b_native_GLbyte_GLbyte_GLbyte(long __this__nativeId, byte red, byte green, byte blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColor3bv(const GLbyte*)</code></p>
     */
    @QtUninvokable
    public final void glColor3bv(byte[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3bv_native_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor3bv_native_const_GLbyte_ptr(long __this__nativeId, byte[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColor3d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glColor3d(double red, double green, double blue){
        glColor3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glColor3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double red, double green, double blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColor3dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glColor3dv(double[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColor3f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glColor3f(float red, float green, float blue){
        glColor3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glColor3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColor3fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glColor3fv(float[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColor3i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glColor3i(int red, int green, int blue){
        glColor3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glColor3i_native_GLint_GLint_GLint(long __this__nativeId, int red, int green, int blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColor3iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glColor3iv(int[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColor3s(GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glColor3s(short red, short green, short blue){
        glColor3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glColor3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short red, short green, short blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColor3sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glColor3sv(short[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColor4b(GLbyte,<wbr/>GLbyte,<wbr/>GLbyte,<wbr/>GLbyte)</code></p>
     */
    @QtUninvokable
    public final void glColor4b(byte red, byte green, byte blue, byte alpha){
        glColor4b_native_GLbyte_GLbyte_GLbyte_GLbyte(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColor4b_native_GLbyte_GLbyte_GLbyte_GLbyte(long __this__nativeId, byte red, byte green, byte blue, byte alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColor4bv(const GLbyte*)</code></p>
     */
    @QtUninvokable
    public final void glColor4bv(byte[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4bv_native_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor4bv_native_const_GLbyte_ptr(long __this__nativeId, byte[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColor4d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glColor4d(double red, double green, double blue, double alpha){
        glColor4d_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColor4d_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double red, double green, double blue, double alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColor4dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glColor4dv(double[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor4dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColor4f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glColor4f(float red, float green, float blue, float alpha){
        glColor4f_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColor4f_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColor4fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glColor4fv(float[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor4fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColor4i(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glColor4i(int red, int green, int blue, int alpha){
        glColor4i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColor4i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int red, int green, int blue, int alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColor4iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glColor4iv(int[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor4iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColor4s(GLshort,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glColor4s(short red, short green, short blue, short alpha){
        glColor4s_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColor4s_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short red, short green, short blue, short alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColor4sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glColor4sv(short[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor4sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColorMask(GLboolean,<wbr/>GLboolean,<wbr/>GLboolean,<wbr/>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glColorMask(boolean red, boolean green, boolean blue, boolean alpha){
        glColorMask_native_GLboolean_GLboolean_GLboolean_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColorMask_native_GLboolean_GLboolean_GLboolean_GLboolean(long __this__nativeId, boolean red, boolean green, boolean blue, boolean alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColorMaski(GLuint,<wbr/>GLboolean,<wbr/>GLboolean,<wbr/>GLboolean,<wbr/>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glColorMaski(int index, boolean r, boolean g, boolean b, boolean a){
        glColorMaski_native_GLuint_GLboolean_GLboolean_GLboolean_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), index, r, g, b, a);
    }
    
    @QtUninvokable
    private native void glColorMaski_native_GLuint_GLboolean_GLboolean_GLboolean_GLboolean(long __this__nativeId, int index, boolean r, boolean g, boolean b, boolean a);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColorMaterial(GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glColorMaterial(int face, int mode){
        glColorMaterial_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, mode);
    }
    
    @QtUninvokable
    private native void glColorMaterial_native_GLenum_GLenum(long __this__nativeId, int face, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColorP3ui(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glColorP3ui(int type, int color){
        glColorP3ui_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), type, color);
    }
    
    @QtUninvokable
    private native void glColorP3ui_native_GLenum_GLuint(long __this__nativeId, int type, int color);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColorP3uiv(GLenum,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glColorP3uiv(int type, java.nio.@Nullable IntBuffer color){
        glColorP3uiv_native_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, color);
    }
    
    @QtUninvokable
    private native void glColorP3uiv_native_GLenum_const_GLuint_ptr(long __this__nativeId, int type, java.nio.IntBuffer color);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColorP4ui(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glColorP4ui(int type, int color){
        glColorP4ui_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), type, color);
    }
    
    @QtUninvokable
    private native void glColorP4ui_native_GLenum_GLuint(long __this__nativeId, int type, int color);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColorP4uiv(GLenum,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glColorP4uiv(int type, java.nio.@Nullable IntBuffer color){
        glColorP4uiv_native_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, color);
    }
    
    @QtUninvokable
    private native void glColorP4uiv_native_GLenum_const_GLuint_ptr(long __this__nativeId, int type, java.nio.IntBuffer color);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColorPointer(GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glColorPointer(int size, int type, int stride, java.nio.@Nullable Buffer pointer){
        glColorPointer_native_GLint_GLenum_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), size, type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glColorPointer_native_GLint_GLenum_GLsizei_const_void_ptr(long __this__nativeId, int size, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColorSubTable(GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glColorSubTable(int target, int start, int count, int format, int type, java.nio.@Nullable Buffer data){
        glColorSubTable_native_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, start, count, format, type, data);
    }
    
    @QtUninvokable
    private native void glColorSubTable_native_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr(long __this__nativeId, int target, int start, int count, int format, int type, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColorTable(GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glColorTable(int target, int internalformat, int width, int format, int type, java.nio.@Nullable Buffer table){
        glColorTable_native_GLenum_GLenum_GLsizei_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, format, type, table);
    }
    
    @QtUninvokable
    private native void glColorTable_native_GLenum_GLenum_GLsizei_GLenum_GLenum_const_void_ptr(long __this__nativeId, int target, int internalformat, int width, int format, int type, java.nio.Buffer table);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColorTableParameterfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glColorTableParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glColorTableParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glColorTableParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glColorTableParameteriv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glColorTableParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glColorTableParameteriv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glColorTableParameteriv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCompileShader(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glCompileShader(int shader){
        glCompileShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @QtUninvokable
    private native void glCompileShader_native_GLuint(long __this__nativeId, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCompressedTexImage1D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexImage1D(int target, int level, int internalformat, int width, int border, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexImage1D_native_GLenum_GLint_GLenum_GLsizei_GLint_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, border, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexImage1D_native_GLenum_GLint_GLenum_GLsizei_GLint_GLsizei_const_void_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int border, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCompressedTexImage2D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexImage2D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLint_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, border, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexImage2D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLint_GLsizei_const_void_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int border, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCompressedTexImage3D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexImage3D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLsizei_GLint_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, depth, border, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexImage3D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLsizei_GLint_GLsizei_const_void_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCompressedTexSubImage1D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexSubImage1D(int target, int level, int xoffset, int width, int format, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, width, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLsizei_const_void_ptr(long __this__nativeId, int target, int level, int xoffset, int width, int format, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCompressedTexSubImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, width, height, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_void_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCompressedTexSubImage3D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLsizei_const_void_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCompressedTextureSubImage1D(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTextureSubImage1D_native_GLuint_GLint_GLint_GLsizei_GLenum_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level, xoffset, width, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTextureSubImage1D_native_GLuint_GLint_GLint_GLsizei_GLenum_GLsizei_const_void_ptr(long __this__nativeId, int texture, int level, int xoffset, int width, int format, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCompressedTextureSubImage2D(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTextureSubImage2D_native_GLuint_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level, xoffset, yoffset, width, height, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTextureSubImage2D_native_GLuint_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_void_ptr(long __this__nativeId, int texture, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCompressedTextureSubImage3D(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTextureSubImage3D_native_GLuint_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTextureSubImage3D_native_GLuint_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLsizei_const_void_ptr(long __this__nativeId, int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glConvolutionFilter1D(GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glConvolutionFilter1D(int target, int internalformat, int width, int format, int type, java.nio.@Nullable Buffer image){
        glConvolutionFilter1D_native_GLenum_GLenum_GLsizei_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, format, type, image);
    }
    
    @QtUninvokable
    private native void glConvolutionFilter1D_native_GLenum_GLenum_GLsizei_GLenum_GLenum_const_void_ptr(long __this__nativeId, int target, int internalformat, int width, int format, int type, java.nio.Buffer image);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glConvolutionFilter2D(GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glConvolutionFilter2D(int target, int internalformat, int width, int height, int format, int type, java.nio.@Nullable Buffer image){
        glConvolutionFilter2D_native_GLenum_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, height, format, type, image);
    }
    
    @QtUninvokable
    private native void glConvolutionFilter2D_native_GLenum_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr(long __this__nativeId, int target, int internalformat, int width, int height, int format, int type, java.nio.Buffer image);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glConvolutionParameterf(GLenum,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glConvolutionParameterf(int target, int pname, float params){
        glConvolutionParameterf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glConvolutionParameterf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int target, int pname, float params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glConvolutionParameterfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glConvolutionParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glConvolutionParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glConvolutionParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glConvolutionParameteri(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glConvolutionParameteri(int target, int pname, int params){
        glConvolutionParameteri_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glConvolutionParameteri_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glConvolutionParameteriv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glConvolutionParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glConvolutionParameteriv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glConvolutionParameteriv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCopyBufferSubData(GLenum,<wbr/>GLenum,<wbr/>GLintptr,<wbr/>GLintptr,<wbr/>GLsizeiptr)</code></p>
     */
    @QtUninvokable
    public final void glCopyBufferSubData(int readTarget, int writeTarget, long readOffset, long writeOffset, long size){
        glCopyBufferSubData_native_GLenum_GLenum_GLintptr_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), readTarget, writeTarget, readOffset, writeOffset, size);
    }
    
    @QtUninvokable
    private native void glCopyBufferSubData_native_GLenum_GLenum_GLintptr_GLintptr_GLsizeiptr(long __this__nativeId, int readTarget, int writeTarget, long readOffset, long writeOffset, long size);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCopyColorSubTable(GLenum,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyColorSubTable(int target, int start, int x, int y, int width){
        glCopyColorSubTable_native_GLenum_GLsizei_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, start, x, y, width);
    }
    
    @QtUninvokable
    private native void glCopyColorSubTable_native_GLenum_GLsizei_GLint_GLint_GLsizei(long __this__nativeId, int target, int start, int x, int y, int width);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCopyColorTable(GLenum,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyColorTable(int target, int internalformat, int x, int y, int width){
        glCopyColorTable_native_GLenum_GLenum_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, x, y, width);
    }
    
    @QtUninvokable
    private native void glCopyColorTable_native_GLenum_GLenum_GLint_GLint_GLsizei(long __this__nativeId, int target, int internalformat, int x, int y, int width);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCopyConvolutionFilter1D(GLenum,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyConvolutionFilter1D(int target, int internalformat, int x, int y, int width){
        glCopyConvolutionFilter1D_native_GLenum_GLenum_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, x, y, width);
    }
    
    @QtUninvokable
    private native void glCopyConvolutionFilter1D_native_GLenum_GLenum_GLint_GLint_GLsizei(long __this__nativeId, int target, int internalformat, int x, int y, int width);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCopyConvolutionFilter2D(GLenum,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyConvolutionFilter2D(int target, int internalformat, int x, int y, int width, int height){
        glCopyConvolutionFilter2D_native_GLenum_GLenum_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glCopyConvolutionFilter2D_native_GLenum_GLenum_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int internalformat, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCopyImageSubData(GLuint,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLuint,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyImageSubData(int srcName, int srcTarget, int srcLevel, int srcX, int srcY, int srcZ, int dstName, int dstTarget, int dstLevel, int dstX, int dstY, int dstZ, int srcWidth, int srcHeight, int srcDepth){
        glCopyImageSubData_native_GLuint_GLenum_GLint_GLint_GLint_GLint_GLuint_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth);
    }
    
    @QtUninvokable
    private native void glCopyImageSubData_native_GLuint_GLenum_GLint_GLint_GLint_GLint_GLuint_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei(long __this__nativeId, int srcName, int srcTarget, int srcLevel, int srcX, int srcY, int srcZ, int dstName, int dstTarget, int dstLevel, int dstX, int dstY, int dstZ, int srcWidth, int srcHeight, int srcDepth);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCopyNamedBufferSubData(GLuint,<wbr/>GLuint,<wbr/>GLintptr,<wbr/>GLintptr,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyNamedBufferSubData(int readBuffer, int writeBuffer, long readOffset, long writeOffset, int size){
        glCopyNamedBufferSubData_native_GLuint_GLuint_GLintptr_GLintptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), readBuffer, writeBuffer, readOffset, writeOffset, size);
    }
    
    @QtUninvokable
    private native void glCopyNamedBufferSubData_native_GLuint_GLuint_GLintptr_GLintptr_GLsizei(long __this__nativeId, int readBuffer, int writeBuffer, long readOffset, long writeOffset, int size);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCopyPixels(GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glCopyPixels(int x, int y, int width, int height, int type){
        glCopyPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height, type);
    }
    
    @QtUninvokable
    private native void glCopyPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum(long __this__nativeId, int x, int y, int width, int height, int type);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCopyTexImage1D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glCopyTexImage1D(int target, int level, int internalformat, int x, int y, int width, int border){
        glCopyTexImage1D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, x, y, width, border);
    }
    
    @QtUninvokable
    private native void glCopyTexImage1D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLint(long __this__nativeId, int target, int level, int internalformat, int x, int y, int width, int border);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCopyTexImage2D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border){
        glCopyTexImage2D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, x, y, width, height, border);
    }
    
    @QtUninvokable
    private native void glCopyTexImage2D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLsizei_GLint(long __this__nativeId, int target, int level, int internalformat, int x, int y, int width, int height, int border);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCopyTexSubImage1D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyTexSubImage1D(int target, int level, int xoffset, int x, int y, int width){
        glCopyTexSubImage1D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, x, y, width);
    }
    
    @QtUninvokable
    private native void glCopyTexSubImage1D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei(long __this__nativeId, int target, int level, int xoffset, int x, int y, int width);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCopyTexSubImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height){
        glCopyTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glCopyTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int level, int xoffset, int yoffset, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCopyTexSubImage3D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height){
        glCopyTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glCopyTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCopyTextureSubImage1D(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyTextureSubImage1D(int texture, int level, int xoffset, int x, int y, int width){
        glCopyTextureSubImage1D_native_GLuint_GLint_GLint_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level, xoffset, x, y, width);
    }
    
    @QtUninvokable
    private native void glCopyTextureSubImage1D_native_GLuint_GLint_GLint_GLint_GLint_GLsizei(long __this__nativeId, int texture, int level, int xoffset, int x, int y, int width);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCopyTextureSubImage2D(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int x, int y, int width, int height){
        glCopyTextureSubImage2D_native_GLuint_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level, xoffset, yoffset, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glCopyTextureSubImage2D_native_GLuint_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int texture, int level, int xoffset, int yoffset, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCopyTextureSubImage3D(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height){
        glCopyTextureSubImage3D_native_GLuint_GLint_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level, xoffset, yoffset, zoffset, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glCopyTextureSubImage3D_native_GLuint_GLint_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int texture, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCreateBuffers(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glCreateBuffers(int n, java.nio.@Nullable IntBuffer buffers){
        glCreateBuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, buffers);
    }
    
    @QtUninvokable
    private native void glCreateBuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer buffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCreateFramebuffers(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glCreateFramebuffers(int n, java.nio.@Nullable IntBuffer framebuffers){
        glCreateFramebuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, framebuffers);
    }
    
    @QtUninvokable
    private native void glCreateFramebuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer framebuffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCreateProgram()</code></p>
     */
    @QtUninvokable
    public final int glCreateProgram(){
        return glCreateProgram_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int glCreateProgram_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCreateProgramPipelines(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glCreateProgramPipelines(int n, java.nio.@Nullable IntBuffer pipelines){
        glCreateProgramPipelines_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, pipelines);
    }
    
    @QtUninvokable
    private native void glCreateProgramPipelines_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer pipelines);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCreateQueries(GLenum,<wbr/>GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glCreateQueries(int target, int n, java.nio.@Nullable IntBuffer ids){
        glCreateQueries_native_GLenum_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, n, ids);
    }
    
    @QtUninvokable
    private native void glCreateQueries_native_GLenum_GLsizei_GLuint_ptr(long __this__nativeId, int target, int n, java.nio.IntBuffer ids);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCreateRenderbuffers(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glCreateRenderbuffers(int n, java.nio.@Nullable IntBuffer renderbuffers){
        glCreateRenderbuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, renderbuffers);
    }
    
    @QtUninvokable
    private native void glCreateRenderbuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer renderbuffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCreateSamplers(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glCreateSamplers(int n, java.nio.@Nullable IntBuffer samplers){
        glCreateSamplers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, samplers);
    }
    
    @QtUninvokable
    private native void glCreateSamplers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer samplers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCreateShader(GLenum)</code></p>
     */
    @QtUninvokable
    public final int glCreateShader(int type){
        return glCreateShader_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), type);
    }
    
    @QtUninvokable
    private native int glCreateShader_native_GLenum(long __this__nativeId, int type);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCreateShaderProgramv(GLenum,<wbr/>GLsizei,<wbr/>const GLchar*const*)</code></p>
     */
    @QtUninvokable
    public final int glCreateShaderProgramv(int type, java.lang.String[] strings){
        return glCreateShaderProgramv_native_GLenum_GLsizei_const_GLchar_cptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, strings);
    }
    
    @QtUninvokable
    private native int glCreateShaderProgramv_native_GLenum_GLsizei_const_GLchar_cptr_ptr(long __this__nativeId, int type, java.lang.String[] strings);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCreateTextures(GLenum,<wbr/>GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glCreateTextures(int target, int n, java.nio.@Nullable IntBuffer textures){
        glCreateTextures_native_GLenum_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, n, textures);
    }
    
    @QtUninvokable
    private native void glCreateTextures_native_GLenum_GLsizei_GLuint_ptr(long __this__nativeId, int target, int n, java.nio.IntBuffer textures);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCreateTransformFeedbacks(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glCreateTransformFeedbacks(int n, java.nio.@Nullable IntBuffer ids){
        glCreateTransformFeedbacks_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @QtUninvokable
    private native void glCreateTransformFeedbacks_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCreateVertexArrays(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glCreateVertexArrays(int n, java.nio.@Nullable IntBuffer arrays){
        glCreateVertexArrays_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, arrays);
    }
    
    @QtUninvokable
    private native void glCreateVertexArrays_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer arrays);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glCullFace(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glCullFace(int mode){
        glCullFace_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glCullFace_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDebugMessageCallback(GLDEBUGPROC,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glDebugMessageCallback(io.qt.gui.gl.@Nullable GLDEBUGPROC callback){
        glDebugMessageCallback_native_GLDEBUGPROC_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), callback);
    }
    
    @QtUninvokable
    private native void glDebugMessageCallback_native_GLDEBUGPROC_const_void_ptr(long __this__nativeId, io.qt.gui.gl.GLDEBUGPROC callback);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDebugMessageControl(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLuint*,<wbr/>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glDebugMessageControl(int source, int type, int severity, int count, java.nio.@Nullable IntBuffer ids, boolean enabled){
        glDebugMessageControl_native_GLenum_GLenum_GLenum_GLsizei_const_GLuint_ptr_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), source, type, severity, count, ids, enabled);
    }
    
    @QtUninvokable
    private native void glDebugMessageControl_native_GLenum_GLenum_GLenum_GLsizei_const_GLuint_ptr_GLboolean(long __this__nativeId, int source, int type, int severity, int count, java.nio.IntBuffer ids, boolean enabled);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDebugMessageInsert(GLenum,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glDebugMessageInsert(int source, int type, int id, int severity, int length, java.nio.@Nullable CharBuffer buf){
        glDebugMessageInsert_native_GLenum_GLenum_GLuint_GLenum_GLsizei_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), source, type, id, severity, length, buf);
    }
    
    @QtUninvokable
    private native void glDebugMessageInsert_native_GLenum_GLenum_GLuint_GLenum_GLsizei_const_GLchar_ptr(long __this__nativeId, int source, int type, int id, int severity, int length, java.nio.CharBuffer buf);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDeleteBuffers(GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glDeleteBuffers(int n, java.nio.@Nullable IntBuffer buffers){
        glDeleteBuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, buffers);
    }
    
    @QtUninvokable
    private native void glDeleteBuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer buffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDeleteFramebuffers(GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glDeleteFramebuffers(int n, java.nio.@Nullable IntBuffer framebuffers){
        glDeleteFramebuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, framebuffers);
    }
    
    @QtUninvokable
    private native void glDeleteFramebuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer framebuffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDeleteLists(GLuint,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glDeleteLists(int list, int range){
        glDeleteLists_native_GLuint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), list, range);
    }
    
    @QtUninvokable
    private native void glDeleteLists_native_GLuint_GLsizei(long __this__nativeId, int list, int range);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDeleteProgram(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glDeleteProgram(int program){
        glDeleteProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glDeleteProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDeleteProgramPipelines(GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glDeleteProgramPipelines(int n, java.nio.@Nullable IntBuffer pipelines){
        glDeleteProgramPipelines_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, pipelines);
    }
    
    @QtUninvokable
    private native void glDeleteProgramPipelines_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer pipelines);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDeleteQueries(GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glDeleteQueries(int n, java.nio.@Nullable IntBuffer ids){
        glDeleteQueries_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @QtUninvokable
    private native void glDeleteQueries_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDeleteRenderbuffers(GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glDeleteRenderbuffers(int n, java.nio.@Nullable IntBuffer renderbuffers){
        glDeleteRenderbuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, renderbuffers);
    }
    
    @QtUninvokable
    private native void glDeleteRenderbuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer renderbuffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDeleteSamplers(GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glDeleteSamplers(int count, java.nio.@Nullable IntBuffer samplers){
        glDeleteSamplers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), count, samplers);
    }
    
    @QtUninvokable
    private native void glDeleteSamplers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int count, java.nio.IntBuffer samplers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDeleteShader(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glDeleteShader(int shader){
        glDeleteShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @QtUninvokable
    private native void glDeleteShader_native_GLuint(long __this__nativeId, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDeleteSync(GLsync)</code></p>
     */
    @QtUninvokable
    public final void glDeleteSync(io.qt.gui.gl.@Nullable GLsync sync){
        glDeleteSync_native___GLsync_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync));
    }
    
    @QtUninvokable
    private native void glDeleteSync_native___GLsync_ptr(long __this__nativeId, long sync);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDeleteTextures(GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glDeleteTextures(int n, java.nio.@Nullable IntBuffer textures){
        glDeleteTextures_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures);
    }
    
    @QtUninvokable
    private native void glDeleteTextures_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDeleteTransformFeedbacks(GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glDeleteTransformFeedbacks(int n, java.nio.@Nullable IntBuffer ids){
        glDeleteTransformFeedbacks_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @QtUninvokable
    private native void glDeleteTransformFeedbacks_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDeleteVertexArrays(GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glDeleteVertexArrays(int n, java.nio.@Nullable IntBuffer arrays){
        glDeleteVertexArrays_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, arrays);
    }
    
    @QtUninvokable
    private native void glDeleteVertexArrays_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer arrays);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDepthFunc(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glDepthFunc(int func){
        glDepthFunc_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), func);
    }
    
    @QtUninvokable
    private native void glDepthFunc_native_GLenum(long __this__nativeId, int func);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDepthMask(GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glDepthMask(boolean flag){
        glDepthMask_native_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), flag);
    }
    
    @QtUninvokable
    private native void glDepthMask_native_GLboolean(long __this__nativeId, boolean flag);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDepthRange(GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glDepthRange(double nearVal, double farVal){
        glDepthRange_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), nearVal, farVal);
    }
    
    @QtUninvokable
    private native void glDepthRange_native_GLdouble_GLdouble(long __this__nativeId, double nearVal, double farVal);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDepthRangeArrayv(GLuint,<wbr/>GLsizei,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glDepthRangeArrayv(int first, int count, java.nio.@Nullable DoubleBuffer v){
        glDepthRangeArrayv_native_GLuint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), first, count, v);
    }
    
    @QtUninvokable
    private native void glDepthRangeArrayv_native_GLuint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int first, int count, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDepthRangeIndexed(GLuint,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glDepthRangeIndexed(int index, double n, double f){
        glDepthRangeIndexed_native_GLuint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, n, f);
    }
    
    @QtUninvokable
    private native void glDepthRangeIndexed_native_GLuint_GLdouble_GLdouble(long __this__nativeId, int index, double n, double f);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDepthRangef(GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glDepthRangef(float n, float f){
        glDepthRangef_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), n, f);
    }
    
    @QtUninvokable
    private native void glDepthRangef_native_GLfloat_GLfloat(long __this__nativeId, float n, float f);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDetachShader(GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glDetachShader(int program, int shader){
        glDetachShader_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, shader);
    }
    
    @QtUninvokable
    private native void glDetachShader_native_GLuint_GLuint(long __this__nativeId, int program, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDisable(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glDisable(int cap){
        glDisable_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native void glDisable_native_GLenum(long __this__nativeId, int cap);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDisableClientState(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glDisableClientState(int array){
        glDisableClientState_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), array);
    }
    
    @QtUninvokable
    private native void glDisableClientState_native_GLenum(long __this__nativeId, int array);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDisableVertexArrayAttrib(GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glDisableVertexArrayAttrib(int vaobj, int index){
        glDisableVertexArrayAttrib_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), vaobj, index);
    }
    
    @QtUninvokable
    private native void glDisableVertexArrayAttrib_native_GLuint_GLuint(long __this__nativeId, int vaobj, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDisableVertexAttribArray(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glDisableVertexAttribArray(int index){
        glDisableVertexAttribArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void glDisableVertexAttribArray_native_GLuint(long __this__nativeId, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDisablei(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glDisablei(int target, int index){
        glDisablei_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index);
    }
    
    @QtUninvokable
    private native void glDisablei_native_GLenum_GLuint(long __this__nativeId, int target, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDispatchCompute(GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glDispatchCompute(int num_groups_x, int num_groups_y, int num_groups_z){
        glDispatchCompute_native_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), num_groups_x, num_groups_y, num_groups_z);
    }
    
    @QtUninvokable
    private native void glDispatchCompute_native_GLuint_GLuint_GLuint(long __this__nativeId, int num_groups_x, int num_groups_y, int num_groups_z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDispatchComputeIndirect(GLintptr)</code></p>
     */
    @QtUninvokable
    public final void glDispatchComputeIndirect(long indirect){
        glDispatchComputeIndirect_native_GLintptr(QtJambi_LibraryUtilities.internal.nativeId(this), indirect);
    }
    
    @QtUninvokable
    private native void glDispatchComputeIndirect_native_GLintptr(long __this__nativeId, long indirect);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDrawArrays(GLenum,<wbr/>GLint,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glDrawArrays(int mode, int first, int count){
        glDrawArrays_native_GLenum_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count);
    }
    
    @QtUninvokable
    private native void glDrawArrays_native_GLenum_GLint_GLsizei(long __this__nativeId, int mode, int first, int count);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDrawArraysIndirect(GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glDrawArraysIndirect(int mode, java.nio.@Nullable Buffer indirect){
        glDrawArraysIndirect_native_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, indirect);
    }
    
    @QtUninvokable
    private native void glDrawArraysIndirect_native_GLenum_const_void_ptr(long __this__nativeId, int mode, java.nio.Buffer indirect);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDrawArraysInstanced(GLenum,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glDrawArraysInstanced(int mode, int first, int count, int instancecount){
        glDrawArraysInstanced_native_GLenum_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count, instancecount);
    }
    
    @QtUninvokable
    private native void glDrawArraysInstanced_native_GLenum_GLint_GLsizei_GLsizei(long __this__nativeId, int mode, int first, int count, int instancecount);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDrawArraysInstancedBaseInstance(GLenum,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glDrawArraysInstancedBaseInstance(int mode, int first, int count, int instancecount, int baseinstance){
        glDrawArraysInstancedBaseInstance_native_GLenum_GLint_GLsizei_GLsizei_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count, instancecount, baseinstance);
    }
    
    @QtUninvokable
    private native void glDrawArraysInstancedBaseInstance_native_GLenum_GLint_GLsizei_GLsizei_GLuint(long __this__nativeId, int mode, int first, int count, int instancecount, int baseinstance);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDrawBuffer(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glDrawBuffer(int buf){
        glDrawBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), buf);
    }
    
    @QtUninvokable
    private native void glDrawBuffer_native_GLenum(long __this__nativeId, int buf);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDrawBuffers(GLsizei,<wbr/>const GLenum*)</code></p>
     */
    @QtUninvokable
    public final void glDrawBuffers(int n, java.nio.@Nullable IntBuffer bufs){
        glDrawBuffers_native_GLsizei_const_GLenum_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, bufs);
    }
    
    @QtUninvokable
    private native void glDrawBuffers_native_GLsizei_const_GLenum_ptr(long __this__nativeId, int n, java.nio.IntBuffer bufs);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDrawElements(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glDrawElements(int mode, int count, int type, java.nio.@Nullable Buffer indices){
        glDrawElements_native_GLenum_GLsizei_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices);
    }
    
    @QtUninvokable
    private native void glDrawElements_native_GLenum_GLsizei_GLenum_const_void_ptr(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDrawElementsBaseVertex(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const void*,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glDrawElementsBaseVertex(int mode, int count, int type, java.nio.@Nullable Buffer indices, int basevertex){
        glDrawElementsBaseVertex_native_GLenum_GLsizei_GLenum_const_void_ptr_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, basevertex);
    }
    
    @QtUninvokable
    private native void glDrawElementsBaseVertex_native_GLenum_GLsizei_GLenum_const_void_ptr_GLint(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices, int basevertex);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDrawElementsIndirect(GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glDrawElementsIndirect(int mode, int type, java.nio.@Nullable Buffer indirect){
        glDrawElementsIndirect_native_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, type, indirect);
    }
    
    @QtUninvokable
    private native void glDrawElementsIndirect_native_GLenum_GLenum_const_void_ptr(long __this__nativeId, int mode, int type, java.nio.Buffer indirect);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDrawElementsInstanced(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const void*,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glDrawElementsInstanced(int mode, int count, int type, java.nio.@Nullable Buffer indices, int instancecount){
        glDrawElementsInstanced_native_GLenum_GLsizei_GLenum_const_void_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, instancecount);
    }
    
    @QtUninvokable
    private native void glDrawElementsInstanced_native_GLenum_GLsizei_GLenum_const_void_ptr_GLsizei(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices, int instancecount);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDrawElementsInstancedBaseInstance(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const void*,<wbr/>GLsizei,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glDrawElementsInstancedBaseInstance(int mode, int count, int type, java.nio.@Nullable Buffer indices, int instancecount, int baseinstance){
        glDrawElementsInstancedBaseInstance_native_GLenum_GLsizei_GLenum_const_void_ptr_GLsizei_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, instancecount, baseinstance);
    }
    
    @QtUninvokable
    private native void glDrawElementsInstancedBaseInstance_native_GLenum_GLsizei_GLenum_const_void_ptr_GLsizei_GLuint(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices, int instancecount, int baseinstance);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDrawElementsInstancedBaseVertex(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const void*,<wbr/>GLsizei,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glDrawElementsInstancedBaseVertex(int mode, int count, int type, java.nio.@Nullable Buffer indices, int instancecount, int basevertex){
        glDrawElementsInstancedBaseVertex_native_GLenum_GLsizei_GLenum_const_void_ptr_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, instancecount, basevertex);
    }
    
    @QtUninvokable
    private native void glDrawElementsInstancedBaseVertex_native_GLenum_GLsizei_GLenum_const_void_ptr_GLsizei_GLint(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices, int instancecount, int basevertex);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDrawElementsInstancedBaseVertexBaseInstance(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const void*,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glDrawElementsInstancedBaseVertexBaseInstance(int mode, int count, int type, java.nio.@Nullable Buffer indices, int instancecount, int basevertex, int baseinstance){
        glDrawElementsInstancedBaseVertexBaseInstance_native_GLenum_GLsizei_GLenum_const_void_ptr_GLsizei_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, instancecount, basevertex, baseinstance);
    }
    
    @QtUninvokable
    private native void glDrawElementsInstancedBaseVertexBaseInstance_native_GLenum_GLsizei_GLenum_const_void_ptr_GLsizei_GLint_GLuint(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices, int instancecount, int basevertex, int baseinstance);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDrawPixels(GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glDrawPixels(int width, int height, int format, int type, java.nio.@Nullable Buffer pixels){
        glDrawPixels_native_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), width, height, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glDrawPixels_native_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr(long __this__nativeId, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDrawRangeElements(GLenum,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glDrawRangeElements(int mode, int start, int end, int count, int type, java.nio.@Nullable Buffer indices){
        glDrawRangeElements_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, start, end, count, type, indices);
    }
    
    @QtUninvokable
    private native void glDrawRangeElements_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_void_ptr(long __this__nativeId, int mode, int start, int end, int count, int type, java.nio.Buffer indices);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDrawRangeElementsBaseVertex(GLenum,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const void*,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glDrawRangeElementsBaseVertex(int mode, int start, int end, int count, int type, java.nio.@Nullable Buffer indices, int basevertex){
        glDrawRangeElementsBaseVertex_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_void_ptr_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, start, end, count, type, indices, basevertex);
    }
    
    @QtUninvokable
    private native void glDrawRangeElementsBaseVertex_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_void_ptr_GLint(long __this__nativeId, int mode, int start, int end, int count, int type, java.nio.Buffer indices, int basevertex);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDrawTransformFeedback(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glDrawTransformFeedback(int mode, int id){
        glDrawTransformFeedback_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, id);
    }
    
    @QtUninvokable
    private native void glDrawTransformFeedback_native_GLenum_GLuint(long __this__nativeId, int mode, int id);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDrawTransformFeedbackInstanced(GLenum,<wbr/>GLuint,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glDrawTransformFeedbackInstanced(int mode, int id, int instancecount){
        glDrawTransformFeedbackInstanced_native_GLenum_GLuint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, id, instancecount);
    }
    
    @QtUninvokable
    private native void glDrawTransformFeedbackInstanced_native_GLenum_GLuint_GLsizei(long __this__nativeId, int mode, int id, int instancecount);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDrawTransformFeedbackStream(GLenum,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glDrawTransformFeedbackStream(int mode, int id, int stream){
        glDrawTransformFeedbackStream_native_GLenum_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, id, stream);
    }
    
    @QtUninvokable
    private native void glDrawTransformFeedbackStream_native_GLenum_GLuint_GLuint(long __this__nativeId, int mode, int id, int stream);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glDrawTransformFeedbackStreamInstanced(GLenum,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glDrawTransformFeedbackStreamInstanced(int mode, int id, int stream, int instancecount){
        glDrawTransformFeedbackStreamInstanced_native_GLenum_GLuint_GLuint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, id, stream, instancecount);
    }
    
    @QtUninvokable
    private native void glDrawTransformFeedbackStreamInstanced_native_GLenum_GLuint_GLuint_GLsizei(long __this__nativeId, int mode, int id, int stream, int instancecount);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEdgeFlag(GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glEdgeFlag(boolean flag){
        glEdgeFlag_native_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), flag);
    }
    
    @QtUninvokable
    private native void glEdgeFlag_native_GLboolean(long __this__nativeId, boolean flag);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEdgeFlagPointer(GLsizei,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glEdgeFlagPointer(int stride, java.nio.@Nullable Buffer pointer){
        glEdgeFlagPointer_native_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), stride, pointer);
    }
    
    @QtUninvokable
    private native void glEdgeFlagPointer_native_GLsizei_const_void_ptr(long __this__nativeId, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEnable(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glEnable(int cap){
        glEnable_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native void glEnable_native_GLenum(long __this__nativeId, int cap);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEnableClientState(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glEnableClientState(int array){
        glEnableClientState_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), array);
    }
    
    @QtUninvokable
    private native void glEnableClientState_native_GLenum(long __this__nativeId, int array);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEnableVertexArrayAttrib(GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glEnableVertexArrayAttrib(int vaobj, int index){
        glEnableVertexArrayAttrib_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), vaobj, index);
    }
    
    @QtUninvokable
    private native void glEnableVertexArrayAttrib_native_GLuint_GLuint(long __this__nativeId, int vaobj, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEnableVertexAttribArray(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glEnableVertexAttribArray(int index){
        glEnableVertexAttribArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void glEnableVertexAttribArray_native_GLuint(long __this__nativeId, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEnablei(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glEnablei(int target, int index){
        glEnablei_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index);
    }
    
    @QtUninvokable
    private native void glEnablei_native_GLenum_GLuint(long __this__nativeId, int target, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEnd()</code></p>
     */
    @QtUninvokable
    public final void glEnd(){
        glEnd_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glEnd_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEndConditionalRender()</code></p>
     */
    @QtUninvokable
    public final void glEndConditionalRender(){
        glEndConditionalRender_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glEndConditionalRender_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEndList()</code></p>
     */
    @QtUninvokable
    public final void glEndList(){
        glEndList_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glEndList_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEndQuery(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glEndQuery(int target){
        glEndQuery_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void glEndQuery_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEndQueryIndexed(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glEndQueryIndexed(int target, int index){
        glEndQueryIndexed_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index);
    }
    
    @QtUninvokable
    private native void glEndQueryIndexed_native_GLenum_GLuint(long __this__nativeId, int target, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEndTransformFeedback()</code></p>
     */
    @QtUninvokable
    public final void glEndTransformFeedback(){
        glEndTransformFeedback_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glEndTransformFeedback_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEvalCoord1d(GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord1d(double u){
        glEvalCoord1d_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord1d_native_GLdouble(long __this__nativeId, double u);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEvalCoord1dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord1dv(double[] u){
        if(u!=null && u.length < 1)
            throw new IllegalArgumentException("Argument 'u': Wrong number of elements in array. Found: " + u.length + ", expected: 1");
        glEvalCoord1dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord1dv_native_const_GLdouble_ptr(long __this__nativeId, double[] u);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEvalCoord1f(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord1f(float u){
        glEvalCoord1f_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord1f_native_GLfloat(long __this__nativeId, float u);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEvalCoord1fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord1fv(float[] u){
        if(u!=null && u.length < 1)
            throw new IllegalArgumentException("Argument 'u': Wrong number of elements in array. Found: " + u.length + ", expected: 1");
        glEvalCoord1fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord1fv_native_const_GLfloat_ptr(long __this__nativeId, float[] u);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEvalCoord2d(GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord2d(double u, double v){
        glEvalCoord2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), u, v);
    }
    
    @QtUninvokable
    private native void glEvalCoord2d_native_GLdouble_GLdouble(long __this__nativeId, double u, double v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEvalCoord2dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord2dv(double[] u){
        if(u!=null && u.length < 2)
            throw new IllegalArgumentException("Argument 'u': Wrong number of elements in array. Found: " + u.length + ", expected: 2");
        glEvalCoord2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord2dv_native_const_GLdouble_ptr(long __this__nativeId, double[] u);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEvalCoord2f(GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord2f(float u, float v){
        glEvalCoord2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), u, v);
    }
    
    @QtUninvokable
    private native void glEvalCoord2f_native_GLfloat_GLfloat(long __this__nativeId, float u, float v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEvalCoord2fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord2fv(float[] u){
        if(u!=null && u.length < 2)
            throw new IllegalArgumentException("Argument 'u': Wrong number of elements in array. Found: " + u.length + ", expected: 2");
        glEvalCoord2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord2fv_native_const_GLfloat_ptr(long __this__nativeId, float[] u);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEvalMesh1(GLenum,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glEvalMesh1(int mode, int i1, int i2){
        glEvalMesh1_native_GLenum_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, i1, i2);
    }
    
    @QtUninvokable
    private native void glEvalMesh1_native_GLenum_GLint_GLint(long __this__nativeId, int mode, int i1, int i2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEvalMesh2(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glEvalMesh2(int mode, int i1, int i2, int j1, int j2){
        glEvalMesh2_native_GLenum_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, i1, i2, j1, j2);
    }
    
    @QtUninvokable
    private native void glEvalMesh2_native_GLenum_GLint_GLint_GLint_GLint(long __this__nativeId, int mode, int i1, int i2, int j1, int j2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEvalPoint1(GLint)</code></p>
     */
    @QtUninvokable
    public final void glEvalPoint1(int i){
        glEvalPoint1_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @QtUninvokable
    private native void glEvalPoint1_native_GLint(long __this__nativeId, int i);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glEvalPoint2(GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glEvalPoint2(int i, int j){
        glEvalPoint2_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), i, j);
    }
    
    @QtUninvokable
    private native void glEvalPoint2_native_GLint_GLint(long __this__nativeId, int i, int j);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFeedbackBuffer(GLsizei,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glFeedbackBuffer(int type, java.nio.@Nullable FloatBuffer buffer){
        glFeedbackBuffer_native_GLsizei_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, buffer);
    }
    
    @QtUninvokable
    private native void glFeedbackBuffer_native_GLsizei_GLenum_GLfloat_ptr(long __this__nativeId, int type, java.nio.FloatBuffer buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFenceSync(GLenum,<wbr/>GLbitfield)</code></p>
     */
    @QtUninvokable
    public final io.qt.gui.gl.@Nullable GLsync glFenceSync(int condition, int flags){
        return glFenceSync_native_GLenum_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), condition, flags);
    }
    
    @QtUninvokable
    private native io.qt.gui.gl.GLsync glFenceSync_native_GLenum_GLbitfield(long __this__nativeId, int condition, int flags);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFinish()</code></p>
     */
    @QtUninvokable
    public final void glFinish(){
        glFinish_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glFinish_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFlush()</code></p>
     */
    @QtUninvokable
    public final void glFlush(){
        glFlush_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glFlush_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFlushMappedBufferRange(GLenum,<wbr/>GLintptr,<wbr/>GLsizeiptr)</code></p>
     */
    @QtUninvokable
    public final void glFlushMappedBufferRange(int target, long offset, long length){
        glFlushMappedBufferRange_native_GLenum_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, length);
    }
    
    @QtUninvokable
    private native void glFlushMappedBufferRange_native_GLenum_GLintptr_GLsizeiptr(long __this__nativeId, int target, long offset, long length);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFlushMappedNamedBufferRange(GLuint,<wbr/>GLintptr,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glFlushMappedNamedBufferRange(int buffer, long offset, int length){
        glFlushMappedNamedBufferRange_native_GLuint_GLintptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, offset, length);
    }
    
    @QtUninvokable
    private native void glFlushMappedNamedBufferRange_native_GLuint_GLintptr_GLsizei(long __this__nativeId, int buffer, long offset, int length);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFogCoordPointer(GLenum,<wbr/>GLsizei,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glFogCoordPointer(int type, int stride, java.nio.@Nullable Buffer pointer){
        glFogCoordPointer_native_GLenum_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glFogCoordPointer_native_GLenum_GLsizei_const_void_ptr(long __this__nativeId, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFogCoordd(GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glFogCoordd(double coord){
        glFogCoordd_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), coord);
    }
    
    @QtUninvokable
    private native void glFogCoordd_native_GLdouble(long __this__nativeId, double coord);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFogCoorddv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glFogCoorddv(java.nio.@Nullable DoubleBuffer coord){
        glFogCoorddv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord);
    }
    
    @QtUninvokable
    private native void glFogCoorddv_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer coord);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFogCoordf(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glFogCoordf(float coord){
        glFogCoordf_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), coord);
    }
    
    @QtUninvokable
    private native void glFogCoordf_native_GLfloat(long __this__nativeId, float coord);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFogCoordfv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glFogCoordfv(java.nio.@Nullable FloatBuffer coord){
        glFogCoordfv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord);
    }
    
    @QtUninvokable
    private native void glFogCoordfv_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer coord);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFogf(GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glFogf(int pname, float param){
        glFogf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glFogf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFogfv(GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glFogfv(int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glFogfv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glFogfv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFogi(GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glFogi(int pname, int param){
        glFogi_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glFogi_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFogiv(GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glFogiv(int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glFogiv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glFogiv_native_GLenum_const_GLint_ptr(long __this__nativeId, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFramebufferParameteri(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glFramebufferParameteri(int target, int pname, int param){
        glFramebufferParameteri_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glFramebufferParameteri_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFramebufferRenderbuffer(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer){
        glFramebufferRenderbuffer_native_GLenum_GLenum_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, renderbuffertarget, renderbuffer);
    }
    
    @QtUninvokable
    private native void glFramebufferRenderbuffer_native_GLenum_GLenum_GLenum_GLuint(long __this__nativeId, int target, int attachment, int renderbuffertarget, int renderbuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFramebufferTexture(GLenum,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glFramebufferTexture(int target, int attachment, int texture, int level){
        glFramebufferTexture_native_GLenum_GLenum_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, texture, level);
    }
    
    @QtUninvokable
    private native void glFramebufferTexture_native_GLenum_GLenum_GLuint_GLint(long __this__nativeId, int target, int attachment, int texture, int level);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFramebufferTexture1D(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glFramebufferTexture1D(int target, int attachment, int textarget, int texture, int level){
        glFramebufferTexture1D_native_GLenum_GLenum_GLenum_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, textarget, texture, level);
    }
    
    @QtUninvokable
    private native void glFramebufferTexture1D_native_GLenum_GLenum_GLenum_GLuint_GLint(long __this__nativeId, int target, int attachment, int textarget, int texture, int level);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFramebufferTexture2D(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level){
        glFramebufferTexture2D_native_GLenum_GLenum_GLenum_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, textarget, texture, level);
    }
    
    @QtUninvokable
    private native void glFramebufferTexture2D_native_GLenum_GLenum_GLenum_GLuint_GLint(long __this__nativeId, int target, int attachment, int textarget, int texture, int level);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFramebufferTexture3D(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glFramebufferTexture3D(int target, int attachment, int textarget, int texture, int level, int zoffset){
        glFramebufferTexture3D_native_GLenum_GLenum_GLenum_GLuint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, textarget, texture, level, zoffset);
    }
    
    @QtUninvokable
    private native void glFramebufferTexture3D_native_GLenum_GLenum_GLenum_GLuint_GLint_GLint(long __this__nativeId, int target, int attachment, int textarget, int texture, int level, int zoffset);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFramebufferTextureLayer(GLenum,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glFramebufferTextureLayer(int target, int attachment, int texture, int level, int layer){
        glFramebufferTextureLayer_native_GLenum_GLenum_GLuint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, texture, level, layer);
    }
    
    @QtUninvokable
    private native void glFramebufferTextureLayer_native_GLenum_GLenum_GLuint_GLint_GLint(long __this__nativeId, int target, int attachment, int texture, int level, int layer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFrontFace(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glFrontFace(int mode){
        glFrontFace_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glFrontFace_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glFrustum(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glFrustum(double left, double right, double bottom, double top, double zNear, double zFar){
        glFrustum_native_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), left, right, bottom, top, zNear, zFar);
    }
    
    @QtUninvokable
    private native void glFrustum_native_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double left, double right, double bottom, double top, double zNear, double zFar);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGenBuffers(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGenBuffers(int n, java.nio.@Nullable IntBuffer buffers){
        glGenBuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, buffers);
    }
    
    @QtUninvokable
    private native void glGenBuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer buffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGenFramebuffers(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGenFramebuffers(int n, java.nio.@Nullable IntBuffer framebuffers){
        glGenFramebuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, framebuffers);
    }
    
    @QtUninvokable
    private native void glGenFramebuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer framebuffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGenLists(GLsizei)</code></p>
     */
    @QtUninvokable
    public final int glGenLists(int range){
        return glGenLists_native_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), range);
    }
    
    @QtUninvokable
    private native int glGenLists_native_GLsizei(long __this__nativeId, int range);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGenProgramPipelines(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGenProgramPipelines(int n, java.nio.@Nullable IntBuffer pipelines){
        glGenProgramPipelines_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, pipelines);
    }
    
    @QtUninvokable
    private native void glGenProgramPipelines_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer pipelines);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGenQueries(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGenQueries(int n, java.nio.@Nullable IntBuffer ids){
        glGenQueries_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @QtUninvokable
    private native void glGenQueries_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGenRenderbuffers(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGenRenderbuffers(int n, java.nio.@Nullable IntBuffer renderbuffers){
        glGenRenderbuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, renderbuffers);
    }
    
    @QtUninvokable
    private native void glGenRenderbuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer renderbuffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGenSamplers(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGenSamplers(int count, java.nio.@Nullable IntBuffer samplers){
        glGenSamplers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), count, samplers);
    }
    
    @QtUninvokable
    private native void glGenSamplers_native_GLsizei_GLuint_ptr(long __this__nativeId, int count, java.nio.IntBuffer samplers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGenTextures(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGenTextures(int n, java.nio.@Nullable IntBuffer textures){
        glGenTextures_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures);
    }
    
    @QtUninvokable
    private native void glGenTextures_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGenTransformFeedbacks(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGenTransformFeedbacks(int n, java.nio.@Nullable IntBuffer ids){
        glGenTransformFeedbacks_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @QtUninvokable
    private native void glGenTransformFeedbacks_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGenVertexArrays(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGenVertexArrays(int n, java.nio.@Nullable IntBuffer arrays){
        glGenVertexArrays_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, arrays);
    }
    
    @QtUninvokable
    private native void glGenVertexArrays_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer arrays);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGenerateMipmap(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glGenerateMipmap(int target){
        glGenerateMipmap_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void glGenerateMipmap_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGenerateTextureMipmap(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glGenerateTextureMipmap(int texture){
        glGenerateTextureMipmap_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @QtUninvokable
    private native void glGenerateTextureMipmap_native_GLuint(long __this__nativeId, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetActiveAtomicCounterBufferiv(GLuint,<wbr/>GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetActiveAtomicCounterBufferiv(int program, int bufferIndex, int pname, java.nio.@Nullable IntBuffer params){
        glGetActiveAtomicCounterBufferiv_native_GLuint_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, bufferIndex, pname, params);
    }
    
    @QtUninvokable
    private native void glGetActiveAtomicCounterBufferiv_native_GLuint_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int bufferIndex, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetActiveAttrib(GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLint*,<wbr/>GLenum*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetActiveAttrib(int program, int index, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable IntBuffer size, java.nio.@Nullable IntBuffer type, java.nio.@Nullable CharBuffer name){
        glGetActiveAttrib_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, bufSize, length, size, type, name);
    }
    
    @QtUninvokable
    private native void glGetActiveAttrib_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetActiveSubroutineName(GLuint,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetActiveSubroutineName(int program, int shadertype, int index, int bufsize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer name){
        glGetActiveSubroutineName_native_GLuint_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, index, bufsize, length, name);
    }
    
    @QtUninvokable
    private native void glGetActiveSubroutineName_native_GLuint_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int shadertype, int index, int bufsize, java.nio.IntBuffer length, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetActiveSubroutineUniformName(GLuint,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetActiveSubroutineUniformName(int program, int shadertype, int index, int bufsize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer name){
        glGetActiveSubroutineUniformName_native_GLuint_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, index, bufsize, length, name);
    }
    
    @QtUninvokable
    private native void glGetActiveSubroutineUniformName_native_GLuint_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int shadertype, int index, int bufsize, java.nio.IntBuffer length, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetActiveSubroutineUniformiv(GLuint,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetActiveSubroutineUniformiv(int program, int shadertype, int index, int pname, java.nio.@Nullable IntBuffer values){
        glGetActiveSubroutineUniformiv_native_GLuint_GLenum_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, index, pname, values);
    }
    
    @QtUninvokable
    private native void glGetActiveSubroutineUniformiv_native_GLuint_GLenum_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int shadertype, int index, int pname, java.nio.IntBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetActiveUniform(GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLint*,<wbr/>GLenum*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetActiveUniform(int program, int index, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable IntBuffer size, java.nio.@Nullable IntBuffer type, java.nio.@Nullable CharBuffer name){
        glGetActiveUniform_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, bufSize, length, size, type, name);
    }
    
    @QtUninvokable
    private native void glGetActiveUniform_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetActiveUniformBlockName(GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetActiveUniformBlockName(int program, int uniformBlockIndex, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer uniformBlockName){
        glGetActiveUniformBlockName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockIndex, bufSize, length, uniformBlockName);
    }
    
    @QtUninvokable
    private native void glGetActiveUniformBlockName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int uniformBlockIndex, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer uniformBlockName);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetActiveUniformBlockiv(GLuint,<wbr/>GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, java.nio.@Nullable IntBuffer params){
        glGetActiveUniformBlockiv_native_GLuint_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockIndex, pname, params);
    }
    
    @QtUninvokable
    private native void glGetActiveUniformBlockiv_native_GLuint_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int uniformBlockIndex, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetActiveUniformName(GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetActiveUniformName(int program, int uniformIndex, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer uniformName){
        glGetActiveUniformName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformIndex, bufSize, length, uniformName);
    }
    
    @QtUninvokable
    private native void glGetActiveUniformName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int uniformIndex, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer uniformName);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetActiveUniformsiv(GLuint,<wbr/>GLsizei,<wbr/>const GLuint*,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetActiveUniformsiv(int program, int uniformCount, java.nio.@Nullable IntBuffer uniformIndices, int pname, java.nio.@Nullable IntBuffer params){
        glGetActiveUniformsiv_native_GLuint_GLsizei_const_GLuint_ptr_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformCount, uniformIndices, pname, params);
    }
    
    @QtUninvokable
    private native void glGetActiveUniformsiv_native_GLuint_GLsizei_const_GLuint_ptr_GLenum_GLint_ptr(long __this__nativeId, int program, int uniformCount, java.nio.IntBuffer uniformIndices, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetAttachedShaders(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetAttachedShaders(int program, int maxCount, java.nio.@Nullable IntBuffer count, java.nio.@Nullable IntBuffer shaders){
        glGetAttachedShaders_native_GLuint_GLsizei_GLsizei_ptr_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, maxCount, count, shaders);
    }
    
    @QtUninvokable
    private native void glGetAttachedShaders_native_GLuint_GLsizei_GLsizei_ptr_GLuint_ptr(long __this__nativeId, int program, int maxCount, java.nio.IntBuffer count, java.nio.IntBuffer shaders);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetAttribLocation(GLuint,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final int glGetAttribLocation(int program, java.nio.@Nullable CharBuffer name){
        return glGetAttribLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @QtUninvokable
    private native int glGetAttribLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetBooleani_v(GLenum,<wbr/>GLuint,<wbr/>GLboolean*)</code></p>
     */
    @QtUninvokable
    public final void glGetBooleani_v(int target, int index, java.nio.@Nullable IntBuffer data){
        glGetBooleani_v_native_GLenum_GLuint_GLboolean_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @QtUninvokable
    private native void glGetBooleani_v_native_GLenum_GLuint_GLboolean_ptr(long __this__nativeId, int target, int index, java.nio.IntBuffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetBooleanv(GLenum,<wbr/>GLboolean*)</code></p>
     */
    @QtUninvokable
    public final void glGetBooleanv(int pname, boolean[] data){
        if(data!=null && data.length < 1)
            throw new IllegalArgumentException("Argument 'data': Wrong number of elements in array. Found: " + data.length + ", expected: 1");
        glGetBooleanv_native_GLenum_GLboolean_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, data);
    }
    
    @QtUninvokable
    private native void glGetBooleanv_native_GLenum_GLboolean_ptr(long __this__nativeId, int pname, boolean[] data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetBufferParameteri64v(GLenum,<wbr/>GLenum,<wbr/>GLint64*)</code></p>
     */
    @QtUninvokable
    public final void glGetBufferParameteri64v(int target, int pname, java.nio.@Nullable LongBuffer params){
        glGetBufferParameteri64v_native_GLenum_GLenum_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetBufferParameteri64v_native_GLenum_GLenum_GLint64_ptr(long __this__nativeId, int target, int pname, java.nio.LongBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetBufferParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetBufferParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetBufferParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetBufferParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetBufferPointerv(GLenum,<wbr/>GLenum,<wbr/>void**)</code></p>
     */
    @QtUninvokable
    public final void glGetBufferPointerv(int target, int pname, java.nio.@Nullable Buffer[] params){
        glGetBufferPointerv_native_GLenum_GLenum_void_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetBufferPointerv_native_GLenum_GLenum_void_ptr_ptr(long __this__nativeId, int target, int pname, java.nio.Buffer[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetBufferSubData(GLenum,<wbr/>GLintptr,<wbr/>GLsizeiptr,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glGetBufferSubData(int target, long offset, long size, java.nio.@Nullable Buffer data){
        glGetBufferSubData_native_GLenum_GLintptr_GLsizeiptr_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, size, data);
    }
    
    @QtUninvokable
    private native void glGetBufferSubData_native_GLenum_GLintptr_GLsizeiptr_void_ptr(long __this__nativeId, int target, long offset, long size, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetClipPlane(GLenum,<wbr/>GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glGetClipPlane(int plane, double[] equation){
        if(equation!=null && equation.length < 4)
            throw new IllegalArgumentException("Argument 'equation': Wrong number of elements in array. Found: " + equation.length + ", expected: 4");
        glGetClipPlane_native_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), plane, equation);
    }
    
    @QtUninvokable
    private native void glGetClipPlane_native_GLenum_GLdouble_ptr(long __this__nativeId, int plane, double[] equation);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetColorTable(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glGetColorTable(int target, int format, int type, java.nio.@Nullable Buffer table){
        glGetColorTable_native_GLenum_GLenum_GLenum_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, format, type, table);
    }
    
    @QtUninvokable
    private native void glGetColorTable_native_GLenum_GLenum_GLenum_void_ptr(long __this__nativeId, int target, int format, int type, java.nio.Buffer table);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetColorTableParameterfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetColorTableParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glGetColorTableParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetColorTableParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetColorTableParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetColorTableParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetColorTableParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetColorTableParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetCompressedTexImage(GLenum,<wbr/>GLint,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glGetCompressedTexImage(int target, int level, java.nio.@Nullable Buffer img){
        glGetCompressedTexImage_native_GLenum_GLint_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, img);
    }
    
    @QtUninvokable
    private native void glGetCompressedTexImage_native_GLenum_GLint_void_ptr(long __this__nativeId, int target, int level, java.nio.Buffer img);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetCompressedTextureImage(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glGetCompressedTextureImage(int texture, int level, int bufSize, java.nio.@Nullable Buffer pixels){
        glGetCompressedTextureImage_native_GLuint_GLint_GLsizei_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level, bufSize, pixels);
    }
    
    @QtUninvokable
    private native void glGetCompressedTextureImage_native_GLuint_GLint_GLsizei_void_ptr(long __this__nativeId, int texture, int level, int bufSize, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetCompressedTextureSubImage(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int bufSize, java.nio.@Nullable Buffer pixels){
        glGetCompressedTextureSubImage_native_GLuint_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLsizei_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level, xoffset, yoffset, zoffset, width, height, depth, bufSize, pixels);
    }
    
    @QtUninvokable
    private native void glGetCompressedTextureSubImage_native_GLuint_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLsizei_void_ptr(long __this__nativeId, int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int bufSize, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetConvolutionFilter(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glGetConvolutionFilter(int target, int format, int type, java.nio.@Nullable Buffer image){
        glGetConvolutionFilter_native_GLenum_GLenum_GLenum_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, format, type, image);
    }
    
    @QtUninvokable
    private native void glGetConvolutionFilter_native_GLenum_GLenum_GLenum_void_ptr(long __this__nativeId, int target, int format, int type, java.nio.Buffer image);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetConvolutionParameterfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetConvolutionParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glGetConvolutionParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetConvolutionParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetConvolutionParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetConvolutionParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetConvolutionParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetConvolutionParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetDebugMessageLog(GLuint,<wbr/>GLsizei,<wbr/>GLenum*,<wbr/>GLenum*,<wbr/>GLuint*,<wbr/>GLenum*,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final int glGetDebugMessageLog(int[] sources, int[] types, int[] ids, int[] severities, java.lang.String[] messageLog){
        if(sources!=null && sources.length < 1)
            throw new IllegalArgumentException("Argument 'sources': Wrong number of elements in array. Found: " + sources.length + ", expected: 1");
        if(types!=null && types.length < 1)
            throw new IllegalArgumentException("Argument 'types': Wrong number of elements in array. Found: " + types.length + ", expected: 1");
        if(ids!=null && ids.length < 1)
            throw new IllegalArgumentException("Argument 'ids': Wrong number of elements in array. Found: " + ids.length + ", expected: 1");
        if(severities!=null && severities.length < 1)
            throw new IllegalArgumentException("Argument 'severities': Wrong number of elements in array. Found: " + severities.length + ", expected: 1");
        return glGetDebugMessageLog_native_GLuint_GLsizei_GLenum_ptr_GLenum_ptr_GLuint_ptr_GLenum_ptr_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sources, types, ids, severities, messageLog);
    }
    
    @QtUninvokable
    private native int glGetDebugMessageLog_native_GLuint_GLsizei_GLenum_ptr_GLenum_ptr_GLuint_ptr_GLenum_ptr_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int[] sources, int[] types, int[] ids, int[] severities, java.lang.String[] messageLog);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetDoublei_v(GLenum,<wbr/>GLuint,<wbr/>GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glGetDoublei_v(int target, int index, java.nio.@Nullable DoubleBuffer data){
        glGetDoublei_v_native_GLenum_GLuint_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @QtUninvokable
    private native void glGetDoublei_v_native_GLenum_GLuint_GLdouble_ptr(long __this__nativeId, int target, int index, java.nio.DoubleBuffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetDoublev(GLenum,<wbr/>GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glGetDoublev(int pname, double[] data){
        if(data!=null && data.length < 1)
            throw new IllegalArgumentException("Argument 'data': Wrong number of elements in array. Found: " + data.length + ", expected: 1");
        glGetDoublev_native_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, data);
    }
    
    @QtUninvokable
    private native void glGetDoublev_native_GLenum_GLdouble_ptr(long __this__nativeId, int pname, double[] data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetError()</code></p>
     */
    @QtUninvokable
    public final int glGetError(){
        return glGetError_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int glGetError_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetFloati_v(GLenum,<wbr/>GLuint,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetFloati_v(int target, int index, java.nio.@Nullable FloatBuffer data){
        glGetFloati_v_native_GLenum_GLuint_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @QtUninvokable
    private native void glGetFloati_v_native_GLenum_GLuint_GLfloat_ptr(long __this__nativeId, int target, int index, java.nio.FloatBuffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetFloatv(GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetFloatv(int pname, float[] data){
        if(data!=null && data.length < 1)
            throw new IllegalArgumentException("Argument 'data': Wrong number of elements in array. Found: " + data.length + ", expected: 1");
        glGetFloatv_native_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, data);
    }
    
    @QtUninvokable
    private native void glGetFloatv_native_GLenum_GLfloat_ptr(long __this__nativeId, int pname, float[] data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetFragDataIndex(GLuint,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final int glGetFragDataIndex(int program, java.nio.@Nullable CharBuffer name){
        return glGetFragDataIndex_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @QtUninvokable
    private native int glGetFragDataIndex_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetFragDataLocation(GLuint,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final int glGetFragDataLocation(int program, java.nio.@Nullable CharBuffer name){
        return glGetFragDataLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @QtUninvokable
    private native int glGetFragDataLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetFramebufferAttachmentParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, java.nio.@Nullable IntBuffer params){
        glGetFramebufferAttachmentParameteriv_native_GLenum_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, pname, params);
    }
    
    @QtUninvokable
    private native void glGetFramebufferAttachmentParameteriv_native_GLenum_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int attachment, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetFramebufferParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetFramebufferParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetFramebufferParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetFramebufferParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetGraphicsResetStatus()</code></p>
     */
    @QtUninvokable
    public final int glGetGraphicsResetStatus(){
        return glGetGraphicsResetStatus_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int glGetGraphicsResetStatus_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetHistogram(GLenum,<wbr/>GLboolean,<wbr/>GLenum,<wbr/>GLenum,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glGetHistogram(int target, boolean reset, int format, int type, java.nio.@Nullable Buffer values){
        glGetHistogram_native_GLenum_GLboolean_GLenum_GLenum_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, reset, format, type, values);
    }
    
    @QtUninvokable
    private native void glGetHistogram_native_GLenum_GLboolean_GLenum_GLenum_void_ptr(long __this__nativeId, int target, boolean reset, int format, int type, java.nio.Buffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetHistogramParameterfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetHistogramParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glGetHistogramParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetHistogramParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetHistogramParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetHistogramParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetHistogramParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetHistogramParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetInteger64i_v(GLenum,<wbr/>GLuint,<wbr/>GLint64*)</code></p>
     */
    @QtUninvokable
    public final void glGetInteger64i_v(int target, int index, java.nio.@Nullable LongBuffer data){
        glGetInteger64i_v_native_GLenum_GLuint_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @QtUninvokable
    private native void glGetInteger64i_v_native_GLenum_GLuint_GLint64_ptr(long __this__nativeId, int target, int index, java.nio.LongBuffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetInteger64v(GLenum,<wbr/>GLint64*)</code></p>
     */
    @QtUninvokable
    public final void glGetInteger64v(int pname, java.nio.@Nullable LongBuffer data){
        glGetInteger64v_native_GLenum_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, data);
    }
    
    @QtUninvokable
    private native void glGetInteger64v_native_GLenum_GLint64_ptr(long __this__nativeId, int pname, java.nio.LongBuffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetIntegeri_v(GLenum,<wbr/>GLuint,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetIntegeri_v(int target, int index, java.nio.@Nullable IntBuffer data){
        glGetIntegeri_v_native_GLenum_GLuint_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @QtUninvokable
    private native void glGetIntegeri_v_native_GLenum_GLuint_GLint_ptr(long __this__nativeId, int target, int index, java.nio.IntBuffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetIntegerv(GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetIntegerv(int pname, int[] data){
        if(data!=null && data.length < 1)
            throw new IllegalArgumentException("Argument 'data': Wrong number of elements in array. Found: " + data.length + ", expected: 1");
        glGetIntegerv_native_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, data);
    }
    
    @QtUninvokable
    private native void glGetIntegerv_native_GLenum_GLint_ptr(long __this__nativeId, int pname, int[] data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetInternalformati64v(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLint64*)</code></p>
     */
    @QtUninvokable
    public final void glGetInternalformati64v(int target, int internalformat, int pname, int bufSize, java.nio.@Nullable LongBuffer params){
        glGetInternalformati64v_native_GLenum_GLenum_GLenum_GLsizei_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, pname, bufSize, params);
    }
    
    @QtUninvokable
    private native void glGetInternalformati64v_native_GLenum_GLenum_GLenum_GLsizei_GLint64_ptr(long __this__nativeId, int target, int internalformat, int pname, int bufSize, java.nio.LongBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetInternalformativ(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetInternalformativ(int target, int internalformat, int pname, int bufSize, java.nio.@Nullable IntBuffer params){
        glGetInternalformativ_native_GLenum_GLenum_GLenum_GLsizei_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, pname, bufSize, params);
    }
    
    @QtUninvokable
    private native void glGetInternalformativ_native_GLenum_GLenum_GLenum_GLsizei_GLint_ptr(long __this__nativeId, int target, int internalformat, int pname, int bufSize, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetLightfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetLightfv(int light, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetLightfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, params);
    }
    
    @QtUninvokable
    private native void glGetLightfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int light, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetLightiv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetLightiv(int light, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetLightiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, params);
    }
    
    @QtUninvokable
    private native void glGetLightiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int light, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetMapdv(GLenum,<wbr/>GLenum,<wbr/>GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glGetMapdv(int target, int query, double[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glGetMapdv_native_GLenum_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, query, v);
    }
    
    @QtUninvokable
    private native void glGetMapdv_native_GLenum_GLenum_GLdouble_ptr(long __this__nativeId, int target, int query, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetMapfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetMapfv(int target, int query, float[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glGetMapfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, query, v);
    }
    
    @QtUninvokable
    private native void glGetMapfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int query, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetMapiv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetMapiv(int target, int query, int[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glGetMapiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, query, v);
    }
    
    @QtUninvokable
    private native void glGetMapiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int query, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetMaterialfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetMaterialfv(int face, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetMaterialfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, params);
    }
    
    @QtUninvokable
    private native void glGetMaterialfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int face, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetMaterialiv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetMaterialiv(int face, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetMaterialiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, params);
    }
    
    @QtUninvokable
    private native void glGetMaterialiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int face, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetMinmax(GLenum,<wbr/>GLboolean,<wbr/>GLenum,<wbr/>GLenum,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glGetMinmax(int target, boolean reset, int format, int type, java.nio.@Nullable Buffer values){
        glGetMinmax_native_GLenum_GLboolean_GLenum_GLenum_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, reset, format, type, values);
    }
    
    @QtUninvokable
    private native void glGetMinmax_native_GLenum_GLboolean_GLenum_GLenum_void_ptr(long __this__nativeId, int target, boolean reset, int format, int type, java.nio.Buffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetMinmaxParameterfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetMinmaxParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glGetMinmaxParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetMinmaxParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetMinmaxParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetMinmaxParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetMinmaxParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetMinmaxParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetMultisamplefv(GLenum,<wbr/>GLuint,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetMultisamplefv(int pname, int index, java.nio.@Nullable FloatBuffer val){
        glGetMultisamplefv_native_GLenum_GLuint_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, index, val);
    }
    
    @QtUninvokable
    private native void glGetMultisamplefv_native_GLenum_GLuint_GLfloat_ptr(long __this__nativeId, int pname, int index, java.nio.FloatBuffer val);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetNamedBufferParameteri64v(GLuint,<wbr/>GLenum,<wbr/>GLint64*)</code></p>
     */
    @QtUninvokable
    public final void glGetNamedBufferParameteri64v(int buffer, int pname, java.nio.@Nullable LongBuffer params){
        glGetNamedBufferParameteri64v_native_GLuint_GLenum_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, pname, params);
    }
    
    @QtUninvokable
    private native void glGetNamedBufferParameteri64v_native_GLuint_GLenum_GLint64_ptr(long __this__nativeId, int buffer, int pname, java.nio.LongBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetNamedBufferParameteriv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetNamedBufferParameteriv(int buffer, int pname, java.nio.@Nullable IntBuffer params){
        glGetNamedBufferParameteriv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, pname, params);
    }
    
    @QtUninvokable
    private native void glGetNamedBufferParameteriv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int buffer, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetNamedBufferPointerv(GLuint,<wbr/>GLenum,<wbr/>void**)</code></p>
     */
    @QtUninvokable
    public final void glGetNamedBufferPointerv(int buffer, int pname, java.nio.@Nullable Buffer[] params){
        glGetNamedBufferPointerv_native_GLuint_GLenum_void_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, pname, params);
    }
    
    @QtUninvokable
    private native void glGetNamedBufferPointerv_native_GLuint_GLenum_void_ptr_ptr(long __this__nativeId, int buffer, int pname, java.nio.Buffer[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetNamedBufferSubData(GLuint,<wbr/>GLintptr,<wbr/>GLsizei,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glGetNamedBufferSubData(int buffer, long offset, int size, java.nio.@Nullable Buffer data){
        glGetNamedBufferSubData_native_GLuint_GLintptr_GLsizei_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, offset, size, data);
    }
    
    @QtUninvokable
    private native void glGetNamedBufferSubData_native_GLuint_GLintptr_GLsizei_void_ptr(long __this__nativeId, int buffer, long offset, int size, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetNamedFramebufferAttachmentParameteriv(GLuint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetNamedFramebufferAttachmentParameteriv(int framebuffer, int attachment, int pname, java.nio.@Nullable IntBuffer params){
        glGetNamedFramebufferAttachmentParameteriv_native_GLuint_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer, attachment, pname, params);
    }
    
    @QtUninvokable
    private native void glGetNamedFramebufferAttachmentParameteriv_native_GLuint_GLenum_GLenum_GLint_ptr(long __this__nativeId, int framebuffer, int attachment, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetNamedFramebufferParameteriv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetNamedFramebufferParameteriv(int framebuffer, int pname, java.nio.@Nullable IntBuffer param){
        glGetNamedFramebufferParameteriv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer, pname, param);
    }
    
    @QtUninvokable
    private native void glGetNamedFramebufferParameteriv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int framebuffer, int pname, java.nio.IntBuffer param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetNamedRenderbufferParameteriv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetNamedRenderbufferParameteriv(int renderbuffer, int pname, java.nio.@Nullable IntBuffer params){
        glGetNamedRenderbufferParameteriv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), renderbuffer, pname, params);
    }
    
    @QtUninvokable
    private native void glGetNamedRenderbufferParameteriv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int renderbuffer, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetObjectLabel(GLenum,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetObjectLabel(int identifier, int name, java.lang.String[] label){
        if (label.length < 1)
            throw new IllegalArgumentException("Argument 'label': Wrong number of elements in array. Found: 0, expected: 1");
        glGetObjectLabel_native_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), identifier, name, label);
    }
    
    @QtUninvokable
    private native void glGetObjectLabel_native_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int identifier, int name, java.lang.String[] label);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetObjectPtrLabel(const void*,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetObjectPtrLabel(io.qt.gui.gl.@StrictNonNull GLsync ptr, java.lang.String[] label){
        if (label.length < 1)
            throw new IllegalArgumentException("Argument 'label': Wrong number of elements in array. Found: 0, expected: 1");
        java.util.Objects.requireNonNull(ptr, "Argument 'ptr': null not expected.");
        glGetObjectPtrLabel_native_const_void_ptr_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), ptr, label);
    }
    
    @QtUninvokable
    private native void glGetObjectPtrLabel_native_const_void_ptr_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, io.qt.gui.gl.GLsync ptr, java.lang.String[] label);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetPixelMapfv(GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetPixelMapfv(int map, java.nio.@Nullable FloatBuffer values){
        glGetPixelMapfv_native_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, values);
    }
    
    @QtUninvokable
    private native void glGetPixelMapfv_native_GLenum_GLfloat_ptr(long __this__nativeId, int map, java.nio.FloatBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetPixelMapuiv(GLenum,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetPixelMapuiv(int map, java.nio.@Nullable IntBuffer values){
        glGetPixelMapuiv_native_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, values);
    }
    
    @QtUninvokable
    private native void glGetPixelMapuiv_native_GLenum_GLuint_ptr(long __this__nativeId, int map, java.nio.IntBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetPixelMapusv(GLenum,<wbr/>GLushort*)</code></p>
     */
    @QtUninvokable
    public final void glGetPixelMapusv(int map, java.nio.@Nullable ShortBuffer values){
        glGetPixelMapusv_native_GLenum_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, values);
    }
    
    @QtUninvokable
    private native void glGetPixelMapusv_native_GLenum_GLushort_ptr(long __this__nativeId, int map, java.nio.ShortBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetPointerv(GLenum,<wbr/>void**)</code></p>
     */
    @QtUninvokable
    public final void glGetPointerv(int pname, java.nio.Buffer @StrictNonNull[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetPointerv_native_GLenum_void_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetPointerv_native_GLenum_void_ptr_ptr(long __this__nativeId, int pname, java.nio.Buffer[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetPolygonStipple(GLubyte*)</code></p>
     */
    @QtUninvokable
    public final void glGetPolygonStipple(java.nio.@Nullable ByteBuffer mask){
        glGetPolygonStipple_native_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glGetPolygonStipple_native_GLubyte_ptr(long __this__nativeId, java.nio.ByteBuffer mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetProgramBinary(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLenum*,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glGetProgramBinary(int program, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable IntBuffer binaryFormat, java.nio.@Nullable Buffer binary){
        glGetProgramBinary_native_GLuint_GLsizei_GLsizei_ptr_GLenum_ptr_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, bufSize, length, binaryFormat, binary);
    }
    
    @QtUninvokable
    private native void glGetProgramBinary_native_GLuint_GLsizei_GLsizei_ptr_GLenum_ptr_void_ptr(long __this__nativeId, int program, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer binaryFormat, java.nio.Buffer binary);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetProgramInfoLog(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetProgramInfoLog(int program, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer infoLog){
        glGetProgramInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, bufSize, length, infoLog);
    }
    
    @QtUninvokable
    private native void glGetProgramInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetProgramInterfaceiv(GLuint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetProgramInterfaceiv(int program, int programInterface, int pname, java.nio.@Nullable IntBuffer params){
        glGetProgramInterfaceiv_native_GLuint_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, programInterface, pname, params);
    }
    
    @QtUninvokable
    private native void glGetProgramInterfaceiv_native_GLuint_GLenum_GLenum_GLint_ptr(long __this__nativeId, int program, int programInterface, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetProgramPipelineInfoLog(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetProgramPipelineInfoLog(int pipeline, java.lang.String[] infoLog){
        if (infoLog.length < 1)
            throw new IllegalArgumentException("Argument 'infoLog': Wrong number of elements in array. Found: 0, expected: 1");
        glGetProgramPipelineInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pipeline, infoLog);
    }
    
    @QtUninvokable
    private native void glGetProgramPipelineInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int pipeline, java.lang.String[] infoLog);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetProgramPipelineiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetProgramPipelineiv(int pipeline, int pname, java.nio.@Nullable IntBuffer params){
        glGetProgramPipelineiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pipeline, pname, params);
    }
    
    @QtUninvokable
    private native void glGetProgramPipelineiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int pipeline, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetProgramResourceIndex(GLuint,<wbr/>GLenum,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final int glGetProgramResourceIndex(int program, int programInterface, java.nio.@Nullable CharBuffer name){
        return glGetProgramResourceIndex_native_GLuint_GLenum_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, programInterface, name);
    }
    
    @QtUninvokable
    private native int glGetProgramResourceIndex_native_GLuint_GLenum_const_GLchar_ptr(long __this__nativeId, int program, int programInterface, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetProgramResourceLocation(GLuint,<wbr/>GLenum,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final int glGetProgramResourceLocation(int program, int programInterface, java.nio.@Nullable CharBuffer name){
        return glGetProgramResourceLocation_native_GLuint_GLenum_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, programInterface, name);
    }
    
    @QtUninvokable
    private native int glGetProgramResourceLocation_native_GLuint_GLenum_const_GLchar_ptr(long __this__nativeId, int program, int programInterface, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetProgramResourceLocationIndex(GLuint,<wbr/>GLenum,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final int glGetProgramResourceLocationIndex(int program, int programInterface, java.nio.@Nullable CharBuffer name){
        return glGetProgramResourceLocationIndex_native_GLuint_GLenum_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, programInterface, name);
    }
    
    @QtUninvokable
    private native int glGetProgramResourceLocationIndex_native_GLuint_GLenum_const_GLchar_ptr(long __this__nativeId, int program, int programInterface, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetProgramResourceName(GLuint,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetProgramResourceName(int program, int programInterface, int index, java.lang.String[] name){
        if (name.length < 1)
            throw new IllegalArgumentException("Argument 'name': Wrong number of elements in array. Found: 0, expected: 1");
        glGetProgramResourceName_native_GLuint_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, programInterface, index, name);
    }
    
    @QtUninvokable
    private native void glGetProgramResourceName_native_GLuint_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int programInterface, int index, java.lang.String[] name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetProgramResourceiv(GLuint,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>const GLenum*,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetProgramResourceiv(int program, int programInterface, int index, int propCount, java.nio.@Nullable IntBuffer props, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable IntBuffer params){
        glGetProgramResourceiv_native_GLuint_GLenum_GLuint_GLsizei_const_GLenum_ptr_GLsizei_GLsizei_ptr_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, programInterface, index, propCount, props, bufSize, length, params);
    }
    
    @QtUninvokable
    private native void glGetProgramResourceiv_native_GLuint_GLenum_GLuint_GLsizei_const_GLenum_ptr_GLsizei_GLsizei_ptr_GLint_ptr(long __this__nativeId, int program, int programInterface, int index, int propCount, java.nio.IntBuffer props, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetProgramStageiv(GLuint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetProgramStageiv(int program, int shadertype, int pname, java.nio.@Nullable IntBuffer values){
        glGetProgramStageiv_native_GLuint_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, pname, values);
    }
    
    @QtUninvokable
    private native void glGetProgramStageiv_native_GLuint_GLenum_GLenum_GLint_ptr(long __this__nativeId, int program, int shadertype, int pname, java.nio.IntBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetProgramiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetProgramiv(int program, int pname, java.nio.@Nullable IntBuffer params){
        glGetProgramiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, pname, params);
    }
    
    @QtUninvokable
    private native void glGetProgramiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetQueryIndexediv(GLenum,<wbr/>GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetQueryIndexediv(int target, int index, int pname, java.nio.@Nullable IntBuffer params){
        glGetQueryIndexediv_native_GLenum_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryIndexediv_native_GLenum_GLuint_GLenum_GLint_ptr(long __this__nativeId, int target, int index, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetQueryObjecti64v(GLuint,<wbr/>GLenum,<wbr/>GLint64*)</code></p>
     */
    @QtUninvokable
    public final void glGetQueryObjecti64v(int id, int pname, java.nio.@Nullable LongBuffer params){
        glGetQueryObjecti64v_native_GLuint_GLenum_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryObjecti64v_native_GLuint_GLenum_GLint64_ptr(long __this__nativeId, int id, int pname, java.nio.LongBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetQueryObjectiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetQueryObjectiv(int id, int pname, java.nio.@Nullable IntBuffer params){
        glGetQueryObjectiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryObjectiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int id, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetQueryObjectui64v(GLuint,<wbr/>GLenum,<wbr/>GLuint64*)</code></p>
     */
    @QtUninvokable
    public final void glGetQueryObjectui64v(int id, int pname, java.nio.@Nullable LongBuffer params){
        glGetQueryObjectui64v_native_GLuint_GLenum_GLuint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryObjectui64v_native_GLuint_GLenum_GLuint64_ptr(long __this__nativeId, int id, int pname, java.nio.LongBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetQueryObjectuiv(GLuint,<wbr/>GLenum,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetQueryObjectuiv(int id, int pname, java.nio.@Nullable IntBuffer params){
        glGetQueryObjectuiv_native_GLuint_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryObjectuiv_native_GLuint_GLenum_GLuint_ptr(long __this__nativeId, int id, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetQueryiv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetQueryiv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetQueryiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetRenderbufferParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetRenderbufferParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetRenderbufferParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetRenderbufferParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetSamplerParameterIiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetSamplerParameterIiv(int sampler, int pname, java.nio.@Nullable IntBuffer params){
        glGetSamplerParameterIiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, params);
    }
    
    @QtUninvokable
    private native void glGetSamplerParameterIiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetSamplerParameterIuiv(GLuint,<wbr/>GLenum,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetSamplerParameterIuiv(int sampler, int pname, java.nio.@Nullable IntBuffer params){
        glGetSamplerParameterIuiv_native_GLuint_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, params);
    }
    
    @QtUninvokable
    private native void glGetSamplerParameterIuiv_native_GLuint_GLenum_GLuint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetSamplerParameterfv(GLuint,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetSamplerParameterfv(int sampler, int pname, java.nio.@Nullable FloatBuffer params){
        glGetSamplerParameterfv_native_GLuint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, params);
    }
    
    @QtUninvokable
    private native void glGetSamplerParameterfv_native_GLuint_GLenum_GLfloat_ptr(long __this__nativeId, int sampler, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetSamplerParameteriv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetSamplerParameteriv(int sampler, int pname, java.nio.@Nullable IntBuffer params){
        glGetSamplerParameteriv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, params);
    }
    
    @QtUninvokable
    private native void glGetSamplerParameteriv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetSeparableFilter(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>void*,<wbr/>void*,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glGetSeparableFilter(int target, int format, int type, java.nio.@Nullable Buffer row, java.nio.@Nullable Buffer column, java.nio.@Nullable Buffer span){
        glGetSeparableFilter_native_GLenum_GLenum_GLenum_void_ptr_void_ptr_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, format, type, row, column, span);
    }
    
    @QtUninvokable
    private native void glGetSeparableFilter_native_GLenum_GLenum_GLenum_void_ptr_void_ptr_void_ptr(long __this__nativeId, int target, int format, int type, java.nio.Buffer row, java.nio.Buffer column, java.nio.Buffer span);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetShaderInfoLog(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetShaderInfoLog(int shader, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer infoLog){
        glGetShaderInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, bufSize, length, infoLog);
    }
    
    @QtUninvokable
    private native void glGetShaderInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetShaderPrecisionFormat(GLenum,<wbr/>GLenum,<wbr/>GLint*,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetShaderPrecisionFormat(int shadertype, int precisiontype, java.nio.@Nullable IntBuffer range, java.nio.@Nullable IntBuffer precision){
        glGetShaderPrecisionFormat_native_GLenum_GLenum_GLint_ptr_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shadertype, precisiontype, range, precision);
    }
    
    @QtUninvokable
    private native void glGetShaderPrecisionFormat_native_GLenum_GLenum_GLint_ptr_GLint_ptr(long __this__nativeId, int shadertype, int precisiontype, java.nio.IntBuffer range, java.nio.IntBuffer precision);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetShaderSource(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetShaderSource(int shader, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer source){
        glGetShaderSource_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, bufSize, length, source);
    }
    
    @QtUninvokable
    private native void glGetShaderSource_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer source);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetShaderiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetShaderiv(int shader, int pname, java.nio.@Nullable IntBuffer params){
        glGetShaderiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, pname, params);
    }
    
    @QtUninvokable
    private native void glGetShaderiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int shader, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetString(GLenum)</code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String glGetString(int name){
        return glGetString_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native java.lang.@NonNull String glGetString_native_GLenum(long __this__nativeId, int name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetStringi(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String glGetStringi(int name, int index){
        return glGetStringi_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), name, index);
    }
    
    @QtUninvokable
    private native java.lang.@NonNull String glGetStringi_native_GLenum_GLuint(long __this__nativeId, int name, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetSubroutineIndex(GLuint,<wbr/>GLenum,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final int glGetSubroutineIndex(int program, int shadertype, java.nio.@Nullable CharBuffer name){
        return glGetSubroutineIndex_native_GLuint_GLenum_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, name);
    }
    
    @QtUninvokable
    private native int glGetSubroutineIndex_native_GLuint_GLenum_const_GLchar_ptr(long __this__nativeId, int program, int shadertype, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetSubroutineUniformLocation(GLuint,<wbr/>GLenum,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final int glGetSubroutineUniformLocation(int program, int shadertype, java.nio.@Nullable CharBuffer name){
        return glGetSubroutineUniformLocation_native_GLuint_GLenum_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, name);
    }
    
    @QtUninvokable
    private native int glGetSubroutineUniformLocation_native_GLuint_GLenum_const_GLchar_ptr(long __this__nativeId, int program, int shadertype, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetSynciv(GLsync,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetSynciv(io.qt.gui.gl.@Nullable GLsync sync, int pname, int[] length, java.nio.@Nullable IntBuffer values){
        if(length!=null && length.length < 1)
            throw new IllegalArgumentException("Argument 'length': Wrong number of elements in array. Found: " + length.length + ", expected: 1");
        glGetSynciv_native___GLsync_ptr_GLenum_GLsizei_GLsizei_ptr_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync), pname, length, values);
    }
    
    @QtUninvokable
    private native void glGetSynciv_native___GLsync_ptr_GLenum_GLsizei_GLsizei_ptr_GLint_ptr(long __this__nativeId, long sync, int pname, int[] length, java.nio.IntBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTexEnvfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexEnvfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glGetTexEnvfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexEnvfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTexEnviv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexEnviv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexEnviv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexEnviv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTexGendv(GLenum,<wbr/>GLenum,<wbr/>GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexGendv(int coord, int pname, java.nio.@Nullable DoubleBuffer params){
        glGetTexGendv_native_GLenum_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexGendv_native_GLenum_GLenum_GLdouble_ptr(long __this__nativeId, int coord, int pname, java.nio.DoubleBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTexGenfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexGenfv(int coord, int pname, java.nio.@Nullable FloatBuffer params){
        glGetTexGenfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexGenfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int coord, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTexGeniv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexGeniv(int coord, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexGeniv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexGeniv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int coord, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTexImage(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexImage(int target, int level, int format, int type, java.nio.@Nullable Buffer pixels){
        glGetTexImage_native_GLenum_GLint_GLenum_GLenum_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glGetTexImage_native_GLenum_GLint_GLenum_GLenum_void_ptr(long __this__nativeId, int target, int level, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTexLevelParameterfv(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexLevelParameterfv(int target, int level, int pname, java.nio.@Nullable FloatBuffer params){
        glGetTexLevelParameterfv_native_GLenum_GLint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexLevelParameterfv_native_GLenum_GLint_GLenum_GLfloat_ptr(long __this__nativeId, int target, int level, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTexLevelParameteriv(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexLevelParameteriv(int target, int level, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexLevelParameteriv_native_GLenum_GLint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexLevelParameteriv_native_GLenum_GLint_GLenum_GLint_ptr(long __this__nativeId, int target, int level, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTexParameterIiv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexParameterIiv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexParameterIiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameterIiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTexParameterIuiv(GLenum,<wbr/>GLenum,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexParameterIuiv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexParameterIuiv_native_GLenum_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameterIuiv_native_GLenum_GLenum_GLuint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTexParameterfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glGetTexParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTexParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTextureImage(GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glGetTextureImage(int texture, int level, int format, int type, int bufSize, java.nio.@Nullable Buffer pixels){
        glGetTextureImage_native_GLuint_GLint_GLenum_GLenum_GLsizei_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level, format, type, bufSize, pixels);
    }
    
    @QtUninvokable
    private native void glGetTextureImage_native_GLuint_GLint_GLenum_GLenum_GLsizei_void_ptr(long __this__nativeId, int texture, int level, int format, int type, int bufSize, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTextureLevelParameterfv(GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetTextureLevelParameterfv(int texture, int level, int pname, java.nio.@Nullable FloatBuffer params){
        glGetTextureLevelParameterfv_native_GLuint_GLint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTextureLevelParameterfv_native_GLuint_GLint_GLenum_GLfloat_ptr(long __this__nativeId, int texture, int level, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTextureLevelParameteriv(GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTextureLevelParameteriv(int texture, int level, int pname, java.nio.@Nullable IntBuffer params){
        glGetTextureLevelParameteriv_native_GLuint_GLint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTextureLevelParameteriv_native_GLuint_GLint_GLenum_GLint_ptr(long __this__nativeId, int texture, int level, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTextureParameterIiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTextureParameterIiv(int texture, int pname, java.nio.@Nullable IntBuffer params){
        glGetTextureParameterIiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTextureParameterIiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int texture, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTextureParameterIuiv(GLuint,<wbr/>GLenum,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTextureParameterIuiv(int texture, int pname, java.nio.@Nullable IntBuffer params){
        glGetTextureParameterIuiv_native_GLuint_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTextureParameterIuiv_native_GLuint_GLenum_GLuint_ptr(long __this__nativeId, int texture, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTextureParameterfv(GLuint,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetTextureParameterfv(int texture, int pname, java.nio.@Nullable FloatBuffer params){
        glGetTextureParameterfv_native_GLuint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTextureParameterfv_native_GLuint_GLenum_GLfloat_ptr(long __this__nativeId, int texture, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTextureParameteriv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTextureParameteriv(int texture, int pname, java.nio.@Nullable IntBuffer params){
        glGetTextureParameteriv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTextureParameteriv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int texture, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTextureSubImage(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int bufSize, java.nio.@Nullable Buffer pixels){
        glGetTextureSubImage_native_GLuint_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_GLsizei_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, bufSize, pixels);
    }
    
    @QtUninvokable
    private native void glGetTextureSubImage_native_GLuint_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_GLsizei_void_ptr(long __this__nativeId, int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int bufSize, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTransformFeedbackVarying(GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLsizei*,<wbr/>GLenum*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetTransformFeedbackVarying(int program, int index, int[] size, int[] type, java.lang.String[] name){
        if (name.length < 1)
            throw new IllegalArgumentException("Argument 'name': Wrong number of elements in array. Found: 0, expected: 1");
        if(size!=null && size.length < 1)
            throw new IllegalArgumentException("Argument 'size': Wrong number of elements in array. Found: " + size.length + ", expected: 1");
        if(type!=null && type.length < 1)
            throw new IllegalArgumentException("Argument 'type': Wrong number of elements in array. Found: " + type.length + ", expected: 1");
        glGetTransformFeedbackVarying_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLsizei_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, size, type, name);
    }
    
    @QtUninvokable
    private native void glGetTransformFeedbackVarying_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLsizei_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int[] size, int[] type, java.lang.String[] name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTransformFeedbacki64_v(GLuint,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLint64*)</code></p>
     */
    @QtUninvokable
    public final void glGetTransformFeedbacki64_v(int xfb, int pname, int index, java.nio.@Nullable LongBuffer param){
        glGetTransformFeedbacki64_v_native_GLuint_GLenum_GLuint_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), xfb, pname, index, param);
    }
    
    @QtUninvokable
    private native void glGetTransformFeedbacki64_v_native_GLuint_GLenum_GLuint_GLint64_ptr(long __this__nativeId, int xfb, int pname, int index, java.nio.LongBuffer param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTransformFeedbacki_v(GLuint,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTransformFeedbacki_v(int xfb, int pname, int index, java.nio.@Nullable IntBuffer param){
        glGetTransformFeedbacki_v_native_GLuint_GLenum_GLuint_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), xfb, pname, index, param);
    }
    
    @QtUninvokable
    private native void glGetTransformFeedbacki_v_native_GLuint_GLenum_GLuint_GLint_ptr(long __this__nativeId, int xfb, int pname, int index, java.nio.IntBuffer param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetTransformFeedbackiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTransformFeedbackiv(int xfb, int pname, java.nio.@Nullable IntBuffer param){
        glGetTransformFeedbackiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), xfb, pname, param);
    }
    
    @QtUninvokable
    private native void glGetTransformFeedbackiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int xfb, int pname, java.nio.IntBuffer param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetUniformBlockIndex(GLuint,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final int glGetUniformBlockIndex(int program, java.nio.@Nullable CharBuffer uniformBlockName){
        return glGetUniformBlockIndex_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockName);
    }
    
    @QtUninvokable
    private native int glGetUniformBlockIndex_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer uniformBlockName);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetUniformIndices(GLuint,<wbr/>GLsizei,<wbr/>const GLchar*const*,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetUniformIndices(int program, java.lang.String[] uniformNames, int[] uniformIndices){
        glGetUniformIndices_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformNames, uniformIndices);
    }
    
    @QtUninvokable
    private native void glGetUniformIndices_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLuint_ptr(long __this__nativeId, int program, java.lang.String[] uniformNames, int[] uniformIndices);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetUniformLocation(GLuint,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final int glGetUniformLocation(int program, java.nio.@Nullable CharBuffer name){
        return glGetUniformLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @QtUninvokable
    private native int glGetUniformLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetUniformSubroutineuiv(GLenum,<wbr/>GLint,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetUniformSubroutineuiv(int shadertype, int location, java.nio.@Nullable IntBuffer params){
        glGetUniformSubroutineuiv_native_GLenum_GLint_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shadertype, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformSubroutineuiv_native_GLenum_GLint_GLuint_ptr(long __this__nativeId, int shadertype, int location, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetUniformdv(GLuint,<wbr/>GLint,<wbr/>GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glGetUniformdv(int program, int location, java.nio.@Nullable DoubleBuffer params){
        glGetUniformdv_native_GLuint_GLint_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformdv_native_GLuint_GLint_GLdouble_ptr(long __this__nativeId, int program, int location, java.nio.DoubleBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetUniformfv(GLuint,<wbr/>GLint,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetUniformfv(int program, int location, java.nio.@Nullable FloatBuffer params){
        glGetUniformfv_native_GLuint_GLint_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformfv_native_GLuint_GLint_GLfloat_ptr(long __this__nativeId, int program, int location, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetUniformiv(GLuint,<wbr/>GLint,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetUniformiv(int program, int location, java.nio.@Nullable IntBuffer params){
        glGetUniformiv_native_GLuint_GLint_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformiv_native_GLuint_GLint_GLint_ptr(long __this__nativeId, int program, int location, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetUniformuiv(GLuint,<wbr/>GLint,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetUniformuiv(int program, int location, java.nio.@Nullable IntBuffer params){
        glGetUniformuiv_native_GLuint_GLint_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformuiv_native_GLuint_GLint_GLuint_ptr(long __this__nativeId, int program, int location, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetVertexArrayIndexed64iv(GLuint,<wbr/>GLuint,<wbr/>GLenum,<wbr/>GLint64*)</code></p>
     */
    @QtUninvokable
    public final void glGetVertexArrayIndexed64iv(int vaobj, int index, int pname, java.nio.@Nullable LongBuffer param){
        glGetVertexArrayIndexed64iv_native_GLuint_GLuint_GLenum_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), vaobj, index, pname, param);
    }
    
    @QtUninvokable
    private native void glGetVertexArrayIndexed64iv_native_GLuint_GLuint_GLenum_GLint64_ptr(long __this__nativeId, int vaobj, int index, int pname, java.nio.LongBuffer param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetVertexArrayIndexediv(GLuint,<wbr/>GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetVertexArrayIndexediv(int vaobj, int index, int pname, java.nio.@Nullable IntBuffer param){
        glGetVertexArrayIndexediv_native_GLuint_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), vaobj, index, pname, param);
    }
    
    @QtUninvokable
    private native void glGetVertexArrayIndexediv_native_GLuint_GLuint_GLenum_GLint_ptr(long __this__nativeId, int vaobj, int index, int pname, java.nio.IntBuffer param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetVertexArrayiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetVertexArrayiv(int vaobj, int pname, java.nio.@Nullable IntBuffer param){
        glGetVertexArrayiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), vaobj, pname, param);
    }
    
    @QtUninvokable
    private native void glGetVertexArrayiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int vaobj, int pname, java.nio.IntBuffer param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetVertexAttribIiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetVertexAttribIiv(int index, int pname, java.nio.@Nullable IntBuffer params){
        glGetVertexAttribIiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribIiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int index, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetVertexAttribIuiv(GLuint,<wbr/>GLenum,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetVertexAttribIuiv(int index, int pname, java.nio.@Nullable IntBuffer params){
        glGetVertexAttribIuiv_native_GLuint_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribIuiv_native_GLuint_GLenum_GLuint_ptr(long __this__nativeId, int index, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetVertexAttribLdv(GLuint,<wbr/>GLenum,<wbr/>GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glGetVertexAttribLdv(int index, int pname, java.nio.@Nullable DoubleBuffer params){
        glGetVertexAttribLdv_native_GLuint_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribLdv_native_GLuint_GLenum_GLdouble_ptr(long __this__nativeId, int index, int pname, java.nio.DoubleBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetVertexAttribPointerv(GLuint,<wbr/>GLenum,<wbr/>void**)</code></p>
     */
    @QtUninvokable
    public final void glGetVertexAttribPointerv(int index, int pname, java.nio.@Nullable Buffer[] pointer){
        glGetVertexAttribPointerv_native_GLuint_GLenum_void_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, pointer);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribPointerv_native_GLuint_GLenum_void_ptr_ptr(long __this__nativeId, int index, int pname, java.nio.Buffer[] pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetVertexAttribdv(GLuint,<wbr/>GLenum,<wbr/>GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glGetVertexAttribdv(int index, int pname, java.nio.@Nullable DoubleBuffer params){
        glGetVertexAttribdv_native_GLuint_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribdv_native_GLuint_GLenum_GLdouble_ptr(long __this__nativeId, int index, int pname, java.nio.DoubleBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetVertexAttribfv(GLuint,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetVertexAttribfv(int index, int pname, java.nio.@Nullable FloatBuffer params){
        glGetVertexAttribfv_native_GLuint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribfv_native_GLuint_GLenum_GLfloat_ptr(long __this__nativeId, int index, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetVertexAttribiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetVertexAttribiv(int index, int pname, java.nio.@Nullable IntBuffer params){
        glGetVertexAttribiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int index, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetnColorTable(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glGetnColorTable(int target, int format, int type, int bufSize, java.nio.@Nullable Buffer table){
        glGetnColorTable_native_GLenum_GLenum_GLenum_GLsizei_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, format, type, bufSize, table);
    }
    
    @QtUninvokable
    private native void glGetnColorTable_native_GLenum_GLenum_GLenum_GLsizei_void_ptr(long __this__nativeId, int target, int format, int type, int bufSize, java.nio.Buffer table);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetnCompressedTexImage(GLenum,<wbr/>GLint,<wbr/>GLsizei,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glGetnCompressedTexImage(int target, int lod, int bufSize, java.nio.@Nullable Buffer pixels){
        glGetnCompressedTexImage_native_GLenum_GLint_GLsizei_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, lod, bufSize, pixels);
    }
    
    @QtUninvokable
    private native void glGetnCompressedTexImage_native_GLenum_GLint_GLsizei_void_ptr(long __this__nativeId, int target, int lod, int bufSize, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetnConvolutionFilter(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glGetnConvolutionFilter(int target, int format, int type, int bufSize, java.nio.@Nullable Buffer image){
        glGetnConvolutionFilter_native_GLenum_GLenum_GLenum_GLsizei_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, format, type, bufSize, image);
    }
    
    @QtUninvokable
    private native void glGetnConvolutionFilter_native_GLenum_GLenum_GLenum_GLsizei_void_ptr(long __this__nativeId, int target, int format, int type, int bufSize, java.nio.Buffer image);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetnHistogram(GLenum,<wbr/>GLboolean,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glGetnHistogram(int target, boolean reset, int format, int type, int bufSize, java.nio.@Nullable Buffer values){
        glGetnHistogram_native_GLenum_GLboolean_GLenum_GLenum_GLsizei_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, reset, format, type, bufSize, values);
    }
    
    @QtUninvokable
    private native void glGetnHistogram_native_GLenum_GLboolean_GLenum_GLenum_GLsizei_void_ptr(long __this__nativeId, int target, boolean reset, int format, int type, int bufSize, java.nio.Buffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetnMapdv(GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glGetnMapdv(int target, int query, int bufSize, java.nio.@Nullable DoubleBuffer v){
        glGetnMapdv_native_GLenum_GLenum_GLsizei_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, query, bufSize, v);
    }
    
    @QtUninvokable
    private native void glGetnMapdv_native_GLenum_GLenum_GLsizei_GLdouble_ptr(long __this__nativeId, int target, int query, int bufSize, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetnMapfv(GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetnMapfv(int target, int query, int bufSize, java.nio.@Nullable FloatBuffer v){
        glGetnMapfv_native_GLenum_GLenum_GLsizei_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, query, bufSize, v);
    }
    
    @QtUninvokable
    private native void glGetnMapfv_native_GLenum_GLenum_GLsizei_GLfloat_ptr(long __this__nativeId, int target, int query, int bufSize, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetnMapiv(GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetnMapiv(int target, int query, int bufSize, java.nio.@Nullable IntBuffer v){
        glGetnMapiv_native_GLenum_GLenum_GLsizei_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, query, bufSize, v);
    }
    
    @QtUninvokable
    private native void glGetnMapiv_native_GLenum_GLenum_GLsizei_GLint_ptr(long __this__nativeId, int target, int query, int bufSize, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetnMinmax(GLenum,<wbr/>GLboolean,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glGetnMinmax(int target, boolean reset, int format, int type, int bufSize, java.nio.@Nullable Buffer values){
        glGetnMinmax_native_GLenum_GLboolean_GLenum_GLenum_GLsizei_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, reset, format, type, bufSize, values);
    }
    
    @QtUninvokable
    private native void glGetnMinmax_native_GLenum_GLboolean_GLenum_GLenum_GLsizei_void_ptr(long __this__nativeId, int target, boolean reset, int format, int type, int bufSize, java.nio.Buffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetnPixelMapfv(GLenum,<wbr/>GLsizei,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetnPixelMapfv(int map, int bufSize, java.nio.@Nullable FloatBuffer values){
        glGetnPixelMapfv_native_GLenum_GLsizei_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, bufSize, values);
    }
    
    @QtUninvokable
    private native void glGetnPixelMapfv_native_GLenum_GLsizei_GLfloat_ptr(long __this__nativeId, int map, int bufSize, java.nio.FloatBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetnPixelMapuiv(GLenum,<wbr/>GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetnPixelMapuiv(int map, int bufSize, java.nio.@Nullable IntBuffer values){
        glGetnPixelMapuiv_native_GLenum_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, bufSize, values);
    }
    
    @QtUninvokable
    private native void glGetnPixelMapuiv_native_GLenum_GLsizei_GLuint_ptr(long __this__nativeId, int map, int bufSize, java.nio.IntBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetnPixelMapusv(GLenum,<wbr/>GLsizei,<wbr/>GLushort*)</code></p>
     */
    @QtUninvokable
    public final void glGetnPixelMapusv(int map, int bufSize, java.nio.@Nullable ShortBuffer values){
        glGetnPixelMapusv_native_GLenum_GLsizei_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, bufSize, values);
    }
    
    @QtUninvokable
    private native void glGetnPixelMapusv_native_GLenum_GLsizei_GLushort_ptr(long __this__nativeId, int map, int bufSize, java.nio.ShortBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetnPolygonStipple(GLsizei,<wbr/>GLubyte*)</code></p>
     */
    @QtUninvokable
    public final void glGetnPolygonStipple(int bufSize, java.nio.@Nullable ByteBuffer pattern){
        glGetnPolygonStipple_native_GLsizei_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), bufSize, pattern);
    }
    
    @QtUninvokable
    private native void glGetnPolygonStipple_native_GLsizei_GLubyte_ptr(long __this__nativeId, int bufSize, java.nio.ByteBuffer pattern);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetnSeparableFilter(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>void*,<wbr/>GLsizei,<wbr/>void*,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glGetnSeparableFilter(int target, int format, int type, int rowBufSize, java.nio.@Nullable Buffer row, int columnBufSize, java.nio.@Nullable Buffer column, java.nio.@Nullable Buffer span){
        glGetnSeparableFilter_native_GLenum_GLenum_GLenum_GLsizei_void_ptr_GLsizei_void_ptr_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, format, type, rowBufSize, row, columnBufSize, column, span);
    }
    
    @QtUninvokable
    private native void glGetnSeparableFilter_native_GLenum_GLenum_GLenum_GLsizei_void_ptr_GLsizei_void_ptr_void_ptr(long __this__nativeId, int target, int format, int type, int rowBufSize, java.nio.Buffer row, int columnBufSize, java.nio.Buffer column, java.nio.Buffer span);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetnTexImage(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glGetnTexImage(int target, int level, int format, int type, int bufSize, java.nio.@Nullable Buffer pixels){
        glGetnTexImage_native_GLenum_GLint_GLenum_GLenum_GLsizei_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, format, type, bufSize, pixels);
    }
    
    @QtUninvokable
    private native void glGetnTexImage_native_GLenum_GLint_GLenum_GLenum_GLsizei_void_ptr(long __this__nativeId, int target, int level, int format, int type, int bufSize, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetnUniformdv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glGetnUniformdv(int program, int location, int bufSize, java.nio.@Nullable DoubleBuffer params){
        glGetnUniformdv_native_GLuint_GLint_GLsizei_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, bufSize, params);
    }
    
    @QtUninvokable
    private native void glGetnUniformdv_native_GLuint_GLint_GLsizei_GLdouble_ptr(long __this__nativeId, int program, int location, int bufSize, java.nio.DoubleBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetnUniformfv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetnUniformfv(int program, int location, int bufSize, java.nio.@Nullable FloatBuffer params){
        glGetnUniformfv_native_GLuint_GLint_GLsizei_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, bufSize, params);
    }
    
    @QtUninvokable
    private native void glGetnUniformfv_native_GLuint_GLint_GLsizei_GLfloat_ptr(long __this__nativeId, int program, int location, int bufSize, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetnUniformiv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetnUniformiv(int program, int location, int bufSize, java.nio.@Nullable IntBuffer params){
        glGetnUniformiv_native_GLuint_GLint_GLsizei_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, bufSize, params);
    }
    
    @QtUninvokable
    private native void glGetnUniformiv_native_GLuint_GLint_GLsizei_GLint_ptr(long __this__nativeId, int program, int location, int bufSize, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glGetnUniformuiv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetnUniformuiv(int program, int location, int bufSize, java.nio.@Nullable IntBuffer params){
        glGetnUniformuiv_native_GLuint_GLint_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, bufSize, params);
    }
    
    @QtUninvokable
    private native void glGetnUniformuiv_native_GLuint_GLint_GLsizei_GLuint_ptr(long __this__nativeId, int program, int location, int bufSize, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glHint(GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glHint(int target, int mode){
        glHint_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, mode);
    }
    
    @QtUninvokable
    private native void glHint_native_GLenum_GLenum(long __this__nativeId, int target, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glHistogram(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glHistogram(int target, int width, int internalformat, boolean sink){
        glHistogram_native_GLenum_GLsizei_GLenum_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, width, internalformat, sink);
    }
    
    @QtUninvokable
    private native void glHistogram_native_GLenum_GLsizei_GLenum_GLboolean(long __this__nativeId, int target, int width, int internalformat, boolean sink);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIndexMask(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glIndexMask(int mask){
        glIndexMask_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glIndexMask_native_GLuint(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIndexPointer(GLenum,<wbr/>GLsizei,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glIndexPointer(int type, int stride, java.nio.@Nullable Buffer pointer){
        glIndexPointer_native_GLenum_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glIndexPointer_native_GLenum_GLsizei_const_void_ptr(long __this__nativeId, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIndexd(GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glIndexd(double c){
        glIndexd_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexd_native_GLdouble(long __this__nativeId, double c);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIndexdv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glIndexdv(double[] c){
        if(c!=null && c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexdv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexdv_native_const_GLdouble_ptr(long __this__nativeId, double[] c);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIndexf(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glIndexf(float c){
        glIndexf_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexf_native_GLfloat(long __this__nativeId, float c);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIndexfv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glIndexfv(float[] c){
        if(c!=null && c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexfv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexfv_native_const_GLfloat_ptr(long __this__nativeId, float[] c);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIndexi(GLint)</code></p>
     */
    @QtUninvokable
    public final void glIndexi(int c){
        glIndexi_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexi_native_GLint(long __this__nativeId, int c);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIndexiv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glIndexiv(int[] c){
        if(c!=null && c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexiv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexiv_native_const_GLint_ptr(long __this__nativeId, int[] c);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIndexs(GLshort)</code></p>
     */
    @QtUninvokable
    public final void glIndexs(short c){
        glIndexs_native_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexs_native_GLshort(long __this__nativeId, short c);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIndexsv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glIndexsv(short[] c){
        if(c!=null && c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexsv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexsv_native_const_GLshort_ptr(long __this__nativeId, short[] c);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIndexub(GLubyte)</code></p>
     */
    @QtUninvokable
    public final void glIndexub(byte c){
        glIndexub_native_GLubyte(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexub_native_GLubyte(long __this__nativeId, byte c);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIndexubv(const GLubyte*)</code></p>
     */
    @QtUninvokable
    public final void glIndexubv(byte[] c){
        if(c!=null && c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexubv_native_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexubv_native_const_GLubyte_ptr(long __this__nativeId, byte[] c);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glInitNames()</code></p>
     */
    @QtUninvokable
    public final void glInitNames(){
        glInitNames_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glInitNames_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glInterleavedArrays(GLenum,<wbr/>GLsizei,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glInterleavedArrays(int format, int stride, java.nio.@Nullable Buffer pointer){
        glInterleavedArrays_native_GLenum_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), format, stride, pointer);
    }
    
    @QtUninvokable
    private native void glInterleavedArrays_native_GLenum_GLsizei_const_void_ptr(long __this__nativeId, int format, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glInvalidateBufferData(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glInvalidateBufferData(int buffer){
        glInvalidateBufferData_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), buffer);
    }
    
    @QtUninvokable
    private native void glInvalidateBufferData_native_GLuint(long __this__nativeId, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glInvalidateBufferSubData(GLuint,<wbr/>GLintptr,<wbr/>GLsizeiptr)</code></p>
     */
    @QtUninvokable
    public final void glInvalidateBufferSubData(int buffer, long offset, long length){
        glInvalidateBufferSubData_native_GLuint_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, offset, length);
    }
    
    @QtUninvokable
    private native void glInvalidateBufferSubData_native_GLuint_GLintptr_GLsizeiptr(long __this__nativeId, int buffer, long offset, long length);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glInvalidateFramebuffer(GLenum,<wbr/>GLsizei,<wbr/>const GLenum*)</code></p>
     */
    @QtUninvokable
    public final void glInvalidateFramebuffer(int target, int numAttachments, java.nio.@Nullable IntBuffer attachments){
        glInvalidateFramebuffer_native_GLenum_GLsizei_const_GLenum_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, numAttachments, attachments);
    }
    
    @QtUninvokable
    private native void glInvalidateFramebuffer_native_GLenum_GLsizei_const_GLenum_ptr(long __this__nativeId, int target, int numAttachments, java.nio.IntBuffer attachments);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glInvalidateNamedFramebufferData(GLuint,<wbr/>GLsizei,<wbr/>const GLenum*)</code></p>
     */
    @QtUninvokable
    public final void glInvalidateNamedFramebufferData(int framebuffer, int numAttachments, java.nio.@Nullable IntBuffer attachments){
        glInvalidateNamedFramebufferData_native_GLuint_GLsizei_const_GLenum_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer, numAttachments, attachments);
    }
    
    @QtUninvokable
    private native void glInvalidateNamedFramebufferData_native_GLuint_GLsizei_const_GLenum_ptr(long __this__nativeId, int framebuffer, int numAttachments, java.nio.IntBuffer attachments);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glInvalidateNamedFramebufferSubData(GLuint,<wbr/>GLsizei,<wbr/>const GLenum*,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glInvalidateNamedFramebufferSubData(int framebuffer, int numAttachments, java.nio.@Nullable IntBuffer attachments, int x, int y, int width, int height){
        glInvalidateNamedFramebufferSubData_native_GLuint_GLsizei_const_GLenum_ptr_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer, numAttachments, attachments, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glInvalidateNamedFramebufferSubData_native_GLuint_GLsizei_const_GLenum_ptr_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int framebuffer, int numAttachments, java.nio.IntBuffer attachments, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glInvalidateSubFramebuffer(GLenum,<wbr/>GLsizei,<wbr/>const GLenum*,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glInvalidateSubFramebuffer(int target, int numAttachments, java.nio.@Nullable IntBuffer attachments, int x, int y, int width, int height){
        glInvalidateSubFramebuffer_native_GLenum_GLsizei_const_GLenum_ptr_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, numAttachments, attachments, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glInvalidateSubFramebuffer_native_GLenum_GLsizei_const_GLenum_ptr_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int numAttachments, java.nio.IntBuffer attachments, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glInvalidateTexImage(GLuint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glInvalidateTexImage(int texture, int level){
        glInvalidateTexImage_native_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level);
    }
    
    @QtUninvokable
    private native void glInvalidateTexImage_native_GLuint_GLint(long __this__nativeId, int texture, int level);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glInvalidateTexSubImage(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glInvalidateTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth){
        glInvalidateTexSubImage_native_GLuint_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level, xoffset, yoffset, zoffset, width, height, depth);
    }
    
    @QtUninvokable
    private native void glInvalidateTexSubImage_native_GLuint_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei(long __this__nativeId, int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIsBuffer(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsBuffer(int buffer){
        return glIsBuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), buffer);
    }
    
    @QtUninvokable
    private native boolean glIsBuffer_native_GLuint(long __this__nativeId, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIsEnabled(GLenum)</code></p>
     */
    @QtUninvokable
    public final boolean glIsEnabled(int cap){
        return glIsEnabled_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native boolean glIsEnabled_native_GLenum(long __this__nativeId, int cap);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIsEnabledi(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsEnabledi(int target, int index){
        return glIsEnabledi_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index);
    }
    
    @QtUninvokable
    private native boolean glIsEnabledi_native_GLenum_GLuint(long __this__nativeId, int target, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIsFramebuffer(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsFramebuffer(int framebuffer){
        return glIsFramebuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer);
    }
    
    @QtUninvokable
    private native boolean glIsFramebuffer_native_GLuint(long __this__nativeId, int framebuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIsList(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsList(int list){
        return glIsList_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), list);
    }
    
    @QtUninvokable
    private native boolean glIsList_native_GLuint(long __this__nativeId, int list);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIsProgram(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsProgram(int program){
        return glIsProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native boolean glIsProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIsProgramPipeline(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsProgramPipeline(int pipeline){
        return glIsProgramPipeline_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), pipeline);
    }
    
    @QtUninvokable
    private native boolean glIsProgramPipeline_native_GLuint(long __this__nativeId, int pipeline);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIsQuery(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsQuery(int id){
        return glIsQuery_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @QtUninvokable
    private native boolean glIsQuery_native_GLuint(long __this__nativeId, int id);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIsRenderbuffer(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsRenderbuffer(int renderbuffer){
        return glIsRenderbuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), renderbuffer);
    }
    
    @QtUninvokable
    private native boolean glIsRenderbuffer_native_GLuint(long __this__nativeId, int renderbuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIsSampler(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsSampler(int sampler){
        return glIsSampler_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), sampler);
    }
    
    @QtUninvokable
    private native boolean glIsSampler_native_GLuint(long __this__nativeId, int sampler);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIsShader(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsShader(int shader){
        return glIsShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @QtUninvokable
    private native boolean glIsShader_native_GLuint(long __this__nativeId, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIsSync(GLsync)</code></p>
     */
    @QtUninvokable
    public final boolean glIsSync(io.qt.gui.gl.@Nullable GLsync sync){
        return glIsSync_native___GLsync_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync));
    }
    
    @QtUninvokable
    private native boolean glIsSync_native___GLsync_ptr(long __this__nativeId, long sync);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIsTexture(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsTexture(int texture){
        return glIsTexture_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @QtUninvokable
    private native boolean glIsTexture_native_GLuint(long __this__nativeId, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIsTransformFeedback(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsTransformFeedback(int id){
        return glIsTransformFeedback_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @QtUninvokable
    private native boolean glIsTransformFeedback_native_GLuint(long __this__nativeId, int id);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glIsVertexArray(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsVertexArray(int array){
        return glIsVertexArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), array);
    }
    
    @QtUninvokable
    private native boolean glIsVertexArray_native_GLuint(long __this__nativeId, int array);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glLightModelf(GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glLightModelf(int pname, float param){
        glLightModelf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glLightModelf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glLightModelfv(GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glLightModelfv(int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glLightModelfv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glLightModelfv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glLightModeli(GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glLightModeli(int pname, int param){
        glLightModeli_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glLightModeli_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glLightModeliv(GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glLightModeliv(int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glLightModeliv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glLightModeliv_native_GLenum_const_GLint_ptr(long __this__nativeId, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glLightf(GLenum,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glLightf(int light, int pname, float param){
        glLightf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, param);
    }
    
    @QtUninvokable
    private native void glLightf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int light, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glLightfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glLightfv(int light, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glLightfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, params);
    }
    
    @QtUninvokable
    private native void glLightfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int light, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glLighti(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glLighti(int light, int pname, int param){
        glLighti_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, param);
    }
    
    @QtUninvokable
    private native void glLighti_native_GLenum_GLenum_GLint(long __this__nativeId, int light, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glLightiv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glLightiv(int light, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glLightiv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, params);
    }
    
    @QtUninvokable
    private native void glLightiv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int light, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glLineStipple(GLint,<wbr/>GLushort)</code></p>
     */
    @QtUninvokable
    public final void glLineStipple(int factor, short pattern){
        glLineStipple_native_GLint_GLushort(QtJambi_LibraryUtilities.internal.nativeId(this), factor, pattern);
    }
    
    @QtUninvokable
    private native void glLineStipple_native_GLint_GLushort(long __this__nativeId, int factor, short pattern);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glLineWidth(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glLineWidth(float width){
        glLineWidth_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), width);
    }
    
    @QtUninvokable
    private native void glLineWidth_native_GLfloat(long __this__nativeId, float width);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glLinkProgram(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glLinkProgram(int program){
        glLinkProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glLinkProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glListBase(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glListBase(int base){
        glListBase_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), base);
    }
    
    @QtUninvokable
    private native void glListBase_native_GLuint(long __this__nativeId, int base);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glLoadIdentity()</code></p>
     */
    @QtUninvokable
    public final void glLoadIdentity(){
        glLoadIdentity_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glLoadIdentity_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glLoadMatrixd(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glLoadMatrixd(double[] m){
        if(m!=null && m.length < 16)
            throw new IllegalArgumentException("Argument 'm': Wrong number of elements in array. Found: " + m.length + ", expected: 16");
        glLoadMatrixd_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glLoadMatrixd_native_const_GLdouble_ptr(long __this__nativeId, double[] m);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glLoadMatrixf(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glLoadMatrixf(float[] m){
        if(m!=null && m.length < 16)
            throw new IllegalArgumentException("Argument 'm': Wrong number of elements in array. Found: " + m.length + ", expected: 16");
        glLoadMatrixf_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glLoadMatrixf_native_const_GLfloat_ptr(long __this__nativeId, float[] m);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glLoadName(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glLoadName(int name){
        glLoadName_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void glLoadName_native_GLuint(long __this__nativeId, int name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glLoadTransposeMatrixd(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glLoadTransposeMatrixd(java.nio.@Nullable DoubleBuffer m){
        glLoadTransposeMatrixd_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glLoadTransposeMatrixd_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer m);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glLoadTransposeMatrixf(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glLoadTransposeMatrixf(java.nio.@Nullable FloatBuffer m){
        glLoadTransposeMatrixf_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glLoadTransposeMatrixf_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer m);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glLogicOp(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glLogicOp(int opcode){
        glLogicOp_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), opcode);
    }
    
    @QtUninvokable
    private native void glLogicOp_native_GLenum(long __this__nativeId, int opcode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMap1d(GLenum,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLint,<wbr/>GLint,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMap1d(int target, double u1, double u2, int stride, int order, java.nio.@Nullable DoubleBuffer points){
        glMap1d_native_GLenum_GLdouble_GLdouble_GLint_GLint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, u1, u2, stride, order, points);
    }
    
    @QtUninvokable
    private native void glMap1d_native_GLenum_GLdouble_GLdouble_GLint_GLint_const_GLdouble_ptr(long __this__nativeId, int target, double u1, double u2, int stride, int order, java.nio.DoubleBuffer points);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMap1f(GLenum,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLint,<wbr/>GLint,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMap1f(int target, float u1, float u2, int stride, int order, java.nio.@Nullable FloatBuffer points){
        glMap1f_native_GLenum_GLfloat_GLfloat_GLint_GLint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, u1, u2, stride, order, points);
    }
    
    @QtUninvokable
    private native void glMap1f_native_GLenum_GLfloat_GLfloat_GLint_GLint_const_GLfloat_ptr(long __this__nativeId, int target, float u1, float u2, int stride, int order, java.nio.FloatBuffer points);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMap2d(GLenum,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLint,<wbr/>GLint,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLint,<wbr/>GLint,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMap2d(int target, double u1, double u2, int ustride, int uorder, double v1, double v2, int vstride, int vorder, java.nio.@Nullable DoubleBuffer points){
        glMap2d_native_GLenum_GLdouble_GLdouble_GLint_GLint_GLdouble_GLdouble_GLint_GLint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
    }
    
    @QtUninvokable
    private native void glMap2d_native_GLenum_GLdouble_GLdouble_GLint_GLint_GLdouble_GLdouble_GLint_GLint_const_GLdouble_ptr(long __this__nativeId, int target, double u1, double u2, int ustride, int uorder, double v1, double v2, int vstride, int vorder, java.nio.DoubleBuffer points);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMap2f(GLenum,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLint,<wbr/>GLint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLint,<wbr/>GLint,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMap2f(int target, float u1, float u2, int ustride, int uorder, float v1, float v2, int vstride, int vorder, java.nio.@Nullable FloatBuffer points){
        glMap2f_native_GLenum_GLfloat_GLfloat_GLint_GLint_GLfloat_GLfloat_GLint_GLint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
    }
    
    @QtUninvokable
    private native void glMap2f_native_GLenum_GLfloat_GLfloat_GLint_GLint_GLfloat_GLfloat_GLint_GLint_const_GLfloat_ptr(long __this__nativeId, int target, float u1, float u2, int ustride, int uorder, float v1, float v2, int vstride, int vorder, java.nio.FloatBuffer points);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMapBuffer(GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final java.nio.@Nullable Buffer glMapBuffer(int target, int access){
        return glMapBuffer_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, access);
    }
    
    @QtUninvokable
    private native java.nio.Buffer glMapBuffer_native_GLenum_GLenum(long __this__nativeId, int target, int access);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMapBufferRange(GLenum,<wbr/>GLintptr,<wbr/>GLsizeiptr,<wbr/>GLbitfield)</code></p>
     */
    @QtUninvokable
    public final java.nio.@Nullable Buffer glMapBufferRange(int target, long offset, int access){
        return glMapBufferRange_native_GLenum_GLintptr_GLsizeiptr_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, access);
    }
    
    @QtUninvokable
    private native java.nio.Buffer glMapBufferRange_native_GLenum_GLintptr_GLsizeiptr_GLbitfield(long __this__nativeId, int target, long offset, int access);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMapGrid1d(GLint,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glMapGrid1d(int un, double u1, double u2){
        glMapGrid1d_native_GLint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), un, u1, u2);
    }
    
    @QtUninvokable
    private native void glMapGrid1d_native_GLint_GLdouble_GLdouble(long __this__nativeId, int un, double u1, double u2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMapGrid1f(GLint,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glMapGrid1f(int un, float u1, float u2){
        glMapGrid1f_native_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), un, u1, u2);
    }
    
    @QtUninvokable
    private native void glMapGrid1f_native_GLint_GLfloat_GLfloat(long __this__nativeId, int un, float u1, float u2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMapGrid2d(GLint,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLint,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glMapGrid2d(int un, double u1, double u2, int vn, double v1, double v2){
        glMapGrid2d_native_GLint_GLdouble_GLdouble_GLint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), un, u1, u2, vn, v1, v2);
    }
    
    @QtUninvokable
    private native void glMapGrid2d_native_GLint_GLdouble_GLdouble_GLint_GLdouble_GLdouble(long __this__nativeId, int un, double u1, double u2, int vn, double v1, double v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMapGrid2f(GLint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLint,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glMapGrid2f(int un, float u1, float u2, int vn, float v1, float v2){
        glMapGrid2f_native_GLint_GLfloat_GLfloat_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), un, u1, u2, vn, v1, v2);
    }
    
    @QtUninvokable
    private native void glMapGrid2f_native_GLint_GLfloat_GLfloat_GLint_GLfloat_GLfloat(long __this__nativeId, int un, float u1, float u2, int vn, float v1, float v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMapNamedBuffer(GLuint,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final java.nio.@Nullable Buffer glMapNamedBuffer(int buffer, int access){
        return glMapNamedBuffer_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, access);
    }
    
    @QtUninvokable
    private native java.nio.Buffer glMapNamedBuffer_native_GLuint_GLenum(long __this__nativeId, int buffer, int access);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMapNamedBufferRange(GLuint,<wbr/>GLintptr,<wbr/>GLsizei,<wbr/>GLbitfield)</code></p>
     */
    @QtUninvokable
    public final java.nio.@Nullable Buffer glMapNamedBufferRange(int buffer, long offset, int length, int access){
        return glMapNamedBufferRange_native_GLuint_GLintptr_GLsizei_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, offset, length, access);
    }
    
    @QtUninvokable
    private native java.nio.Buffer glMapNamedBufferRange_native_GLuint_GLintptr_GLsizei_GLbitfield(long __this__nativeId, int buffer, long offset, int length, int access);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMaterialf(GLenum,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glMaterialf(int face, int pname, float param){
        glMaterialf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, param);
    }
    
    @QtUninvokable
    private native void glMaterialf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int face, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMaterialfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMaterialfv(int face, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glMaterialfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, params);
    }
    
    @QtUninvokable
    private native void glMaterialfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int face, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMateriali(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glMateriali(int face, int pname, int param){
        glMateriali_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, param);
    }
    
    @QtUninvokable
    private native void glMateriali_native_GLenum_GLenum_GLint(long __this__nativeId, int face, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMaterialiv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glMaterialiv(int face, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glMaterialiv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, params);
    }
    
    @QtUninvokable
    private native void glMaterialiv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int face, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMatrixMode(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glMatrixMode(int mode){
        glMatrixMode_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glMatrixMode_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMemoryBarrier(GLbitfield)</code></p>
     */
    @QtUninvokable
    public final void glMemoryBarrier(int barriers){
        glMemoryBarrier_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), barriers);
    }
    
    @QtUninvokable
    private native void glMemoryBarrier_native_GLbitfield(long __this__nativeId, int barriers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMemoryBarrierByRegion(GLbitfield)</code></p>
     */
    @QtUninvokable
    public final void glMemoryBarrierByRegion(int barriers){
        glMemoryBarrierByRegion_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), barriers);
    }
    
    @QtUninvokable
    private native void glMemoryBarrierByRegion_native_GLbitfield(long __this__nativeId, int barriers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMinSampleShading(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glMinSampleShading(float value){
        glMinSampleShading_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void glMinSampleShading_native_GLfloat(long __this__nativeId, float value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMinmax(GLenum,<wbr/>GLenum,<wbr/>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glMinmax(int target, int internalformat, boolean sink){
        glMinmax_native_GLenum_GLenum_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, sink);
    }
    
    @QtUninvokable
    private native void glMinmax_native_GLenum_GLenum_GLboolean(long __this__nativeId, int target, int internalformat, boolean sink);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultMatrixd(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMultMatrixd(double[] m){
        if(m!=null && m.length < 16)
            throw new IllegalArgumentException("Argument 'm': Wrong number of elements in array. Found: " + m.length + ", expected: 16");
        glMultMatrixd_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glMultMatrixd_native_const_GLdouble_ptr(long __this__nativeId, double[] m);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultMatrixf(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMultMatrixf(float[] m){
        if(m!=null && m.length < 16)
            throw new IllegalArgumentException("Argument 'm': Wrong number of elements in array. Found: " + m.length + ", expected: 16");
        glMultMatrixf_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glMultMatrixf_native_const_GLfloat_ptr(long __this__nativeId, float[] m);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultTransposeMatrixd(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMultTransposeMatrixd(java.nio.@Nullable DoubleBuffer m){
        glMultTransposeMatrixd_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glMultTransposeMatrixd_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer m);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultTransposeMatrixf(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMultTransposeMatrixf(java.nio.@Nullable FloatBuffer m){
        glMultTransposeMatrixf_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glMultTransposeMatrixf_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer m);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiDrawArrays(GLenum,<wbr/>const GLint*,<wbr/>const GLsizei*,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glMultiDrawArrays(int mode, java.nio.@Nullable IntBuffer first, java.nio.@Nullable IntBuffer count, int drawcount){
        glMultiDrawArrays_native_GLenum_const_GLint_ptr_const_GLsizei_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count, drawcount);
    }
    
    @QtUninvokable
    private native void glMultiDrawArrays_native_GLenum_const_GLint_ptr_const_GLsizei_ptr_GLsizei(long __this__nativeId, int mode, java.nio.IntBuffer first, java.nio.IntBuffer count, int drawcount);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiDrawArraysIndirect(GLenum,<wbr/>const void*,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glMultiDrawArraysIndirect(int mode, java.nio.@Nullable Buffer indirect, int drawcount, int stride){
        glMultiDrawArraysIndirect_native_GLenum_const_void_ptr_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, indirect, drawcount, stride);
    }
    
    @QtUninvokable
    private native void glMultiDrawArraysIndirect_native_GLenum_const_void_ptr_GLsizei_GLsizei(long __this__nativeId, int mode, java.nio.Buffer indirect, int drawcount, int stride);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiDrawElements(GLenum,<wbr/>const GLsizei*,<wbr/>GLenum,<wbr/>const void*const*,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glMultiDrawElements(int mode, java.nio.@Nullable IntBuffer count, int type, java.nio.Buffer @StrictNonNull[] indices, int drawcount){
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glMultiDrawElements_native_GLenum_const_GLsizei_ptr_GLenum_const_void_cptr_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, drawcount);
    }
    
    @QtUninvokable
    private native void glMultiDrawElements_native_GLenum_const_GLsizei_ptr_GLenum_const_void_cptr_ptr_GLsizei(long __this__nativeId, int mode, java.nio.IntBuffer count, int type, java.nio.Buffer[] indices, int drawcount);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiDrawElementsBaseVertex(GLenum,<wbr/>const GLsizei*,<wbr/>GLenum,<wbr/>const void*const*,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glMultiDrawElementsBaseVertex(int mode, java.nio.@Nullable IntBuffer count, int type, java.nio.Buffer @StrictNonNull[] indices, int drawcount, java.nio.@Nullable IntBuffer basevertex){
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glMultiDrawElementsBaseVertex_native_GLenum_const_GLsizei_ptr_GLenum_const_void_cptr_ptr_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, drawcount, basevertex);
    }
    
    @QtUninvokable
    private native void glMultiDrawElementsBaseVertex_native_GLenum_const_GLsizei_ptr_GLenum_const_void_cptr_ptr_GLsizei_const_GLint_ptr(long __this__nativeId, int mode, java.nio.IntBuffer count, int type, java.nio.Buffer[] indices, int drawcount, java.nio.IntBuffer basevertex);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiDrawElementsIndirect(GLenum,<wbr/>GLenum,<wbr/>const void*,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glMultiDrawElementsIndirect(int mode, int type, java.nio.@Nullable Buffer indirect, int drawcount, int stride){
        glMultiDrawElementsIndirect_native_GLenum_GLenum_const_void_ptr_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, type, indirect, drawcount, stride);
    }
    
    @QtUninvokable
    private native void glMultiDrawElementsIndirect_native_GLenum_GLenum_const_void_ptr_GLsizei_GLsizei(long __this__nativeId, int mode, int type, java.nio.Buffer indirect, int drawcount, int stride);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord1d(GLenum,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1d(int target, double s){
        glMultiTexCoord1d_native_GLenum_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), target, s);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1d_native_GLenum_GLdouble(long __this__nativeId, int target, double s);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord1dv(GLenum,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1dv(int target, java.nio.@Nullable DoubleBuffer v){
        glMultiTexCoord1dv_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1dv_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int target, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord1f(GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1f(int target, float s){
        glMultiTexCoord1f_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, s);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1f_native_GLenum_GLfloat(long __this__nativeId, int target, float s);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord1fv(GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1fv(int target, java.nio.@Nullable FloatBuffer v){
        glMultiTexCoord1fv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1fv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord1i(GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1i(int target, int s){
        glMultiTexCoord1i_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, s);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1i_native_GLenum_GLint(long __this__nativeId, int target, int s);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord1iv(GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1iv(int target, java.nio.@Nullable IntBuffer v){
        glMultiTexCoord1iv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1iv_native_GLenum_const_GLint_ptr(long __this__nativeId, int target, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord1s(GLenum,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1s(int target, short s){
        glMultiTexCoord1s_native_GLenum_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), target, s);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1s_native_GLenum_GLshort(long __this__nativeId, int target, short s);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord1sv(GLenum,<wbr/>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1sv(int target, java.nio.@Nullable ShortBuffer v){
        glMultiTexCoord1sv_native_GLenum_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1sv_native_GLenum_const_GLshort_ptr(long __this__nativeId, int target, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord2d(GLenum,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2d(int target, double s, double t){
        glMultiTexCoord2d_native_GLenum_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2d_native_GLenum_GLdouble_GLdouble(long __this__nativeId, int target, double s, double t);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord2dv(GLenum,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2dv(int target, java.nio.@Nullable DoubleBuffer v){
        glMultiTexCoord2dv_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2dv_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int target, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord2f(GLenum,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2f(int target, float s, float t){
        glMultiTexCoord2f_native_GLenum_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2f_native_GLenum_GLfloat_GLfloat(long __this__nativeId, int target, float s, float t);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord2fv(GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2fv(int target, java.nio.@Nullable FloatBuffer v){
        glMultiTexCoord2fv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2fv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord2i(GLenum,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2i(int target, int s, int t){
        glMultiTexCoord2i_native_GLenum_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2i_native_GLenum_GLint_GLint(long __this__nativeId, int target, int s, int t);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord2iv(GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2iv(int target, java.nio.@Nullable IntBuffer v){
        glMultiTexCoord2iv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2iv_native_GLenum_const_GLint_ptr(long __this__nativeId, int target, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord2s(GLenum,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2s(int target, short s, short t){
        glMultiTexCoord2s_native_GLenum_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2s_native_GLenum_GLshort_GLshort(long __this__nativeId, int target, short s, short t);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord2sv(GLenum,<wbr/>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2sv(int target, java.nio.@Nullable ShortBuffer v){
        glMultiTexCoord2sv_native_GLenum_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2sv_native_GLenum_const_GLshort_ptr(long __this__nativeId, int target, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord3d(GLenum,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3d(int target, double s, double t, double r){
        glMultiTexCoord3d_native_GLenum_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3d_native_GLenum_GLdouble_GLdouble_GLdouble(long __this__nativeId, int target, double s, double t, double r);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord3dv(GLenum,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3dv(int target, java.nio.@Nullable DoubleBuffer v){
        glMultiTexCoord3dv_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3dv_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int target, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord3f(GLenum,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3f(int target, float s, float t, float r){
        glMultiTexCoord3f_native_GLenum_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3f_native_GLenum_GLfloat_GLfloat_GLfloat(long __this__nativeId, int target, float s, float t, float r);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord3fv(GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3fv(int target, java.nio.@Nullable FloatBuffer v){
        glMultiTexCoord3fv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3fv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord3i(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3i(int target, int s, int t, int r){
        glMultiTexCoord3i_native_GLenum_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3i_native_GLenum_GLint_GLint_GLint(long __this__nativeId, int target, int s, int t, int r);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord3iv(GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3iv(int target, java.nio.@Nullable IntBuffer v){
        glMultiTexCoord3iv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3iv_native_GLenum_const_GLint_ptr(long __this__nativeId, int target, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord3s(GLenum,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3s(int target, short s, short t, short r){
        glMultiTexCoord3s_native_GLenum_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3s_native_GLenum_GLshort_GLshort_GLshort(long __this__nativeId, int target, short s, short t, short r);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord3sv(GLenum,<wbr/>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3sv(int target, java.nio.@Nullable ShortBuffer v){
        glMultiTexCoord3sv_native_GLenum_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3sv_native_GLenum_const_GLshort_ptr(long __this__nativeId, int target, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord4d(GLenum,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4d(int target, double s, double t, double r, double q){
        glMultiTexCoord4d_native_GLenum_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r, q);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4d_native_GLenum_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, int target, double s, double t, double r, double q);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord4dv(GLenum,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4dv(int target, java.nio.@Nullable DoubleBuffer v){
        glMultiTexCoord4dv_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4dv_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int target, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord4f(GLenum,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4f(int target, float s, float t, float r, float q){
        glMultiTexCoord4f_native_GLenum_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r, q);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4f_native_GLenum_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int target, float s, float t, float r, float q);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord4fv(GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4fv(int target, java.nio.@Nullable FloatBuffer v){
        glMultiTexCoord4fv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4fv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord4i(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4i(int target, int s, int t, int r, int q){
        glMultiTexCoord4i_native_GLenum_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r, q);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4i_native_GLenum_GLint_GLint_GLint_GLint(long __this__nativeId, int target, int s, int t, int r, int q);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord4iv(GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4iv(int target, java.nio.@Nullable IntBuffer v){
        glMultiTexCoord4iv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4iv_native_GLenum_const_GLint_ptr(long __this__nativeId, int target, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord4s(GLenum,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4s(int target, short s, short t, short r, short q){
        glMultiTexCoord4s_native_GLenum_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r, q);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4s_native_GLenum_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, int target, short s, short t, short r, short q);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoord4sv(GLenum,<wbr/>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4sv(int target, java.nio.@Nullable ShortBuffer v){
        glMultiTexCoord4sv_native_GLenum_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4sv_native_GLenum_const_GLshort_ptr(long __this__nativeId, int target, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoordP1ui(GLenum,<wbr/>GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoordP1ui(int texture, int type, int coords){
        glMultiTexCoordP1ui_native_GLenum_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), texture, type, coords);
    }
    
    @QtUninvokable
    private native void glMultiTexCoordP1ui_native_GLenum_GLenum_GLuint(long __this__nativeId, int texture, int type, int coords);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoordP1uiv(GLenum,<wbr/>GLenum,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoordP1uiv(int texture, int type, java.nio.@Nullable IntBuffer coords){
        glMultiTexCoordP1uiv_native_GLenum_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, type, coords);
    }
    
    @QtUninvokable
    private native void glMultiTexCoordP1uiv_native_GLenum_GLenum_const_GLuint_ptr(long __this__nativeId, int texture, int type, java.nio.IntBuffer coords);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoordP2ui(GLenum,<wbr/>GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoordP2ui(int texture, int type, int coords){
        glMultiTexCoordP2ui_native_GLenum_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), texture, type, coords);
    }
    
    @QtUninvokable
    private native void glMultiTexCoordP2ui_native_GLenum_GLenum_GLuint(long __this__nativeId, int texture, int type, int coords);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoordP2uiv(GLenum,<wbr/>GLenum,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoordP2uiv(int texture, int type, java.nio.@Nullable IntBuffer coords){
        glMultiTexCoordP2uiv_native_GLenum_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, type, coords);
    }
    
    @QtUninvokable
    private native void glMultiTexCoordP2uiv_native_GLenum_GLenum_const_GLuint_ptr(long __this__nativeId, int texture, int type, java.nio.IntBuffer coords);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoordP3ui(GLenum,<wbr/>GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoordP3ui(int texture, int type, int coords){
        glMultiTexCoordP3ui_native_GLenum_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), texture, type, coords);
    }
    
    @QtUninvokable
    private native void glMultiTexCoordP3ui_native_GLenum_GLenum_GLuint(long __this__nativeId, int texture, int type, int coords);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoordP3uiv(GLenum,<wbr/>GLenum,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoordP3uiv(int texture, int type, java.nio.@Nullable IntBuffer coords){
        glMultiTexCoordP3uiv_native_GLenum_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, type, coords);
    }
    
    @QtUninvokable
    private native void glMultiTexCoordP3uiv_native_GLenum_GLenum_const_GLuint_ptr(long __this__nativeId, int texture, int type, java.nio.IntBuffer coords);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoordP4ui(GLenum,<wbr/>GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoordP4ui(int texture, int type, int coords){
        glMultiTexCoordP4ui_native_GLenum_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), texture, type, coords);
    }
    
    @QtUninvokable
    private native void glMultiTexCoordP4ui_native_GLenum_GLenum_GLuint(long __this__nativeId, int texture, int type, int coords);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glMultiTexCoordP4uiv(GLenum,<wbr/>GLenum,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoordP4uiv(int texture, int type, java.nio.@Nullable IntBuffer coords){
        glMultiTexCoordP4uiv_native_GLenum_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, type, coords);
    }
    
    @QtUninvokable
    private native void glMultiTexCoordP4uiv_native_GLenum_GLenum_const_GLuint_ptr(long __this__nativeId, int texture, int type, java.nio.IntBuffer coords);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNamedBufferData(GLuint,<wbr/>GLsizei,<wbr/>const void*,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glNamedBufferData(int buffer, int size, java.nio.@Nullable Buffer data, int usage){
        glNamedBufferData_native_GLuint_GLsizei_const_void_ptr_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, size, data, usage);
    }
    
    @QtUninvokable
    private native void glNamedBufferData_native_GLuint_GLsizei_const_void_ptr_GLenum(long __this__nativeId, int buffer, int size, java.nio.Buffer data, int usage);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNamedBufferStorage(GLuint,<wbr/>GLsizei,<wbr/>const void*,<wbr/>GLbitfield)</code></p>
     */
    @QtUninvokable
    public final void glNamedBufferStorage(int buffer, int size, java.nio.@Nullable Buffer data, int flags){
        glNamedBufferStorage_native_GLuint_GLsizei_const_void_ptr_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, size, data, flags);
    }
    
    @QtUninvokable
    private native void glNamedBufferStorage_native_GLuint_GLsizei_const_void_ptr_GLbitfield(long __this__nativeId, int buffer, int size, java.nio.Buffer data, int flags);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNamedBufferSubData(GLuint,<wbr/>GLintptr,<wbr/>GLsizei,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glNamedBufferSubData(int buffer, long offset, int size, java.nio.@Nullable Buffer data){
        glNamedBufferSubData_native_GLuint_GLintptr_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, offset, size, data);
    }
    
    @QtUninvokable
    private native void glNamedBufferSubData_native_GLuint_GLintptr_GLsizei_const_void_ptr(long __this__nativeId, int buffer, long offset, int size, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNamedFramebufferDrawBuffer(GLuint,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glNamedFramebufferDrawBuffer(int framebuffer, int buf){
        glNamedFramebufferDrawBuffer_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer, buf);
    }
    
    @QtUninvokable
    private native void glNamedFramebufferDrawBuffer_native_GLuint_GLenum(long __this__nativeId, int framebuffer, int buf);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNamedFramebufferDrawBuffers(GLuint,<wbr/>GLsizei,<wbr/>const GLenum*)</code></p>
     */
    @QtUninvokable
    public final void glNamedFramebufferDrawBuffers(int framebuffer, int n, java.nio.@Nullable IntBuffer bufs){
        glNamedFramebufferDrawBuffers_native_GLuint_GLsizei_const_GLenum_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer, n, bufs);
    }
    
    @QtUninvokable
    private native void glNamedFramebufferDrawBuffers_native_GLuint_GLsizei_const_GLenum_ptr(long __this__nativeId, int framebuffer, int n, java.nio.IntBuffer bufs);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNamedFramebufferParameteri(GLuint,<wbr/>GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glNamedFramebufferParameteri(int framebuffer, int pname, int param){
        glNamedFramebufferParameteri_native_GLuint_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer, pname, param);
    }
    
    @QtUninvokable
    private native void glNamedFramebufferParameteri_native_GLuint_GLenum_GLint(long __this__nativeId, int framebuffer, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNamedFramebufferReadBuffer(GLuint,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glNamedFramebufferReadBuffer(int framebuffer, int src){
        glNamedFramebufferReadBuffer_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer, src);
    }
    
    @QtUninvokable
    private native void glNamedFramebufferReadBuffer_native_GLuint_GLenum(long __this__nativeId, int framebuffer, int src);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNamedFramebufferRenderbuffer(GLuint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glNamedFramebufferRenderbuffer(int framebuffer, int attachment, int renderbuffertarget, int renderbuffer){
        glNamedFramebufferRenderbuffer_native_GLuint_GLenum_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer, attachment, renderbuffertarget, renderbuffer);
    }
    
    @QtUninvokable
    private native void glNamedFramebufferRenderbuffer_native_GLuint_GLenum_GLenum_GLuint(long __this__nativeId, int framebuffer, int attachment, int renderbuffertarget, int renderbuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNamedFramebufferTexture(GLuint,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glNamedFramebufferTexture(int framebuffer, int attachment, int texture, int level){
        glNamedFramebufferTexture_native_GLuint_GLenum_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer, attachment, texture, level);
    }
    
    @QtUninvokable
    private native void glNamedFramebufferTexture_native_GLuint_GLenum_GLuint_GLint(long __this__nativeId, int framebuffer, int attachment, int texture, int level);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNamedFramebufferTextureLayer(GLuint,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glNamedFramebufferTextureLayer(int framebuffer, int attachment, int texture, int level, int layer){
        glNamedFramebufferTextureLayer_native_GLuint_GLenum_GLuint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer, attachment, texture, level, layer);
    }
    
    @QtUninvokable
    private native void glNamedFramebufferTextureLayer_native_GLuint_GLenum_GLuint_GLint_GLint(long __this__nativeId, int framebuffer, int attachment, int texture, int level, int layer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNamedRenderbufferStorage(GLuint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glNamedRenderbufferStorage(int renderbuffer, int internalformat, int width, int height){
        glNamedRenderbufferStorage_native_GLuint_GLenum_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), renderbuffer, internalformat, width, height);
    }
    
    @QtUninvokable
    private native void glNamedRenderbufferStorage_native_GLuint_GLenum_GLsizei_GLsizei(long __this__nativeId, int renderbuffer, int internalformat, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNamedRenderbufferStorageMultisample(GLuint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glNamedRenderbufferStorageMultisample(int renderbuffer, int samples, int internalformat, int width, int height){
        glNamedRenderbufferStorageMultisample_native_GLuint_GLsizei_GLenum_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), renderbuffer, samples, internalformat, width, height);
    }
    
    @QtUninvokable
    private native void glNamedRenderbufferStorageMultisample_native_GLuint_GLsizei_GLenum_GLsizei_GLsizei(long __this__nativeId, int renderbuffer, int samples, int internalformat, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNewList(GLuint,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glNewList(int list, int mode){
        glNewList_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), list, mode);
    }
    
    @QtUninvokable
    private native void glNewList_native_GLuint_GLenum(long __this__nativeId, int list, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNormal3b(GLbyte,<wbr/>GLbyte,<wbr/>GLbyte)</code></p>
     */
    @QtUninvokable
    public final void glNormal3b(byte nx, byte ny, byte nz){
        glNormal3b_native_GLbyte_GLbyte_GLbyte(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @QtUninvokable
    private native void glNormal3b_native_GLbyte_GLbyte_GLbyte(long __this__nativeId, byte nx, byte ny, byte nz);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNormal3bv(const GLbyte*)</code></p>
     */
    @QtUninvokable
    public final void glNormal3bv(byte[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3bv_native_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glNormal3bv_native_const_GLbyte_ptr(long __this__nativeId, byte[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNormal3d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glNormal3d(double nx, double ny, double nz){
        glNormal3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @QtUninvokable
    private native void glNormal3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double nx, double ny, double nz);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNormal3dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glNormal3dv(double[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glNormal3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNormal3f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glNormal3f(float nx, float ny, float nz){
        glNormal3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @QtUninvokable
    private native void glNormal3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float nx, float ny, float nz);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNormal3fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glNormal3fv(float[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glNormal3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNormal3i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glNormal3i(int nx, int ny, int nz){
        glNormal3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @QtUninvokable
    private native void glNormal3i_native_GLint_GLint_GLint(long __this__nativeId, int nx, int ny, int nz);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNormal3iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glNormal3iv(int[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glNormal3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNormal3s(GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glNormal3s(short nx, short ny, short nz){
        glNormal3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @QtUninvokable
    private native void glNormal3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short nx, short ny, short nz);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNormal3sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glNormal3sv(short[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glNormal3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNormalP3ui(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glNormalP3ui(int type, int coords){
        glNormalP3ui_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), type, coords);
    }
    
    @QtUninvokable
    private native void glNormalP3ui_native_GLenum_GLuint(long __this__nativeId, int type, int coords);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNormalP3uiv(GLenum,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glNormalP3uiv(int type, java.nio.@Nullable IntBuffer coords){
        glNormalP3uiv_native_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, coords);
    }
    
    @QtUninvokable
    private native void glNormalP3uiv_native_GLenum_const_GLuint_ptr(long __this__nativeId, int type, java.nio.IntBuffer coords);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glNormalPointer(GLenum,<wbr/>GLsizei,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glNormalPointer(int type, int stride, java.nio.@Nullable Buffer pointer){
        glNormalPointer_native_GLenum_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glNormalPointer_native_GLenum_GLsizei_const_void_ptr(long __this__nativeId, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glObjectLabel(GLenum,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glObjectLabel(int identifier, int name, int length, java.nio.@Nullable CharBuffer label){
        glObjectLabel_native_GLenum_GLuint_GLsizei_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), identifier, name, length, label);
    }
    
    @QtUninvokable
    private native void glObjectLabel_native_GLenum_GLuint_GLsizei_const_GLchar_ptr(long __this__nativeId, int identifier, int name, int length, java.nio.CharBuffer label);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glObjectPtrLabel(const void*,<wbr/>GLsizei,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glObjectPtrLabel(io.qt.gui.gl.@StrictNonNull GLsync ptr, java.lang.String label){
        java.util.Objects.requireNonNull(ptr, "Argument 'ptr': null not expected.");
        glObjectPtrLabel_native_const_void_ptr_GLsizei_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), ptr, label);
    }
    
    @QtUninvokable
    private native void glObjectPtrLabel_native_const_void_ptr_GLsizei_const_GLchar_ptr(long __this__nativeId, io.qt.gui.gl.GLsync ptr, java.lang.String label);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glOrtho(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glOrtho(double left, double right, double bottom, double top, double zNear, double zFar){
        glOrtho_native_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), left, right, bottom, top, zNear, zFar);
    }
    
    @QtUninvokable
    private native void glOrtho_native_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double left, double right, double bottom, double top, double zNear, double zFar);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPassThrough(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPassThrough(float token){
        glPassThrough_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), token);
    }
    
    @QtUninvokable
    private native void glPassThrough_native_GLfloat(long __this__nativeId, float token);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPatchParameterfv(GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glPatchParameterfv(int pname, java.nio.@Nullable FloatBuffer values){
        glPatchParameterfv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, values);
    }
    
    @QtUninvokable
    private native void glPatchParameterfv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int pname, java.nio.FloatBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPatchParameteri(GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glPatchParameteri(int pname, int value){
        glPatchParameteri_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, value);
    }
    
    @QtUninvokable
    private native void glPatchParameteri_native_GLenum_GLint(long __this__nativeId, int pname, int value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPauseTransformFeedback()</code></p>
     */
    @QtUninvokable
    public final void glPauseTransformFeedback(){
        glPauseTransformFeedback_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPauseTransformFeedback_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPixelMapfv(GLenum,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glPixelMapfv(int map, int mapsize, java.nio.@Nullable FloatBuffer values){
        glPixelMapfv_native_GLenum_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, mapsize, values);
    }
    
    @QtUninvokable
    private native void glPixelMapfv_native_GLenum_GLsizei_const_GLfloat_ptr(long __this__nativeId, int map, int mapsize, java.nio.FloatBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPixelMapuiv(GLenum,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glPixelMapuiv(int map, int mapsize, java.nio.@Nullable IntBuffer values){
        glPixelMapuiv_native_GLenum_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, mapsize, values);
    }
    
    @QtUninvokable
    private native void glPixelMapuiv_native_GLenum_GLsizei_const_GLuint_ptr(long __this__nativeId, int map, int mapsize, java.nio.IntBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPixelMapusv(GLenum,<wbr/>GLsizei,<wbr/>const GLushort*)</code></p>
     */
    @QtUninvokable
    public final void glPixelMapusv(int map, int mapsize, java.nio.@Nullable ShortBuffer values){
        glPixelMapusv_native_GLenum_GLsizei_const_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, mapsize, values);
    }
    
    @QtUninvokable
    private native void glPixelMapusv_native_GLenum_GLsizei_const_GLushort_ptr(long __this__nativeId, int map, int mapsize, java.nio.ShortBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPixelStoref(GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPixelStoref(int pname, float param){
        glPixelStoref_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelStoref_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPixelStorei(GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glPixelStorei(int pname, int param){
        glPixelStorei_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelStorei_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPixelTransferf(GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPixelTransferf(int pname, float param){
        glPixelTransferf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelTransferf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPixelTransferi(GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glPixelTransferi(int pname, int param){
        glPixelTransferi_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelTransferi_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPixelZoom(GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPixelZoom(float xfactor, float yfactor){
        glPixelZoom_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), xfactor, yfactor);
    }
    
    @QtUninvokable
    private native void glPixelZoom_native_GLfloat_GLfloat(long __this__nativeId, float xfactor, float yfactor);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPointParameterf(GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPointParameterf(int pname, float param){
        glPointParameterf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPointParameterf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPointParameterfv(GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glPointParameterfv(int pname, java.nio.@Nullable FloatBuffer params){
        glPointParameterfv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glPointParameterfv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPointParameteri(GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glPointParameteri(int pname, int param){
        glPointParameteri_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPointParameteri_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPointParameteriv(GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glPointParameteriv(int pname, java.nio.@Nullable IntBuffer params){
        glPointParameteriv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glPointParameteriv_native_GLenum_const_GLint_ptr(long __this__nativeId, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPointSize(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPointSize(float size){
        glPointSize_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), size);
    }
    
    @QtUninvokable
    private native void glPointSize_native_GLfloat(long __this__nativeId, float size);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPolygonMode(GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glPolygonMode(int face, int mode){
        glPolygonMode_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, mode);
    }
    
    @QtUninvokable
    private native void glPolygonMode_native_GLenum_GLenum(long __this__nativeId, int face, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPolygonOffset(GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPolygonOffset(float factor, float units){
        glPolygonOffset_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), factor, units);
    }
    
    @QtUninvokable
    private native void glPolygonOffset_native_GLfloat_GLfloat(long __this__nativeId, float factor, float units);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPolygonStipple(const GLubyte*)</code></p>
     */
    @QtUninvokable
    public final void glPolygonStipple(java.nio.@Nullable ByteBuffer mask){
        glPolygonStipple_native_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glPolygonStipple_native_const_GLubyte_ptr(long __this__nativeId, java.nio.ByteBuffer mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPopAttrib()</code></p>
     */
    @QtUninvokable
    public final void glPopAttrib(){
        glPopAttrib_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPopAttrib_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPopClientAttrib()</code></p>
     */
    @QtUninvokable
    public final void glPopClientAttrib(){
        glPopClientAttrib_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPopClientAttrib_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPopDebugGroup()</code></p>
     */
    @QtUninvokable
    public final void glPopDebugGroup(){
        glPopDebugGroup_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPopDebugGroup_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPopMatrix()</code></p>
     */
    @QtUninvokable
    public final void glPopMatrix(){
        glPopMatrix_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPopMatrix_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPopName()</code></p>
     */
    @QtUninvokable
    public final void glPopName(){
        glPopName_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPopName_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPrimitiveRestartIndex(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glPrimitiveRestartIndex(int index){
        glPrimitiveRestartIndex_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void glPrimitiveRestartIndex_native_GLuint(long __this__nativeId, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPrioritizeTextures(GLsizei,<wbr/>const GLuint*,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glPrioritizeTextures(int n, java.nio.@Nullable IntBuffer textures, java.nio.@Nullable FloatBuffer priorities){
        glPrioritizeTextures_native_GLsizei_const_GLuint_ptr_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures, priorities);
    }
    
    @QtUninvokable
    private native void glPrioritizeTextures_native_GLsizei_const_GLuint_ptr_const_GLfloat_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures, java.nio.FloatBuffer priorities);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramBinary(GLuint,<wbr/>GLenum,<wbr/>const void*,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glProgramBinary(int program, int binaryFormat, java.nio.@Nullable Buffer binary, int length){
        glProgramBinary_native_GLuint_GLenum_const_void_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), program, binaryFormat, binary, length);
    }
    
    @QtUninvokable
    private native void glProgramBinary_native_GLuint_GLenum_const_void_ptr_GLsizei(long __this__nativeId, int program, int binaryFormat, java.nio.Buffer binary, int length);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramParameteri(GLuint,<wbr/>GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glProgramParameteri(int program, int pname, int value){
        glProgramParameteri_native_GLuint_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), program, pname, value);
    }
    
    @QtUninvokable
    private native void glProgramParameteri_native_GLuint_GLenum_GLint(long __this__nativeId, int program, int pname, int value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform1d(GLuint,<wbr/>GLint,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform1d(int program, int location, double v0){
        glProgramUniform1d_native_GLuint_GLint_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0);
    }
    
    @QtUninvokable
    private native void glProgramUniform1d_native_GLuint_GLint_GLdouble(long __this__nativeId, int program, int location, double v0);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform1dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform1dv(int program, int location, int count, java.nio.@Nullable DoubleBuffer value){
        glProgramUniform1dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform1dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform1f(GLuint,<wbr/>GLint,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform1f(int program, int location, float v0){
        glProgramUniform1f_native_GLuint_GLint_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0);
    }
    
    @QtUninvokable
    private native void glProgramUniform1f_native_GLuint_GLint_GLfloat(long __this__nativeId, int program, int location, float v0);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform1fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform1fv(int program, int location, int count, java.nio.@Nullable FloatBuffer value){
        glProgramUniform1fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform1fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform1i(GLuint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform1i(int program, int location, int v0){
        glProgramUniform1i_native_GLuint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0);
    }
    
    @QtUninvokable
    private native void glProgramUniform1i_native_GLuint_GLint_GLint(long __this__nativeId, int program, int location, int v0);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform1iv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform1iv(int program, int location, int count, java.nio.@Nullable IntBuffer value){
        glProgramUniform1iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform1iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform1ui(GLuint,<wbr/>GLint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform1ui(int program, int location, int v0){
        glProgramUniform1ui_native_GLuint_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0);
    }
    
    @QtUninvokable
    private native void glProgramUniform1ui_native_GLuint_GLint_GLuint(long __this__nativeId, int program, int location, int v0);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform1uiv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform1uiv(int program, int location, int count, java.nio.@Nullable IntBuffer value){
        glProgramUniform1uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform1uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform2d(GLuint,<wbr/>GLint,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform2d(int program, int location, double v0, double v1){
        glProgramUniform2d_native_GLuint_GLint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1);
    }
    
    @QtUninvokable
    private native void glProgramUniform2d_native_GLuint_GLint_GLdouble_GLdouble(long __this__nativeId, int program, int location, double v0, double v1);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform2dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform2dv(int program, int location, int count, java.nio.@Nullable DoubleBuffer value){
        glProgramUniform2dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform2dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform2f(GLuint,<wbr/>GLint,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform2f(int program, int location, float v0, float v1){
        glProgramUniform2f_native_GLuint_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1);
    }
    
    @QtUninvokable
    private native void glProgramUniform2f_native_GLuint_GLint_GLfloat_GLfloat(long __this__nativeId, int program, int location, float v0, float v1);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform2fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform2fv(int program, int location, int count, java.nio.@Nullable FloatBuffer value){
        glProgramUniform2fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform2fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform2i(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform2i(int program, int location, int v0, int v1){
        glProgramUniform2i_native_GLuint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1);
    }
    
    @QtUninvokable
    private native void glProgramUniform2i_native_GLuint_GLint_GLint_GLint(long __this__nativeId, int program, int location, int v0, int v1);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform2iv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform2iv(int program, int location, int count, java.nio.@Nullable IntBuffer value){
        glProgramUniform2iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform2iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform2ui(GLuint,<wbr/>GLint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform2ui(int program, int location, int v0, int v1){
        glProgramUniform2ui_native_GLuint_GLint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1);
    }
    
    @QtUninvokable
    private native void glProgramUniform2ui_native_GLuint_GLint_GLuint_GLuint(long __this__nativeId, int program, int location, int v0, int v1);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform2uiv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform2uiv(int program, int location, int count, java.nio.@Nullable IntBuffer value){
        glProgramUniform2uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform2uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform3d(GLuint,<wbr/>GLint,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform3d(int program, int location, double v0, double v1, double v2){
        glProgramUniform3d_native_GLuint_GLint_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glProgramUniform3d_native_GLuint_GLint_GLdouble_GLdouble_GLdouble(long __this__nativeId, int program, int location, double v0, double v1, double v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform3dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform3dv(int program, int location, int count, java.nio.@Nullable DoubleBuffer value){
        glProgramUniform3dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform3dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform3f(GLuint,<wbr/>GLint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform3f(int program, int location, float v0, float v1, float v2){
        glProgramUniform3f_native_GLuint_GLint_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glProgramUniform3f_native_GLuint_GLint_GLfloat_GLfloat_GLfloat(long __this__nativeId, int program, int location, float v0, float v1, float v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform3fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform3fv(int program, int location, int count, java.nio.@Nullable FloatBuffer value){
        glProgramUniform3fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform3fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform3i(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform3i(int program, int location, int v0, int v1, int v2){
        glProgramUniform3i_native_GLuint_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glProgramUniform3i_native_GLuint_GLint_GLint_GLint_GLint(long __this__nativeId, int program, int location, int v0, int v1, int v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform3iv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform3iv(int program, int location, int count, java.nio.@Nullable IntBuffer value){
        glProgramUniform3iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform3iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform3ui(GLuint,<wbr/>GLint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform3ui(int program, int location, int v0, int v1, int v2){
        glProgramUniform3ui_native_GLuint_GLint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glProgramUniform3ui_native_GLuint_GLint_GLuint_GLuint_GLuint(long __this__nativeId, int program, int location, int v0, int v1, int v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform3uiv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform3uiv(int program, int location, int count, java.nio.@Nullable IntBuffer value){
        glProgramUniform3uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform3uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform4d(GLuint,<wbr/>GLint,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform4d(int program, int location, double v0, double v1, double v2, double v3){
        glProgramUniform4d_native_GLuint_GLint_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glProgramUniform4d_native_GLuint_GLint_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, int program, int location, double v0, double v1, double v2, double v3);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform4dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform4dv(int program, int location, int count, java.nio.@Nullable DoubleBuffer value){
        glProgramUniform4dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform4dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform4f(GLuint,<wbr/>GLint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform4f(int program, int location, float v0, float v1, float v2, float v3){
        glProgramUniform4f_native_GLuint_GLint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glProgramUniform4f_native_GLuint_GLint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int program, int location, float v0, float v1, float v2, float v3);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform4fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform4fv(int program, int location, int count, java.nio.@Nullable FloatBuffer value){
        glProgramUniform4fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform4fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform4i(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform4i(int program, int location, int v0, int v1, int v2, int v3){
        glProgramUniform4i_native_GLuint_GLint_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glProgramUniform4i_native_GLuint_GLint_GLint_GLint_GLint_GLint(long __this__nativeId, int program, int location, int v0, int v1, int v2, int v3);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform4iv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform4iv(int program, int location, int count, java.nio.@Nullable IntBuffer value){
        glProgramUniform4iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform4iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform4ui(GLuint,<wbr/>GLint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform4ui(int program, int location, int v0, int v1, int v2, int v3){
        glProgramUniform4ui_native_GLuint_GLint_GLuint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glProgramUniform4ui_native_GLuint_GLint_GLuint_GLuint_GLuint_GLuint(long __this__nativeId, int program, int location, int v0, int v1, int v2, int v3);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniform4uiv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniform4uiv(int program, int location, int count, java.nio.@Nullable IntBuffer value){
        glProgramUniform4uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @QtUninvokable
    private native void glProgramUniform4uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniformMatrix2dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniformMatrix2dv(int program, int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glProgramUniformMatrix2dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix2dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniformMatrix2fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniformMatrix2fv(int program, int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glProgramUniformMatrix2fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix2fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniformMatrix2x3dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniformMatrix2x3dv(int program, int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glProgramUniformMatrix2x3dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix2x3dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniformMatrix2x3fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniformMatrix2x3fv(int program, int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glProgramUniformMatrix2x3fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix2x3fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniformMatrix2x4dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniformMatrix2x4dv(int program, int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glProgramUniformMatrix2x4dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix2x4dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniformMatrix2x4fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniformMatrix2x4fv(int program, int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glProgramUniformMatrix2x4fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix2x4fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniformMatrix3dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniformMatrix3dv(int program, int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glProgramUniformMatrix3dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix3dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniformMatrix3fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniformMatrix3fv(int program, int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glProgramUniformMatrix3fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix3fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniformMatrix3x2dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniformMatrix3x2dv(int program, int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glProgramUniformMatrix3x2dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix3x2dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniformMatrix3x2fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniformMatrix3x2fv(int program, int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glProgramUniformMatrix3x2fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix3x2fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniformMatrix3x4dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniformMatrix3x4dv(int program, int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glProgramUniformMatrix3x4dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix3x4dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniformMatrix3x4fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniformMatrix3x4fv(int program, int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glProgramUniformMatrix3x4fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix3x4fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniformMatrix4dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniformMatrix4dv(int program, int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glProgramUniformMatrix4dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix4dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniformMatrix4fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniformMatrix4fv(int program, int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glProgramUniformMatrix4fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix4fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniformMatrix4x2dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniformMatrix4x2dv(int program, int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glProgramUniformMatrix4x2dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix4x2dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniformMatrix4x2fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniformMatrix4x2fv(int program, int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glProgramUniformMatrix4x2fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix4x2fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniformMatrix4x3dv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniformMatrix4x3dv(int program, int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glProgramUniformMatrix4x3dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix4x3dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProgramUniformMatrix4x3fv(GLuint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glProgramUniformMatrix4x3fv(int program, int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glProgramUniformMatrix4x3fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glProgramUniformMatrix4x3fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glProvokingVertex(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glProvokingVertex(int mode){
        glProvokingVertex_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glProvokingVertex_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPushAttrib(GLbitfield)</code></p>
     */
    @QtUninvokable
    public final void glPushAttrib(int mask){
        glPushAttrib_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glPushAttrib_native_GLbitfield(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPushClientAttrib(GLbitfield)</code></p>
     */
    @QtUninvokable
    public final void glPushClientAttrib(int mask){
        glPushClientAttrib_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glPushClientAttrib_native_GLbitfield(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPushDebugGroup(GLenum,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glPushDebugGroup(int source, int id, int length, java.nio.@Nullable CharBuffer message){
        glPushDebugGroup_native_GLenum_GLuint_GLsizei_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), source, id, length, message);
    }
    
    @QtUninvokable
    private native void glPushDebugGroup_native_GLenum_GLuint_GLsizei_const_GLchar_ptr(long __this__nativeId, int source, int id, int length, java.nio.CharBuffer message);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPushMatrix()</code></p>
     */
    @QtUninvokable
    public final void glPushMatrix(){
        glPushMatrix_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPushMatrix_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glPushName(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glPushName(int name){
        glPushName_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void glPushName_native_GLuint(long __this__nativeId, int name);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glQueryCounter(GLuint,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glQueryCounter(int id, int target){
        glQueryCounter_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), id, target);
    }
    
    @QtUninvokable
    private native void glQueryCounter_native_GLuint_GLenum(long __this__nativeId, int id, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos2d(GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2d(double x, double y){
        glRasterPos2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glRasterPos2d_native_GLdouble_GLdouble(long __this__nativeId, double x, double y);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos2dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2dv(double[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glRasterPos2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos2dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos2f(GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2f(float x, float y){
        glRasterPos2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glRasterPos2f_native_GLfloat_GLfloat(long __this__nativeId, float x, float y);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos2fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2fv(float[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glRasterPos2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos2fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos2i(GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2i(int x, int y){
        glRasterPos2i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glRasterPos2i_native_GLint_GLint(long __this__nativeId, int x, int y);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos2iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2iv(int[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glRasterPos2iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos2iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos2s(GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2s(short x, short y){
        glRasterPos2s_native_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glRasterPos2s_native_GLshort_GLshort(long __this__nativeId, short x, short y);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos2sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2sv(short[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glRasterPos2sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos2sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos3d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3d(double x, double y, double z){
        glRasterPos3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glRasterPos3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos3dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3dv(double[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glRasterPos3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos3f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3f(float x, float y, float z){
        glRasterPos3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glRasterPos3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos3fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3fv(float[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glRasterPos3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos3i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3i(int x, int y, int z){
        glRasterPos3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glRasterPos3i_native_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos3iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3iv(int[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glRasterPos3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos3s(GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3s(short x, short y, short z){
        glRasterPos3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glRasterPos3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos3sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3sv(short[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glRasterPos3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos4d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4d(double x, double y, double z, double w){
        glRasterPos4d_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glRasterPos4d_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z, double w);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos4dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4dv(double[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glRasterPos4dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos4dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos4f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4f(float x, float y, float z, float w){
        glRasterPos4f_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glRasterPos4f_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z, float w);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos4fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4fv(float[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glRasterPos4fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos4fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos4i(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4i(int x, int y, int z, int w){
        glRasterPos4i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glRasterPos4i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z, int w);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos4iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4iv(int[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glRasterPos4iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos4iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos4s(GLshort,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4s(short x, short y, short z, short w){
        glRasterPos4s_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glRasterPos4s_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z, short w);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRasterPos4sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4sv(short[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glRasterPos4sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos4sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glReadBuffer(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glReadBuffer(int src){
        glReadBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), src);
    }
    
    @QtUninvokable
    private native void glReadBuffer_native_GLenum(long __this__nativeId, int src);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glReadPixels(GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glReadPixels(int x, int y, int width, int height, int format, int type, java.nio.@Nullable Buffer pixels){
        glReadPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glReadPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_void_ptr(long __this__nativeId, int x, int y, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glReadnPixels(GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>void*)</code></p>
     */
    @QtUninvokable
    public final void glReadnPixels(int x, int y, int width, int height, int format, int type, int bufSize, java.nio.@Nullable Buffer data){
        glReadnPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_GLsizei_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height, format, type, bufSize, data);
    }
    
    @QtUninvokable
    private native void glReadnPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_GLsizei_void_ptr(long __this__nativeId, int x, int y, int width, int height, int format, int type, int bufSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRectd(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glRectd(double x1, double y1, double x2, double y2){
        glRectd_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x1, y1, x2, y2);
    }
    
    @QtUninvokable
    private native void glRectd_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x1, double y1, double x2, double y2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRectdv(const GLdouble*,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glRectdv(double[] v1, double[] v2){
        if(v1!=null && v1.length < 2)
            throw new IllegalArgumentException("Argument 'v1': Wrong number of elements in array. Found: " + v1.length + ", expected: 2");
        if(v2!=null && v2.length < 2)
            throw new IllegalArgumentException("Argument 'v2': Wrong number of elements in array. Found: " + v2.length + ", expected: 2");
        glRectdv_native_const_GLdouble_ptr_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v1, v2);
    }
    
    @QtUninvokable
    private native void glRectdv_native_const_GLdouble_ptr_const_GLdouble_ptr(long __this__nativeId, double[] v1, double[] v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRectf(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glRectf(float x1, float y1, float x2, float y2){
        glRectf_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x1, y1, x2, y2);
    }
    
    @QtUninvokable
    private native void glRectf_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x1, float y1, float x2, float y2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRectfv(const GLfloat*,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glRectfv(float[] v1, float[] v2){
        if(v1!=null && v1.length < 2)
            throw new IllegalArgumentException("Argument 'v1': Wrong number of elements in array. Found: " + v1.length + ", expected: 2");
        if(v2!=null && v2.length < 2)
            throw new IllegalArgumentException("Argument 'v2': Wrong number of elements in array. Found: " + v2.length + ", expected: 2");
        glRectfv_native_const_GLfloat_ptr_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v1, v2);
    }
    
    @QtUninvokable
    private native void glRectfv_native_const_GLfloat_ptr_const_GLfloat_ptr(long __this__nativeId, float[] v1, float[] v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRecti(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glRecti(int x1, int y1, int x2, int y2){
        glRecti_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x1, y1, x2, y2);
    }
    
    @QtUninvokable
    private native void glRecti_native_GLint_GLint_GLint_GLint(long __this__nativeId, int x1, int y1, int x2, int y2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRectiv(const GLint*,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glRectiv(int[] v1, int[] v2){
        if(v1!=null && v1.length < 2)
            throw new IllegalArgumentException("Argument 'v1': Wrong number of elements in array. Found: " + v1.length + ", expected: 2");
        if(v2!=null && v2.length < 2)
            throw new IllegalArgumentException("Argument 'v2': Wrong number of elements in array. Found: " + v2.length + ", expected: 2");
        glRectiv_native_const_GLint_ptr_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v1, v2);
    }
    
    @QtUninvokable
    private native void glRectiv_native_const_GLint_ptr_const_GLint_ptr(long __this__nativeId, int[] v1, int[] v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRects(GLshort,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glRects(short x1, short y1, short x2, short y2){
        glRects_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x1, y1, x2, y2);
    }
    
    @QtUninvokable
    private native void glRects_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short x1, short y1, short x2, short y2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRectsv(const GLshort*,<wbr/>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glRectsv(short[] v1, short[] v2){
        if(v1!=null && v1.length < 2)
            throw new IllegalArgumentException("Argument 'v1': Wrong number of elements in array. Found: " + v1.length + ", expected: 2");
        if(v2!=null && v2.length < 2)
            throw new IllegalArgumentException("Argument 'v2': Wrong number of elements in array. Found: " + v2.length + ", expected: 2");
        glRectsv_native_const_GLshort_ptr_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v1, v2);
    }
    
    @QtUninvokable
    private native void glRectsv_native_const_GLshort_ptr_const_GLshort_ptr(long __this__nativeId, short[] v1, short[] v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glReleaseShaderCompiler()</code></p>
     */
    @QtUninvokable
    public final void glReleaseShaderCompiler(){
        glReleaseShaderCompiler_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glReleaseShaderCompiler_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRenderMode(GLenum)</code></p>
     */
    @QtUninvokable
    public final int glRenderMode(int mode){
        return glRenderMode_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native int glRenderMode_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRenderbufferStorage(GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glRenderbufferStorage(int target, int internalformat, int width, int height){
        glRenderbufferStorage_native_GLenum_GLenum_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, height);
    }
    
    @QtUninvokable
    private native void glRenderbufferStorage_native_GLenum_GLenum_GLsizei_GLsizei(long __this__nativeId, int target, int internalformat, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRenderbufferStorageMultisample(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glRenderbufferStorageMultisample(int target, int samples, int internalformat, int width, int height){
        glRenderbufferStorageMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, samples, internalformat, width, height);
    }
    
    @QtUninvokable
    private native void glRenderbufferStorageMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei(long __this__nativeId, int target, int samples, int internalformat, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glResetHistogram(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glResetHistogram(int target){
        glResetHistogram_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void glResetHistogram_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glResetMinmax(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glResetMinmax(int target){
        glResetMinmax_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void glResetMinmax_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glResumeTransformFeedback()</code></p>
     */
    @QtUninvokable
    public final void glResumeTransformFeedback(){
        glResumeTransformFeedback_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glResumeTransformFeedback_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRotated(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glRotated(double angle, double x, double y, double z){
        glRotated_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), angle, x, y, z);
    }
    
    @QtUninvokable
    private native void glRotated_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double angle, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glRotatef(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glRotatef(float angle, float x, float y, float z){
        glRotatef_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), angle, x, y, z);
    }
    
    @QtUninvokable
    private native void glRotatef_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float angle, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSampleCoverage(GLfloat,<wbr/>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glSampleCoverage(float value, boolean invert){
        glSampleCoverage_native_GLfloat_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), value, invert);
    }
    
    @QtUninvokable
    private native void glSampleCoverage_native_GLfloat_GLboolean(long __this__nativeId, float value, boolean invert);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSampleMaski(GLuint,<wbr/>GLbitfield)</code></p>
     */
    @QtUninvokable
    public final void glSampleMaski(int maskNumber, int mask){
        glSampleMaski_native_GLuint_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), maskNumber, mask);
    }
    
    @QtUninvokable
    private native void glSampleMaski_native_GLuint_GLbitfield(long __this__nativeId, int maskNumber, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSamplerParameterIiv(GLuint,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glSamplerParameterIiv(int sampler, int pname, java.nio.@Nullable IntBuffer param){
        glSamplerParameterIiv_native_GLuint_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @QtUninvokable
    private native void glSamplerParameterIiv_native_GLuint_GLenum_const_GLint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSamplerParameterIuiv(GLuint,<wbr/>GLenum,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glSamplerParameterIuiv(int sampler, int pname, java.nio.@Nullable IntBuffer param){
        glSamplerParameterIuiv_native_GLuint_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @QtUninvokable
    private native void glSamplerParameterIuiv_native_GLuint_GLenum_const_GLuint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSamplerParameterf(GLuint,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glSamplerParameterf(int sampler, int pname, float param){
        glSamplerParameterf_native_GLuint_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @QtUninvokable
    private native void glSamplerParameterf_native_GLuint_GLenum_GLfloat(long __this__nativeId, int sampler, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSamplerParameterfv(GLuint,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glSamplerParameterfv(int sampler, int pname, java.nio.@Nullable FloatBuffer param){
        glSamplerParameterfv_native_GLuint_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @QtUninvokable
    private native void glSamplerParameterfv_native_GLuint_GLenum_const_GLfloat_ptr(long __this__nativeId, int sampler, int pname, java.nio.FloatBuffer param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSamplerParameteri(GLuint,<wbr/>GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glSamplerParameteri(int sampler, int pname, int param){
        glSamplerParameteri_native_GLuint_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @QtUninvokable
    private native void glSamplerParameteri_native_GLuint_GLenum_GLint(long __this__nativeId, int sampler, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSamplerParameteriv(GLuint,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glSamplerParameteriv(int sampler, int pname, java.nio.@Nullable IntBuffer param){
        glSamplerParameteriv_native_GLuint_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @QtUninvokable
    private native void glSamplerParameteriv_native_GLuint_GLenum_const_GLint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glScaled(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glScaled(double x, double y, double z){
        glScaled_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glScaled_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glScalef(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glScalef(float x, float y, float z){
        glScalef_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glScalef_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glScissor(GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glScissor(int x, int y, int width, int height){
        glScissor_native_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height);
    }
    
    @QtUninvokable
    private native void glScissor_native_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glScissorArrayv(GLuint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glScissorArrayv(int first, int count, java.nio.@Nullable IntBuffer v){
        glScissorArrayv_native_GLuint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), first, count, v);
    }
    
    @QtUninvokable
    private native void glScissorArrayv_native_GLuint_GLsizei_const_GLint_ptr(long __this__nativeId, int first, int count, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glScissorIndexed(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glScissorIndexed(int index, int left, int bottom, int width, int height){
        glScissorIndexed_native_GLuint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), index, left, bottom, width, height);
    }
    
    @QtUninvokable
    private native void glScissorIndexed_native_GLuint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int index, int left, int bottom, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glScissorIndexedv(GLuint,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glScissorIndexedv(int index, java.nio.@Nullable IntBuffer v){
        glScissorIndexedv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glScissorIndexedv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSecondaryColor3b(GLbyte,<wbr/>GLbyte,<wbr/>GLbyte)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3b(byte red, byte green, byte blue){
        glSecondaryColor3b_native_GLbyte_GLbyte_GLbyte(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3b_native_GLbyte_GLbyte_GLbyte(long __this__nativeId, byte red, byte green, byte blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSecondaryColor3bv(const GLbyte*)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3bv(java.nio.@Nullable ByteBuffer v){
        glSecondaryColor3bv_native_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3bv_native_const_GLbyte_ptr(long __this__nativeId, java.nio.ByteBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSecondaryColor3d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3d(double red, double green, double blue){
        glSecondaryColor3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double red, double green, double blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSecondaryColor3dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3dv(java.nio.@Nullable DoubleBuffer v){
        glSecondaryColor3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3dv_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSecondaryColor3f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3f(float red, float green, float blue){
        glSecondaryColor3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSecondaryColor3fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3fv(java.nio.@Nullable FloatBuffer v){
        glSecondaryColor3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3fv_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSecondaryColor3i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3i(int red, int green, int blue){
        glSecondaryColor3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3i_native_GLint_GLint_GLint(long __this__nativeId, int red, int green, int blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSecondaryColor3iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3iv(java.nio.@Nullable IntBuffer v){
        glSecondaryColor3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3iv_native_const_GLint_ptr(long __this__nativeId, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSecondaryColor3s(GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3s(short red, short green, short blue){
        glSecondaryColor3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short red, short green, short blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSecondaryColor3sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3sv(java.nio.@Nullable ShortBuffer v){
        glSecondaryColor3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3sv_native_const_GLshort_ptr(long __this__nativeId, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSecondaryColor3ub(GLubyte,<wbr/>GLubyte,<wbr/>GLubyte)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3ub(byte red, byte green, byte blue){
        glSecondaryColor3ub_native_GLubyte_GLubyte_GLubyte(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3ub_native_GLubyte_GLubyte_GLubyte(long __this__nativeId, byte red, byte green, byte blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSecondaryColor3ubv(const GLubyte*)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3ubv(java.nio.@Nullable ByteBuffer v){
        glSecondaryColor3ubv_native_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3ubv_native_const_GLubyte_ptr(long __this__nativeId, java.nio.ByteBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSecondaryColor3ui(GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3ui(int red, int green, int blue){
        glSecondaryColor3ui_native_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3ui_native_GLuint_GLuint_GLuint(long __this__nativeId, int red, int green, int blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSecondaryColor3uiv(const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3uiv(java.nio.@Nullable IntBuffer v){
        glSecondaryColor3uiv_native_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3uiv_native_const_GLuint_ptr(long __this__nativeId, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSecondaryColor3us(GLushort,<wbr/>GLushort,<wbr/>GLushort)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3us(short red, short green, short blue){
        glSecondaryColor3us_native_GLushort_GLushort_GLushort(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3us_native_GLushort_GLushort_GLushort(long __this__nativeId, short red, short green, short blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSecondaryColor3usv(const GLushort*)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3usv(java.nio.@Nullable ShortBuffer v){
        glSecondaryColor3usv_native_const_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3usv_native_const_GLushort_ptr(long __this__nativeId, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSecondaryColorP3ui(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColorP3ui(int type, int color){
        glSecondaryColorP3ui_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), type, color);
    }
    
    @QtUninvokable
    private native void glSecondaryColorP3ui_native_GLenum_GLuint(long __this__nativeId, int type, int color);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSecondaryColorP3uiv(GLenum,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColorP3uiv(int type, java.nio.@Nullable IntBuffer color){
        glSecondaryColorP3uiv_native_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, color);
    }
    
    @QtUninvokable
    private native void glSecondaryColorP3uiv_native_GLenum_const_GLuint_ptr(long __this__nativeId, int type, java.nio.IntBuffer color);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSecondaryColorPointer(GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColorPointer(int size, int type, int stride, java.nio.@Nullable Buffer pointer){
        glSecondaryColorPointer_native_GLint_GLenum_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), size, type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glSecondaryColorPointer_native_GLint_GLenum_GLsizei_const_void_ptr(long __this__nativeId, int size, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSelectBuffer(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glSelectBuffer(java.nio.@Nullable IntBuffer buffer){
        glSelectBuffer_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer);
    }
    
    @QtUninvokable
    private native void glSelectBuffer_native_GLsizei_GLuint_ptr(long __this__nativeId, java.nio.IntBuffer buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glSeparableFilter2D(GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glSeparableFilter2D(int target, int internalformat, int width, int height, int format, int type, java.nio.@Nullable Buffer row, java.nio.@Nullable Buffer column){
        glSeparableFilter2D_native_GLenum_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, height, format, type, row, column);
    }
    
    @QtUninvokable
    private native void glSeparableFilter2D_native_GLenum_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr_const_void_ptr(long __this__nativeId, int target, int internalformat, int width, int height, int format, int type, java.nio.Buffer row, java.nio.Buffer column);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glShadeModel(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glShadeModel(int mode){
        glShadeModel_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glShadeModel_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glShaderBinary(GLsizei,<wbr/>const GLuint*,<wbr/>GLenum,<wbr/>const void*,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glShaderBinary(int count, java.nio.@Nullable IntBuffer shaders, int binaryformat, java.nio.@Nullable Buffer binary, int length){
        glShaderBinary_native_GLsizei_const_GLuint_ptr_GLenum_const_void_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), count, shaders, binaryformat, binary, length);
    }
    
    @QtUninvokable
    private native void glShaderBinary_native_GLsizei_const_GLuint_ptr_GLenum_const_void_ptr_GLsizei(long __this__nativeId, int count, java.nio.IntBuffer shaders, int binaryformat, java.nio.Buffer binary, int length);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glShaderSource(GLuint,<wbr/>GLsizei,<wbr/>const GLchar*const*,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glShaderSource(int shader, java.lang.String[] string, java.nio.@Nullable IntBuffer length){
        glShaderSource_native_GLuint_GLsizei_const_GLchar_cptr_ptr_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, string, length);
    }
    
    @QtUninvokable
    private native void glShaderSource_native_GLuint_GLsizei_const_GLchar_cptr_ptr_const_GLint_ptr(long __this__nativeId, int shader, java.lang.String[] string, java.nio.IntBuffer length);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glShaderStorageBlockBinding(GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glShaderStorageBlockBinding(int program, int storageBlockIndex, int storageBlockBinding){
        glShaderStorageBlockBinding_native_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, storageBlockIndex, storageBlockBinding);
    }
    
    @QtUninvokable
    private native void glShaderStorageBlockBinding_native_GLuint_GLuint_GLuint(long __this__nativeId, int program, int storageBlockIndex, int storageBlockBinding);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glStencilFunc(GLenum,<wbr/>GLint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glStencilFunc(int func, int ref, int mask){
        glStencilFunc_native_GLenum_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), func, ref, mask);
    }
    
    @QtUninvokable
    private native void glStencilFunc_native_GLenum_GLint_GLuint(long __this__nativeId, int func, int ref, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glStencilFuncSeparate(GLenum,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glStencilFuncSeparate(int face, int func, int ref, int mask){
        glStencilFuncSeparate_native_GLenum_GLenum_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), face, func, ref, mask);
    }
    
    @QtUninvokable
    private native void glStencilFuncSeparate_native_GLenum_GLenum_GLint_GLuint(long __this__nativeId, int face, int func, int ref, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glStencilMask(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glStencilMask(int mask){
        glStencilMask_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glStencilMask_native_GLuint(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glStencilMaskSeparate(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glStencilMaskSeparate(int face, int mask){
        glStencilMaskSeparate_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), face, mask);
    }
    
    @QtUninvokable
    private native void glStencilMaskSeparate_native_GLenum_GLuint(long __this__nativeId, int face, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glStencilOp(GLenum,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glStencilOp(int fail, int zfail, int zpass){
        glStencilOp_native_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), fail, zfail, zpass);
    }
    
    @QtUninvokable
    private native void glStencilOp_native_GLenum_GLenum_GLenum(long __this__nativeId, int fail, int zfail, int zpass);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glStencilOpSeparate(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glStencilOpSeparate(int face, int sfail, int dpfail, int dppass){
        glStencilOpSeparate_native_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, sfail, dpfail, dppass);
    }
    
    @QtUninvokable
    private native void glStencilOpSeparate_native_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int face, int sfail, int dpfail, int dppass);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexBuffer(GLenum,<wbr/>GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glTexBuffer(int target, int internalformat, int buffer){
        glTexBuffer_native_GLenum_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, buffer);
    }
    
    @QtUninvokable
    private native void glTexBuffer_native_GLenum_GLenum_GLuint(long __this__nativeId, int target, int internalformat, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexBufferRange(GLenum,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLintptr,<wbr/>GLsizeiptr)</code></p>
     */
    @QtUninvokable
    public final void glTexBufferRange(int target, int internalformat, int buffer, long offset, long size){
        glTexBufferRange_native_GLenum_GLenum_GLuint_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, buffer, offset, size);
    }
    
    @QtUninvokable
    private native void glTexBufferRange_native_GLenum_GLenum_GLuint_GLintptr_GLsizeiptr(long __this__nativeId, int target, int internalformat, int buffer, long offset, long size);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord1d(GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1d(double s){
        glTexCoord1d_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glTexCoord1d_native_GLdouble(long __this__nativeId, double s);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord1dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1dv(double[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glTexCoord1dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord1dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord1f(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1f(float s){
        glTexCoord1f_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glTexCoord1f_native_GLfloat(long __this__nativeId, float s);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord1fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1fv(float[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glTexCoord1fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord1fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord1i(GLint)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1i(int s){
        glTexCoord1i_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glTexCoord1i_native_GLint(long __this__nativeId, int s);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord1iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1iv(int[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glTexCoord1iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord1iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord1s(GLshort)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1s(short s){
        glTexCoord1s_native_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glTexCoord1s_native_GLshort(long __this__nativeId, short s);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord1sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1sv(short[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glTexCoord1sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord1sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord2d(GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2d(double s, double t){
        glTexCoord2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), s, t);
    }
    
    @QtUninvokable
    private native void glTexCoord2d_native_GLdouble_GLdouble(long __this__nativeId, double s, double t);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord2dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2dv(double[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glTexCoord2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord2dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord2f(GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2f(float s, float t){
        glTexCoord2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), s, t);
    }
    
    @QtUninvokable
    private native void glTexCoord2f_native_GLfloat_GLfloat(long __this__nativeId, float s, float t);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord2fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2fv(float[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glTexCoord2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord2fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord2i(GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2i(int s, int t){
        glTexCoord2i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s, t);
    }
    
    @QtUninvokable
    private native void glTexCoord2i_native_GLint_GLint(long __this__nativeId, int s, int t);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord2iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2iv(int[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glTexCoord2iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord2iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord2s(GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2s(short s, short t){
        glTexCoord2s_native_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), s, t);
    }
    
    @QtUninvokable
    private native void glTexCoord2s_native_GLshort_GLshort(long __this__nativeId, short s, short t);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord2sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2sv(short[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glTexCoord2sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord2sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord3d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3d(double s, double t, double r){
        glTexCoord3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r);
    }
    
    @QtUninvokable
    private native void glTexCoord3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double s, double t, double r);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord3dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3dv(double[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glTexCoord3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord3f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3f(float s, float t, float r){
        glTexCoord3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r);
    }
    
    @QtUninvokable
    private native void glTexCoord3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float s, float t, float r);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord3fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3fv(float[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glTexCoord3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord3i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3i(int s, int t, int r){
        glTexCoord3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r);
    }
    
    @QtUninvokable
    private native void glTexCoord3i_native_GLint_GLint_GLint(long __this__nativeId, int s, int t, int r);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord3iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3iv(int[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glTexCoord3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord3s(GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3s(short s, short t, short r){
        glTexCoord3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r);
    }
    
    @QtUninvokable
    private native void glTexCoord3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short s, short t, short r);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord3sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3sv(short[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glTexCoord3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord4d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4d(double s, double t, double r, double q){
        glTexCoord4d_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r, q);
    }
    
    @QtUninvokable
    private native void glTexCoord4d_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double s, double t, double r, double q);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord4dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4dv(double[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glTexCoord4dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord4dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord4f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4f(float s, float t, float r, float q){
        glTexCoord4f_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r, q);
    }
    
    @QtUninvokable
    private native void glTexCoord4f_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float s, float t, float r, float q);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord4fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4fv(float[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glTexCoord4fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord4fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord4i(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4i(int s, int t, int r, int q){
        glTexCoord4i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r, q);
    }
    
    @QtUninvokable
    private native void glTexCoord4i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int s, int t, int r, int q);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord4iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4iv(int[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glTexCoord4iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord4iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord4s(GLshort,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4s(short s, short t, short r, short q){
        glTexCoord4s_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r, q);
    }
    
    @QtUninvokable
    private native void glTexCoord4s_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short s, short t, short r, short q);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoord4sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4sv(short[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glTexCoord4sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord4sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoordP1ui(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glTexCoordP1ui(int type, int coords){
        glTexCoordP1ui_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), type, coords);
    }
    
    @QtUninvokable
    private native void glTexCoordP1ui_native_GLenum_GLuint(long __this__nativeId, int type, int coords);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoordP1uiv(GLenum,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoordP1uiv(int type, java.nio.@Nullable IntBuffer coords){
        glTexCoordP1uiv_native_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, coords);
    }
    
    @QtUninvokable
    private native void glTexCoordP1uiv_native_GLenum_const_GLuint_ptr(long __this__nativeId, int type, java.nio.IntBuffer coords);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoordP2ui(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glTexCoordP2ui(int type, int coords){
        glTexCoordP2ui_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), type, coords);
    }
    
    @QtUninvokable
    private native void glTexCoordP2ui_native_GLenum_GLuint(long __this__nativeId, int type, int coords);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoordP2uiv(GLenum,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoordP2uiv(int type, java.nio.@Nullable IntBuffer coords){
        glTexCoordP2uiv_native_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, coords);
    }
    
    @QtUninvokable
    private native void glTexCoordP2uiv_native_GLenum_const_GLuint_ptr(long __this__nativeId, int type, java.nio.IntBuffer coords);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoordP3ui(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glTexCoordP3ui(int type, int coords){
        glTexCoordP3ui_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), type, coords);
    }
    
    @QtUninvokable
    private native void glTexCoordP3ui_native_GLenum_GLuint(long __this__nativeId, int type, int coords);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoordP3uiv(GLenum,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoordP3uiv(int type, java.nio.@Nullable IntBuffer coords){
        glTexCoordP3uiv_native_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, coords);
    }
    
    @QtUninvokable
    private native void glTexCoordP3uiv_native_GLenum_const_GLuint_ptr(long __this__nativeId, int type, java.nio.IntBuffer coords);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoordP4ui(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glTexCoordP4ui(int type, int coords){
        glTexCoordP4ui_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), type, coords);
    }
    
    @QtUninvokable
    private native void glTexCoordP4ui_native_GLenum_GLuint(long __this__nativeId, int type, int coords);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoordP4uiv(GLenum,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoordP4uiv(int type, java.nio.@Nullable IntBuffer coords){
        glTexCoordP4uiv_native_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, coords);
    }
    
    @QtUninvokable
    private native void glTexCoordP4uiv_native_GLenum_const_GLuint_ptr(long __this__nativeId, int type, java.nio.IntBuffer coords);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexCoordPointer(GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoordPointer(int size, int type, int stride, java.nio.@Nullable Buffer pointer){
        glTexCoordPointer_native_GLint_GLenum_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), size, type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glTexCoordPointer_native_GLint_GLenum_GLsizei_const_void_ptr(long __this__nativeId, int size, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexEnvf(GLenum,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTexEnvf(int target, int pname, float param){
        glTexEnvf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexEnvf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int target, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexEnvfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTexEnvfv(int target, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexEnvfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexEnvfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexEnvi(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glTexEnvi(int target, int pname, int param){
        glTexEnvi_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexEnvi_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexEnviv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexEnviv(int target, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexEnviv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexEnviv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexGend(GLenum,<wbr/>GLenum,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glTexGend(int coord, int pname, double param){
        glTexGend_native_GLenum_GLenum_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, param);
    }
    
    @QtUninvokable
    private native void glTexGend_native_GLenum_GLenum_GLdouble(long __this__nativeId, int coord, int pname, double param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexGendv(GLenum,<wbr/>GLenum,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glTexGendv(int coord, int pname, double[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexGendv_native_GLenum_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glTexGendv_native_GLenum_GLenum_const_GLdouble_ptr(long __this__nativeId, int coord, int pname, double[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexGenf(GLenum,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTexGenf(int coord, int pname, float param){
        glTexGenf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, param);
    }
    
    @QtUninvokable
    private native void glTexGenf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int coord, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexGenfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTexGenfv(int coord, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexGenfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glTexGenfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int coord, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexGeni(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glTexGeni(int coord, int pname, int param){
        glTexGeni_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, param);
    }
    
    @QtUninvokable
    private native void glTexGeni_native_GLenum_GLenum_GLint(long __this__nativeId, int coord, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexGeniv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexGeniv(int coord, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexGeniv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glTexGeniv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int coord, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexImage1D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexImage1D_native_GLenum_GLint_GLint_GLsizei_GLint_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, border, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexImage1D_native_GLenum_GLint_GLint_GLsizei_GLint_GLenum_GLenum_const_void_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int border, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexImage2D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLint_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, border, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexImage2D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLint_GLenum_GLenum_const_void_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int border, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexImage2DMultisample(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glTexImage2DMultisample(int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations){
        glTexImage2DMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, samples, internalformat, width, height, fixedsamplelocations);
    }
    
    @QtUninvokable
    private native void glTexImage2DMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLboolean(long __this__nativeId, int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexImage3D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexImage3D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLsizei_GLint_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, depth, border, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexImage3D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLsizei_GLint_GLenum_GLenum_const_void_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexImage3DMultisample(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glTexImage3DMultisample(int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations){
        glTexImage3DMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLsizei_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, samples, internalformat, width, height, depth, fixedsamplelocations);
    }
    
    @QtUninvokable
    private native void glTexImage3DMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLsizei_GLboolean(long __this__nativeId, int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexParameterIiv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexParameterIiv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glTexParameterIiv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameterIiv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexParameterIuiv(GLenum,<wbr/>GLenum,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glTexParameterIuiv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glTexParameterIuiv_native_GLenum_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameterIuiv_native_GLenum_GLenum_const_GLuint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexParameterf(GLenum,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTexParameterf(int target, int pname, float param){
        glTexParameterf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexParameterf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int target, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexParameterfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTexParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glTexParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexParameteri(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glTexParameteri(int target, int pname, int param){
        glTexParameteri_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexParameteri_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexParameteriv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glTexParameteriv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameteriv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexStorage1D(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glTexStorage1D(int target, int levels, int internalformat, int width){
        glTexStorage1D_native_GLenum_GLsizei_GLenum_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, levels, internalformat, width);
    }
    
    @QtUninvokable
    private native void glTexStorage1D_native_GLenum_GLsizei_GLenum_GLsizei(long __this__nativeId, int target, int levels, int internalformat, int width);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexStorage2D(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glTexStorage2D(int target, int levels, int internalformat, int width, int height){
        glTexStorage2D_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, levels, internalformat, width, height);
    }
    
    @QtUninvokable
    private native void glTexStorage2D_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei(long __this__nativeId, int target, int levels, int internalformat, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexStorage2DMultisample(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glTexStorage2DMultisample(int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations){
        glTexStorage2DMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, samples, internalformat, width, height, fixedsamplelocations);
    }
    
    @QtUninvokable
    private native void glTexStorage2DMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLboolean(long __this__nativeId, int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexStorage3D(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glTexStorage3D(int target, int levels, int internalformat, int width, int height, int depth){
        glTexStorage3D_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, levels, internalformat, width, height, depth);
    }
    
    @QtUninvokable
    private native void glTexStorage3D_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLsizei(long __this__nativeId, int target, int levels, int internalformat, int width, int height, int depth);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexStorage3DMultisample(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glTexStorage3DMultisample(int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations){
        glTexStorage3DMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLsizei_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, samples, internalformat, width, height, depth, fixedsamplelocations);
    }
    
    @QtUninvokable
    private native void glTexStorage3DMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLsizei_GLboolean(long __this__nativeId, int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexSubImage1D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, width, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLenum_const_void_ptr(long __this__nativeId, int target, int level, int xoffset, int width, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexSubImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, width, height, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTexSubImage3D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTextureBarrier()</code></p>
     */
    @QtUninvokable
    public final void glTextureBarrier(){
        glTextureBarrier_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glTextureBarrier_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTextureBuffer(GLuint,<wbr/>GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glTextureBuffer(int texture, int internalformat, int buffer){
        glTextureBuffer_native_GLuint_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), texture, internalformat, buffer);
    }
    
    @QtUninvokable
    private native void glTextureBuffer_native_GLuint_GLenum_GLuint(long __this__nativeId, int texture, int internalformat, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTextureBufferRange(GLuint,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLintptr,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glTextureBufferRange(int texture, int internalformat, int buffer, long offset, int size){
        glTextureBufferRange_native_GLuint_GLenum_GLuint_GLintptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), texture, internalformat, buffer, offset, size);
    }
    
    @QtUninvokable
    private native void glTextureBufferRange_native_GLuint_GLenum_GLuint_GLintptr_GLsizei(long __this__nativeId, int texture, int internalformat, int buffer, long offset, int size);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTextureParameterIiv(GLuint,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTextureParameterIiv(int texture, int pname, java.nio.@Nullable IntBuffer params){
        glTextureParameterIiv_native_GLuint_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, pname, params);
    }
    
    @QtUninvokable
    private native void glTextureParameterIiv_native_GLuint_GLenum_const_GLint_ptr(long __this__nativeId, int texture, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTextureParameterIuiv(GLuint,<wbr/>GLenum,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glTextureParameterIuiv(int texture, int pname, java.nio.@Nullable IntBuffer params){
        glTextureParameterIuiv_native_GLuint_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, pname, params);
    }
    
    @QtUninvokable
    private native void glTextureParameterIuiv_native_GLuint_GLenum_const_GLuint_ptr(long __this__nativeId, int texture, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTextureParameterf(GLuint,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTextureParameterf(int texture, int pname, float param){
        glTextureParameterf_native_GLuint_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), texture, pname, param);
    }
    
    @QtUninvokable
    private native void glTextureParameterf_native_GLuint_GLenum_GLfloat(long __this__nativeId, int texture, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTextureParameterfv(GLuint,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTextureParameterfv(int texture, int pname, java.nio.@Nullable FloatBuffer param){
        glTextureParameterfv_native_GLuint_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, pname, param);
    }
    
    @QtUninvokable
    private native void glTextureParameterfv_native_GLuint_GLenum_const_GLfloat_ptr(long __this__nativeId, int texture, int pname, java.nio.FloatBuffer param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTextureParameteri(GLuint,<wbr/>GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glTextureParameteri(int texture, int pname, int param){
        glTextureParameteri_native_GLuint_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), texture, pname, param);
    }
    
    @QtUninvokable
    private native void glTextureParameteri_native_GLuint_GLenum_GLint(long __this__nativeId, int texture, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTextureParameteriv(GLuint,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTextureParameteriv(int texture, int pname, java.nio.@Nullable IntBuffer param){
        glTextureParameteriv_native_GLuint_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, pname, param);
    }
    
    @QtUninvokable
    private native void glTextureParameteriv_native_GLuint_GLenum_const_GLint_ptr(long __this__nativeId, int texture, int pname, java.nio.IntBuffer param);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTextureStorage1D(GLuint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glTextureStorage1D(int texture, int levels, int internalformat, int width){
        glTextureStorage1D_native_GLuint_GLsizei_GLenum_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), texture, levels, internalformat, width);
    }
    
    @QtUninvokable
    private native void glTextureStorage1D_native_GLuint_GLsizei_GLenum_GLsizei(long __this__nativeId, int texture, int levels, int internalformat, int width);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTextureStorage2D(GLuint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glTextureStorage2D(int texture, int levels, int internalformat, int width, int height){
        glTextureStorage2D_native_GLuint_GLsizei_GLenum_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), texture, levels, internalformat, width, height);
    }
    
    @QtUninvokable
    private native void glTextureStorage2D_native_GLuint_GLsizei_GLenum_GLsizei_GLsizei(long __this__nativeId, int texture, int levels, int internalformat, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTextureStorage2DMultisample(GLuint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glTextureStorage2DMultisample(int texture, int samples, int internalformat, int width, int height, boolean fixedsamplelocations){
        glTextureStorage2DMultisample_native_GLuint_GLsizei_GLenum_GLsizei_GLsizei_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), texture, samples, internalformat, width, height, fixedsamplelocations);
    }
    
    @QtUninvokable
    private native void glTextureStorage2DMultisample_native_GLuint_GLsizei_GLenum_GLsizei_GLsizei_GLboolean(long __this__nativeId, int texture, int samples, int internalformat, int width, int height, boolean fixedsamplelocations);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTextureStorage3D(GLuint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glTextureStorage3D(int texture, int levels, int internalformat, int width, int height, int depth){
        glTextureStorage3D_native_GLuint_GLsizei_GLenum_GLsizei_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), texture, levels, internalformat, width, height, depth);
    }
    
    @QtUninvokable
    private native void glTextureStorage3D_native_GLuint_GLsizei_GLenum_GLsizei_GLsizei_GLsizei(long __this__nativeId, int texture, int levels, int internalformat, int width, int height, int depth);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTextureStorage3DMultisample(GLuint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glTextureStorage3DMultisample(int texture, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations){
        glTextureStorage3DMultisample_native_GLuint_GLsizei_GLenum_GLsizei_GLsizei_GLsizei_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), texture, samples, internalformat, width, height, depth, fixedsamplelocations);
    }
    
    @QtUninvokable
    private native void glTextureStorage3DMultisample_native_GLuint_GLsizei_GLenum_GLsizei_GLsizei_GLsizei_GLboolean(long __this__nativeId, int texture, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTextureSubImage1D(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, java.nio.@Nullable Buffer pixels){
        glTextureSubImage1D_native_GLuint_GLint_GLint_GLsizei_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level, xoffset, width, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTextureSubImage1D_native_GLuint_GLint_GLint_GLsizei_GLenum_GLenum_const_void_ptr(long __this__nativeId, int texture, int level, int xoffset, int width, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTextureSubImage2D(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.@Nullable Buffer pixels){
        glTextureSubImage2D_native_GLuint_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level, xoffset, yoffset, width, height, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTextureSubImage2D_native_GLuint_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr(long __this__nativeId, int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTextureSubImage3D(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.@Nullable Buffer pixels){
        glTextureSubImage3D_native_GLuint_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTextureSubImage3D_native_GLuint_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr(long __this__nativeId, int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTextureView(GLuint,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glTextureView(int texture, int target, int origtexture, int internalformat, int minlevel, int numlevels, int minlayer, int numlayers){
        glTextureView_native_GLuint_GLenum_GLuint_GLenum_GLuint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), texture, target, origtexture, internalformat, minlevel, numlevels, minlayer, numlayers);
    }
    
    @QtUninvokable
    private native void glTextureView_native_GLuint_GLenum_GLuint_GLenum_GLuint_GLuint_GLuint_GLuint(long __this__nativeId, int texture, int target, int origtexture, int internalformat, int minlevel, int numlevels, int minlayer, int numlayers);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTransformFeedbackBufferBase(GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glTransformFeedbackBufferBase(int xfb, int index, int buffer){
        glTransformFeedbackBufferBase_native_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), xfb, index, buffer);
    }
    
    @QtUninvokable
    private native void glTransformFeedbackBufferBase_native_GLuint_GLuint_GLuint(long __this__nativeId, int xfb, int index, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTransformFeedbackBufferRange(GLuint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLintptr,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glTransformFeedbackBufferRange(int xfb, int index, int buffer, long offset, int size){
        glTransformFeedbackBufferRange_native_GLuint_GLuint_GLuint_GLintptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), xfb, index, buffer, offset, size);
    }
    
    @QtUninvokable
    private native void glTransformFeedbackBufferRange_native_GLuint_GLuint_GLuint_GLintptr_GLsizei(long __this__nativeId, int xfb, int index, int buffer, long offset, int size);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTransformFeedbackVaryings(GLuint,<wbr/>GLsizei,<wbr/>const GLchar*const*,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glTransformFeedbackVaryings(int program, java.lang.String[] varyings, int bufferMode){
        glTransformFeedbackVaryings_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), program, varyings, bufferMode);
    }
    
    @QtUninvokable
    private native void glTransformFeedbackVaryings_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLenum(long __this__nativeId, int program, java.lang.String[] varyings, int bufferMode);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTranslated(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glTranslated(double x, double y, double z){
        glTranslated_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glTranslated_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glTranslatef(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTranslatef(float x, float y, float z){
        glTranslatef_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glTranslatef_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform1d(GLint,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glUniform1d(int location, double x){
        glUniform1d_native_GLint_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), location, x);
    }
    
    @QtUninvokable
    private native void glUniform1d_native_GLint_GLdouble(long __this__nativeId, int location, double x);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform1dv(GLint,<wbr/>GLsizei,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glUniform1dv(int location, int count, java.nio.@Nullable DoubleBuffer value){
        glUniform1dv_native_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform1dv_native_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int location, int count, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform1f(GLint,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glUniform1f(int location, float v0){
        glUniform1f_native_GLint_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0);
    }
    
    @QtUninvokable
    private native void glUniform1f_native_GLint_GLfloat(long __this__nativeId, int location, float v0);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform1fv(GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniform1fv(int location, int count, java.nio.@Nullable FloatBuffer value){
        glUniform1fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform1fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform1i(GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glUniform1i(int location, int v0){
        glUniform1i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0);
    }
    
    @QtUninvokable
    private native void glUniform1i_native_GLint_GLint(long __this__nativeId, int location, int v0);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform1iv(GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform1iv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform1iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform1iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform1ui(GLint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glUniform1ui(int location, int v0){
        glUniform1ui_native_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0);
    }
    
    @QtUninvokable
    private native void glUniform1ui_native_GLint_GLuint(long __this__nativeId, int location, int v0);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform1uiv(GLint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform1uiv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform1uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform1uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform2d(GLint,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glUniform2d(int location, double x, double y){
        glUniform2d_native_GLint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y);
    }
    
    @QtUninvokable
    private native void glUniform2d_native_GLint_GLdouble_GLdouble(long __this__nativeId, int location, double x, double y);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform2dv(GLint,<wbr/>GLsizei,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glUniform2dv(int location, int count, java.nio.@Nullable DoubleBuffer value){
        glUniform2dv_native_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform2dv_native_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int location, int count, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform2f(GLint,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glUniform2f(int location, float v0, float v1){
        glUniform2f_native_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1);
    }
    
    @QtUninvokable
    private native void glUniform2f_native_GLint_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform2fv(GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniform2fv(int location, int count, java.nio.@Nullable FloatBuffer value){
        glUniform2fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform2fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform2i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glUniform2i(int location, int v0, int v1){
        glUniform2i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1);
    }
    
    @QtUninvokable
    private native void glUniform2i_native_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform2iv(GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform2iv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform2iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform2iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform2ui(GLint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glUniform2ui(int location, int v0, int v1){
        glUniform2ui_native_GLint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1);
    }
    
    @QtUninvokable
    private native void glUniform2ui_native_GLint_GLuint_GLuint(long __this__nativeId, int location, int v0, int v1);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform2uiv(GLint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform2uiv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform2uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform2uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform3d(GLint,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glUniform3d(int location, double x, double y, double z){
        glUniform3d_native_GLint_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z);
    }
    
    @QtUninvokable
    private native void glUniform3d_native_GLint_GLdouble_GLdouble_GLdouble(long __this__nativeId, int location, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform3dv(GLint,<wbr/>GLsizei,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glUniform3dv(int location, int count, java.nio.@Nullable DoubleBuffer value){
        glUniform3dv_native_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform3dv_native_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int location, int count, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform3f(GLint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glUniform3f(int location, float v0, float v1, float v2){
        glUniform3f_native_GLint_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glUniform3f_native_GLint_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1, float v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform3fv(GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniform3fv(int location, int count, java.nio.@Nullable FloatBuffer value){
        glUniform3fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform3fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform3i(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glUniform3i(int location, int v0, int v1, int v2){
        glUniform3i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glUniform3i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1, int v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform3iv(GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform3iv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform3iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform3iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform3ui(GLint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glUniform3ui(int location, int v0, int v1, int v2){
        glUniform3ui_native_GLint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glUniform3ui_native_GLint_GLuint_GLuint_GLuint(long __this__nativeId, int location, int v0, int v1, int v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform3uiv(GLint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform3uiv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform3uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform3uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform4d(GLint,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glUniform4d(int location, double x, double y, double z, double w){
        glUniform4d_native_GLint_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glUniform4d_native_GLint_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, int location, double x, double y, double z, double w);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform4dv(GLint,<wbr/>GLsizei,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glUniform4dv(int location, int count, java.nio.@Nullable DoubleBuffer value){
        glUniform4dv_native_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform4dv_native_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int location, int count, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform4f(GLint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glUniform4f(int location, float v0, float v1, float v2, float v3){
        glUniform4f_native_GLint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glUniform4f_native_GLint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1, float v2, float v3);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform4fv(GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniform4fv(int location, int count, java.nio.@Nullable FloatBuffer value){
        glUniform4fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform4fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform4i(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glUniform4i(int location, int v0, int v1, int v2, int v3){
        glUniform4i_native_GLint_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glUniform4i_native_GLint_GLint_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1, int v2, int v3);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform4iv(GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform4iv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform4iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform4iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform4ui(GLint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glUniform4ui(int location, int v0, int v1, int v2, int v3){
        glUniform4ui_native_GLint_GLuint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glUniform4ui_native_GLint_GLuint_GLuint_GLuint_GLuint(long __this__nativeId, int location, int v0, int v1, int v2, int v3);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniform4uiv(GLint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform4uiv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform4uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform4uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniformBlockBinding(GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glUniformBlockBinding(int program, int uniformBlockIndex, int uniformBlockBinding){
        glUniformBlockBinding_native_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockIndex, uniformBlockBinding);
    }
    
    @QtUninvokable
    private native void glUniformBlockBinding_native_GLuint_GLuint_GLuint(long __this__nativeId, int program, int uniformBlockIndex, int uniformBlockBinding);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniformMatrix2dv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix2dv(int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glUniformMatrix2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniformMatrix2fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix2fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniformMatrix2x3dv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix2x3dv(int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glUniformMatrix2x3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2x3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniformMatrix2x3fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix2x3fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix2x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniformMatrix2x4dv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix2x4dv(int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glUniformMatrix2x4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2x4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniformMatrix2x4fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix2x4fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix2x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniformMatrix3dv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix3dv(int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glUniformMatrix3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniformMatrix3fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix3fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniformMatrix3x2dv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix3x2dv(int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glUniformMatrix3x2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3x2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniformMatrix3x2fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix3x2fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix3x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniformMatrix3x4dv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix3x4dv(int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glUniformMatrix3x4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3x4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniformMatrix3x4fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix3x4fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix3x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniformMatrix4dv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix4dv(int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glUniformMatrix4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniformMatrix4fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix4fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniformMatrix4x2dv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix4x2dv(int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glUniformMatrix4x2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4x2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniformMatrix4x2fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix4x2fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix4x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniformMatrix4x3dv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix4x3dv(int location, int count, boolean transpose, java.nio.@Nullable DoubleBuffer value){
        glUniformMatrix4x3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4x3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniformMatrix4x3fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix4x3fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix4x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUniformSubroutinesuiv(GLenum,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glUniformSubroutinesuiv(int shadertype, int count, java.nio.@Nullable IntBuffer indices){
        glUniformSubroutinesuiv_native_GLenum_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shadertype, count, indices);
    }
    
    @QtUninvokable
    private native void glUniformSubroutinesuiv_native_GLenum_GLsizei_const_GLuint_ptr(long __this__nativeId, int shadertype, int count, java.nio.IntBuffer indices);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUnmapBuffer(GLenum)</code></p>
     */
    @QtUninvokable
    public final boolean glUnmapBuffer(int target){
        return glUnmapBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native boolean glUnmapBuffer_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUnmapNamedBuffer(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glUnmapNamedBuffer(int buffer){
        return glUnmapNamedBuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), buffer);
    }
    
    @QtUninvokable
    private native boolean glUnmapNamedBuffer_native_GLuint(long __this__nativeId, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUseProgram(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glUseProgram(int program){
        glUseProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glUseProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glUseProgramStages(GLuint,<wbr/>GLbitfield,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glUseProgramStages(int pipeline, int stages, int program){
        glUseProgramStages_native_GLuint_GLbitfield_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), pipeline, stages, program);
    }
    
    @QtUninvokable
    private native void glUseProgramStages_native_GLuint_GLbitfield_GLuint(long __this__nativeId, int pipeline, int stages, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glValidateProgram(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glValidateProgram(int program){
        glValidateProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glValidateProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glValidateProgramPipeline(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glValidateProgramPipeline(int pipeline){
        glValidateProgramPipeline_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), pipeline);
    }
    
    @QtUninvokable
    private native void glValidateProgramPipeline_native_GLuint(long __this__nativeId, int pipeline);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex2d(GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glVertex2d(double x, double y){
        glVertex2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glVertex2d_native_GLdouble_GLdouble(long __this__nativeId, double x, double y);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex2dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glVertex2dv(double[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glVertex2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex2dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex2f(GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glVertex2f(float x, float y){
        glVertex2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glVertex2f_native_GLfloat_GLfloat(long __this__nativeId, float x, float y);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex2fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glVertex2fv(float[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glVertex2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex2fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex2i(GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glVertex2i(int x, int y){
        glVertex2i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glVertex2i_native_GLint_GLint(long __this__nativeId, int x, int y);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex2iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glVertex2iv(int[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glVertex2iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex2iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex2s(GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glVertex2s(short x, short y){
        glVertex2s_native_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glVertex2s_native_GLshort_GLshort(long __this__nativeId, short x, short y);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex2sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glVertex2sv(short[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glVertex2sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex2sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex3d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glVertex3d(double x, double y, double z){
        glVertex3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glVertex3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex3dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glVertex3dv(double[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glVertex3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex3f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glVertex3f(float x, float y, float z){
        glVertex3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glVertex3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex3fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glVertex3fv(float[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glVertex3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex3i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glVertex3i(int x, int y, int z){
        glVertex3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glVertex3i_native_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex3iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glVertex3iv(int[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glVertex3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex3s(GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glVertex3s(short x, short y, short z){
        glVertex3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glVertex3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex3sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glVertex3sv(short[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glVertex3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex4d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glVertex4d(double x, double y, double z, double w){
        glVertex4d_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertex4d_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z, double w);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex4dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glVertex4dv(double[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glVertex4dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex4dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex4f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glVertex4f(float x, float y, float z, float w){
        glVertex4f_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertex4f_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z, float w);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex4fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glVertex4fv(float[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glVertex4fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex4fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex4i(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glVertex4i(int x, int y, int z, int w){
        glVertex4i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertex4i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z, int w);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex4iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glVertex4iv(int[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glVertex4iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex4iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex4s(GLshort,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glVertex4s(short x, short y, short z, short w){
        glVertex4s_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertex4s_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z, short w);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertex4sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glVertex4sv(short[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glVertex4sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex4sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexArrayAttribBinding(GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexArrayAttribBinding(int vaobj, int attribindex, int bindingindex){
        glVertexArrayAttribBinding_native_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), vaobj, attribindex, bindingindex);
    }
    
    @QtUninvokable
    private native void glVertexArrayAttribBinding_native_GLuint_GLuint_GLuint(long __this__nativeId, int vaobj, int attribindex, int bindingindex);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexArrayAttribFormat(GLuint,<wbr/>GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexArrayAttribFormat(int vaobj, int attribindex, int size, int type, boolean normalized, int relativeoffset){
        glVertexArrayAttribFormat_native_GLuint_GLuint_GLint_GLenum_GLboolean_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), vaobj, attribindex, size, type, normalized, relativeoffset);
    }
    
    @QtUninvokable
    private native void glVertexArrayAttribFormat_native_GLuint_GLuint_GLint_GLenum_GLboolean_GLuint(long __this__nativeId, int vaobj, int attribindex, int size, int type, boolean normalized, int relativeoffset);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexArrayAttribIFormat(GLuint,<wbr/>GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexArrayAttribIFormat(int vaobj, int attribindex, int size, int type, int relativeoffset){
        glVertexArrayAttribIFormat_native_GLuint_GLuint_GLint_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), vaobj, attribindex, size, type, relativeoffset);
    }
    
    @QtUninvokable
    private native void glVertexArrayAttribIFormat_native_GLuint_GLuint_GLint_GLenum_GLuint(long __this__nativeId, int vaobj, int attribindex, int size, int type, int relativeoffset);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexArrayAttribLFormat(GLuint,<wbr/>GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexArrayAttribLFormat(int vaobj, int attribindex, int size, int type, int relativeoffset){
        glVertexArrayAttribLFormat_native_GLuint_GLuint_GLint_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), vaobj, attribindex, size, type, relativeoffset);
    }
    
    @QtUninvokable
    private native void glVertexArrayAttribLFormat_native_GLuint_GLuint_GLint_GLenum_GLuint(long __this__nativeId, int vaobj, int attribindex, int size, int type, int relativeoffset);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexArrayBindingDivisor(GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexArrayBindingDivisor(int vaobj, int bindingindex, int divisor){
        glVertexArrayBindingDivisor_native_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), vaobj, bindingindex, divisor);
    }
    
    @QtUninvokable
    private native void glVertexArrayBindingDivisor_native_GLuint_GLuint_GLuint(long __this__nativeId, int vaobj, int bindingindex, int divisor);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexArrayElementBuffer(GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexArrayElementBuffer(int vaobj, int buffer){
        glVertexArrayElementBuffer_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), vaobj, buffer);
    }
    
    @QtUninvokable
    private native void glVertexArrayElementBuffer_native_GLuint_GLuint(long __this__nativeId, int vaobj, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexArrayVertexBuffer(GLuint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLintptr,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glVertexArrayVertexBuffer(int vaobj, int bindingindex, int buffer, long offset, int stride){
        glVertexArrayVertexBuffer_native_GLuint_GLuint_GLuint_GLintptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), vaobj, bindingindex, buffer, offset, stride);
    }
    
    @QtUninvokable
    private native void glVertexArrayVertexBuffer_native_GLuint_GLuint_GLuint_GLintptr_GLsizei(long __this__nativeId, int vaobj, int bindingindex, int buffer, long offset, int stride);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexArrayVertexBuffers(GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>const GLuint*,<wbr/>const GLintptr*,<wbr/>const GLsizei*)</code></p>
     */
    @QtUninvokable
    public final void glVertexArrayVertexBuffers(int vaobj, int first, int count, java.nio.@Nullable IntBuffer buffers, java.nio.@Nullable LongBuffer offsets, java.nio.@Nullable IntBuffer strides){
        glVertexArrayVertexBuffers_native_GLuint_GLuint_GLsizei_const_GLuint_ptr_const_GLintptr_ptr_const_GLsizei_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), vaobj, first, count, buffers, offsets, strides);
    }
    
    @QtUninvokable
    private native void glVertexArrayVertexBuffers_native_GLuint_GLuint_GLsizei_const_GLuint_ptr_const_GLintptr_ptr_const_GLsizei_ptr(long __this__nativeId, int vaobj, int first, int count, java.nio.IntBuffer buffers, java.nio.LongBuffer offsets, java.nio.IntBuffer strides);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib1d(GLuint,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib1d(int index, double x){
        glVertexAttrib1d_native_GLuint_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @QtUninvokable
    private native void glVertexAttrib1d_native_GLuint_GLdouble(long __this__nativeId, int index, double x);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib1dv(GLuint,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib1dv(int index, java.nio.@Nullable DoubleBuffer v){
        glVertexAttrib1dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib1dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib1f(GLuint,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib1f(int index, float x){
        glVertexAttrib1f_native_GLuint_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @QtUninvokable
    private native void glVertexAttrib1f_native_GLuint_GLfloat(long __this__nativeId, int index, float x);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib1fv(GLuint,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib1fv(int index, java.nio.@Nullable FloatBuffer v){
        glVertexAttrib1fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib1fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib1s(GLuint,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib1s(int index, short x){
        glVertexAttrib1s_native_GLuint_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @QtUninvokable
    private native void glVertexAttrib1s_native_GLuint_GLshort(long __this__nativeId, int index, short x);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib1sv(GLuint,<wbr/>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib1sv(int index, java.nio.@Nullable ShortBuffer v){
        glVertexAttrib1sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib1sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib2d(GLuint,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib2d(int index, double x, double y){
        glVertexAttrib2d_native_GLuint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @QtUninvokable
    private native void glVertexAttrib2d_native_GLuint_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib2dv(GLuint,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib2dv(int index, java.nio.@Nullable DoubleBuffer v){
        glVertexAttrib2dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib2dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib2f(GLuint,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib2f(int index, float x, float y){
        glVertexAttrib2f_native_GLuint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @QtUninvokable
    private native void glVertexAttrib2f_native_GLuint_GLfloat_GLfloat(long __this__nativeId, int index, float x, float y);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib2fv(GLuint,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib2fv(int index, java.nio.@Nullable FloatBuffer v){
        glVertexAttrib2fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib2fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib2s(GLuint,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib2s(int index, short x, short y){
        glVertexAttrib2s_native_GLuint_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @QtUninvokable
    private native void glVertexAttrib2s_native_GLuint_GLshort_GLshort(long __this__nativeId, int index, short x, short y);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib2sv(GLuint,<wbr/>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib2sv(int index, java.nio.@Nullable ShortBuffer v){
        glVertexAttrib2sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib2sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib3d(GLuint,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib3d(int index, double x, double y, double z){
        glVertexAttrib3d_native_GLuint_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @QtUninvokable
    private native void glVertexAttrib3d_native_GLuint_GLdouble_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib3dv(GLuint,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib3dv(int index, java.nio.@Nullable DoubleBuffer v){
        glVertexAttrib3dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib3dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib3f(GLuint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib3f(int index, float x, float y, float z){
        glVertexAttrib3f_native_GLuint_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @QtUninvokable
    private native void glVertexAttrib3f_native_GLuint_GLfloat_GLfloat_GLfloat(long __this__nativeId, int index, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib3fv(GLuint,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib3fv(int index, java.nio.@Nullable FloatBuffer v){
        glVertexAttrib3fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib3fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib3s(GLuint,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib3s(int index, short x, short y, short z){
        glVertexAttrib3s_native_GLuint_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @QtUninvokable
    private native void glVertexAttrib3s_native_GLuint_GLshort_GLshort_GLshort(long __this__nativeId, int index, short x, short y, short z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib3sv(GLuint,<wbr/>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib3sv(int index, java.nio.@Nullable ShortBuffer v){
        glVertexAttrib3sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib3sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib4Nbv(GLuint,<wbr/>const GLbyte*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4Nbv(int index, java.nio.@Nullable ByteBuffer v){
        glVertexAttrib4Nbv_native_GLuint_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4Nbv_native_GLuint_const_GLbyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib4Niv(GLuint,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4Niv(int index, java.nio.@Nullable IntBuffer v){
        glVertexAttrib4Niv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4Niv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib4Nsv(GLuint,<wbr/>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4Nsv(int index, java.nio.@Nullable ShortBuffer v){
        glVertexAttrib4Nsv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4Nsv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib4Nub(GLuint,<wbr/>GLubyte,<wbr/>GLubyte,<wbr/>GLubyte,<wbr/>GLubyte)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4Nub(int index, byte x, byte y, byte z, byte w){
        glVertexAttrib4Nub_native_GLuint_GLubyte_GLubyte_GLubyte_GLubyte(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4Nub_native_GLuint_GLubyte_GLubyte_GLubyte_GLubyte(long __this__nativeId, int index, byte x, byte y, byte z, byte w);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib4Nubv(GLuint,<wbr/>const GLubyte*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4Nubv(int index, java.nio.@Nullable ByteBuffer v){
        glVertexAttrib4Nubv_native_GLuint_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4Nubv_native_GLuint_const_GLubyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib4Nuiv(GLuint,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4Nuiv(int index, java.nio.@Nullable IntBuffer v){
        glVertexAttrib4Nuiv_native_GLuint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4Nuiv_native_GLuint_const_GLuint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib4Nusv(GLuint,<wbr/>const GLushort*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4Nusv(int index, java.nio.@Nullable ShortBuffer v){
        glVertexAttrib4Nusv_native_GLuint_const_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4Nusv_native_GLuint_const_GLushort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib4bv(GLuint,<wbr/>const GLbyte*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4bv(int index, java.nio.@Nullable ByteBuffer v){
        glVertexAttrib4bv_native_GLuint_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4bv_native_GLuint_const_GLbyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib4d(GLuint,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4d(int index, double x, double y, double z, double w){
        glVertexAttrib4d_native_GLuint_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4d_native_GLuint_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y, double z, double w);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib4dv(GLuint,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4dv(int index, java.nio.@Nullable DoubleBuffer v){
        glVertexAttrib4dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib4f(GLuint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4f(int index, float x, float y, float z, float w){
        glVertexAttrib4f_native_GLuint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4f_native_GLuint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int index, float x, float y, float z, float w);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib4fv(GLuint,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4fv(int index, java.nio.@Nullable FloatBuffer v){
        glVertexAttrib4fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib4iv(GLuint,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4iv(int index, java.nio.@Nullable IntBuffer v){
        glVertexAttrib4iv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4iv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib4s(GLuint,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4s(int index, short x, short y, short z, short w){
        glVertexAttrib4s_native_GLuint_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4s_native_GLuint_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, int index, short x, short y, short z, short w);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib4sv(GLuint,<wbr/>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4sv(int index, java.nio.@Nullable ShortBuffer v){
        glVertexAttrib4sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib4ubv(GLuint,<wbr/>const GLubyte*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4ubv(int index, java.nio.@Nullable ByteBuffer v){
        glVertexAttrib4ubv_native_GLuint_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4ubv_native_GLuint_const_GLubyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib4uiv(GLuint,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4uiv(int index, java.nio.@Nullable IntBuffer v){
        glVertexAttrib4uiv_native_GLuint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4uiv_native_GLuint_const_GLuint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttrib4usv(GLuint,<wbr/>const GLushort*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4usv(int index, java.nio.@Nullable ShortBuffer v){
        glVertexAttrib4usv_native_GLuint_const_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4usv_native_GLuint_const_GLushort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribBinding(GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribBinding(int attribindex, int bindingindex){
        glVertexAttribBinding_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), attribindex, bindingindex);
    }
    
    @QtUninvokable
    private native void glVertexAttribBinding_native_GLuint_GLuint(long __this__nativeId, int attribindex, int bindingindex);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribDivisor(GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribDivisor(int index, int divisor){
        glVertexAttribDivisor_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, divisor);
    }
    
    @QtUninvokable
    private native void glVertexAttribDivisor_native_GLuint_GLuint(long __this__nativeId, int index, int divisor);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribFormat(GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribFormat(int attribindex, int size, int type, boolean normalized, int relativeoffset){
        glVertexAttribFormat_native_GLuint_GLint_GLenum_GLboolean_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), attribindex, size, type, normalized, relativeoffset);
    }
    
    @QtUninvokable
    private native void glVertexAttribFormat_native_GLuint_GLint_GLenum_GLboolean_GLuint(long __this__nativeId, int attribindex, int size, int type, boolean normalized, int relativeoffset);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribI1i(GLuint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI1i(int index, int x){
        glVertexAttribI1i_native_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @QtUninvokable
    private native void glVertexAttribI1i_native_GLuint_GLint(long __this__nativeId, int index, int x);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribI1iv(GLuint,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI1iv(int index, java.nio.@Nullable IntBuffer v){
        glVertexAttribI1iv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI1iv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribI1ui(GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI1ui(int index, int x){
        glVertexAttribI1ui_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @QtUninvokable
    private native void glVertexAttribI1ui_native_GLuint_GLuint(long __this__nativeId, int index, int x);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribI1uiv(GLuint,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI1uiv(int index, java.nio.@Nullable IntBuffer v){
        glVertexAttribI1uiv_native_GLuint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI1uiv_native_GLuint_const_GLuint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribI2i(GLuint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI2i(int index, int x, int y){
        glVertexAttribI2i_native_GLuint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @QtUninvokable
    private native void glVertexAttribI2i_native_GLuint_GLint_GLint(long __this__nativeId, int index, int x, int y);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribI2iv(GLuint,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI2iv(int index, java.nio.@Nullable IntBuffer v){
        glVertexAttribI2iv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI2iv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribI2ui(GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI2ui(int index, int x, int y){
        glVertexAttribI2ui_native_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @QtUninvokable
    private native void glVertexAttribI2ui_native_GLuint_GLuint_GLuint(long __this__nativeId, int index, int x, int y);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribI2uiv(GLuint,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI2uiv(int index, java.nio.@Nullable IntBuffer v){
        glVertexAttribI2uiv_native_GLuint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI2uiv_native_GLuint_const_GLuint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribI3i(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI3i(int index, int x, int y, int z){
        glVertexAttribI3i_native_GLuint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @QtUninvokable
    private native void glVertexAttribI3i_native_GLuint_GLint_GLint_GLint(long __this__nativeId, int index, int x, int y, int z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribI3iv(GLuint,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI3iv(int index, java.nio.@Nullable IntBuffer v){
        glVertexAttribI3iv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI3iv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribI3ui(GLuint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI3ui(int index, int x, int y, int z){
        glVertexAttribI3ui_native_GLuint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @QtUninvokable
    private native void glVertexAttribI3ui_native_GLuint_GLuint_GLuint_GLuint(long __this__nativeId, int index, int x, int y, int z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribI3uiv(GLuint,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI3uiv(int index, java.nio.@Nullable IntBuffer v){
        glVertexAttribI3uiv_native_GLuint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI3uiv_native_GLuint_const_GLuint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribI4bv(GLuint,<wbr/>const GLbyte*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI4bv(int index, java.nio.@Nullable ByteBuffer v){
        glVertexAttribI4bv_native_GLuint_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI4bv_native_GLuint_const_GLbyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribI4i(GLuint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI4i(int index, int x, int y, int z, int w){
        glVertexAttribI4i_native_GLuint_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertexAttribI4i_native_GLuint_GLint_GLint_GLint_GLint(long __this__nativeId, int index, int x, int y, int z, int w);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribI4iv(GLuint,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI4iv(int index, java.nio.@Nullable IntBuffer v){
        glVertexAttribI4iv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI4iv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribI4sv(GLuint,<wbr/>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI4sv(int index, java.nio.@Nullable ShortBuffer v){
        glVertexAttribI4sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI4sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribI4ubv(GLuint,<wbr/>const GLubyte*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI4ubv(int index, java.nio.@Nullable ByteBuffer v){
        glVertexAttribI4ubv_native_GLuint_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI4ubv_native_GLuint_const_GLubyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribI4ui(GLuint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI4ui(int index, int x, int y, int z, int w){
        glVertexAttribI4ui_native_GLuint_GLuint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertexAttribI4ui_native_GLuint_GLuint_GLuint_GLuint_GLuint(long __this__nativeId, int index, int x, int y, int z, int w);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribI4uiv(GLuint,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI4uiv(int index, java.nio.@Nullable IntBuffer v){
        glVertexAttribI4uiv_native_GLuint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI4uiv_native_GLuint_const_GLuint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribI4usv(GLuint,<wbr/>const GLushort*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI4usv(int index, java.nio.@Nullable ShortBuffer v){
        glVertexAttribI4usv_native_GLuint_const_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI4usv_native_GLuint_const_GLushort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribIFormat(GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribIFormat(int attribindex, int size, int type, int relativeoffset){
        glVertexAttribIFormat_native_GLuint_GLint_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), attribindex, size, type, relativeoffset);
    }
    
    @QtUninvokable
    private native void glVertexAttribIFormat_native_GLuint_GLint_GLenum_GLuint(long __this__nativeId, int attribindex, int size, int type, int relativeoffset);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribIPointer(GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribIPointer(int index, int size, int type, int stride, java.nio.@Nullable Buffer pointer){
        glVertexAttribIPointer_native_GLuint_GLint_GLenum_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, size, type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glVertexAttribIPointer_native_GLuint_GLint_GLenum_GLsizei_const_void_ptr(long __this__nativeId, int index, int size, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribL1d(GLuint,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribL1d(int index, double x){
        glVertexAttribL1d_native_GLuint_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @QtUninvokable
    private native void glVertexAttribL1d_native_GLuint_GLdouble(long __this__nativeId, int index, double x);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribL1dv(GLuint,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribL1dv(int index, java.nio.@Nullable DoubleBuffer v){
        glVertexAttribL1dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribL1dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribL2d(GLuint,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribL2d(int index, double x, double y){
        glVertexAttribL2d_native_GLuint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @QtUninvokable
    private native void glVertexAttribL2d_native_GLuint_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribL2dv(GLuint,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribL2dv(int index, java.nio.@Nullable DoubleBuffer v){
        glVertexAttribL2dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribL2dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribL3d(GLuint,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribL3d(int index, double x, double y, double z){
        glVertexAttribL3d_native_GLuint_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @QtUninvokable
    private native void glVertexAttribL3d_native_GLuint_GLdouble_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribL3dv(GLuint,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribL3dv(int index, java.nio.@Nullable DoubleBuffer v){
        glVertexAttribL3dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribL3dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribL4d(GLuint,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribL4d(int index, double x, double y, double z, double w){
        glVertexAttribL4d_native_GLuint_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertexAttribL4d_native_GLuint_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y, double z, double w);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribL4dv(GLuint,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribL4dv(int index, java.nio.@Nullable DoubleBuffer v){
        glVertexAttribL4dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribL4dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribLFormat(GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribLFormat(int attribindex, int size, int type, int relativeoffset){
        glVertexAttribLFormat_native_GLuint_GLint_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), attribindex, size, type, relativeoffset);
    }
    
    @QtUninvokable
    private native void glVertexAttribLFormat_native_GLuint_GLint_GLenum_GLuint(long __this__nativeId, int attribindex, int size, int type, int relativeoffset);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribLPointer(GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribLPointer(int index, int size, int type, int stride, java.nio.@Nullable Buffer pointer){
        glVertexAttribLPointer_native_GLuint_GLint_GLenum_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, size, type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glVertexAttribLPointer_native_GLuint_GLint_GLenum_GLsizei_const_void_ptr(long __this__nativeId, int index, int size, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribP1ui(GLuint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribP1ui(int index, int type, boolean normalized, int value){
        glVertexAttribP1ui_native_GLuint_GLenum_GLboolean_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP1ui_native_GLuint_GLenum_GLboolean_GLuint(long __this__nativeId, int index, int type, boolean normalized, int value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribP1uiv(GLuint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribP1uiv(int index, int type, boolean normalized, java.nio.@Nullable IntBuffer value){
        glVertexAttribP1uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP1uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(long __this__nativeId, int index, int type, boolean normalized, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribP2ui(GLuint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribP2ui(int index, int type, boolean normalized, int value){
        glVertexAttribP2ui_native_GLuint_GLenum_GLboolean_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP2ui_native_GLuint_GLenum_GLboolean_GLuint(long __this__nativeId, int index, int type, boolean normalized, int value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribP2uiv(GLuint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribP2uiv(int index, int type, boolean normalized, java.nio.@Nullable IntBuffer value){
        glVertexAttribP2uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP2uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(long __this__nativeId, int index, int type, boolean normalized, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribP3ui(GLuint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribP3ui(int index, int type, boolean normalized, int value){
        glVertexAttribP3ui_native_GLuint_GLenum_GLboolean_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP3ui_native_GLuint_GLenum_GLboolean_GLuint(long __this__nativeId, int index, int type, boolean normalized, int value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribP3uiv(GLuint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribP3uiv(int index, int type, boolean normalized, java.nio.@Nullable IntBuffer value){
        glVertexAttribP3uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP3uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(long __this__nativeId, int index, int type, boolean normalized, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribP4ui(GLuint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribP4ui(int index, int type, boolean normalized, int value){
        glVertexAttribP4ui_native_GLuint_GLenum_GLboolean_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP4ui_native_GLuint_GLenum_GLboolean_GLuint(long __this__nativeId, int index, int type, boolean normalized, int value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribP4uiv(GLuint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribP4uiv(int index, int type, boolean normalized, java.nio.@Nullable IntBuffer value){
        glVertexAttribP4uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP4uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(long __this__nativeId, int index, int type, boolean normalized, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexAttribPointer(GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>GLsizei,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, java.nio.@Nullable Buffer pointer){
        glVertexAttribPointer_native_GLuint_GLint_GLenum_GLboolean_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, size, type, normalized, stride, pointer);
    }
    
    @QtUninvokable
    private native void glVertexAttribPointer_native_GLuint_GLint_GLenum_GLboolean_GLsizei_const_void_ptr(long __this__nativeId, int index, int size, int type, boolean normalized, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexBindingDivisor(GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexBindingDivisor(int bindingindex, int divisor){
        glVertexBindingDivisor_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), bindingindex, divisor);
    }
    
    @QtUninvokable
    private native void glVertexBindingDivisor_native_GLuint_GLuint(long __this__nativeId, int bindingindex, int divisor);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexP2ui(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexP2ui(int type, int value){
        glVertexP2ui_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), type, value);
    }
    
    @QtUninvokable
    private native void glVertexP2ui_native_GLenum_GLuint(long __this__nativeId, int type, int value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexP2uiv(GLenum,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexP2uiv(int type, java.nio.@Nullable IntBuffer value){
        glVertexP2uiv_native_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, value);
    }
    
    @QtUninvokable
    private native void glVertexP2uiv_native_GLenum_const_GLuint_ptr(long __this__nativeId, int type, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexP3ui(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexP3ui(int type, int value){
        glVertexP3ui_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), type, value);
    }
    
    @QtUninvokable
    private native void glVertexP3ui_native_GLenum_GLuint(long __this__nativeId, int type, int value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexP3uiv(GLenum,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexP3uiv(int type, java.nio.@Nullable IntBuffer value){
        glVertexP3uiv_native_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, value);
    }
    
    @QtUninvokable
    private native void glVertexP3uiv_native_GLenum_const_GLuint_ptr(long __this__nativeId, int type, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexP4ui(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexP4ui(int type, int value){
        glVertexP4ui_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), type, value);
    }
    
    @QtUninvokable
    private native void glVertexP4ui_native_GLenum_GLuint(long __this__nativeId, int type, int value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexP4uiv(GLenum,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexP4uiv(int type, java.nio.@Nullable IntBuffer value){
        glVertexP4uiv_native_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, value);
    }
    
    @QtUninvokable
    private native void glVertexP4uiv_native_GLenum_const_GLuint_ptr(long __this__nativeId, int type, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glVertexPointer(GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const void*)</code></p>
     */
    @QtUninvokable
    public final void glVertexPointer(int size, int type, int stride, java.nio.@Nullable Buffer pointer){
        glVertexPointer_native_GLint_GLenum_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), size, type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glVertexPointer_native_GLint_GLenum_GLsizei_const_void_ptr(long __this__nativeId, int size, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glViewport(GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glViewport(int x, int y, int width, int height){
        glViewport_native_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height);
    }
    
    @QtUninvokable
    private native void glViewport_native_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glViewportArrayv(GLuint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glViewportArrayv(int first, int count, java.nio.@Nullable FloatBuffer v){
        glViewportArrayv_native_GLuint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), first, count, v);
    }
    
    @QtUninvokable
    private native void glViewportArrayv_native_GLuint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int first, int count, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glViewportIndexedf(GLuint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glViewportIndexedf(int index, float x, float y, float w, float h){
        glViewportIndexedf_native_GLuint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, w, h);
    }
    
    @QtUninvokable
    private native void glViewportIndexedf_native_GLuint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int index, float x, float y, float w, float h);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glViewportIndexedfv(GLuint,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glViewportIndexedfv(int index, java.nio.@Nullable FloatBuffer v){
        glViewportIndexedfv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glViewportIndexedfv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glWaitSync(GLsync,<wbr/>GLbitfield,<wbr/>GLuint64)</code></p>
     */
    @QtUninvokable
    public final void glWaitSync(io.qt.gui.gl.@Nullable GLsync sync, int flags, long timeout){
        glWaitSync_native___GLsync_ptr_GLbitfield_GLuint64(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync), flags, timeout);
    }
    
    @QtUninvokable
    private native void glWaitSync_native___GLsync_ptr_GLbitfield_GLuint64(long __this__nativeId, long sync, int flags, long timeout);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glWindowPos2d(GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos2d(double x, double y){
        glWindowPos2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glWindowPos2d_native_GLdouble_GLdouble(long __this__nativeId, double x, double y);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glWindowPos2dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos2dv(java.nio.@Nullable DoubleBuffer v){
        glWindowPos2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos2dv_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glWindowPos2f(GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos2f(float x, float y){
        glWindowPos2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glWindowPos2f_native_GLfloat_GLfloat(long __this__nativeId, float x, float y);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glWindowPos2fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos2fv(java.nio.@Nullable FloatBuffer v){
        glWindowPos2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos2fv_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glWindowPos2i(GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos2i(int x, int y){
        glWindowPos2i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glWindowPos2i_native_GLint_GLint(long __this__nativeId, int x, int y);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glWindowPos2iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos2iv(java.nio.@Nullable IntBuffer v){
        glWindowPos2iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos2iv_native_const_GLint_ptr(long __this__nativeId, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glWindowPos2s(GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos2s(short x, short y){
        glWindowPos2s_native_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glWindowPos2s_native_GLshort_GLshort(long __this__nativeId, short x, short y);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glWindowPos2sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos2sv(java.nio.@Nullable ShortBuffer v){
        glWindowPos2sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos2sv_native_const_GLshort_ptr(long __this__nativeId, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glWindowPos3d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos3d(double x, double y, double z){
        glWindowPos3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glWindowPos3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glWindowPos3dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos3dv(java.nio.@Nullable DoubleBuffer v){
        glWindowPos3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos3dv_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glWindowPos3f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos3f(float x, float y, float z){
        glWindowPos3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glWindowPos3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glWindowPos3fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos3fv(java.nio.@Nullable FloatBuffer v){
        glWindowPos3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos3fv_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glWindowPos3i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos3i(int x, int y, int z){
        glWindowPos3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glWindowPos3i_native_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glWindowPos3iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos3iv(java.nio.@Nullable IntBuffer v){
        glWindowPos3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos3iv_native_const_GLint_ptr(long __this__nativeId, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glWindowPos3s(GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos3s(short x, short y, short z){
        glWindowPos3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glWindowPos3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z);
    
    /**
     * <p>See <code>QOpenGLFunctions_4_5_Compatibility::<wbr/>glWindowPos3sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos3sv(java.nio.@Nullable ShortBuffer v){
        glWindowPos3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos3sv_native_const_GLshort_ptr(long __this__nativeId, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QAbstractOpenGLFunctions::<wbr/>initializeOpenGLFunctions()</code></p>
     */
    @QtUninvokable
    @Override
    public boolean initializeOpenGLFunctions(){
        return initializeOpenGLFunctions_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean initializeOpenGLFunctions_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QOpenGLFunctions_4_5_Compatibility(QPrivateConstructor p) { super(p); } 
    
}
