package io.qt.opengl;

import io.qt.*;


/**
 * <p>Encapsulates an OpenGL framebuffer object</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html">QOpenGLFramebufferObject</a></code></p>
 */
public class QOpenGLFramebufferObject extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#Attachment-enum">QOpenGLFramebufferObject::Attachment</a></code></p>
     */
    public enum Attachment implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#Attachment-enum">QOpenGLFramebufferObject::<wbr/>NoAttachment</a></code></p>
         */
        NoAttachment(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#Attachment-enum">QOpenGLFramebufferObject::<wbr/>CombinedDepthStencil</a></code></p>
         */
        CombinedDepthStencil(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#Attachment-enum">QOpenGLFramebufferObject::<wbr/>Depth</a></code></p>
         */
        Depth(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Attachment(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Attachment resolve(int value) {
            switch (value) {
            case 0: return NoAttachment;
            case 1: return CombinedDepthStencil;
            case 2: return Depth;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#FramebufferRestorePolicy-enum">QOpenGLFramebufferObject::FramebufferRestorePolicy</a></code></p>
     */
    public enum FramebufferRestorePolicy implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#FramebufferRestorePolicy-enum">QOpenGLFramebufferObject::<wbr/>DontRestoreFramebufferBinding</a></code></p>
         */
        DontRestoreFramebufferBinding(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#FramebufferRestorePolicy-enum">QOpenGLFramebufferObject::<wbr/>RestoreFramebufferBindingToDefault</a></code></p>
         */
        RestoreFramebufferBindingToDefault(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#FramebufferRestorePolicy-enum">QOpenGLFramebufferObject::<wbr/>RestoreFrameBufferBinding</a></code></p>
         */
        RestoreFrameBufferBinding(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FramebufferRestorePolicy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull FramebufferRestorePolicy resolve(int value) {
            switch (value) {
            case 0: return DontRestoreFramebufferBinding;
            case 1: return RestoreFramebufferBindingToDefault;
            case 2: return RestoreFrameBufferBinding;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#QOpenGLFramebufferObject">QOpenGLFramebufferObject::<wbr/>QOpenGLFramebufferObject(QSize,<wbr/>GLenum)</a></code></p>
     */
    public QOpenGLFramebufferObject(io.qt.core.@NonNull QSize size, int target){
        super((QPrivateConstructor)null);
        initialize_native(this, size, target);
    }
    
    private native static void initialize_native(QOpenGLFramebufferObject instance, io.qt.core.QSize size, int target);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#QOpenGLFramebufferObject-2">QOpenGLFramebufferObject::<wbr/>QOpenGLFramebufferObject(QSize,<wbr/>QOpenGLFramebufferObject::Attachment,<wbr/>GLenum,<wbr/>GLenum)</a></code></p>
     */
    public QOpenGLFramebufferObject(io.qt.core.@NonNull QSize size, io.qt.opengl.QOpenGLFramebufferObject.@NonNull Attachment attachment, int target, int internalFormat){
        super((QPrivateConstructor)null);
        initialize_native(this, size, attachment, target, internalFormat);
    }
    
    private native static void initialize_native(QOpenGLFramebufferObject instance, io.qt.core.QSize size, io.qt.opengl.QOpenGLFramebufferObject.Attachment attachment, int target, int internalFormat);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#QOpenGLFramebufferObject-4">QOpenGLFramebufferObject::<wbr/>QOpenGLFramebufferObject(QSize,<wbr/>QOpenGLFramebufferObjectFormat)</a></code></p>
     */
    public QOpenGLFramebufferObject(io.qt.core.@NonNull QSize size, io.qt.opengl.@NonNull QOpenGLFramebufferObjectFormat format){
        super((QPrivateConstructor)null);
        initialize_native(this, size, format);
    }
    
    private native static void initialize_native(QOpenGLFramebufferObject instance, io.qt.core.QSize size, io.qt.opengl.QOpenGLFramebufferObjectFormat format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#QOpenGLFramebufferObject-1">QOpenGLFramebufferObject::<wbr/>QOpenGLFramebufferObject(int,<wbr/>int,<wbr/>GLenum)</a></code></p>
     */
    public QOpenGLFramebufferObject(int width, int height, int target){
        super((QPrivateConstructor)null);
        initialize_native(this, width, height, target);
    }
    
    private native static void initialize_native(QOpenGLFramebufferObject instance, int width, int height, int target);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#QOpenGLFramebufferObject-3">QOpenGLFramebufferObject::<wbr/>QOpenGLFramebufferObject(int,<wbr/>int,<wbr/>QOpenGLFramebufferObject::Attachment,<wbr/>GLenum,<wbr/>GLenum)</a></code></p>
     */
    public QOpenGLFramebufferObject(int width, int height, io.qt.opengl.QOpenGLFramebufferObject.@NonNull Attachment attachment, int target, int internalFormat){
        super((QPrivateConstructor)null);
        initialize_native(this, width, height, attachment, target, internalFormat);
    }
    
    private native static void initialize_native(QOpenGLFramebufferObject instance, int width, int height, io.qt.opengl.QOpenGLFramebufferObject.Attachment attachment, int target, int internalFormat);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#QOpenGLFramebufferObject-5">QOpenGLFramebufferObject::<wbr/>QOpenGLFramebufferObject(int,<wbr/>int,<wbr/>QOpenGLFramebufferObjectFormat)</a></code></p>
     */
    public QOpenGLFramebufferObject(int width, int height, io.qt.opengl.@NonNull QOpenGLFramebufferObjectFormat format){
        super((QPrivateConstructor)null);
        initialize_native(this, width, height, format);
    }
    
    private native static void initialize_native(QOpenGLFramebufferObject instance, int width, int height, io.qt.opengl.QOpenGLFramebufferObjectFormat format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#addColorAttachment">QOpenGLFramebufferObject::<wbr/>addColorAttachment(QSize,<wbr/>GLenum)</a></code></p>
     */
    @QtUninvokable
    public final void addColorAttachment(io.qt.core.@NonNull QSize size, int internalFormat){
        addColorAttachment_native_cref_QSize_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size), internalFormat);
    }
    
    @QtUninvokable
    private native void addColorAttachment_native_cref_QSize_GLenum(long __this__nativeId, long size, int internalFormat);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#addColorAttachment-1">QOpenGLFramebufferObject::<wbr/>addColorAttachment(int,<wbr/>int,<wbr/>GLenum)</a></code></p>
     */
    @QtUninvokable
    public final void addColorAttachment(int width, int height, int internalFormat){
        addColorAttachment_native_int_int_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), width, height, internalFormat);
    }
    
    @QtUninvokable
    private native void addColorAttachment_native_int_int_GLenum(long __this__nativeId, int width, int height, int internalFormat);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#attachment">QOpenGLFramebufferObject::<wbr/>attachment()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLFramebufferObject.@NonNull Attachment attachment(){
        return io.qt.opengl.QOpenGLFramebufferObject.Attachment.resolve(attachment_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int attachment_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#bind">QOpenGLFramebufferObject::<wbr/>bind()</a></code></p>
     */
    @QtUninvokable
    public final boolean bind(){
        return bind_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean bind_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#format">QOpenGLFramebufferObject::<wbr/>format()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.opengl.@NonNull QOpenGLFramebufferObjectFormat format(){
        return format_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.opengl.QOpenGLFramebufferObjectFormat format_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#handle">QOpenGLFramebufferObject::<wbr/>handle()const</a></code></p>
     */
    @QtUninvokable
    public final int handle(){
        return handle_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int handle_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#height">QOpenGLFramebufferObject::<wbr/>height()const</a></code></p>
     */
    @QtUninvokable
    public final int height(){
        return height_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int height_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#isBound">QOpenGLFramebufferObject::<wbr/>isBound()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isBound(){
        return isBound_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isBound_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#isValid">QOpenGLFramebufferObject::<wbr/>isValid()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#release">QOpenGLFramebufferObject::<wbr/>release()</a></code></p>
     */
    @QtUninvokable
    public final boolean release(){
        return release_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean release_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#setAttachment">QOpenGLFramebufferObject::<wbr/>setAttachment(QOpenGLFramebufferObject::Attachment)</a></code></p>
     */
    @QtUninvokable
    public final void setAttachment(io.qt.opengl.QOpenGLFramebufferObject.@NonNull Attachment attachment){
        setAttachment_native_QOpenGLFramebufferObject_Attachment(QtJambi_LibraryUtilities.internal.nativeId(this), attachment.value());
    }
    
    @QtUninvokable
    private native void setAttachment_native_QOpenGLFramebufferObject_Attachment(long __this__nativeId, int attachment);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#size">QOpenGLFramebufferObject::<wbr/>size()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QSize size(){
        return size_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSize size_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#sizes">QOpenGLFramebufferObject::<wbr/>sizes()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.core.@NonNull QSize> sizes(){
        return sizes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.core.QSize> sizes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#takeTexture">QOpenGLFramebufferObject::<wbr/>takeTexture()</a></code></p>
     */
    @QtUninvokable
    public final int takeTexture(){
        return takeTexture_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int takeTexture_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#takeTexture-1">QOpenGLFramebufferObject::<wbr/>takeTexture(int)</a></code></p>
     */
    @QtUninvokable
    public final int takeTexture(int colorAttachmentIndex){
        return takeTexture_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), colorAttachmentIndex);
    }
    
    @QtUninvokable
    private native int takeTexture_native_int(long __this__nativeId, int colorAttachmentIndex);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#texture">QOpenGLFramebufferObject::<wbr/>texture()const</a></code></p>
     */
    @QtUninvokable
    public final int texture(){
        return texture_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int texture_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#textures">QOpenGLFramebufferObject::<wbr/>textures()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Integer> textures(){
        return textures_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.@QtPrimitiveType Integer> textures_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#toImage">QOpenGLFramebufferObject::<wbr/>toImage(bool)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QImage toImage(boolean flipped){
        return toImage_native_bool_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), flipped);
    }
    
    @QtUninvokable
    private native io.qt.gui.QImage toImage_native_bool_constfct(long __this__nativeId, boolean flipped);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#toImage-1">QOpenGLFramebufferObject::<wbr/>toImage(bool,<wbr/>int)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QImage toImage(boolean flipped, int colorAttachmentIndex){
        return toImage_native_bool_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), flipped, colorAttachmentIndex);
    }
    
    @QtUninvokable
    private native io.qt.gui.QImage toImage_native_bool_int_constfct(long __this__nativeId, boolean flipped, int colorAttachmentIndex);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#width">QOpenGLFramebufferObject::<wbr/>width()const</a></code></p>
     */
    @QtUninvokable
    public final int width(){
        return width_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int width_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#bindDefault">QOpenGLFramebufferObject::<wbr/>bindDefault()</a></code></p>
     */
    public native static boolean bindDefault();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#blitFramebuffer-3">QOpenGLFramebufferObject::<wbr/>blitFramebuffer(QOpenGLFramebufferObject*,<wbr/>QOpenGLFramebufferObject*,<wbr/>GLbitfield,<wbr/>GLenum)</a></code></p>
     */
    public static void blitFramebuffer(io.qt.opengl.@Nullable QOpenGLFramebufferObject target, io.qt.opengl.@Nullable QOpenGLFramebufferObject source, int buffers, int filter){
        blitFramebuffer_native_QOpenGLFramebufferObject_ptr_QOpenGLFramebufferObject_ptr_GLbitfield_GLenum(QtJambi_LibraryUtilities.internal.checkedNativeId(target), QtJambi_LibraryUtilities.internal.checkedNativeId(source), buffers, filter);
    }
    
    private native static void blitFramebuffer_native_QOpenGLFramebufferObject_ptr_QOpenGLFramebufferObject_ptr_GLbitfield_GLenum(long target, long source, int buffers, int filter);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#blitFramebuffer-2">QOpenGLFramebufferObject::<wbr/>blitFramebuffer(QOpenGLFramebufferObject*,<wbr/>QRect,<wbr/>QOpenGLFramebufferObject*,<wbr/>QRect,<wbr/>GLbitfield,<wbr/>GLenum)</a></code></p>
     */
    public static void blitFramebuffer(io.qt.opengl.@Nullable QOpenGLFramebufferObject target, io.qt.core.@NonNull QRect targetRect, io.qt.opengl.@Nullable QOpenGLFramebufferObject source, io.qt.core.@NonNull QRect sourceRect, int buffers, int filter){
        blitFramebuffer_native_QOpenGLFramebufferObject_ptr_cref_QRect_QOpenGLFramebufferObject_ptr_cref_QRect_GLbitfield_GLenum(QtJambi_LibraryUtilities.internal.checkedNativeId(target), QtJambi_LibraryUtilities.internal.checkedNativeId(targetRect), QtJambi_LibraryUtilities.internal.checkedNativeId(source), QtJambi_LibraryUtilities.internal.checkedNativeId(sourceRect), buffers, filter);
    }
    
    private native static void blitFramebuffer_native_QOpenGLFramebufferObject_ptr_cref_QRect_QOpenGLFramebufferObject_ptr_cref_QRect_GLbitfield_GLenum(long target, long targetRect, long source, long sourceRect, int buffers, int filter);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#blitFramebuffer-1">QOpenGLFramebufferObject::<wbr/>blitFramebuffer(QOpenGLFramebufferObject*,<wbr/>QRect,<wbr/>QOpenGLFramebufferObject*,<wbr/>QRect,<wbr/>GLbitfield,<wbr/>GLenum,<wbr/>int,<wbr/>int)</a></code></p>
     */
    public static void blitFramebuffer(io.qt.opengl.@Nullable QOpenGLFramebufferObject target, io.qt.core.@NonNull QRect targetRect, io.qt.opengl.@Nullable QOpenGLFramebufferObject source, io.qt.core.@NonNull QRect sourceRect, int buffers, int filter, int readColorAttachmentIndex, int drawColorAttachmentIndex){
        blitFramebuffer_native_QOpenGLFramebufferObject_ptr_cref_QRect_QOpenGLFramebufferObject_ptr_cref_QRect_GLbitfield_GLenum_int_int(QtJambi_LibraryUtilities.internal.checkedNativeId(target), QtJambi_LibraryUtilities.internal.checkedNativeId(targetRect), QtJambi_LibraryUtilities.internal.checkedNativeId(source), QtJambi_LibraryUtilities.internal.checkedNativeId(sourceRect), buffers, filter, readColorAttachmentIndex, drawColorAttachmentIndex);
    }
    
    private native static void blitFramebuffer_native_QOpenGLFramebufferObject_ptr_cref_QRect_QOpenGLFramebufferObject_ptr_cref_QRect_GLbitfield_GLenum_int_int(long target, long targetRect, long source, long sourceRect, int buffers, int filter, int readColorAttachmentIndex, int drawColorAttachmentIndex);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#blitFramebuffer">QOpenGLFramebufferObject::<wbr/>blitFramebuffer(QOpenGLFramebufferObject*,<wbr/>QRect,<wbr/>QOpenGLFramebufferObject*,<wbr/>QRect,<wbr/>GLbitfield,<wbr/>GLenum,<wbr/>int,<wbr/>int,<wbr/>QOpenGLFramebufferObject::FramebufferRestorePolicy)</a></code></p>
     */
    public static void blitFramebuffer(io.qt.opengl.@Nullable QOpenGLFramebufferObject target, io.qt.core.@NonNull QRect targetRect, io.qt.opengl.@Nullable QOpenGLFramebufferObject source, io.qt.core.@NonNull QRect sourceRect, int buffers, int filter, int readColorAttachmentIndex, int drawColorAttachmentIndex, io.qt.opengl.QOpenGLFramebufferObject.@NonNull FramebufferRestorePolicy restorePolicy){
        blitFramebuffer_native_QOpenGLFramebufferObject_ptr_cref_QRect_QOpenGLFramebufferObject_ptr_cref_QRect_GLbitfield_GLenum_int_int_QOpenGLFramebufferObject_FramebufferRestorePolicy(QtJambi_LibraryUtilities.internal.checkedNativeId(target), QtJambi_LibraryUtilities.internal.checkedNativeId(targetRect), QtJambi_LibraryUtilities.internal.checkedNativeId(source), QtJambi_LibraryUtilities.internal.checkedNativeId(sourceRect), buffers, filter, readColorAttachmentIndex, drawColorAttachmentIndex, restorePolicy.value());
    }
    
    private native static void blitFramebuffer_native_QOpenGLFramebufferObject_ptr_cref_QRect_QOpenGLFramebufferObject_ptr_cref_QRect_GLbitfield_GLenum_int_int_QOpenGLFramebufferObject_FramebufferRestorePolicy(long target, long targetRect, long source, long sourceRect, int buffers, int filter, int readColorAttachmentIndex, int drawColorAttachmentIndex, int restorePolicy);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#hasOpenGLFramebufferBlit">QOpenGLFramebufferObject::<wbr/>hasOpenGLFramebufferBlit()</a></code></p>
     */
    public native static boolean hasOpenGLFramebufferBlit();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobject.html#hasOpenGLFramebufferObjects">QOpenGLFramebufferObject::<wbr/>hasOpenGLFramebufferObjects()</a></code></p>
     */
    public native static boolean hasOpenGLFramebufferObjects();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QOpenGLFramebufferObject(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLFramebufferObject(io.qt.core.QSize, int)}
     *  with <code>target = 0x0DE1</code>.</p>
     */
    public QOpenGLFramebufferObject(io.qt.core.@NonNull QSize size) {
        this(size, (int)0x0DE1);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLFramebufferObject(io.qt.core.QSize, io.qt.opengl.QOpenGLFramebufferObject.Attachment, int, int)}
     *  with <code>internalFormat = 0</code>.</p>
     */
    public QOpenGLFramebufferObject(io.qt.core.@NonNull QSize size, io.qt.opengl.QOpenGLFramebufferObject.@NonNull Attachment attachment, int target) {
        this(size, attachment, target, (int)0);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLFramebufferObject(io.qt.core.QSize, io.qt.opengl.QOpenGLFramebufferObject.Attachment, int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>target = 0x0DE1</code></li>
     * <li><code>internalFormat = 0</code></li>
     * </ul>
     */
    public QOpenGLFramebufferObject(io.qt.core.@NonNull QSize size, io.qt.opengl.QOpenGLFramebufferObject.@NonNull Attachment attachment) {
        this(size, attachment, (int)0x0DE1, (int)0);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLFramebufferObject(int, int, int)}
     *  with <code>target = 0x0DE1</code>.</p>
     */
    public QOpenGLFramebufferObject(int width, int height) {
        this(width, height, (int)0x0DE1);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLFramebufferObject(int, int, io.qt.opengl.QOpenGLFramebufferObject.Attachment, int, int)}
     *  with <code>internalFormat = 0</code>.</p>
     */
    public QOpenGLFramebufferObject(int width, int height, io.qt.opengl.QOpenGLFramebufferObject.@NonNull Attachment attachment, int target) {
        this(width, height, attachment, target, (int)0);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLFramebufferObject(int, int, io.qt.opengl.QOpenGLFramebufferObject.Attachment, int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>target = 0x0DE1</code></li>
     * <li><code>internalFormat = 0</code></li>
     * </ul>
     */
    public QOpenGLFramebufferObject(int width, int height, io.qt.opengl.QOpenGLFramebufferObject.@NonNull Attachment attachment) {
        this(width, height, attachment, (int)0x0DE1, (int)0);
    }
    
    /**
     * <p>Overloaded function for {@link #addColorAttachment(io.qt.core.QSize, int)}
     *  with <code>internalFormat = 0</code>.</p>
     */
    @QtUninvokable
    public final void addColorAttachment(io.qt.core.@NonNull QSize size) {
        addColorAttachment(size, (int)0);
    }
    
    /**
     * <p>Overloaded function for {@link #addColorAttachment(int, int, int)}
     *  with <code>internalFormat = 0</code>.</p>
     */
    @QtUninvokable
    public final void addColorAttachment(int width, int height) {
        addColorAttachment(width, height, (int)0);
    }
    
    /**
     * <p>Overloaded function for {@link #toImage(boolean)}
     *  with <code>flipped = true</code>.</p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QImage toImage() {
        return toImage((boolean)true);
    }
    
    /**
     * <p>Overloaded function for {@link #blitFramebuffer(io.qt.opengl.QOpenGLFramebufferObject, io.qt.opengl.QOpenGLFramebufferObject, int, int)}
     *  with <code>filter = 0x2600</code>.</p>
     */
    public static void blitFramebuffer(io.qt.opengl.@Nullable QOpenGLFramebufferObject target, io.qt.opengl.@Nullable QOpenGLFramebufferObject source, int buffers) {
        blitFramebuffer(target, source, buffers, (int)0x2600);
    }
    
    /**
     * <p>Overloaded function for {@link #blitFramebuffer(io.qt.opengl.QOpenGLFramebufferObject, io.qt.opengl.QOpenGLFramebufferObject, int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>buffers = 0x00004000</code></li>
     * <li><code>filter = 0x2600</code></li>
     * </ul>
     */
    public static void blitFramebuffer(io.qt.opengl.@Nullable QOpenGLFramebufferObject target, io.qt.opengl.@Nullable QOpenGLFramebufferObject source) {
        blitFramebuffer(target, source, (int)0x00004000, (int)0x2600);
    }
    
    /**
     * <p>Overloaded function for {@link #blitFramebuffer(io.qt.opengl.QOpenGLFramebufferObject, io.qt.core.QRect, io.qt.opengl.QOpenGLFramebufferObject, io.qt.core.QRect, int, int)}
     *  with <code>filter = 0x2600</code>.</p>
     */
    public static void blitFramebuffer(io.qt.opengl.@Nullable QOpenGLFramebufferObject target, io.qt.core.@NonNull QRect targetRect, io.qt.opengl.@Nullable QOpenGLFramebufferObject source, io.qt.core.@NonNull QRect sourceRect, int buffers) {
        blitFramebuffer(target, targetRect, source, sourceRect, buffers, (int)0x2600);
    }
    
    /**
     * <p>Overloaded function for {@link #blitFramebuffer(io.qt.opengl.QOpenGLFramebufferObject, io.qt.core.QRect, io.qt.opengl.QOpenGLFramebufferObject, io.qt.core.QRect, int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>buffers = 0x00004000</code></li>
     * <li><code>filter = 0x2600</code></li>
     * </ul>
     */
    public static void blitFramebuffer(io.qt.opengl.@Nullable QOpenGLFramebufferObject target, io.qt.core.@NonNull QRect targetRect, io.qt.opengl.@Nullable QOpenGLFramebufferObject source, io.qt.core.@NonNull QRect sourceRect) {
        blitFramebuffer(target, targetRect, source, sourceRect, (int)0x00004000, (int)0x2600);
    }
}
